/**
 * includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Rtk_CDCa.h"
#include "cdca_common.h"
#include "rtk_porting_util.h"
#include "cdca_interface.h"
#include "auto_version.h"
#include "cdca_sys.h"
#include "cdca_rDebug.h"
#include "cdca_dmx.h"
#include "cdca_sc.h"
#include "rtk_porting_tuner.h"


pthread_mutex_t Rtk_CDCA::mutex= PTHREAD_MUTEX_INITIALIZER;
//Rtk_CDCA* Rtk_CDCA::m_pSingleton = NULL;
static Rtk_CDCA m_pSingleton;

st_cdca_tsid_info Rtk_CDCA::m_tsidBase[MAX_CHANNEL_NUM] = 
    {\
    {0x202,false}, {0x302,false},\
    {0x402,false},{0x502,false},\
    {0x602,false},{0x702,false},\
    {0x802,false},{0x902,false} \
    };

Rtk_CDCA::Rtk_CDCA() :
          m_emmPid(0xFFFF),
          m_initialized(false),
          m_bSeparateSetEmm(true)
         
{
        memset(m_pChannelInfo, 0x00, sizeof(st_cdca_channel_info) * MAX_CHANNEL_NUM);

}

Rtk_CDCA::~Rtk_CDCA()
{
	if (m_initialized)
		UnInit();

}
int Rtk_CDCA::Init() 
{
    CDCA_Trace("Init, has been inited: %s\n", m_initialized?"true":"false");
    pthread_mutex_lock(&mutex);
    CDCA_BOOL cdcaSysReady = false;	
    CDCA_BOOL smartCardReady = false;
    CDCA_BOOL caLibReady = false;

    CDCA_U8 ca_threadPriority = 5;
    if (false == m_initialized)
    {
        m_initialized = true;

        cdcaSysReady = CDCA_Sys_Init();
        CDCA_Debug(" caMgrStatus, status = %s\n", cdcaSysReady?"true":"false");
        if(cdcaSysReady == CDCA_FALSE) 
        {
            goto error;
        }

        caLibReady = CDCASTB_Init(ca_threadPriority);
        CDCA_Debug(" CDCASTB_Init, status = %s\n", caLibReady?"true":"false");
        if(caLibReady == CDCA_FALSE)
        {
            goto error;
        }

#ifdef ENABLE_SC
        smartCardReady  = CDCA_Sc_Init();
        CDCA_Debug(" CDCA_Sc_Init, status = %s\n", smartCardReady?"true":"false");
        if(smartCardReady == CDCA_FALSE)
        {
            goto error;
        }

        if(CDCA_SC_INSERT == CDCA_SC_GetCardStatus())
            CDCASTB_SCInsert();
        else
            CDCASTB_SCRemove();
#endif
    }
    pthread_mutex_unlock(&mutex);
    return RTKCA_OK;

error:
    if (smartCardReady)
        CDCA_Sc_Uninit();

    if (cdcaSysReady)
        CDCA_Sys_Uninit();

    if(caLibReady)
        CDCASTB_Close();

    m_initialized = false;

    pthread_mutex_unlock(&mutex);
    return RTKCA_ERROR;
}

void Rtk_CDCA::uninit()
{
    CDCASTB_SetEcmPid(CDCA_LIST_FIRST, NULL);
    CDCASTB_SetEcmPid(CDCA_LIST_OK, NULL);

    CDCA_Dmx_SetCommonSource(NULL);
    CDCASTB_Close();
    CDCA_Sc_Uninit();
    CDCA_Sys_Uninit();
    m_emmPid = 0xFFFF;
    m_initialized = false;
    m_bSeparateSetEmm = true;
}
/**
 * @brief CAS uninit
 */
int Rtk_CDCA::UnInit() 
{
    CDCA_Trace("UnInit, m_initialized = %s, m_bSeparateSetEmm = %s \n", m_initialized?"true":"false", m_bSeparateSetEmm?"true":"false");
    pthread_mutex_lock(&mutex);

    if(m_initialized)
    {
        if(false == m_bSeparateSetEmm ) //rtk demo case
        {
             if( descramblingChCount() == 0 )
                    uninit();
        }
        else
        {
            uninit();
        }
    }
    pthread_mutex_unlock(&mutex);
    return RTKCA_OK;
}

int Rtk_CDCA::DescramblerInit(int descramble_id)
{
    (void)(descramble_id);
    CDCA_Trace("");
    pthread_mutex_lock(&mutex);

    if(false == m_initialized)
    {
        pthread_mutex_unlock(&mutex);
        return RTKCA_ERROR;
    }
    pthread_mutex_unlock(&mutex);
    return RTKCA_OK;
}

int Rtk_CDCA::DescramblerUninit(int descramble_id) 
{
    (void)(descramble_id);
    CDCA_Trace("descramble_id = %d\n", descramble_id);
    pthread_mutex_lock(&mutex);
    if(false == m_initialized)
    {
        pthread_mutex_unlock(&mutex);
        return RTKCA_ERROR;
    }
    
    pthread_mutex_unlock(&mutex);
    return RTKCA_OK;
}

void Rtk_CDCA::setEmmPid(uint16_t pid, int source_handle)
{
#if 0
        int pre_SrcHdl;
        CDCA_Dmx_GetCommonSource(&pre_SrcHdl);
        CDCA_Trace("pre_srcHdl = 0x%x, source_handle = 0x%x, m_emmpid = 0x%x, pid = 0x%x", pre_SrcHdl, source_handle, m_emmPid, pid);
        if(pre_SrcHdl == source_handle && m_emmPid == pid)
        {
            pthread_mutex_unlock(&mutex);
            return RTKCA_ERROR;
        }
#endif

#if defined(ENABLE_VENDOR_LIB) || !defined(ENABLE_SC)
        if (m_initialized && pid < 0x1FFF) {
            CDCA_Debug("setEmmPid... pid = 0x%x \n", pid);
            if(pid != 0)
            {
                CDCA_Dmx_SetCommonSource(source_handle);
            }
	   CDCASTB_SetEmmPid(pid);
    }
#endif

}

int Rtk_CDCA::SetEmmPid(uint16_t caSystemId, uint16_t pid, int source_handle)
{
    (void)(caSystemId);
     setEmmPid(pid, source_handle);
    return RTKCA_OK;
}

/**
 * @brief CAS start descramble
 */
int Rtk_CDCA::StartDescramble(int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info)
{

     pthread_mutex_lock(&mutex);
    CDCA_Debug("StartDescramble... descramble_id = %d, source_handle = 0x%x\n", descramble_id, ecm_info.source_handle);
    if(false == m_initialized)
    {
        CDCA_Err("Rtk_Cdca:: init failed, Plz Check!!!");
        pthread_mutex_unlock(&mutex);
        return RTKCA_ERROR;
    }
        
    int ecmCount = 0;
    uint32_t tsidBase = 0;
    CDCA_Debug("Descramble_id: %d \n", descramble_id);

    Source_Handle source_handle = (Source_Handle)ecm_info.source_handle;

    //parse ecm_info
    st_cdca_ecmStream_info pEcmStreamInfo[16];
    memset(pEcmStreamInfo, 0x00, sizeof(st_cdca_ecmStream_info) * 16);
    parseEcmStreamInfo(ecm_info, &tsidBase, pEcmStreamInfo, &ecmCount);

    CDCA_Debug("Ecm count = %d, tsidBase:0x%x\n", ecmCount, tsidBase);
    if(ecmCount == 1)
    {
        RTK_Source_SetTsidSidx(source_handle, pEcmStreamInfo[0].tsid);
    }
    else
    {
        for(int k = 0; k < ecmCount; k++)
        {
            RTK_Source_SetTsidSid_Ex(source_handle, pEcmStreamInfo[k].tsid, pEcmStreamInfo[k].pidNum, pEcmStreamInfo[k].stream_pid);   
        }
    }

#if defined(ENABLE_VENDOR_LIB) || !defined(ENABLE_SC)
    //rtk demo only
    if(descramblingChCount() == 0 && ecm_info.emm_pid <0x1FFF)
    {
        CDCA_Debug("m_bSeparateSetEmm = false  case\n");
        setEmmPid(ecm_info.emm_pid, (int)source_handle);
        m_emmPid =  ecm_info.emm_pid;
        m_bSeparateSetEmm = false;
    }
#endif

    int ret =  mapEcmInfo2ChannelInfo(tsidBase, descramble_id, ecm_info, ecmCount,  pEcmStreamInfo);
    if(RTKCA_OK != ret)
    {
        goto error;
    }
  
     refreshChEcmPids();
     pthread_mutex_unlock(&mutex);

    return RTKCA_OK;

    error:
        CDCA_Err("Error, plz check\n");
         pthread_mutex_unlock(&mutex);
         return RTKCA_ERROR;
}

/**
 * @brief CAS stop descramble
 */
int Rtk_CDCA::StopDescramble(int descramble_id) 
{
    int channelIdx = -1;
    
    pthread_mutex_lock(&mutex);
    if(false == m_initialized)
    {
        CDCA_Err("Not initialized ...\n");
        pthread_mutex_unlock(&mutex);

        return RTKCA_ERROR;
    }

    CDCA_Trace("StopDescramble, descramble_id = %d, m_bSeparateSetEmm = %s...\n", descramble_id, m_bSeparateSetEmm?"true":"false");

    for(int i = 0; i < MAX_CHANNEL_NUM; i++)
    {
        if(descramble_id == m_pChannelInfo[i].descramble_id && 0 != m_pChannelInfo[i].source_handle && 0 != m_pChannelInfo[i].ecm_num)
        {
            channelIdx = i;
            break;
        }
    }
    
    if(-1 == channelIdx)
    {
        CDCA_Err("Wrong descramble_id, plz check!!!\n");
        pthread_mutex_unlock(&mutex);
        return RTKCA_ERROR;
    }

    CDCA_Trace("channel %d 's idx = %d, ecm_num = %d \n", descramble_id, channelIdx, m_pChannelInfo[channelIdx].ecm_num);
    int ecm_num = m_pChannelInfo[channelIdx].ecm_num;
    CDCA_U16 ecmPid;

    //rtk demo only
    bool bEmmReset = false;
     int emmSourceHdl = 0;
    CDCA_Dmx_GetCommonSource(&emmSourceHdl);
    if(false == m_bSeparateSetEmm && m_pChannelInfo[channelIdx].source_handle == emmSourceHdl)
    {
        setEmmPid(0, emmSourceHdl);
        bEmmReset = true;
    }

    for(int i = 0; i < ecm_num; i++)
    {
        ecmPid = m_pChannelInfo[channelIdx].pServiceInfo[i]->m_wEcmPid;
         //release ecm section filter by tsid
        CDCA_Dmx_RemoveSectionFiler(ecmPid);
        
        //remove ExmMap
        cdca_sys_MapExmRemoveByTsid(ecmPid);

        CDCA_Trace("to free keyslot, ecmpid = 0x%x\n", ecmPid);
        cdca_sys_FreeKeySlotByTsid(ecmPid);  
    }
	
    //remove channel info from  m_pChannelInfo by descramble_id
    if(ecm_num >0)
    	ecmPid = m_pChannelInfo[channelIdx].pServiceInfo[0]->m_wEcmPid;
    freeChannelInfo(channelIdx);
	if((descramblingChCount() == 0) && (ecm_num > 0)){ //stop descramble 
		CDCA_Trace("stop TP descramble descramblingChCount=0 \n");
		cdca_sys_stopTpDescrambe(ecmPid, RTK_NO_DESCRAMBLE);
	}

    //rtk demo only	
    if(false == m_bSeparateSetEmm && descramblingChCount() > 0 && bEmmReset)
    {
        int availIdx = getAvailChannelInfoIdx();
        if(-1 != availIdx)
        {
            setEmmPid(m_emmPid, m_pChannelInfo[availIdx].source_handle);
        }
    }
	
     refreshChEcmPids();

    CDCA_Trace("end...\n");

     pthread_mutex_unlock(&mutex);

    return RTKCA_OK;
        
}

/**
 * @brief Register event callback.
 */
int Rtk_CDCA::RegsiterEventCallback(int descramble_id, RTK_CaIntfCallback_t pfunc) 
{
	(void)(descramble_id);
	(void)(pfunc);
	
	return RTKCA_OK;
}

/**
 * @brief UnRegister event callback.
 */
int Rtk_CDCA::UnRegsiterEventCallback(int descramble_id)
{
	(void)(descramble_id);
	return RTKCA_OK;
}

uint16_t Rtk_CDCA::GetCaSystemID(void)
{
	CDCA_Trace("\n");
#ifdef ENABLE_SC
	return 0x4A02;
#else
	return 0x4A03;
#endif
}

int Rtk_CDCA::DVRCipherInit(int id)
{
	(void)(id);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherUnInit(int id)
{
	(void)(id);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherConfig(int id, RTKCA_DvrCipher_config_t cfg)
{
	(void)(id);
	(void)(cfg);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherGetDataAglin(int id, uint32_t *alignBytes)
{
	(void)(id);
	(void)(alignBytes);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherContinuityReset(int id, int64_t conti_ofs)
{
	(void)(id);
	(void)(conti_ofs);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherEnc(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)
{
	(void)(id);
	(void)(inbuf);
	(void)(outbuf);
	(void)(size);
	return RTKCA_NOT_SUPPORT;
}
int Rtk_CDCA::DVRCipherDec(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)
{
	(void)(id);
	(void)(inbuf);
	(void)(outbuf);
	(void)(size);
	return RTKCA_NOT_SUPPORT;
}

Rtk_CDCA* Rtk_CDCA::getInstance()
{
    /*
        pthread_mutex_lock(&mutex);

        if(NULL == m_pSingleton )
        {
            m_pSingleton = new Rtk_CDCA();
        }

        pthread_mutex_unlock(&mutex);
        return m_pSingleton;
        */

       return &m_pSingleton;
}

uint32_t Rtk_CDCA::genTsidBase()
{   
    uint32_t tsid = 0;
    for(int i = 0; i < MAX_CHANNEL_NUM; i++)
    {
        if(false == m_tsidBase[i].bUsing)
        {
            tsid = m_tsidBase[i].tsidBase;
            m_tsidBase[i].bUsing = true;
            break;
        }
    }

    return tsid;
}

int Rtk_CDCA::mapEcmInfo2ChannelInfo(uint32_t tsidBase, int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info, int ecmCount,  st_cdca_ecmStream_info* pEcmStreamInfo)
{
    CDCA_Debug("descramble_id = %d, tsidBase = 0x%x, ecmCount =%d \n", descramble_id, tsidBase, ecmCount);
    int channelIdx = -1;
    for(int i = 0; i < MAXMULTI_CHANNEL_NUM; i++)
    {
        if(0 == m_pChannelInfo[i].descramble_id && 0 == m_pChannelInfo[i].source_handle && 0 == m_pChannelInfo[i].ecm_num)
        {
            channelIdx = i;
            break;
        }
    }
    if(-1 == channelIdx)
    {
        CDCA_Err("Not find valid ChannelIndex, Plz Check!!!!");
        return RTKCA_ERROR;
    }
    m_pChannelInfo[channelIdx].descramble_id = descramble_id;
    m_pChannelInfo[channelIdx].tsidBase = tsidBase;
    m_pChannelInfo[channelIdx].source_handle = ecm_info.source_handle;
    m_pChannelInfo[channelIdx].ecm_num = ecmCount;

    for(int i = 0; i < ecmCount; i++)
    {
            m_pChannelInfo[channelIdx].pServiceInfo[i] = (SCDCASServiceInfo *)malloc(sizeof(SCDCASServiceInfo));
            if(NULL == m_pChannelInfo[channelIdx].pServiceInfo[i])
            {
                    CDCA_Err("malloc pServiceInfo,error!\n");
                    return RTKCA_ERROR;
            }
            memset(m_pChannelInfo[channelIdx].pServiceInfo[i], 0x00, sizeof(SCDCASServiceInfo));
            m_pChannelInfo[channelIdx].pServiceInfo[i]->m_wEcmPid = 0xFFFF;

    
         m_pChannelInfo[channelIdx].pServiceInfo[i]->m_wEcmPid = pEcmStreamInfo[i].tsid;
         CDCA_Info("Add EcmPid to ca lib, EcmPid = 0x%x, ecm_info.program_id = 0x%x \n", m_pChannelInfo[channelIdx].pServiceInfo[i]->m_wEcmPid, ecm_info.program_id);
        /*put program_number in m_wServiceID*/
        ///for(int k=0; k < CDCA_MAXNUM_PROGRAMBYCW; k++)
        m_pChannelInfo[channelIdx].pServiceInfo[i]->m_wServiceID[0]= ecm_info.program_id;  

        m_pChannelInfo[channelIdx].pServiceInfo[i]->m_byServiceNum = pEcmStreamInfo[i].pidNum; 
        m_pChannelInfo[channelIdx].pServiceInfo[i]->m_byReserved  = 1;
    }

    return RTKCA_OK;
}

void Rtk_CDCA::parseEcmStreamInfo(RTKCA_Descramble_ECM_info_t &ecm_info, uint32_t* tsidBase, st_cdca_ecmStream_info* pEcmStreamInfo, int* ecmCount)
{
    uint32_t tsid = 0;
    int ecmNum = 0;
    for(int i = 0; i < RTKCA_MAX_STREAM_PID_NUM; i++)
    {
        if(ecm_info.ecm_AVPids[i].ecm_pid == 0x00)
            continue;

        int availableIdx = -1;
        bool isNewEcm = false;
        
        for(int j = 0; j < 16; j++)
        {
            if(pEcmStreamInfo[j].ecm_pid == ecm_info.ecm_AVPids[i].ecm_pid)
            {
                availableIdx = j;
                break;
            }
            if(pEcmStreamInfo[j].ecm_pid == 0x00)
            {
                availableIdx = j;
                isNewEcm = true;
                break;
            }
        }//ecm_num end

        if(-1 == availableIdx)
        {
            CDCA_Err("Error, plz check !!!!\n");
            continue;
        }
        CDCA_Debug("isNewEcm = %s\n", isNewEcm == false?"false":"true");
       if(isNewEcm == true)        
       {
            if(0 == tsid)
            {
                tsid = genTsidBase();
                *tsidBase = tsid;
            }
            do{
                tsid++;                
                cdca_sys_MapExmCreate(tsid,ecm_info.ecm_AVPids[i].ecm_pid, ecm_info.source_handle);                pEcmStreamInfo[availableIdx].tsid = tsid;                   
            }while(tsid == ecm_info.emm_pid);	  
            pEcmStreamInfo[availableIdx].tsid = tsid;          
            ecmNum++;        
        }  
        /*
        if(isNewEcm == true)
        {
            cdca_sys_MapExmCreate(tsid,ecm_info.ecm_AVPids[i].ecm_pid, ecm_info.source_handle);
            pEcmStreamInfo[availableIdx].tsid = tsid;          
            tsid++;
            ecmNum++;
        }
        */
        //CDCA_Debug("m_ecmNum = %d\n", ecmNum);
        //CDCA_Debug("[%d].ecm_pid = 0x%x,stream_pid = 0x%x\n", i, ecm_info.ecm_AVPids[i].ecm_pid, ecm_info.ecm_AVPids[i].stream_pid);
        uint8_t pid_num = pEcmStreamInfo[availableIdx].pidNum;
        pEcmStreamInfo[availableIdx].ecm_pid = ecm_info.ecm_AVPids[i].ecm_pid;

        pEcmStreamInfo[availableIdx].stream_pid[pid_num] =  ecm_info.ecm_AVPids[i].stream_pid;
        pEcmStreamInfo[availableIdx].pidNum++;
        
    }//parse ecm_info end

    *ecmCount = ecmNum;
}

void Rtk_CDCA::resetTsidBase(uint32_t tsidBase)
{
    for(int i =0; i<MAX_CHANNEL_NUM; i++)
    {
        if(tsidBase == m_tsidBase[i].tsidBase)
        {
            m_tsidBase[i].bUsing = false;
            break;
        }
    }
}

void Rtk_CDCA::freeChannelInfo(int index)
{  
    CDCA_Debug("reset tsidBase: 0x%x\n", m_pChannelInfo[index].tsidBase);
    resetTsidBase( m_pChannelInfo[index].tsidBase);
    
    m_pChannelInfo[index].descramble_id = 0;
    m_pChannelInfo[index].ecm_num = 0;
    m_pChannelInfo[index].source_handle = 0;
    m_pChannelInfo[index].tsidBase = 0;

    for(int i = 0; i < MAX_ECM_NUM; i++)
    {
        if(NULL != m_pChannelInfo[index].pServiceInfo[i])
        {
            free(m_pChannelInfo[index].pServiceInfo[i]);
            m_pChannelInfo[index].pServiceInfo[i] = NULL;
        }
    } 
}

int Rtk_CDCA::descramblingChCount()
{
    int count = 0;
    for(int i = 0; i < MAXMULTI_CHANNEL_NUM; i++)
    {
          if(0 == m_pChannelInfo[i].descramble_id && 0 == m_pChannelInfo[i].source_handle && 0 == m_pChannelInfo[i].ecm_num)
          {
                continue;
          }
          count++;
    }

    return count;
}

int Rtk_CDCA::getAvailChannelInfoIdx()
{
    int idx = -1;
    for(int i = 0; i < MAXMULTI_CHANNEL_NUM; i++)
    {
          if(0 != m_pChannelInfo[i].descramble_id && 0 != m_pChannelInfo[i].source_handle && 0 != m_pChannelInfo[i].ecm_num)
          {
                idx =i;
                break;
          }
    }

    return idx;
}

void Rtk_CDCA::refreshChEcmPids()
{
    CDCASTB_SetEcmPid(CDCA_LIST_FIRST, NULL);

    //traverse m_pChannelInfo Array to set all of valid pServiceInfo into calib
    for(int i = 0; i < MAXMULTI_CHANNEL_NUM; i++)
    {
          if(0 == m_pChannelInfo[i].descramble_id && 0 == m_pChannelInfo[i].source_handle && 0 == m_pChannelInfo[i].ecm_num)
          {
                continue;
          }
          CDCA_Debug("Channel %d valid, desrabmle_id = %d, ecm_num = %d, set pServiceInfo to calib\n", i,  m_pChannelInfo[i].descramble_id, m_pChannelInfo[i].ecm_num);
          for(int j = 0; j < m_pChannelInfo[i].ecm_num; j++)
          {
                   CDCASTB_SetEcmPid(CDCA_LIST_ADD, m_pChannelInfo[i].pServiceInfo[j]);
          }
    }
    
    CDCASTB_SetEcmPid(CDCA_LIST_OK, NULL);
}

// ===================================================================================================
// static callback

void Rtk_CDCA::CDSTBCA_ActionRequestExt(CDCA_U16 wTVSID, CDCA_U8 byActionType, CDCA_U8 byLen, CDCA_U8* pbyData)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->actionRequestExt(wTVSID, byActionType, byLen, pbyData);
}

void Rtk_CDCA::CDSTBCA_ContinuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->continuesWatchLimit(byType, wWorkTime, wStopTime);
}

void Rtk_CDCA::CDSTBCA_DetitleReceived(CDCA_U8 bstatus)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->detitleReceived(bstatus);
}

void Rtk_CDCA::CDSTBCA_EmailNotifyIcon(CDCA_U8 byShow, CDCA_U32 dwEmailID)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->emailNotifyIcon(byShow, dwEmailID);
}

void Rtk_CDCA::CDSTBCA_EntitleChanged(CDCA_U16 wTvsID)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->entitleChanged (wTvsID);
}

void Rtk_CDCA::CDSTBCA_HideOSDMessage(CDCA_U8 byStyle)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->hideOSDMessage (byStyle);
}

void Rtk_CDCA::CDSTBCA_HideIPPVDlg(CDCA_U16 wEcmPid)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->hideIPPVDlg(wEcmPid);
}

void Rtk_CDCA::CDSTBCA_RequestFeeding(CDCA_BOOL bReadStatus)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->requestFeeding(bReadStatus);
}

void Rtk_CDCA::CDSTBCA_ShowBuyMessage (CDCA_U16 wEcmPID, CDCA_U8  byMessageType)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showBuyMessage (wEcmPID, byMessageType);
}

void Rtk_CDCA::CDSTBCA_ShowCurtainNotify(CDCA_U16 wEcmPID, CDCA_U16 wCurtainCode)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showCurtainNotify(wEcmPID, wCurtainCode);
}

void Rtk_CDCA::CDSTBCA_ShowFingerMessageExt(CDCA_U16 wEcmPID, char* fingerMsg)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showFingerMessageExt(wEcmPID, fingerMsg);
}

#ifdef ENABLE_VENDOR_LIB
void Rtk_CDCA::CDSTBCA_ShowFingerInfo(CDCA_U16 wEcmPID, const SCDCAFingerInfo* pFingerInfo)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showFingerInfo(wEcmPID, pFingerInfo);
}

void Rtk_CDCA::CDSTBCA_LockService(const SCDCALockService * pLockService)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->lockService(pLockService);
}

void Rtk_CDCA::CDSTBCA_ShowOSDInfo(SCDCAOSDInfo *pOSDInfo)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showOSDInfo(pOSDInfo);
}

void Rtk_CDCA::CDSTBCA_StartIppvBuyDlg(CDCA_U8 byMessageType, CDCA_U16 wEcmPid, const SCDCAIppvBuyInfo * pIppvProgram)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->startIppvBuyDlg(byMessageType, wEcmPid, pIppvProgram);
}
#endif
void Rtk_CDCA::CDSTBCA_ShowOSDMessage(CDCA_U8 byStyle, const char* szMessage)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showOSDMessage (byStyle, szMessage);
}

void Rtk_CDCA::CDSTBCA_ShowProgressStrip(CDCA_U8 byProgress, CDCA_U8 byMark)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->showProgressStrip(byProgress, byMark);
}

void Rtk_CDCA::CDSTBCA_UNLockService(void)
{
    Rtk_CDCA * pInstance = Rtk_CDCA::getInstance();
    if (NULL != pInstance)
        pInstance->unlockService();
}

//---------------------------------------------------------------------------------------------------
// registration

void Rtk_CDCA::registerOnActionRequestExtCallback (std::function<void(CDCA_U16, CDCA_U8, CDCA_U8, CDCA_U8 *)> callbackFn)
{
    m_onActionRequestExtFn = callbackFn;
}

void Rtk_CDCA::registerOnContinuesWatchLimitCallback (std::function<void(CDCA_U8, CDCA_U16, CDCA_U16)> callbackFn)
{
    m_onContinuesWatchLimitFn = callbackFn;
}

void Rtk_CDCA::registerOnDetitleReceivedCallback (std::function<void(CDCA_U8)> callbackFn)
{
    m_onDetitleReceivedFn = callbackFn;
}

void Rtk_CDCA::registerOnEmailNotifyIconCallback (std::function<void(CDCA_U8, CDCA_U32)> callbackFn)
{
    m_onEmailNotifyIconFn = callbackFn;
}

void Rtk_CDCA::registerOnEntitleChangedCallback (std::function<void(CDCA_U16)> callbackFn)
{
    m_onEntitleChangedFn = callbackFn;
}

void Rtk_CDCA::registerOnHideOSDMessageCallback (std::function<void(CDCA_U8)> callbackFn)
{
    m_onHideOSDMessageFn = callbackFn;
}

void Rtk_CDCA::registerOnHideIPPVDlgCallback (std::function<void(CDCA_U16)> callbackFn)
{
    m_onHideIPPVDlgFn = callbackFn;
}

void Rtk_CDCA::registerOnRequestFeedingCallback (std::function<void(CDCA_BOOL)> callbackFn)
{
    m_onRequestFeedingFn = callbackFn;
}

void Rtk_CDCA::registerOnShowBuyMessageCallback (std::function<void(CDCA_U16, CDCA_U8)> callbackFn)
{
    m_onShowBuyMessageFn = callbackFn;
}

void Rtk_CDCA::registerOnShowCurtainNotifyCallback (std::function<void(CDCA_U16, CDCA_U16)> callbackFn)
{
    m_onShowCurtainNotifyFn = callbackFn;
}

void Rtk_CDCA::registerOnShowFingerMessageExtCallback (std::function<void(CDCA_U16, char *)> callbackFn)
{
    m_onShowFingerMessageExtFn = callbackFn;
}

#ifdef ENABLE_VENDOR_LIB
void Rtk_CDCA::registerOnShowFingerInfoCallback (std::function<void(CDCA_U16, const SCDCAFingerInfo *)> callbackFn)
{
    m_onShowFingerInfoFn = callbackFn;
}

void Rtk_CDCA::registerOnStartIppvBuyDlgCallback (std::function<void(CDCA_U8, CDCA_U16, const SCDCAIppvBuyInfo *)> callbackFn)
{
    m_onStartIppvBuyDlgFn = callbackFn;
}

void Rtk_CDCA::registerOnLockServiceCallback (std::function<void(const SCDCALockService *)> callbackFn)
{
    m_onLockServiceFn = callbackFn;
}

void Rtk_CDCA::registerOnShowOSDInfoCallback (std::function<void(SCDCAOSDInfo *)> callbackFn)
{
    m_onShowOSDInfoFn = callbackFn;
}
#endif

void Rtk_CDCA::registerOnShowOSDMessageCallback (std::function<void(CDCA_U8, const char *)> callbackFn)
{
    m_onShowOSDMessageFn = callbackFn;
}

void Rtk_CDCA::registerOnShowProgressStripCallback (std::function<void(CDCA_U8, CDCA_U8)> callbackFn)
{
    m_onShowProgressStripFn = callbackFn;
}

void Rtk_CDCA::registerOnUNLockServiceCallback (std::function<void(void)> callbackFn)
{
    m_onUNLockServiceFn = callbackFn;
}

//---------------------------------------------------------------------------------------------------
// callback function object

void Rtk_CDCA::actionRequestExt(CDCA_U16 wTVSID, CDCA_U8 byActionType, CDCA_U8 byLen, CDCA_U8* pbyData)
{
    if (m_onActionRequestExtFn)
        m_onActionRequestExtFn(wTVSID, byActionType, byLen, pbyData);    
}

void Rtk_CDCA::continuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime)
{
    if (m_onContinuesWatchLimitFn)
        m_onContinuesWatchLimitFn(byType, wWorkTime, wStopTime);    
}

void Rtk_CDCA::detitleReceived(CDCA_U8 bstatus)
{
    if (m_onDetitleReceivedFn)
        m_onDetitleReceivedFn(bstatus);    
}

void Rtk_CDCA::emailNotifyIcon(CDCA_U8 byShow, CDCA_U32 dwEmailID)
{
    if(m_onEmailNotifyIconFn)
        m_onEmailNotifyIconFn(byShow, dwEmailID);
}

void Rtk_CDCA::entitleChanged(CDCA_U16 wTvsID)
{
    if (m_onEntitleChangedFn)
        m_onEntitleChangedFn(wTvsID);    
}

void Rtk_CDCA::hideOSDMessage(CDCA_U8 byStyle)
{
    if (m_onHideOSDMessageFn)
        m_onHideOSDMessageFn(byStyle);    
}

void Rtk_CDCA::hideIPPVDlg(CDCA_U16 wEcmPid)
{
    if (m_onHideIPPVDlgFn)
        m_onHideIPPVDlgFn(wEcmPid);    
}

void Rtk_CDCA::requestFeeding(CDCA_BOOL bReadStatus)
{
    if (m_onRequestFeedingFn)
        m_onRequestFeedingFn(bReadStatus);    
}

void Rtk_CDCA::showBuyMessage (CDCA_U16 wEcmPID, CDCA_U8 byMessageType)
{
    if(m_onShowBuyMessageFn)
        m_onShowBuyMessageFn(wEcmPID, byMessageType);
}

void Rtk_CDCA::showCurtainNotify(CDCA_U16 wEcmPID, CDCA_U16 wCurtainCode)
{
    if(m_onShowCurtainNotifyFn)
        m_onShowCurtainNotifyFn(wEcmPID, wCurtainCode);
}

void Rtk_CDCA::showFingerMessageExt(CDCA_U16 wEcmPID, char* fingerMsg)
{
    if(m_onShowFingerMessageExtFn)
        m_onShowFingerMessageExtFn(wEcmPID, fingerMsg);
}

#ifdef ENABLE_VENDOR_LIB
void Rtk_CDCA::showFingerInfo(CDCA_U16 wEcmPID, const SCDCAFingerInfo* pFingerInfo)
{
    if(m_onShowFingerInfoFn)
        m_onShowFingerInfoFn(wEcmPID, pFingerInfo);
}

void Rtk_CDCA::showOSDInfo(SCDCAOSDInfo *pOSDInfo)
{
    if (m_onShowOSDInfoFn)
        m_onShowOSDInfoFn(pOSDInfo);    
}

void Rtk_CDCA::lockService(const SCDCALockService* pLockService)
{
    if (m_onLockServiceFn)
        m_onLockServiceFn(pLockService);    
}

void Rtk_CDCA::startIppvBuyDlg(CDCA_U8 byMessageType, CDCA_U16 wEcmPid, const SCDCAIppvBuyInfo* pIppvProgram)
{
    if (m_onStartIppvBuyDlgFn)
        m_onStartIppvBuyDlgFn(byMessageType, wEcmPid, pIppvProgram);    
}
#endif

void Rtk_CDCA::showOSDMessage(CDCA_U8 byStyle, const char * szMessage)
{
    if (m_onShowOSDMessageFn)
        m_onShowOSDMessageFn(byStyle, szMessage);    
}

void Rtk_CDCA::showProgressStrip(CDCA_U8 byProgress, CDCA_U8 byMark)
{
    if (m_onShowProgressStripFn)
        m_onShowProgressStripFn(byProgress, byMark);    
}

void Rtk_CDCA::unlockService(void)
{
    if (m_onUNLockServiceFn)
        m_onUNLockServiceFn();    
}
//=====================================================================================================

#ifdef  __cplusplus
extern "C" {
#endif
Irtk_CaIntf* Rtk_GetCaIntfInstance(void)
{
	return (Irtk_CaIntf *)(Rtk_CDCA::getInstance());
}

void Rtk_PutCaIntfInstance(void)
{
	return;
}
#ifdef  __cplusplus
}
#endif
