#include "cdca_client.h"
#include "cdca_rDebug.h"
#include "rtk_porting_util.h"
#include "auto_version.h"

static bool m_isInit = false;

char CDCAHwa_Init(int caIndex)
{
    CDCA_Debug("CDCA_Init\n");
    
    if(m_isInit)  return 0;
    
    m_isInit = true;
    INT32_T connRefs=0;

    if(rtk_porting_getClientConnectStatus(&connRefs)==RTK_HAL_FALSE)
    {
    	if(rtk_porting_connect_TvServer()!=RTK_SUCCESS)
    	{
    		CDCA_Err("connect Server failed!\n");
    		return k_RetError;
    	}
    }	

#if 0
    if(!m_isInit)
    {
    	m_isInit = true;
    	CDCA_data_receive_init(caIndex);
    	rtk_porting_container_RegisterEventCallback((CA_EVENT_CALLBACK)_xEvent_Callbak);
    }
    else
    {
    	CDCA_Debug("[CLIENT]Already init\n");
    }
    #endif
    
    INT8_T ret = 0;

    ret = rtk_porting_container_InitCA(caIndex);
    CDCA_Debug("[CLIENT]rtk_porting_container_InitCA. ret = %d\n", ret);

    return ret;
}

void CDCAHwa_GetSTBID(unsigned short *pwPlatformID, unsigned long *pdwUniqueID)
{
	CA_directCallParam_t dparam;	
	memset(&dparam, 0x00, sizeof(CA_directCallParam_t));
	
	dparam.ret = -1;
	dparam.len_idata = 1;
	dparam.idata[0] = CDCA_HWA_GETSTBID; //function id.

    	rtk_porting_container_SetGetProperty(&dparam);
        
	*pwPlatformID = dparam.idata[0];
	CDCA_Debug("pwPlatformID:%d \n",*pwPlatformID);
	*pdwUniqueID = dparam.idata[1];
	CDCA_Debug("pdwUniqueID:%d \n",*pdwUniqueID);
}

void CDCAHwa_SetCW(unsigned short wEcmPID, const unsigned char* pbyOddKey, const unsigned char* pbyEvenKey,  unsigned char byKeyLen, unsigned char bTapingEnabled)
{

    CA_directCallParam_t dparam;	
    memset(&dparam, 0x00, sizeof(CA_directCallParam_t));

    dparam.ret = -1;
    dparam.len_idata = 4;
    dparam.idata[0] = CDCA_HWA_SETCW; //function id.
    dparam.idata[1] = wEcmPID;
    dparam.idata[2] = byKeyLen;
    dparam.idata[3] = bTapingEnabled;

    for(int i = 0; i < byKeyLen; i++)
    {
        dparam.cdata[i] =  pbyOddKey[i];
       //printf("OddKey[%d] = 0x%02x , param.cdata[%d] = 0x%02x \n", i , pbyOddKey[i], i, dparam.cdata[i]);
    }

    for(int j = 0;j < byKeyLen;j++)
    {
        dparam.cdata[byKeyLen+j] = pbyEvenKey[j];	
        //printf("EvenKey[%d] = 0x%02x , param.cdata[%d] = 0x%02x \n", j , pbyEvenKey[j], byKeyLen+j, dparam.cdata[byKeyLen+j]);
    }
    dparam.len_cdata = 2*byKeyLen;
    
    rtk_porting_container_SetGetProperty(&dparam);
    

}


void CDCAHwa_Remove_ECMPID(unsigned short wEcmPID)//remove keyslot
{
    CDCA_Debug("\n");
    CA_directCallParam_t dparam;
    memset(&dparam, 0x00, sizeof(CA_directCallParam_t));

    dparam.ret = -1;
    dparam.len_idata = 2;
    dparam.idata[0] = CDCA_HWA_REMOVE_ECMPID; //function id.
    dparam.idata[1] = wEcmPID;
    rtk_porting_container_SetGetProperty(&dparam);
}


void CDCAHwa_SetCW_Sercure(unsigned char *pData)
{
    	CA_directCallParam_t dparam;	
	memset(&dparam, 0x00, sizeof(CA_directCallParam_t));
	
	dparam.ret = -1;
	dparam.len_idata = 1;
	dparam.idata[0] = CDCA_HWA_SETCW_SERCURE; //function id.

    	rtk_porting_container_SetGetProperty(&dparam);
        
        memcpy(pData, dparam.cdata, dparam.len_cdata);

	CDCA_Debug("len_cdata:%d\n", dparam.len_cdata);
}

void CDCAHwa_Reset_Module(unsigned char *pData)
{
    	CA_directCallParam_t dparam;	
	memset(&dparam, 0x00, sizeof(CA_directCallParam_t));
	
	dparam.ret = -1;
	dparam.len_idata = 1;
	dparam.idata[0] = CDCA_HWA_RESET_MODULE; //function id.
        //:TODO:
        
    	rtk_porting_container_SetGetProperty(&dparam);
}


void CDCAHwa_GetOTPData()
{

}



void CDCAHwa_InterfaceTest(int type)
{
	CA_directCallParam_t dparam;	
	memset(&dparam, 0x00, sizeof(CA_directCallParam_t));
	
	dparam.ret = -1;
	dparam.len_idata = 1;
	dparam.idata[0] = CDCA_HWA_INTERFACE_TEST; //function id.
	
	rtk_porting_container_SetGetProperty(&dparam);
	return;
}
