#ifndef _CDCA_INTRFACE_H_
#define _CDCA_INTRFACE_H_

#include "cdca_rDebug.h"
//#include "cdca_pub.h"
//#include "cdca_api.h"
#include "CDCASS.h"
#include "cdca_hwa_types.h"

#ifdef  __cplusplus
extern "C" {
#endif

typedef enum
{
    NTSM_OK = 0x0000,
    NTSM_ERR_UNSUPPORT = 0x9100,
    NTSM_ERR_INS = 0x9200,
    NTSM_ERR_TIMEOVER = 0x9300,
    NTSM_ERR_Algorithm = 0x9401,
    NTSM_ERR_RootKeyID = 0x9402,
    NTSM_ERR_RootKLADLevels =0x9403,
    
}NTSM_status_e;

typedef CDCA_U32  CDCA_Semaphore;
extern CDCA_BOOL CDSTBCA_SetPrivateDataFilter( CDCA_U8        byReqID,  
											   const CDCA_U8* pbyFilter,  
											   const CDCA_U8* pbyMask, 
											   CDCA_U8        byLen, 
											   CDCA_U16       wPid, 
											   CDCA_U8        byWaitSeconds );

extern void CDSTBCA_ReleasePrivateDataFilter( CDCA_U8  byReqID, CDCA_U16 wPid); 

extern void CDSTBCA_ScrSetCW(CDCA_U16 wEcmPID, const CDCA_U8* pbyOddKey, const CDCA_U8* pbyEvenKey, CDCA_U8 byKeyLen,  CDCA_BOOL bTapingEnabled);

extern CDCA_BOOL CDSTBCA_SCReset( CDCA_U8* pbyATR, CDCA_U8* pbyLen );

extern CDCA_BOOL CDSTBCA_SCPBRun( const CDCA_U8* pbyCommand, CDCA_U16 wCommandLen, 
										CDCA_U8* pbyReply, CDCA_U16* pwReplyLen);
//NSC
///extern void CDSTBCA_LockService( const SCDCALockService* pLockService );



extern void* CDSTBCA_Malloc( CDCA_U32 byBufSize );
extern void  CDSTBCA_Free( void* pBuf );

extern void  CDSTBCA_Memset( void*    pDestBuf,
                             CDCA_U8  c,
                             CDCA_U32 wSize );

extern void  CDSTBCA_Memcpy( void*       pDestBuf,
                             const void* pSrcBuf,
                             CDCA_U32    wSize );

extern void CDSTBCA_ReadBuffer( CDCA_U8   byBlockID,
                                CDCA_U8*  pbyData,
                                CDCA_U32* pdwLen );

extern void CDSTBCA_WriteBuffer( CDCA_U8        byBlockID,
                                 const CDCA_U8* pbyData,
                                 CDCA_U32       dwLen );

extern void CDSTBCA_GetSTBID( CDCA_U16* pwPlatformID,
                              CDCA_U32* pdwUniqueID);

extern CDCA_U16 CDSTBCA_SCFunction( CDCA_U8* pData);

extern void CDSTBCA_ShowBuyMessage( CDCA_U16 wEcmPID,
                                    CDCA_U8  byMessageType );
extern CDCA_U16 CDSTBCA_Strlen(const char* pString );
extern void CDSTBCA_Printf(CDCA_U8 byLevel, const char* szMesssage );


#ifdef  __cplusplus
}
#endif


#endif //_CDCA_INTRFACE_H_
