#ifndef __CDCA_SYS_H__
#define __CDCA_SYS_H__
#include <stdint.h>
#include "rtk_porting_tuner.h"
#include "rtk_porting_source.h"
#include "rtk_porting_util.h"

#ifdef  __cplusplus
extern "C" {
#endif

//#ifdef ENABLE_DTVFLOW_SVP

#define ALGO_00_TS_CSAV2                0x000
#define ALGO_01_TS_CSAV3                0x01
#define ALGO_02_TS_AES_128_ECB   0x02

#define KLAD_ALGO_00_PLAINTEXT  0x00
#define KLAD_ALGO_01_TDES            0x01
#define KLAD_ALGO_02_AES              0x02

typedef enum
{
	KLAD_INVALID_ROOT_KEY,
	KLAD_CSAV2_ROOT_KEY ,
	KLAD_CSAV3_ROOT_KEY,
	KLAD_AES_ROOT_KEY,
}CDCA_root_key_e;

typedef enum
{
    CDCA_SYS_SUCCESS,
    CDCA_SYS_FAIL,
    CDCA_SYS_TIMEOUT
}CDCA_sys_result_t;

typedef struct{
        uint8_t keyType __attribute__ ((aligned (4)));
        uint16_t keySlotId __attribute__ ((aligned (4)));
        uint8_t  keyset __attribute__ ((aligned (4)));
        uint8_t tp_id __attribute__ ((aligned (4)));
        uint8_t is_enc __attribute__ ((aligned (4)));
}st_cdca_key_info;

typedef struct{
        uint8_t bDecAlgo __attribute__ ((aligned (4)));
        uint8_t bKladAlgo __attribute__ ((aligned (4)));
        uint8_t bKladRkId __attribute__ ((aligned (4)));
        uint8_t bKladLevels __attribute__ ((aligned (4)));
        uint8_t pEk1_k0[16] __attribute__ ((aligned (4)));
        uint8_t pEk2_k1[16] __attribute__ ((aligned (4)));
        uint8_t pEk3_k2[16] __attribute__ ((aligned (4)));
        uint8_t pEk4_k3[16] __attribute__ ((aligned (4)));
        
}st_cdca_klad_info;

typedef struct{
        uint16_t tsid __attribute__ ((aligned (4)));
        uint8_t bCwLen __attribute__ ((aligned (4)));
        uint8_t pEvenCw[16] __attribute__ ((aligned (4)));
        uint8_t pOddCw[16] __attribute__ ((aligned (4)));
        uint8_t bTapingEnable  __attribute__ ((aligned (4)));
        uint8_t bExtensionFlag  __attribute__ ((aligned (4)));
        st_cdca_klad_info klad_info  __attribute__ ((aligned (4)));
}st_cdca_cw_info;

typedef struct{
    st_cdca_key_info key_info  __attribute__ ((aligned (4)));
    st_cdca_cw_info cw_info  __attribute__ ((aligned (4)));
}st_cdca_descramble_info;

typedef struct{
	uint32_t tsid;
	uint16_t ecmPid;

	Source_Handle sourceHandle;
}st_cdca_scramble_info;

typedef struct{
     int descramble_id;
     uint16_t emmpid; //ecm count =0;
     Source_Handle sourceHandle;
}st_cdca_emm_srcHdl;

typedef enum
{
    CDCA_UPDATE_TSID,//don't update tsid, tsid is unique
    CDCA_UPDATE_ECMPID,
    CDCA_UPDATE_SOURCE_HANDLE,
}cdca_scramble_e;

typedef enum{
    EK1_K0 =1,
    EK2_K1 ,
    EK3_K2,
    EK4_K3,
}EK_ENUM;

typedef enum {
    TPA_0 = 0,
    TPA_1,
    TPB_0,
    TPB_1,
    TPC_0
}TP_INSTANCE_ID;





#define CDCA_SYS_UUID { 0xccd042f6, 0xc103, 0x11ea, \
{ 0xb3, 0xde, 0x02, 0x42, 0xac, 0x13, 0x00, 0x04} }
/* The CMDs(have to be the same as) implemented in cdcasys TA  */

#define TA_CDCA_SYS_INIT (0x10)
#define TA_CDCA_SYS_KM_GET_KEYSLOT  (TA_CDCA_SYS_INIT +0)
#define TA_CDCA_SYS_KM_SET_KEYSLOT   (TA_CDCA_SYS_INIT +1)
#define TA_CDCA_SYS_KM_FREE_KEYSLOT (TA_CDCA_SYS_INIT +2)
#define TA_CDCA_SYS_KM_GET_KEYID      (TA_CDCA_SYS_INIT +3)
#define TA_CDCA_SYS_KM_SET_CW  (TA_CDCA_SYS_INIT +4)
#define TA_CDCA_SYS_GET_OTP_CHIP_ID (TA_CDCA_SYS_INIT +5)


#define TA_CDCA_STATUS_NOT_INIT  0
#define TA_CDCA_STATUS_OPENED    1
#define TA_CDCA_STATUS_NOT_EXIST 2

int Initialize_cdca_ta();
void Finalize_cdca_ta();

int getKeyInfo(uint32_t tsid,uint8_t is_enc,st_cdca_key_info* key_info);
int KmGetKeySlotID(int32_t *km_state, uint16_t *keyslot_id);
int KmSetKeySlotID(int32_t *kt_manager_state, uint16_t keyslot_id);
int KmFreeKeySlotID(int32_t *kt_manager_state, uint16_t keyslot_id);
int KmGetKeyID(int32_t *kt_manager_state, uint16_t keyslot_id, unsigned char *key_id);
int cdca_sys_GetOtpData();
int cdca_sys_RemoveEcmPid();
int cdca_sys_SetSecureCw(unsigned char* pData);
int cdca_sys_SetSrcCw(CDCA_U16 wEcmPID,const CDCA_U8* pbyOddKey,const CDCA_U8* pbyEvenKey,CDCA_U8 byKeyLen,CDCA_BOOL bTapingEnabled);
int cdca_sys_GetChipId(unsigned int *chipId);
int cdca_sys_setDescrambleInfo(st_cdca_descramble_info* desc_info);
int cdca_sys_FreeKeySlotByTsid(uint32_t tsid);
int cdca_sys_stopTpDescrambe(uint32_t tsid, Rtk_Descrambler_Mode_e mode);


int cdca_sys_MapExmCreate(CDCA_U32 tsid, CDCA_U16 ecmPid,int sourceHandle);
int cdca_sys_MapExmUpdateByParam(uint32_t tsid, cdca_scramble_e paramKey,uint32_t paramValue);
int cdca_sys_MapExmRemoveByTsid(uint32_t tsid);
int cdca_sys_MapExmQueryByParam(uint32_t tsid, cdca_scramble_e paramKey,uint32_t* paramValue);
int cdca_sys_MapExmGetSourceHandle(uint32_t *scrHandle);


CDCA_BOOL CDCA_Sys_Init();
void CDCA_Sys_Uninit();


//s#endif //#ifdef ENABLE_DTVFLOW_SVPs

#ifdef __cplusplus
}
#endif
#endif// #ifndef __CDCA_SYS_H__

