/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_dmx.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA dmx related APIs
**-------------------------------------------------------------------------------
*/
#include "cdca_interface.h"
#include "CDCASS.h"
#include "rtk_porting_util.h"
#include "rtk_hal_base.h"

//#include "Rtk_CDCa.h"
#include "cdca_common.h"
#include "cdca_dmx.h"
#include "cdca_sys.h"


#define CDCA_CW_PDATA_LENGTH (122)

#define UNUSED_PID (0xFFFF)

#define MAX_OPEN_FILTER	(32)	   //same as server

static SecFilterInfo g_ExmReqInfo[MAX_OPEN_FILTER] = {};

static pthread_mutex_t g_cdca_dmx_mutex = PTHREAD_MUTEX_INITIALIZER;

static bool g_dmx_isInit = false;
static uint32_t g_dmx_com_srcHdl = 0;

void CDCA_Dmx_SetCommonSource(int source_handle)
{
    CDCA_Trace("emm source handle = 0x%x\n", source_handle);
    pthread_mutex_lock(&g_cdca_dmx_mutex);

    g_dmx_com_srcHdl = source_handle;
    pthread_mutex_unlock(&g_cdca_dmx_mutex);
}

void CDCA_Dmx_GetCommonSource(int* source_handle)
{
    pthread_mutex_lock(&g_cdca_dmx_mutex);
    *source_handle = g_dmx_com_srcHdl ;
    pthread_mutex_unlock(&g_cdca_dmx_mutex);
}

CDCA_BOOL _dmx_Init()
{
    if(g_dmx_isInit == false)
    {        

	for(int i=0; i < MAX_OPEN_FILTER; i++)
	{
		g_ExmReqInfo[i].wPid= UNUSED_PID;
		g_ExmReqInfo[i].reqID = 0;
              g_ExmReqInfo[i].tsid = UNKNOWN_TSID_SIDX;
               g_ExmReqInfo[i].filter_handle = 0;
	}
        g_dmx_isInit = true;           
    }
    
    return CDCA_TRUE;
}


int _find_ReqInfo_Idx(CDCA_U16 wPid,    CDCA_U8 byReqID)
{
    int index =-1;
    if(wPid == UNUSED_PID || byReqID == 0)
    {
        return index;
    }
       
    for(int idx = 0; idx < MAX_OPEN_FILTER; idx++)
    {
        //if( g_ExmReqInfo[idx].wPid == wPid && g_ExmReqInfo[idx].ReqID == byReqID)
        if( g_ExmReqInfo[idx].tsid == wPid && g_ExmReqInfo[idx].reqID == byReqID)
        {
            index = idx;
            break;
        }
    }
    return index;
}

void _dmx_release_exmReqInfo(CDCA_U8  byReqID, CDCA_U16 wPid)
{
        uint32_t srcHandle;
        int ret;
        int id = _find_ReqInfo_Idx(wPid, byReqID);

        CDCA_Debug("Remove sectoinFilter &ExmReqInfo[%d], wpid = 0x%x, byReqId = %d\n", id, wPid, byReqID);
        ret = cdca_sys_MapExmQueryByParam(wPid,CDCA_UPDATE_SOURCE_HANDLE,&srcHandle);
        if(ret != CDCA_SYS_SUCCESS)
        {
                //cdca_sys_MapExmGetSourceHandle(&srcHandle);
                srcHandle = g_dmx_com_srcHdl;
        }

        if(srcHandle == 0)
        {
                CDCA_Err("Source Handle is NULL, Please check !!!\n");
        }

        if(id < 0 || id >= MAX_OPEN_FILTER || 0 == srcHandle)
                return ;  

        CDCA_Trace("RemoveSectionFilter srcHandle = 0x%x, filter_handle = %p \n", srcHandle, g_ExmReqInfo[id].filter_handle);
        RTK_Source_RemoveSectionFilter((Source_Handle)srcHandle, g_ExmReqInfo[id].filter_handle);

        g_ExmReqInfo[id].wPid = UNUSED_PID;
        g_ExmReqInfo[id].reqID = 0;
        g_ExmReqInfo[id].tsid = UNKNOWN_TSID_SIDX;
        g_ExmReqInfo[id].filter_handle = 0;
}


static void CDCA_Section_CB(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
    CDCA_Trace("SectionCallback, handle = %p,  enStatus = %d, length = %d\n", handle,  (int)enStatus, length);
	
    //SecFilterInfo* filterInfo = (SecFilterInfo *) userParam;
    SecFilterInfo filterInfo; 
    memcpy(&filterInfo, userParam, sizeof(SecFilterInfo)); 
    
    CDCA_Info("SectionCallback, tsid = 0x%x, wPid = (0x%x)\n", filterInfo.tsid, filterInfo.wPid);
    if(filterInfo.wPid == 0xFFFF)
    {
        CDCA_Err("SectionCallback wPid invalid, Warning\n");
        return;
    }

    //deliver private data to CA lib
    #if 0
		printf("\n");
	    for(int i=0;i<length;i++){
			if((i>0) && (i%8==0))
				printf("\n");
			printf(" %02X ",section[i]);
			
	    }
		
		printf("\n");
	#endif

#ifdef ENABLE_CA_LIB
    CDCA_BOOL bTimeout = (enStatus == HAL_SECTION_FILTER_TIMEOUT)?CDCA_TRUE:CDCA_FALSE;
    CDCASTB_PrivateDataGot(filterInfo.reqID, bTimeout, filterInfo.tsid, section,length);
#endif
    
     if(0 != (filterInfo.reqID & 0x80)) //ont shot
     {
        CDCA_Info("Release private data filter by STB tsid (0x%x) \n", filterInfo.tsid );
        pthread_mutex_lock(&g_cdca_dmx_mutex);
        _dmx_release_exmReqInfo(filterInfo.reqID, filterInfo.tsid);
        pthread_mutex_unlock(&g_cdca_dmx_mutex);
     }
}


CDCA_BOOL CDSTBCA_SetPrivateDataFilter(CDCA_U8 byReqID,  
							const CDCA_U8* pbyFilter,
							const CDCA_U8* pbyMask, 
							CDCA_U8 byLen, 
							CDCA_U16 wPid,
							CDCA_U8 byWaitSeconds )
{

    CDCA_Trace("CDSTBCA_SetPrivateDataFilter invoked : byReqID =0x%x,wPid = 0x%x, byWaitSeconds = %d, Len =0x%x", byReqID, wPid, byWaitSeconds, byLen);

    CDCA_Trace("pbyFilter =%02x %02x %02x %02x %02x %02x %02x %02x ", 
                          pbyFilter[0], pbyFilter[1], pbyFilter[2], pbyFilter[3], pbyFilter[4], pbyFilter[5], pbyFilter[6], pbyFilter[7]);

    CDCA_Trace("pbyMask =%02x %02x %02x %02x %02x %02x %02x %02x ", 
                          pbyMask[0], pbyMask[1], pbyMask[2], pbyMask[3], pbyMask[4], pbyMask[5], pbyMask[6], pbyMask[7]);
    pthread_mutex_lock(&g_cdca_dmx_mutex);
     _dmx_Init();

    uint32_t  srcHandle = 0 ;
    RTK_SectionFilterMask SectionFilterPattern;
    RTK_SectionFilter filter_handle;

	/*
        //FIXME
       SecFilterInfo *param =(SecFilterInfo *) malloc(sizeof(SecFilterInfo));
	param->reqID = byReqID;
	param->tsid = wPid; //from calib is tsid
	param->wPid = wPid; //ecm pid
	*/
    CDCA_U16 tsid = wPid;
    uint32_t ecmPid;
    int validIdx = -1;

    int ret;
    ret =cdca_sys_MapExmQueryByParam(tsid,CDCA_UPDATE_ECMPID,&ecmPid);
    if(ret == CDCA_SYS_SUCCESS){
    	wPid = (ecmPid & 0xFFFF);
    }

    ret = cdca_sys_MapExmQueryByParam(tsid,CDCA_UPDATE_SOURCE_HANDLE,&srcHandle);
    if(ret != CDCA_SYS_SUCCESS)
    {
        if(0 == srcHandle )
        {
            CDCA_Debug("not ecm pid, using emm source handler \n");
            srcHandle = g_dmx_com_srcHdl;
        } 
    }
    if(srcHandle == 0){
        CDCA_Err("source Handle is NULL,Please check !!! \n");
        goto error;
    }
    
    memset(&SectionFilterPattern, 0x00, sizeof(RTK_SectionFilterMask));
    SectionFilterPattern.pid = wPid;// ecm pid or emm pid
    if(0 == (byReqID & 0x80))
    {
        SectionFilterPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
    }
    else
    {
        SectionFilterPattern.monitoring_mode = RTK_SECTION_MODE_ONESHOT;
    } 
    //only support max_filter_num=32
    if(_find_ReqInfo_Idx(tsid, byReqID) >=0 )
    {
        CDCA_Debug("param->tsid(0x%x) & reqId(0x%x) exist, release old one\n", byReqID, tsid);
        _dmx_release_exmReqInfo(byReqID, tsid);
    }

    for(int idx = 0; idx < MAX_OPEN_FILTER; idx++)
    {
        CDCA_Debug("g_ExmReqInfo[%d].pid = 0x%x, reqID = 0x%x \n", idx, g_ExmReqInfo[idx].wPid, g_ExmReqInfo[idx].reqID);
        
    	if(UNUSED_PID == g_ExmReqInfo[idx].wPid && 0 == g_ExmReqInfo[idx].reqID)
    	{
    	    validIdx = idx;
            break;
    	}
    }
    
    if(MAX_OPEN_FILTER == validIdx)
    {
    	CDCA_Err("no buffer to save request pid/filter, index=%d\n", validIdx);

    	goto error; 
    }

    g_ExmReqInfo[validIdx].reqID = byReqID;
    g_ExmReqInfo[validIdx].wPid = wPid;
    g_ExmReqInfo[validIdx].tsid = tsid;

    CDCA_Info("ExmReqInfo idx =%d\n", validIdx);
    SectionFilterPattern.callback_01 = CDCA_Section_CB;
    //SectionFilterPattern.section_user_param = (void *)param;
    SectionFilterPattern.section_user_param = &g_ExmReqInfo[validIdx];
    SectionFilterPattern.u32byWaitTimeoutMs = byWaitSeconds*1000;
    SectionFilterPattern.comp[0] = pbyFilter[0];
    SectionFilterPattern.mask[0] = pbyMask[0];  

    memcpy(&SectionFilterPattern.comp[1] ,&pbyFilter[1],byLen -1);
    memcpy(&SectionFilterPattern.mask[1], &pbyMask[1],byLen - 1);

	
    RTK_Source_AddSectionFilter((Source_Handle)srcHandle, &filter_handle, &SectionFilterPattern);
    g_ExmReqInfo[validIdx].filter_handle = filter_handle;

    CDCA_Trace("exit ");
    pthread_mutex_unlock(&g_cdca_dmx_mutex);
    return CDCA_TRUE;

error:
    CDCA_Info("Error case \n");
    pthread_mutex_unlock(&g_cdca_dmx_mutex);
    return CDCA_FALSE;
        
}


void CDSTBCA_ScrSetCW(CDCA_U16 wEcmPID,
                                                    const CDCA_U8* pbyOddKey, 
                                                    const CDCA_U8* pbyEvenKey, 
                                                    CDCA_U8 byKeyLen,  
                                                    CDCA_BOOL bTapingEnabled)
{

        CDCA_Info("enter... wEcmPId = 0x%x\n", wEcmPID);
		cdca_sys_SetSrcCw(wEcmPID,pbyOddKey,pbyEvenKey,byKeyLen,bTapingEnabled);
}

void CDCA_Reset_Module(unsigned char *pData)
{
        (void)(pData);
        CDCA_Trace("Need to implement \n");
}


//[deprecated]
//dataLen value (1 or 2 bytes) carried with cdata, dataLen bytes num carried with len_cdata
//real data start from pData[dataLenStartIdx + dataLenBytes],  be carried by idata[256] array 
void CDCA_GetOTPData(unsigned char *pData)
{

        int intLen = sizeof(int);
        int idataUsingLen = 0;

        int dataLenStartIdx = 2; //start index of pData to get the dataLen
        int dataLenBytes = 1;   //need check bytes to get the datalen
        
        CA_directCallParam_t dparam;
        memset(&dparam, 0x00, sizeof(CA_directCallParam_t));
        dparam.ret = -1;
        dparam.len_idata = 1;
        dparam.idata[0] = CDCA_HWA_RESET_GETOTPDATA; //function id.
        
        CDCA_U8 dataLen = pData[2];
        CDCA_Trace("pData[2] = 0x%02x\n", pData[2]);
        if(dataLen >= 0 && dataLen < 0x80 )//[0, 127]
        {
            dataLenStartIdx = 2;
            dataLenBytes = 1;
            dataLen = pData[dataLenStartIdx];            

        }
        else if(dataLen == 0x81 )//[128,255]
        {
            dataLenStartIdx = 3;
            dataLenBytes = 1;
            dataLen = pData[dataLenStartIdx];
        }
        else //[256, 1020]
        {
             dataLenStartIdx = 3;
             dataLenBytes = 2;
             dataLen = pData[3] << 8 |pData[4];
        }

         if(dataLen > 1020)
        {
            CDCA_Err("DataLen over the size");
            return;
        }  

        idataUsingLen = (dataLen%intLen == 0)?(dataLen/intLen):(dataLen/intLen) + 1;
        dparam.len_idata += idataUsingLen;
        memcpy(dparam.idata + 1, pData + dataLenStartIdx + dataLenBytes, dataLen);
        
        dparam.len_cdata = dataLenBytes;
        for(int j = 0; j < dataLenBytes; j++)
        {
            dparam.cdata[j] = pData[dataLenStartIdx + j];
        }
        rtk_porting_container_SetGetProperty(&dparam);

        int retDataLen = 0;
        CDCA_Trace("dparam.len_cdata = %d\n", dparam.len_cdata);
        if(dparam.len_cdata == dataLenBytes)
        {
            if(dataLenBytes == 1)
                retDataLen = dparam.cdata[0];
            else if(dataLenBytes == 2)
                retDataLen = dparam.cdata[0] << 8 | dparam.cdata[1];
            else 
                CDCA_Err("Error case\n");
        }
        CDCA_Trace("retDataLen = %d, org dataLen = %d\n", retDataLen, dataLen);
        if(retDataLen != dataLen)
        {
            CDCA_Err("OTP data len not correct\n");
            return; 
        }

        pData[0] = 0x80;
        pData[1] = pData[2];
        for(int j = 0; j < dataLenBytes; j++)
        {
            CDCA_Trace("cdata[%d] = 0x%02x\n", j, dparam.cdata[j]);
            pData[dataLenStartIdx -1 + j] = dparam.cdata[j];
        }
        memcpy(pData + dataLenStartIdx + dataLenBytes -1, dparam.idata, dataLen);
       
}

void CDCA_Remove_ECMPID(unsigned short wEcmPID)//remove keyslot
{
    CDCA_Debug("wEcmPID = 0x%x\n", wEcmPID);
    cdca_sys_FreeKeySlotByTsid(wEcmPID);
}

void CDSTBCA_ReleasePrivateDataFilter( CDCA_U8  byReqID, CDCA_U16 wPid )
{
    CDCA_Debug("Release section filer by calib,  wPid = 0x%x, byReqId = 0x%x\n", wPid, byReqID);
    pthread_mutex_lock(&g_cdca_dmx_mutex);

    _dmx_release_exmReqInfo(byReqID, wPid);
    
    pthread_mutex_unlock(&g_cdca_dmx_mutex);
    return; 
}

void CDCA_Dmx_RemoveSectionFiler(CDCA_U32  tsid)
{
    
    pthread_mutex_lock(&g_cdca_dmx_mutex);
    
    for(int idx = 0; idx < MAX_OPEN_FILTER; idx++)
    {
        if(g_ExmReqInfo[idx].tsid == tsid && 0 != (g_ExmReqInfo[idx].reqID & 0x80)) 
        {
            //only release oneshot sectionFilter
            CDCA_Debug("Remove ecm sectionFilter by STB, tsid = 0x%x, g_ExmReqInfo[idx].reqID = 0x%x,  g_ExmReqInfo[idx].wPid = 0x%x\n", tsid, g_ExmReqInfo[idx].reqID,  g_ExmReqInfo[idx].wPid);
            _dmx_release_exmReqInfo(g_ExmReqInfo[idx].reqID, tsid);
        }
    }

    pthread_mutex_unlock(&g_cdca_dmx_mutex);
}

