/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_interface.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA Device related APIs & other APIs
**-------------------------------------------------------------------------------
*/


#include <stdarg.h>
#include <stdio.h>
#include <strings.h>
#include <openssl/aes.h>

#include "cdca_interface.h"
#include "rtk_porting_util.h"
#include "cdca_common.h"
#include "cdca_sys.h"
#include "cdca_dmx.h"
#include "Rtk_CDCa.h"


typedef enum{
        RESET_SEC_MODULE =0x02,
        GET_OTP_DATA =0x05,
        LOAD_CW =0x18,
}Sc_Func_Ins_e;

 int fprintf(FILE *stream, const char *fmt, ...)
{
	va_list ap;
	int ret;
	char *s;

	s = NULL;
	va_start(ap, fmt);
	ret = vasprintf(&s, fmt, ap);
	va_end(ap);

	if (s) {
		fwrite(s, 1, strlen(s), stream);
	}
	free(s);

	return ret;
}

void DUMP_DATA( char * fileName, unsigned char* buf, int len) 
{
     char file[100] = "/data/vendor/mediadrm/ca/";
     FILE *pFile = fopen(strcat(file, fileName), "w+"); 
     if(pFile ==NULL)
     {
        CDCA_Err("fopen failed errno = %d reason = %s \n", errno, strerror(errno));
        return;
     }
    for(int i=0; i< len; i++) 
    {
        if((i+1)%16 == 0) 
        {
            fprintf(pFile, "%02x \r\n",  buf[i]); 
        }
        else 
        {
             fprintf(pFile, "%02x  ",  buf[i]); 
        }
    }
    
    if(NULL != pFile) 
    { 
        fclose(pFile); 
    }

}
    

void CDSTBCA_GetSTBID( CDCA_U16* pwPlatformID, CDCA_U32* pdwUniqueID)
{
#ifdef ENABLE_CA_LIB
    *pwPlatformID = CDCASTB_GetPlatformID();
#else
    *pwPlatformID = 0x8383;
#endif
     CDCA_Debug("pwPlatformID:0x%x \n ", *pwPlatformID);

    cdca_sys_GetChipId(pdwUniqueID);
    CDCA_Debug(" pdwUniqueID:0x%x \n",  *pdwUniqueID);
}


CDCA_U16 CDSTBCA_SCFunction( CDCA_U8* pData)
{

   CDCA_Trace("pData = 0x%x\n", *pData);


    if(GET_OTP_DATA == *pData)
    {
        CDCA_U8 len =  *(pData +2);
        if(len >= 0 && len < 0x80 )//[0, 127]
        {
            *pData = 0x80;
            *(pData+1) = len;
             for(int i = 1; i <= len; i++)
            {
                *(pData+1+i) = 0x00;
            }
        }
        else if(len == 0x81 )
        {
            len = *(pData + 3);
            *pData = 0x80; //returnCode
            *(pData + 1 ) =  0x81;//*(pData +2);
            *(pData+2)  = *(pData + 3);
            CDCA_Trace("pData+3= 0x%x, len = 0x%x\n", *(pData +3), len);
            for(int i = 1; i <= len; i++)
            {
                *(pData+2+i) = 0x00;
            }
        }
        else //[256, 1020]: Need to check more
        {
             *pData = 0x80;
             *(pData + 1 ) =  0x82;          
        }

        //CDCA_GetOTPData(pData); //replace cdca_sys_getOTPData

        return NTSM_OK;  
    }
    else if(RESET_SEC_MODULE == *pData)
    {
        return NTSM_OK;
    }
    else if(LOAD_CW == *pData)
    {
          //DUMP_DATA("scfun.txt", (unsigned char*)pData, 256);

          cdca_sys_SetSecureCw(pData);

           return NTSM_OK;
    }

    return NTSM_ERR_UNSUPPORT;
}

void CDSTBCA_ShowBuyMessage( CDCA_U16 wEcmPID, CDCA_U8  byMessageType )
{
	CDCA_Debug("wEcmPID=%d, byMessageType=%d\n", wEcmPID, byMessageType);
#ifdef ENABLE_CA_LIB
    Rtk_CDCA::CDSTBCA_ShowBuyMessage(wEcmPID, byMessageType);
#endif
}

CDCA_U16 CDSTBCA_Strlen(const char* pString )
{
	CDCA_Trace("enter\n");
	unsigned short strlength = 0;
	if (NULL == pString)
	{
		printf("[%s] null is param\n", __func__);
	}
	else
	{
		strlength = strlen(pString);
	}
	CDCA_Trace("memcpy : done. exit\n");
	return strlength;
}


void CDSTBCA_Printf(CDCA_U8 byLevel, const char* szMesssage )
{	
    UNUSED(byLevel);
    UNUSED(szMesssage);
    ALOGD("[CDCA][CALib]Lev:0x%x, message: %s\n", byLevel, szMesssage);	

    return;
}

#ifndef ENABLE_SC
CDCA_BOOL  CDSTBCA_GetCurrentTime( CDCA_S32  *pUTCTime, CDCA_S32 *pTimeZoneBias, CDCA_S32 *pDaylightBias,  CDCA_BOOL* pInDaylight)
{
	struct tm lt = {0};
	time_t t;

	//DBG_PRINT("%d  %s:\n", __LINE__, __func__);

	t = time(NULL);
	if(-1 == t)
		return CDCA_FALSE;

	*pUTCTime = t;
	
	localtime_r(&t, &lt);
	*pTimeZoneBias = lt.tm_gmtoff * 60;  /*minutes*/
	*pDaylightBias = 0;  // TBD
	if (lt.tm_isdst > 0)
		*pInDaylight = CDCA_TRUE;
	else
		*pInDaylight = CDCA_FALSE;

	//DBG_PRINT("%d  %s: %s\n", __LINE__, __func__, ctime(&t));
	return CDCA_TRUE;
}
#endif


void CDSTBCA_ShowOSDMessage( CDCA_U8     byStyle,
                                    const char* szMessage )
{
	CDCA_Debug("byStyle = %d\n", byStyle);
#ifdef ENABLE_CA_LIB
   Rtk_CDCA::CDSTBCA_ShowOSDMessage(byStyle, szMessage);
#endif
}
									
void CDSTBCA_HideOSDMessage( CDCA_U8 byStyle )
{
	CDCA_Debug("byStyle = %d\n", byStyle);
#ifdef ENABLE_CA_LIB
   Rtk_CDCA::CDSTBCA_HideOSDMessage(byStyle);
#endif
}

void CDSTBCA_EmailNotifyIcon( CDCA_U8 byShow, CDCA_U32 dwEmailID )
{
	CDCA_Debug(" byShow = %d, dwEmailID = %d\n", byShow, dwEmailID);
#ifdef ENABLE_CA_LIB
   Rtk_CDCA::CDSTBCA_EmailNotifyIcon(byShow, dwEmailID);
#endif
}

static char key[AES_BLOCK_SIZE] ;

CDCA_BOOL CDSTBCA_AESCBC_Encrypt(CDCA_U8 *pPlainText, CDCA_U32 TextLen, CDCA_U8 *pCipherText)
{
    CDCA_Trace("TextLen = %d\n", TextLen);
    static bool key_stat = false;
    if(key_stat == false)
    {
        for(int i = 0; i < AES_BLOCK_SIZE; i++)
        {
            key[i] = 32 + i;
        }
        key_stat = true;
    }

    if(!pPlainText || !pCipherText) return CDCA_FALSE;
    
    unsigned char iv[AES_BLOCK_SIZE];
    for(int i=0; i<AES_BLOCK_SIZE; ++i)
    {
        iv[i]=0;
    }
    AES_KEY aes;
    if(AES_set_encrypt_key((unsigned char*)key, 128, &aes) < 0)
        return CDCA_FALSE;
    AES_cbc_encrypt(pPlainText, pCipherText,   TextLen, &aes,  iv, AES_ENCRYPT);

    return CDCA_TRUE;
}


CDCA_BOOL CDSTBCA_AESCBC_Decrypt(CDCA_U8 *pCipherText, CDCA_U32 TextLen, CDCA_U8 *pPlainText)
{
    CDCA_Trace("TextLen = %d\n", TextLen);
  	if(!pCipherText || !pPlainText) return CDCA_FALSE;
  
    unsigned char iv[AES_BLOCK_SIZE];
    for(int i=0; i<AES_BLOCK_SIZE; ++i)
    {
        iv[i]=0;
    }
    AES_KEY aes;
    if(AES_set_decrypt_key((unsigned char*)key, 128, &aes) < 0)
    {
        return CDCA_FALSE;
    }
    AES_cbc_encrypt(pCipherText, pPlainText, TextLen, &aes, iv, AES_DECRYPT);
    
    return CDCA_TRUE;
}

  void CDSTBCA_ShowFingerMessageExt( CDCA_U16 wEcmPID, char* fingerMsg )
{
   	CDCA_Debug("%s\n", __func__);
#ifdef ENABLE_CA_LIB
    Rtk_CDCA::CDSTBCA_ShowFingerMessageExt(wEcmPID, fingerMsg);
#endif
}


void  CDSTBCA_ActionRequestExt( CDCA_U16 wTVSID,
                                      CDCA_U8  byActionType,
                                      CDCA_U8 byLen,
                                      CDCA_U8* pbyData)
{
   	//CDCA_Trace("%s\n", __func__);  // disabled due to the heavy debug output
#ifdef ENABLE_CA_LIB
    Rtk_CDCA::CDSTBCA_ActionRequestExt(wTVSID, byActionType, byLen, pbyData);
#endif
}


