/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_mem.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA memorizer related APIs
**-------------------------------------------------------------------------------
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>    // for malloc
#include <unistd.h>  // for F_OK ...
#include <pthread.h>
#include <semaphore.h>
#include <sys/types.h>
#include <sys/ipc.h>

#include <linux/msg.h>
#include <sys/stat.h>	// for S_IRUSR ...

#include "cdca_interface.h"
#include "cdca_common.h"

#define CDNVM_FOLDER						"/data/vendor/mediadrm/ca/"
#define CDNVM_DATA_A						"cd_nvm_1.dat"
#define CDNVM_DATA_B						"cd_nvm_2.dat"
#define CDNVM_DATA_C						"cd_nvm_3.dat"

#define CDNVM_TOTAL_SIZE			(64*1024)	//box allocation for CA LIB
#define CDNVM_MAX_SIZE			CDNVM_TOTAL_SIZE


static int g_cdnvm_init = 0;
static pthread_mutex_t  g_cdnvm_mutex = PTHREAD_MUTEX_INITIALIZER;

int xInit(void)
{
	CDCA_Trace("NVM initialization.\n");
	FILE *flashfile;
	int total_len = CDNVM_TOTAL_SIZE;
	char* buf = (char *)malloc(sizeof(char) *CDNVM_TOTAL_SIZE);

	if( 0 == g_cdnvm_init)
	{
		//CDNVM_MutexCreate(&g_cdnvm_mutex, NULL);
		g_cdnvm_init = 1;	/* To avoid creating several mutex because there is only one e2p file on system */
		#if (0)
			//Need remove after finish CA program.
			//Formate Buffer to test CDSTBCA_LockService/OSD.
			printf("!!!FormatBuffer!!!\n");
			printf("!!!FormatBuffer!!!\n");
			printf("!!!FormatBuffer!!!\n");
			if( (access(CDNVM_FOLDER CDNVM_DATA_A, F_OK)) == 0 )
			{
				printf("!!!FormatBuffer CDNVM_DATA_A!!!\n");
				CDCASTB_FormatBuffer();
			}
			if( (access(CDNVM_FOLDER CDNVM_DATA_B, F_OK)) == 0 )
			{
				printf("!!!FormatBuffer CDNVM_DATA_B!!!\n");
				CDCASTB_FormatBuffer();
			}
			#ifndef ENABLE_SC
            if( (access(CDNVM_FOLDER CDNVM_DATA_C, F_OK)) == 0 )
			{
				//CDCA_Trace("!!!FormatBuffer CDNVM_DATA_C!!!\n");
				CDCASTB_FormatBuffer();
			}
			#endif
		#endif
	}

	if( (access(CDNVM_FOLDER, F_OK)) != 0 )
	{
		mkdir(CDNVM_FOLDER, S_IRUSR|S_IWUSR|S_IXUSR);
	}
	
	if( (access(CDNVM_FOLDER CDNVM_DATA_A, F_OK)) != 0 )
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_A, "wb");
		if(flashfile==NULL)
		{
			CDCA_Err("open file_1 failed!\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }			
                       return (1);
		}

		memset(buf, 0x00, CDNVM_TOTAL_SIZE);
		//sprintf(buf, "%s", CTINVM_VERSION);

		if( total_len != fwrite( buf, 1, total_len, flashfile) )
		{
			CDCA_Err("fwrite file_1 error !\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }
                       return (1);
		}

		fclose( flashfile );

	}
	else
	{
		CDCA_Info("e2p file_1 exist. OK\n");
	}

	if( (access(CDNVM_FOLDER CDNVM_DATA_B, F_OK)) != 0 )
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_B, "wb");
		if(flashfile==NULL)
		{
			CDCA_Err("open file_2 failed!\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }
                       return (1);
		}

		memset(buf, 0x00, CDNVM_TOTAL_SIZE);
		//sprintf(buf, "%s", CTINVM_VERSION);

		if( total_len != fwrite( buf, 1, total_len, flashfile) )
		{
			CDCA_Err("fwrite file_2 error !\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }
            
			return (1);
		}

		fclose( flashfile );
	}
	else
	{
		CDCA_Info("e2p file_2 exist. OK\n");
	}

#ifndef ENABLE_SC
    if( (access(CDNVM_FOLDER CDNVM_DATA_C, F_OK)) != 0 )
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_C, "wb");
		if(flashfile==NULL)
		{
			CDCA_Err("open file_3 failed!\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }
                       return (1);
		}

		memset(buf, 0x00, CDNVM_TOTAL_SIZE);
		//sprintf(buf, "%s", CTINVM_VERSION);

		if( total_len != fwrite( buf, 1, total_len, flashfile) )
		{
			CDCA_Err("fwrite file_3 error !\n");
                       if(buf)
                       {
                           free(buf);
                           buf = NULL;
                       }
                       return (1);
		}

		fclose( flashfile );
	}
	else
	{
		CDCA_Info("e2p file_3 exist. OK\n");
	}
#endif
       if(buf)
       {
           free(buf);
           buf = NULL;
       }
	return 0;
}


int xNVM_Read(unsigned char byBlockID, unsigned char *pdata, unsigned int* len)
{
	CDCA_Info("enter with byBlockID = %d, len=%d\n", byBlockID, *len);
	FILE *flashfile = NULL;
	int read;
	unsigned int length= *len;
	unsigned char ret = 1; // assume it will fail

	pthread_mutex_lock(&g_cdnvm_mutex);
	
	if(CDCA_FLASH_BLOCK_A == byBlockID)
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_A, "rb");
	}
	else if(CDCA_FLASH_BLOCK_B == byBlockID)
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_B, "rb");
	}	
        else
        {
		#ifndef ENABLE_SC
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_C, "rb");
		#endif
        }
        unsigned int totalLen = 0;
        fseek(flashfile, 0L, SEEK_END);
        totalLen = ftell(flashfile);
        CDCA_Info("byBlockID  = %d 's total length = %d \n", byBlockID, totalLen);

        
	if(flashfile==NULL)
	{
		CDCA_Err("open file failed!\n");
		goto xNVM_ReadEnd;
	}
	if( (fseek(flashfile,0,SEEK_SET)) != 0 )
	{
		CDCA_Err("fseek file failed!\n");
		fclose(flashfile);
		goto xNVM_ReadEnd;
	}
	if( (read = (fread(pdata,1,length,flashfile)) )< 0 )
	{
		CDCA_Err("fread file failed!");
		fclose(flashfile);
		goto xNVM_ReadEnd;
	}
	
	CDCA_Trace("\nread=%d\n",read);
#if 0 //for debug

	CDCA_Trace("\npdata = \n");
	int i;
	for(i=0; i<read; i++)
	{
		CDCA_Trace("%d:0x%x  ", i, pdata[i]);
		if(i==10) CDCA_Trace("\n");
	}
#endif

	fclose(flashfile);
	* len = read;
	ret =0;
	

xNVM_ReadEnd:
	pthread_mutex_unlock(&g_cdnvm_mutex);
	CDCA_Info("exit with byBlockID = %d, len=%d\n", byBlockID, *len);
	return ret;
}


int xNVM_Write(unsigned char byBlockID, const unsigned char *pdata, unsigned int len)
{
	CDCA_Info("enter with byBlockID = %d, len=%d\n", byBlockID, len);

	FILE *flashfile = NULL;
	int write;
	unsigned char ret = 1; // assume it will fail
	
	pthread_mutex_lock(&g_cdnvm_mutex);

	if(CDCA_FLASH_BLOCK_A == byBlockID)
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_A, "wb");
	}
	else if(CDCA_FLASH_BLOCK_B == byBlockID)
	{
		flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_B, "wb");
	}
       else
       {
	   #ifndef ENABLE_SC
        	flashfile = fopen(CDNVM_FOLDER CDNVM_DATA_C, "rb");
	   #endif
       }
	
	if(flashfile==NULL)
	{
		CDCA_Err("open file failed!\n");
		goto xNVM_WriteEnd;
	}

	if( (fseek(flashfile,0,SEEK_SET)) != 0 )
	{
		CDCA_Err("fseek file failed!\n");
		fclose(flashfile);
		goto xNVM_WriteEnd;
	}

	if( (write = (fwrite(pdata,1,len,flashfile))) < 0 )
	{
		CDCA_Err("fwrite file failed!\n");
		fclose(flashfile);
		goto xNVM_WriteEnd;
	}
	fclose(flashfile);
	ret = 0;

xNVM_WriteEnd:
	pthread_mutex_unlock(&g_cdnvm_mutex);
	CDCA_Info("exit with byBlockID = %d, len=%d\n", byBlockID, len);
	return ret;
}




void* CDSTBCA_Malloc(CDCA_U32 byBufSize )
{
	//CDCA_Trace("enter\n");
	void * p;
	if (0 == byBufSize)
	{
            return NULL;
	}
	p = (void *)malloc(byBufSize);
	if (NULL == p)
	{	
            CDCA_Err(" malloc is null\n");
            return NULL;
	}
	//CDCA_Trace("malloc : done. exit\n");
	return p;
}

void  CDSTBCA_Free(void* pBuf )
{
	//CDCA_Trace("enter\n");
	if(NULL == pBuf)
	{
            CDCA_Err("pBuf is null\n");
	}
	else
	{
            free(pBuf);
            pBuf = NULL;
	}
	//CDCA_Trace("free : done. exit\n");
}

void  CDSTBCA_Memset(void* pDestBuf, CDCA_U8  c, CDCA_U32 wSize )
{
	//CDCA_Trace("enter\n");
	if (NULL == pDestBuf)
	{
            CDCA_Err("null is param\n");
	}
	else
	{
            memset(pDestBuf, c, wSize);
	}
	//CDCA_Trace("memset : done. exit\n");
}

 void  CDSTBCA_Memcpy(void* pDestBuf, const void* pSrcBuf, CDCA_U32 wSize )
 {
	//CDCA_Trace("enter, wSize = %d[0x%x]\n", wSize, wSize);
	if (NULL == pDestBuf || NULL == pSrcBuf)
	{
            CDCA_Err("null is param\n");
	}
	else
	{
            memcpy(pDestBuf, pSrcBuf, wSize);
	}
	//CDCA_Trace("memcpy : done. exit\n");
 }


void CDSTBCA_ReadBuffer( CDCA_U8   byBlockID, CDCA_U8*  pbyData, CDCA_U32* pdwLen )
{
	CDCA_Trace("enter with byBlockID=%d, sizeof(*pbyData) = %d, dwLen=%d\n", byBlockID, sizeof(*pbyData), *pdwLen);
	if(xInit() != 0)
	{
		CDCA_Err(" Init nvm fail.\n");
		goto CDSTBCA_ReadBufferEnd;
	}
	
	CDCA_Trace("CDSTBCA_ReadBuffer:Read data from NVM file.\n");
	#ifdef ENABLE_SC
	if ((CDCA_FLASH_BLOCK_A != byBlockID && CDCA_FLASH_BLOCK_B !=  byBlockID  )
	#else 
	if ((CDCA_FLASH_BLOCK_A != byBlockID && CDCA_FLASH_BLOCK_B !=  byBlockID && CDCA_FLASH_BLOCK_C !=  byBlockID )
	#endif
		|| (CDNVM_MAX_SIZE < *pdwLen)
		|| (NULL == pbyData)
		|| (NULL == pdwLen))
	{
		CDCA_Err(" wrong parameters! byBlockID=%d, len=%d, pbyData=%p\n",  byBlockID, *pdwLen, pbyData);
		*pdwLen = 0;
		goto CDSTBCA_ReadBufferEnd;
	}
	
	if(xNVM_Read(byBlockID, pbyData, pdwLen) != 0)
	{
		CDCA_Err("ReadBuffer failed !\n");
		goto CDSTBCA_ReadBufferEnd;
	}
	CDCA_Trace("read exit OK\n");
	
CDSTBCA_ReadBufferEnd:
	return;
}

void CDSTBCA_WriteBuffer( CDCA_U8  byBlockID, const CDCA_U8* pbyData, CDCA_U32 dwLen )
{
	CDCA_Trace("enter with byBlockID=%d, sizeof(*pbyData) = %d, dwLen=%d\n", byBlockID, sizeof(*pbyData), dwLen);
	unsigned int length =dwLen;
    
	if(xInit() != 0)
	{
		CDCA_Err("Init nvm fail.\n");
		goto CDSTBCA_WriteBufferEnd;
	}
	
	if(CDNVM_MAX_SIZE < length)	
		length = CDNVM_MAX_SIZE;
	
	CDCA_Info("\nCDSTBCA_WriteBuffer:write data to NVM file.\n");
	#ifdef ENABLE_SC
	if ((CDCA_FLASH_BLOCK_A != byBlockID && CDCA_FLASH_BLOCK_B !=  byBlockID )
	#else
	if ((CDCA_FLASH_BLOCK_A != byBlockID && CDCA_FLASH_BLOCK_B !=  byBlockID &&  CDCA_FLASH_BLOCK_C !=  byBlockID)
	#endif
		|| (NULL == pbyData))
	{
		CDCA_Err("wrong parameters! byBlockID=%d, len=%d\n", byBlockID, length);
		goto CDSTBCA_WriteBufferEnd;
	}
	
	if(xNVM_Write(byBlockID, pbyData, length) != 0)
	{
		CDCA_Err("writeBuffer failed !\n");
		goto CDSTBCA_WriteBufferEnd;
	}
	CDCA_Trace("write exit OK\n");
	
CDSTBCA_WriteBufferEnd:
	return;
}

#ifndef ENABLE_SC
void CDSTBCA_LockService( const SCDCALockService* pLockService )
{
   CDCA_Trace("pcr_pid = 0x%x\n", pLockService->m_wPcrPid);

}

void CDSTBCA_UNLockService( void )
{
   CDCA_Trace("");

}
#endif
