/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_os.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA os related APIs
**-------------------------------------------------------------------------------
*/


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <semaphore.h>
#include <sys/types.h>
#include <errno.h>

#include "cdca_interface.h"

struct thread_info
{
	pthread_t thread_id;
	void (*entryPoint)(void);
};

CDCA_BOOL CDSTBCA_RegisterTask(const char*	szName,
	   CDCA_U8  	byPriority,
	   void*		pTaskFun,
	   void*      	pParam,
	   CDCA_U16  	wStackSize  
)
{
	CDCA_Trace("enter, name=%s, stack=%d, entry=0x%x, priority=%d, pParam=%d\n", 
		szName, wStackSize, pTaskFun, byPriority, pParam);
	CDCA_BOOL ret = CDCA_TRUE;
	int taskId;
	struct thread_info *p_tinfo = NULL;

	
	int err = 0;
	struct sched_param  sparam;
	pthread_attr_t      attr;
	pthread_attr_init(&attr);
	
	if( 0 != pthread_attr_setdetachstate( &attr, PTHREAD_CREATE_DETACHED)) 
	{
		CDCA_Err("pthread_attr_setdetachstate failed !\n");
		taskId = 0;
		pthread_attr_destroy( &attr );
		ret = CDCA_FALSE;
		goto CDSTBCA_RegisterTaskEnd;
	}
	memset(&sparam, 0, sizeof(struct sched_param));

	if ((CDCA_S32)byPriority >= 0){
		if ((CDCA_S32)byPriority < sched_get_priority_min(SCHED_RR))
			byPriority = sched_get_priority_min(SCHED_RR);
		if ((CDCA_S32)byPriority > sched_get_priority_max(SCHED_RR))
			byPriority = sched_get_priority_max(SCHED_RR);
		
		sparam.sched_priority = byPriority;
		///pthread_attr_setschedpolicy(&attr, SCHED_RR);
		///pthread_attr_setschedparam(&attr, &sparam);
		///pthread_attr_setstacksize(&attr,wStackSize);
	}
    
	p_tinfo = (struct thread_info *)malloc(sizeof(struct thread_info));
	if(NULL == p_tinfo)
	{
		CDCA_Err("No buffer for p_tinfo!\n");
		taskId = 0;
		pthread_attr_destroy( &attr );
		ret = CDCA_FALSE;
		goto CDSTBCA_RegisterTaskEnd;
	}
	err = pthread_create(&(p_tinfo->thread_id), &attr, (void* (*)(void*))pTaskFun, pParam);
	if((err!=0)) 
	{
		CDCA_Err("pthread_create failed\n");
		taskId = 0;
		pthread_attr_destroy(&attr);
		free(p_tinfo);
		ret = CDCA_FALSE;
		goto CDSTBCA_RegisterTaskEnd;
	}

	pthread_attr_destroy(&attr);
	
CDSTBCA_RegisterTaskEnd:
	CDCA_Debug("exit,name = %s, native thread id = 0x%lx\n", szName, p_tinfo->thread_id);
	
	return ret;
}

void CDSTBCA_Sleep(CDCA_U32 wMilliSeconds)
{
	///CDCA_Trace("enter with msToWait=%d\n", wMilliSeconds);

	if(wMilliSeconds==0)
	{
		goto CDSTBCA_SleepEnd;
	}
	else
	{
		usleep(wMilliSeconds*1000);
	}
CDSTBCA_SleepEnd:
	///CDCA_Trace(" exit  \n" );
	return;
}

void CDSTBCA_SemaphoreInit( CDCA_Semaphore* pSemaphore, CDCA_BOOL  bInitVal )
{
	///CDCA_Trace("enter with bInitVal=%d\n", bInitVal);
	unsigned int initialTokenCount = 1;

	if(CDCA_TRUE == bInitVal)
	{
		if(NULL == pSemaphore)
		{
			CDCA_Err( "NULL pSemaphore!\n" );
			goto CDSTBCA_SemaphoreInitEnd;
		}
		
		sem_t* psem = (sem_t*) malloc(sizeof(sem_t));
		if( NULL == psem )
		{
			CDCA_Err( "malloc failed !\n" );
			goto CDSTBCA_SemaphoreInitEnd;
		}

		if ( -1 == sem_init( psem, 0, initialTokenCount))
		{
			CDCA_Err( "sem_init failed !\n" );
			goto CDSTBCA_SemaphoreInitEnd;
		}

		*pSemaphore = (CDCA_U32 )psem;
	}
	else
	{
		goto CDSTBCA_SemaphoreInitEnd;
	}
	

CDSTBCA_SemaphoreInitEnd:
	///CDCA_Trace("exit with  *pSemaphore=0x%x, bInitVal=%d\n", *pSemaphore, bInitVal);
	return;

}


void CDSTBCA_SemaphoreWait( CDCA_Semaphore* pSemaphore )
{
	///CDCA_Trace("enter with *pSemaphore=0x%x\n", *pSemaphore);

	int semRet;
	CDCA_Semaphore Semaphore = * pSemaphore;

	semRet = sem_wait( (sem_t*)(Semaphore));
	///CDCA_Info ("sem_wait ret=%d!\n", semRet);
	if(0 != semRet)
	{
		CDCA_Err("sem_wait error, errorno = %d!\n", errno);
		goto CDSTBCA_SemaphoreWaitEnd;
	}
    
	* pSemaphore = Semaphore;
CDSTBCA_SemaphoreWaitEnd:
	///CDCA_Debug("exit with *pSemaphore=0x%x\n", *pSemaphore);
	return;

}

void CDSTBCA_SemaphoreSignal( CDCA_Semaphore* pSemaphore )
{
	///CDCA_Trace("enter with *pSemaphore=0x%0x\n", *pSemaphore);

	int semRet;
	CDCA_Semaphore Semaphore = * pSemaphore;

	semRet = sem_post((sem_t*)(Semaphore));
	if(0!=semRet)
	{
		CDCA_Err(" sem_post error, errorno = %d!\n", errno);
		goto CDCA_OSPSemaphoreReturnTokenEnd;
	}
	* pSemaphore = Semaphore;
CDCA_OSPSemaphoreReturnTokenEnd:

	///CDCA_Debug("exit with *pSemaphore=0x%x\n", *pSemaphore);
	return ;
}



