/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_dmx.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA dmx related APIs
**-------------------------------------------------------------------------------
*/
#include "cdca_interface.h"
#include "CDCASS.h"
#include "rtk_porting_util.h"
#include "rtk_hal_base.h"
#include "RTK_Node.h"

#include "Rtk_CDCa.h"
#include "cdca_common.h"
#include "cdca_sc.h"

//SmartCard
unsigned int m_SCRegisterHandle;
SC_RegInfo_t m_SCCallback;

void CDCA_SCEvent_CB(INT32_T a_pstEventInfo)
{
    	CDCA_Debug("a_pstEventInfo = %d!\n", (int)a_pstEventInfo);
#if defined(ENABLE_CA_LIB) && defined(ENABLE_SC)
	switch(a_pstEventInfo)
	{
		case RTK_EVENT_SC_OUT:
			CDCA_Trace("event = RTK_EVENT_SC_OUT!\n");
			CDCASTB_SCRemove();
			break;
		case RTK_EVENT_SC_IN:
			CDCA_Trace(" event = RTK_EVENT_SC_IN!\n");
			CDCASTB_SCInsert();
			break;
		case RTK_EVENT_SC_ERROR:
			CDCA_Trace("event = RTK_EVENT_SC_ERROR!\n");
			break;
		default:
			break;
	}

    #endif	
}

CDCA_S32 CDCA_SC_DRV_Initialize(void)
{
        CDCA_Trace("");
	if(RTK_OK == rtk_porting_smartcard_Initialize(RTK_SC_PROTOCOL_T0))
		return CDCA_TRUE;  
	else
		return CDCA_FALSE;
}

CDCA_S32 CDCA_SC_DRV_UnInitialize(void)
{
    CDCA_Trace("");
    if(RTK_OK == rtk_porting_smartcard_UnInitialize())
        return CDCA_TRUE;
    else
        return CDCA_FALSE;    
}

int CDCA_SC_DRV_RegisterEventHandler(SC_RegInfo_t *a_pstRegInfo, unsigned int *a_pHandle)
{
	 if(RTK_OK == rtk_porting_smartcard_Register((RTK_SC_RegInfo_t*) a_pstRegInfo, a_pHandle,3*1024))
	 	return 0;
	 else
	 	return -1;
}

int CDCA_SC_DRV_UnegisterEventHandler(unsigned int a_Handle)
{
	if(RTK_OK == rtk_porting_smartcard_Unregister(a_Handle))
		return 0;
	else
		return -1;
}
/*---------------------------------------------------------------------- 
 * Func : CDSC_GetCardStatus 
 *
 * Desc : check card present.
 *
 * Retn : CDCA_TRUE : card prenest / CDCA_FALSE : card removed
 *----------------------------------------------------------------------*/
CDCA_SC_STATUS CDCA_SC_GetCardStatus(void)
{
	if(RTK_OK ==rtk_porting_smartcard_GetCardStatus())
	{
	        CDCA_Trace("smartcard insert\n");
		return CDCA_SC_INSERT;
	}
	else
	{
	        CDCA_Trace("smartcard remove\n");
		return CDCA_SC_REMOVE;
	}
}

CDCA_BOOL CDSTBCA_SCReset( CDCA_U8* pbyATR, CDCA_U8* pbyLen )
{
    CDCA_Trace("enter...");
    if(RTK_OK == rtk_porting_smartcard_Reset(pbyATR, pbyLen))
    {
        CDCA_Trace("smartcard_Reset ok\n");
        return CDCA_TRUE;
    }
    else
        return CDCA_FALSE;
}


CDCA_BOOL CDSTBCA_SCPBRun( const CDCA_U8* pbyCommand,
                                                    CDCA_U16 wCommandLen, 
							CDCA_U8* pbyReply, 
							CDCA_U16* pwReplyLen)
{
    CDCA_Trace("enter");
    RTK_SC_Response pscResponse;
    pscResponse.u8pbyreply = pbyReply;
    pscResponse.u8pwReplyLen = (unsigned int *)pwReplyLen;
    pscResponse.u8pSW = (UINT16_T *) malloc(1*sizeof(UINT16_T));
    if(RTK_TRANSFER_OK == rtk_porting_smartcard_Transfer(pbyCommand,wCommandLen,
    					&pscResponse, RTK_SC_PROTOCOL_T0,RTK_TRUE))
    {
    	// add sw to pbyReply
    	*(pbyReply+(*pwReplyLen)) = 0xff & ((*pscResponse.u8pSW)>>8);
    	*(pbyReply+(*pwReplyLen+1)) = 0xff & (*pscResponse.u8pSW);
    	// add the length
    	*pwReplyLen = (*pwReplyLen) +2;
	#if 0
	
		CDCA_Debug("apdu lenght %d \n",*pwReplyLen);
		printf("\n");
		for(int i=0;i<*pwReplyLen;i++){
			if(i>0 && (i%8==0))
				printf("\n");
			printf(" %02X ", *(pbyReply+i));
			
		}
		printf("\n");
	#endif
		
        CDCA_Trace("exit");
    	return CDCA_TRUE;
    }
    else
    	return CDCA_FALSE;
}
        
CDCA_BOOL CDCA_Sc_Init()
{

    CDCA_BOOL  smcStatus = CDCA_TRUE;
    smcStatus = CDCA_SC_DRV_Initialize();
    if(smcStatus == CDCA_FALSE)
        return CDCA_FALSE;
    
    m_SCCallback.callback  = CDCA_SCEvent_CB;
    m_SCCallback.u32Tag = m_SCCallback.u32Tag + 0x10;

    smcStatus = (0 ==CDCA_SC_DRV_RegisterEventHandler(&m_SCCallback, &m_SCRegisterHandle))? CDCA_TRUE:CDCA_FALSE;
    CDCA_Trace(" CDCA_SC_DRV_RegisterEventHandler %s\n", (smcStatus ==0)?"False":"True");
    if(smcStatus == CDCA_FALSE)
        return CDCA_FALSE;

    return CDCA_TRUE;
}

void CDCA_Sc_Uninit()
{
    CDCA_SC_DRV_UnegisterEventHandler(m_SCRegisterHandle);
    CDCA_SC_DRV_UnInitialize();

    m_SCRegisterHandle = 0x01;
    m_SCCallback.callback= 0;
    m_SCCallback.u32Tag=0;
}

