
#ifdef  __cplusplus
extern "C" {
#endif
#include "rtk_efuse.h"
#include <tee_client_api_v25.h>
#include <tee_client_api_extensions.h>
#ifdef __cplusplus
}
#endif
#include "CDCASS.h"
#include "cdca_rDebug.h"
#include "cdca_sys.h"


#define CDCA_OTP_REG_BASE			(0x98017000)  
// Chip_ID,					7776,	128b,	3D8[31]~3CC[0]
//CDCA use 4byte only 
#define CDCA_OTP_CHIP_ID                    (CDCA_OTP_REG_BASE+0x3d8)
#define CDCA_CW_PDATA_LENGTH (122)
#define KLAD_LEN (16)
#define DEC (0)
#define ENC (1)
#define DTVK_NOT_READY 0xFF
#define MAX_TSID_NUMS (16)
#define NOT_USE_PID 0xFFFF // unsigned short
#define UNKNOWN_TSID_SIDX 0xFFFFFFFF


//
#define TP_PID_FILTER_COUNT  (128/2)

static TEEC_Context ctx;
static TEEC_Session sess;
static TEEC_UUID uuid = CDCA_SYS_UUID;
static unsigned char g_cdca_ta_status = TA_CDCA_STATUS_NOT_INIT;
static pthread_mutex_t	g_cdca_sys_mutex = PTHREAD_MUTEX_INITIALIZER;
static st_cdca_scramble_info g_pscrambleInfo[MAX_TSID_NUMS];
static st_cdca_emm_srcHdl g_emmSrcHdl[MAX_TSID_NUMS];

static unsigned int READ_REG32(unsigned int addr)
{
	unsigned char buf[4];
        
	rtk_efuse_read(addr-CDCA_OTP_REG_BASE, buf, 4);
        
	volatile unsigned int *ptr = (unsigned int *)buf;
	return *ptr;
}

static int  _KM_TEEC_STATUS(TEEC_Result res)
{
    switch(res)
    {
        case TEEC_SUCCESS: return CDCA_SYS_SUCCESS;
        default: return CDCA_SYS_FAIL;
    }
}

bool xDataValid(st_cdca_cw_info* cw_info)
{
    bool is_valid = false;
	bool is_valid_rootKey =false;
    for(int i=0;i<cw_info->bCwLen;i++)
    {
           if(cw_info->pOddCw[i]  != 0x00)
           {
                is_valid = true;
                break;
           }
    } 

	if(cw_info->bExtensionFlag !=0){
		switch(cw_info->klad_info.bKladRkId) 
		{
			case KLAD_CSAV2_ROOT_KEY:
			case KLAD_CSAV3_ROOT_KEY:
			case KLAD_AES_ROOT_KEY:
				is_valid_rootKey= true;
				break;
			default:
				CDCA_Err("Root key is invalid !!!! \n");
				is_valid_rootKey =false;
				break;
		}
	    
    }

    return (is_valid && is_valid_rootKey);
}

static int xParseData(unsigned char *pData, st_cdca_cw_info* cw_info)
{
        int ret = CDCA_SYS_SUCCESS;
        uint32_t i=0;
        uint8_t bIns =pData[0];
		
        i++;
        CDCA_Debug ("INS 0x%X , ",bIns);
        
        cw_info->tsid = (pData[1] <<8) | pData[2];
        i = i+2;
        CDCA_Debug (" tsid (0x%x) ID 0x%x,0x%x  , ",cw_info->tsid,pData[1],pData[2]);
		
        cw_info->bCwLen = pData[i];
        i ++;
        CDCA_Debug ("CW Length %d  , ",cw_info->bCwLen );
        
        for(int c=0;c<cw_info->bCwLen;c++){
                cw_info->pOddCw[c]  = pData[i];
                i++;
        }
        CDCA_Debug ("OddCW %02X%02X%02X%02X%02X%02X%02X%02X \n ",cw_info->pOddCw[0],cw_info->pOddCw[1]
                                        ,cw_info->pOddCw[2] ,cw_info->pOddCw[3],cw_info->pOddCw[4]
                                        ,cw_info->pOddCw[5],cw_info->pOddCw[6],cw_info->pOddCw[7]);
        
        for(int c=0;c<cw_info->bCwLen;c++){
                cw_info->pEvenCw[c]  = pData[i];
                i++;
        }
        CDCA_Debug ("EvenCW %02X%02X%02X%02X%02X%02X%02X%02X \n ",cw_info->pEvenCw[0],cw_info->pEvenCw[1]
                                        ,cw_info->pEvenCw[2] ,cw_info->pEvenCw[3],cw_info->pEvenCw[4]
                                        ,cw_info->pEvenCw[5],cw_info->pEvenCw[6],cw_info->pEvenCw[7]);
        
        cw_info->bTapingEnable = pData[i];
        i++;
        CDCA_Debug("Attribute  0x%x  \n",cw_info->bTapingEnable);
        
        cw_info->bExtensionFlag = pData[i];
        CDCA_Debug("Extension Flag 0x%x \n",cw_info->bExtensionFlag);
        i++;
        if(cw_info->bExtensionFlag)
            {
                cw_info->klad_info.bDecAlgo = pData[i];
                i++;
                CDCA_Debug("DescramAlgorithm 0x%x \n",cw_info->klad_info.bDecAlgo);
        
                cw_info->klad_info.bKladAlgo = pData[i];
                i++;
                CDCA_Debug("KLADAlgorithm 0x%x \n",cw_info->klad_info.bKladAlgo);
        
                cw_info->klad_info.bKladRkId = pData[i];
                i++;
                CDCA_Debug("KLADRootKeyID 0x%x \n",cw_info->klad_info.bKladRkId);
        
                cw_info->klad_info.bKladLevels = pData[i];
                i++;
                CDCA_Debug("KLADlevels 0x%x \n",cw_info->klad_info.bKladLevels);
        
                for(int c=1;c<cw_info->klad_info.bKladLevels;c++){
                        switch (c){
                            case EK1_K0:
                                for(int n=0;n<KLAD_LEN;n++){
                                    cw_info->klad_info.pEk1_k0[n]= pData[i];
                                    i++;
                                }
                                CDCA_Debug ("EK1 %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X \n",cw_info->klad_info.pEk1_k0[0],cw_info->klad_info.pEk1_k0[1]
                                        ,cw_info->klad_info.pEk1_k0[2] ,cw_info->klad_info.pEk1_k0[3],cw_info->klad_info.pEk1_k0[4]
                                        ,cw_info->klad_info.pEk1_k0[5],cw_info->klad_info.pEk1_k0[6],cw_info->klad_info.pEk1_k0[7]
                                        ,cw_info->klad_info.pEk1_k0[8],cw_info->klad_info.pEk1_k0[9],cw_info->klad_info.pEk1_k0[10]
                                        ,cw_info->klad_info.pEk1_k0[11],cw_info->klad_info.pEk1_k0[12],cw_info->klad_info.pEk1_k0[13]
                                        ,cw_info->klad_info.pEk1_k0[14],cw_info->klad_info.pEk1_k0[15]);
                                break;
        
                             case EK2_K1:
                                    for(int n=0;n<KLAD_LEN;n++){
                                        cw_info->klad_info.pEk2_k1[n]= pData[i];
                                        i++;
                                    }
                                    CDCA_Debug ("EK2 %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X \n",cw_info->klad_info.pEk2_k1[0],cw_info->klad_info.pEk2_k1[1]
                                        ,cw_info->klad_info.pEk2_k1[2] ,cw_info->klad_info.pEk2_k1[3],cw_info->klad_info.pEk2_k1[4]
                                        ,cw_info->klad_info.pEk2_k1[5],cw_info->klad_info.pEk2_k1[6],cw_info->klad_info.pEk2_k1[7]
                                        ,cw_info->klad_info.pEk2_k1[8],cw_info->klad_info.pEk2_k1[9],cw_info->klad_info.pEk2_k1[10]
                                        ,cw_info->klad_info.pEk2_k1[11],cw_info->klad_info.pEk2_k1[12],cw_info->klad_info.pEk2_k1[13]
                                        ,cw_info->klad_info.pEk2_k1[14],cw_info->klad_info.pEk2_k1[15]);
                                    break;
                              
                             case EK3_K2:
                                    for(int n=0;n<KLAD_LEN;n++){
                                        cw_info->klad_info.pEk3_k2[n]= pData[i];
                                        i++;
                                    }
                                    CDCA_Debug ("EK3 %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X \n",cw_info->klad_info.pEk3_k2[0],cw_info->klad_info.pEk3_k2[1]
                                        ,cw_info->klad_info.pEk3_k2[2] ,cw_info->klad_info.pEk3_k2[3],cw_info->klad_info.pEk3_k2[4]
                                        ,cw_info->klad_info.pEk3_k2[5],cw_info->klad_info.pEk3_k2[6],cw_info->klad_info.pEk3_k2[7]
                                        ,cw_info->klad_info.pEk3_k2[8],cw_info->klad_info.pEk3_k2[9],cw_info->klad_info.pEk3_k2[10]
                                        ,cw_info->klad_info.pEk3_k2[11],cw_info->klad_info.pEk3_k2[12],cw_info->klad_info.pEk3_k2[13]
                                        ,cw_info->klad_info.pEk3_k2[14],cw_info->klad_info.pEk3_k2[15]);
                                    break;
                             case EK4_K3:
                                    for(int n=0;n<KLAD_LEN;n++){
                                        cw_info->klad_info.pEk4_k3[n]= pData[i];
                                        i++;
                                    }
                                    CDCA_Debug ("EK4 %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X \n",cw_info->klad_info.pEk4_k3[0],cw_info->klad_info.pEk4_k3[1]
                                        ,cw_info->klad_info.pEk4_k3[2] ,cw_info->klad_info.pEk4_k3[3],cw_info->klad_info.pEk4_k3[4]
                                        ,cw_info->klad_info.pEk4_k3[5],cw_info->klad_info.pEk4_k3[6],cw_info->klad_info.pEk4_k3[7]
                                        ,cw_info->klad_info.pEk4_k3[8],cw_info->klad_info.pEk4_k3[9],cw_info->klad_info.pEk4_k3[10]
                                        ,cw_info->klad_info.pEk4_k3[11],cw_info->klad_info.pEk4_k3[12],cw_info->klad_info.pEk4_k3[13]
                                        ,cw_info->klad_info.pEk4_k3[14],cw_info->klad_info.pEk4_k3[15]);
                                    break;
                              default:
                                    CDCA_Err(" Klad error please check !!\n");
                                    ret = CDCA_SYS_FAIL;
                        }
                }
        }
        return ret;
}

static int xGetKeyInfo(uint32_t tsid, uint8_t is_enc,st_cdca_key_info* key_info)
{
    int ret = CDCA_SYS_SUCCESS;
    Rtk_Cas_DTVKey_t rtkKeyInfo;
    memset(&rtkKeyInfo,0,sizeof(Rtk_Cas_DTVKey_t));
    //TP_INSTANCE_ID tp_id ;
    unsigned char keyset_id = DTVK_NOT_READY;
    uint16_t keyslot_id ;
    int32_t km_state;

    rtk_porting_key_getKeyInfo(tsid,DEC,&rtkKeyInfo);
    keyslot_id = (uint16_t)rtkKeyInfo.slot_id;
    keyset_id = rtkKeyInfo.keyset_id;
    
    if(keyslot_id  == DTVK_NOT_READY)
    {
        KmGetKeySlotID(&km_state, &keyslot_id);
    }
    
    if(keyslot_id == DTVK_NOT_READY)
    {
        CDCA_Err("key slot should not be  0xFF!!\n");
        ret = CDCA_SYS_FAIL;
    }
    KmSetKeySlotID(&km_state, keyslot_id);
    KmGetKeyID(&km_state,keyslot_id,&keyset_id);
    
    key_info->keyset = keyset_id;
    key_info->keySlotId = keyslot_id;
    key_info->is_enc = is_enc;

    return ret;
}

static Rtk_Descrambler_Algorithm_ID_e xGetDescrambleAlgo(uint8_t bAlgo)
{
        Rtk_Descrambler_Algorithm_ID_e algo_id = (Rtk_Descrambler_Algorithm_ID_e)0xFF;
       
	switch(bAlgo) {
                case ALGO_00_TS_CSAV2:
                    algo_id = RTK_DESCRAMBLE_ALGO_CSA2;
                    break;
                case ALGO_01_TS_CSAV3:
                    algo_id = RTK_DESCRAMBLE_ALGO_CSA3;
                    break;
                case ALGO_02_TS_AES_128_ECB:
                    algo_id = RTK_DESCRAMBLE_ALGO_AES_128_ECB;
                    break;
                
                default:
                CDCA_Trace("NOT AltiProject Algorithm !\n");
                break;
	}
        return algo_id;
}
static int xSetCW(st_cdca_descramble_info* desc_info)
{
    int32_t km_state;
    TEEC_Result res = TEEC_ERROR_GENERIC;
    TEEC_Operation op;
    uint32_t uErrOrigin;
    
    Initialize_cdca_ta();

    pthread_mutex_lock(&g_cdca_sys_mutex);
    if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED){
        pthread_mutex_unlock(&g_cdca_sys_mutex);
        memset(&op,0,sizeof(op));
        
        op.paramTypes = TEEC_PARAM_TYPES(TEEC_MEMREF_TEMP_INPUT,TEEC_VALUE_OUTPUT,
                                        TEEC_NONE,TEEC_NONE);
        op.params[0].tmpref.buffer = (void *)desc_info;
        op.params[0].tmpref.size    = sizeof(st_cdca_descramble_info);
    
        res = TEEC_InvokeCommand(&sess, TA_CDCA_SYS_KM_SET_CW, &op, &uErrOrigin);
        if(res != TEEC_SUCCESS){
                CDCA_Err("TEEC_InvokeCommand failed with code  0x%x \n",res);
        }
        
        km_state = (int32_t)op.params[1].value.a;
        
        if(km_state != TEEC_SUCCESS){
                CDCA_Err(" Key Manager state 0x%x \n",km_state);
        }
    }else{
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            CDCA_Err(" CDCA TA is not init!!!\n");
    }
    return _KM_TEEC_STATUS(res);
}

int Initialize_cdca_ta()
{
        TEEC_Result res;
        uint32_t uErrOrigin;
        pthread_mutex_lock(&g_cdca_sys_mutex);
        if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED)
        {
                pthread_mutex_unlock(&g_cdca_sys_mutex);
                return CDCA_SYS_SUCCESS;
        }
        if(g_cdca_ta_status == TA_CDCA_STATUS_NOT_INIT)
        {
                res = TEEC_InitializeContext(NULL,&ctx);
                if(res != TEEC_SUCCESS){
                        CDCA_Err("TEEC_InitializeContext failed,code 0x%x \n",res);
                        g_cdca_ta_status = TA_CDCA_STATUS_NOT_EXIST;
                        pthread_mutex_unlock(&g_cdca_sys_mutex);

                        return -1;
                }
                res = TEEC_OpenSession(&ctx,&sess,&uuid,TEEC_LOGIN_PUBLIC,NULL,NULL,&uErrOrigin);
                if(res != TEEC_SUCCESS){
                        CDCA_Err("TEEC_OpenSession failed , code 0x%x",res);
                        TEEC_FinalizeContext(&ctx);
                        g_cdca_ta_status = TA_CDCA_STATUS_NOT_INIT;
                        pthread_mutex_unlock(&g_cdca_sys_mutex);
                        return -1;
                }
                g_cdca_ta_status = TA_CDCA_STATUS_OPENED;
        }
        pthread_mutex_unlock(&g_cdca_sys_mutex);
        CDCA_Debug( "Init success \n");
        return CDCA_SYS_SUCCESS;
}

void Finalize_cdca_ta()
{
        pthread_mutex_lock(&g_cdca_sys_mutex);
        if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED)
        {
                CDCA_Debug("\n");
                TEEC_CloseSession(&sess);
                TEEC_FinalizeContext(&ctx);
                g_cdca_ta_status = TA_CDCA_STATUS_NOT_INIT;
        }
        pthread_mutex_unlock(&g_cdca_sys_mutex);
}

int KmGetKeySlotID(int32_t *km_state, uint16_t *keyslot_id)
{
        TEEC_Result res = TEEC_ERROR_GENERIC;
        TEEC_Operation op;
        uint32_t uErrOrigin;

        Initialize_cdca_ta();
        pthread_mutex_lock(&g_cdca_sys_mutex);
        if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED){
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            memset(&op,0,sizeof(op));
            op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_OUTPUT,TEEC_NONE,
                                            TEEC_NONE,TEEC_NONE);
            
            res = TEEC_InvokeCommand(&sess, TA_CDCA_SYS_KM_GET_KEYSLOT, &op, &uErrOrigin);
            if(res != TEEC_SUCCESS){
                    CDCA_Err("TEEC_InvokeCommand failed with code  0x%x \n",res);
            }
            
            *km_state = (int32_t)op.params[0].value.a;
            *keyslot_id = (uint16_t)op.params[0].value.b;
            if(*km_state != TEEC_SUCCESS){
                    CDCA_Err(" Key Manager state 0x%x \n",*km_state);
            }
        }else{
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            CDCA_Err(" CDCA TA is not init!!!\n");
        }
        return _KM_TEEC_STATUS(res);
}

int KmSetKeySlotID(int32_t *km_state, uint16_t keyslot_id)
{
        TEEC_Result res = TEEC_ERROR_GENERIC;
        TEEC_Operation op;
        uint32_t uErrOrigin;

        Initialize_cdca_ta();
        pthread_mutex_lock(&g_cdca_sys_mutex);
        if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED){
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            memset(&op,0,sizeof(op));
            op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,TEEC_VALUE_INPUT,
                                        TEEC_VALUE_OUTPUT,TEEC_NONE);
            op.params[0].value.a = keyslot_id;
            op.params[0].value.b = 2; //pb 
            op.params[1].value.a = 2;//num_key;
            op.params[1].value.b = 0x101;// rootkey_id;
            res = TEEC_InvokeCommand(&sess, TA_CDCA_SYS_KM_SET_KEYSLOT, &op, &uErrOrigin);
            if(res != TEEC_SUCCESS){
                    CDCA_Err("TEEC_InvokeCommand failed with code  0x%x \n",res);
            }
            
            *km_state = (int32_t)op.params[2].value.a;
            if(*km_state != TEEC_SUCCESS){
                    CDCA_Err(" Key Manager state 0x%x \n",*km_state);
            }
        }else{
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            CDCA_Err(" CDCA TA is not init!!!\n");
        }
        return _KM_TEEC_STATUS(res);

}

int KmFreeKeySlotID(int32_t *km_state, uint16_t keyslot_id)
{
    TEEC_Result res = TEEC_ERROR_GENERIC;
    TEEC_Operation op;
    uint32_t uErrOrigin;
    
    Initialize_cdca_ta();
    pthread_mutex_lock(&g_cdca_sys_mutex);
    if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED){
        pthread_mutex_unlock(&g_cdca_sys_mutex);
        memset(&op,0,sizeof(op));
        op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,TEEC_VALUE_OUTPUT,
                                        TEEC_NONE,TEEC_NONE);
        op.params[0].value.a = keyslot_id;
        
        res = TEEC_InvokeCommand(&sess, TA_CDCA_SYS_KM_FREE_KEYSLOT, &op, &uErrOrigin);
        if(res != TEEC_SUCCESS){
                CDCA_Err("TEEC_InvokeCommand failed with code  0x%x \n",res);
        }
        
        *km_state = (int32_t)op.params[1].value.a;
        if(*km_state != TEEC_SUCCESS){
                CDCA_Err(" Key Manager state 0x%x \n",*km_state);
        }
    }else{
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            CDCA_Err(" CDCA TA is not init!!!\n");
    }
    return _KM_TEEC_STATUS(res);
}

int KmGetKeyID(int32_t *km_state, uint16_t keyslot_id, unsigned char *key_id)
{
    TEEC_Result res = TEEC_ERROR_GENERIC;
    TEEC_Operation op;
    uint32_t uErrOrigin;
    
    Initialize_cdca_ta();
    
    pthread_mutex_lock(&g_cdca_sys_mutex);
    if(g_cdca_ta_status == TA_CDCA_STATUS_OPENED){
        pthread_mutex_unlock(&g_cdca_sys_mutex);
        memset(&op,0,sizeof(op));
        op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT,TEEC_VALUE_OUTPUT,
                                        TEEC_NONE,TEEC_NONE);
        op.params[0].value.a = keyslot_id;

        res = TEEC_InvokeCommand(&sess, TA_CDCA_SYS_KM_GET_KEYID, &op, &uErrOrigin);
        if(res != TEEC_SUCCESS){
                CDCA_Err("TEEC_InvokeCommand failed with code  0x%x \n",res);
        }
        
        *km_state = (int32_t)op.params[1].value.a;
        *key_id = (unsigned char)op.params[1].value.b;
    
        if(*km_state != TEEC_SUCCESS){
                CDCA_Err(" Key Manager state 0x%x \n",*km_state);
        }
    }else{
            pthread_mutex_unlock(&g_cdca_sys_mutex);
            CDCA_Err(" CDCA TA is not init!!!\n");
    }
    return _KM_TEEC_STATUS(res);
}

int cdca_sys_GetChipId(unsigned int *chipId)
{
    unsigned int otp_value;
    otp_value = READ_REG32(CDCA_OTP_CHIP_ID);
    *chipId =(otp_value & 0xFF000000) >>24u
                    | (otp_value & 0xFF0000)  >>8u
                    |(otp_value & 0xFF00) <<8u
                    |(otp_value & 0xFF) <<24u;
    CDCA_Debug("chipId (0x%x) \n",*chipId);
    return CDCA_SYS_SUCCESS;
}

int cdca_sys_SetSrcCw(CDCA_U16 wEcmPID,
                    const CDCA_U8* pbyOddKey, 
                    const CDCA_U8* pbyEvenKey, 
                    CDCA_U8 byKeyLen,  
                    CDCA_BOOL bTapingEnabled)
{
    int ret =CDCA_SYS_SUCCESS;
    
    st_cdca_cw_info cw_info;
    st_cdca_key_info key_info;
    st_cdca_descramble_info desc_info;
    
    memset(&desc_info,0x00,sizeof(st_cdca_descramble_info));
    memset(&cw_info, 0x00, sizeof(st_cdca_cw_info));
    memset(&key_info,0x00,sizeof(st_cdca_key_info));
    cw_info.tsid = wEcmPID;
    cw_info.bCwLen = byKeyLen;
    memcpy(cw_info.pEvenCw,pbyEvenKey,byKeyLen);
    memcpy(cw_info.pOddCw,pbyOddKey,byKeyLen);
    cw_info.bTapingEnable = bTapingEnabled;
    cw_info.bExtensionFlag = false;
    ret =xGetKeyInfo(cw_info.tsid, DEC, &key_info);
	if(ret != CDCA_SYS_SUCCESS){
		CDCA_Err("get KeyInfo fail, pls check!! \n");
		ret = CDCA_SYS_FAIL;
		return ret;
	}
    
    CDCA_Debug("key_info.tp_id = %d, key_info.keySlotId =%d, key_info.keyset =%d, key_info.is_enc = %d \n",  key_info.tp_id, key_info.keySlotId, key_info.keyset, key_info.is_enc);
    desc_info.cw_info = cw_info;
    desc_info.key_info = key_info;
    
    xSetCW(&desc_info);
    ret = cdca_sys_setDescrambleInfo(&desc_info);
    return ret;
}

int cdca_sys_setDescrambleInfo(st_cdca_descramble_info* desc_info)
{
    int ret =CDCA_SYS_SUCCESS;
    Rtk_Descrambler_Algorithm_ID_e  algo;
    Rtk_CAS_DescrambleInfo_t casDescInfo;
    memset(&casDescInfo,0,sizeof(Rtk_CAS_DescrambleInfo_t));
    casDescInfo.tsid_sidx = desc_info->cw_info.tsid;
    casDescInfo.is_enc = DEC;
    casDescInfo.path = RTK_CAS_DESCRAMBLE_PATH_RT;
    if(desc_info->cw_info.bExtensionFlag){
            algo = xGetDescrambleAlgo(desc_info->cw_info.klad_info.bDecAlgo);
    }else{ //Clear key 
            algo = RTK_DESCRAMBLE_ALGO_CSA2;
    }
    casDescInfo.algo = algo;
    casDescInfo.key_set = desc_info->key_info.keyset;
    casDescInfo.key_slot = desc_info->key_info.keySlotId;
    casDescInfo.mode = Rtk_CAS_TSP_LEVEL_DESCRAMBLE;
    ret = rtk_porting_key_setDescrambleInfo(&casDescInfo);
    return ret;
}
int cdca_sys_SetSecureCw(unsigned char* pData)
{

    int ret =CDCA_SYS_SUCCESS;
    st_cdca_cw_info cw_info;
    st_cdca_key_info key_info;
    st_cdca_descramble_info desc_info;
    
    memset(&desc_info,0x00,sizeof(st_cdca_descramble_info));
    memset(&cw_info, 0x00, sizeof(st_cdca_cw_info));
    memset(&key_info,0x00,sizeof(st_cdca_key_info));
    
    xParseData(pData,  &cw_info);
    if(xDataValid(&cw_info) == false)
    {
        CDCA_Debug("CW invalid ...\n");
		cdca_sys_SetSrcCw(cw_info.tsid,desc_info.cw_info.pOddCw,
					desc_info.cw_info.pEvenCw,desc_info.cw_info.bCwLen,0);
		return ret;
    }
    xGetKeyInfo(cw_info.tsid, DEC, &key_info);
    CDCA_Debug("key_info.tp_id = %d, key_info.keySlotId =%d, key_info.keyset =%d, key_info.is_enc = %d \n",  key_info.tp_id, key_info.keySlotId, key_info.keyset, key_info.is_enc);
    desc_info.cw_info = cw_info;
    desc_info.key_info = key_info;
    xSetCW(&desc_info);
    ret=cdca_sys_setDescrambleInfo(&desc_info);
    return ret;
}

int cdca_sys_FreeKeySlotByTsid(uint32_t tsid)
{
	int ret =CDCA_SYS_FAIL;
	int32_t km_state;
	Rtk_Cas_DTVKey_t rtkKeyInfo;
    memset(&rtkKeyInfo,0,sizeof(Rtk_Cas_DTVKey_t));

    ret = rtk_porting_key_getKeyInfo(tsid,DEC,&rtkKeyInfo);
	
	if(ret != CDCA_SYS_SUCCESS){
		CDCA_Debug("key slot for tsid (0x%x) not found !!!\n", tsid);
		return ret;
	}
        KmFreeKeySlotID(&km_state, rtkKeyInfo.slot_id);
	if(km_state != TEEC_SUCCESS){
        CDCA_Err(" Key Manager state 0x%x \n",km_state);
		return CDCA_SYS_FAIL;
    }
    rtk_poring_key_updateField(tsid, DEC, RTK_KEY_FIELD_SLOT_ID, DTVK_NOT_READY);
    rtk_poring_key_updateField(tsid, DEC, RTK_KEY_FIELD_KEYSET_ID, DTVK_NOT_READY);
	

    return ret;
           
}

int cdca_sys_stopTpDescrambe(uint32_t tsid, Rtk_Descrambler_Mode_e mode)
{
    int ret =CDCA_SYS_FAIL;
    ret = rtk_porting_source_setDescrambleControl(tsid, mode);
	return ret;
}

void CDCA_Sys_Uninit()
{
   Finalize_cdca_ta();
#if 1
	pthread_mutex_lock(&g_cdca_sys_mutex);
   for(int i=0;i<MAX_TSID_NUMS;i++){
	   g_pscrambleInfo[i].tsid = UNKNOWN_TSID_SIDX;
	   g_pscrambleInfo[i].ecmPid = NOT_USE_PID;
	   g_pscrambleInfo[i].sourceHandle = NULL;
   }
   pthread_mutex_unlock(&g_cdca_sys_mutex);
#endif
}

CDCA_BOOL CDCA_Sys_Init()
{
    CDCA_Trace("sys_Init\n");
   
    INT32_T connRefs=0;

    if(rtk_porting_getClientConnectStatus(&connRefs)==RTK_HAL_FALSE)
    {
    	if(rtk_porting_connect_TvServer()!=RTK_SUCCESS)
    	{
    		CDCA_Err("connect Server failed!\n");
    		return CDCA_FALSE;
    	}
    }	
    
    INT8_T ret = 0;
    ret =(Initialize_cdca_ta() == CDCA_SYS_SUCCESS)?CDCA_TRUE:CDCA_FALSE;
    CDCA_Debug("init cdca ta. ret = %s\n", (ret == CDCA_TRUE)?"true":"false");

#if 1	
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		g_pscrambleInfo[i].tsid = UNKNOWN_TSID_SIDX;
		g_pscrambleInfo[i].ecmPid = NOT_USE_PID;
		g_pscrambleInfo[i].sourceHandle = NULL;
	}

        for(int i=0;i<MAX_TSID_NUMS;i++)
        {
            g_emmSrcHdl[i].descramble_id = -1;
            g_emmSrcHdl[i].emmpid = NOT_USE_PID;
            g_emmSrcHdl[i].sourceHandle = NULL;
        }
    pthread_mutex_unlock(&g_cdca_sys_mutex);
#endif
    return ret;
}

int cdca_sys_MapExmCreate(CDCA_U32 tsid, CDCA_U16 ecmPid,int sourceHandle)
{
	int ret = CDCA_SYS_FAIL;
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		if((g_pscrambleInfo[i].tsid == UNKNOWN_TSID_SIDX) && (g_pscrambleInfo[i].ecmPid == NOT_USE_PID))
		{
			g_pscrambleInfo[i].tsid =tsid;
			g_pscrambleInfo[i].ecmPid = ecmPid;
			g_pscrambleInfo[i].sourceHandle = (Source_Handle)sourceHandle;
			ret =CDCA_SYS_SUCCESS;
			break;
		}
	}
	if(ret!= CDCA_SYS_SUCCESS){
		CDCA_Err("No free slot for tsid found !!!\n");
	}
	pthread_mutex_unlock(&g_cdca_sys_mutex);
	return ret;
}

int cdca_sys_MapExmUpdateByParam(uint32_t tsid, cdca_scramble_e paramKey,uint32_t paramValue)
{
	int ret = CDCA_SYS_FAIL;
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		if(g_pscrambleInfo[i].tsid == tsid)
		{
			switch(paramKey){
				case CDCA_UPDATE_ECMPID:
					g_pscrambleInfo[i].ecmPid = (uint16_t)paramValue;
					break;
				case CDCA_UPDATE_SOURCE_HANDLE:
					g_pscrambleInfo[i].sourceHandle= (Source_Handle)paramValue;
					break;
			}
			
			ret =CDCA_SYS_SUCCESS;
			break;
		}
	}
	if(ret!= CDCA_SYS_SUCCESS){
		CDCA_Err("No free slot for tsid found !!!\n");
	}
	pthread_mutex_unlock(&g_cdca_sys_mutex);
	return ret;
}


int cdca_sys_MapExmRemoveByTsid(uint32_t tsid){
	int ret = CDCA_SYS_FAIL;
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		if(g_pscrambleInfo[i].tsid == tsid)
		{
			g_pscrambleInfo[i].tsid = UNKNOWN_TSID_SIDX;
			g_pscrambleInfo[i].ecmPid = NOT_USE_PID;
			g_pscrambleInfo[i].sourceHandle = NULL;
			ret =CDCA_SYS_SUCCESS;
			break;
		}
	}
	if(ret!= CDCA_SYS_SUCCESS){
		CDCA_Err("remove tsid(0x%x)fail !!!\n",tsid);
	}
	pthread_mutex_unlock(&g_cdca_sys_mutex);
	return ret;
}
int cdca_sys_MapExmQueryByParam(uint32_t tsid, cdca_scramble_e paramKey,uint32_t *paramValue){
	int ret = CDCA_SYS_FAIL;
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		if(g_pscrambleInfo[i].tsid == tsid)
		{
			switch(paramKey){
				case CDCA_UPDATE_ECMPID:
					*paramValue = g_pscrambleInfo[i].ecmPid;
					ret =CDCA_SYS_SUCCESS;
					break;
				case CDCA_UPDATE_SOURCE_HANDLE:
					*paramValue = (uint32_t)g_pscrambleInfo[i].sourceHandle;
					ret =CDCA_SYS_SUCCESS;
					break;
			}
		}
	}
	if(ret!= CDCA_SYS_SUCCESS){
		CDCA_Err("param (%d) for tsid (0x%x) not found !!!\n",paramKey,tsid);
	}
	pthread_mutex_unlock(&g_cdca_sys_mutex);
	return ret;
}

int cdca_sys_MapExmGetSourceHandle(uint32_t *scrHandle){
	int ret = CDCA_SYS_FAIL;
	pthread_mutex_lock(&g_cdca_sys_mutex);
	for(int i=0;i<MAX_TSID_NUMS;i++){
		if((g_pscrambleInfo[i].tsid != UNKNOWN_TSID_SIDX)
				&& (g_pscrambleInfo[i].ecmPid != NOT_USE_PID)
				&& (g_pscrambleInfo[i].sourceHandle != NULL))
		{
			*scrHandle = (uint32_t)g_pscrambleInfo[i].sourceHandle;
			ret = CDCA_SYS_SUCCESS;
			CDCA_Debug(" idx(%d)scrHandle (0x%x) \n",i,*scrHandle);
			break;
			
		}
	}
	pthread_mutex_unlock(&g_cdca_sys_mutex);
	return ret;
}

