#include <stddef.h>
#include <semaphore.h>
#include <time.h>
#include <stdio.h>
#include "CDCASS.h"
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include "cdca_rDebug.h"
#include "Rtk_CDCa.h"


extern "C" {

#define FILTER_MAX_LENGTH	16

#define __HWACOM_DEBUG__

#ifdef __HWACOM_DEBUG__
#define DBG_PRINT	 CDCA_Info
#else
#define DBG_PRINT(...)
#endif

/*-------- vH޲z -------*/
/* qvܤ */

void CDSTBCA_EntitleChanged( CDCA_U16 wTvsID )
{
	CDCA_Debug(" TvsID (0x%x) \n",wTvsID);
    Rtk_CDCA::CDSTBCA_EntitleChanged(wTvsID);
	return;
}

/* ϱv̻{Xq */

void CDSTBCA_DetitleReceived( CDCA_U8 bstatus )
{
	CDCA_Debug(" bstatus= %u \n",bstatus);
    Rtk_CDCA::CDSTBCA_DetitleReceived(bstatus);
	return;
}

/* IPPVܮ */
void CDSTBCA_HideIPPVDlg(CDCA_U16 wEcmPid)
{
	CDCA_Debug(" wEcmPid= 0x%x \n",wEcmPid);
	Rtk_CDCA::CDSTBCA_HideIPPVDlg(wEcmPid);
	return;
}

/*------- l/OSDܺ޲z -------*/
/*ܶW?OSDHA `NGpOSDInfo?NULLAܨOSD*/
void  CDSTBCA_ShowOSDInfo(SCDCAOSDInfo *pOSDInfo)
{
	UNUSED(*pOSDInfo);
	CDCA_Debug(" \n");
	Rtk_CDCA::CDSTBCA_ShowOSDInfo(pOSDInfo);
    return;
}

/*-------- ld --------*/
/* ШDŪiƾڵG */
void  CDSTBCA_RequestFeeding( CDCA_BOOL bReadStatus )
{
	CDCA_Debug(" ReadStatus = %d \n",bReadStatus);
	Rtk_CDCA::CDSTBCA_RequestFeeding(bReadStatus);
	return;
}

/*-------- jWD --------*/
/* WDw */
void CDSTBCA_LockService( const SCDCALockService* pLockService )
{
	CDCA_Debug("%s\n", __func__);
    Rtk_CDCA::CDSTBCA_LockService(pLockService);
	return;
}

/* ѰWDw */
void CDSTBCA_UNLockService( void )
{
	CDCA_Debug("%s\n", __func__);
	Rtk_CDCA::CDSTBCA_UNLockService();
	return;
}

/* Wū, pFingerInfo=NULL ܨWū*/
void CDSTBCA_ShowFingerInfo ( CDCA_U16 wEcmPID,
                              const SCDCAFingerInfo* pFingerInfo )
{
	CDCA_Debug(" ecmpid (0x%x) \n",wEcmPID);
    Rtk_CDCA::CDSTBCA_ShowFingerInfo (wEcmPID, pFingerInfo );
	return;
}

/*--------- Wq --------*/
/* qWܩŹw*/
void  CDSTBCA_ShowCurtainNotify( CDCA_U16 wEcmPID,
                                 CDCA_U16  wCurtainCode)
{
	CDCA_Debug(" ecmpid (0x%x),wCurtainCode (%d) \n",wEcmPID,wCurtainCode);
	Rtk_CDCA::CDSTBCA_ShowCurtainNotify(wEcmPID, wCurtainCode);
	return;
}

/* i */
void CDSTBCA_ShowProgressStrip( CDCA_U8 byProgress,
                                CDCA_U8 byMark )
{
	CDCA_Debug(" byProgress (%d),byMark (%d) \n",byProgress,byMark);
    Rtk_CDCA::CDSTBCA_ShowProgressStrip(byProgress, byMark);
	return;
}

/*-------- IPPV -------*/
/* IPPV`سq */
void CDSTBCA_StartIppvBuyDlg( CDCA_U8 byMessageType,
                              CDCA_U16 wEcmPid,
                              const SCDCAIppvBuyInfo* pIppvProgram  )
{
	UNUSED(*pIppvProgram);
	CDCA_Debug(" messageType (%d) ecmpid (0x%x) \n",byMessageType,wEcmPid);
	Rtk_CDCA::CDSTBCA_StartIppvBuyDlg(byMessageType, wEcmPid, pIppvProgram);
	return;
}

/*byType=0ܸTγs[ݭ, 
byType=1ܱҥγs[ݭ,ɡAwWorkTime(su@ɶA:p)MwStopTime(ɶA:)~ݭn]mWC 
byType=2ܨes[ݭ*/

void CDSTBCA_ContinuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime)
{
	CDCA_Debug("byType= %u, wWorkTime= %u (hr), wStopTime= %u (min)\n", byType, wWorkTime, wStopTime);
    Rtk_CDCA::CDSTBCA_ContinuesWatchLimit(byType, wWorkTime, wStopTime);
	return;
}

/*--------- eɶ --------*/
/*\^CDCA_TRUE,Ѫ^CDCA_FALSE*/
//The bias is the difference, in minutes, between Coordinated Universal Time (UTC) and local time, UTC = local time + bias
CDCA_BOOL  CDSTBCA_GetCurrentTime( CDCA_S32  *pUTCTime, CDCA_S32 *pTimeZoneBias, CDCA_S32 *pDaylightBias,  CDCA_BOOL* pInDaylight)
{
	struct tm lt = {0};
	time_t t;

	//DBG_PRINT("%d  %s:\n", __LINE__, __func__);

	t = time(NULL);
	if(-1 == t)
		return CDCA_FALSE;

	*pUTCTime = t;
	
	localtime_r(&t, &lt);
	*pTimeZoneBias = 0 - (lt.tm_gmtoff / 60);  /*minutes*/
	*pDaylightBias = 0;  // TBD
	if (lt.tm_isdst > 0)
		*pInDaylight = CDCA_TRUE;
	else
		*pInDaylight = CDCA_FALSE;

	//DBG_PRINT("%d  %s: %s\n", __LINE__, __func__, ctime(&t));
	return CDCA_TRUE;
}
}  /* extern "C" { */
