#ifndef CDCAS_CALIB_APIEX_H
#define CDCAS_CALIB_APIEX_H

#ifdef  __cplusplus
extern "C" {
#endif


/*----------------------------------------------------------------------------*/
typedef unsigned long long CDCA_U64;
typedef unsigned int       CDCA_U32;
typedef unsigned short     CDCA_U16;
typedef unsigned char      CDCA_U8;

typedef signed char        CDCA_S8;
typedef signed int         CDCA_S32;

typedef CDCA_U8            CDCA_BOOL;

#define CDCA_TRUE    ((CDCA_BOOL)1)
#define CDCA_FALSE   ((CDCA_BOOL)0)

/*----------------------------------------궨--------------------------------------*/

/*--------- FLASH -------*/
#define CDCA_FLASH_BLOCK_A        1     /* BLOCK A */
#define CDCA_FLASH_BLOCK_B        2     /* BLOCK B */
#define CDCA_FLASH_BLOCK_C        3     /* BLOCK C */

/*---------  --------*/
#define CDCA_MAXLEN_STBSN         12   /* кŵĳ */
#define CDCA_MAXLEN_STBSN_DEC     15   /* кŵĳȣʮƱʾ */
/*----------  ----------*/
#define CDCA_MAXNUM_PROGRAMBYCW   4    /* һĽĿ */

#define CDCA_MAXLEN_PINCODE       6    /* PINĳ */
#define CDCA_MAXNUM_OPERATOR      4    /* Ӫ̸ */
#define CDCA_MAXLEN_TVSPRIINFO    32   /* Ӫ˽Ϣĳ */
#define CDCA_MAXNUM_ACLIST        18   /* ÿӪ̵û */


#define CDCA_MAXNUM_ENTITLE       500  /* ȨƷ */


/*---------- CASʾϢ ---------*/
#define CDCA_MESSAGE_CANCEL_TYPE            0x00  /* ȡǰʾ */
#define CDCA_MESSAGE_NOOPER_TYPE            0x04  /* ֽ֧ĿӪ */
#define CDCA_MESSAGE_WATCHLEVEL_TYPE        0x07  /* Ŀ趨Ĺۿ */
#define CDCA_MESSAGE_NOENTITLE_TYPE         0x09  /* ûȨ */
#define CDCA_MESSAGE_DECRYPTFAIL_TYPE       0x0A  /* Ŀʧ */
#define CDCA_MESSAGE_ERRREGION_TYPE         0x0C  /* ȷ */
#define CDCA_MESSAGE_SCHIPFREEZE_TYPE       0x1A  /* ȫоƬѶᣬϵӪ */
#define CDCA_MESSAGE_SCHIPGROUPKEY_TYPE     0x1B  /* ȫоƬԿȱʧϵӪ */
#define CDCA_MESSAGE_STBLOCKED_TYPE         0x20  /*  */
#define CDCA_MESSAGE_STBFREEZE_TYPE         0x21  /* б */


/*---------- ܵ÷ֵ ----------*/
#define CDCA_RC_OK                    0x00  /* ɹ */
#define CDCA_RC_UNKNOWN               0x01  /* δ֪ */
#define CDCA_RC_POINTER_INVALID       0x02  /* ָЧ */
#define CDCA_RC_PIN_INVALID           0x04  /* PINЧ */
#define CDCA_RC_DATASPACE_SMALL       0x06  /* Ŀռ䲻 */
#define CDCA_RC_DATA_NOT_FIND         0x08  /* ûҵҪ */
#define CDCA_RC_WATCHRATING_INVALID   0x0E  /* 趨ĹۿЧ */
#define CDCA_RC_UNSUPPORT             0x22  /* ֧ */
#define CDCA_RC_LEN_ERROR             0x23  /* ȴ */
#define CDCA_RC_SCHIP_ERROR           0x24  /* ȫоƬô */

/*---------- ECM_PIDõĲ ---------*/
#define CDCA_LIST_OK          0x00
#define CDCA_LIST_FIRST       0x01
#define CDCA_LIST_ADD         0x02




/*------------ ʼС ------------*/
#define CDCA_MAXNUM_EMAIL         100  /* бʼ */
#define CDCA_MAXLEN_EMAIL_TITLE   30   /* ʼĳ */
#define CDCA_MAXLEN_EMAIL_CONTENT 160  /* ʼݵĳ */
/*------------ ʼͼʾʽ ------------*/
#define CDCA_Email_IconHide       0x00  /* ʼ֪ͨͼ */
#define CDCA_Email_New            0x01  /* ʼ֪ͨʾʼͼ */
#define CDCA_Email_SpaceExhaust   0x02  /* ̿ռͼ˸ */

/*------------ OSDĳ -----------*/
#define CDCA_MAXLEN_OSD           180   /* OSDݵ󳤶 */
/*------------ OSDʾ ------------*/
#define CDCA_OSD_TOP              0x01  /* OSDʾĻϷ */
#define CDCA_OSD_BOTTOM           0x02  /* OSDʾĻ· */
#define CDCA_OSD_FULLSCREEN       0x03  /* OSDʾ */
#define CDCA_OSD_HALFSCREEN       0x04  /* OSD񣺰ʾ */



/*---------- ƵӦض ---------*/
#define CDCA_MAXNUM_COMPONENT     5    /* Ŀ */
#define CDCA_MAXLEN_LOCKMESS      40

/*---------- CDSTBCA_ActionRequestExt ӿڲ ------------------------------*/
#define CDCA_ACTIONREQUEST_RESTARTSTB          0    /*  */
#define CDCA_ACTIONREQUEST_FREEZESTB           1    /*  */
#define CDCA_ACTIONREQUEST_SEARCHCHANNEL       2    /* Ŀ */
#define CDCA_ACTIONREQUEST_STBUPGRADE          3    /* г */
#define CDCA_ACTIONREQUEST_UNFREEZESTB         4    /*  */
#define CDCA_ACTIONREQUEST_INITIALIZESTB       5    /* ʼ */
#define CDCA_ACTIONREQUEST_SHOWSYSTEMINFO      6    /* ʾϵͳϢ */

#define CDCA_ACTIONREQUEST_DISABLEEPGADINFO    201  /* EPGϢ */
#define CDCA_ACTIONREQUEST_ENABLEEPGADINFO     202  /* ָEPGϢ */


/*------------------------------------------------------------------------*/




/*-------------------------------------end of 궨--------------------------------------*/



/*----------------------------------------ݽṹ----------------------------------------*/

/*-- ϵͳʱ --*/
typedef CDCA_U32  CDCA_TIME;
typedef CDCA_U16  CDCA_DATE;

/*-- ź壨ͬĲϵͳܲһ--*/
typedef CDCA_U32  CDCA_Semaphore;

/*-- ĿϢ --*/
/* Y10_update : ֻҪECMPIDServiceID */
typedef struct {
    CDCA_U16  m_wEcmPid;         /* ĿӦϢPID */
    CDCA_U8   m_byServiceNum;    /* ǰPIDµĽĿ */
    CDCA_U8   m_byReserved;      /*  */
    CDCA_U16  m_wServiceID[CDCA_MAXNUM_PROGRAMBYCW]; /* ǰPIDµĽĿIDб */
}SCDCASServiceInfo;


/*-- ӪϢ --*/
typedef struct {
    char     m_szTVSPriInfo[CDCA_MAXLEN_TVSPRIINFO+1];  /* Ӫ˽Ϣ */
    CDCA_U8  m_byReserved[3];    /*  */
}SCDCAOperatorInfo;


/*-- ȨϢ --*/
typedef struct {
    CDCA_U32  m_dwProductID;   /* ͨȨĽĿID */
    CDCA_DATE m_tBeginDate;    /* Ȩʼʱ */
    CDCA_DATE m_tExpireDate;   /* ȨĹʱ */
    CDCA_U8   m_bCanTape;      /* ûǷ¼1¼0¼ */
    CDCA_U8   m_byReserved[3]; /*  */
}SCDCAEntitle;

/*-- ȨϢ --*/
typedef struct {
    CDCA_U16      m_wProductCount;
    CDCA_U8       m_m_byReserved[2];    /*  */
    SCDCAEntitle  m_Entitles[CDCA_MAXNUM_ENTITLE]; /* Ȩб */
}SCDCAEntitles;


/*-- ʼͷ --*/
typedef struct {
    CDCA_U32   m_dwActionID;                             /* Email ID */
    CDCA_U32   m_tCreateTime;                            /* EMAILʱ */
    CDCA_U16   m_wImportance;                            /* Ҫԣ 0ͨ1Ҫ */
    CDCA_U8    m_byReserved[2];                          /*  */
    char       m_szEmailHead[CDCA_MAXLEN_EMAIL_TITLE+4]; /* ʼ */
    CDCA_U8    m_bNewEmail;                              /* ʼǣ0Ѷʼ1ʼ */
}SCDCAEmailHead;

/*-- ʼ --*/
typedef struct {
    char     m_szEmail[CDCA_MAXLEN_EMAIL_CONTENT+4];     /* Email */
    CDCA_U8  m_byReserved[3];                            /*  */
}SCDCAEmailContent;



/*-- ƵϢ --*/
/*-- ĿϢ --*/
typedef struct { /* ֪ͨнĿͼPIDϢһĿܰ */
    CDCA_U16   m_wCompPID;     /* PID */
    CDCA_U16   m_wECMPID;      /* ӦECMPIDǲŵģӦȡ0 */
    CDCA_U8    m_CompType;     /*  */
    CDCA_U8    m_byReserved[3];/*  */
}SCDCAComponent;


/*-- ƵϢ --*/
typedef struct {
    CDCA_U32   m_dwFrequency;              /* ƵʣBCD */
    CDCA_U32   m_symbol_rate;              /* ʣBCD */
    CDCA_U16   m_wPcrPid;                  /* PCR PID */
    CDCA_U8    m_Modulation;               /* Ʒʽ */
    CDCA_U8    m_ComponentNum;             /* Ŀ */
    SCDCAComponent m_CompArr[CDCA_MAXNUM_COMPONENT];       /* Ŀб */
    CDCA_U8    m_fec_outer;                /* ǰ */
    CDCA_U8    m_fec_inner;                /* ǰ */
    char       m_szBeforeInfo[CDCA_MAXLEN_LOCKMESS+1]; /*  */
    char       m_szQuitInfo[CDCA_MAXLEN_LOCKMESS+1];   /*  */
    char       m_szEndInfo[CDCA_MAXLEN_LOCKMESS+1];    /*  */
}SCDCALockService;
/*˵
a. ϵͳУm_dwFrequencym_symbol_rateʹBCD룬ǰȡMHzΪλ
   ʱǰ44-bit BCDʾСǰֵ44-bit BCDʾСֵ
   磺
        ƵΪ642000KHz642.0000MHzӦm_dwFrequencyֵӦΪ0x06420000
        Ϊ6875KHz6.8750MHzӦm_symbol_rateֵӦΪ0x00068750

b. ϵͳУm_Modulationȡֵ£
    0       Reserved
    1       QAM16
    2       QAM32
    3       QAM64
    4       QAM128
    5       QAM256
    6255  Reserved
*/



/*------------------------------------end of ݽṹ-------------------------------------*/



/*---------------------------½ӿCA_LIBṩSTB------------------------*/

/*------ CA_LIBȹ ------*/

/* CA_LIBʼ */
extern CDCA_BOOL CDCASTB_Init( CDCA_U8 byThreadPrior );

/* رCA_LIBͷԴ */
extern void CDCASTB_Close( void );

/* CDCASͬж */
extern CDCA_BOOL  CDCASTB_IsCDCa(CDCA_U16 wCaSystemID);

/*------ Flash ------ */

/* 洢ռĸʽ */
extern void CDCASTB_FormatBuffer( void );

/* ζԴ洢ռĶд */
extern void CDCASTB_RequestMaskBuffer(void);

/* 򿪶Դ洢ռĶд */
extern void CDCASTB_RequestUpdateBuffer(void);

/*------ TS ------*/

/* ECMͽĿϢ */
extern void CDCASTB_SetEcmPid( CDCA_U8 byType,
                               const SCDCASServiceInfo* pServiceInfo );

/* EMMϢ */
extern void  CDCASTB_SetEmmPid(CDCA_U16 wEmmPid);

/* ˽ݽջص */
extern void CDCASTB_PrivateDataGot( CDCA_U8        byReqID,
								  	CDCA_BOOL      bTimeout,
									CDCA_U16       wPid,
									const CDCA_U8* pbyReceiveData,
									CDCA_U16       wLen            );


/* ȡⲿ */
extern CDCA_U16 CDCASTB_GetSTBSN( char* pSTBSN );

/* PIN */
extern CDCA_U16 CDCASTB_ChangePin( const CDCA_U8* pbyOldPin,
                                   const CDCA_U8* pbyNewPin);

/* ûۿ */
extern CDCA_U16 CDCASTB_SetRating( const CDCA_U8* pbyPin,
                                   CDCA_U8 byRating );

/* ѯûۿ */
extern CDCA_U16 CDCASTB_GetRating( CDCA_U8* pbyRating );

/* ܿȫоƬʱ */
extern CDCA_U16 CDCASTB_SetWorkTime( const CDCA_U8* pbyPin,
									 CDCA_U8        byStartHour,
									 CDCA_U8        byStartMin,
									 CDCA_U8        byStartSec,
									 CDCA_U8        byEndHour,
									 CDCA_U8        byEndMin,
									 CDCA_U8        byEndSec    );

/* ѯܿȫоƬǰʱ */
extern CDCA_U16 CDCASTB_GetWorkTime( CDCA_U8* pbyStartHour,
									 CDCA_U8* pbyStartMin,
									 CDCA_U8* pbyStartSec,
									 CDCA_U8* pbyEndHour,
									 CDCA_U8* pbyEndMin,
									 CDCA_U8* pbyEndSec   );

/*------- Ϣѯ -------*/

/* ѯCA_LIB汾 */
extern CDCA_U32 CDCASTB_GetVer( void );

/* ѯӪIDб */
extern CDCA_U16 CDCASTB_GetOperatorIds( CDCA_U16* pwTVSID );

/* ѯӪϢ */
extern CDCA_U16 CDCASTB_GetOperatorInfo( CDCA_U16           wTVSID,
                                         SCDCAOperatorInfo* pOperatorInfo );

/* ѯû */
extern CDCA_U16 CDCASTB_GetACList( CDCA_U16 wTVSID, CDCA_U32* pACArray );


/* ѯCard versionֵ */
extern CDCA_U16 CDCASTB_GetCardVer(CDCA_U16 wTvsID, CDCA_U16* pwCardVer);

/* ѯͨȨĿ */
extern CDCA_U16 CDCASTB_GetServiceEntitles( CDCA_U16       wTVSID,
                                            SCDCAEntitles* pServiceEntitles );



/*CAͨòѯӿ*/
/*
˵:
    byType  :ѯ͡
    pInData :ݵַݿռɵ߷䡣
    pOutData:ݵַݿռɵ߷䡣
ֵCDCA_RC_OK 	ʾɹ
	    ֵ		ʾʧܣ鿴ͷļ"ܵ÷ֵ"
*/
extern CDCA_U16 CDCASTB_QuerySomething(CDCA_U8 byType,void * pInData, void * pOutData);



/*-------- ȨϢ --------*/

/* ѯȨIDб */
extern CDCA_U16 CDCASTB_GetEntitleIDs( CDCA_U16  wTVSID,
                                       CDCA_U32* pdwEntitleIds );


/* ѯƽ̨ */
extern CDCA_U16 CDCASTB_GetPlatformID( void );


/* ѯCASϵͳʱ */
CDCA_U32 CDCASTB_GetCASTime();



/*-------- ʼ --------*/

/* ѯʼͷϢ */
extern CDCA_U16 CDCASTB_GetEmailHeads( SCDCAEmailHead* pEmailHead,
                                       CDCA_U8*        pbyCount,
                                       CDCA_U8*        pbyFromIndex );

/* ѯָʼͷϢ */
extern CDCA_U16 CDCASTB_GetEmailHead( CDCA_U32        dwEmailID,
                                      SCDCAEmailHead* pEmailHead );

/* ѯָʼ */
extern CDCA_U16 CDCASTB_GetEmailContent( CDCA_U32           dwEmailID,
                                         SCDCAEmailContent* pEmailContent );

/* ɾʼ */
extern void CDCASTB_DelEmail( CDCA_U32 dwEmailID );

/* ѯʹ */
extern CDCA_U16 CDCASTB_GetEmailSpaceInfo( CDCA_U8* pbyEmailNum,
                                           CDCA_U8* pbyEmptyNum );




/*-------- ʾ --------*/

/* ˢ½ */
extern void CDCASTB_RefreshInterface( void );

/*-------- ˫ģӿ -------*/




/*------------------------ϽӿCA_LIBṩSTB---------------------------*/

/******************************************************************************/

/*------------------------½ӿSTBṩCA_LIB---------------------------*/

/*-------- ̹߳ --------*/

/* ע */
extern CDCA_BOOL CDSTBCA_RegisterTask( const char* szName,
                                       CDCA_U8     byPriority,
                                       void*       pTaskFun,
                                       void*       pParam,
                                       CDCA_U16    wStackSize  );

/* ̹߳ */
extern void CDSTBCA_Sleep(CDCA_U32 wMilliSeconds);


/*-------- ź --------*/

/* ʼź */
extern void CDSTBCA_SemaphoreInit( CDCA_Semaphore* pSemaphore,
                                   CDCA_BOOL       bInitVal );

/* źź */
extern void CDSTBCA_SemaphoreSignal( CDCA_Semaphore* pSemaphore );

/* źȡź */
extern void CDSTBCA_SemaphoreWait( CDCA_Semaphore* pSemaphore );


/*-------- ڴ --------*/

/* ڴ */
extern void* CDSTBCA_Malloc( CDCA_U32 byBufSize );

/* ͷڴ */
extern void  CDSTBCA_Free( void* pBuf );

/* ڴ渳ֵ */
extern void  CDSTBCA_Memset( void*    pDestBuf,
                             CDCA_U8  c,
                             CDCA_U32 wSize );

/* ڴ渴 */
extern void  CDSTBCA_Memcpy( void*       pDestBuf,
                             const void* pSrcBuf,
                             CDCA_U32    wSize );


/*--------- 洢ռ䣨Flash ---------*/

/* ȡ洢ռ */
extern void CDSTBCA_ReadBuffer( CDCA_U8   byBlockID,
                                CDCA_U8*  pbyData,
                                CDCA_U32* pdwLen );

/* д洢ռ */
extern void CDSTBCA_WriteBuffer( CDCA_U8        byBlockID,
                                 const CDCA_U8* pbyData,
                                 CDCA_U32       dwLen );


/*-------- TS --------*/

/* ˽ݹ */
extern CDCA_BOOL CDSTBCA_SetPrivateDataFilter( CDCA_U8        byReqID,
											   const CDCA_U8* pbyFilter,
											   const CDCA_U8* pbyMask,
											   CDCA_U8        byLen,
											   CDCA_U16       wPid,
											   CDCA_U8        byWaitSeconds );

/* ͷ˽ݹ */
extern void CDSTBCA_ReleasePrivateDataFilter( CDCA_U8  byReqID,
                                              CDCA_U16 wPid );



/*-------- ȫ --------*/

/* ȡΨһ */
extern void CDSTBCA_GetSTBID( CDCA_U16* pwPlatformID,
                              CDCA_U32* pdwUniqueID);

/* ȫоƬӿ(߰CW) */
extern CDCA_U16 CDSTBCA_SCFunction( CDCA_U8* pData);


/*------- ʼ/OSDʾ -------*/

/* ʼ֪ͨ */
extern void CDSTBCA_EmailNotifyIcon( CDCA_U8 byShow, CDCA_U32 dwEmailID );

/* ʾͨOSDϢ */
extern void CDSTBCA_ShowOSDMessage( CDCA_U8     byStyle,
                                    const char* szMessage );

/* OSDϢ*/
extern void CDSTBCA_HideOSDMessage( CDCA_U8 byStyle );





/*-------- ǿлƵ --------*/
/* Ƶ */
extern void CDSTBCA_LockService( const SCDCALockService* pLockService );

/* Ƶ */
extern void CDSTBCA_UNLockService( void );


/*-------- ʾ --------*/

/* տĿʾ */
/*wEcmPID==0ʾwEcmPID޹صϢ*/
extern void CDSTBCA_ShowBuyMessage( CDCA_U16 wEcmPID,
                                    CDCA_U8  byMessageType );



/* ָʾfingerMsg=NULL ʾȡָ*/
extern void CDSTBCA_ShowFingerMessageExt( CDCA_U16 wEcmPID,
                                      char* fingerMsg );

/*--------- ֪ͨ --------*/
/* ֪ͨ */
extern void  CDSTBCA_ActionRequestExt( CDCA_U16 wTVSID,
                                      CDCA_U8  byActionType,
                                      CDCA_U8 byLen,
                                      CDCA_U8* pbyData);





/*--------- ȡǰʱ --------*/
/*ȡɹCDCA_TRUE,ȡʧܷCDCA_FALSE*/
//The bias is the difference, in minutes, between Coordinated Universal Time (UTC) and local time, UTC = local time + bias
extern CDCA_BOOL  CDSTBCA_GetCurrentTime( CDCA_S32  *pUTCTime, CDCA_S32 *pTimeZoneBias, CDCA_S32 *pDaylightBias,  CDCA_BOOL* pInDaylight);






/*--------  --------*/

/* ȡַ */
extern CDCA_U16 CDSTBCA_Strlen(const char* pString );

/* Ϣ */
extern void CDSTBCA_Printf(CDCA_U8 byLevel, const char* szMesssage );

/* ݽAES CBC */
extern CDCA_BOOL CDSTBCA_AESCBC_Encrypt(CDCA_U8 *pPlainText, CDCA_U32 TextLen, CDCA_U8 *pCipherText);

/* ݽAES CBC */
extern CDCA_BOOL CDSTBCA_AESCBC_Decrypt(CDCA_U8 *pCipherText, CDCA_U32 TextLen, CDCA_U8 *pPlainText);

/*---------------------------ϽӿSTBṩCA_LIB------------------------*/

#ifdef  __cplusplus
}
#endif
#endif
/*EOF*/

