#ifndef CDCAS_CALIB_APIEX_H
#define CDCAS_CALIB_APIEX_H

#ifdef  __cplusplus
extern "C" {
#endif


/*----------------------------------------------------------------------------*/
typedef unsigned long long CDCA_U64;
typedef unsigned int       CDCA_U32;
typedef unsigned short     CDCA_U16;
typedef unsigned char      CDCA_U8;

typedef signed char        CDCA_S8;
typedef signed int         CDCA_S32;

typedef CDCA_U8            CDCA_BOOL;

#define CDCA_TRUE    ((CDCA_BOOL)1)
#define CDCA_FALSE   ((CDCA_BOOL)0)

/*----------------------------------------궨--------------------------------------*/

/*--------- FLASH -------*/
#define CDCA_FLASH_BLOCK_A        1     /* BLOCK A */
#define CDCA_FLASH_BLOCK_B        2     /* BLOCK B */

/*---------  --------*/
#define CDCA_MAXLEN_STBSN         12   /* кŵĳ */
#define CDCA_MAXLEN_STBSN_DEC     15   /* кŵĳȣʮƱʾ */
#define CDCA_MAXLEN_SN            16   /* ܿкŵĳ */
/*----------  ----------*/
#define CDCA_MAXNUM_PROGRAMBYCW   4    /* һĽĿ */


/*---------- CASʾϢ ---------*/
#define CDCA_MESSAGE_CANCEL_TYPE            0x00  /* ȡǰʾ */
#define CDCA_MESSAGE_BADCARD_TYPE           0x01  /* ޷ʶ */
#define CDCA_MESSAGE_EXPICARD_TYPE          0x02  /* ܿڣ¿ */
#define CDCA_MESSAGE_INSERTCARD_TYPE        0x03  /* ŽĿܿ */
#define CDCA_MESSAGE_NOOPER_TYPE            0x04  /* ֽ֧ĿӪ */
#define CDCA_MESSAGE_BLACKOUT_TYPE          0x05  /*  */
#define CDCA_MESSAGE_OUTWORKTIME_TYPE       0x06  /* ǰʱα趨Ϊܹۿ */
#define CDCA_MESSAGE_WATCHLEVEL_TYPE        0x07  /* Ŀ趨Ĺۿ */
#define CDCA_MESSAGE_PAIRING_TYPE           0x08  /* ܿ뱾вӦ */
#define CDCA_MESSAGE_NOENTITLE_TYPE         0x09  /* ûȨ */
#define CDCA_MESSAGE_DECRYPTFAIL_TYPE       0x0A  /* Ŀʧ */
#define CDCA_MESSAGE_NOMONEY_TYPE           0x0B  /* ڽ */
#define CDCA_MESSAGE_ERRREGION_TYPE         0x0C  /* ȷ */
#define CDCA_MESSAGE_NEEDFEED_TYPE          0x0D  /* ӿҪĸӦĸ */
#define CDCA_MESSAGE_ERRCARD_TYPE           0x0E  /* ܿУʧܣϵӪ */
#define CDCA_MESSAGE_UPDATE_TYPE            0x0F  /* ܿУ벻Ҫο߹ػ */
#define CDCA_MESSAGE_LOWCARDVER_TYPE        0x10  /* ܿ */
#define CDCA_MESSAGE_VIEWLOCK_TYPE          0x11  /* ƵлƵ */
#define CDCA_MESSAGE_MAXRESTART_TYPE        0x12  /* ܿʱߣ5Ӻ²忨 */
#define CDCA_MESSAGE_FREEZE_TYPE            0x13  /* ܿѶᣬϵӪ */
#define CDCA_MESSAGE_CALLBACK_TYPE          0x14  /* ܿͣشӼ¼Ӫ */
#define CDCA_MESSAGE_CURTAIN_TYPE           0x15  /* ߼ԤĿý׶βѹۿ */
#define CDCA_MESSAGE_CARDTESTSTART_TYPE     0x16  /* Կ...*/
#define CDCA_MESSAGE_CARDTESTFAILD_TYPE     0x17  /* ԿʧܣͨѶģ */
#define CDCA_MESSAGE_CARDTESTSUCC_TYPE      0x18  /* ԿԳɹ */
#define CDCA_MESSAGE_NOCALIBOPER_TYPE       0x19  /* вֲⶨӪ */
#define CDCA_MESSAGE_SCHIPFREEZE_TYPE       0x1A  /* ȫоƬѶᣬϵӪ */
#define CDCA_MESSAGE_SCHIPGROUPKEY_TYPE     0x1B  /* ȫоƬԿȱʧϵӪ */
#define CDCA_MESSAGE_STBLOCKED_TYPE         0x20  /*  */
#define CDCA_MESSAGE_STBFREEZE_TYPE         0x21  /* б */
#define CDCA_MESSAGE_UNSUPPORTDEVICE_TYPE   0x30  /* ֵ֧նͣţ0xXXXX*/


/*---------- ܵ÷ֵ ----------*/
#define CDCA_RC_OK                    0x00  /* ɹ */
#define CDCA_RC_UNKNOWN               0x01  /* δ֪ */
#define CDCA_RC_POINTER_INVALID       0x02  /* ָЧ */
#define CDCA_RC_CARD_INVALID          0x03  /* ܿЧ */
#define CDCA_RC_PIN_INVALID           0x04  /* PINЧ */
#define CDCA_RC_DATASPACE_SMALL       0x06  /* Ŀռ䲻 */
#define CDCA_RC_CARD_PAIROTHER        0x07  /* ܿѾӦĻ */
#define CDCA_RC_DATA_NOT_FIND         0x08  /* ûҵҪ */
#define CDCA_RC_PROG_STATUS_INVALID   0x09  /* ҪĽĿ״̬Ч */
#define CDCA_RC_CARD_NO_ROOM          0x0A  /* ܿûпռŹĽĿ */
#define CDCA_RC_WORKTIME_INVALID      0x0B  /* 趨ĹʱЧ */
#define CDCA_RC_IPPV_CANNTDEL         0x0C  /* IPPVĿܱɾ */
#define CDCA_RC_CARD_NOPAIR           0x0D  /* ܿûжӦκεĻ */
#define CDCA_RC_WATCHRATING_INVALID   0x0E  /* 趨ĹۿЧ */
#define CDCA_RC_CARD_NOTSUPPORT       0x0F  /* ǰִ֧ܿ˹ */
#define CDCA_RC_DATA_ERROR            0x10  /* ݴܾܿ */
#define CDCA_RC_FEEDTIME_NOT_ARRIVE   0x11  /* ιʱδӿܱι */
#define CDCA_RC_CARD_TYPEERROR        0x12  /* ĸιʧܣܿʹ */

#define CDCA_RC_CAS_FAILED            0x20  /* casִָʧ */
#define CDCA_RC_OPER_FAILED           0x21  /* Ӫִָʧ */
#define CDCA_RC_UNSUPPORT             0x22  /* ֧ */
#define CDCA_RC_LEN_ERROR             0x23  /* ȴ */
#define CDCA_RC_SCHIP_ERROR           0x24  /* ȫоƬô */

/*---------- ECM_PIDõĲ ---------*/
#define CDCA_LIST_OK          0x00
#define CDCA_LIST_FIRST       0x01
#define CDCA_LIST_ADD         0x02

/*-------------------------------------end of 궨--------------------------------------*/



/*----------------------------------------ݽṹ----------------------------------------*/

/*-- ϵͳʱ --*/
typedef CDCA_U32  CDCA_TIME;
typedef CDCA_U16  CDCA_DATE;

/*-- ź壨ͬĲϵͳܲһ--*/
typedef CDCA_U32  CDCA_Semaphore;

/*-- ĿϢ --*/
/* Y10_update : ֻҪECMPIDServiceID */
typedef struct {
    CDCA_U16  m_wEcmPid;         /* ĿӦϢPID */
    CDCA_U8   m_byServiceNum;    /* ǰPIDµĽĿ */
    CDCA_U8   m_byReserved;      /*  */
    CDCA_U16  m_wServiceID[CDCA_MAXNUM_PROGRAMBYCW]; /* ǰPIDµĽĿIDб */
}SCDCASServiceInfo;


/*------------------------------------end of ݽṹ-------------------------------------*/



/*---------------------------½ӿCA_LIBṩSTB------------------------*/

/*------ CA_LIBȹ ------*/

/* CA_LIBʼ */
extern CDCA_BOOL CDCASTB_Init( CDCA_U8 byThreadPrior );

/* رCA_LIBͷԴ */
extern void CDCASTB_Close( void );

/* CDCASͬж */
extern CDCA_BOOL  CDCASTB_IsCDCa(CDCA_U16 wCaSystemID);


/*------ TS ------*/

/* ECMͽĿϢ */
extern void CDCASTB_SetEcmPid( CDCA_U8 byType,
                               const SCDCASServiceInfo* pServiceInfo );


/* ˽ݽջص */
extern void CDCASTB_PrivateDataGot( CDCA_U8        byReqID,
								  	CDCA_BOOL      bTimeout,
									CDCA_U16       wPid,
									const CDCA_U8* pbyReceiveData,
									CDCA_U16       wLen            );

/*------- ܿ -------*/

/* ܿ */
extern CDCA_BOOL CDCASTB_SCInsert( void );

/* γܿ*/
extern void CDCASTB_SCRemove( void );

/* ȡܿⲿ */
extern CDCA_U16 CDCASTB_GetCardSN( char* pCardSN );


/*------- Ӧ -------*/

/* ѯӦ */
extern CDCA_U16 CDCASTB_IsPaired( CDCA_U8* pbyNum,
                                  CDCA_U8* pbySTBID_List );
/* ѯƽ̨ */
extern CDCA_U16 CDCASTB_GetPlatformID( void );


/*------------------------ϽӿCA_LIBṩSTB---------------------------*/

/******************************************************************************/

/*------------------------½ӿSTBṩCA_LIB---------------------------*/

/*-------- ̹߳ --------*/

/* ע */
extern CDCA_BOOL CDSTBCA_RegisterTask( const char* szName,
                                       CDCA_U8     byPriority,
                                       void*       pTaskFun,
                                       void*       pParam,
                                       CDCA_U16    wStackSize  );

/* ̹߳ */
extern void CDSTBCA_Sleep(CDCA_U32 wMilliSeconds);


/*-------- ź --------*/

/* ʼź */
extern void CDSTBCA_SemaphoreInit( CDCA_Semaphore* pSemaphore,
                                   CDCA_BOOL       bInitVal );

/* źź */
extern void CDSTBCA_SemaphoreSignal( CDCA_Semaphore* pSemaphore );

/* źȡź */
extern void CDSTBCA_SemaphoreWait( CDCA_Semaphore* pSemaphore );


/*-------- ڴ --------*/

/* ڴ */
extern void* CDSTBCA_Malloc( CDCA_U32 byBufSize );

/* ͷڴ */
extern void  CDSTBCA_Free( void* pBuf );

/* ڴ渳ֵ */
extern void  CDSTBCA_Memset( void*    pDestBuf,
                             CDCA_U8  c,
                             CDCA_U32 wSize );

/* ڴ渴 */
extern void  CDSTBCA_Memcpy( void*       pDestBuf,
                             const void* pSrcBuf,
                             CDCA_U32    wSize );


/*--------- 洢ռ䣨Flash ---------*/

/* ȡ洢ռ */
extern void CDSTBCA_ReadBuffer( CDCA_U8   byBlockID,
                                CDCA_U8*  pbyData,
                                CDCA_U32* pdwLen );

/* д洢ռ */
extern void CDSTBCA_WriteBuffer( CDCA_U8        byBlockID,
                                 const CDCA_U8* pbyData,
                                 CDCA_U32       dwLen );


/*-------- TS --------*/

/* ˽ݹ */
extern CDCA_BOOL CDSTBCA_SetPrivateDataFilter( CDCA_U8        byReqID,
											   const CDCA_U8* pbyFilter,
											   const CDCA_U8* pbyMask,
											   CDCA_U8        byLen,
											   CDCA_U16       wPid,
											   CDCA_U8        byWaitSeconds );


/* CW(Ǹ߰) */
extern void CDSTBCA_ScrSetCW( CDCA_U16       wEcmPID,
							  const CDCA_U8* pbyOddKey,
							  const CDCA_U8* pbyEvenKey,
							  CDCA_U8        byKeyLen,
							  CDCA_BOOL      bTapingEnabled );

/*--------- ܿ ---------*/

/* ܿλ */
extern CDCA_BOOL CDSTBCA_SCReset( CDCA_U8* pbyATR, CDCA_U8* pbyLen );

/* ܿͨѶ */
extern CDCA_BOOL CDSTBCA_SCPBRun( const CDCA_U8* pbyCommand,
								  CDCA_U16       wCommandLen,
								  CDCA_U8*       pbyReply,
								  CDCA_U16*      pwReplyLen  );



/*-------- ȫ --------*/

/* ȡΨһ */
extern void CDSTBCA_GetSTBID( CDCA_U16* pwPlatformID,
                              CDCA_U32* pdwUniqueID);

/* ȫоƬӿ(߰CW) */
extern CDCA_U16 CDSTBCA_SCFunction( CDCA_U8* pData);






/*-------- ʾ --------*/

/* տĿʾ */
/*wEcmPID==0ʾwEcmPID޹صϢ*/
extern void CDSTBCA_ShowBuyMessage( CDCA_U16 wEcmPID,
                                    CDCA_U8  byMessageType );














/*--------  --------*/

/* ȡַ */
extern CDCA_U16 CDSTBCA_Strlen(const char* pString );

/* Ϣ */
extern void CDSTBCA_Printf(CDCA_U8 byLevel, const char* szMesssage );


/*---------------------------ϽӿSTBṩCA_LIB------------------------*/

#ifdef  __cplusplus
}
#endif
#endif
/*EOF*/

