#ifndef CDCAS_CALIB_APIEX_H
#define CDCAS_CALIB_APIEX_H

#ifdef  __cplusplus
extern "C" {
#endif


/*-------------------------------------򩳸ƫO---------------------------------------*/
typedef unsigned long long CDCA_U64;
typedef unsigned int       CDCA_U32;
typedef unsigned short     CDCA_U16;
typedef unsigned char      CDCA_U8;

typedef signed char        CDCA_S8;
typedef signed int         CDCA_S32;

typedef CDCA_U8            CDCA_BOOL;

#define CDCA_TRUE    ((CDCA_BOOL)1)
#define CDCA_FALSE   ((CDCA_BOOL)0)

/*----------------------------------------wq--------------------------------------*/

/*--------- FLASH -------*/
#define CDCA_FLASH_BLOCK_A        1     /* BLOCK A */
#define CDCA_FLASH_BLOCK_B        2     /* BLOCK B */

/*---------  --------*/
#define CDCA_MAXLEN_STBSN         12   /* W */
#define CDCA_MAXLEN_STBSN_DEC     15   /* Wס]Qiܡ^ */
#define CDCA_MAXLEN_SN            16   /* zdǸ */
/*---------- W ----------*/
#define CDCA_MAXNUM_PROGRAMBYCW   4    /* @ӱr̦hѪ`ؼ */

#define CDCA_MAXLEN_PINCODE       6    /* PINX */
#define CDCA_MAXNUM_OPERATOR      4    /* ̦hBӭӼ */
#define CDCA_MAXLEN_TVSPRIINFO    32   /* BӨpT */
#define CDCA_MAXNUM_ACLIST        18   /* CӹBӪϥΪ̯SxӼ */

#define CDCA_MAXNUM_SLOT          20   /* dsx̤j] */

#define CDCA_MAXNUM_CURTAIN_RECORD  80 /* Źw`ذO̤jӼ */

#define CDCA_MAXNUM_IPPVP         300  /* zdOșhIPPV`تӼ */
#define CDCA_MAXNUM_PRICE         2    /* ̦hIPPVӼ */

#define CDCA_MAXNUM_ENTITLE       1000 /* v~̤jӼ */

#define CDCA_MAXNUM_DETITLE       5    /* CӹBӤUiOsϱvXӼ */

/*---------- CASܸT ---------*/
#define CDCA_MESSAGE_CANCEL_TYPE            0x00  /* e */
#define CDCA_MESSAGE_BADCARD_TYPE           0x01  /* LkѧOd */
#define CDCA_MESSAGE_EXPICARD_TYPE          0x02  /* zdLAЧ󴫷sd */
#define CDCA_MESSAGE_INSERTCARD_TYPE        0x03  /* [Z`ءAдJzd */
#define CDCA_MESSAGE_NOOPER_TYPE            0x04  /* 䴩`عB */
#define CDCA_MESSAGE_BLACKOUT_TYPE          0x05  /* T */
#define CDCA_MESSAGE_OUTWORKTIME_TYPE       0x06  /* eɬqQ]w[ */
#define CDCA_MESSAGE_WATCHLEVEL_TYPE        0x07  /* `دŧO]w[ݯŧO */
#define CDCA_MESSAGE_PAIRING_TYPE           0x08  /* zdPW */
#define CDCA_MESSAGE_NOENTITLE_TYPE         0x09  /* Sv */
#define CDCA_MESSAGE_DECRYPTFAIL_TYPE       0x0A  /* `ظѱK */
#define CDCA_MESSAGE_NOMONEY_TYPE           0x0B  /* dB */
#define CDCA_MESSAGE_ERRREGION_TYPE         0x0C  /* ϰ줣T */
#define CDCA_MESSAGE_NEEDFEED_TYPE          0x0D  /* ldݭnMdAдJd */
#define CDCA_MESSAGE_ERRCARD_TYPE           0x0E  /* zd祢ѡApôB */
#define CDCA_MESSAGE_UPDATE_TYPE            0x0F  /* zdɯŤAФnޥdΪ */
#define CDCA_MESSAGE_LOWCARDVER_TYPE        0x10  /* ФɯŴzd */
#define CDCA_MESSAGE_VIEWLOCK_TYPE          0x11  /* ФWcWD */
#define CDCA_MESSAGE_MAXRESTART_TYPE        0x12  /* zdȮɥvA5᭫sd */
#define CDCA_MESSAGE_FREEZE_TYPE            0x13  /* zdwᵲApôB */
#define CDCA_MESSAGE_CALLBACK_TYPE          0x14  /* zdwȰAЦ^ǦOB */
#define CDCA_MESSAGE_CURTAIN_TYPE           0x15  /* Źw`ءAӶqKO[ */
#define CDCA_MESSAGE_CARDTESTSTART_TYPE     0x16  /* ɯŴեdդ...*/
#define CDCA_MESSAGE_CARDTESTFAILD_TYPE     0x17  /* ɯŴեdեѡAˬddqTҲ */
#define CDCA_MESSAGE_CARDTESTSUCC_TYPE      0x18  /* ɯŴեdզ\ */
#define CDCA_MESSAGE_NOCALIBOPER_TYPE       0x19  /* dsbӮwwB */
#define CDCA_MESSAGE_SCHIPFREEZE_TYPE       0x1A  /* wwᵲApôB */
#define CDCA_MESSAGE_SCHIPGROUPKEY_TYPE     0x1B  /* wժ_ʥApôB */
#define CDCA_MESSAGE_STBLOCKED_TYPE         0x20  /* ЭҾW */
#define CDCA_MESSAGE_STBFREEZE_TYPE         0x21  /* WQᵲ */
#define CDCA_MESSAGE_UNSUPPORTDEVICE_TYPE   0x30  /* 䴩׺]sG0xXXXX^*/


/*---------- \եΪ^ȩwq ----------*/
#define CDCA_RC_OK                    0x00  /* \ */
#define CDCA_RC_UNKNOWN               0x01  /* ~ */
#define CDCA_RC_POINTER_INVALID       0x02  /* wL */
#define CDCA_RC_CARD_INVALID          0x03  /* zdL */
#define CDCA_RC_PIN_INVALID           0x04  /* PINXL */
#define CDCA_RC_DATASPACE_SMALL       0x06  /* ҵŶ */
#define CDCA_RC_CARD_PAIROTHER        0x07  /* zdwgOW */
#define CDCA_RC_DATA_NOT_FIND         0x08  /* Sҭn */
#define CDCA_RC_PROG_STATUS_INVALID   0x09  /* nʶR`تAL */
#define CDCA_RC_CARD_NO_ROOM          0x0A  /* zdSŶsʶR` */
#define CDCA_RC_WORKTIME_INVALID      0x0B  /* ]wu@ɬqL */
#define CDCA_RC_IPPV_CANNTDEL         0x0C  /* IPPV`ؤQR */
#define CDCA_RC_CARD_NOPAIR           0x0D  /* zdS󪺾W */
#define CDCA_RC_WATCHRATING_INVALID   0x0E  /* ]w[ݯŧOL */
#define CDCA_RC_CARD_NOTSUPPORT       0x0F  /* ezd䴩\ */
#define CDCA_RC_DATA_ERROR            0x10  /* ƿ~Azdڵ */
#define CDCA_RC_FEEDTIME_NOT_ARRIVE   0x11  /* iɶAldQi */
#define CDCA_RC_CARD_TYPEERROR        0x12  /* ldiѡAJzd~ */

#define CDCA_RC_CAS_FAILED            0x20  /* vdcasO楢 */
#define CDCA_RC_OPER_FAILED           0x21  /* vdBӫO楢 */
#define CDCA_RC_UNSUPPORT             0x22  /*  */
#define CDCA_RC_LEN_ERROR             0x23  /* ׿~ */
#define CDCA_RC_SCHIP_ERROR           0x24  /* w]m~ */

/*---------- ECM_PID]mާ@ ---------*/
#define CDCA_LIST_OK          0x00
#define CDCA_LIST_FIRST       0x01
#define CDCA_LIST_ADD         0x02


/*-- ŪdzdA --*/
#define CDCA_SC_OUT         0x00    /* ŪdSd          */
#define CDCA_SC_REMOVING    0x01    /* bޥdAmA      */
#define CDCA_SC_INSERTING   0x02    /* bdAl        */
#define CDCA_SC_IN          0x03    /* ŪdOiΪd      */
#define CDCA_SC_ERROR       0x04    /* ŪddѧO      */
#define CDCA_SC_UPDATE      0x05    /* Ūddiɯ */
#define CDCA_SC_UPDATE_ERR  0x06    /* Ūddɯť      */


/*------------ ljpμƶq ------------*/
#define CDCA_MAXNUM_EMAIL         100  /* WOs̤jlӼ */
#define CDCA_MAXLEN_EMAIL_TITLE   30   /* lD */
#define CDCA_MAXLEN_EMAIL_CONTENT 160  /* l󤺮e */
/*------------ lϥܤ覡 ------------*/
#define CDCA_Email_IconHide       0x00  /* ölqϥ */
#define CDCA_Email_New            0x01  /* slqAܷslϥ */
#define CDCA_Email_SpaceExhaust   0x02  /* ϺЪŶwAϥܰ{{ */

/*------------ OSD׭ -----------*/
#define CDCA_MAXLEN_OSD           256   /* OSDe̤j */
/*------------ OSD ------------*/
#define CDCA_OSD_TOP              0x01  /* OSDGܦbùW */
#define CDCA_OSD_BOTTOM           0x02  /* OSDGܦbùU */
#define CDCA_OSD_FULLSCREEN       0x03  /* OSDG */
#define CDCA_OSD_HALFSCREEN       0x04  /* OSDGb */


/*------------ IPPV/IPPTPʶRq -------------*/
#define CDCA_IPPV_FREEVIEWED_SEGMENT  0x00  /* IPPVKOwqAO_ʶR */
#define CDCA_IPPV_PAYVIEWED_SEGMENT   0x01  /* IPPVOqAO_ʶR */
#define CDCA_IPPT_PAYVIEWED_SEGMENT   0x02  /* IPPTOqAO_ʶR */

/*------------ IPPV ------------*/
#define CDCA_IPPVPRICETYPE_TPPVVIEW       0x0  /* ^ǡAv */
#define CDCA_IPPVPRICETYPE_TPPVVIEWTAPING 0x1  /* ^ǡAiv */

/*------------ IPPV`تA -----------*/
#define CDCA_IPPVSTATUS_BOOKING   0x01  /* ww */
#define CDCA_IPPVSTATUS_VIEWED    0x03  /* w */

/*---------- WDwάwq ---------*/
#define CDCA_MAXNUM_COMPONENT     5    /* `زե̤jӼ */
#define CDCA_MAXLEN_LOCKMESS      40

/*---------- CDSTBCA_ActionRequestExt Ѽ ------------------------------*/
#define CDCA_ACTIONREQUEST_RESTARTSTB          0    /* ҾW */
#define CDCA_ACTIONREQUEST_FREEZESTB           1    /* ᵲW */
#define CDCA_ACTIONREQUEST_SEARCHCHANNEL       2    /* sj` */
#define CDCA_ACTIONREQUEST_STBUPGRADE          3    /* W{ɯ */
#define CDCA_ACTIONREQUEST_UNFREEZESTB         4    /* ѰᵲW */
#define CDCA_ACTIONREQUEST_INITIALIZESTB       5    /* lƾW */
#define CDCA_ACTIONREQUEST_SHOWSYSTEMINFO      6    /* ܨtθT */

#define CDCA_ACTIONREQUEST_DISABLEEPGADINFO    201  /* TEPGsiT\ */
#define CDCA_ACTIONREQUEST_ENABLEEPGADINFO     202  /* _EPGsiT\ */

#define CDCA_ACTIONREQUEST_CARDINSERTFINISH    255  /* dBz */

/*------------------------------------------------------------------------*/


/*---------- ϱvT{Xάwq --------*/
#define CDCA_Detitle_All_Read     0x00  /* ҦϱvT{XwgQŪAùϥ */
#define CDCA_Detitle_Received     0x01  /* sϱvXAܤϱvXϥ */
#define CDCA_Detitle_Space_Small  0x02  /* ϱvXŶAܹϥܪAܨϥΪ */
#define CDCA_Detitle_Ignore       0x03  /* 쭫ƪϱvXAiABz */


/*---------- iױܸT ---------*/
#define CDCA_SCALE_RECEIVEPATCH   1     /* ɯŸƱ */
#define CDCA_SCALE_PATCHING       2     /* zdɯŤ */


/*---------- ŹwAX ---------*/
#define CDCA_CURTAIN_CANCLE          0x00  /*Źw*/
#define CDCA_CURTAIN_OK              0x01  /*Źw`إ`ѱK*/
#define CDCA_CURTAIN_TOTTIME_ERROR   0x02  /*Źw`ظTѱKGwgF`[ݮɪ*/
#define CDCA_CURTAIN_WATCHTIME_ERROR 0x03  /*Źw`ظTѱKGwgFWatchTime*/
#define CDCA_CURTAIN_TOTCNT_ERROR    0x04  /*Źw`ظTѱKGwgF`\[ݦ*/
#define CDCA_CURTAIN_ROOM_ERROR      0x05  /*Źw`ظTѱKGŹw`ذOŶ*/
#define CDCA_CURTAIN_PARAM_ERROR     0x06  /*Źw`ظTѱKG`ذѼƿ~*/
#define CDCA_CURTAIN_TIME_ERROR      0x07  /*Źw`ظTѱKGƿ~*/


/*---------- CDSTBCA_ContinuesWatchLimit Ѽ wq------------------------------*/
#define CDCA_ContinuesWatchLimit_Disable 0 /* ҥ */
#define CDCA_ContinuesWatchLimit_Enable  1 /* ҥ */
#define CDCA_ContinuesWatchLimit_Clear   2 /* e */
/*------------------------------------------------------------------------*/


/*-------------------------------------end of wq--------------------------------------*/



/*----------------------------------------Ƶc----------------------------------------*/

/*-- tήɶ --*/
typedef CDCA_U32  CDCA_TIME;
typedef CDCA_U16  CDCA_DATE;

/*-- Hqwq]P@~tΥiण@ˡ^--*/
typedef CDCA_U32  CDCA_Semaphore;

/*-- `ظT --*/
/* Y10_update : uݭnECMPIDMServiceIDYi */
typedef struct {
    CDCA_U16  m_wEcmPid;         /* `جTPID */
    CDCA_U8   m_byServiceNum;    /* ePIDU`حӼ */
    CDCA_U8   m_byReserved;      /* Od */
    CDCA_U16  m_wServiceID[CDCA_MAXNUM_PROGRAMBYCW]; /* ePIDU`IDC */
}SCDCASServiceInfo;


/*-- BӸT --*/
typedef struct {
    char     m_szTVSPriInfo[CDCA_MAXLEN_TVSPRIINFO+1];  /* BӨpT */
    CDCA_U8  m_byReserved[3];    /* Od */
}SCDCAOperatorInfo;


/*-- vT --*/
typedef struct {
    CDCA_U32  m_dwProductID;   /* qv`ID */
    CDCA_DATE m_tBeginDate;    /* v_lɶ */
    CDCA_DATE m_tExpireDate;   /* vLɶ */
    CDCA_U8   m_bCanTape;      /* ϥΪ̬O_ʶRvG1ХiHvF0ФiHv */
    CDCA_U8   m_byReserved[3]; /* Od */
}SCDCAEntitle;

/*-- vTX --*/
typedef struct {
    CDCA_U16      m_wProductCount;
    CDCA_U8       m_m_byReserved[2];    /* Od */
    SCDCAEntitle  m_Entitles[CDCA_MAXNUM_ENTITLE]; /* vC */
}SCDCAEntitles;

/*-- ]H --*/
typedef struct {
    CDCA_U32  m_wCreditLimit; /* HΫס]Iơ^*/
    CDCA_U32  m_wBalance;     /* w᪺I */
}SCDCATVSSlotInfo;

/*-- IPPV/IPPT`ت --*/
typedef struct {
    CDCA_U16  m_wPrice;       /* `ػ]Iơ^*/
    CDCA_U8   m_byPriceCode;  /* `ػ */
    CDCA_U8   m_byReserved;   /* Od */
}SCDCAIPPVPrice;

/*-- IPPV/IPPT`ʶRܸT --*/
typedef struct {
    CDCA_U32        m_dwProductID;          /* `تID */
    CDCA_U16        m_wTvsID;               /* BID */
    CDCA_U8         m_bySlotID;             /* ]ID */
    CDCA_U8         m_byPriceNum;           /* `ػӼ */
    SCDCAIPPVPrice  m_Price[CDCA_MAXNUM_PRICE]; /* `ػ */
    union {
        CDCA_DATE   m_wExpiredDate;         /* `عLɶ,IPPV */
        CDCA_U16    m_wIntervalMin;         /* ɶjA,IPPT  */
    }m_wIPPVTime;
    CDCA_U8         m_byReserved[2];        /* Od */
}SCDCAIppvBuyInfo;

/*-- IPPV`ظT --*/
typedef struct {
    CDCA_U32   m_dwProductID;   /* `تID */
    CDCA_U8    m_byBookEdFlag;  /* ~AGBOOKINGAVIEWED */
    CDCA_U8    m_bCanTape;      /* O_iHvG1ХiHvF0ФiHv */
    CDCA_U16   m_wPrice;        /* `ػ */
    CDCA_DATE  m_wExpiredDate;  /* `عLɶ,IPPV */
    CDCA_U8    m_bySlotID;      /* ]ID */
    CDCA_U8    m_byReserved;    /* Od */
}SCDCAIppvInfo;


/*-- lY --*/
typedef struct {
    CDCA_U32   m_dwActionID;                             /* Email ID */
    CDCA_U32   m_tCreateTime;                            /* EMAILЫتɶ */
    CDCA_U16   m_wImportance;                            /* nʡG 0дqA1Эn */
    CDCA_U8    m_byReserved[2];                          /* Od */
    char       m_szEmailHead[CDCA_MAXLEN_EMAIL_TITLE+4]; /* lD */
    CDCA_U8    m_bNewEmail;                              /* slаOG0ФwŪlF1зsl */
}SCDCAEmailHead;

/*-- l󤺮e --*/
typedef struct {
    char     m_szEmail[CDCA_MAXLEN_EMAIL_CONTENT+4];     /* Email */
    CDCA_U8  m_byReserved[3];                            /* Od */
}SCDCAEmailContent;

/* WOSD */
typedef struct{
    CDCA_U8     byDisplayMode;                 //ܼҦA 0GܿùܡA1GܿùWuܡA2GܿùUuܡALȫOd
    //HU5ӰѼƥubyDisplayMode0ɤ~ġC
    CDCA_U8     byShowType;                    //O_j 0:DjܡA1:jܡC
    CDCA_U8     byFontSize;                    //WOSDrjp 0Gq{A1GjA2GpA3~255ܹڦrjpjpCpGW䴩3~255hӹw]rjp
    CDCA_U8     byBackgroundArea;              //eùnʤAd]20~100^C
    CDCA_BOOL   bShowCardSN;                   //O_nDbWOSDUܥdA 0G 1G
    char        szCardSN[17];                  //zddA0rAbShowCardSN1ܡC`GdrjpWw]rjpC
    //HU3ӰѼƹbyDisplayMode0,1,2ġC
    CDCA_U32    dwFontColor;                   //rC
    CDCA_U32    dwBackgroundColor;             //IC
    char        szContent[CDCA_MAXLEN_OSD+4];  //WOSDeC`GuܮɦrjpWw]rjpC
}SCDCAOSDInfo;


/*-- WDwT --*/
/*-- `ؤT --*/
typedef struct { /* ΩqW`PIDTA@Ӹ`إi]thӤ */
    CDCA_U16   m_wCompPID;     /* եPID */
    CDCA_U16   m_wECMPID;      /* ECM]PIDApGO[ZAh0C */
    CDCA_U8    m_CompType;     /* ե */
    CDCA_U8    m_byReserved[3];/* Od */
}SCDCAComponent;


/*-- WDѼƸT --*/
typedef struct {
    CDCA_U32   m_dwFrequency;              /* WvABCDX */
    CDCA_U32   m_symbol_rate;              /* ŸvABCDX */
    CDCA_U16   m_wPcrPid;                  /* PCR PID */
    CDCA_U8    m_Modulation;               /* ջs覡 */
    CDCA_U8    m_ComponentNum;             /* `زեӼ */
    SCDCAComponent m_CompArr[CDCA_MAXNUM_COMPONENT];       /* `زեM */
    CDCA_U8    m_fec_outer;                /* eȿ~X */
    CDCA_U8    m_fec_inner;                /* eȿX */
    char       m_szBeforeInfo[CDCA_MAXLEN_LOCKMESS+1]; /* Od */
    char       m_szQuitInfo[CDCA_MAXLEN_LOCKMESS+1];   /* Od */
    char       m_szEndInfo[CDCA_MAXLEN_LOCKMESS+1];    /* Od */
}SCDCALockService;
/*G
a. tΤAѼm_dwFrequencyMm_symbol_rateϥBCDXAsXeMHzC
   sXɡAe44-bit BCDXܤpIeȡA44-bit BCDXܤpI᪺ȡC
   ҦpG
        YWv642000KHzAY642.0000MHzAhm_dwFrequency0x06420000F
        YŸv6875KHzAY6.8750MHzAhm_symbol_rate0x00068750C

b. tΤAm_ModulationȦpUG
    0       Reserved
    1       QAM16
    2       QAM32
    3       QAM64
    4       QAM128
    5       QAM256
    6255  Reserved
*/

/*-- ܸT--*/
typedef struct {
    CDCA_U8    byShowType;             //ܤ覡0Gr; 1GI}F2Gx}FLȫOdC
    CDCA_U8    byContentType;          // 1GWALȨɡC
    CDCA_BOOL  bIsVisible;             //i0GʡF1G
    CDCA_BOOL  bIsForcedShow;          //O_j 0GDj 1GjܡC
    CDCA_U8    byEncryption;           //[Ktk 0G[KFD0G[K
    CDCA_U16   wFlashing_EachShowTime; //C{{ܮɪA0ɪܤ{{C
    CDCA_U16   wFlashing_EachHideTime; //C{{ȰɪA0ɪܤ{{C
    CDCA_U8    byFontSize;             //rjpAȽd[0,255]A0ܹw]rjpA1ܤjrA2ܤprA3~255ܹڦrjpApGW3~255hӹw]rjpܡCbyShowType1M2ɪܫϰ쪺jpC
    CDCA_U8    byReserved;             //0x00   Od
    CDCA_U32   dwFontColor;            //rCAзRGBȡCbyShowType1ɸӭȵLNqC
    CDCA_U32   dwBackgroundColor;      //ICAзRGBȡAbyShowType1M2ɤnDC
    CDCA_U8    byX_position;           //ܦmXbyСAȽd0~100
    CDCA_U8    byY_position;           //ܦmYbyСAȽd0~100
    CDCA_U8    pbyMatrixInnerPos[16];  //byShowType2ɪܯx}CӦryЭȡCbyShowTypeLȮɦLNqC
    char       szContent[17];          //ݭnܪeA0rC
}SCDCAFingerInfo;

/*-- Źw`ظT --*/
typedef struct {
    CDCA_U16   m_wProgramID;         /* `تID */
    CDCA_TIME  m_dwStartWatchTime;   /* _l[ݮɶ */
    CDCA_U8    m_byWatchTotalCount;  /* ֭p[ݦ */
    CDCA_U16   m_wWatchTotalTime;    /* ֭p[ݮɪ,(cpg) */
}SCDCACurtainInfo;

/*------------------------------------end of Ƶc-------------------------------------*/



/*---------------------------HUOCA_LIBѵSTB------------------------*/

/*------ CA_LIBի׺޲z ------*/

/* CA_LIBl */
extern CDCA_BOOL CDCASTB_Init( CDCA_U8 byThreadPrior );

/* CA_LIBA귽 */
extern void CDCASTB_Close( void );

/* CDCASPKP_ */
extern CDCA_BOOL  CDCASTB_IsCDCa(CDCA_U16 wCaSystemID);

/*------ Flash޲z ------ */

/* sxŶ榡 */
extern void CDCASTB_FormatBuffer( void );

/* BnsxŶŪgާ@ */
extern void CDCASTB_RequestMaskBuffer(void);

/* }sxŶŪgާ@ */
extern void CDCASTB_RequestUpdateBuffer(void);

/*------ TSy޲z ------*/

/* ]mECMM`ظT */
extern void CDCASTB_SetEcmPid( CDCA_U8 byType,
                               const SCDCASServiceInfo* pServiceInfo );

/* ]mEMMT */
extern void  CDCASTB_SetEmmPid(CDCA_U16 wEmmPid);

/* pƱ^ */
extern void CDCASTB_PrivateDataGot( CDCA_U8        byReqID,
								  	CDCA_BOOL      bTimeout,
									CDCA_U16       wPid,
									const CDCA_U8* pbyReceiveData,
									CDCA_U16       wLen            );

/*------- zd޲z -------*/

/* Jzd */
extern CDCA_BOOL CDCASTB_SCInsert( void );

/* ޥXzd*/
extern void CDCASTB_SCRemove( void );

/* Ūzd~d */
extern CDCA_U16 CDCASTB_GetCardSN( char* pCardSN );

/* W~s */
extern CDCA_U16 CDCASTB_GetSTBSN( char* pSTBSN );

/* PINX޲z */
extern CDCA_U16 CDCASTB_ChangePin( const CDCA_U8* pbyOldPin,
                                   const CDCA_U8* pbyNewPin);

/* ]mΤ[ݯŧO */
extern CDCA_U16 CDCASTB_SetRating( const CDCA_U8* pbyPin,
                                   CDCA_U8 byRating );

/* dߥΤ[ݯŧO */
extern CDCA_U16 CDCASTB_GetRating( CDCA_U8* pbyRating );

/* ]mzdΦwu@ɬq */
extern CDCA_U16 CDCASTB_SetWorkTime( const CDCA_U8* pbyPin,
									 CDCA_U8        byStartHour,
									 CDCA_U8        byStartMin,
									 CDCA_U8        byStartSec,
									 CDCA_U8        byEndHour,
									 CDCA_U8        byEndMin,
									 CDCA_U8        byEndSec    );

/* dߴzdΦweu@ɬq */
extern CDCA_U16 CDCASTB_GetWorkTime( CDCA_U8* pbyStartHour,
									 CDCA_U8* pbyStartMin,
									 CDCA_U8* pbyStartSec,
									 CDCA_U8* pbyEndHour,
									 CDCA_U8* pbyEndMin,
									 CDCA_U8* pbyEndSec   );

/*------- 򥻸Td -------*/

/* dCA_LIB */
extern CDCA_U32 CDCASTB_GetVer( void );

/* d߹BIDC */
extern CDCA_U16 CDCASTB_GetOperatorIds( CDCA_U16* pwTVSID );

/* d߹BӸT */
extern CDCA_U16 CDCASTB_GetOperatorInfo( CDCA_U16           wTVSID,
                                         SCDCAOperatorInfo* pOperatorInfo );

/* dߨϥΪ̯Sx */
extern CDCA_U16 CDCASTB_GetACList( CDCA_U16 wTVSID, CDCA_U32* pACArray );

/* d߿]IDC */
extern CDCA_U16 CDCASTB_GetSlotIDs( CDCA_U16 wTVSID, CDCA_U8* pbySlotID );

/* d߿]ԲӸT */
extern CDCA_U16 CDCASTB_GetSlotInfo( CDCA_U16          wTVSID,
                                     CDCA_U8           bySlotID,
                                     SCDCATVSSlotInfo* pSlotInfo );

/* dߴzdᵲA*/
/*pbyStatusȻ:
    0: `;
    D0: ᵲ */
extern CDCA_U16 CDCASTB_GetCardFreezeStatus(CDCA_U16 wTvsID, CDCA_U8* pbyStatus);


/* dCard version */
extern CDCA_U16 CDCASTB_GetCardVer(CDCA_U16 wTvsID, CDCA_U16* pwCardVer);

/* dߴqv`ʶRp */
extern CDCA_U16 CDCASTB_GetServiceEntitles( CDCA_U16       wTVSID,
                                            SCDCAEntitles* pServiceEntitles );



/*CAqάdߤ*/
/*
Ѽƻ:
    byType  :dC
    pInData :JƦ}AƪŶѽեΪ̤tC
    pOutData:XƦ}AƪŶѽեΪ̤tC
^ȡGCDCA_RC_OK 	Gܦ\
	    L		GܥѡAdݼYɪ"\եΪ^ȩwq"
*/
extern CDCA_U16 CDCASTB_QuerySomething(CDCA_U8 byType,void * pInData, void * pOutData);


/*-- Źw`ʶROd(ե) --*/
/*
ѼƻG
	wTvsID	GBID
	pCurtainRecs	GŹwOСAnD}CjpCDCA_MAXNUM_CURTAIN_RECORDC
	pNumber	GXİOơAYqpCurtainRecs[0]}lӼơC

^ȡGCDCA_RC_OK 	Gܦ\
	    L		GܥѡAdݼYɪ"\եΪ^ȩwq"

*/
extern CDCA_U16 CDCASTB_GetCurtainRecords( CDCA_U16 wTvsID,
                                SCDCACurtainInfo* pCurtainRecs,
                                CDCA_U8* pNumber);


/*-------- vT޲z --------*/

/* d߱vIDC */
extern CDCA_U16 CDCASTB_GetEntitleIDs( CDCA_U16  wTVSID,
                                       CDCA_U32* pdwEntitleIds );

/* dߤϱvT{X */
extern CDCA_U16 CDCASTB_GetDetitleChkNums( CDCA_U16   wTvsID,
                                           CDCA_BOOL* bReadFlag,
                                           CDCA_U32*  pdwDetitleChkNums);

/* dߤϱvTŪA */
extern CDCA_BOOL CDCASTB_GetDetitleReaded( CDCA_U16 wTvsID );

/* RϱvT{X */
extern CDCA_BOOL CDCASTB_DelDetitleChkNum( CDCA_U16 wTvsID,
                                           CDCA_U32 dwDetitleChkNum );

/*------- d -------*/

/* d߾dp */
extern CDCA_U16 CDCASTB_IsPaired( CDCA_U8* pbyNum,
                                  CDCA_U8* pbySTBID_List );
/* d߾WOs */
extern CDCA_U16 CDCASTB_GetPlatformID( void );

/* d߲׺s */
extern CDCA_U16 CDCASTB_GetTerminalTypeID( void );

/* dCAStήɶ */
CDCA_U32 CDCASTB_GetCASTime();

/*-------- IPPV -------*/

/* IPPV`ʶR */
extern CDCA_U16 CDCASTB_StopIPPVBuyDlg( CDCA_BOOL       bBuyProgram,
                                        CDCA_U16        wEcmPid,
                                        const CDCA_U8*  pbyPinCode,
                                        const SCDCAIPPVPrice* pPrice );

/* IPPV`ʶRpd */
extern CDCA_U16 CDCASTB_GetIPPVProgram( CDCA_U16       wTvsID,
                                        SCDCAIppvInfo* pIppv,
                                        CDCA_U16*      pwNumber );


/*-------- l޲z --------*/

/* d߶lYT */
extern CDCA_U16 CDCASTB_GetEmailHeads( SCDCAEmailHead* pEmailHead,
                                       CDCA_U8*        pbyCount,
                                       CDCA_U8*        pbyFromIndex );

/* d߫wlYT */
extern CDCA_U16 CDCASTB_GetEmailHead( CDCA_U32        dwEmailID,
                                      SCDCAEmailHead* pEmailHead );

/* d߫wl󪺤e */
extern CDCA_U16 CDCASTB_GetEmailContent( CDCA_U32           dwEmailID,
                                         SCDCAEmailContent* pEmailContent );

/* Rl */
extern void CDCASTB_DelEmail( CDCA_U32 dwEmailID );

/* d߶lcϥαp */
extern CDCA_U16 CDCASTB_GetEmailSpaceInfo( CDCA_U8* pbyEmailNum,
                                           CDCA_U8* pbyEmptyNum );


/*-------- ld --------*/

/* ŪldH */
extern CDCA_U16 CDCASTB_GetOperatorChildStatus( CDCA_U16   wTVSID,
                                                CDCA_U8*   pbyIsChild,
                                                CDCA_U16*   pwDelayTime,
                                                CDCA_TIME* pLastFeedTime,
                                                char*      pParentCardSN,
                                                CDCA_BOOL *pbIsCanFeed );

/* Ūdi */
extern CDCA_U16 CDCASTB_ReadFeedDataFromParent( CDCA_U16 wTVSID,
                                                CDCA_U8* pbyFeedData,
                                                CDCA_U8* pbyLen     );

/* iƼgJld */
extern CDCA_U16 CDCASTB_WriteFeedDataToChild( CDCA_U16       wTVSID,
                                              const CDCA_U8* pbyFeedData,
                                              CDCA_U8        byLen    );


/*-------- ܤ޲z --------*/

/* s */
extern void CDCASTB_RefreshInterface( void );

/*-------- VҲդ -------*/




/*------------------------HWOCA_LIBѵSTB---------------------------*/

/******************************************************************************/

/*------------------------HUOSTBѵCA_LIB---------------------------*/

/*-------- ޲z --------*/

/* U */
extern CDCA_BOOL CDSTBCA_RegisterTask( const char* szName,
                                       CDCA_U8     byPriority,
                                       void*       pTaskFun,
                                       void*       pParam,
                                       CDCA_U16    wStackSize  );

/* _ */
extern void CDSTBCA_Sleep(CDCA_U32 wMilliSeconds);


/*-------- Hq޲z --------*/

/* lƫHq */
extern void CDSTBCA_SemaphoreInit( CDCA_Semaphore* pSemaphore,
                                   CDCA_BOOL       bInitVal );

/* HqH */
extern void CDSTBCA_SemaphoreSignal( CDCA_Semaphore* pSemaphore );

/* HqH */
extern void CDSTBCA_SemaphoreWait( CDCA_Semaphore* pSemaphore );


/*-------- O޲z --------*/

/* tO */
extern void* CDSTBCA_Malloc( CDCA_U32 byBufSize );

/* O */
extern void  CDSTBCA_Free( void* pBuf );

/* O */
extern void  CDSTBCA_Memset( void*    pDestBuf,
                             CDCA_U8  c,
                             CDCA_U32 wSize );

/* Oƻs */
extern void  CDSTBCA_Memcpy( void*       pDestBuf,
                             const void* pSrcBuf,
                             CDCA_U32    wSize );


/*--------- sxŶ]Flash^޲z ---------*/

/* ŪsxŶ */
extern void CDSTBCA_ReadBuffer( CDCA_U8   byBlockID,
                                CDCA_U8*  pbyData,
                                CDCA_U32* pdwLen );

/* gJsxŶ */
extern void CDSTBCA_WriteBuffer( CDCA_U8        byBlockID,
                                 const CDCA_U8* pbyData,
                                 CDCA_U32       dwLen );


/*-------- TSy޲z --------*/

/* ]mpƾڿz˵{ */
extern CDCA_BOOL CDSTBCA_SetPrivateDataFilter( CDCA_U8        byReqID,
											   const CDCA_U8* pbyFilter,
											   const CDCA_U8* pbyMask,
											   CDCA_U8        byLen,
											   CDCA_U16       wPid,
											   CDCA_U8        byWaitSeconds );

/* pƿz˵{ */
extern void CDSTBCA_ReleasePrivateDataFilter( CDCA_U8  byReqID,
                                              CDCA_U16 wPid );

/* ]mCWZ(Dw) */
extern void CDSTBCA_ScrSetCW( CDCA_U16       wEcmPID,
							  const CDCA_U8* pbyOddKey,
							  const CDCA_U8* pbyEvenKey,
							  CDCA_U8        byKeyLen,
							  CDCA_BOOL      bTapingEnabled );

/*--------- zd޲z ---------*/

/* zd_ */
extern CDCA_BOOL CDSTBCA_SCReset( CDCA_U8* pbyATR, CDCA_U8* pbyLen );

/* zdqT */
extern CDCA_BOOL CDSTBCA_SCPBRun( const CDCA_U8* pbyCommand,
								  CDCA_U16       wCommandLen,
								  CDCA_U8*       pbyReply,
								  CDCA_U16*      pwReplyLen  );

/*-------- vT޲z -------*/

/* qvܤ */
extern void CDSTBCA_EntitleChanged( CDCA_U16 wTvsID );


/* ϱvT{Xq */
extern void CDSTBCA_DetitleReceived( CDCA_U8 bstatus );



/*-------- w --------*/

/* ŪWߤ@s */
extern void CDSTBCA_GetSTBID( CDCA_U16* pwPlatformID,
                              CDCA_U32* pdwUniqueID);

/* w(tw]mCW) */
extern CDCA_U16 CDSTBCA_SCFunction( CDCA_U8* pData);

/*-------- IPPV -------*/

/* IPPV`سq */
extern void CDSTBCA_StartIppvBuyDlg( CDCA_U8                 byMessageType,
                                     CDCA_U16                wEcmPid,
                                     const SCDCAIppvBuyInfo* pIppvProgram  );

/* IPPVܤ */
extern void CDSTBCA_HideIPPVDlg(CDCA_U16 wEcmPid);

/*------- l/OSDܺ޲z -------*/

/* lq */
extern void CDSTBCA_EmailNotifyIcon( CDCA_U8 byShow, CDCA_U32 dwEmailID );

/* ܴqOSDT */
extern void CDSTBCA_ShowOSDMessage( CDCA_U8     byStyle,
                                    const char* szMessage );

/* OSDH*/
extern void CDSTBCA_HideOSDMessage( CDCA_U8 byStyle );

/*ܶWOSDTA `NGpOSDInfoNULLAܨOSD*/
extern void  CDSTBCA_ShowOSDInfo(SCDCAOSDInfo *pOSDInfo);



/*-------- ld --------*/

/* ШDŪiƵG */
extern void  CDSTBCA_RequestFeeding( CDCA_BOOL bReadStatus );


/*-------- jWD --------*/
/* WDw */
extern void CDSTBCA_LockService( const SCDCALockService* pLockService );

/* ѰWDw */
extern void CDSTBCA_UNLockService( void );


/*-------- ܤ޲z --------*/

/* ॿ`ݸ`ت */
/*wEcmPID==0ܻPwEcmPIDL*/
extern void CDSTBCA_ShowBuyMessage( CDCA_U16 wEcmPID,
                                    CDCA_U8  byMessageType );


/* Wū, pFingerInfo=NULL ܨWū*/
extern void CDSTBCA_ShowFingerInfo ( CDCA_U16 wEcmPID,
                         const SCDCAFingerInfo* pFingerInfo );

/* ܡAfingerMsg=NULL ܨ*/
extern void CDSTBCA_ShowFingerMessageExt( CDCA_U16 wEcmPID,
                                      char* fingerMsg );

/*--------- Wq --------*/
/* Wq */
extern void  CDSTBCA_ActionRequestExt( CDCA_U16 wTVSID,
                                      CDCA_U8  byActionType,
                                      CDCA_U8 byLen,
                                      CDCA_U8* pbyData);

/* qWܩŹw*/
extern void  CDSTBCA_ShowCurtainNotify( CDCA_U16 wEcmPID,
                                    CDCA_U16  wCurtainCode);

/* i */
extern void CDSTBCA_ShowProgressStrip( CDCA_U8 byProgress,
                                       CDCA_U8 byMark );



/*--------- s[ݭq --------*/
/*byType=0ܸTγs[ݭ,
 byType=1ܱҥγs[ݭ,ɡAwWorkTime(su@ɶA:p)MwStopTime(ɶA:)~ݭn]mWC
 byType=2ܨes[ݭ*/
extern void CDSTBCA_ContinuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime);

/*--------- eɶ --------*/
/*\^CDCA_TRUE,Ѫ^CDCA_FALSE*/
//The bias is the difference, in minutes, between Coordinated Universal Time (UTC) and local time, UTC = local time + bias
extern CDCA_BOOL  CDSTBCA_GetCurrentTime( CDCA_S32  *pUTCTime, CDCA_S32 *pTimeZoneBias, CDCA_S32 *pDaylightBias,  CDCA_BOOL* pInDaylight);






/*-------- 䥦 --------*/

/* r */
extern CDCA_U16 CDSTBCA_Strlen(const char* pString );

/* ոոTX */
extern void CDSTBCA_Printf(CDCA_U8 byLevel, const char* szMesssage );


/*---------------------------HWOSTBѵCA_LIB------------------------*/

#ifdef  __cplusplus
}
#endif
#endif
/*EOF*/


