#ifndef __RTK_EFUSE_H__
#define __RTK_EFUSE_H__

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdint.h>

#define EFUSE_DEV "/sys/bus/nvmem/devices/rtk-efuse0/nvmem"

/**
 * rtk_efuse_read - read efuse data into buf
 * @offset: offset of efuse data
 * @buf: buf for saving efuse data
 * @count: byte count
 *
 *  Returns 0 on success, -1 otherwise
 */
static inline
int rtk_efuse_read(uint32_t offset, uint8_t *buf, size_t count)
{
	int ret = -1;
	int fd = open(EFUSE_DEV, O_RDONLY);
	ssize_t size;

	if (fd < 0)
		return -1;

	lseek(fd, offset, SEEK_SET);
	size = read(fd, buf, count);
	if (size == count)
		ret = 0;
	close(fd);

	return ret;
}

#endif /* __RTK_EFUSE_H__ */

