/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name   : cdca_rDebug.cpp
** @Version     : 1.0
** @Author      : 
** @Created     : 2020-07-01
** @Description : CDCA log related APIs
**-------------------------------------------------------------------------------
*/
#include "cacd_rDebug.h"

#define TAG "CDCA_rtk"

void CDCA_Trace(const char *fmt, ...)
{
    if(get_log_level() >= 2)
    {
        va_list args;
        va_start(args, fmt);
        __android_log_vprint(ANDROID_LOG_VERBOSE, TAG, fmt, args);
        va_end(args);
    }
}

void CDCA_Debug(const char *fmt, ...)
{
    if(get_log_level() >= 1)
    {
        va_list args;
        va_start(args, fmt);
        __android_log_vprint(ANDROID_LOG_DEBUG, TAG, fmt, args);
        va_end(args);
    }
    
}

void CDCA_Info(const char *fmt, ...)
{
    if(get_log_level() >= 0)
    {
        va_list args;
        va_start(args, fmt);
        __android_log_vprint(ANDROID_LOG_INFO, TAG, fmt, args);
        va_end(args);
    }
}

void CDCA_Err(const char* fmt, ...)
{
    int  lev = get_log_level() ;
    if(lev >= 0)
    {
        va_list args;
        va_start(args, fmt);
        __android_log_vprint(ANDROID_LOG_ERROR, TAG, fmt, args);
        va_end(args);
    }
    else  //lev = -1 case
    {
        va_list args;
        va_start(args, fmt);
        vprintf(fmt, args);
        va_end(args);        
    }
}

int get_log_level()
{
    int lev = -1;
    char value[10] = "";

    const char dvdlog_property[] = "persist.vendor.dvdlog";

    int ret = __system_property_get(dvdlog_property, value); //0 means some error
    if(0 != ret)
    {
       lev = atoi(value);
    }
    //log lev [-1, 2]
    lev = (lev <= -1)? -1:lev;
    lev = (lev >= 2)? 2:lev;

    return lev;
}