
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "RTK_Node.h"


RTK_NODE* new_node(void)
{
	RTK_NODE* node = (RTK_NODE*)malloc(sizeof(RTK_NODE));

	if(node)
		memset(node, 0, sizeof(RTK_NODE));

	return node;
}

int insert_node(RTK_NODE** root, RTK_NODE* node)
{
	RTK_NODE *search_node;
	if(node == NULL)
		return RTK_NODE_NULL;

	if((*root) == NULL)
	{
		(*root) = node;
	}
	else
	{
		search_node = (*root);
		do
		{
			if(search_node->next == NULL)
			{
				search_node->next = node;
				break;
			}
			search_node = search_node->next;
		}
		while(search_node != NULL);
	}
	return RTK_NODE_OK;
}

int remove_node(RTK_NODE** root, RTK_NODE* node)
{
	RTK_NODE *search_node;

	if(node == NULL || *root == NULL)
		return RTK_NODE_NULL;

	if((*root) == node)
	{
		search_node = (*root);
		(*root)= (*root)->next;	//????
		free(search_node);
		search_node = NULL;
		return RTK_NODE_OK;
	}
	else
	{
		search_node = (*root);
		do
		{
			if(search_node->next == node)
			{
				search_node->next = node->next;
				free(node);
				node = NULL;
				return RTK_NODE_OK;
			}
			search_node = search_node->next;
		}
		while(search_node != NULL);

		//RTK_NODE_WARNNING("node not exist!\n");
		return RTK_NODE_NOT_FOUND;
	}
}

RTK_NODE* get_next_node(RTK_NODE* node)
{
	if(node == NULL) return NULL;

	return node->next;
}

void* get_node_data(RTK_NODE* node)
{
	if(node == NULL) return NULL;

	return node->data;
}
void set_node_data(RTK_NODE* node, void* data)
{
	if(node == NULL) return;

	node->data = data;
}
int get_node_num(RTK_NODE* root)
{
	RTK_NODE* search_node = root;
	int i=0;

	while(search_node != NULL)
	{
		i++;
		search_node = get_next_node(search_node);
	}
	return i;
}

