///////////////////////////////////////////////////////////////////////////////
// file:rtk_udp_hal.h
//
// @author: grace
///////////////////////////////////////////////////////////////////////////////
#ifndef __INC_RTK_UDP_HAL__
#define __INC_RTK_UDP_HAL__

////////////////////////////////////////////////////////////////////////////////
// includes
////////////////////////////////////////////////////////////////////////////////
#include "rtk_hal_base.h"
////////////////////////////////////////////////////////////////////////////////
// Macro definition
////////////////////////////////////////////////////////////////////////////////
/**
** @brief
**	This enum define socket type
*/
#define RECV_UDP_DATA_MAX_SIZE_ONCE (7*188*150)//1316*200
#define RECV_UDP_BUFF_MAX (20*1024*1024)//20MB

/**
** @brief
**	This enum define socket type
*/
typedef enum
{
	RTK_UDP_OK = 0,  /*!< every thing is OK.*/
	RTK_UDP_BUFFER_NOT_AVAILABLE, /*!< buffer is not avaliable*/
	RTK_UDP_Fail,  /*!< failed.*/
	RTK_UDP_DATA_NOT_ENOUGH,  /*!< data is not enough*/
	RTK_UDP_SOCKET_OPEN_Fail,  /*!< socket open failed.*/
}
RTK_UDP_Error;
	
typedef struct
{
	unsigned long	begin;
	unsigned long	end;
	unsigned long	readPtr;
	unsigned long	writePtr;
	unsigned char	buffer[RECV_UDP_BUFF_MAX];	// address must 8 bytes alignment
} RTK_UDP_Mem_Pool_t;
typedef struct
{
	RTK_SOCKET_t rtk_socket;
	pthread_t UDPRecvThread_t;
	UDPReceiver* udpReceiver;
	RTK_Bool got_sharebuf;
	RTK_UDP_Mem_Pool_t udp_mem_buffer;
} RTK_UDP_HANDLE_t;

RTK_UDP_Error RTK_UDPReceiver_Create(RTK_UDP_HANDLE_t **udp_handle, RTK_SOCKET_t* rtk_ocket);
RTK_UDP_Error RTK_UDPReceiver_Start(RTK_UDP_HANDLE_t* udp_handle);
RTK_UDP_Error RTK_UDPReceiver_ReadFromUDPShareBuffer(RTK_UDP_HANDLE_t* udp_handle, RTK_TSInputBuffer *buffer);
RTK_UDP_Error RTK_UDPReceiver_Destory(RTK_UDP_HANDLE_t* udp_handle);


#endif //__INC_SOCKET_CFG__
