/*
 * rtk_list.h
 *
 *  Created on: 2017. 5. 19.
 */

#ifndef __RTK_LIST_H__
#define __RTK_LIST_H__

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include "rtk_hal.h"

#ifdef __cplusplus
extern "C" {
#endif

// define structure
typedef struct _listnode
{
	RTK_SectionData* data;
    struct _listnode *next;
} ListNode;

typedef struct _list
{
    ListNode *front, *back;
    int size;
} List;

// Initialize and destroy list
List* createList();
void destroyList(List* list);

// Check whether list is empty
// if list is empty, return true
bool isEmpty(List* list);

ListNode* getFront(List* list);
ListNode* getBack(List* list);

// add node
void addFront(List* list, RTK_SectionData* node);
void addBack(List* list, RTK_SectionData* node);

// remove node
void removeFront(List* list);
void removeBack(List* list);

#ifdef __cplusplus
}
#endif
#endif //__RTK_LIST_H__
