/*****************************************************************************
 * Copyright (c) Realtek, Inc. All rights reserved.
 * FileName: RHAL_Base.cpp
 * Create Time: 2017. 5. 19.
 * Description:
 * Note:
 *****************************************************************************/
#include <stdio.h>

#if defined(USE_RTKHAL_IN_ANDROID8) ||defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10) || defined(__LINARO_SDK__) 
#include <rtk_ion.h>
#else
#include <ion.h> 
#endif

#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
#include <ext_rtk_ion.h>
#include<sys/types.h>
#include<sys/stat.h>
#endif

#if defined(USE_RTKHAL_IN_ANDROID8) ||defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10)
#include <SidebandClient.h>
#endif

#include <cutils/log.h>
//#include "rtk_porting_av.h"
//#include "rtk_porting_typedef.h"
#include "rtk_porting_rvsdSocket.h"
#include "NativeAudioRedirect.h"
#include "rtk_customer_interface.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include<sys/un.h>
#include <ctype.h>
#include <time.h>

#ifdef __ANDROID__
#include <sys/system_properties.h>
#endif

#if defined(USE_RTKHAL_IN_ANDROID9)
#include "VoutUtil.h"
#endif

#undef UNUSED
#define UNUSED(x)      ((void)(x))     /* to avoid warnings */
#include "rtk_monitor.h" // system_monitor
#include "RHAL_Base.h"
//#include<vector>;
#define PES_SHAHRE_FD00      "pes_share_fd00"
#define PES_SHAHRE_FD01      "pes_share_fd01"

#define RTK_HANDLE_FATAL_ERROR_EN	(1)
#define VIDEO_STOP_NON_BLOCK        (1)

#define USE_SIGNAL_HANDLER			// enable after code stablized; master branch need open it!!

#if defined(USE_SIGNAL_HANDLER)
#include "rtk_signal.h"
#endif

#if defined(USE_SIGNAL_HANDLER)
static int gSignalHappened=0;
#define MUTEX_CHECKSIG_AND_LOCK(x)  do {if(!gSignalHappened)pthread_mutex_lock(x);}while(0)
#define MUTEX_CHECKSIG_AND_UNLOCK(x)  do {if(!gSignalHappened)pthread_mutex_unlock(x);}while(0)
#else
#define MUTEX_CHECKSIG_AND_LOCK(x)	pthread_mutex_lock(x)
#define MUTEX_CHECKSIG_AND_UNLOCK(x)	pthread_mutex_unlock(x)
#endif

#define RTKHAL_INF_EN
#define RTKHAL_WRN_EN
#define RTKHAL_ERR_EN

#ifdef RTKHAL_INF_EN
#define RTKHAL_INF(fmt, args...)          ALOGD("[RTK_HAL][INF]" fmt, ##args)
#else
#define RTKHAL_INF(fmt, args...)
#endif
#ifdef RTKHAL_WRN_EN
#define RTKHAL_WRN(fmt, args...)          ALOGW("[RTK_HAL][WRN]" fmt, ##args)
#else
#define RTKHAL_WRN(fmt, args...)
#endif
#ifdef RTKHAL_ERR_EN
#define RTKHAL_ERR(fmt, args...)          ALOGE("[RTK_HAL][ERR]" fmt, ##args)
#else
#define RTKHAL_ERR(fmt, args...)
#endif

#define RTKHAL_DBG_GETTIME

static struct timeval start1={0, 0};
static struct timeval end1={0, 0};

static double timeuse =0;
static struct timeval zapping_start={0, 0};
static struct timeval zapping_start2={0, 0};
static struct timeval zapping_start3={0, 0};
static struct timeval zapping_end={0, 0};
double zapping_timeuse =0;


static bool pes_start_av_flag = 0;


static pthread_mutex_t RHAL_Base_mutex = PTHREAD_MUTEX_INITIALIZER;

#if defined(USE_RTKHAL_IN_ANDROID10)
static pthread_mutex_t surface_mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

#ifdef RTKHAL_DBG_GETTIME
#define RTK_GET_TIME(tp)						gettimeofday(tp, NULL)
#define RTK_GET_SPEND_TIME(start,end,spend) 		*(spend) = 1000000 * ((end)->tv_sec - (start)->tv_sec) + ((end)->tv_usec -(start)->tv_usec);
#define RTK_INFO_ZAPPING_TIME(infoStr,spend) 	RTKHAL_INF("[ZAPPING_TIME][%s] cost %f ms\n", (infoStr),(spend)/1000);
#else
#define RTK_GET_TIME(tp) 
#define RTK_GET_SPEND_TIME(start,end,spend) 
#define RTK_INFO_ZAPPING_TIME(infoStr,spend) 
#endif

#define MTP_TEST //need to mark when tuner source OK
#define ENABLE_TS_CALLBACK_RECORD

#define RTKHAL_MSG_INTERVAL			3*1000 // 3 sec
#define RTKHAL_INTER_ERR(last_time, fmt, args... ) \
if( _xRtk_pli_getMilliseconds() - last_time > RTKHAL_MSG_INTERVAL) \
{ \
	RTKHAL_ERR(fmt, args); \
	last_time = _xRtk_pli_getMilliseconds(); \
} \

#define PKT_SIZE 188
#define ALIGN_PKT_SIZE (PKT_SIZE*4) // 16-byte alignment
#define RTK_PACKET_LENGTH_SIZE		4
//#define RTK_MAX_DTVFLOW_NO (2)  //tuner source only can init once, need to modify
#define RTK_CHANNEL_0	(0) // dtvflow 0
#define RTK_CHANNEL_1	(1) // dtvflow 1
#define RTK_DEMUX_THREAD_SLEEP_S (10*1000)
#define RTK_CREATE_SLEEP_S (1*1000)
#define RTK_INPUT_FILE_ERROR_CONCEAL_LEVEL (4096)

#define DBMSWITCHTODBMV     49
#define DBSWITCHTODBM           (0.01)

#undef  GET_BANDWIDTH_STR
#define GET_BANDWIDTH_STR(x)			((x == Rtk_TUNER_BANDWIDTH_5M) ? "Bandwidth 5M" : \
										 (x == Rtk_TUNER_BANDWIDTH_6M) ? "Bandwidth 6M" : \
										 (x == Rtk_TUNER_BANDWIDTH_7M) ? "Bandwidth 7M" : \
										 (x == Rtk_TUNER_BANDWIDTH_8M) ? "Bandwidth 8M" : "unknow")

#define GET_LNBMODE_STR(x)				((x == RTK_LNB_MODE_OFF) ? "LNB_OFF" : \
										(x == RTK_LNB_MODE_13V) ? "LNB_13V" : \
										(x == RTK_LNB_MODE_18V) ? "LNB_18V" : \
										(x == RTK_LNB_MODE_13V_WITH_22K_BURST) ? "LNB_13V_WITH_22K_BURST" : \
										(x == RTK_LNB_MODE_18V_WITH_22K_BURST) ? "LNB_18V_WITH_22K_BURST" : "unknow")

#define TS_INVALID_PID (0x1FFF)
#define IS_VALID_AVPID(x)	(((x)!=-1) && ((x)!=0x1FFF) &&((x)!=0))

static const struct
{
	Hal_Key_UpdateMode_e hal_update_mode;
	Rtk_Key_UpdateMode_e rtk_update_mode;
}HAL_KEY_UPDATE_MODE_MAP[]={
		{HAL_UPDATE_DIRECTLY,RTK_UPDATE_DIRECTLY},
		{HAL_UPDATE_WAIT_FOR_DUAL_KEY,RTK_UPDATE_WAIT_FOR_DUAL_KEY},
		{HAL_UPDATE_WAIT_FOR_DUAL_KEY_IF_EXIST,RTK_UPDATE_WAIT_FOR_DUAL_KEY_IF_EXIST}
};

#ifdef ANDROID
sp<ANativeWindow> g_spNativeWindow[RTK_MAX_DTVFLOW_NO]; 	//two video windows
#endif

extern RHAL_Base * RHAL_GetHalInstance(void);
extern void RHAL_HalInstanceCleanup(void);

//support two dtvflow

static void _xRTK_HAL_Callback( HAL_HANDLE_S* pHandle, RTK_CallbackEvent event, void * data, UINT32_T data_size);

#define SET_MAIN_PLANE_V2 RTK_FALSE

// for test
//#ifndef SET_MAIN_PLANE_V2
#include <cutils/properties.h>
//#endif

/* determine whether the VO of this window id is set to V2 */
static RTK_Bool isPlaneV2Set(RTK_WinPlane id)
{
	RTK_Bool isV2 = RTK_FALSE;

#ifdef SET_MAIN_PLANE_V2
	isV2 = SET_MAIN_PLANE_V2;

#else // for test
	char pvalue[PROPERTY_VALUE_MAX];
	property_get("persist.media.mplane", pvalue, "0");
	isV2 = (pvalue[0] == '1') ? RTK_TRUE : RTK_FALSE;
#endif

	RTKHAL_INF("isV2 %d id %d", isV2, id);
	RTK_Bool setPlaneV2 = RTK_FALSE;

	if (id == RTK_WIN_MAIN)
	{
		setPlaneV2 = isV2;
	}
	else
	{
		setPlaneV2 = (isV2 == RTK_FALSE) ? RTK_TRUE : RTK_FALSE;
	}

	return setPlaneV2;
}


#if defined(USE_SIGNAL_HANDLER)
#if 0
#define MAX_RES_COUNT	(3)
pthread_mutex_t g_allocated_mutex;
static RTK_Player g_allocated_players[MAX_RES_COUNT];
static RTK_Demux g_allocated_demuxes[MAX_RES_COUNT];
static RTK_EmmDemux g_allocated_emmdmx[MAX_RES_COUNT];
static RTK_Bool g_cleanup = RTK_FALSE;
static RTK_Error add_allocated(void * array[], void * item)
{
	RTK_Error res = RTK_Fail;

	if(item == NULL)
		return RTK_Fail;

	pthread_mutex_lock(&g_allocated_mutex);
	if( g_cleanup == RTK_TRUE)
	{
		_xDestroy((HAL_HANDLE_S*)item);
	}
	else
	{
		size_t i = 0;
		for(i = 0; i < MAX_RES_COUNT; ++i)
		{
			if(array[i] == NULL)
			{
				array[i] = item;
				RTKHAL_INF("%s - add [%d]=%p\n", __FUNCTION__, i, item);
				res = RTK_OK;
				break;
			}
		}
	}
	pthread_mutex_unlock(&g_allocated_mutex);
	return res;
}

static RTK_Error remove_allocated(void * array[], void * item)
{
	RTK_Error res = RTK_Fail;

	if(item == NULL)
	{
		return res;
	}

	pthread_mutex_lock(&g_allocated_mutex);
	{
		size_t i = 0;
		for(i = 0; i < MAX_RES_COUNT; ++i)
		{
			if(array[i] == item)
			{
				RTKHAL_INF("%s - remove [%d]=%p\n", __FUNCTION__, i, item);
				array[i] = NULL;
				res = RTK_OK;
				break;
			}
		}
	}
	pthread_mutex_unlock(&g_allocated_mutex);

	return res;
}
#endif

static void cleanup_allocated(void)
{
	RTKHAL_INF("%s - enter\n", __FUNCTION__);
	gSignalHappened=1;
	size_t i = 0;
	//size_t count;
	HAL_HANDLE_S *pHandle;

	//-------------------------------------------------------------------------
	//	free player
	//-------------------------------------------------------------------------
	for(i = 0; i < RTK_MAX_DTVFLOW_NO; ++i)
	{
/*		
		//Exceptions sometimes occur because non-reentrant functions(such as printf) are called in interrupts
		pHandle = RHAL_GetHalInstance()->m_pCurHal_Handle[i];

		if(pHandle)
			RTKHAL_INF("%s - clean up player %p\n", __FUNCTION__, pHandle);
		
		if (pHandle)
		{
			_xRTK_HAL_Callback(pHandle, RTK_CLEANUP, NULL, 0);
		}
*/
		pHandle = RHAL_GetHalInstance()->m_pCurHal_Handle[i];	// pHandle must de assigned again, _xRTK_HAL_Callback() may update g_pCurPlayer_Handle[i]
		
		if(pHandle != NULL)
		{
			if(pHandle->type==HAL_TYPE_DEMUX_ONLY)
			{
				if(RTK_Demux_Stop((RTK_Demux)pHandle) != RTK_OK)
				{
					RTKHAL_ERR("clean up error\n");
				}

				#ifdef CLIENT_DTVSOURCE
				RTKHAL_INF("%s - unset source for demux %p\n", __FUNCTION__, pHandle);
				RHAL_GetHalInstance()->Demux_SetSource((RTK_Demux)pHandle, NULL);
				#endif
				
				RTKHAL_INF("%s - destroy demux %p\n", __FUNCTION__, pHandle);
				if(RTK_Demux_Destroy((RTK_Demux)pHandle) != RTK_OK)
				{
					RTKHAL_ERR("clean up error\n");	
				}
				RTKHAL_INF("%s - destroy demux %p done\n", __FUNCTION__, pHandle);
			}
			else 
			{
				if(RTK_Player_Stop((RTK_Player)pHandle, RTK_FALSE) != RTK_OK)
				{
					RTKHAL_ERR("clean up error\n");
				}

				/* Added by hai_huang for DHCHANK-905 */
				if(RTK_OK != RTK_Player_RemovePESFilter((RTK_Player)pHandle, 0))
				{
					/* The message can be ignore */
					//RTKHAL_ERR("RTK_Player_RemovePESFilter failed! \n");
				}

				#ifdef CLIENT_DTVSOURCE
				RTKHAL_INF("%s - unset source for player %p\n", __FUNCTION__, pHandle);
				RHAL_GetHalInstance()->Player_SetSource((RTK_Player)pHandle, NULL);
				#endif
				if(pHandle->isRecording == RTK_TRUE)
				{
					if(RTK_Player_DVRStop((RTK_Player)pHandle) != RTK_OK)
					{
						RTKHAL_ERR("clean up error\n");	
					}
				}
				RTKHAL_INF("%s - destroy player %p\n", __FUNCTION__, pHandle);
				if(RTK_Player_Destroy((RTK_Player)pHandle) != RTK_OK)
				{
					RTKHAL_ERR("clean up error\n");	
				}
				RTKHAL_INF("%s - destroy player %p done\n", __FUNCTION__, pHandle);
			}
		}

	}

	#ifdef CLIENT_DTVSOURCE
	for(int i=0; i<RTK_MAX_DTVSOURCE_MUM; i++)
	{
		if(RHAL_GetHalInstance()->m_pCurSource_Handle[i]!=NULL)
		{
			RTKHAL_INF("%s - destroy source %p\n", __FUNCTION__, RHAL_GetHalInstance()->m_pCurSource_Handle[i]);
			RHAL_GetHalInstance()->Source_Destroy(RHAL_GetHalInstance()->m_pCurSource_Handle[i]);
		}
	}
	#endif

//RTKHAL 2.0 remove EMM demux.
#if 0
	//-------------------------------------------------------------------------
	//	free EMM demux
	//-------------------------------------------------------------------------
	for(i = 0; i < RTK_MAX_DTVFLOW_NO; ++i)
	{
		pHandle =RHAL_GetHalInstance()->m_pCurEmmDemux_Handle[i];
		
		RTKHAL_INF("%s - destroy player %p\n", __FUNCTION__, pHandle);
		
		if (pHandle)
		{
			_xRTK_HAL_Callback(pHandle, RTK_CLEANUP, NULL, 0);
		}
		
		pHandle =RHAL_GetHalInstance()->m_pCurEmmDemux_Handle[i];	// pHandle must de assigned again, _xRTK_HAL_Callback() may update g_pCurPlayer_Handle[i]

		if(pHandle != NULL)
		{
			if(RTK_EmmDemux_Destroy((RTK_EmmDemux)pHandle) != RTK_OK)
			{
				RTKHAL_ERR("clean up error\n");
			}
			
			RTKHAL_INF("%s - destroy player %p done\n", __FUNCTION__, pHandle);
		}
	}
#endif	
#if defined(USE_RTKHAL_IN_ANDROID10)		
	RTK_DestorySurface(RTK_WIN_MAIN);
	RTK_DestorySurface(RTK_WIN_PIP);
#endif
	RHAL_HalInstanceCleanup();
	gSignalHappened=0;
	RTKHAL_INF("%s - exit\n", __FUNCTION__);
}
#endif

static inline void _xFree_Handle(HAL_HANDLE_S *handle)
{
	free(handle);
	handle = NULL;
}

static Rtk_Key_UpdateMode_e _lookup_rtk_key_update_mode(Hal_Key_UpdateMode_e update_mode){
	int numEntry= sizeof (HAL_KEY_UPDATE_MODE_MAP)/sizeof(HAL_KEY_UPDATE_MODE_MAP[0]);
	for(int i=0;i<numEntry;i++){
		if(update_mode== HAL_KEY_UPDATE_MODE_MAP[i].hal_update_mode)
			return HAL_KEY_UPDATE_MODE_MAP[i].rtk_update_mode;
	}
	return RTK_UPDATE_DIRECTLY; //default
}

static inline UINT32_T _xGet_AvHandle(HAL_HANDLE_S *handle)
{
	return handle->av_handle;
}

#if 1//ndef ENABLE_SOURCE_FILTER
static inline DEMUX_HANDLE_S* _xGet_DmxHandle(HAL_HANDLE_S *handle)
{
	return handle->dmx_handle;
}
#endif

static inline DEMUX_PES_HANDLE_S* _xGet_DmxPESHandle(HAL_HANDLE_S *handle)
{
	return handle->dmx_pes_handle;
}


static inline RTK_REC_CODEC_e _xTransfer_AV_Codec(RTK_Codec codec)
{
	RTK_REC_CODEC_e eCodec = RTK_REC_CODEC_NONE;
	switch(codec)
	{
		case RTK_CODEC_VIDEO_MPEG2:
			eCodec = RTK_REC_CODEC_MPEG2;
			break;
		case RTK_CODEC_VIDEO_H264:
			eCodec = RTK_REC_CODEC_H264;
			break;
		case RTK_CODEC_VIDEO_H265:
			eCodec = RTK_REC_CODEC_H265;
			break;
		case RTK_CODEC_AUDIO_MPEG1:
		case RTK_CODEC_AUDIO_MPEG2:
		case RTK_CODEC_AUDIO_AAC:
		case RTK_CODEC_AUDIO_AACPLUS:
		case RTK_CODEC_AUDIO_AC3:
		case RTK_CODEC_AUDIO_AC3_TRUE_HD:
		case RTK_CODEC_AUDIO_AC3_PLUS:
		case RTK_CODEC_AUDIO_EAC3:
		case RTK_CODEC_AUDIO_DTS:
		case RTK_CODEC_AUDIO_DTS_HD:
		case RTK_CODEC_AUDIO_DTS_HD_MA:
        case RTK_CODEC_AUDIO_MP4:
          
			eCodec = RTK_REC_CODEC_AUDIO;
			break;
		default:
			break;
	}
	return eCodec;
}

static inline RTK_AV_TYPE_e _xGet_AVtype_fromCodec(RTK_Codec codec)
{
	RTK_AV_TYPE_e avType = RTK_AV_INVALID_TYPE;
	switch(codec)
	{
		case RTK_CODEC_VIDEO_MPEG1:
		case RTK_CODEC_VIDEO_MPEG2:
		case RTK_CODEC_VIDEO_MPEG4_PART2:				
		case RTK_CODEC_VIDEO_H264:	
		case RTK_CODEC_VIDEO_H265:
			avType = RTK_AV_VIDEO;
			break;
		case RTK_CODEC_AUDIO_MPEG1:
		case RTK_CODEC_AUDIO_MPEG2:
		case RTK_CODEC_AUDIO_MP4:
		case RTK_CODEC_AUDIO_AAC:
		case RTK_CODEC_AUDIO_AACPLUS:
		case RTK_CODEC_AUDIO_AC3:
		case RTK_CODEC_AUDIO_AC3_TRUE_HD:
		case RTK_CODEC_AUDIO_AC3_PLUS:
		case RTK_CODEC_AUDIO_EAC3:
		case RTK_CODEC_AUDIO_DTS:
		case RTK_CODEC_AUDIO_DTS_HD:
		case RTK_CODEC_AUDIO_DTS_HD_MA:
			avType = RTK_AV_AUDIO;
			break;
		default:
			break;
	}
	return avType;
}

static inline RTK_VIDEO_CODEC_TYPE_e _xTransfer_Video_Codec(RTK_Codec codec)
{
	RTK_VIDEO_CODEC_TYPE_e eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_UNKNOWN;
	switch(codec)
	{
		case RTK_CODEC_VIDEO_MPEG1:
			eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_MPEG1;
			break;
		case RTK_CODEC_VIDEO_MPEG2:
			eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_MPEG2;
			break;
		case RTK_CODEC_VIDEO_MPEG4_PART2:
			eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_MPEG4;
			break;
		case RTK_CODEC_VIDEO_H264:
			eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_H264;
			break;
		case RTK_CODEC_VIDEO_H265:
			eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_HEVC;
			break;
		default:
			break;
	}
	return eRtkVideoCodec;
}

static inline RTK_AUDIO_CODEC_TYPE_e _xTransfer_Audio_Codec(RTK_Codec codec)
{
	RTK_AUDIO_CODEC_TYPE_e eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_UNKNOWN;

	switch(codec)
	{
		case RTK_CODEC_AUDIO_MPEG1:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_MPEG1;
			break;
		case RTK_CODEC_AUDIO_MPEG2:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_MPEG2;
			break;
		case RTK_CODEC_AUDIO_MP3:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_MP3;
			break;
		case RTK_CODEC_AUDIO_MP4:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_MP4;
			break;
		case RTK_CODEC_AUDIO_AAC:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_AAC;
			break;
		case RTK_CODEC_AUDIO_AACPLUS:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_AAC_PLUS_ADTS;//RTK_AUDIO_CODEC_TYPE_AAC_PLUS_LOAS
			break;
		case RTK_CODEC_AUDIO_AC3:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_AC3;
			break;
		case RTK_CODEC_AUDIO_AC3_TRUE_HD:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DTS_HD;
			break;
		case RTK_CODEC_AUDIO_AC3_PLUS:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_E_AC3;
			break;
		case RTK_CODEC_AUDIO_EAC3:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_E_AC3;
			break;
		case RTK_CODEC_AUDIO_LPCM:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_PCM;
			break;
		case RTK_CODEC_AUDIO_DTS:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DTS;
			break;
		case RTK_CODEC_AUDIO_DTS_HD:
			eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DTS_HD;
			break;
		case RTK_CODEC_AUDIO_DTS_HD_MA:
			
			break;
		default:
			break;
	}

	return eRtkAudioCodec;
}

static inline Rtk_CableTnr_Modulation_e _xTransfer_Modulation(RTK_ModulationType type)
{
	Rtk_CableTnr_Modulation_e eModulation = RTK_CABLETNR_QAM_256;
	switch(type)
	{
		case RTK_DEMOD_256QAM:
			eModulation=RTK_CABLETNR_QAM_256;
			break;
		case RTK_DEMOD_128QAM:
			eModulation=RTK_CABLETNR_QAM_128;
			break;
		case RTK_DEMOD_64QAM:
			eModulation=RTK_CABLETNR_QAM_64;
			break;
		case RTK_DEMOD_32QAM:
			eModulation=RTK_CABLETNR_QAM_32;
			break;
		case RTK_DEMOD_16QAM :
			eModulation=RTK_CABLETNR_QAM_16;
			break;
		default:
			eModulation=RTK_CABLETNR_QAM_256;
			break;
	}
	return eModulation;
}

static void _xRTK_HAL_Callback( HAL_HANDLE_S* pHandle, RTK_CallbackEvent event, void * data, UINT32_T data_size)
{
	RTK_CallbackConfig* pCb_config = NULL;
	
	if(pHandle)
	{

		pCb_config = &(pHandle->player_config.callback);

		if(pCb_config)
		{
			//RTKHAL_INF("callback event %d\n", event);
			
			if(pCb_config->function)
			{
				pCb_config->function(event, pHandle->type, pCb_config->user_param, data, data_size);
			}
			else
			{
				RTKHAL_ERR("no callback function\n");
			}
		}
	}
	
	return;
}




static INT64_T _xRtk_pli_getMilliseconds()
{
    struct timespec tp;
    clock_gettime(CLOCK_MONOTONIC, &tp);

    return (int64_t)tp.tv_sec * 1000 + tp.tv_nsec / 1000000;
}


static RTK_Error _xAddTSFilter(HAL_HANDLE_S* handle, RTK_TSFilterPattern * pattern, RTK_TSFilter * filter_handle)
{
	if((handle == NULL) || (pattern == NULL) || (filter_handle == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	INT32_T ts_filter = 0;
	RTK_REC_FILTER_t filter_pattern;
	filter_pattern.pid = (INT32_T) pattern->pid;
	filter_pattern.encrypt = pattern->encrypt;
	filter_pattern.codec = _xTransfer_AV_Codec(pattern->codec);
	filter_pattern.isAnchor = pattern->isAnchor;
	filter_pattern.isTag = pattern->isTag;

	rtk_porting_record_add_pid(handle->av_handle ,filter_pattern,  &ts_filter);

	* filter_handle = (RTK_TSFilter *)ts_filter;
	
	RTKHAL_INF("[%s]:0x%x pid=0x%x enc=%d handle=0x%x\n", __FUNCTION__, handle->av_handle, pattern->pid, pattern->encrypt, ts_filter);

	return RTK_OK;
}

static RTK_Error _xRemoveTSFilter(HAL_HANDLE_S* handle, RTK_TSFilter filter_handle)
{
	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	UINT32_T u32ts_filter = (UINT32_T)filter_handle;
	RTKHAL_INF("[%s]:%p handle=%d\n", __FUNCTION__, handle, u32ts_filter);
	
	//remove a pid filter and don't care about type
	rtk_porting_record_delete_pid(handle->av_handle, u32ts_filter);
	
	return RTK_OK;
}

static RTK_Error _xRemoveAllTSFilters(HAL_HANDLE_S* handle)
{
	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	//rtk_porting_AllTSFilterStop(_xGet_DmxHandle(handle));
	rtk_porting_record_clear_pid(handle->av_handle);	

	return RTK_OK;
}

RTK_Error _xReSetShareMemReady(HAL_HANDLE_S* handle)
{
	handle->PlayerMtpMemPool->header.bMemReady=0;
	return RTK_OK;
}

static RTK_Error _xAddSectionFilter(void* handle, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	UINT32_T u32FilterID = 0;
	RTK_FILTER_MASK_TYPE_e FilterMask;

	if((handle == NULL) || (filter_handle == NULL) || (pattern == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	//need check comp & mask & mode.
	RTK_PORTING_DMUX_REQUEST_MODE u8byReqID;
	if(pattern->monitoring_mode == RTK_SECTION_MODE_ONESHOT)
	{
		u8byReqID = RTK_PORTING_SECTION_MODE_ONESHOT;
	}
	else
	{
		u8byReqID = RTK_PORTING_SECTION_MODE_CONTINOUS;
	}

	//default is 0, should check crc by rtk.
	FilterMask.u8crc_check_option = 0;
	if((pattern->options & RTK_SECTION_OPTION_NO_CHECK_CRC) == RTK_SECTION_OPTION_NO_CHECK_CRC)
	{
		FilterMask.u8crc_check_option = RTK_DMUX_SECTION_OPTION_NO_CHECK_CRC;
	}
	memcpy(FilterMask.u8pbyFilter, pattern->comp, RTK_MAX_SECTION_MASK_LENGTH);
	memcpy(FilterMask.u8pbyMask,   pattern->mask, RTK_MAX_SECTION_MASK_LENGTH);
	memcpy(FilterMask.u8pbyMode,   pattern->mode, RTK_MAX_SECTION_MASK_LENGTH);

	FilterMask.u32byWaitTimeoutMs = pattern->u32byWaitTimeoutMs;
#ifdef ENABLE_SOURCE_FILTER
	if(rtk_porting_SectionFilterOpen((DEMUX_HANDLE_S*)handle, 
		pattern->pid, RTK_MAX_SECTION_MASK_LENGTH, 
		u8byReqID, FilterMask, &u32FilterID, pattern->section_user_param, (void*)pattern->callback_01)!=RTK_OK)
	{
		RTKHAL_ERR("[%s]rtk_porting_SectionFilterOpen failed\n", __FUNCTION__);
		*filter_handle=0;
		return RTK_Fail;
	}
#else
	if(rtk_porting_SectionFilterOpen(_xGet_DmxHandle((HAL_HANDLE_S *)handle), 
		pattern->pid, RTK_MAX_SECTION_MASK_LENGTH, 
		u8byReqID, FilterMask, &u32FilterID, pattern->section_user_param, (void*)pattern->callback_01)!=RTK_OK)
	{
		RTKHAL_ERR("[%s]rtk_porting_SectionFilterOpen failed\n", __FUNCTION__);
		*filter_handle=0;
		return RTK_Fail;
	}
#endif
	RTKHAL_INF("%s,[%s][%d]:%p pid=0x%x handle=0x%x,u32byWaitTimeoutMs:%ud		ms\n",__FILE__, __FUNCTION__,__LINE__, handle, pattern->pid, u32FilterID,FilterMask.u32byWaitTimeoutMs);

	*filter_handle = (RTK_SectionFilter)u32FilterID;

	return RTK_OK;
}

static RTK_Error _xRemoveSectionFilter(void* handle, RTK_SectionFilter filter_handle)
{
	UINT16_T u16FilterPid = 0xFFFF;//0xFFFF means not use this param.

	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p handle=0x%x\n", __FUNCTION__, handle, (UINT32_T)filter_handle);

	#ifdef ENABLE_SOURCE_FILTER
	rtk_porting_SectionFilterStop((DEMUX_HANDLE_S*)handle, u16FilterPid, (UINT32_T)filter_handle);
	#else
	rtk_porting_SectionFilterStop(_xGet_DmxHandle((HAL_HANDLE_S *)handle), u16FilterPid, (UINT32_T)filter_handle);
	#endif
	return RTK_OK;
}

static RTK_Error _xRemoveAllSectionFilters(void* handle)
{
	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	#ifdef ENABLE_SOURCE_FILTER
	rtk_porting_SectionAllFilterStop((DEMUX_HANDLE_S*)handle);
	#else
	rtk_porting_SectionAllFilterStop(_xGet_DmxHandle((HAL_HANDLE_S *)handle));
	#endif
	return RTK_OK;
}

#if (VIDEO_STOP_NON_BLOCK)
//-----------------------------------------------------------------------------
//	video stop non-blocking related function
//-----------------------------------------------------------------------------
static RTK_AV_EVENT_MSG av_event_msg = {0, RTK_VIDEO_STOPPED_EVT, 0};
static pthread_mutex_t av_event_mutex = PTHREAD_MUTEX_INITIALIZER;

void _video_stop_callback(RTK_AV_EVENT_MSG msg)
{
	pthread_mutex_lock(&av_event_mutex);
	av_event_msg = msg;
	pthread_mutex_unlock(&av_event_mutex);
}

static void _video_stop_prepare(UINT32_T av_handle)
{
	pthread_mutex_lock(&av_event_mutex);
	memset(&av_event_msg, 0x00, sizeof(av_event_msg));
	pthread_mutex_unlock(&av_event_mutex);
	
	rtk_porting_av_add_event_callback(av_handle, RTK_VIDEO_STOPPED_EVT, _video_stop_callback);
}

static char _wait_video_stop_complete(UINT32_T av_handle)
{
	#define VIDEO_STOP_RETRY_COUNT (1000)
	char ret = 1;
	int i;
	
	for (i=0; i<VIDEO_STOP_RETRY_COUNT; i++)
	{
		pthread_mutex_lock(&av_event_mutex);
		if ((av_event_msg.av_handle == av_handle) && (av_event_msg.av_event == RTK_VIDEO_STOPPED_EVT))
		{
			pthread_mutex_unlock(&av_event_mutex);
			break;
		}
		pthread_mutex_unlock(&av_event_mutex);
		usleep(10*1000);
	}

	if (i == VIDEO_STOP_RETRY_COUNT)
	{
		ret = 0;
		printf("%s(%d) video stop timeout !!!\n",__func__,__LINE__);
	}

	return ret;
}
#endif
//-----------------------------------------------------------------------------

#if 0
static RTK_Error _xControlSectionFilter(void* handle, RTK_SectionFilter filter_handle,RTK_Bool enable)
{
	UINT16_T u16FilterPid = 0xFFFF;//0xFFFF means not use this param.

	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p handle=0x%x\n", __FUNCTION__, handle, (UINT32_T)filter_handle);



	rtk_porting_SectionFilterStop(_xGet_DmxHandle((HAL_HANDLE_S *)handle), u16FilterPid, (UINT32_T)filter_handle);
	return RTK_OK;
}
#endif

static RTK_Error _xAddPESFilter(void* handle, RTK_PESFilterPattern * pattern)
{	
	if((handle == NULL) || (pattern == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

#if 0
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)handle;
	Rtk_Subtitle_Info_t  tsSubtitleTrackInfo;
	memset(&tsSubtitleTrackInfo,0 ,sizeof(Rtk_Subtitle_Info_t));
	tsSubtitleTrackInfo.bshow= false;
	tsSubtitleTrackInfo.pid= pattern->pid;
	INT8_T ret1 = RTK_OK;
	ret1 = rtk_porting_av_SetSubtitle( hal_handle->av_handle,tsSubtitleTrackInfo);
	RTKHAL_INF("[%s]:ret1:%d \n", __FUNCTION__, ret1);
#endif
	
	PESFilterData mPESFilterData;
	mPESFilterData.demux_PES_handle = _xGet_DmxPESHandle((HAL_HANDLE_S *)handle);
	mPESFilterData.pid = pattern->pid;
	mPESFilterData.pes_user_param = pattern->userParam;
	mPESFilterData.callback = (void *)pattern->callback;
	mPESFilterData.bFilterId = pattern->u8filterID;
	
	RTKHAL_INF("%s,[%s][%d]:%p pid=0x%x u8filterID=0x%x\n",__FILE__, __FUNCTION__,__LINE__, handle, pattern->pid, pattern->u8filterID);
    
	HAL_HANDLE_S* rtk_handle = (HAL_HANDLE_S *)handle;
	if((rtk_handle->playingStatus & RHAL_VIDEO_PLAYING) != RHAL_VIDEO_PLAYING  && (pes_start_av_flag == 0))
		 {
			  rtk_porting_video_play(_xGet_AvHandle(rtk_handle));	 
			  pes_start_av_flag = 0x01;
		 }
	if(RTK_OK != rtk_porting_StartPesFilter(mPESFilterData))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}

static RTK_Error _xRemovePESFilter(void* handle, UINT8_T u8FilterId)
{
	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p u8FilterId=0x%x\n", __FUNCTION__, handle, u8FilterId);
    
    HAL_HANDLE_S* rtk_handle = (HAL_HANDLE_S *)handle;
     if((rtk_handle->playingStatus & RHAL_VIDEO_PLAYING) != RHAL_VIDEO_PLAYING  && (pes_start_av_flag == 0x01))
    	{
	         
			 rtk_porting_video_stop(_xGet_AvHandle(rtk_handle),0);
			 pes_start_av_flag = 0x00;
    	}
	if(RTK_OK !=rtk_porting_StopPesFilter(_xGet_DmxPESHandle((HAL_HANDLE_S *)handle), u8FilterId))	
	{
		return RTK_Fail;
	}
	return RTK_OK;
}

RTK_REC_CODEC_e RHAL_Transfer_AV_Codec(RTK_Codec codec)
{
	return _xTransfer_AV_Codec(codec);
}

RTK_VIDEO_CODEC_TYPE_e RHAL_Transfer_Video_Codec(RTK_Codec codec)
{
	return _xTransfer_Video_Codec(codec);
}

RTK_AUDIO_CODEC_TYPE_e RHAL_Transfer_Audio_Codec(RTK_Codec codec)
{
	return _xTransfer_Audio_Codec(codec);
}

Rtk_CableTnr_Modulation_e RHAL_Transfer_Modulation(RTK_ModulationType type)
{
	return _xTransfer_Modulation(type);
}

HAL_HANDLE_S* RHAL_Base::m_pCurHal_Handle[]={NULL, NULL};
Source_Handle RHAL_Base::m_pCurSource_Handle[RTK_MAX_DTVSOURCE_MUM];
pthread_mutex_t RHAL_Base::m_av_create_mutex=PTHREAD_MUTEX_INITIALIZER;

RHAL_Base::RHAL_Base(int dtvflow_num)
{
	(void)dtvflow_num;	// fix compile warning
	
	RTKHAL_INF("[%s:%s]: enter\n", __FILE__, __func__);
	m_halInitSuccess=RTK_Fail;
	
	/*m_dtvflow_num=dtvflow_num;
	if(m_dtvflow_num>RTK_MAX_DTVFLOW_NO)
		m_dtvflow_num=RTK_MAX_DTVFLOW_NO;
	*/
	//always let m_dtvflow_num is the max dtvflow numbers.
	m_dtvflow_num=RTK_MAX_DTVFLOW_NO;
	
	m_AvInit=RTK_FALSE;

	//set default dvb resource config.
	m_dvbResourceConfig.demux_usenum=0;
	m_dvbResourceConfig.player_usenum=0;
	m_dvbResourceConfig.playerWithTP_usenum=RTK_MAX_DTVFLOW_NO;
	m_dvbResourceConfig.esplayer_usenum=0;

	for(int i=0; i<RTK_MAX_DTVFLOW_NO; i++)
	{
		m_channelStatus[i].channelState=RHAL_CHANNEL_free;
		m_channelStatus[i].channelHalType=HAL_TYPE_NONE;
		m_BufInUse[i]=RTK_FALSE;
		m_SidebandHandle[i]=NULL;
		m_ionmem_sharefd[i].channel=-1;
		m_ionmem_sharefd[i].DemuxSharefd=-1;
		m_ionmem_sharefd[i].DTVSharefd=-1;
		m_ionmem_sharefd[i].MultiviewSharefd=-1;
		m_ionmem_sharefd[i].OSMsharefd=-1;
		m_ionmem_sharefd[i].RecSharefd=-1;
		m_ionmem_sharefd[i].SectionSharefd=-1;

		pthread_mutex_init(&m_rtk_hal_mutex[i], NULL);

		m_pCurHal_Handle[i]=NULL;
	}

	for(int i=0; i<RTK_MAX_DTVSOURCE_MUM; i++)
	{
		m_pCurSource_Handle[i]=NULL;
		m_sourceDmxHandle[i].isUsing=false;
		m_sourceDmxHandle[i].source_handle=NULL;
		m_sourceDmxHandle[i].dmx_handle=NULL;
		m_sourceDmxHandle[i].sectionThread_stop=false;
		m_sourceDmxHandle[i].sectionThread_id=0;
	}
	pthread_mutex_init(&m_sourceDmxHandle_mutex, NULL);

	 m_dtvSource_isInit=false;
	
	//We do connect TvServer in here, because every instance will enter into here first.
	if(rtk_porting_connect_TvServer()!=RTK_OK)  
	{
		RTKHAL_ERR("rtk_porting_connect_TvServer fail !!!\n");
		return;
	}

	RTKHAL_INF("[%s:%s]: bf FDSHMClient_init\n", __FILE__, __func__);
	if(rtk_porting_FDSHMClient_init()!=RTK_OK)
	{
		RTKHAL_ERR("rtk_porting_FDSHMClient_init fail !!!\n");
		return;
	}
	RTKHAL_INF("[%s:%s]: af FDSHMClient_init\n", __FILE__, __func__);

	m_uiTunerChannel = 0;
#if defined(USE_RTKHAL_IN_ANDROID9) 
	mhal_hdmiLib = new realtek::HDMILib();
#endif

	m_halInitSuccess=RTK_OK;
	
	RTKHAL_INF("[%s:%s]: exit\n", __FILE__, __func__);

}

RHAL_Base::~RHAL_Base()
{
	RTKHAL_INF("[%s:%s]: enter\n", __FILE__, __func__);
	mCleanup_AV();
	
	rtk_porting_FDSHMClient_uninit();
	rtk_porting_disconnect_TvServer();

	for(int i=0; i<RTK_MAX_DTVFLOW_NO; i++)
	{
		pthread_mutex_destroy(&m_rtk_hal_mutex[i]);
	}


	pthread_mutex_destroy(&m_sourceDmxHandle_mutex);

	
#if defined(USE_RTKHAL_IN_ANDROID9) 
         if(mhal_hdmiLib !=NULL)
	     delete mhal_hdmiLib;
#endif

	
	RTKHAL_INF("[%s:%s]: exit\n", __FILE__, __func__);
}
static bool mUseSourceFilter(RTK_Player player)
{
    if(!player)
		return false;
    HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
    HAL_TYPE type =hal_handle->type ;
    return (type == HAL_TYPE_PLAYER)?false:true;
}
///<add by changxi_huang
bool RHAL_Base::addCCData(HAL_HANDLE_S *handle,unsigned char *pUnit,unsigned int len)
{
	if(pUnit == NULL || len <= 0){
		return false;
	}
	DataUnit_t* pDataUnit = (DataUnit_t*)malloc(sizeof(DataUnit_t));
	if(pDataUnit == NULL){
		return false;
	}
	pDataUnit->pData = pUnit;
	pDataUnit->length = len;
	pDataUnit->next = NULL;
	if(handle->m_CCData.pHead != NULL){
		if(handle->m_CCData.pTail != NULL){
			handle->m_CCData.pTail->next = pDataUnit;
			handle->m_CCData.pTail = pDataUnit;
		}
	}else{
		handle->m_CCData.pHead = pDataUnit;
		handle->m_CCData.pTail = pDataUnit;
 	}
	return true;
 }

bool RHAL_Base::readCCData(HAL_HANDLE_S *handle,unsigned char **pUnit,unsigned int* pLen)
{
	if(pUnit == NULL || pLen == NULL){
		return false;
	}
	if(handle->m_CCData.pHead == NULL){
		return false;
	}
	//1)delete old data
	if(handle->m_CCData.pRead != NULL){
		DataUnit_t*pTmpH = handle->m_CCData.pHead;
		for(;pTmpH != NULL && pTmpH != handle->m_CCData.pRead;){
			DataUnit_t*pTmpN = pTmpH->next;
			if(pTmpH->pData != NULL){
				free(pTmpH->pData);
				pTmpH->pData = NULL;
			}
			free(pTmpH);
			pTmpH = pTmpN;
		}
		handle->m_CCData.pHead = pTmpH;
	}
	//2)read out new data
	if(handle->m_CCData.pRead != NULL){
		if(handle->m_CCData.pRead != handle->m_CCData.pTail){
			handle->m_CCData.pRead = handle->m_CCData.pRead->next;
			if(handle->m_CCData.pRead != NULL){
				if(handle->m_CCData.pRead->pData != NULL){
					*pUnit = handle->m_CCData.pRead->pData;
					*pLen = handle->m_CCData.pRead->length;
					return true;
				}
			}
		}
	}else{
		handle->m_CCData.pRead = handle->m_CCData.pHead;
		if(handle->m_CCData.pRead->pData != NULL){
			*pUnit = handle->m_CCData.pRead->pData;
			*pLen = handle->m_CCData.pRead->length;
			return true;
		}
	}
	return false;
}
///< add end
RTK_Error RHAL_Base::mGetInputBuffer(HAL_HANDLE_S *handle, RTK_TSInputBuffer *buffer,  HAL_TYPE type)	
{

	UINT32_T wr = 0, rd = 0, beginPhyAddr=0, endPhyAddr=0;
	UINT32_T size = 0;
	UINT32_T align_size = PKT_SIZE;
	if((handle == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	if( handle->player_config.input.isEncrypt == RTK_TRUE)
	{ // block encrypt
		align_size = ALIGN_PKT_SIZE;
	}

	if((type == HAL_TYPE_DEMUX)||(type == HAL_TYPE_EMMDEMUX))
	{
#ifdef CLIENT_DTVSOURCE
		return Source_GetInputBuffer(handle->connect_source, buffer);
#else
		int channel_idx = handle->channel;

		pthread_mutex_lock(&m_rtk_hal_mutex[channel_idx]);
		if( handle->got_mtpbuf == RTK_TRUE)
		{
			pthread_mutex_unlock(&m_rtk_hal_mutex[channel_idx]);
			RTKHAL_ERR("[%s]Had get before, please Discard first!\n",__FUNCTION__);
			return RTK_Fail;
		}
		else if( m_BufInUse[handle->channel] == RTK_TRUE )
		{
			pthread_mutex_unlock(&m_rtk_hal_mutex[channel_idx]);
			RTKHAL_INTER_ERR(handle->last_got_time, "%s[%p] g_BufInUse, try later !!\n", __FUNCTION__, handle);
			buffer->size = 0;
			return RTK_Fail;
		}
		else
		{
			handle->got_mtpbuf = RTK_TRUE;
			m_BufInUse[handle->channel] = RTK_TRUE;
		}
		pthread_mutex_unlock(&m_rtk_hal_mutex[channel_idx]);

		if(handle->DemuxMtpMemPool== NULL)
		{
			RTKHAL_ERR("MTP buffer is null !!error!!\n");
			return RTK_Fail;
		}
		wr = handle->DemuxMtpMemPool->header.shared_buf_wr_ptr;
		rd = handle->DemuxMtpMemPool->header.shared_buf_rd_ptr;
		beginPhyAddr = handle->DemuxMtpMemPool->info.mtp_buf_base;
		endPhyAddr = handle->DemuxMtpMemPool->info.mtp_buf_limit;
		
		//RTKHAL_INF("[%d]begin %s:  wr=0x%x, rd=0x%x,beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__,  wr, rd, beginPhyAddr, endPhyAddr);

		if(wr >= rd)
		{
			if(rd != beginPhyAddr)
			{			   
				size = (endPhyAddr - wr);
			}
			else
			{
				size = (endPhyAddr - wr) - align_size;  // to avoid writable_offset == data_end_offset
				
			}
		}
		else
		{
			size = (rd - wr) - align_size;  // to avoid writable_offset == data_end_offset
			
		}

		buffer->size = (size/align_size) * align_size;
		buffer->memory =  (void *) (handle->DemuxMtpMemPool->buffer + (wr-beginPhyAddr));
		buffer->filled_size = 0;
		buffer->isLast=RTK_FALSE;
		rtk_store_system_cmd(RTK_DEMUX_FREE_SIZE,RTK_SYSTEM_TYPE_INT, &buffer->size); // system_monitor
		//RTKHAL_INF("[%d]after %s %d:  size=0x%x\n",type,  __FUNCTION__,__LINE__,   size);
		if(buffer->size == 0)
		{
			pthread_mutex_lock(&m_rtk_hal_mutex[channel_idx]);
			handle->got_mtpbuf = RTK_FALSE;
			m_BufInUse[handle->channel] = RTK_FALSE;
			pthread_mutex_unlock(&m_rtk_hal_mutex[channel_idx]);
			RTKHAL_INTER_ERR(handle->last_got_time, "%s[%p] get size is 0 !! 0x%x 0x%x \n", __FUNCTION__, handle, wr, rd);
			//RTKHAL_ERR("[%d]%s[%p] get size is 0 !! 0x%x 0x%x \n", type, __FUNCTION__, handle, wr, rd);
			return RTK_Fail;
		}
#endif
	}
	else if(type == HAL_TYPE_PLAYER)
	{
		
		//printf("%s: ###type=0x%x\n", __FUNCTION__, type);

		if(handle->PlayerMtpMemPool== NULL)
		{
			RTKHAL_ERR("PlayerMtpMemPool is null !!error!!\n");
			return RTK_Fail;
		}

		
		wr = handle->PlayerMtpMemPool->header.writePtr;
		rd = handle->PlayerMtpMemPool->header.readPtr;
		beginPhyAddr = handle->PlayerMtpMemPool->header.beginPhyAddr;
		endPhyAddr = handle->PlayerMtpMemPool->header.endPhyAddr;

		//RTKHAL_INF("[%d]begin %s:  wr=0x%x, rd=0x%x,beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__,  wr, rd, beginPhyAddr, endPhyAddr);

		if(wr >= rd)
		{
			if(rd != beginPhyAddr)
			{			   
				size = (endPhyAddr - wr);
			}
			else
			{
				size = (endPhyAddr - wr) - align_size;  // to avoid writable_offset == data_end_offset
				
			}
		}
		else
		{
			size = (rd - wr) - align_size;  // to avoid writable_offset == data_end_offset
			
		}

		buffer->size = (size/align_size) * align_size;
		if(handle->isSecurePlayShmUsed==true)
		{
			buffer->memory =  (void *) ((unsigned char *)(handle->pSecurePlayShm_virt)+ wr);
		}
		else
			buffer->memory =  (void *) ((unsigned char *)(handle->PlayerMtpMemPool)+ wr);
		
		buffer->filled_size = 0;
		buffer->isLast=RTK_FALSE;

		rtk_store_system_cmd(RTK_PLAYER_FREE_SIZE,RTK_SYSTEM_TYPE_INT, &buffer->size); // system_monitor

		if(handle->PlayerMtpMemPool->header.bMemReady==0)
		{
			buffer->size =0;
			RTKHAL_INF("wait Server memery ready. After that we can feed data\n");
		}
		
		//RTKHAL_INF("[%d]after %s:  wr=0x%x, rd=0x%x, beginPhyAddr=0x%x, endPhyAddr=0x%x, buffer->size=0x%x\n", type, __FUNCTION__,  wr, rd, beginPhyAddr, endPhyAddr, buffer->size);
		if(buffer->size == 0)
		{
			RTKHAL_INTER_ERR(handle->last_got_time, "%s[%p] get size is 0 !! 0x%x 0x%x \n", __FUNCTION__, handle, wr, rd);
			//RTKHAL_ERR("[%d]%s[%p] get size is 0 !! 0x%x 0x%x \n", type, __FUNCTION__, handle, wr, rd);
			return RTK_Fail;
		}

	}


	if( buffer->size > 0)
	{
		handle->last_got_time = _xRtk_pli_getMilliseconds();
		//RTKHAL_INF("%s[%p] get size 0x%x 0x%x 0x%x\n", __FUNCTION__, handle, wr, rd, buffer->size);
	}
	//RTKHAL_INF("[%d]buffer->memory=%p, get size %d(0x%x)\n", type, buffer->memory, buffer->size, buffer->size);

	return RTK_OK;
}


RTK_Error RHAL_Base::mFeedInputBuffer(HAL_HANDLE_S *handle, RTK_TSInputBuffer * buffer,  HAL_TYPE type)
{
	UINT32_T fill_size = 0;
	UINT32_T wr = 0, rd = 0, beginPhyAddr=0, endPhyAddr=0;
	UINT32_T align_size = PKT_SIZE;

	if((handle == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	if( handle->player_config.input.isEncrypt == RTK_TRUE)
	{ // block encrypt
		align_size = ALIGN_PKT_SIZE;
	}

	fill_size = buffer->filled_size;	
	rtk_store_system_cmd(RTK_PLAYER_FEED_SIZE,RTK_SYSTEM_TYPE_INT,&fill_size);
	if (fill_size == 0)
	{
		return RTK_OK;
	}
	
	//RTKHAL_INF("[%d]fill size %d(0x%x)\n", type, buffer->filled_size, buffer->filled_size);
	if( (fill_size % align_size) != 0 )
	{
		if(buffer->isLast)
		{ // if last, we cut incomplete packet
			RTKHAL_WRN("%s : last one, we cut incomplete packetn\n", __FUNCTION__);
			fill_size -= fill_size % align_size;
		}
		else
		{
			RTKHAL_ERR("%s : fill size not packet align %d\n", __FUNCTION__, align_size);
			return RTK_Fail;
		}
	}
	
	unsigned char * pp = (unsigned char *)buffer->memory;

	if(handle->isSecurePlayShmUsed==false && pp[0] != 0x47)
	{
		if( handle->type == HAL_TYPE_DEMUX && handle->player_config.input.isEncrypt == RTK_FALSE)
		{
			RTKHAL_ERR("%s : packet alignment wrong\n", __FUNCTION__);
			return RTK_Fail;
		}
	}

	if((type == HAL_TYPE_DEMUX)||(type == HAL_TYPE_EMMDEMUX))
	{
#ifdef CLIENT_DTVSOURCE
		return Source_FeedInputBuffer(handle->connect_source, buffer);
#else
		buffer->size = 0;
		wr = handle->DemuxMtpMemPool->header.shared_buf_wr_ptr;		
		rd = handle->DemuxMtpMemPool->header.shared_buf_rd_ptr;
		beginPhyAddr = handle->DemuxMtpMemPool->info.mtp_buf_base;
		endPhyAddr = handle->DemuxMtpMemPool->info.mtp_buf_limit;
		
		//RTKHAL_INF("[%d]begin %s %d :  wr=0x%x, rd=0x%x,beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__, __LINE__, wr, rd, beginPhyAddr, endPhyAddr);

		// double check if feed size overwrite
		if (wr >= rd)
		{
			if(rd != beginPhyAddr)
			{
				if ((wr + fill_size) > endPhyAddr)
				{
					RTKHAL_ERR("failed 1 => (0x%x 0x%x) 0x%x 0x%x\n", wr,rd, fill_size, endPhyAddr);
					return RTK_Fail;
				}
			}
			else
			{
				if ((wr + fill_size) >= endPhyAddr)
				{
					RTKHAL_ERR("failed 2 => (0x%x 0x%x) 0x%x 0x%x\n", wr,rd, fill_size, endPhyAddr);
					return RTK_Fail;
				}
			}
		}
		else
		{
			if ((wr + fill_size) >= rd)
			{
				RTKHAL_ERR("failed 3 => (0x%x 0x%x) 0x%x\n", wr,rd, fill_size);
				return RTK_Fail;
			}
		}

		// update write point
		wr += fill_size;
		if (wr >= endPhyAddr)
		{
			wr = beginPhyAddr;
		}
		handle->DemuxMtpMemPool->header.shared_buf_wr_ptr = wr ;
		if(buffer->isLast == RTK_TRUE)
		{
			RTKHAL_ERR("%s set DemuxMtpMemPool isLast=1\n", __FUNCTION__);
			handle->DemuxMtpMemPool->header.is_last = 1;
		}
		 rtk_store_system_cmd(RTK_DEMUX_RP_ADDR,RTK_SYSTEM_TYPE_INT, &rd);//monitor_system
		 rtk_store_system_cmd(RTK_DEMUX_WP_ADDR,RTK_SYSTEM_TYPE_INT, &wr);//monitor_system
		//RTKHAL_INF("[%d]after %s %d :  wr=0x%x, rd=0x%x,beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__, __LINE__, wr, rd, beginPhyAddr, endPhyAddr);

		// release in use flag
		pthread_mutex_lock(&m_rtk_hal_mutex[handle->channel]);
		handle->got_mtpbuf = RTK_FALSE;
		m_BufInUse[handle->channel] = RTK_FALSE;
		pthread_mutex_unlock(&m_rtk_hal_mutex[handle->channel]);
#endif
	}
	else if(type == HAL_TYPE_PLAYER)
	{
		buffer->size = 0;
		wr = handle->PlayerMtpMemPool->header.writePtr;
		rd = handle->PlayerMtpMemPool->header.readPtr;
		beginPhyAddr = handle->PlayerMtpMemPool->header.beginPhyAddr;
		endPhyAddr = handle->PlayerMtpMemPool->header.endPhyAddr;
	    
		//RTKHAL_INF("%s:###*pp=0x%x, type=0x%x\n",__FUNCTION__, *pp, type);
		//RTKHAL_INF("[%d]begin %s %d:  wr=0x%x, rd=0x%x,  beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__,  __LINE__, wr, rd, beginPhyAddr, endPhyAddr);

		// double check if feed size overwrite
		if (wr >= rd)
		{
			if(rd != beginPhyAddr)
			{
				if ((wr + fill_size) > endPhyAddr)
				{
					RTKHAL_ERR("failed 1 => (0x%x 0x%x) 0x%x 0x%x\n", wr,rd, fill_size, endPhyAddr);
					return RTK_Fail;
				}
			}
			else
			{
				if ((wr + fill_size) >= endPhyAddr)
				{
					RTKHAL_ERR("failed 2 => (0x%x 0x%x) 0x%x 0x%x\n", wr,rd, fill_size, endPhyAddr);
					return RTK_Fail;
				}
			}
		}
		else
		{
			if ((wr + fill_size) >= rd)
			{
				RTKHAL_ERR("failed 3 => (0x%x 0x%x) 0x%x\n", wr,rd, fill_size);
				return RTK_Fail;
			}
		}

		// update write point
		wr += fill_size;
		if (wr >= endPhyAddr)
		{
			wr = handle->PlayerMtpMemPool->header.beginPhyAddr;
		}
		handle->PlayerMtpMemPool->header.writePtr= wr ;

		rtk_store_system_cmd(RTK_PLAYER_RP_ADDR,RTK_SYSTEM_TYPE_INT, &rd);//monitor_system
		rtk_store_system_cmd(RTK_PLAYER_WP_ADDR,RTK_SYSTEM_TYPE_INT, &wr);//monitor_system
		
		//RTKHAL_INF("[%d]after %s %d :  wr=0x%x, rd=0x%x,beginPhyAddr=0x%x, endPhyAddr=0x%x\n", type, __FUNCTION__, __LINE__, wr, rd, beginPhyAddr, endPhyAddr);
	}
	return RTK_OK;
}

RTK_Error RHAL_Base::mDiscardInputBuffer(HAL_HANDLE_S* handle, RTK_TSInputBuffer * buffer,  HAL_TYPE type)
{
	if((handle == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(type == HAL_TYPE_DEMUX || type == HAL_TYPE_EMMDEMUX)
	{
#ifndef CLIENT_DTVSOURCE
		pthread_mutex_lock(&m_rtk_hal_mutex[handle->channel]);
		if( handle->got_mtpbuf == RTK_TRUE)
		{
			handle->got_mtpbuf = RTK_FALSE;
			m_BufInUse[handle->channel] = RTK_FALSE;
			pthread_mutex_unlock(&m_rtk_hal_mutex[handle->channel]);
		}
		else
		{
			pthread_mutex_unlock(&m_rtk_hal_mutex[handle->channel]);
			//RTKHAL_ERR("[%d][%s]doesn't get buffer first\n",type, __FUNCTION__);
			return RTK_Fail;
		}
#endif
	}
	buffer->size = 0;
	return RTK_OK;
}

/***************************************************************
* 				   Private  class functions
****************************************************************/
RTK_Error RHAL_Base::mOnceInit_AV(RTK_InputConfig input,int channel_index, HAL_TYPE hal_type)
{
	(void)input;// fix compile warning
	Rtk_AV_Create_Attr_t av_attr;
	Rtk_AV_Param_t t_av_param;
	//INT32_T  ret;
	//INT32_T  socketfd;
	//int waitCount=2000; //wait 2s

#ifdef CLIENT_DTVSOURCE
	if(m_dtvSource_isInit==false)
	{
		mMtpBufInit();
		if(RTK_OK != rtk_porting_source_init())
		{
			RTKHAL_ERR("[%s]rtk_porting_source_init failed\n", __FUNCTION__);
		}

		m_dtvSource_isInit=true;
	}
#endif	

	if(m_channelStatus[channel_index].channelState == RHAL_CHANNEL_free)
	{
#if defined(USE_SIGNAL_HANDLER)
		if(!input.disableSignalHandle)
		{
			if(signal_init(cleanup_allocated) != 0)
			{
				RTKHAL_ERR("failed to install signal_handler\n");
				return RTK_Fail;
			}
		}			
#endif
		/*INT8_T ret = RTK_OK;
		ret = rtk_porting_init();  
		if( ret != RTK_OK) 
		{
			RTKHAL_ERR("rtk_porting_init fail !!!\n");
			return RTK_Fail;
		}*/

		if(hal_type!=HAL_TYPE_DEMUX_ONLY) //demux-only-hal no need rvsd.
		{
			rtk_porting_create_rvsdSocket((RTK_RVSD_SOCKET_e)channel_index);
		}	
#ifndef CLIENT_DTVSOURCE
		rtk_porting_av_set_inputSource(RTK_DTV_INPUT_TUNER);
		rtk_porting_tuner_init();
#endif
		memset(&av_attr, 0, sizeof(av_attr));
		av_attr.e_source = RTK_AV_SOURCE_DVB;

		RTK_DvbResourceConfig_t dvbResourceConfig=m_dvbResourceConfig;
		UNUSED(dvbResourceConfig);
		int chan_index = channel_index;
		{
			pthread_mutex_lock(&m_rtk_hal_mutex[chan_index]);
                        
			av_attr.channel_id  = chan_index;
			av_attr.tuner_id  = chan_index;

			if(hal_type==HAL_TYPE_DEMUX_ONLY)
			{
				av_attr.PlayerMode=RTK_PLAY_MODE_withoutDecode;
				av_attr.e_source = RTK_AV_SOURCE_DVB;
				m_channelStatus[chan_index].channelHalType=HAL_TYPE_DEMUX_ONLY;
			}
			else if(hal_type==HAL_TYPE_DEMUX)
			{
				av_attr.PlayerMode=RTK_PLAY_MODE_default;
				av_attr.e_source = RTK_AV_SOURCE_DVB;
				m_channelStatus[chan_index].channelHalType=HAL_TYPE_DEMUX;
			}
			else if(hal_type==HAL_TYPE_PLAYER)
			{
				av_attr.PlayerMode=RTK_PLAY_MODE_fromShareMem;
				av_attr.e_source = RTK_AV_SOURCE_DVB;
				m_channelStatus[chan_index].channelHalType=HAL_TYPE_PLAYER;
			}
			else if(hal_type==HAL_TYPE_ES_PLAYER)
			{
				av_attr.PlayerMode=RTK_PLAY_MODE_fromShareMem;
				av_attr.e_source=RTK_AV_SOURCE_ES;
				m_channelStatus[chan_index].channelHalType=HAL_TYPE_ES_PLAYER;
			}

			RTKHAL_INF("av_attr.PlayerMode=%d, av_attr.e_source=%d\n", av_attr.PlayerMode, 
				av_attr.e_source);
			
			rtk_porting_av_create( av_attr, &t_av_param);	

#ifdef ANDROID

#if 0
			UINT32_T supportShmBitMap=0;
			int i=0;
	    	int revfds[RTK_SHM_TYPE_MAX];
				
		   	for(i=0; i<RTK_SHM_TYPE_MAX; i++)
		   	{
		   		revfds[i]=-1;
		   	}

			rtk_porting_av_GetShmBitMap(chan_index, &supportShmBitMap);

			if(av_attr.e_source==RTK_AV_SOURCE_DVB)
			{
				//usleep(1000*10);
				waitCount=2000;
				while(rtk_porting_av_get_sharefdSocketReady(av_attr.channel_id) == RTK_FALSE)
				{
					usleep(1000);
					waitCount--;
					if(waitCount<=0)
					{
						RTKHAL_ERR("share fd socket in server was not ready!!!\n");
						break;
					}	
				}

				int ret = ion_creat_client_socket(&socketfd);
				if(ret >= 0)
				{
					for(i=0; i<RTK_SHM_TYPE_MAX; i++)
					{
						if((supportShmBitMap>>i)&0x1)
						{	
							revfds[i]=ion_receive_share_fd(socketfd);
							RTK_DBG_ALL("[socket revfd] revfds[%d]=%d\n", i, revfds[i]);
						}
					}
				
					m_ionmem_sharefd[chan_index].channel= chan_index;
					m_ionmem_sharefd[chan_index].DTVSharefd =revfds[RTK_SHM_PLAY];
					m_ionmem_sharefd[chan_index].SectionSharefd =revfds[RTK_SHM_SECTION];
					#ifdef ENABLE_TS_CALLBACK_RECORD
					m_ionmem_sharefd[chan_index].RecSharefd= revfds[RTK_SHM_REC];
					RTKHAL_INF("[rtk_av_init]chan_index=%d RecSharefd=%ld\n",chan_index,m_ionmem_sharefd[chan_index].RecSharefd);
					#endif
					m_ionmem_sharefd[chan_index].DemuxSharefd= revfds[RTK_SHM_MTP];
					RTKHAL_INF("[rtk_av_init]chan_index=%d DTVsharefd=%ld, SectionSharefd=%ld, DemuxSharefd=%ld\n",chan_index,m_ionmem_sharefd[chan_index].DTVSharefd,m_ionmem_sharefd[chan_index].SectionSharefd,m_ionmem_sharefd[chan_index].DemuxSharefd);
					#ifdef ENABLE_VO_SEND_FRAME
					m_ionmem_sharefd[chan_index].MultiviewSharefd= revfds[RTK_SHM_MULTIVIEW];
					RTKHAL_INF("[rtk_av_init]chan_index=%d MultiviewSharefd=%ld\n",chan_index,m_ionmem_sharefd[chan_index].MultiviewSharefd);
					#endif		
					ion_close_client_soket(socketfd);
				}
				else
				{
					RTKHAL_ERR("%s(%d) ion_creat_client_socket fail !!!\n",__FUNCTION__,__LINE__);
				}
			}
#else
			if(av_attr.e_source == RTK_AV_SOURCE_DVB)
			{
				char cName[64];
				INT32_T iShareMemFd = -1;
				UINT32_T uiShmBitMap = 0;
				
				rtk_porting_av_GetShmBitMap(chan_index, &uiShmBitMap);
				
				if (uiShmBitMap & RTK_SHM_PLAY_BIT)
				{
					snprintf(cName, sizeof(cName) - 1, "%s%d", DTV_PLAY_SHAREMEM_NAME, chan_index);
					if (rtk_porting_FDSHMClient_GetFd(cName, &iShareMemFd) == RTK_OK && iShareMemFd >= 0)
					{
						m_ionmem_sharefd[chan_index].DTVSharefd = iShareMemFd;
					}
					else
					{
						RTKHAL_ERR("[%s:%d] Get %s share memory fd fail!!\n", __func__, __LINE__, cName);
					}
				}

				if (uiShmBitMap & RTK_SHM_SECTION_BIT)
				{
					snprintf(cName, sizeof(cName) - 1, "%s%d", DTV_SEC_SHAREMEM_NAME, chan_index);
					if (rtk_porting_FDSHMClient_GetFd(cName, &iShareMemFd) == RTK_OK && iShareMemFd >= 0)
					{
						m_ionmem_sharefd[chan_index].SectionSharefd = iShareMemFd;
					}
					else
					{
						RTKHAL_ERR("[%s:%d] Get %s share memory fd fail!!\n", __func__, __LINE__, cName);
					}
				}

				if (uiShmBitMap & RTK_SHM_MTP_BIT)
				{
					snprintf(cName, sizeof(cName) - 1, "%s%d", DTV_MTP_SHAREMEM_NAME, chan_index);
					if (rtk_porting_FDSHMClient_GetFd(cName, &iShareMemFd) == RTK_OK && iShareMemFd >= 0)
					{
						m_ionmem_sharefd[chan_index].DemuxSharefd = iShareMemFd;
					}
					else
					{
						RTKHAL_ERR("[%s:%d] Get %s share memory fd fail!!\n", __func__, __LINE__, cName);
					}
				}
				RTKHAL_INF("[%s]chan_index=%d DTVsharefd=%ld, SectionSharefd=%ld, DemuxSharefd=%ld\n", 
							__func__, chan_index, m_ionmem_sharefd[chan_index].DTVSharefd, 
							m_ionmem_sharefd[chan_index].SectionSharefd, m_ionmem_sharefd[chan_index].DemuxSharefd);
				
#ifdef ENABLE_VO_SEND_FRAME
				if (uiShmBitMap & RTK_SHM_MULTIVIEW_BIT)
				{
					snprintf(cName, sizeof(cName) - 1, "%s%d", DTV_MULTI_SHAREMEM_NAME, chan_index);
					if (rtk_porting_FDSHMClient_GetFd(cName, &iShareMemFd) == RTK_OK && iShareMemFd >= 0)
					{
						m_ionmem_sharefd[chan_index].MultiviewSharefd = iShareMemFd;
					}
					else
					{
						RTKHAL_ERR("[%s:%d] Get %s share memory fd fail!!\n", __func__, __LINE__, cName);
					}
					RTKHAL_INF("[%s]chan_index=%d MultiviewSharefd=%ld\n", __func__, chan_index, m_ionmem_sharefd[chan_index].MultiviewSharefd);
				}
#endif	
				m_ionmem_sharefd[chan_index].channel= chan_index;
			}

#endif
#endif //endof ANDROID	
			m_channelStatus[chan_index].channelState=RHAL_CHANNEL_allocated;
			pthread_mutex_unlock(&m_rtk_hal_mutex[chan_index]);
				
		}
		m_AvInit=RTK_TRUE;
	}

	return RTK_OK;
}

RTK_Error RHAL_Base::mCleanup_AV(int channel_id)
{
	int i = channel_id;

	if(i<0 || i>m_dtvflow_num)
	{
		RTKHAL_ERR("invalid channel id(%d)\n", channel_id);
		return RTK_Fail;
	}
	if((int)(m_ionmem_sharefd[i].DemuxSharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].DemuxSharefd);
		m_ionmem_sharefd[i].DemuxSharefd=-1;
	}
	
	if((int)(m_ionmem_sharefd[i].DTVSharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].DTVSharefd);
		m_ionmem_sharefd[i].DTVSharefd=-1;
	}
	if((int)(m_ionmem_sharefd[i].MultiviewSharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].MultiviewSharefd);
		m_ionmem_sharefd[i].MultiviewSharefd=-1;
	}
	
	if((int)(m_ionmem_sharefd[i].OSMsharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].OSMsharefd);
		m_ionmem_sharefd[i].OSMsharefd=-1;
	}
	
	if((int)(m_ionmem_sharefd[i].RecSharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].RecSharefd);
		m_ionmem_sharefd[i].RecSharefd=-1;
	}
	if((int)(m_ionmem_sharefd[i].SectionSharefd)!=-1)
	{
		close(m_ionmem_sharefd[i].SectionSharefd);
		m_ionmem_sharefd[i].SectionSharefd=-1;
	}

	rtk_porting_av_cleanup1(i);

	if(m_channelStatus[i].channelHalType!=HAL_TYPE_DEMUX_ONLY)
	{
		rtk_porting_delete_rvsdSocket((RTK_RVSD_SOCKET_e)i);
	}	
	m_channelStatus[i].channelState=RHAL_CHANNEL_free;
	m_channelStatus[i].channelHalType=HAL_TYPE_NONE;

	pthread_mutex_lock(&m_av_create_mutex);
	
	int vector_size=static_cast<int>(m_channels.size());
	int index=0;

	RTKHAL_INF("[%s:%d]:Print m_channels vector, size=%d, before erase %d\n", 
		__func__, __LINE__, vector_size, channel_id);
	for(index=0; index<vector_size; index++)
	{
		RTKHAL_INF("[%s:%d]:m_channels vector[%d]=%d.\n", __func__, __LINE__, index, m_channels[index]);
	}
	#ifdef ENABLE_GLINUX_RTK_PORTING 
	//glinux can not using std::remove
	vector<int>::iterator it = std::find(m_channels.begin(), m_channels.end(), channel_id);
	while (it != m_channels.end())
	{
		it = m_channels.erase(it);
		it = std::find(it, m_channels.end(), 5);
	}
	#else
	m_channels.erase(std::remove(m_channels.begin(), m_channels.end(), channel_id), m_channels.end());
	#endif
	
	vector_size=static_cast<int>(m_channels.size());
	RTKHAL_INF("[%s:%d]:Print m_channels vector, size=%d, after erase %d\n", 
		__func__, __LINE__, vector_size, channel_id);
	
	for(index=0; index<vector_size; index++)
	{
		RTKHAL_INF("[%s:%d]:m_channels vector[%d]=%d.\n", __func__, __LINE__, index, m_channels[index]);
	}
	pthread_mutex_unlock(&m_av_create_mutex);

	return RTK_OK;	
}

void RHAL_Base::mCleanup_AV(void)
{

	for(uint32_t j=0; j<m_channels.size(); j++)
	{
	    int i = m_channels[j];
	    RTK_DBG_ALL("%s,channel_index=%d\n",__func__,i);
	    if (i<0)
	        continue;
		if((int)(m_ionmem_sharefd[i].DemuxSharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].DemuxSharefd);
			m_ionmem_sharefd[i].DemuxSharefd=-1;
		}
		
		if((int)(m_ionmem_sharefd[i].DTVSharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].DTVSharefd);
			m_ionmem_sharefd[i].DTVSharefd=-1;
		}
		if((int)(m_ionmem_sharefd[i].MultiviewSharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].MultiviewSharefd);
			m_ionmem_sharefd[i].MultiviewSharefd=-1;
		}
		
		if((int)(m_ionmem_sharefd[i].OSMsharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].OSMsharefd);
			m_ionmem_sharefd[i].OSMsharefd=-1;
		}
		
		if((int)(m_ionmem_sharefd[i].RecSharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].RecSharefd);
			m_ionmem_sharefd[i].RecSharefd=-1;
		}
		if((int)(m_ionmem_sharefd[i].SectionSharefd)!=-1)
		{
			close(m_ionmem_sharefd[i].SectionSharefd);
			m_ionmem_sharefd[i].SectionSharefd=-1;
		}	
	}
	rtk_porting_smartcard_UnInitialize();
	rtk_porting_destory_winSurface(RTK_SURFACE_V1);
	rtk_porting_destory_winSurface(RTK_SURFACE_V2);

	for(uint32_t j=0; j<m_channels.size(); j++)
	{
	    int i = m_channels[j];
	    if (i<0)
	        continue;
	    rtk_porting_av_cleanup1(i);
		if(i==RTK_RVSD_SOCKET0 || i==RTK_RVSD_SOCKET1)
			rtk_porting_delete_rvsdSocket((RTK_RVSD_SOCKET_e)i);
	}

#ifdef CLIENT_DTVSOURCE
	if(m_dtvSource_isInit==true)
	{
		//source uninit move to server.
		//rtk_porting_source_uninit();
		mMtpBufUninit();
		m_dtvSource_isInit=false;
	}	
#endif

}

RTK_Error RHAL_Base::mCreate(RTK_InputConfig input, RTK_RecConfig rec, HAL_HANDLE_S **p_hal_handle, HAL_TYPE type,int channel_index=-1)
{
#if 1//ndef ENABLE_SOURCE_FILTER
	DEMUX_HANDLE_S *dmx_handle = NULL;
#endif	
	DEMUX_PES_HANDLE_S *dmx_pes_handle = NULL;
	HAL_HANDLE_S *hal_handle;
	//RTK_Error	ret = RTK_Fail;
	INT8_T	tmpValue=2;
	INT32_T IonShareFd=-1;
	INT32_T IonFd=-1;
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        INT32_T Rtk_IonFd=-1;
        #endif
	INT32_T size=0;
	ion_user_handle_t      IonHandle;
	INT8_T *noncacheable=&tmpValue;  
	INT32_T	IonMapFd=-1;
	void	*VirAddr=NULL;
	ULONG_T Buffer_Physical = 0;//for recored MTP buffer addr

	(void)type;	// fix compile warning
	(void)rec;

	*p_hal_handle = (HAL_HANDLE_S*)malloc(sizeof(HAL_HANDLE_S));

	if( *p_hal_handle == NULL )
	{
		return RTK_Fail;
	}
	
	hal_handle = *p_hal_handle;

	memset(hal_handle, 0x00, sizeof(HAL_HANDLE_S));

	hal_handle->create_by_duplicate = RTK_FALSE;
	hal_handle->isRecording = RTK_FALSE;
	hal_handle->m_bGetCCdata = false;
	hal_handle->type = type;
	hal_handle->m_subtitle.pid = TS_INVALID_PID;
	
	RTKHAL_INF("input.type=%d\n", input.type);

	// decide channel
	hal_handle->channel = channel_index; 
	m_channelStatus[channel_index].channelState = RHAL_CHANNEL_using;

	RTKHAL_INF("hal_handle->channel=%d, type=%d\n", hal_handle->channel, type);

	// create av
	Rtk_AV_Param_t t_av_param;
	Rtk_AV_Create_Attr_t av_attr;
	memset(&av_attr, 0, sizeof(av_attr));
	if(type==HAL_TYPE_ES_PLAYER)
		av_attr.e_source = RTK_AV_SOURCE_ES;
	else
		av_attr.e_source = RTK_AV_SOURCE_DVB;
	
	av_attr.channel_id = hal_handle->channel;
	av_attr.tuner_id  = hal_handle->channel; //please fix me?? tuner id should be not equal to channle id.
	rtk_porting_av_create(av_attr, &t_av_param);

	if(type!= HAL_TYPE_ES_PLAYER)
	{
		// create demux
		#ifndef ENABLE_SOURCE_FILTER
		rtk_porting_SectionFilterCreate(&dmx_handle, hal_handle->channel);
		#endif
		
		if(RTK_OK != rtk_porting_CreatePesFilter(&dmx_pes_handle, hal_handle->channel))
		{
			RTKHAL_ERR("create pes filter error!!! channel=%d \n", hal_handle->channel);
		}
	}
	
	hal_handle->used = RTK_TRUE;
	hal_handle->av_handle = t_av_param.av_handle;
	#ifndef ENABLE_SOURCE_FILTER
	hal_handle->dmx_handle = dmx_handle;
	#endif
	hal_handle->dmx_pes_handle = dmx_pes_handle;

	hal_handle->speed = 1;
	RTK_BOOL isSMP = RTK_FALSE;
	if(rtk_porting_av_getSMP(av_attr.channel_id) == RTK_TRUE)
	{
		isSMP = RTK_TRUE;
	}

	pthread_mutex_init(&hal_handle->mutex, NULL);
	
	// setting input
	if(input.type == RTK_INPUT_SOURCE)
	{
		RTKHAL_INF("[%s-%d]_xCreate input Source.\n",__func__,__LINE__);
	}
	else if(input.type == RTK_INPUT_TUNER) // tuner
	{
		RTKHAL_INF("[%s-%d]_xCreate input tuner.\n",__func__,__LINE__);
		Rtk_Tuner_Param_t tuner_param;
		memset(&tuner_param, 0x00, sizeof(Rtk_Tuner_Param_t));
		
		if(input.tuner.type == RTK_TUNER_TYPE_DVBC)
		{
			//input ex:730,1,6875000
			tuner_param.type = RTK_TUNER_TYPE_DVB_C;
			tuner_param.bandwidth =(Rtk_Tuner_Bandwidth_e) input.tuner.bandwidth;
			tuner_param.tnr_param.dvb_c_param.u32frequency=input.tuner.tnr_param.dvb_c_param.u32frequency*1000*1000;
			tuner_param.tnr_param.dvb_c_param.u32symbol_rate=input.tuner.tnr_param.dvb_c_param.u32symbol_rate;
			tuner_param.tnr_param.dvb_c_param.modulation=(Rtk_CableTnr_Modulation_e)input.tuner.tnr_param.dvb_c_param.modulation;
			tuner_param.tnr_param.dvb_c_param.annex_type = (Rtk_DVBC_ANNEX_TYPE_e)input.tuner.tnr_param.dvb_c_param.annex_type;
			RTKHAL_INF("DVBC input tuner.u32frequency=%u\n",tuner_param.tnr_param.dvb_c_param.u32frequency);
			RTKHAL_INF("DVBC input tuner.u32symbol_rate=%u\n",tuner_param.tnr_param.dvb_c_param.u32symbol_rate);
			RTKHAL_INF("DVBC input tuner.modulation=%d\n",(int)tuner_param.tnr_param.dvb_c_param.modulation);
			RTKHAL_INF("DVBC input tuner.annex_type=%d\n",(int)tuner_param.tnr_param.dvb_c_param.annex_type);
			RTKHAL_INF("DVBC input tuner.bandwidth=%d\n",(int)tuner_param.bandwidth);
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_DVB_T )
		{
			//input ex:730
			tuner_param.type = RTK_TUNER_TYPE_DVBT;
			tuner_param.bandwidth =(Rtk_Tuner_Bandwidth_e) input.tuner.bandwidth;
			tuner_param.tnr_param.dvb_t_param.u32frequency=input.tuner.tnr_param.dvb_t_param.u32frequency*1000*1000;
			RTKHAL_INF("[%s-%d] DVBT input tuner.u32frequency = %u bandwidth = %s\n",
						__func__,
						__LINE__,
						tuner_param.tnr_param.dvb_t_param.u32frequency,
						GET_BANDWIDTH_STR(tuner_param.bandwidth));
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_DVB_T2 )
		{
			//input ex:730
			tuner_param.type = RTK_TUNER_TYPE_DVBT2;
			tuner_param.bandwidth =(Rtk_Tuner_Bandwidth_e) input.tuner.bandwidth;
			tuner_param.tnr_param.dvb_t_param.u32frequency=input.tuner.tnr_param.dvb_t_param.u32frequency*1000*1000;
			RTKHAL_INF("[%s-%d] DVBT2 input tuner.u32frequency = %u bandwidth = %s\n",
						__func__,
						__LINE__,
						tuner_param.tnr_param.dvb_t_param.u32frequency,
						GET_BANDWIDTH_STR(tuner_param.bandwidth));		
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_DTMB)
		{	
			//input ex:730
			tuner_param.type = RTK_TUNER_TYPE_DTMB_T;
			tuner_param.tnr_param.dtmb_t_param.u32frequency=input.tuner.tnr_param.dtmb_t_param.u32frequency*1000*1000;
			RTKHAL_INF("[%s-%d] DTMB input tuner.u32frequency=%u\n",__func__,__LINE__,tuner_param.tnr_param.dtmb_t_param.u32frequency);
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_ABS)
		{
			//input ex:730
			tuner_param.type = RTK_TUNER_TYPE_ABS_S;
			tuner_param.tnr_param.abs_s_param.u32frequency=input.tuner.tnr_param.abs_s_param.u32frequency*1000*1000;
			RTKHAL_INF("[%s-%d] ABS input tuner.u32frequency=%u\n",__func__,__LINE__,tuner_param.tnr_param.abs_s_param.u32frequency);	
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_DVB_S)
		{
			tuner_param.type = RTK_TUNER_TYPE_DVBS;
			tuner_param.tnr_param.dvb_s_param.u32frequency =input.tuner.tnr_param.dvb_s_param.u32frequency*1000*1000;
			tuner_param.tnr_param.dvb_s_param.lnbmode =(Rtk_LNB_MODE_e) input.tuner.tnr_param.dvb_s_param.lnbmode;
			tuner_param.tnr_param.dvb_s_param.u32symbol_rate =input.tuner.tnr_param.dvb_s_param.u32symbol_rate ;
			RTKHAL_INF("[%s-%d] DVBS input tuner.u32frequency = %u lnbmode = %s symbolrate = %u\n",
						__func__,
						__LINE__,
						tuner_param.tnr_param.dvb_t_param.u32frequency,
						GET_LNBMODE_STR(tuner_param.tnr_param.dvb_s_param.lnbmode),
						tuner_param.tnr_param.dvb_s_param.u32symbol_rate);	
		}
		else if(input.tuner.type == RTK_TUNER_TYPE_DVB_S2)
		{
			tuner_param.type = RTK_TUNER_TYPE_DVBS2;
			tuner_param.tnr_param.dvb_s_param.u32frequency =input.tuner.tnr_param.dvb_s_param.u32frequency*1000*1000;
			tuner_param.tnr_param.dvb_s_param.lnbmode =(Rtk_LNB_MODE_e) input.tuner.tnr_param.dvb_s_param.lnbmode;
			tuner_param.tnr_param.dvb_s_param.u32symbol_rate =input.tuner.tnr_param.dvb_s_param.u32symbol_rate ;
			RTKHAL_INF("[%s-%d] DVBS2 input tuner.u32frequency = %u lnbmode = %s symbolrate = %u\n",
						__func__,
						__LINE__,
						tuner_param.tnr_param.dvb_t_param.u32frequency,
						GET_LNBMODE_STR(tuner_param.tnr_param.dvb_s_param.lnbmode),
						tuner_param.tnr_param.dvb_s_param.u32symbol_rate);
		}
		
		if(input.tuner.type >= RTK_TUNER_TYPE_DVBC && input.tuner.type <= RTK_TUNER_TYPE_DVB_T2)
		{
#ifdef CLIENT_DTVSOURCE
			// TODO: this is test code to transfer tuner_param to source_param
			Rtk_Porting_Source_Param_t source_param;
			source_param.type = tuner_param.type == RTK_TUNER_TYPE_DVB_C ? RTK_PORTING_SOURCE_TYPE_DVB_C : 
								tuner_param.type == RTK_TUNER_TYPE_DVBT ? RTK_PORTING_SOURCE_TYPE_DVBT : 
								tuner_param.type == RTK_TUNER_TYPE_DVBT2 ? RTK_PORTING_SOURCE_TYPE_DVBT2 :
								tuner_param.type == RTK_TUNER_TYPE_DVBS ? RTK_PORTING_SOURCE_TYPE_DVBS : 
								tuner_param.type == RTK_TUNER_TYPE_DVBS2 ? RTK_PORTING_SOURCE_TYPE_DVBS2 :
								tuner_param.type == RTK_TUNER_TYPE_DTMB_T ? RTK_PORTING_SOURCE_TYPE_DTMB_T : RTK_PORTING_SOURCE_TYPE_DVB_C;

			source_param.bandwidth = tuner_param.bandwidth;
			memcpy( &source_param.tnr_param , &tuner_param.tnr_param, sizeof(tuner_param.tnr_param) );
			source_param.isSMP = isSMP;
			source_param.isPullMode = false;
			if(RTK_OK != rtk_porting_source_create(source_param, &hal_handle->internal_source))
			{
				RTKHAL_ERR("rtk_porting_source_create %d faild\n", source_param.type);
				return RTK_Fail;
			}
			RTKHAL_INF("hal_handle->internal_source is %p\n", hal_handle->internal_source);
			if(RTK_OK != rtk_porting_av_SetSource(hal_handle->av_handle ,hal_handle->internal_source))
			{
				RTKHAL_ERR("rtk_porting_av_SetSource %p faild\n", hal_handle->internal_source);
				rtk_porting_source_destroy(hal_handle->internal_source);
				hal_handle->internal_source = 0;
				return RTK_Fail;
			}
			m_uiTunerChannel = hal_handle->channel;
			hal_handle->connect_source = hal_handle->internal_source;

			#ifdef ENABLE_SOURCE_FILTER
			MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
			if(mCreateSourceSectionFilter(hal_handle->connect_source)!=RTK_OK)
			{
				rtk_porting_source_destroy(hal_handle->internal_source);
				hal_handle->internal_source = 0;
				hal_handle->connect_source =0;
				MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
				return RTK_Fail;
			}		
			MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
			#endif
#else
			char tuner_lock_ret = rtk_porting_tuner_scanning(hal_handle->channel, tuner_param);
			if(tuner_lock_ret != RTK_OK)
			{
				RTKHAL_ERR("rtk_porting_tuner_scanning fail\n");
				return RTK_Fail;
			}
#endif
		}
		hal_handle->AVSyncMode = RTK_NAV_AVSYNC_SYSTEM_MASTER_BY_PCR;	//default AV SYNC mode for tuner
	}
	else if(input.type == RTK_INPUT_MEMORY_MD)
	{
#ifdef CLIENT_DTVSOURCE
		Rtk_Porting_Source_Param_t source_param;
		source_param.type = RTK_PORTING_SOURCE_TYPE_MD;
		source_param.isSMP = isSMP;
		source_param.isPullMode = false;
		if(RTK_OK != rtk_porting_source_create(source_param, &hal_handle->internal_source))
		{
			RTKHAL_ERR("rtk_porting_source_create %d faild\n", source_param.type);
			return RTK_Fail;
		}
		RTKHAL_INF("hal_handle->internal_source is %p\n", hal_handle->internal_source);
		if(RTK_OK != rtk_porting_av_SetSource(hal_handle->av_handle ,hal_handle->internal_source))
		{
			RTKHAL_ERR("rtk_porting_av_SetSource %p faild\n", hal_handle->internal_source);
			rtk_porting_source_destroy(hal_handle->internal_source);
			hal_handle->internal_source = 0;
			return RTK_Fail;
		}
		hal_handle->connect_source = hal_handle->internal_source;
		hal_handle->mtp_ion = NULL;
		#ifdef ENABLE_SOURCE_FILTER
		MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
		if(mCreateSourceSectionFilter(hal_handle->connect_source)!=RTK_OK)
		{
			rtk_porting_source_destroy(hal_handle->internal_source);
			hal_handle->internal_source = 0;
			hal_handle->connect_source =0;
			MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
			return RTK_Fail;
		}		
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		#endif
#else
		return RTK_Fail;
#endif
	}
	else if(type==HAL_TYPE_DEMUX || type==HAL_TYPE_DEMUX_ONLY)
	{
#ifdef CLIENT_DTVSOURCE
		hal_handle->mtp_ion = mMtpBufPreLend();
		if (hal_handle->mtp_ion == NULL)
		{
			RTKHAL_ERR("[%s]mMtpBufPreLend failed\n", __FUNCTION__);
			return RTK_Fail;
		}

		Rtk_Porting_Source_Param_t source_param;
		source_param.type = RTK_PORTING_SOURCE_TYPE_MTP;
		source_param.tnr_param.mm_param.phyAddr = (unsigned int)hal_handle->mtp_ion->ion_phy;
		source_param.tnr_param.mm_param.len = MTP_BUF_SIZE;
		source_param.isSMP = isSMP;
		source_param.isPullMode = true;
		if(RTK_OK != rtk_porting_source_create(source_param, &hal_handle->internal_source))
		{
			if(hal_handle->mtp_ion) mMtpBufReturn(hal_handle->mtp_ion);
			RTKHAL_ERR("rtk_porting_source_create %d faild\n", source_param.type);
			return RTK_Fail;
		}
		RTKHAL_INF("hal_handle->internal_source is %p\n", hal_handle->internal_source);
		if(RTK_OK != rtk_porting_av_SetSource(hal_handle->av_handle ,hal_handle->internal_source))
		{
			RTKHAL_ERR("rtk_porting_av_SetSource %p faild\n", hal_handle->internal_source);
			if(hal_handle->mtp_ion) mMtpBufReturn(hal_handle->mtp_ion);
			rtk_porting_source_destroy(hal_handle->internal_source);
			hal_handle->internal_source = 0;
			return RTK_Fail;
		}
		hal_handle->connect_source = hal_handle->internal_source;
		hal_handle->mtp_ion = NULL;

		#ifdef ENABLE_SOURCE_FILTER
		MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
		if(mCreateSourceSectionFilter(hal_handle->connect_source)!=RTK_OK)
		{
			MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
			if(hal_handle->mtp_ion) mMtpBufReturn(hal_handle->mtp_ion);
			rtk_porting_source_destroy(hal_handle->internal_source);
			hal_handle->internal_source = 0;
			hal_handle->connect_source =0;
			return RTK_Fail;
		}		
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		#endif

		mMtpBufSetSource(hal_handle->mtp_ion, hal_handle->internal_source, RTK_PORTING_SOURCE_TYPE_MTP);
#else
		//open demux
		IonShareFd = m_ionmem_sharefd[channel_index].DemuxSharefd;


	#ifdef ANDROID
                #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                VirAddr= ExtIonGetShareMemory(&IonFd,&Rtk_IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
                #else
		VirAddr= IonGetShareMemory(&IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
                #endif
	#endif

		RTKHAL_INF("##PhyAddr=0x%lx,mIonMmapFd=%d,mViraddr=0x%x,size=%d\n",Buffer_Physical,IonMapFd,(INT32_T)VirAddr,size);
			
		hal_handle->DemuxMtpMemSize	= size;
		hal_handle->DemuxMtpMemMapfd 	= IonMapFd; 	
		hal_handle->DemuxMtpMemPool	= (Mtp_Mem_Pool_t *)VirAddr;		
		hal_handle->DemuxMtpMemIonFd 	= IonFd;
#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        hal_handle->DemuxMtpMemRtkIonFd = Rtk_IonFd;
#endif
		hal_handle->DemuxMtpMemIonHandle = IonHandle;
			
		if((hal_handle->DemuxMtpMemPool == NULL)||((unsigned int)(hal_handle->DemuxMtpMemPool) == 0xFFFFFFFF))
		{
			RTKHAL_ERR("rtk_porting_GetMTPBufferPhyAddr wrong, mmap fail!\n");
			return RTK_Fail;
		}
		else
		{
			RTKHAL_INF("hal_handle->DemuxMtpMemPool = %p, hal_handle->av_handle=%d\n", hal_handle->DemuxMtpMemPool, hal_handle->av_handle);
		}

		if(rtk_porting_TunerControlMTP_Init(hal_handle->av_handle, hal_handle->channel, ((input.isEncrypt==RTK_TRUE)? 1: 0) )!=RTK_OK)
		{
			RTKHAL_INF("demux rtk_porting_TunerControlMTP_Init failed\n");
			return RTK_Fail;
		}
		RTKHAL_INF("demux rtk_porting_TunerControlMTP_Init success.\n");
#endif
	}
	else if(type==HAL_TYPE_PLAYER)
	{

		IonShareFd = m_ionmem_sharefd[channel_index].DTVSharefd;
#ifdef ANDROID
                #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                VirAddr= ExtIonGetShareMemory(&IonFd,&Rtk_IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
                #else
		VirAddr= IonGetShareMemory(&IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
                #endif
#endif

		RTKHAL_INF("##PhyAddr=%lx,mIonMmapFd=%d,mViraddr=0x%x,size=%d\n",Buffer_Physical,IonMapFd,(INT32_T)VirAddr,size);
			
		hal_handle->PlayerMtpMemSize	= size;
		hal_handle->PlayerMtpMemMapfd 	= IonMapFd; 	
		hal_handle->PlayerMtpMemPool	= (RTK_RingMem_Pool_t *)VirAddr;		
		hal_handle->PlayerMtpMemIonFd 	= IonFd;
#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        hal_handle->PlayerMtpMemRtkIonFd = Rtk_IonFd;
#endif
		hal_handle->PlayerMtpMemIonHandle = IonHandle;
			
		if((hal_handle->PlayerMtpMemPool == NULL)||((unsigned int)(hal_handle->PlayerMtpMemPool) == 0xFFFFFFFF))
		{
			RTKHAL_ERR("rtk_porting_GetMTPBufferPhyAddr wrong, mmap fail!\n");
			return RTK_Fail;
		}
		else
		{
			RTKHAL_INF("hal_handle->PlayerMtpMemPool = %p\n", hal_handle->PlayerMtpMemPool);
		}

		//reset size to origin_size;
		hal_handle->PlayerMtpMemPool->header.writePtr = hal_handle->PlayerMtpMemPool->header.beginPhyAddr;
		hal_handle->PlayerMtpMemPool->header.readPtr = hal_handle->PlayerMtpMemPool->header.beginPhyAddr;
		
		hal_handle->PlayerMtpMemPool->header.bufAlign=0;
		hal_handle->PlayerMtpMemPool->header.size=hal_handle->PlayerMtpMemPool->header.origin_size;
		hal_handle->PlayerMtpMemPool->header.endPhyAddr=hal_handle->PlayerMtpMemPool->header.beginPhyAddr+
			hal_handle->PlayerMtpMemPool->header.size;
		
        rtk_porting_SectionFilterCreate(&dmx_handle, hal_handle->channel);
        hal_handle->dmx_handle = dmx_handle;
        
        RHAL_ThreadParam_t *pThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
        pThreadParam->halHandle=hal_handle;
        pThreadParam->instance=this;
        pThreadParam->bUseSourceFilter = false;
        pthread_create(&((*p_hal_handle)->sec_callback_thread), NULL, mThreadSectionReadyEntry, pThreadParam);
        
	}
	else if(type==HAL_TYPE_ES_PLAYER)
	{
		char bufname[128];
		int sharefd=-1;
		UINT8_T *pbuf=NULL;
		UINT32_T size=0;
		memset(bufname, 0x00, sizeof(bufname));

		sprintf(bufname, "sample_%d", hal_handle->channel);
		rtk_porting_FDSHMClient_GetFd(bufname, &sharefd);

		if(sharefd==-1)
		{
			RTKHAL_ERR("get bufname: share fd failed\n");
			return RTK_Fail;
		}

		hal_handle->handle_ionMapped_esbuf=rtk_porting_map_ionmem(sharefd, &pbuf, &size);

		if(hal_handle->handle_ionMapped_esbuf==NULL)
		{
			RTKHAL_ERR("handle_ionMapped_esbuf, rtk_porting_map_ionmem failed\n");
			return RTK_Fail;
		}

		RTKHAL_INF("es player, bufname=%s, pbuf=%p\n", bufname, pbuf);
		hal_handle->pEsRingbuf_header=(RTK_RingMem_Pool_Header_t*)pbuf;
		hal_handle->pEsbufVirt=pbuf;

	}
	else
	{
		RTKHAL_ERR("Error HAL type(%d)!\n", type);
		return RTK_Fail;
	}

#ifdef ENABLE_VO_SEND_FRAME

	IonShareFd = m_ionmem_sharefd[channel_index].MultiviewSharefd;
#ifdef ANDROID
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        VirAddr= ExtIonGetShareMemory(&IonFd,&Rtk_IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
        #else
	VirAddr= IonGetShareMemory(&IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable, &Buffer_Physical,&IonHandle);
        #endif
#endif

	RTKHAL_INF("##PhyAddr=%lx,mIonMmapFd=%d,mViraddr=0x%x,size=%d\n",Buffer_Physical,IonMapFd,(INT32_T)VirAddr,size);	
	hal_handle->MultiviewMemSize	= size;
	hal_handle->MultiviewMemMapfd 	= IonMapFd; 	
	hal_handle->MultiviewMemBuffer	= (uint8_t *)VirAddr;		
	hal_handle->MultiviewMemIonFd 	= IonFd;
	hal_handle->MultiviewMemIonHandle = IonHandle;
			
	if((hal_handle->MultiviewMemBuffer == NULL)||((unsigned int)(hal_handle->MultiviewMemBuffer) == 0xFFFFFFFF))
	{
		RTKHAL_ERR("rtk_porting_MultiviewMemBuffer wrong, mmap fail!\n");
		return RTK_Fail;
	}
	else
	{
		RTKHAL_INF("hal_handle->MultiviewMemBuffer = %p\n", hal_handle->MultiviewMemBuffer);
	}
#endif	

	// flush MTP and blocking other user( e.g. EmmDemux)
	int check_cnt = 0;
	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	while( m_BufInUse[hal_handle->channel] == RTK_TRUE )
	{
		pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);
		check_cnt++;
		if(check_cnt>10000)
		{
			RTKHAL_ERR("[%s] MTP buffer blocking by someone\n", __FUNCTION__);
			return RTK_Fail;
		}
		RTKHAL_WRN("[%s] g_BufInUse[%d], try again %d!!\n", __FUNCTION__,hal_handle->channel, check_cnt);
		usleep(RTK_CREATE_SLEEP_S);
		pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	}
	//for mtp
	//rtk_porting_TunerControlMtpFlush(_xGet_AvHandle(hal_handle));
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);

	hal_handle->got_mtpbuf = RTK_FALSE;
	hal_handle->last_got_time = 0;
	
	//hal_handle->AVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO;
	hal_handle->AVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO_SKIP;

	if(type!=HAL_TYPE_ES_PLAYER)
	{
		//create section callback thread.
		RHAL_ThreadParam_t *pThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
		pThreadParam->halHandle=hal_handle;
		pThreadParam->instance=this;

		//mThreadSectionReadyEntry will free pThreadParam;
		#ifndef ENABLE_SOURCE_FILTER
		pthread_create(&((*p_hal_handle)->sec_callback_thread), NULL, mThreadSectionReadyEntry, pThreadParam);
		#endif

		//create pes callback thread.
		//mThreadPesReadyEntry will free pPesThreadParam;
		RHAL_ThreadParam_t *pPesThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
		pPesThreadParam->halHandle=hal_handle;
		pPesThreadParam->instance=this;

		pthread_create(&((*p_hal_handle)->pes_callback_thread), NULL, mThreadPesReadyEntry, pPesThreadParam);

	}

	return RTK_OK;
}

void* RHAL_Base::mThreadSectionReadyEntry(void* param)
{
	if(param==NULL)
	{
		RTKHAL_ERR("[%s] param is NULL ???\n", __FUNCTION__);
		return NULL;
	}	
	
	RHAL_ThreadParam_t *hal_param=(RHAL_ThreadParam_t *)param;

	RHAL_Base* pThis = (RHAL_Base*)(hal_param->instance);
	//pThis->mSection_Ready_Thread((void*)hal_param->halHandle);

	//free(hal_param);
	pThis->mSection_Ready_Thread(param);

	return NULL;

}

void* RHAL_Base::mThreadPesReadyEntry(void* param)
{
	if(param==NULL)
	{
		RTKHAL_ERR("[%s] param is NULL ???\n", __FUNCTION__);
		return NULL;
	}	
	
	RHAL_ThreadParam_t *hal_param=(RHAL_ThreadParam_t *)param;

	RHAL_Base* pThis = (RHAL_Base*)(hal_param->instance);
	pThis->mPes_Ready_Thread((void*)hal_param->halHandle);

	free(hal_param);

	return NULL;

}
/**
* @brief
* This function will prepare the cc process callback function with parameter pointer.Note this function is static type.
*
* @param[in]	param		     an pointer that will be transfered to strucrt HAL_HANDLE_S type
*
* @retval		NULL		    parameters error occurred or process end 
*
*/
void* RHAL_Base::mThreadCCEnableEntry(void* param)
{
	if(param==NULL){
		RTKHAL_ERR("[%s] param is NULL ???\n", __FUNCTION__);
		return NULL;
	}
	RHAL_ThreadParam_t *hal_param=(RHAL_ThreadParam_t *)param;
	RHAL_Base* pThis = (RHAL_Base*)(hal_param->instance);
	pThis->mCC_Ready_Thread((void*)hal_param->halHandle);
	free(hal_param);
	return NULL;
}

RTK_Error RHAL_Base::mDestroy(HAL_HANDLE_S* handle)
{
	if(handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	if (handle->create_by_duplicate)
	{
		_xFree_Handle(handle);
		return RTK_OK;
	}

	//unmap secure play share memory.
	if(handle->pSecurePlayShmHandle)
	{
		rtk_porting_unmap_ionmem(handle->pSecurePlayShmHandle);
		handle->pSecurePlayShmHandle=NULL;
		handle->pSecurePlayShm_virt=NULL;
		handle->securePlayShm_size=0;
	}
	if(handle->securePlayShm_fd>0)
	{
		close(handle->securePlayShm_fd);
		handle->securePlayShm_fd=-1;
	}

	if(handle->isSecurePlayShmUsed==true)
	{
		rtk_porting_av_enableSecurePlayShm(handle->av_handle, RTK_FALSE);
		handle->isSecurePlayShmUsed=false;
	}

	if(handle->m_subtitle.pid != TS_INVALID_PID)
	{
		rtk_porting_av_RemoveSubtitle(handle->av_handle,handle->m_subtitle.pid,handle->m_subtitle.subtype);
		memset(&handle->m_subtitle,0,sizeof(Rtk_Subtitle_Info_t));
		handle->m_subtitle.pid = TS_INVALID_PID;
	}

	pthread_mutex_lock(&handle->mutex);
	handle->stop_thread = 1;
	handle->isRecording = RTK_FALSE;
	pthread_mutex_unlock(&handle->mutex);

#if 1//ndef ENABLE_SOURCE_FILTER
	if(handle->sec_callback_thread){
		pthread_join(handle->sec_callback_thread, NULL);
		handle->sec_callback_thread = 0 ;
	}
#endif

	if(handle->pes_callback_thread)
	{
		pthread_join(handle->pes_callback_thread, NULL);
		handle->pes_callback_thread = 0;
	}
	
	if(handle->rec_callback_thread)
	{
		pthread_join(handle->rec_callback_thread, NULL);
		handle->rec_callback_thread = 0;
	}

	pthread_mutex_lock(&handle->mutex);
	//add by changxi_haung
	for(DataUnit_t*pTmp = handle->m_CCData.pHead;pTmp != NULL;){
		DataUnit_t* pNext = pTmp->next;
		if(pTmp->pData != NULL){
			free(pTmp->pData);
			pTmp->pData = NULL;
		}
		free(pTmp);
		pTmp = pNext;
	}
	//add end
	pthread_mutex_unlock(&handle->mutex);

	pthread_mutex_lock(&m_rtk_hal_mutex[handle->channel]);
		
	if( handle->got_mtpbuf == RTK_TRUE)
	{
		RTKHAL_WRN("[%s]Should discard buffer first!\n", __FUNCTION__);
		handle->got_mtpbuf = RTK_FALSE;
		m_BufInUse[handle->channel] = RTK_FALSE;
	}
	pthread_mutex_unlock(&m_rtk_hal_mutex[handle->channel]);

	if((handle->DemuxMtpMemPool != NULL)&&((unsigned int)(handle->DemuxMtpMemPool) != 0xffffffff))
	{       
		//munmap(handle->MtpMemPool, DTV_SHARED_MEMORY_SIZE);
#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        ExtIonPutShareMemory(handle->DemuxMtpMemPool, handle->DemuxMtpMemSize, handle->DemuxMtpMemIonFd,
                             handle->DemuxMtpMemRtkIonFd ,handle->DemuxMtpMemMapfd, handle->DemuxMtpMemIonHandle);
#else
		IonPutShareMemory(handle->DemuxMtpMemPool,handle->DemuxMtpMemSize,handle->DemuxMtpMemIonFd, handle->DemuxMtpMemMapfd,handle->DemuxMtpMemIonHandle);
#endif
		rtk_porting_TunerControlMTP_UnInit(_xGet_AvHandle(handle), handle->channel);//if DemuxMtpMemPool exit, MTP will be used.
	}

	if((handle->PlayerMtpMemPool != NULL)&&((unsigned int)(handle->PlayerMtpMemPool) != 0xffffffff))
	{       
		//munmap(handle->MtpMemPool, DTV_SHARED_MEMORY_SIZE);
#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        ExtIonPutShareMemory(handle->PlayerMtpMemPool, handle->PlayerMtpMemSize,handle->PlayerMtpMemIonFd,
                             handle->PlayerMtpMemRtkIonFd, handle->PlayerMtpMemMapfd, handle->PlayerMtpMemIonHandle);
#else
		IonPutShareMemory(handle->PlayerMtpMemPool,handle->PlayerMtpMemSize,handle->PlayerMtpMemIonFd, handle->PlayerMtpMemMapfd,handle->PlayerMtpMemIonHandle);
#endif
	}

	if(handle->handle_ionMapped_esbuf != NULL)
	{
		rtk_porting_unmap_ionmem(handle->handle_ionMapped_esbuf);
		handle->handle_ionMapped_esbuf=NULL;
	}		

	if(handle->type != HAL_TYPE_ES_PLAYER)
	{
		if(handle->rec_secbuf_fd>0)
		{
			close(handle->rec_secbuf_fd);
			handle->rec_secbuf_fd=-1;
		}
		
		rtk_porting_record_destory(_xGet_AvHandle(handle));

		#ifndef ENABLE_SOURCE_FILTER
		rtk_porting_SectionFilterDestory(_xGet_DmxHandle(handle));
		#endif
		
		if(RTK_OK !=rtk_porting_DestroyPesFilter(_xGet_DmxPESHandle(handle)))
		{
			RTKHAL_WRN("dectroy pes filter failed \n");
		}
	}
	
#ifdef CLIENT_DTVSOURCE

	if(handle->mtp_ion != NULL)
	{
		mMtpBufReturn(handle->mtp_ion);
		handle->mtp_ion = NULL;
	}
	if(handle->connect_source != 0)
	{
		handle->connect_source = 0;
		rtk_porting_av_SetSource(handle->av_handle ,0);
	}
	if(handle->internal_source != 0)
	{
	#ifdef ENABLE_SOURCE_FILTER
		MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
		mDestroySourceSectionFilter(handle->internal_source);
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#endif
		rtk_porting_source_destroy(handle->internal_source);
		handle->internal_source = 0;
	}
#endif

	rtk_porting_av_destory(_xGet_AvHandle(handle));

	pthread_mutex_destroy(&handle->mutex);

	m_channelStatus[handle->channel].channelState = RHAL_CHANNEL_allocated;


	_xFree_Handle(handle);
	return RTK_OK;
}

void RHAL_Base::mPlayback_Callback_Entry(INT32_T data)
{
	RHAL_GetHalInstance()->mPlayback_Callback(data);
}

void RHAL_Base::mPlayback_Callback(INT32_T data)
{
	INT32_T channel_id = (data&0xFFFF0000)>>16;
	INT32_T av_event = data&0xFFFF;
	
	RTKHAL_INF("[%s] data=0x%08x, channelID=%d, EventID=%d\n", __FUNCTION__, data, channel_id, av_event);
	if(channel_id > RTK_MAX_CHANNEL_NO-1)
	{
		RTKHAL_ERR("[%s] channel_id=%d, channel id error!!\n",__FUNCTION__, channel_id);
		return;
	}
	
	HAL_HANDLE_S *pCurPlayer_Handle = NULL;
		
	pthread_mutex_lock(&m_rtk_hal_mutex[channel_id]);
	if (m_pCurHal_Handle[channel_id])
	{
		pCurPlayer_Handle = m_pCurHal_Handle[channel_id];
	}
	pthread_mutex_unlock(&m_rtk_hal_mutex[channel_id]);
	
	RTK_CallbackEvent cbEvent=RTK_CB_EVENT_MAX;
	switch(av_event)
	{
		case RTK_AUDIO_FIRST_FRAME_READY:
			RTKHAL_INF("[%s] RTK_AUDIO_FIRST_FRAME_READY\n",__FUNCTION__);
			cbEvent = RTK_FIRST_AUDIO_FRAME_DECODED;
			break;
		case RTK_VIDEO_FIRST_FRAME_READY:
			RTKHAL_INF("[%s] RTK_VIDEO_FIRST_FRAME_READY\n",__FUNCTION__);
			//if(pCurPlayer_Handle){
			//Player_SendDisplayInfoToHdmiSer((RTK_Player) pCurPlayer_Handle, pCurPlayer_Handle->player_config.video.output);
			//}
			cbEvent = RTK_FIRST_IFRAME_DISPLAYED;
			RTK_GET_TIME(&zapping_end);
			
			if((uint64_t)(zapping_start3.tv_sec*1000000+zapping_start3.tv_usec)>0)
			{
				RTK_GET_SPEND_TIME(&zapping_start3,&zapping_end,&zapping_timeuse);
				RTK_INFO_ZAPPING_TIME("RTK_Player_Pause~RTK_VIDEO_FIRST_FRAME_READY",zapping_timeuse);
				zapping_start3.tv_sec=0;
				zapping_start3.tv_usec=0;
			}

			if((uint64_t)(zapping_start2.tv_sec*1000000+zapping_start2.tv_usec)>0)
			{
				RTK_GET_SPEND_TIME(&zapping_start2,&zapping_end,&zapping_timeuse);
				RTK_INFO_ZAPPING_TIME("RTK_Player_ChangeVideo~RTK_VIDEO_FIRST_FRAME_READY",zapping_timeuse);
				zapping_start2.tv_sec=0;
				zapping_start2.tv_usec=0;
			}

			if((uint64_t)(zapping_start.tv_sec*1000000+zapping_start.tv_usec)>0)
			{
				RTK_GET_SPEND_TIME(&zapping_start,&zapping_end,&zapping_timeuse);
				RTK_INFO_ZAPPING_TIME("RTK_Player_Stop~RTK_VIDEO_FIRST_FRAME_READY",zapping_timeuse);
				zapping_start.tv_sec=0;
				zapping_start.tv_usec=0;
			}
			break;
		case RTK_AV_EOS:
			RTKHAL_INF("[%s] RTK_AV_EOS\n",__FUNCTION__);
			cbEvent = RTK_EOS;
			break;
		case RTK_AUDIO_EOS:
			RTKHAL_INF("[%s] RTK_AUDIO_EOS\n",__FUNCTION__);
			cbEvent = RTK_AUDIO_END;
			break;
		case RTK_VIDEO_EOS:
			RTKHAL_INF("[%s] RTK_VIDEO_EOS\n",__FUNCTION__);
			cbEvent = RTK_VIDEO_END;
			break;
		case RTK_VIDEO_RUN_AFTER_AVSYNC:
			{
				RTKHAL_INF("[%s] RTK_VIDEO_RUN_AFTER_AVSYNC\n",__FUNCTION__);
				cbEvent = RTK_VORUN_AFTER_AVSYNC;
			}
			break;
		case RTK_PLAYBACK_VIDEO_LOST:
			{
				RTKHAL_INF("[%s] RTK_AV_NO_VIDEO\n",__FUNCTION__);
				cbEvent = RTK_AVPLAY_VIDEO_LOST;
			}
			break;
		case RTK_VIDEO_SEARCH_I_FRM_BUT_ERRORBLOCKS:
			RTKHAL_INF("[%s] RTK_VIDEO_SEARCH_I_FRM_BUT_ERRORBLOCKS\n",__FUNCTION__);
			return;
		case RTK_VIDEO_FIRST_PICTURE_DECODED_READY:
			RTKHAL_INF("[%s] RTK_VIDEO_FIRST_PICTURE_DECODED_READY\n",__FUNCTION__);
			return;
		case RTK_VIDEO_FIRST_PTS:
			RTKHAL_INF("[%s] RTK_VIDEO_FIRST_PTS\n",__FUNCTION__);
			return;
		case RTK_VIDEO_FATAL_ERROR_EVENT:
			{
				RTKHAL_INF("[%s] RTK_VIDEO_FATAL_ERROR_EVENT\n",__FUNCTION__);
				cbEvent=RTK_PLAYBACK_FATAL_ERROR;
				if (pCurPlayer_Handle)
				{
					_xRTK_HAL_Callback(pCurPlayer_Handle, cbEvent, NULL, 0);
				}
#if RTK_HANDLE_FATAL_ERROR_EN > 0
				rtk_porting_video_RePlay_AfterFatalErr(pCurPlayer_Handle->av_handle);
				rtk_porting_av_flush(pCurPlayer_Handle->av_handle);
				rtk_porting_video_set_display(pCurPlayer_Handle->av_handle, RTK_TRUE);
#endif
			}
			return;
		case RTK_AUIDO_MIX_READY:
			RTKHAL_INF("[%s] RTK_AUIDO_MIX_READY\n",__FUNCTION__);
			return;
		case RTK_PLAYBACK_FRAMING_ERR:
			RTKHAL_INF("[%s] RTK_VIDEO_FRAMING_ERR\n",__FUNCTION__);
			cbEvent=RTK_VIDEO_FRAMING_ERR;
			break;
		case RTK_PLAYBACK_RINGBUF_FULL:
			RTKHAL_INF("[%s] RTK_AV_RINGBUF_FULL_ERR\n",__FUNCTION__);
			cbEvent=RTK_AV_RINGBUF_FULL_ERR;
			break;
		default:
			RTKHAL_INF("[%s] UNKNOWN EVENT\n",__FUNCTION__);
			return;
	}
	
	if (pCurPlayer_Handle && cbEvent!=RTK_CB_EVENT_MAX)
	{
		RTKHAL_INF("%s(%d):%s\n",__FUNCTION__,__LINE__,(pCurPlayer_Handle->player_config.input.type==RTK_INPUT_TUNER)?"TUNER":"MTP");
		_xRTK_HAL_Callback(pCurPlayer_Handle, cbEvent, NULL, 0);
	}
}

void RHAL_Base::mFirstAudioFrame_Callback_Entry(int data)
{
	RHAL_GetHalInstance()->mFirstAudioFrame_Callback(data);
}
void RHAL_Base::mFirstAudioFrame_Callback(int data)
{
	INT32_T channel_id = (data&0xFFFF0000)>>16;
	HAL_HANDLE_S *pCurPlayer_Handle=NULL;
	
	pthread_mutex_lock(&m_rtk_hal_mutex[channel_id]);
	if (m_pCurHal_Handle[channel_id] && channel_id==RTK_CHANNEL_0)
	{
		pCurPlayer_Handle = m_pCurHal_Handle[channel_id];
	}
	pthread_mutex_unlock(&m_rtk_hal_mutex[channel_id]);

	if (pCurPlayer_Handle)
	{
		RTKHAL_INF("%s(%d):%s\n",__FUNCTION__,__LINE__,(pCurPlayer_Handle->player_config.input.type==RTK_INPUT_TUNER)?"TUNER":"MTP");
		_xRTK_HAL_Callback(pCurPlayer_Handle, RTK_FIRST_AUDIO_FRAME_DECODED, NULL, 0);
	}
}

void *RHAL_Base::mSection_Ready_Thread(void* pParamList)
{
    if (pParamList == NULL)
    {
        RTKHAL_ERR("%s,%d pParamList is NULL\n", __func__,__LINE__);
        return NULL;
    }
    RHAL_ThreadParam_t rhal_thread_param;
    memcpy(&rhal_thread_param,pParamList,sizeof(RHAL_ThreadParam_t));
    free(pParamList);
#if 1//ndef ENABLE_SOURCE_FILTER
	HAL_HANDLE_S *p_hal_handle;
#endif
	DEMUX_HANDLE_S *demux_handle;
	SECTION_CALLBACK_POOL_HEADER_S *pHeader = NULL;
	MSGQ_DATA *pMessage;
	UINT32_T sectionCallbackPoolPhyAddr = 0;
	SECTION_CALLBACK_POOL_S *pSectionCallbackPool = NULL;
	UINT16_T readIndex, writeIndex;
	RTK_SectionFilterCallback_01 callback;
	RTK_SectionFilter filterID;
	//UINT8_T *pSectionData = NULL;
	UINT32_T data_size;
	void *section_user_param;
	//UINT8_T  ret=0;
	UINT8_T  tmpValue=2;
	INT32_T  IonShareFd=-1;
	INT32_T  IonFd=-1;
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        INT32_T  RtkIonFd=-1;
        #endif
	//INT32_T  socketfd=-1;
	INT32_T  size=0;
	RTK_HAL_SECTION_CB_STATUS enStatus;

	ion_user_handle_t IonHandle;

	UINT8_T  *noncacheable=&tmpValue;  
	INT32_T  IonMapFd=-1;

	RTKHAL_INF("Hello World!\n");
#ifdef ENABLE_SOURCE_FILTER
	RHAL_SourceDmxHandleInfo_t* s_dmx_h=NULL;
	if (rhal_thread_param.bUseSourceFilter)
	{
        s_dmx_h=(RHAL_SourceDmxHandleInfo_t*)rhal_thread_param.halHandle;
        demux_handle=s_dmx_h->dmx_handle;
	}
	else
	{
        p_hal_handle = (HAL_HANDLE_S*)rhal_thread_param.halHandle;
        demux_handle = p_hal_handle->dmx_handle;
	}
#else
	p_hal_handle = (HAL_HANDLE_S*)pParamList;
	demux_handle = p_hal_handle->dmx_handle;
#endif	

    bool *isSectionStop;
   #ifdef ENABLE_SOURCE_FILTER
    if (rhal_thread_param.bUseSourceFilter)
    {
        isSectionStop = &(s_dmx_h->sectionThread_stop);
    }
    else
	isSectionStop = (bool *)&(p_hal_handle->stop_thread);
#else    
        isSectionStop = (bool *)&(p_hal_handle->stop_thread);    
#endif
	//set SCHED_RR
	struct sched_param s_param;
	memset((void *)&s_param, 0, sizeof(s_param));
	s_param.sched_priority = 1;

#ifdef ENABLE_SOURCE_FILTER
    #if 0
	while (s_dmx_h->sectionThread_stop == false)
	#endif
	while (*isSectionStop == false)	
#else
	while (p_hal_handle->stop_thread == 0)
#endif		
	{
		//---------------------------------------------------------------------
		//	get section call pool address		
		if(pSectionCallbackPool==NULL)
		{
		#ifdef ENABLE_SOURCE_FILTER
			//TODO: get share memory.
			if (rhal_thread_param.bUseSourceFilter)
			{
			char bufname[64]={0};
			sprintf(bufname, "sectionFilter_%p", demux_handle);
			if(rtk_porting_FDSHMClient_GetFd(bufname, &IonShareFd)!=RTK_OK)
			{
				RTKHAL_ERR("get share buffer (%s) fd failed\n", bufname);
				return NULL;
			}

			if(IonShareFd==-1)
			{
				RTKHAL_ERR("get share buffer (%s) fd failed, invalid fd\n", bufname);
				return NULL;
			}
			RTKHAL_INF("[section]got sharefd=%d for share memory %s\n", IonShareFd, bufname);
			}
			else
			{
                for(int i=0;i<m_dtvflow_num;i++)
                {
                    //RTKHAL_INF("[section]m_ion_sharefd[%d].Sectionsharefd=%ld,channel=%d\n",i, m_ionmem_sharefd[i].SectionSharefd,m_ionmem_sharefd[i].channel);
                    if(p_hal_handle->channel == m_ionmem_sharefd[i].channel)
                    {
                        IonShareFd = m_ionmem_sharefd[i].SectionSharefd;
                        RTKHAL_INF("[section]m_ion_sharefd[%d].Sectionsharefd=%ld,channel=%d\n",i, m_ionmem_sharefd[i].SectionSharefd,m_ionmem_sharefd[i].channel);
                        RTKHAL_INF("[section]find sharefd=%d\n",IonShareFd);
                        break;
                    }
                }   
			
			}
		#else
			for(int i=0;i<m_dtvflow_num;i++)
			{
				//RTKHAL_INF("[section]m_ion_sharefd[%d].Sectionsharefd=%ld,channel=%d\n",i, m_ionmem_sharefd[i].SectionSharefd,m_ionmem_sharefd[i].channel);
				if(p_hal_handle->channel == m_ionmem_sharefd[i].channel)
				{
					IonShareFd = m_ionmem_sharefd[i].SectionSharefd;
					RTKHAL_INF("[section]m_ion_sharefd[%d].Sectionsharefd=%ld,channel=%d\n",i, m_ionmem_sharefd[i].SectionSharefd,m_ionmem_sharefd[i].channel);
					RTKHAL_INF("[section]find sharefd=%d\n",IonShareFd);
					break;
				}
			}	
		#endif
                        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                        pSectionCallbackPool = (SECTION_CALLBACK_POOL_S*)ExtIonGetShareMemory(&IonFd, &RtkIonFd,IonShareFd, &size ,&IonMapFd,(void **)&noncacheable,
													  (unsigned long*)&sectionCallbackPoolPhyAddr,&IonHandle);
                        #else
			pSectionCallbackPool = (SECTION_CALLBACK_POOL_S*)IonGetShareMemory(&IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable,
														  (unsigned long*)&sectionCallbackPoolPhyAddr,&IonHandle);
                        #endif
		}

		if((pSectionCallbackPool  == NULL)||((unsigned int)pSectionCallbackPool  == 0xffffffff))
		{
			RTKHAL_ERR("pSectionCallbackPool wrong, mmap fail!\n");
			#ifdef ENABLE_SOURCE_FILTER
			if(IonShareFd!=-1)
				close(IonShareFd);
			#endif
			return NULL;
		}
		else
		{
			//RTKHAL_INF("pSectionCallbackPool = %p\n", pSectionCallbackPool );
			//RTKHAL_INF("##PhyAddr=%lx,mIonMmapFd=%d,mViraddr=0x%x,size=%d\n",sectionCallbackPoolPhyAddr,IonMapFd,(INT32_T)pSectionCallbackPool,size);
			pHeader = &pSectionCallbackPool->header;
		}


		//---------------------------------------------------------------------
#ifdef ENABLE_SOURCE_FILTER		
		while ((pHeader->lock)  && (*isSectionStop == false)) usleep(1000);	// wait write unlock
		if(*isSectionStop)//exit while loop when stop_thread=1;
			break;
#else
		while ((pHeader->lock)	&& (p_hal_handle->stop_thread == 0)) usleep(1000);	// wait write unlock
		if(p_hal_handle->stop_thread )//exit while loop when stop_thread=1;
			break;
#endif
		pHeader->lock = 1;					// read lock

		readIndex  = pHeader->readIndex;
		writeIndex = pHeader->writeIndex; 
		
		if ((pHeader->tag != SECTION_CALLBACK_POOL_TAG) || (readIndex >= SECTION_CALLBACK_MSG_COUNT) || (writeIndex >= SECTION_CALLBACK_MSG_COUNT))
		{
			RTKHAL_INF("sectionCallbackPoolPhyAddr=0x%x\n",sectionCallbackPoolPhyAddr);
			RTKHAL_INF("tag=0x%08x readIndex=%d writeIndex=%d\n",pHeader->tag,readIndex,writeIndex);
			RTKHAL_INF("abort\n");
//			assert(0);
		}
		
		if (readIndex == writeIndex)
		{
			pHeader->lock = 0;				// read unlock
			usleep(RTK_DEMUX_THREAD_SLEEP_S);
			continue;
		}
		if(readIndex >= 0 && readIndex < sizeof(pSectionCallbackPool->buffer)/sizeof(pSectionCallbackPool->buffer[0])){
			pMessage = &pSectionCallbackPool->buffer[readIndex].message;
		}else{
			RTKHAL_ERR(" mSection_Ready_Thread  readIndex =%d Out-of-bounds \n",readIndex);
		}
		callback = NULL;

		switch (pMessage->u8mtype)
		{
			case RTK_MSGQ_TYPE_SECTION_READY:
				callback = (RTK_SectionFilterCallback_01)pMessage->callback;
				filterID = (RTK_SectionFilter)pMessage->u32FilterID;
				data_size = pMessage->u32Len;
				memcpy(pSectionCallbackPool->working_buffer, pSectionCallbackPool->buffer[readIndex].data, data_size);
				section_user_param = pMessage->section_user_param;
				enStatus = HAL_SECTION_FILTER_HIT;
				break;
			case RTK_MSGQ_TYPE_THREAD_QUIT:
				if((pSectionCallbackPool != NULL)&&((unsigned int)pSectionCallbackPool != 0xffffffff))
				{      
                    #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                    ExtIonPutShareMemory(pSectionCallbackPool, size, IonFd, RtkIonFd,IonMapFd, IonHandle);
                    #else       
					IonPutShareMemory(pSectionCallbackPool,size,IonFd,IonMapFd,IonHandle);	
					#endif
				}
				RTKHAL_INF("%s %d : byebye World!\n", __FUNCTION__, __LINE__);  
				pHeader->lock = 0;	// read unlock
				#ifdef ENABLE_SOURCE_FILTER
				if (rhal_thread_param.bUseSourceFilter)
				{
    				if(IonShareFd!=-1)
    					close(IonShareFd);
				}
				#endif
				pthread_exit(0); /* exit */
				return NULL;

			case RTK_MSGQ_TYPE_SECTION_TIMEOUT:
				callback = (RTK_SectionFilterCallback_01)pMessage->callback;
				filterID = (RTK_SectionFilter)pMessage->u32FilterID;
				data_size = pMessage->u32Len;
				section_user_param = pMessage->section_user_param;	
				enStatus = HAL_SECTION_FILTER_TIMEOUT;
				RTKHAL_INF("%s %d : section timeout!\n", __FUNCTION__, __LINE__);	
				break;
				
			default:
				RTKHAL_INF("msgrcv receive unknown type=%d !\n", pMessage->u8mtype);
				break;
		}
		
		readIndex = (readIndex >= SECTION_CALLBACK_MSG_COUNT-1) ? 0 : readIndex+1;
		pHeader->readIndex = readIndex;
		pHeader->lock = 0;				// must unlock before callback to avoid dead-lock

		if (callback)
		{ 
			callback(filterID, enStatus, pSectionCallbackPool->working_buffer, data_size, section_user_param);
		}
	}

	#if 0 //def ENABLE_SOURCE_FILTER
	if(IonShareFd!=-1)
		close(IonShareFd);
	#endif
	if((pSectionCallbackPool != NULL)&&((unsigned int)pSectionCallbackPool != 0xffffffff))
	{    
	    #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
	    ExtIonPutShareMemory(pSectionCallbackPool, size, IonFd, RtkIonFd,IonMapFd, IonHandle);
        #else	    
		IonPutShareMemory(pSectionCallbackPool, size, IonFd, IonMapFd, IonHandle);	
	    #endif
		pSectionCallbackPool = NULL;
	}
#ifdef ENABLE_SOURCE_FILTER
    if (rhal_thread_param.bUseSourceFilter)
    {
        if(IonShareFd!=-1)
            close(IonShareFd);
    }
#endif

	RTKHAL_INF("%s %d : byebye World!\n", __FUNCTION__, __LINE__);  
	pthread_exit(0); /* exit */
	return NULL;
}


void *RHAL_Base::mPes_Ready_Thread(void* pParamList)
{
	HAL_HANDLE_S *p_hal_handle;
	DEMUX_PES_HANDLE_S *demux_pes_handle;
	PES_CALLBACK_POOL_HEADER_S *pHeader = NULL;
	PES_MSGQ_DATA *pMessage;
	UINT32_T pesCallbackPoolPhyAddr = 0;
	PES_CALLBACK_POOL_S *pPesCallbackPool = NULL;
	UINT16_T readIndex, writeIndex;
	RTK_PESFilterCallback callback;
	UINT32_T filterID;
	UINT32_T data_size;
	void *pes_user_param;
	UINT8_T  tmpValue=2;
	INT32_T  IonShareFd=-1;
	INT32_T  IonFd=-1;
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        INT32_T RtkIonFd=-1;
        #endif
	INT32_T  size=0;

	ion_user_handle_t IonHandle;

	UINT8_T  *noncacheable=&tmpValue;  
	INT32_T  IonMapFd=-1;

	RTKHAL_INF("Hello World!\n");
	p_hal_handle = (HAL_HANDLE_S*)pParamList;
	demux_pes_handle = p_hal_handle->dmx_pes_handle;

	//set SCHED_RR
	struct sched_param s_param;
	memset((void *)&s_param, 0, sizeof(s_param));
	s_param.sched_priority = 1;

	
	while (p_hal_handle->stop_thread == 0)
	{
		//---------------------------------------------------------------------
		//	get pes call pool address		
		if(NULL == pPesCallbackPool)
		{
			for(int i=0;i<m_dtvflow_num;i++)
			{
				
				if(p_hal_handle->channel == m_ionmem_sharefd[i].channel)
				{
					//rtk_porting_FDSHMClient_init(); //move it to RHAL_Base				
					if(0 == p_hal_handle->channel)
					{
						rtk_porting_FDSHMClient_GetFd(PES_SHAHRE_FD00  ,&IonShareFd);	
					}
					else if(1 == p_hal_handle->channel)
					{
						rtk_porting_FDSHMClient_GetFd(PES_SHAHRE_FD01,&IonShareFd);	
					}
					else
					{
						char bufNm[128]={0};
						sprintf(bufNm, "pes_shm_fd%d", p_hal_handle->channel);
						rtk_porting_FDSHMClient_GetFd(bufNm,&IonShareFd);	
						
					}
					RTKHAL_INF("[PES]find sharefd=%d,p_hal_handle->channel=%d\n",IonShareFd,p_hal_handle->channel);
					break;
				}
			}
                        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                        pPesCallbackPool = (PES_CALLBACK_POOL_S*)ExtIonGetShareMemory(&IonFd,&RtkIonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable,
 														  (unsigned long*)&pesCallbackPoolPhyAddr,&IonHandle);
                        #else
			pPesCallbackPool = (PES_CALLBACK_POOL_S*)IonGetShareMemory(&IonFd, IonShareFd, &size ,&IonMapFd,(void **)&noncacheable,
														  (unsigned long*)&pesCallbackPoolPhyAddr,&IonHandle);
                        #endif
		}

		if(( NULL == pPesCallbackPool)||( 0xffffffff == (unsigned int)pPesCallbackPool))
		{
			RTKHAL_ERR("pPesCallbackPool wrong, mmap fail!\n");
			return NULL;
		}
		else
		{
			//RTKHAL_INF("pPesCallbackPool = %p\n", pPesCallbackPool );
			//RTKHAL_INF("##PhyAddr=%lx,mIonMmapFd=%d,mViraddr=0x%x,size=%d\n",pesCallbackPoolPhyAddr,IonMapFd,(UINT32_T)pPesCallbackPool,size);
			pHeader = &pPesCallbackPool->header;
		}


		//---------------------------------------------------------------------
		while (pHeader->lock) usleep(1000);	// wait write unlock
		pHeader->lock = 1;					// read lock

		readIndex  = pHeader->readIndex;
		writeIndex = pHeader->writeIndex; 
		
		if ((pHeader->tag != PES_CALLBACK_POOL_TAG) || (readIndex >= PES_CALLBACK_MSG_COUNT) || (writeIndex >= PES_CALLBACK_MSG_COUNT))
		{
			RTKHAL_INF("pesCallbackPoolPhyAddr=0x%x\n",pesCallbackPoolPhyAddr);
			RTKHAL_INF("tag=0x%08x readIndex=%d writeIndex=%d\n",pHeader->tag,readIndex,writeIndex);
			RTKHAL_INF("abort\n");
			assert(0);
		}
		
		if (readIndex == writeIndex)
		{
			pHeader->lock = 0;	// read unlock
			usleep(RTK_DEMUX_THREAD_SLEEP_S);
			continue;
		}
		
		pMessage = &pPesCallbackPool->buffer[readIndex].message;

		callback = NULL;

		switch (pMessage->u8mtype)
		{
			case RTK_MSGQ_TYPE_PES_READY:
				callback = (RTK_PESFilterCallback)pMessage->callback;
				filterID = pMessage->u8FilterID;
				data_size = pMessage->u32Len;
				memcpy(pPesCallbackPool->working_buffer, pPesCallbackPool->buffer[readIndex].data, data_size);
				pes_user_param = pMessage->pes_user_param;
				break;

			case RTK_MSGQ_TYPE_PES_QUIT:
				if((pPesCallbackPool != NULL)&&((unsigned int)pPesCallbackPool != 0xffffffff))
				{	   
                    #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
                    ExtIonPutShareMemory(pPesCallbackPool, size, IonFd, RtkIonFd,IonMapFd, IonHandle);
                    #else       
					IonPutShareMemory(pPesCallbackPool,size,IonFd,IonMapFd,IonHandle);	
					#endif
					if(IonShareFd != -1){
						close(IonShareFd);
					}
				}
				RTKHAL_INF("%s %d : byebye World!\n", __FUNCTION__, __LINE__);	
				pHeader->lock = 0;	// read unlock
				pthread_exit(0); /* exit */
				return NULL;
				
			default:
				RTKHAL_INF("msgrcv receive unknown type=%d !\n", pMessage->u8mtype);
				break;
		}
		
		readIndex = (readIndex >= PES_CALLBACK_MSG_COUNT-1) ? 0 : readIndex+1;
		pHeader->readIndex = readIndex;
		pHeader->lock = 0;				// must unlock before callback to avoid dead-lock

		if (callback)
		{
			callback(filterID, pPesCallbackPool->working_buffer, data_size, pes_user_param);
		}
	}

	if((pPesCallbackPool != NULL)&&((unsigned int)pPesCallbackPool != 0xffffffff))
	{    
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        ExtIonPutShareMemory(pPesCallbackPool, size, IonFd, RtkIonFd,IonMapFd, IonHandle);
        #else       
		IonPutShareMemory(pPesCallbackPool, size, IonFd, IonMapFd, IonHandle);	
		#endif
		if(IonShareFd != -1){
			close(IonShareFd);
		}
		pPesCallbackPool = NULL;
	}

	RTKHAL_INF("%s %d : byebye World!\n", __FUNCTION__, __LINE__);  
	pthread_exit(0); /* exit */
	return NULL;
}

void *RHAL_Base::mCC_Ready_Thread(void* pParamList)
{
	HAL_HANDLE_S *hal_handle;
	hal_handle = (HAL_HANDLE_S*)pParamList;
	
	//DEMUX_HANDLE_S *demux_handle;
	RTKHAL_ERR("%s %d enter\n",__FUNCTION__,__LINE__);
	if(hal_handle == NULL )
	{
		RTKHAL_ERR("Handle not exist\n");
		return NULL;
	}	
	usleep(1000*1000);//need this, wait dvdplayer create cc socket first.

	//for create socket
	int s=0, len=0;
	unsigned int data_size = 0;
	struct sockaddr_un remote;

	//for select socket
	int retval = 0;
	fd_set rfds;
	struct timeval tv;
	tv.tv_sec = 0;
	tv.tv_usec = 100*1000;
	char dir[108];
	char data_file[100];
	FILE *wfd;


	if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) 
	{
		RTKHAL_ERR("client socket create FAIL\n");
		return NULL;
	}

	memset(&remote, 0x00, sizeof(struct sockaddr_un));
	remote.sun_family = AF_UNIX;
	memset(dir,0,sizeof(dir));
	snprintf(dir,107,"/tmp/ccData%d",hal_handle->channel+1);	
	strncpy(remote.sun_path,dir,sizeof(remote.sun_path)-1);
	printf("client socket is %s\n",dir);
	
#ifdef ANDROID
	char value[100];
	value[0] = '\0';
	property_get("persist.vendor.abstract_socket", value, "false");
	if(strcmp(value, "true") == 0)
	{
		remote.sun_path[0] = 0;   //Use abstract name as domain socket
	}
#endif
	while(connect(s, (struct sockaddr *)&remote, sizeof(struct sockaddr_un)) != 0)
	{
		RTKHAL_ERR("client socket connect server fail!\n");
		usleep(100);
	}
	
	RTKHAL_INF("client socket connect server Success!\n");
	
	time_t timep;
	struct tm *p;
	time(&timep);
	p =localtime(&timep); 
  	 snprintf(data_file,100,"/data/ccData_Client_%01d_%02d-%02d_%02d-%02d_%04d.ts",hal_handle->channel+1,1+p->tm_mon,p->tm_mday,p->tm_hour,p->tm_min,1900+p->tm_year);
  	 printf("save CCData to File = %s\n",data_file);
	 while (hal_handle->stop_cc_thread == RTK_FALSE)
	  {
		
		FD_ZERO(&rfds);
		FD_SET(s, &rfds);

		retval = select(s+1, &rfds, NULL, NULL, &tv);
		if (retval != -1 && FD_ISSET(s, &rfds))
		{
			len = recv(s, (unsigned char *)&data_size, 4, 0);			
			if(len == 0)
			{
				RTKHAL_ERR("no data, break\n");
				continue;
			}
			else if(len == -1)
			{
				RTKHAL_INF("socket recv error.\n");
				continue;
				//usleep(50*1000);//100ms
			}
			else if(len == 4)
			{
				usleep(10*1000);//100ms
				if(data_size <= 0)
				{
					RTKHAL_ERR(" socket recv error, data_size = %d\n", data_size);
					continue;
				}
				
				//data_size = data_size<(10*1024)?data_size:(10*1024);
				unsigned char *buf =(unsigned char *) malloc(data_size);
				if(NULL == buf)
				{
					RTKHAL_ERR("buf malloc error\n");
					close(s);
	
					RTKHAL_ERR("byebye World!\n");
					pthread_exit(0); /* exit */
					return NULL;
				}
				memset(buf, 0x00, data_size);
				len = 0;
				len = recv(s, buf, data_size, 0);
				if(len > 0)
				{
					printf("get cc data, len = %d\n",len);
					
					if(len >= 8)
					{
						printf("CLIENT ccData=[0x%x|0x%x|0x%x|0x%x|0x%x|0x%x|0x%x|0x%x]\n", buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);
					}
					if((wfd = fopen(data_file,"a+")) == NULL) 
					{
						printf("File Open Error.\n");
					}
					else
					{
						   size_t send_len = 0;
						if((send_len = fwrite(buf,1,len,wfd))== (size_t)len)
							RTKHAL_INF("\nwrite unsigned char to file:%s success,%d\n\n",data_file,len);
						fclose(wfd);
					}
					//add by changxi_huang
					if(hal_handle->m_bGetCCdata){
						addCCData(hal_handle,buf,len);
					}
					//add end
					if(hal_handle->player_config.callback.function !=NULL)
						hal_handle->player_config.callback.function(RTK_PICTURE_USER_DATA,hal_handle->type,hal_handle->player_config.callback.user_param,(void*)buf, len);
					//add by changxi_huang
					if(!hal_handle->m_bGetCCdata){
						free(buf);
					}
					//add end
				}
				else if (len == -1)
				{
					free(buf);
					RTKHAL_ERR("wait packet data.\n");
				}
				else 
				{
					free(buf);
					//len == 0, no connect, just break;
					RTKHAL_ERR("no connection, break.\n");
					break;
				}
				/*if(NULL != buf)
				{
					free(buf);
				}*/
			}
		}
		else
		{
			//RTKHAL_INF("[cc_transport](%d) select FAIL, return %d\n", p_hal_handle->channel, retval);
		}

		usleep(1000);
	}
	
	close(s);
	hal_handle->m_bGetCCdata = false;
	RTKHAL_INF("CC byebye World!\n");
	pthread_exit(0); /* exit */
	return NULL;
}

void* RHAL_Base::mThreadRecordEntry(void* param)
{
	if(param==NULL)
	{
		RTKHAL_ERR("[%s] param is NULL ???\n", __FUNCTION__);
		return NULL;
	}	

	RHAL_ThreadParam_t *hal_param=(RHAL_ThreadParam_t *)param;

	RHAL_Base* pThis = (RHAL_Base*)(hal_param->instance);
	pThis->mThreadRecord((void*)hal_param->halHandle);

	free(hal_param);

	return NULL;
}
void * RHAL_Base::mThreadRecord(void* pParamList)
{	
	HAL_HANDLE_S *p_hal_handle = (HAL_HANDLE_S*)pParamList;
	//DEMUX_HANDLE_S *demux_handle = p_hal_handle->dmx_handle;

	// ion
	INT8_T  tmpValue=2,tmpValue1=2;
	INT32_T IonRecShareFd=-1,SecureMemoryIonRecShareFd=-1;
	INT32_T IonFd=-1,SecureMemoryIonFd=-1;
	#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
	INT32_T RtkIonFd=-1,SecureMemoryRtkIonFd=-1;
	#endif
	INT32_T IonSize=0,SecureMemoryIonSize=0;
	INT8_T *noncacheable=&tmpValue;
	INT8_T *SecureMemoryNoncacheable=&tmpValue1;
	INT32_T	IonMapFd=-1,SecureMemoryIonMapFd=-1;
	ion_user_handle_t      IonHandle,SecureMemoryIonHandle;
	
	ULONG_T           rec_phyAddr,SecureMemoryRec_phyAddr;
	
	// ion
	unsigned char *hal_Buffer;
	unsigned char *SecureMemory_hal_Buffer;
	unsigned char *ringbuf_VirAddr;
	unsigned int* ringbuf_R;
	unsigned int* ringbuf_W;

	FRAME_OFFSET_T* m_FrameIndex;
	unsigned int* m_FrameIndex_R;
	unsigned int* m_FrameIndex_W;

	PTS_OFFSET_T* m_PtsIndex;
	unsigned int* m_PtsIndex_R;
	unsigned int* m_PtsIndex_W;

	STOREINFO_OFFSET_T* m_StoreInfoIndex;
	unsigned int* m_StoreInfoIndex_R;
	unsigned int* m_StoreInfoIndex_W;

	PCR_OFFSET_T* m_PCRIndex;
	unsigned int* m_PCRIndex_R;
	unsigned int* m_PCRIndex_W;

	TAG_OFFSET_T* m_TAGIndex;
	unsigned int* m_TAGIndex_R;
	unsigned int* m_TAGIndex_W;
	unsigned int rec_buf_size=0;


	if(p_hal_handle->pulRecShareMemFd != NULL && (int)(*p_hal_handle->pulRecShareMemFd) != -1)
	{
		IonRecShareFd = *p_hal_handle->pulRecShareMemFd;
		RTKHAL_INF("%s %d [REC]find sharefd=%d\n",__FUNCTION__, __LINE__,IonRecShareFd);
	}
	else
	{
		RTKHAL_ERR("%s %d: no valid record share memory!!\n", __func__, __LINE__);
		return NULL;
	}

	#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
	hal_Buffer = (unsigned char*)ExtIonGetShareMemory(&IonFd,&RtkIonFd, IonRecShareFd, &IonSize ,&IonMapFd,(void **)&noncacheable,&rec_phyAddr,&IonHandle);
	#else
	hal_Buffer = (unsigned char*)IonGetShareMemory(&IonFd, IonRecShareFd, &IonSize ,&IonMapFd,(void **)&noncacheable,&rec_phyAddr,&IonHandle);
	#endif

	if((hal_Buffer  == NULL)||((unsigned int)hal_Buffer  == 0xffffffff))
	{
		RTKHAL_ERR("%s %d [%d]: hal_Buffer wrong, iongetsharemem fail!\n", __FUNCTION__, __LINE__, p_hal_handle->type);
		return NULL;
	}
	else
	{
		RTKHAL_INF("%s %d [%d]: hal_Buffer = %p\n", __FUNCTION__, __LINE__, p_hal_handle->type, hal_Buffer );

		ringbuf_VirAddr = hal_Buffer + RECORD_RINGBUFFER_OFFSET;
		rec_buf_size=RECORD_RINGBUFFER_SIZE;
		
		ringbuf_R = (unsigned int*)(hal_Buffer + sizeof(unsigned int) * 4);
		ringbuf_W = (unsigned int*)(hal_Buffer + sizeof(unsigned int) * 5);

		m_FrameIndex = (FRAME_OFFSET_T*) (hal_Buffer + RECORD_FRAME_INDEX_RW_OFFSET + RECORD_FRAME_INDEX_RW_SIZE);
		m_FrameIndex_R = (unsigned int*) (hal_Buffer + RECORD_FRAME_INDEX_RW_OFFSET + sizeof(unsigned int));
		m_FrameIndex_W = (unsigned int*)(hal_Buffer + RECORD_FRAME_INDEX_RW_OFFSET + sizeof(unsigned int) * 2);

		m_PtsIndex = (PTS_OFFSET_T*) (hal_Buffer + RECORD_PTS_INDEX_RW_OFFSET + RECORD_PTS_INDEX_RW_SIZE);
		m_PtsIndex_R = (unsigned int*) (hal_Buffer + RECORD_PTS_INDEX_RW_OFFSET + sizeof(unsigned int));
		m_PtsIndex_W = (unsigned int*) (hal_Buffer + RECORD_PTS_INDEX_RW_OFFSET + sizeof(unsigned int) * 2);	

		m_StoreInfoIndex = (STOREINFO_OFFSET_T*) (hal_Buffer + RECORD_STOREINFO_INDEX_OFFSET);
		m_StoreInfoIndex_R = (unsigned int*) (hal_Buffer + RECORD_STOREINFO_INDEX_RW_OFFSET + sizeof(unsigned int));
		m_StoreInfoIndex_W = (unsigned int*) (hal_Buffer + RECORD_STOREINFO_INDEX_RW_OFFSET + sizeof(unsigned int)*2);

		m_PCRIndex = (PCR_OFFSET_T*) (hal_Buffer + RECORD_PCR_INDEX_RW_OFFSET + RECORD_PCR_INDEX_RW_SIZE);
		m_PCRIndex_R = (unsigned int*) (hal_Buffer + RECORD_PCR_INDEX_RW_OFFSET + sizeof(unsigned int));
		m_PCRIndex_W = (unsigned int*) (hal_Buffer + RECORD_PCR_INDEX_RW_OFFSET + sizeof(unsigned int) * 2);

		m_TAGIndex = (TAG_OFFSET_T*) (hal_Buffer + RECORD_TAG_INDEX_RW_OFFSET + RECORD_TAG_INDEX_RW_SIZE);
		m_TAGIndex_R = (unsigned int*) (hal_Buffer + RECORD_TAG_INDEX_RW_OFFSET + sizeof(unsigned int));
		m_TAGIndex_W = (unsigned int*) (hal_Buffer + RECORD_TAG_INDEX_RW_OFFSET + sizeof(unsigned int) * 2);

		RTKHAL_INF("%s %d: hal_Buffer = %p, ringbuf_R=%p, ringbuf_W=%p, m_StoreInfoIndex_R=%p, m_StoreInfoIndex_W=%p\n", __FUNCTION__, __LINE__, hal_Buffer, ringbuf_R , ringbuf_W, m_StoreInfoIndex_R, m_StoreInfoIndex_W);


	}

	if(p_hal_handle->rec_inSecurebuf==RTK_TRUE && p_hal_handle->rec_secbuf_fd>0)
	{
		SecureMemoryIonRecShareFd=p_hal_handle->rec_secbuf_fd;
		RTKHAL_INF("%s %d [REC] use secure buffer sharefd=%d\n",__FUNCTION__, __LINE__, IonRecShareFd);
		
		#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
		SecureMemory_hal_Buffer = (unsigned char*)ExtIonGetShareMemory(&SecureMemoryIonFd,&SecureMemoryRtkIonFd, SecureMemoryIonRecShareFd, &SecureMemoryIonSize ,&SecureMemoryIonMapFd,(void **)&SecureMemoryNoncacheable,&SecureMemoryRec_phyAddr,&SecureMemoryIonHandle);
		#else
		SecureMemory_hal_Buffer = (unsigned char*)IonGetShareMemory(&SecureMemoryIonFd, SecureMemoryIonRecShareFd, &SecureMemoryIonSize ,&SecureMemoryIonMapFd,(void **)&SecureMemoryNoncacheable,&SecureMemoryRec_phyAddr,&SecureMemoryIonHandle);
		#endif
		if((SecureMemory_hal_Buffer	== NULL)||((unsigned int)SecureMemory_hal_Buffer  == 0xffffffff))
		{
			RTKHAL_ERR("%s %d [%d]: hal_Buffer wrong, iongetsharemem fail!\n", __FUNCTION__, __LINE__, p_hal_handle->type);
			return NULL;
		}
		else
		{
			//unsigned long phy = ion_addr_V2P((unsigned long)SecureMemory_hal_Buffer);
		
			ringbuf_VirAddr = SecureMemory_hal_Buffer + RECORD_RINGBUFFER_OFFSET;
			RTKHAL_INF("%s %d [%d]: SecureMemory_hal_Buffer = %p\n", __FUNCTION__, __LINE__, p_hal_handle->type, SecureMemory_hal_Buffer );		
		}
		
	}

	// start read from ring buffer
	unsigned int rd, wr, size;
	unsigned int rd_frame, wr_frame;
	unsigned int rd_pts, wr_pts;
	unsigned int rd_storeinfo, wr_storeinfo;
	unsigned int rd_pcr, wr_pcr;
	unsigned int rd_tag, wr_tag; // for connect PVR
	long long rec_size = 0;
	unsigned char *pBuf;
	RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);

	while(p_hal_handle->isRecording == RTK_TRUE)
	{

		// update r/w pointor in share buffer
		rd = *ringbuf_R;
		wr = *ringbuf_W;
		rd_frame = *m_FrameIndex_R;
		wr_frame = *m_FrameIndex_W;
		rd_pts = *m_PtsIndex_R;
		wr_pts = *m_PtsIndex_W;
		rd_storeinfo = *m_StoreInfoIndex_R;
		wr_storeinfo = *m_StoreInfoIndex_W;
		rd_pcr = *m_PCRIndex_R;
		wr_pcr = *m_PCRIndex_W;
		rd_tag = *m_TAGIndex_R;
		wr_tag = *m_TAGIndex_W;

		//RTKHAL_INF("%s %d [%d]begin : tsdata index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type,wr, rd);
		//RTKHAL_INF("%s %d [%d]begin : storeinfo index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_storeinfo, rd_storeinfo );

		//store info must be process first. Because the encrypt data need this info to decrypt.  
		if( rd_storeinfo != wr_storeinfo)
		{
			//RTKHAL_INF("%s %d [storeinfo]\n",__FUNCTION__, __LINE__);
			RTKHAL_INF("%s %d [%d]begin : storeinfo index wr/rd : 0x%x/0x%x\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_storeinfo, rd_storeinfo);
			if (wr_storeinfo < rd_storeinfo) // ring back
			{
				pBuf = (unsigned char *)&m_StoreInfoIndex[rd_storeinfo];
				size = (INDEX_TABLE_SIZE - rd_storeinfo) * sizeof(STOREINFO_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_STOREINFO, (void*)pBuf, size);
				rd_storeinfo = 0;
			}

			if(rd_storeinfo != wr_storeinfo)
			{
				pBuf = (unsigned char *)&m_StoreInfoIndex[rd_storeinfo];
				size = (wr_storeinfo - rd_storeinfo) * sizeof(STOREINFO_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_STOREINFO, (void*)pBuf, size);
			}

			*m_StoreInfoIndex_R = wr_storeinfo;
		}
		else if (rd != wr)
		{
			//RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);
			size = wr + ((wr > rd) ? 0 : rec_buf_size) - rd ;
			if(rec_size == 0)
			{
				RTKHAL_INF("%s %d [%d]: first rec data wr/rd : 0x%x/0x%x ; size %d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr, rd, size);
			}
			rec_size += (long long) size;

			//RTKHAL_INF("%s %d [%d]: wr/rd : 0x%x/0x%x ; write %d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr, rd, size);
			if (wr < rd) // ring back
			{
				pBuf = ringbuf_VirAddr + rd;

				if(p_hal_handle->rec_inSecurebuf)
					_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_SECURE_DATA,(void*)pBuf, rec_buf_size - rd );
				else
					_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_DATA,(void*)pBuf, rec_buf_size - rd );
				
				size -= (rec_buf_size - rd);
				rd    =  0;
			}

			if (size > 0)
			{
				pBuf = ringbuf_VirAddr + rd;
				if(p_hal_handle->rec_inSecurebuf)
					_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_SECURE_DATA, (void*)pBuf, size);
				else
					_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_DATA, (void*)pBuf, size);
			}

			*ringbuf_R = wr;
		}
		else if( rd_frame != wr_frame)
		{
			//RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);
			//RTKHAL_INF("%s %d [%d]: frame index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_frame, rd_frame);
			if (wr_frame < rd_frame) // ring back
			{
				pBuf = (unsigned char *)&m_FrameIndex[rd_frame];
				size = (INDEX_TABLE_SIZE - rd_frame) * sizeof(FRAME_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_INDEX, (void*)pBuf, size);
				rd_frame = 0;
			}

			if(rd_frame != wr_frame)
			{
				pBuf = (unsigned char *)&m_FrameIndex[rd_frame];
//				RTKHAL_INF("%s %d [%d]: frame %d[ %d, 0x%llx]\n", __FUNCTION__, __LINE__, p_hal_handle->type, rd_frame, m_FrameIndex[rd_frame].frame, m_FrameIndex[rd_frame].offset);
				size = (wr_frame - rd_frame) * sizeof(FRAME_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_INDEX, (void*)pBuf, size);
			}

			*m_FrameIndex_R = wr_frame;
		}
		else if( rd_pts != wr_pts)
		{
			//RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);
			//RTKHAL_INF("%s %d [%d]: pts index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_pts, rd_pts);
			if (wr_pts < rd_pts) // ring back
			{
				pBuf = (unsigned char *)&m_PtsIndex[rd_pts];
				size = (INDEX_TABLE_SIZE - rd_pts) * sizeof(PTS_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_CTRL, (void*)pBuf, size);
				rd_pts = 0;
			}

			if(rd_pts != wr_pts)
			{
				pBuf = (unsigned char *)&m_PtsIndex[rd_pts];
				size = (wr_pts - rd_pts) * sizeof(PTS_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_CTRL, (void*)pBuf, size);
			}

			*m_PtsIndex_R = wr_pts;
		}
		else if( rd_pcr != wr_pcr)
		{
			//RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);
			//RTKHAL_INF("%s %d [%d]: pcr index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_pcr, rd_pcr);
			if (wr_pcr < rd_pcr) // ring back
			{
				pBuf = (unsigned char *)&m_PCRIndex[rd_pcr];
				size = (INDEX_TABLE_SIZE - rd_pcr) * sizeof(PCR_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_PCR, (void*)pBuf, size);
				rd_pcr = 0;
			}

			if(rd_pcr != wr_pcr)
			{
				pBuf = (unsigned char *)&m_PCRIndex[rd_pcr];
				size = (wr_pcr - rd_pcr) * sizeof(PCR_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_PCR, (void*)pBuf, size);
			}

			*m_PCRIndex_R = wr_pcr;
		}
		else if( rd_tag != wr_tag)
		{
			//RTKHAL_INF("%s %d [_xRec_Thread]\n",__FUNCTION__, __LINE__);
			//RTKHAL_INF("%s %d [%d]: tag index wr/rd : %d/%d\n", __FUNCTION__, __LINE__, p_hal_handle->type, wr_tag, rd_tag);
			if (wr_tag < rd_tag) // ring back
			{
				pBuf = (unsigned char *)&m_TAGIndex[rd_tag];
				size = (INDEX_TABLE_SIZE - rd_tag) * sizeof(TAG_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_TAG, (void*)pBuf, size);
				rd_tag = 0;
			}

			if(rd_tag != wr_tag)
			{
				pBuf = (unsigned char *)&m_TAGIndex[rd_tag];
				size = (wr_tag - rd_tag) * sizeof(TAG_OFFSET_T);
				_xRTK_HAL_Callback( p_hal_handle, RTK_FILTER_TS_TAG, (void*)pBuf, size);
			}

			*m_TAGIndex_R = wr_tag;
		}

		usleep(RTK_DEMUX_THREAD_SLEEP_S);
		//RTKHAL_INF("%s %d [%d]: record %lld bytes\n", __FUNCTION__, __LINE__, p_hal_handle->type, rec_size);
	}
	if((hal_Buffer != NULL)&&((unsigned int)hal_Buffer != 0xffffffff))
	{       
        #if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
        ExtIonPutShareMemory(hal_Buffer, IonSize, IonFd, RtkIonFd, IonMapFd, IonHandle);
        #else       
		IonPutShareMemory(hal_Buffer, IonSize, IonFd, IonMapFd, IonHandle);	
		#endif
		#if 0
		if(IonRecShareFd != -1)
		{
			close(IonRecShareFd);
		}
		#endif
		hal_Buffer = NULL;	
	}
	
	if((SecureMemory_hal_Buffer != NULL)&&((unsigned int)SecureMemory_hal_Buffer != 0xffffffff))
	{
		#if defined(USE_RTKHAL_IN_ANDROID10)&&defined(ION_MACH_LINUX4P14)
		ExtIonPutShareMemory(SecureMemory_hal_Buffer, SecureMemoryIonSize, SecureMemoryIonFd, SecureMemoryRtkIonFd, SecureMemoryIonMapFd, SecureMemoryIonHandle);
		#else		
		IonPutShareMemory(SecureMemory_hal_Buffer, SecureMemoryIonSize, SecureMemoryIonFd, SecureMemoryIonMapFd, SecureMemoryIonHandle); 
		#endif
		#if 0
		if(SecureMemoryIonRecShareFd != -1)
		{
			close(SecureMemoryIonRecShareFd);
		}
		#endif
		SecureMemory_hal_Buffer = NULL;	
	}

	RTKHAL_INF("%s %d [%d]: byebye World!\n", __FUNCTION__, __LINE__, p_hal_handle->type);
	pthread_exit(0); /* exit */
	return NULL;
}

//#ifdef CLIENT_DTVSOURCE

RTK_Error RHAL_Base::mMtpBufInit(void)
{
	RTK_Error ret = RTK_OK;
	pthread_mutex_init(&mtp_mutex, NULL);
	memset(mtp_buf, 0x0 , sizeof(Rtk_MtpBuf_t)*MTP_BUF_COUNT);
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if( 0 != rtk_ion_malloc(&mtp_buf[i].ion, MTP_BUF_SIZE, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, ION_FLAG_SCPUACC | ION_FLAG_HWIPACC))
		{
			RTKHAL_ERR("mMtpBufInit %d/%d fail !!!\n", i+1, MTP_BUF_COUNT);
			ret = RTK_Fail;
			break;
		}
		mtp_buf[i].write_ofs = 0;
		mtp_buf[i].cache_ofs = 0;
		mtp_buf[i].bufsize = MTP_BUF_SIZE;
		mtp_buf[i].freesize = 0;
		mtp_buf[i].pre_lend = false;
	}
	return ret;
}

RTK_Error RHAL_Base::mMtpBufUninit(void)
{
	RTK_Error ret = RTK_OK;
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		rtk_ion_free(&mtp_buf[i].ion);
		mtp_buf[i].write_ofs = 0;
		mtp_buf[i].cache_ofs = 0;
		mtp_buf[i].bufsize = 0;
		mtp_buf[i].freesize = 0;
		mtp_buf[i].pre_lend = false;
		memset(&mtp_buf[i].last_time, 0, sizeof(struct timeval));
	}
	pthread_mutex_destroy(&mtp_mutex);
	return ret;
}

ION_DATA* RHAL_Base::mMtpBufFind(Source_Handle source, unsigned char* virtual_addr)
{
	ION_DATA* p = NULL;
	MUTEX_CHECKSIG_AND_LOCK(&mtp_mutex);
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == source)
		{
			if((virtual_addr == NULL) || (mtp_buf[i].ion.ion_virt == virtual_addr))
			{
				p = &mtp_buf[i].ion;
				break;
			}
		}
	}
	MUTEX_CHECKSIG_AND_UNLOCK(&mtp_mutex);
	return p;
}

ION_DATA* RHAL_Base::mMtpBufLend(Source_Handle source)
{
	ION_DATA* p = NULL;
	pthread_mutex_lock(&mtp_mutex);

	// check if had lend before
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == source)
		{
			pthread_mutex_unlock(&mtp_mutex);
			RTK_ERR_ALL("mMtpBufLend source %p had lend before", source);
			return NULL;
		}
	}

	// search one free to lend
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == NULL && mtp_buf[i].pre_lend == false)
		{
			mtp_buf[i].source = source;
			mtp_buf[i].write_ofs = 0;
			mtp_buf[i].cache_ofs = 0;
			mtp_buf[i].freesize = 0;
			memset(&mtp_buf[i].last_time, 0, sizeof(struct timeval));
			p = &mtp_buf[i].ion;
			break;
		}
	}
	pthread_mutex_unlock(&mtp_mutex);
	return p;
}

ION_DATA* RHAL_Base::mMtpBufPreLend(void)
{
	ION_DATA* p = NULL;
	pthread_mutex_lock(&mtp_mutex);

	// search one free to lend
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == NULL && mtp_buf[i].pre_lend == false)
		{
			mtp_buf[i].pre_lend = true;
			p = &mtp_buf[i].ion;
			break;
		}
	}
	pthread_mutex_unlock(&mtp_mutex);
	return p;
}

RTK_Error RHAL_Base::mMtpBufSetSource(ION_DATA* p, Source_Handle source, Rtk_Porting_Source_Type_e type)
{
	RTK_Error ret = RTK_Fail;
	MUTEX_CHECKSIG_AND_LOCK(&mtp_mutex);
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].ion.ion_phy == p->ion_phy && mtp_buf[i].pre_lend == true && mtp_buf[i].source == NULL)
		{
			mtp_buf[i].source = source;
			mtp_buf[i].write_ofs = 0;
			mtp_buf[i].cache_ofs = 0;
			mtp_buf[i].freesize = 0;
			mtp_buf[i].pre_lend = false;
			mtp_buf[i].type = type;
			memset(&mtp_buf[i].last_time, 0, sizeof(struct timeval));
			ret = RTK_OK;
			break;
		}
	}
	MUTEX_CHECKSIG_AND_UNLOCK(&mtp_mutex);
	return ret;
}

RTK_Error RHAL_Base::mMtpBufReturn(ION_DATA* p)
{
	RTK_Error ret = RTK_Fail;
	MUTEX_CHECKSIG_AND_LOCK(&mtp_mutex);
	for(int i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].ion.ion_phy == p->ion_phy)
		{
			mtp_buf[i].source = NULL;
			mtp_buf[i].write_ofs=0;
			mtp_buf[i].cache_ofs=0;
			mtp_buf[i].freesize = 0;
			mtp_buf[i].pre_lend = false;
			ret = RTK_OK;
			break;
		}
	}
	MUTEX_CHECKSIG_AND_UNLOCK(&mtp_mutex);
	return ret;
}

bool RHAL_Base::mForceUseChannelIndex(HAL_TYPE channel_type, int channelId)
{
	int i=0;
	int ch_id=-1;
	bool find_channel=false;
	int vector_size=static_cast<int>(m_channels.size());

	//check alloceted channel in vector m_channels
	if(vector_size>0)
	{
		for(i=0; i<vector_size; i++)
		{
			ch_id=m_channels[i];
			if(ch_id==channelId && m_channelStatus[ch_id].channelState==RHAL_CHANNEL_allocated 
				&& m_channelStatus[ch_id].channelHalType==channel_type)
			{
				find_channel=true;
				RTKHAL_INF("finish check valid channel(%d) in client vector\n", ch_id);
				break;
			}
		}
	}

	//check freed channel id in Server.
	if(find_channel==false && vector_size<m_dtvflow_num)
	{
		if(rtk_porting_av_setChannelRequested(channelId)==RTK_OK)
		{
			find_channel=true;
			RTKHAL_INF("finish check valid channel(%d) in server\n", channelId);
			m_channels.push_back(channelId);
		}	
	}

	//Find alloceted channel and switch it into request HAL type channel.
	//demux-only-hal no need switch from other hal type.
	if(find_channel==false && vector_size>0 && channel_type!=HAL_TYPE_DEMUX_ONLY) 
	{
		//check an allocated hal witch must not be DEMUX ONLY HAL.
		for(i=0; i<vector_size; i++)
		{
			ch_id=m_channels[i];
			if(ch_id==channelId && m_channelStatus[ch_id].channelState==RHAL_CHANNEL_allocated &&
				m_channelStatus[ch_id].channelHalType != HAL_TYPE_DEMUX_ONLY)
			{
				break;
			}
		}
		if(i<vector_size && m_channelStatus[channelId].channelHalType!=channel_type)
		{
//			int new_channel=-1;
			//clean up
			RTKHAL_INF("HAL hal changed, do clean up for channel %d\n", channelId);

			if(mCleanup_AV(channelId)!=RTK_OK)
			{
				RTKHAL_ERR("clean up channel %d failed\n", channelId);
			}

			if(rtk_porting_av_setChannelRequested(channelId)==RTK_OK)
			{
				find_channel=true;
				RTKHAL_INF("switch HAL type and  use channel(%d) \n", channelId);	
				m_channels.push_back(channelId);
			}
		}
		else
		{
			RTKHAL_ERR("this channel(%d) in channel vector and server both using\n", channelId);
		}
	}

	return find_channel;
	
}

RTK_Error RHAL_Base::mAllocate_Channel_Index(
		HAL_TYPE channel_type,
		int &channel_index)
{
	int i=0;
	int ch_id=-1;
	bool find_channel=false;
	int vector_size=static_cast<int>(m_channels.size());

	//Find alloceted channel in vector m_channels
	if(vector_size>0)
	{
		channel_index=-1;
		for(i=0; i<vector_size; i++)
		{
			ch_id=m_channels[i];
			if(m_channelStatus[ch_id].channelState==RHAL_CHANNEL_allocated 
				&& m_channelStatus[ch_id].channelHalType==channel_type)

			{
				channel_index=ch_id;
				find_channel=true;
				RTKHAL_INF("find out valid channel(%d) in client vector\n", channel_index);
				break;
			}
		}
	}

	//Find freed channel id in Server.
	if(find_channel==false && vector_size<m_dtvflow_num)
	{
		channel_index=-1;

		if(channel_type==HAL_TYPE_DEMUX_ONLY)
		{
			rtk_porting_av_getUnusedDemuxChannelIndex(&channel_index);
		}
		else
			rtk_porting_av_getUnusedChannelIndex(&channel_index);

		RTKHAL_INF("%s,channel_index=%d\n",__func__,channel_index);
		if(channel_index <0 || channel_index >=m_dtvflow_num)
		{
			RTKHAL_INF("no free dvb channel in server!!!\n");
		}
		else
		{
			find_channel=true;
			RTKHAL_INF("find out valid channel(%d) in server\n", channel_index);
			m_channels.push_back(channel_index);
		}
	}

	//Find alloceted channel and switch it into request HAL type channel.
	//demux-only-hal no need switch from other hal type.
	if(find_channel==false && vector_size>0 && channel_type!=HAL_TYPE_DEMUX_ONLY) 
	{
		channel_index=-1;

		//find an allocated hal witch must not be DEMUX ONLY HAL.
		for(i=0; i<vector_size; i++)
		{
			ch_id=m_channels[i];
			if(m_channelStatus[ch_id].channelState==RHAL_CHANNEL_allocated &&
				m_channelStatus[ch_id].channelHalType != HAL_TYPE_DEMUX_ONLY)
			{
				channel_index=ch_id;
				break;
			}
		}

		if(channel_index>=0 && channel_index<m_dtvflow_num && m_channelStatus[channel_index].channelHalType!=channel_type)
		{
			int new_channel=-1;
			//clean up
			RTKHAL_INF("HAL hal changed, do clean up for channel %d\n", channel_index);
			pthread_mutex_unlock(&m_av_create_mutex);
			if(mCleanup_AV(channel_index)!=RTK_OK)
			{
				RTKHAL_ERR("clean up channel %d failed\n", channel_index);
			}
			pthread_mutex_lock(&m_av_create_mutex);
			rtk_porting_av_getUnusedChannelIndex(&new_channel);
			if(new_channel <0 || new_channel >=m_dtvflow_num)
			{
				RTKHAL_INF("no free dvb channel in server!!!\n");
			}
			else if(new_channel!=channel_index)
			{
				RTKHAL_ERR("channel id changed strage strage strage!!!\n");				
			}
			else 
			{
				find_channel=true;
				RTKHAL_INF("switch HAL type and find channel(%d) \n", channel_index);
				m_channels.push_back(channel_index);
			}							
		}
		else
		{
			if(channel_index>=0&&m_channelStatus[channel_index].channelHalType==channel_type)
			{
				RTKHAL_ERR("Please check, type is same, the fist find fail???\n");
			}
		}
	}

	if(find_channel!=true)
	{
		RTKHAL_ERR("find channel fail\n");
		return RTK_Fail;
	} else {
	    return RTK_OK;
	}

}

int RHAL_Base::mFindSourceDmxIndex_bySource(Source_Handle source_handle)
{
	int i=0;
	for(i=0; i<RTK_MAX_DTVSOURCE_MUM;i++)
	{
		if(source_handle!=NULL && m_sourceDmxHandle[i].source_handle==source_handle)
		{
			break; 
		}
	}
	if(i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("no free source dmx channel!!!\n");
		return -1;
	}
	
	return i;
}

int RHAL_Base::mGetSourceDmxIndex()
{
	int i=0;
	for(i=0; i<RTK_MAX_DTVSOURCE_MUM;i++)
	{
		if(m_sourceDmxHandle[i].isUsing==false)
		{
			m_sourceDmxHandle[i].isUsing=true;
			break; 
		}
	}
	if(i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("no free source dmx channel!!!\n");
		return -1;
	}
	
	return i;
}
void RHAL_Base::mPutSourceDmxIndex(int index)
{
	if(index>=0 && index<RTK_MAX_DTVSOURCE_MUM)
		m_sourceDmxHandle[index].isUsing=false;	
}

RTK_Error  RHAL_Base::mCreateSourceSectionFilter(RTK_Source source)
{
	DEMUX_HANDLE_S *p_dmx_h=NULL;
	int sourceDmx_index=mGetSourceDmxIndex();

	if(sourceDmx_index<0)
	{
		RTKHAL_ERR("no free  sourceDmx_index\n");
		return RTK_Fail;
	}
	
	if(rtk_porting_SectionFilterCreate(&p_dmx_h, RTK_SOURCE_DMX_CHANNEL_SHIFT)!=RTK_OK)
	{
		RTKHAL_ERR("Source Section Filter create fail\n");
		mPutSourceDmxIndex(sourceDmx_index);
		return RTK_Fail;
	}
	if(rtk_porting_SectionFilterSetSource(p_dmx_h, source)!=RTK_OK)
	{
		RTKHAL_ERR("Source Section Filter set source failed\n");
		rtk_porting_SectionFilterDestory(p_dmx_h);
		mPutSourceDmxIndex(sourceDmx_index);
		return RTK_Fail;
	}
	
	m_sourceDmxHandle[sourceDmx_index].dmx_handle=p_dmx_h;
	m_sourceDmxHandle[sourceDmx_index].source_handle=source;
	RTKHAL_INF("source dmx create success, index=%d, dmx_handle=%p, source_handle=%p\n",
		sourceDmx_index,
		m_sourceDmxHandle[sourceDmx_index].dmx_handle,
		m_sourceDmxHandle[sourceDmx_index].source_handle);

	m_sourceDmxHandle[sourceDmx_index].sectionThread_stop=false;
	m_sourceDmxHandle[sourceDmx_index].sectionThread_id=0;
	
	RHAL_ThreadParam_t *pThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
	pThreadParam->halHandle=&m_sourceDmxHandle[sourceDmx_index];
	pThreadParam->instance=this;
	pThreadParam->bUseSourceFilter = true;

	//mThreadSectionReadyEntry will free pThreadParam;
	pthread_create(&(m_sourceDmxHandle[sourceDmx_index].sectionThread_id), NULL, 
		mThreadSectionReadyEntry, pThreadParam);

	return RTK_OK;
}
RTK_Error  RHAL_Base::mDestroySourceSectionFilter(RTK_Source source)
{
	int source_dmx_index=-1;
	source_dmx_index=mFindSourceDmxIndex_bySource(source);

	if(source_dmx_index<0 ||  source_dmx_index >= RTK_MAX_DTVSOURCE_MUM)
	{
		return RTK_Fail;
	}
	
	RTKHAL_INF("Do source dmx destroy index=%d, dmx_handle=%p, source_handle=%p\n",
		source_dmx_index,
		m_sourceDmxHandle[source_dmx_index].dmx_handle,
		m_sourceDmxHandle[source_dmx_index].source_handle);

	//stop thread.
	m_sourceDmxHandle[source_dmx_index].sectionThread_stop=true;
	if(m_sourceDmxHandle[source_dmx_index].sectionThread_id)
		pthread_join(m_sourceDmxHandle[source_dmx_index].sectionThread_id, NULL);

	m_sourceDmxHandle[source_dmx_index].sectionThread_id=0;

	//destroy section.
	rtk_porting_SectionFilterDestory(m_sourceDmxHandle[source_dmx_index].dmx_handle);
	m_sourceDmxHandle[source_dmx_index].source_handle=NULL;
	m_sourceDmxHandle[source_dmx_index].dmx_handle=NULL;

	//put dmx index.
	mPutSourceDmxIndex(source_dmx_index);

	return RTK_OK;
}


//#endif // #ifdef CLIENT_DTVSOURCE

/***************************************************************
* 				   Public  class functions
****************************************************************/
RTK_Error RHAL_Base::Player_Create(RTK_Player *player, RTK_PlayerConfig *config, HAL_TYPE type)
{	
	RTKHAL_INF("[%s] enter \n", __FUNCTION__);
	HAL_HANDLE_S *hal_handle;
	RTK_Error ret = RTK_Fail;
    	int channel_index =-1;	
	RTK_GET_TIME(&start1);
	if((player == NULL) || (config == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTK_GET_TIME(&start1);

	pthread_mutex_lock(&m_av_create_mutex);
	if(config->input.isUseAssignedChannelId)
	{
		RTKHAL_INF("[%s] isUseAssignedChannelId (%d) \n", __FUNCTION__, config->input.assignedChannelId);
		if(mForceUseChannelIndex(type, config->input.assignedChannelId)!= true)
		{
			RTKHAL_ERR("[%s] mForceUseChannelIndex (%d) error\n", __FUNCTION__, config->input.assignedChannelId);
			pthread_mutex_unlock(&m_av_create_mutex);
			return RTK_Fail;
		}
		channel_index=config->input.assignedChannelId;
	}
	else
	{
		if (mAllocate_Channel_Index(type, channel_index)!= RTK_OK) {
			RTKHAL_ERR("[%s] mCheck_and_Allocte_Channel error\n", __FUNCTION__);
			pthread_mutex_unlock(&m_av_create_mutex);
			return RTK_Fail;
		}
	}

	ret = mOnceInit_AV(config->input, channel_index, type);
	if( ret != RTK_OK)
	{
		pthread_mutex_unlock(&m_av_create_mutex);
		RTKHAL_ERR("[%s] mOnceInit_AV error\n", __FUNCTION__);
		return RTK_Fail;
	}
	ret = mCreate(config->input, config->rec, (HAL_HANDLE_S**)player, type, channel_index);
	pthread_mutex_unlock(&m_av_create_mutex);

	if( ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] mCreate error\n", __FUNCTION__);
		return RTK_Fail;
	}

	hal_handle = (HAL_HANDLE_S*)*player;
	hal_handle->player_config = *config;
	hal_handle->type = type;
	hal_handle->uiTsFilterCnt = 0;

	RTK_VO_PLANE_e vo_plane = (config->video.output == RTK_WIN_MAIN) ? RTK_VO_PLANE_V1 : RTK_VO_PLANE_V2;
	rtk_porting_av_set_vo_plane(hal_handle->av_handle, vo_plane);

	if(type!=HAL_TYPE_ES_PLAYER)
		rtk_porting_av_set_AV_sync_mode(hal_handle->av_handle, hal_handle->AVSyncMode);

	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	m_pCurHal_Handle[hal_handle->channel] = hal_handle;
	rtk_porting_register_displayready_callback(hal_handle->av_handle, mPlayback_Callback_Entry);
	rtk_porting_register_firstAudioFrameDecoded_callback(hal_handle->av_handle, mFirstAudioFrame_Callback_Entry);
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
		
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);
	return RTK_OK;
}


/*
 * set vo plane
 */
RTK_Error RHAL_Base:: Player_Update_VO_Plane(RTK_Player player, RTK_WinPlane plane) 
{
	//HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)*player;
	RTK_VO_PLANE_e vo_plane = (plane == RTK_WIN_MAIN) ? RTK_VO_PLANE_V1 : RTK_VO_PLANE_V2;
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);    

    if (rtk_porting_video_set_display(av_handle, RTK_FALSE) == RTK_ERR)//show video
        return RTK_Fail;
    
	if (rtk_porting_av_set_vo_plane(av_handle, vo_plane) == RTK_ERR)
        return RTK_Fail;
    
    if (rtk_porting_video_set_display(av_handle, RTK_TRUE)==RTK_ERR)//show video
        return RTK_Fail;
    
    return RTK_OK;
}


/*
 * player destory
 */
RTK_Error RHAL_Base::Player_Destroy(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p enter \n", __FUNCTION__, player);
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	RTK_Error ret;

	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
#if 0	// m_SidebandHandle should never been close or delete here, or it will cause sideband related crash. by YZX 2020-08-13 
	RTK_PlayerConfig *config = &hal_handle->player_config;
	RTK_WinPlane plane_id = (config->video.output == RTK_WIN_MAIN)
				? RTK_WIN_MAIN : RTK_WIN_PIP;
	if(m_SidebandHandle[plane_id] != NULL ) {
		native_handle_close(m_SidebandHandle[plane_id]);
		native_handle_delete(m_SidebandHandle[plane_id]);
		m_SidebandHandle[plane_id] =  NULL;
	}
#endif

	RTK_GET_TIME(&start1);

	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	rtk_porting_unregister_displayready_callback(hal_handle->av_handle);
	rtk_porting_unregister_firstAudioFrameDecoded_callback(hal_handle->av_handle);
	m_pCurHal_Handle[hal_handle->channel] = NULL;
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);
//#ifdef ENABLE_DTVSOURCE
	rtk_porting_av_SetMultiChProgram(hal_handle->av_handle , 0xFF /*NOT_USE_MULTICHANNEL*/);
//#endif
	ret = mDestroy(hal_handle);
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);	
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);
	return ret;
}

/*
 * player start
 */
RTK_Error RHAL_Base::Player_Start(RTK_Player player)
{
	RTKHAL_INF("[%s] enter %p\n", __FUNCTION__, player);
	UINT32_T rate = 256;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
		
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	RTK_GET_TIME(&start1);
	
	UINT32_T av_handle = _xGet_AvHandle(hal_handle);
	RTKHAL_INF("[%s]:0x%x\n", __FUNCTION__, av_handle);

			
	RTK_PlayerConfig *config = &hal_handle->player_config;
	RTKHAL_INF("[%s]:%p vpid=%x, apid=%x, audio.focused=%d\n", __FUNCTION__, player, config->video.pid, config->audio.pid, config->audio.focused);	
	
	rate = (hal_handle->speed >= 0) ? (hal_handle->speed)*256 : 256;

	rtk_porting_av_set_rate(av_handle, rate);

	//Why every start action should do AV sync mode set ?? 

	if(IS_VALID_AVPID(config->video.pid) && IS_VALID_AVPID(config->audio.pid) &&
		!(hal_handle->playingStatus & (RHAL_VIDEO_PLAYING|RHAL_AUDIO_PLAYING)))
	{
		if(m_dtvflow_num>1)
		{
			if(config->audio.focused)
			{
				rtk_porting_av_set_AV_sync_mode(av_handle, hal_handle->AVSyncMode);
			}
			else
			{
				rtk_porting_av_set_AV_sync_mode(av_handle, RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO_AF);
			}
		}
		else
			rtk_porting_av_set_AV_sync_mode(av_handle, hal_handle->AVSyncMode);

	}
	//set video pid.
	if(IS_VALID_AVPID(config->video.pid) && !((hal_handle->playingStatus)&RHAL_VIDEO_PLAYING))
	{
		Rtk_Video_PlayParams_t video_param;
		video_param.e_codec_type = _xTransfer_Video_Codec(config->video.codec);
		rtk_porting_av_modify_video_pid(av_handle, config->video.pid, video_param.e_codec_type);
		rtk_porting_video_play(av_handle);
		rtk_porting_video_set_display(av_handle, RTK_TRUE);//show video
		hal_handle->playingStatus|=RHAL_VIDEO_PLAYING;
	}

	//set audio pid.
	if(IS_VALID_AVPID(config->audio.pid) && !((hal_handle->playingStatus)&RHAL_AUDIO_PLAYING))
	{
		Rtk_Audio_PlayParams_t audio_param;
		audio_param.e_codec_type = _xTransfer_Audio_Codec(config->audio.codec);
		rtk_porting_av_clear_audio_pid(av_handle);
		rtk_porting_av_add_audio_pid(av_handle, config->audio.pid, audio_param.e_codec_type);
		if(m_dtvflow_num>1)
		{
			if(config->audio.focused)
			{
				rtk_porting_audio_play(av_handle, config->audio.pid, RTK_TRUE);
			}
			else
			{
				rtk_porting_audio_play(av_handle, config->audio.pid, RTK_FALSE);
			}
		}
		else
			rtk_porting_audio_play(av_handle, config->audio.pid, RTK_TRUE);

		hal_handle->playingStatus|=RHAL_AUDIO_PLAYING;
		
	}

	if(hal_handle->type == HAL_TYPE_ES_PLAYER)
	{
		rtk_porting_video_set_display(av_handle, RTK_TRUE);//show video
		rtk_porting_video_play(av_handle);
		hal_handle->playingStatus|=RHAL_VIDEO_PLAYING;

		
		rtk_porting_audio_play(av_handle, 0x1FFF, RTK_TRUE);
		hal_handle->playingStatus|=RHAL_AUDIO_PLAYING;
	}
	
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	RTKHAL_INF("[%s] exit\n", __FUNCTION__);
	
	return RTK_OK;
}

/*
 * player stop
 */
RTK_Error RHAL_Base::Player_Stop(RTK_Player player, RTK_Bool keepLastFrame)
{
	RTKHAL_INF("[%s] enter %p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	RTK_GET_TIME(&start1);
	RTK_GET_TIME(&zapping_start);
	UINT32_T av_handle = _xGet_AvHandle(hal_handle);
	RTKHAL_INF("[%s]:0x%x\n", __FUNCTION__, av_handle);

	if(keepLastFrame == RTK_TRUE)
	{
		RTKHAL_INF("keep lastframe requested......\n");
	}
	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	if(hal_handle->stop_cc_thread == RTK_FALSE)
	{
		hal_handle->stop_cc_thread = RTK_TRUE;
		
	}

	if((hal_handle->playingStatus)&RHAL_AUDIO_PLAYING)
	{
		rtk_porting_audio_stop(av_handle);
		//config can be modified only in create and changeVideo or changeAuido APIs.
		//stop only do stop operation.
		//hal_handle->player_config.audio.pid=TS_INVALID_PID; //clear pid in config.
		
	}	
	if((hal_handle->playingStatus)&RHAL_VIDEO_PLAYING)		
	{	
		#if (VIDEO_STOP_NON_BLOCK)
		_video_stop_prepare(av_handle);
		rtk_porting_video_stop_nonblock(av_handle, keepLastFrame);
		_wait_video_stop_complete(av_handle);
		#else
		rtk_porting_video_stop(av_handle, keepLastFrame);
		#endif
		//config can be modified only in create and changeVideo or changeAuido APIs.
		//stop only do stop operation.
		//hal_handle->player_config.video.pid=TS_INVALID_PID;//clear pid in config.
	}

	if(hal_handle->internal_source) //flush cached data in mtp buffer.
	{
		int i=0;
		pthread_mutex_lock(&mtp_mutex);
		for(i = 0; i < MTP_BUF_COUNT; i++)
		{
			if(mtp_buf[i].source == hal_handle->connect_source)
			{	
				break;
			}	
		}
		if(i<MTP_BUF_COUNT)
		{
			mtp_buf[i].cache_ofs=0;
			mtp_buf[i].write_ofs=0;
			mtp_buf[i].freesize = 0;
		}
		pthread_mutex_unlock(&mtp_mutex);
	}
	
	hal_handle->playingStatus &= (~RHAL_VIDEO_PLAYING);
	hal_handle->playingStatus &= (~RHAL_AUDIO_PLAYING);
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);			

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	RTKHAL_INF("[%s] exit\n", __FUNCTION__);

	return RTK_OK;
}


/**
** @brief
** opens and sets sectionFilter by specific pid, add the SectionFilter into SI engine with the player handle
**
** @param[in]		player		 	handle of player to add section filter
** @param[out]		filter_handle 	 	handle of filter to specify
** @param[in]		pattern			defines filter pid, mask, mode, compose type, monitor mode, 
**								user param and a function pointer to SI section filter callback
**
** @retval		RTK_OK			_xAddSectionFilter has successfully processed
** @retval		RTK_Fail 			parameters error occurred or filter open failed.
**
*/
RTK_Error RHAL_Base::Player_AddSectionFilter(RTK_Player player, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);
	#ifdef ENABLE_SOURCE_FILTER

	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	bool useSourceFilter = mUseSourceFilter(player);	
	if (!useSourceFilter)
	{
		DEMUX_HANDLE_S* demux_handle_s= _xGet_DmxHandle((HAL_HANDLE_S *)player);	
		ret =  _xAddSectionFilter(demux_handle_s, filter_handle, pattern);
	}
	else	
	{		
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)player)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret =  _xAddSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle, pattern);
	}
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret =  _xAddSectionFilter(player, filter_handle, pattern);
	#endif
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	return ret;
}

/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		player		 	handle of player 
** @param[in]		filter_handle 	 	handle of filter to stop
**
** @retval		RTK_OK			section filter has been stopped parsing with 
**								specific filter_handle successfully.
** @retval		RTK_Fail 			parameters error occurred or SI engine PID 
**								filter remove failed
**
*/
RTK_Error RHAL_Base::Player_RemoveSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);
	#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	bool useSourceFilter = mUseSourceFilter(player);	
	if (!useSourceFilter)
	{
		DEMUX_HANDLE_S* demux_handle_s= _xGet_DmxHandle((HAL_HANDLE_S *)player);	
		ret = _xRemoveSectionFilter(demux_handle_s, filter_handle);
	}
	else	
	{	
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)player)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle);
	}
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret = _xRemoveSectionFilter(player, filter_handle);
	#endif
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	return ret;
}


/**
** @brief
** enable the sectionFilter status
**
** @param[in]		player			handle of player 
** @param[in]		filter_handle  handle of filter to enable
** @param[in]		enable 	 		enable or disable section fitler
**
** @retval		RTK_OK			section filter has been enable or disable success
** @retval		RTK_Fail 			parameters error occurred or SI engine PID 
**								filter enable failed
**
*/
RTK_Error RHAL_Base::Player_ControlSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle,RTK_Bool enable)
{
	RTK_Error ret =RTK_OK ;
#if 0
	RTKHAL_INF("[%s]:%p,enable = %d \n", __FUNCTION__, player,enable);

	RTK_GET_TIME(&start1);
//	_xRemoveSectionFilter(player, filter_handle);

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
#else
	UNUSED(player);
	UNUSED(filter_handle);
	UNUSED(enable);
#endif

	return ret;
}



/**
** @brief
** stops all sectionFilters player added, then sectionFilters will not work 
**
** @param[in]		player		 	handle of player 
**
** @retval		RTK_OK			all section filters have been stopped parsing successfully.
** @retval		RTK_Fail 			parameters error occurred or SI engine PID filter remove failed.
**
*/
RTK_Error RHAL_Base::Player_RemoveAllSectionFilters(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);

	#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	bool useSourceFilter = mUseSourceFilter(player);	
	if (!useSourceFilter)
	{
		DEMUX_HANDLE_S* demux_handle_s= _xGet_DmxHandle((HAL_HANDLE_S *)player);	
		ret = _xRemoveAllSectionFilters(demux_handle_s);
	}
	else	
	{
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)player)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveAllSectionFilters(m_sourceDmxHandle[s_dmx_i].dmx_handle);
	}
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret =  _xRemoveAllSectionFilters(player);
	#endif
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}



/*
 * TS filter
 * 		- These functions can be called multiple times.
 */
RTK_Error RHAL_Base::Player_AddTSFilter(RTK_Player player, RTK_TSFilterPattern * pattern, RTK_TSFilter * filter_handle)
{
	RTK_Error ret = RTK_OK;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	HAL_HANDLE_S* handle = (HAL_HANDLE_S*)player;

	RTK_GET_TIME(&start1);
	
	pthread_mutex_lock(&handle->mutex);
	if (handle->isRecording != RTK_TRUE)
	{
		ret = Record_Start(player);
		if (ret != RTK_OK)
		{
			RTKHAL_ERR("[%s] player:%p Record_Start fail!!\n", __func__, player);
			goto END_FUNC;
		}
	}	
	
	ret = _xAddTSFilter((HAL_HANDLE_S*)player, pattern, filter_handle);

	if (ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] _xAddTSFilter fail!!\n", __func__);
		goto END_FUNC;
	}
	handle->uiTsFilterCnt++;

END_FUNC:
	pthread_mutex_unlock(&handle->mutex);
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

RTK_Error RHAL_Base::Player_RemoveTSFilter(RTK_Player player, RTK_TSFilter filter_handle)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	RTK_GET_TIME(&start1);
	
	HAL_HANDLE_S* handle = (HAL_HANDLE_S*)player;
	
	RTK_Error ret = _xRemoveTSFilter(handle, filter_handle);

	if (ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] _xRemoveTSFilter fail!!\n", __func__);
		goto END_FUNC;
	}
	
	pthread_mutex_lock(&handle->mutex);
	
	if (handle->uiTsFilterCnt > 0)
	{
		handle->uiTsFilterCnt--;
	}
	
	if (handle->uiTsFilterCnt == 0)
	{
		if (handle->isRecording == true)
		{		
			ret = Record_Stop(player);
			if (ret != RTK_OK)
			{
				RTKHAL_ERR("[%s] Record_Stop fail!!\n", __func__);
				//goto END_FUNC;
			}
		}
		
		if (handle->pulRecShareMemFd && (int)(*handle->pulRecShareMemFd) != -1)
		{
			close(*handle->pulRecShareMemFd);
			*handle->pulRecShareMemFd = -1;
		}
		rtk_porting_record_destory(_xGet_AvHandle(handle));
	}
	pthread_mutex_unlock(&handle->mutex);

END_FUNC:
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	return ret;
}

RTK_Error RHAL_Base::Player_RemoveAllTSFilters(RTK_Player player)
{
	RTK_Error ret;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S* handle = (HAL_HANDLE_S*)player;

	RTK_GET_TIME(&start1);

	ret = _xRemoveAllTSFilters((HAL_HANDLE_S*)player);
	
	if (ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] _xRemoveAllTSFilters fail!!\n", __func__);
		goto END_FUNC;
	}
	
	pthread_mutex_lock(&handle->mutex);
	
	handle->uiTsFilterCnt = 0;

	if (handle->isRecording == true)
	{		
		ret = Record_Stop(player);
		if (ret != RTK_OK)
		{
			RTKHAL_ERR("[%s] Record_Stop fail!!\n", __func__);
			//goto END_FUNC;
		}
	}
	
	if (handle->pulRecShareMemFd && (int)(*handle->pulRecShareMemFd) != -1)
	{
		close(*handle->pulRecShareMemFd);
		*handle->pulRecShareMemFd = -1;
	}
	rtk_porting_record_destory(_xGet_AvHandle(handle));
	pthread_mutex_unlock(&handle->mutex);

END_FUNC:
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

RTK_Error RHAL_Base::Player_ResetTSFilterParser(RTK_Player player)
{
	RTK_Error ret;
	HAL_HANDLE_S* hal=(HAL_HANDLE_S*)player;
	if(hal==NULL)
		return RTK_Fail;
	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);

	RTK_GET_TIME(&start1);
	if(rtk_porting_record_reset(hal->av_handle)!=RTK_OK)
	{
		ret=RTK_Fail;
	}
	else
		ret=RTK_OK;

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

/*
 * Change A/V
 */
RTK_Error RHAL_Base::Player_ChangePCR(RTK_Player player, UINT16_T pcr_pid)
{
	
	RTKHAL_INF("[%s]:%p, pcr_pid:0x%x\n", __FUNCTION__, player, pcr_pid);
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	INT8_T ret;
	
	if(player== NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	RTK_GET_TIME(&start1);	
	ret = rtk_porting_av_modify_pcr_pid(hal_handle->av_handle, pcr_pid);

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);
	
	if(ret == (INT8_T)RTK_ERR)
		return RTK_Fail;
	
	return RTK_OK;
}

/** @brief
** @brief
** changes each track audio PID, codec type, then plays back the multi-audio
**
** @param[in]           player                  handle of player to change audio configuration
** @param[in]           audio                   pointer to an Array of RTK_AudioConfig object
** @param[in]           count                   the amount number of audio track
**
** @retval              RTK_OK                  change audio and play successfully.
** @retval              RTK_Fail                        parameter input error such as player or audio equals NULL.
**
*/
RTK_Error RHAL_Base::Player_ChangeAudioEx(RTK_Player player, RTK_AudioConfig **audio, UINT8_T count) // This API name will be changed to RTK_Player_ChangeAudio
{
	if((player == NULL) || (audio == NULL) || (*audio == NULL)){
		RTKHAL_ERR("[%s] param error ... \n",__FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle=(HAL_HANDLE_S*)player;
	UINT32_T av_handle=hal_handle->av_handle;
	UINT8_T i;
	RTK_AudioConfig *pAudioConfig = (*audio);
	RTK_AudioConfig *pAudioConfig_focus = NULL;
	RTK_AUDIO_CODEC_TYPE_e audio_codec;
	count=(count<=MAX_AUDIO_FILTER_DESC_SIZE)?count :MAX_AUDIO_FILTER_DESC_SIZE;

	for(i=0;i<count;i++){
		audio_codec=_xTransfer_Audio_Codec((pAudioConfig+i)->codec);
		rtk_porting_av_add_audio_pid(av_handle,(pAudioConfig+i)->pid,audio_codec);
		rtk_porting_audio_play(av_handle,(pAudioConfig+i)->pid,(pAudioConfig+i)->focused);
		if((pAudioConfig+i)->focused){
			pAudioConfig_focus = pAudioConfig+i;
		}
#if (0)//for Decrypt
		if(((pAudioConfig+i)->pid !=0) && ((pAudioConfig+i)->pid !=0x1FFF) && ((pAudioConfig+i)->encrypted ==1)
		{
			if(rtk_porting_TunerControlMtpDecryptPidAdd((pAudioConfig+i)->pid, RTK_PID_TYPE_AUDIO !=RTK_OK) //add audio pid to do decrypt.
			{
				return RTK_Fail;
			}
		}
#endif
	}
	if ((pAudioConfig_focus != NULL) &&
		(hal_handle->player_config.audio.pid != pAudioConfig_focus->pid ||
		 hal_handle->player_config.audio.codec != pAudioConfig_focus->codec))
	{
		RTKHAL_INF("[%s]: focus change to pid:0x%x codec:%d\n"
			,__FUNCTION__,pAudioConfig_focus->pid, pAudioConfig_focus->codec);
		//rtk_porting_audio_play(av_handle,pAudioConfig_focus->pid,RTK_TRUE);
		hal_handle->player_config.audio.pid = pAudioConfig_focus->pid;
		hal_handle->player_config.audio.codec = pAudioConfig_focus->codec;
		hal_handle->player_config.audio.encrypted = pAudioConfig_focus->encrypted;
	}
	else
	{
		RTKHAL_INF("%s(%d) focus not change",__FUNCTION__,__LINE__);
	}

	if(pAudioConfig_focus != NULL)
     {
       if(pAudioConfig_focus->focused)
       {
        
	       rtk_porting_audio_play(av_handle, pAudioConfig_focus->pid, RTK_TRUE);
       }
       else
       {
           rtk_porting_audio_play(av_handle, pAudioConfig_focus->pid, RTK_FALSE);
       }
       hal_handle->player_config.audio.focused=pAudioConfig_focus->focused;
     }
	return RTK_OK;
}

/**
** @brief
** changes config audio and plays the audio if currently is focused
**
** @param[in]   player       handle of player to change audio focus
** @param[in]   audio        audio config for pid/codec/encrypted ; focus not use
**
** @retval      RTK_OK       returned if change audio focus status successfully.
** @retval      RTK_Fail     returned if parameter input error such as player equals NULL.
**
*/
RTK_Error RHAL_Base::Player_ChangeAudio(RTK_Player player, RTK_AudioConfig * audio)
{
	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if((player == NULL) || (audio == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	RTK_GET_TIME(&start1);
	
	RTKHAL_INF("[%s]:%p apid=0x%x enc=%d\n", __FUNCTION__, player, audio->pid, audio->encrypted);
	UINT32_T av_handle = _xGet_AvHandle(hal_handle);

	RTK_PlayerConfig *player_config=&(hal_handle->player_config);

	if((audio->pid != player_config->audio.pid)||(audio->codec != player_config->audio.codec)
		|| !((hal_handle->playingStatus)&RHAL_AUDIO_PLAYING)||hal_handle->player_config.audio.focused != audio->focused)
	{
		hal_handle->player_config.audio.pid = audio->pid;
		hal_handle->player_config.audio.codec = audio->codec;
		hal_handle->player_config.audio.encrypted = audio->encrypted;

		if(IS_VALID_AVPID(player_config->audio.pid))//if audiio pid is not valid, do not do audio play really!
		{
			RTK_AUDIO_CODEC_TYPE_e audio_codec = _xTransfer_Audio_Codec(audio->codec);
			rtk_porting_av_clear_audio_pid(av_handle);
			rtk_porting_av_add_audio_pid(av_handle, audio->pid, audio_codec);

#if (0) //for Decrypt
			if ((audio->pid != 0) && (audio->pid != 0x1FFF) && (audio->encrypted == 1))
			{
				if(rtk_porting_TunerControlMtpDecryptPidAdd(audio->pid, RTK_PID_TYPE_AUDIO) != RTK_OK)	//add audio pid to do decrypt.
				{
					RTKHAL_ERR("[%s]:%p - %d\n", __FUNCTION__, player, __LINE__);
					return RTK_ERR;
				}
			}
#endif

			
			// play audio only when currently is focused player
			if(m_dtvflow_num>1) //only dtvflow > 1, focused works, otherwise always focuse this audio pid.
			{
				if(audio->focused)
					rtk_porting_audio_play(av_handle, audio->pid, RTK_TRUE);
				else
					rtk_porting_audio_play(av_handle, audio->pid, RTK_FALSE);

				hal_handle->player_config.audio.focused=audio->focused;
			}
			else
			{
				hal_handle->player_config.audio.focused=RTK_TRUE;
				rtk_porting_audio_play(av_handle, audio->pid, RTK_TRUE);
			}
			hal_handle->playingStatus|=RHAL_AUDIO_PLAYING;
		}
	}
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);

	return RTK_OK;
}

RTK_Error RHAL_Base::Player_ChangeVideo(RTK_Player player, RTK_VideoConfig * video)
{
	if((player == NULL) || (video == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
		
	RTK_GET_TIME(&start1);
	RTK_GET_TIME(&zapping_start2);
	RTKHAL_INF("[%s]:%p vpid=0x%x enc=%d\n", __FUNCTION__, player, video->pid, video->encrypted);
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);

	RTK_PlayerConfig *player_config=&((hal_handle)->player_config);

	if((video->pid != player_config->video.pid)||(video->codec != player_config->video.codec)
		|| !((hal_handle->playingStatus)&RHAL_VIDEO_PLAYING))
	{
		//must update this video pid, or RTK_Player_start can not find changed video pid.
		player_config->video = *video;
		if(IS_VALID_AVPID(player_config->video.pid))//if video pid is not valid, do not do video play really!
		{
			Rtk_Video_PlayParams_t video_param;
			video_param.e_codec_type = _xTransfer_Video_Codec(video->codec);

			rtk_porting_av_modify_video_pid(av_handle, video->pid, video_param.e_codec_type);

#if (0) //for Decrypt
			if ((video->pid != 0) && (video->pid != 0x1FFF) && (video->encrypted == 1))
			{
				if(rtk_porting_TunerControlMtpDecryptPidAdd(video->pid, RTK_PID_TYPE_VIDEO) != RTK_OK)	//add video pid to do decrypt.
				{
					RTKHAL_ERR("[%s]:%p - %d\n", __FUNCTION__, player, __LINE__);
					return RTK_ERR;
				}		
			}
#endif
			rtk_porting_video_play(av_handle);
			hal_handle->playingStatus|=RHAL_VIDEO_PLAYING;
		}
	}

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);

	return RTK_OK;
}


RTK_Error RHAL_Base::Player_GetInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	if((player == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	return mGetInputBuffer( (HAL_HANDLE_S*)player, buffer, hal_handle->type);
}

RTK_Error RHAL_Base::Player_GetInputInfoBuffer(RTK_Player player, unsigned char **ppReplayInfo, unsigned int *pInfoBufSize)
{
    HAL_HANDLE_S* halHandle=(HAL_HANDLE_S*)player;
    if(player == NULL || ppReplayInfo==NULL || pInfoBufSize==NULL)
    {
        RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
        return RTK_Fail;
    }
    if(halHandle->PlayerMtpMemPool == NULL)
    {
        RTKHAL_ERR("[%s]PlayerMtpMemPool is NULL......\n", __FUNCTION__);
        return RTK_Fail;
    }

    if((halHandle->PlayerMtpMemSize)>=(DTV_SHARED_MEMORY_SIZE+PKT_SIZE+REPLAY_INFO_MAX_SIZE))
    {
    	*ppReplayInfo=(unsigned char*)(halHandle->PlayerMtpMemPool)
		+(halHandle->PlayerMtpMemPool->header.endPhyAddr)+PKT_SIZE;
    	*pInfoBufSize = REPLAY_INFO_MAX_SIZE;
    }	
    else
    {
    	RTKHAL_ERR("[%s:%d]: this config not exist input info buffer\n",__func__,__LINE__);
    	*ppReplayInfo=NULL;
	*pInfoBufSize=0;
    }
    return RTK_OK;
}   

RTK_Error RHAL_Base::Player_DecryptResetOffset(RTK_Player player, uint64_t ofs)
{
	HAL_HANDLE_S* halHandle=(HAL_HANDLE_S*)player;
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	UINT32_T av_handle = _xGet_AvHandle(halHandle);
	RTKHAL_INF("[%s]:0x%x\n", __FUNCTION__, av_handle);

	if (rtk_porting_replay_decrypt_resetOffset(av_handle, ofs)!=RTK_OK)
	{
		RTKHAL_ERR("[%s]rtk_porting_reset_decrypt_buffer error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	return RTK_OK;
}	


RTK_Error RHAL_Base::Player_WaitDataGone(RTK_Player player, int32_t timeOut_MS)
{
    RTKHAL_INF("[%s] enter \n", __FUNCTION__);
    HAL_HANDLE_S* handle=(HAL_HANDLE_S*)player;
    UINT32_T wr = 0, rd = 0;
    
    wr = handle->PlayerMtpMemPool->header.writePtr;
    rd = handle->PlayerMtpMemPool->header.readPtr;
    while(rd!=wr)
    {
        usleep(10*1000);    
        timeOut_MS-=10;
        if(timeOut_MS<=0)
            break;
        
        wr = handle->PlayerMtpMemPool->header.writePtr;
        rd = handle->PlayerMtpMemPool->header.readPtr;
    }

    RTKHAL_INF("[%s] exit,  timeOut_MS=%d\n", __FUNCTION__, timeOut_MS);
    
    if(rd!=wr)
        return RTK_Fail;
    else
        return RTK_OK;    
    
}

RTK_Error RHAL_Base::Player_InputRedirect(RTK_Player player, bool isEnable, RTK_Demux redirect_from)
{
	HAL_HANDLE_S *hal_player = (HAL_HANDLE_S*)player;
	HAL_HANDLE_S *hal_demux= (HAL_HANDLE_S*)redirect_from;
	RTK_BOOL en=(isEnable)?RTK_TRUE:RTK_FALSE;

	if(hal_player==NULL || hal_demux==NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(rtk_porting_av_InputRedirect(hal_player->av_handle, en, hal_demux->av_handle)!=RTK_OK)
	{
		return RTK_Fail;
	}

	return RTK_OK;
}
RTK_Error RHAL_Base::Player_FeedInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	if((player == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	return mFeedInputBuffer((HAL_HANDLE_S*)player, buffer, hal_handle->type);
}

RTK_Error RHAL_Base::Player_DiscardInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	if((player == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	return mDiscardInputBuffer((HAL_HANDLE_S*)player, buffer, hal_handle->type);
}

RTK_Error RHAL_Base::Player_SetInputBufferAlign(RTK_Player player, uint32_t align)
{
	uint32_t ori_size=0;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	if((align%188)!=0)
	{
		RTKHAL_ERR("[%s]must align by 188!!!\n", __FUNCTION__);
		return RTK_Fail;
	}

	if(hal_handle->PlayerMtpMemPool==NULL)
	{
		RTKHAL_ERR("[%s]PlayerMtpMemPool is NULL\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	ori_size=hal_handle->PlayerMtpMemPool->header.origin_size;
	RTKHAL_INF("[%s] player=%p,ori_size=%d,align=%d\n", __FUNCTION__,player,ori_size,align);
	if(align>=188)
	{
		hal_handle->PlayerMtpMemPool->header.bufAlign=align;
		//recaculate the buffer end and size;
		hal_handle->PlayerMtpMemPool->header.size=ori_size/align*align;
		hal_handle->PlayerMtpMemPool->header.endPhyAddr=hal_handle->PlayerMtpMemPool->header.beginPhyAddr+
			hal_handle->PlayerMtpMemPool->header.size;

	}
	else
	{
		hal_handle->PlayerMtpMemPool->header.bufAlign=0;
		hal_handle->PlayerMtpMemPool->header.size=ori_size;
		hal_handle->PlayerMtpMemPool->header.endPhyAddr=hal_handle->PlayerMtpMemPool->header.beginPhyAddr+
			hal_handle->PlayerMtpMemPool->header.size;
	}

	return RTK_OK;
}
RTK_Error RHAL_Base::Player_FeedEsInputBuffer(RTK_Player player, RTK_EsInputBuf_t *buffer, int32_t timeout)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	UINT32_T wr = 0, rd = 0, beginPhyAddr=0, endPhyAddr=0, size=0;
	uint32_t feedSize=0, copySize=0;
	Rtk_rawSample_PacketInfo_t rawSample_info;
	int64_t time0, time1;
	struct timeval tv;
	
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	gettimeofday(&tv, NULL);
	time0 = (int64_t)tv.tv_sec*1000+tv.tv_usec/1000;

	RTK_GET_TIME(&start1);

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	memset(&rawSample_info, 0x00, sizeof(Rtk_rawSample_PacketInfo_t));

	while(1)
	{
		wr = hal_handle->pEsRingbuf_header->writePtr;
		rd = hal_handle->pEsRingbuf_header->readPtr;
		beginPhyAddr =hal_handle->pEsRingbuf_header->beginPhyAddr;
		endPhyAddr = hal_handle->pEsRingbuf_header->endPhyAddr;

		//get free size.
		if(wr >= rd)
		{
			size=(endPhyAddr - wr) + (rd-beginPhyAddr);
			if(size>=4) //avoid write pointer reach to the read pointer.
				size-=4;
		}
		else
		{
			size = (rd - wr) -4; 
		}

		if(size>= (buffer->length))
		{
			break;
		}

		gettimeofday(&tv, NULL);
		time1 = (int64_t)tv.tv_sec*1000+tv.tv_usec/1000;

		if (time1 - time0 > timeout)
		{
			RTKHAL_ERR("[%s:%d]:begin(0x%x), end(0x%x), rp(0x%x), wp(0x%x), size(0x%x), buffer->length(0x%x)\n", __func__, __LINE__,
						beginPhyAddr,endPhyAddr, rd, wr, size, buffer->length);
			RTKHAL_ERR("[%s]timeout when check free buffer!!!\n", __FUNCTION__);
			return RTK_Fail;
		}

		usleep(1000);
	}

	feedSize=buffer->length;

	//fill rawSample_info
	if(_xGet_AVtype_fromCodec(buffer->codec)==RTK_AV_VIDEO)
	{
		rawSample_info.type=RTK_AV_VIDEO;
		rawSample_info.codec=_xTransfer_Video_Codec(buffer->codec);
	}
	else if(_xGet_AVtype_fromCodec(buffer->codec)==RTK_AV_AUDIO)
	{
		rawSample_info.type=RTK_AV_AUDIO;
		rawSample_info.codec=_xTransfer_Audio_Codec(buffer->codec);
		rawSample_info.audio_configs.sampleRate=buffer->audio_configs.sampleRate;
		rawSample_info.audio_configs.channelNum=buffer->audio_configs.channelNum;
	}
	
	rawSample_info.pts=buffer->pts;
	rawSample_info.phyaddr=wr;
	rawSample_info.dataLen=buffer->length;

	while(1)
	{
		//---------------------------------------------------------------
		//	destination buffer is secure buffer
		//---------------------------------------------------------------
		if(buffer->isDstSecureBuf) //means dst buffer is secure
		{
			rawSample_info.secPhySrcAddr = buffer->secPhyAddr;
		
			//send raw sample. //TODO:
			if(rtk_porting_av_AddRawSampleInfo(hal_handle->av_handle, &rawSample_info) == RTK_OK)
			{
				break;
			}
		}
		//---------------------------------------------------------------
		//	destination buffer is non-secure buffer
		//---------------------------------------------------------------
		else
		{
			copySize=(feedSize>(endPhyAddr - wr))?(endPhyAddr - wr):(feedSize);
			memcpy(hal_handle->pEsbufVirt+wr, buffer->pData, copySize);

			/*if(copySize>=8)
			{
				unsigned char *p=hal_handle->pEsbufVirt+wr;
				RTKHAL_INF("Feed es buffer: sample hex dump:%02x %02x %02x %02x %02x %02x %02x %02x\n",
						p[0], p[1], p[2], p[3],
						p[4], p[5], p[6], p[7]);
			}*/
			wr+=copySize;

			feedSize-=copySize;
			if(feedSize>0)
			{
				memcpy(hal_handle->pEsbufVirt+beginPhyAddr, buffer->pData+copySize, feedSize);
				wr=beginPhyAddr+feedSize;
			}

			if(wr>=endPhyAddr)
			{
				wr=beginPhyAddr;
			}

			hal_handle->pEsRingbuf_header->writePtr=wr;

			//send raw sample. //TODO:
			if(rtk_porting_av_AddRawSampleInfo(hal_handle->av_handle, &rawSample_info) == RTK_OK)
			{
				break;
			}
		}

		gettimeofday(&tv, NULL);
		time1 = (int64_t)tv.tv_sec*1000+tv.tv_usec/1000;

		if (time1 - time0 > timeout)
		{
			printf("RHAL_Base::%s(%d) RawSample info full !!!\n", __FUNCTION__,__LINE__);
			return RTK_Fail;
		}
		
		usleep(1000);
	}
	
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	RTKHAL_INF("[%s] exit \n", __FUNCTION__);

	return RTK_OK;
}

RTK_Error RHAL_Base::Player_Pause(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	RTK_GET_TIME(&start1);
	RTK_GET_TIME(&zapping_start3);

	INT8_T ret;
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);

	ret = rtk_porting_av_pause(av_handle, RTK_TRUE);
	

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);

	if(ret == (INT8_T)RTK_ERR)
		return RTK_Fail;
	
	return RTK_OK;
}

RTK_Error RHAL_Base::Player_Resume(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	INT8_T ret;
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);
	//rtk_porting_video_resume(av_handle);
	//rtk_porting_audio_resume(av_handle);
	ret = rtk_porting_av_resume(av_handle);
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);
	
	if(ret == (INT8_T)RTK_ERR)
		return RTK_Fail;
	
	return RTK_OK;
}



/*
 * RTK_Player_DropData()
 * 		Drops all previously fed TS from internal buffer which is not yet processed(not decoded, or waiting for display)
 *  	- This function is used for "Seek" operation.
 */
RTK_Error RHAL_Base::Player_DropData(RTK_Player player)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	INT8_T ret;
	//drop all data,such as demux,decode
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	UINT32_T av_handle = _xGet_AvHandle(hal_handle);

	if(hal_handle->internal_source)
	{
		Source_Flush(hal_handle->internal_source);
	}
	#if 1 
	//Drop Data need flush the connect source. 
	//Otherwise, the MTP cached buffer will contain some dirty data.
	if(hal_handle->connect_source) //Need flush connect source ??? Or connect source only need flush by source.
	{
		Source_Flush(hal_handle->connect_source);
	}
	#endif

	ret = rtk_porting_av_flush(av_handle);
	RTKHAL_INF("[%s] exit \n", __FUNCTION__);

	if(ret == (INT8_T)RTK_ERR)
		return RTK_Fail;
	
	return RTK_OK;
}


#ifdef ANDROID
void* RHAL_Base::Player_GetSidebandHandle(RTK_Player player)
{
	RTKHAL_INF("Player_GetSidebandHandle enter... \n" );
	HAL_HANDLE_S* hal_handle = (HAL_HANDLE_S*)player;
	RTK_PlayerConfig *config = &hal_handle->player_config;
	RTK_WinPlane plane_id = (config->video.output == RTK_WIN_MAIN)
				? RTK_WIN_MAIN : RTK_WIN_PIP;
	RTKHAL_INF("Player_GetSidebandHandle enter...plane_id = %d  \n", plane_id ); 
	
	if(m_SidebandHandle[plane_id] !=NULL){
		RTKHAL_INF("Player_GetSidebandHandle return already create... \n" );
		return m_SidebandHandle[plane_id];
	}

#if defined USE_RTKHAL_IN_ANDROID8 || defined USE_RTKHAL_IN_ANDROID9 || defined(USE_RTKHAL_IN_ANDROID10)
        native_handle_t *handle = NULL; 
        SidebandClient::createDvdSBStream(&handle, (int)(plane_id+1)); 
        //native_window_set_sideband_stream(m_surface_main.get(), handle); 
	 m_SidebandHandle[plane_id] = handle;
#endif

	return m_SidebandHandle[plane_id];
}
#endif // ANDROID

RTK_Error RHAL_Base::Player_SetAVSyncMode(RTK_Player player, RTK_AVsyncMode  AvSyncMode)
{
	RTK_NAV_AVSYNC_MODE NavAVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO_AF;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p, AvSyncMode:%d\n", __FUNCTION__, player, AvSyncMode);

	switch(AvSyncMode)
	{
	case RTK_AVSYNC_AUDIO_MASTER_AUTO_AF:
		NavAVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO_AF;
		break;
	case RTK_AVSYNC_VIDEO_ONLY:
		NavAVSyncMode = RTK_NAV_AVSYNC_VIDEO_ONLY;
		break;
	case RTK_AVSYNC_AUDIO_ONLY:
		NavAVSyncMode = RTK_NAV_AVSYNC_AUDIO_ONLY;
		break;		
	case RTK_AVSYNC_SYSTEM_MASTER_BY_PCR:
		NavAVSyncMode = RTK_NAV_AVSYNC_SYSTEM_MASTER_BY_PCR;
		break;
	case RTK_AVSYNC_SYSTEM_MASTER:
		NavAVSyncMode = RTK_NAV_AVSYNC_SYSTEM_MASTER;
		break;		
	case RTK_AVSYNC_AUDIO_MASTER_AUTO:
		NavAVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO;
		break;
	case RTK_AVSYNC_AUDIO_MASTER_AUTO_SKIP:
		NavAVSyncMode = RTK_NAV_AVSYNC_AUDIO_MASTER_AUTO_SKIP;
		break;
    case RTK_AVSYNC_SLOW:
        NavAVSyncMode = RTK_NAV_AVSYNC_SLOW;
        break;		
	case RTK_AVSYNC_INIT_MODE:
		pthread_mutex_lock(&hal_handle->mutex);
		NavAVSyncMode = hal_handle->AVSyncMode;
		pthread_mutex_unlock(&hal_handle->mutex);
		break;
    }
	hal_handle->AVSyncMode = NavAVSyncMode;
	rtk_porting_av_set_AV_sync_mode(hal_handle->av_handle, NavAVSyncMode);

	return RTK_OK;
}

/*
 * Trick playing.
 */
 
/**
** @brief
** sets the speed of play
**
** @param[in]		player		 	handle of player to deal with	
** @param[in]		speed 	 		multiplier factor of change
**
** @retval		RTK_OK			the play speed has changed successfully.
** @retval		RTK_ERR 			parameters error occurred or the play speed change failed.
**
*/
RTK_Error RHAL_Base::Player_SetPlaySpeed(RTK_Player player, float speed)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	RTKHAL_INF("[%s]:%p, speed:%f\n", __FUNCTION__, player, speed);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	pthread_mutex_lock(&hal_handle->mutex);
	//float preSpeed = hal_handle->speed;
	hal_handle->speed = speed;
	pthread_mutex_unlock(&hal_handle->mutex);

#if (0) //sync from skb branch.
	char value[PROPERTY_VALUE_MAX];
	property_get("rtk.hdmi.output", value,"0");
	if(preSpeed == 1.0 && speed != 1.0)
	{
		RTKHAL_INF("[zdl] x1 to x%f \n",speed);
		preSpeed = speed;
		g_mode = (ENUM_AUDIO_DIGITAL_OUTPUT_MODE)atoi(value);
		if(g_mode == AUDIO_DIGITAL_AUTO)
			SetAudioHdmiOutputMode(AUDIO_DIGITAL_LPCM_DUAL_CH);
	}
	else if(preSpeed != 1.0 && speed == 1.0)
	{
		RTKHAL_INF("[zdl] x%f to x1 \n",preSpeed);
		preSpeed = speed;
		SetAudioHdmiOutputMode(g_mode);
	}
#endif	
	INT32_T rate = 256*speed;
	rtk_porting_av_set_rate(hal_handle->av_handle, rate);
	
	/*
	marked by yang_yang 20170801
	trick play do not need to change AV sync mode! 
	0.5x~2x AV sync mode: audio master!
	hal_handle->AVSyncMode = RTK_NAV_AVSYNC_SYSTEM_MASTER_BY_PCR;
	*/
	//rtk_porting_av_set_AV_sync_mode(hal_handle->av_handle, AVSyncMode);

	//hal_handle->MtpMemPool->header.speed = speed;
	return RTK_OK;
}


/**
** @brief
** gets play speed of current
**
** @param[in]		player		 	handle of player to deal with	
** @param[out]		speed 	 		get the multiplier factor of current paly speed 
**
** @retval		RTK_OK			the play speed has got successfully
** @retval		RTK_ERR 			parameters error occurred or play speed get failed.
**
*/
RTK_Error RHAL_Base::Player_GetPlaySpeed(RTK_Player player, float * speed)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	pthread_mutex_lock(&hal_handle->mutex);
	*speed = hal_handle->speed;
	pthread_mutex_unlock(&hal_handle->mutex);

	return RTK_OK;
}

RTK_Error RHAL_Base::Player_GetCurrentDisplayingPTS(RTK_Player player, uint64_t * _pts)
{
	if((player == NULL) || (_pts == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	INT8_T ret = rtk_porting_av_getCurrentPTS(_xGet_AvHandle(hal_handle), _pts);

	if(ret == RTK_OK)
		return RTK_OK;

	return RTK_Fail;
}


RTK_Error RHAL_Base::Player_GetCurrentDisplayingPTSInfo(RTK_Player player, RTK_PTSInfo * pts_info)
{
	if((NULL == player) || (NULL == pts_info))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	RTK_AV_PTSINFO     mPTSInfo;
	INT8_T ret = rtk_porting_av_getCurrentPTSInfo(_xGet_AvHandle(hal_handle), &mPTSInfo);

	if(ret == RTK_OK)
	{	
		pts_info->presentVideoPts = mPTSInfo.presentVideoPTS;	
		pts_info->presentAudioPts = mPTSInfo.presentAudioPTS;
		pts_info->demuxSubtitlePts = mPTSInfo.demuxSubtitlePTS;
		RTKHAL_INF("presentVideoPTS=%lld,presentAudioPTS=%lld  demuxSubtitlePts= %lld \n",mPTSInfo.presentVideoPTS, mPTSInfo.presentAudioPTS,pts_info->demuxSubtitlePts);		
		return RTK_OK;
	}
	return RTK_Fail;
}




RTK_Error RHAL_Base::Player_SendIFrameInfo(RTK_Player player, RTK_IframeOffset_t info)
{
    if((player == NULL) || (info.data_phyaddr!=0))
    {
        RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
        return RTK_Fail;
    }

    HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
    IframeOffset_t info_t;
    memset(&info_t, 0, sizeof(info_t));

    if(hal_handle->DemuxMtpMemPool != NULL)
		info_t.data_phyaddr  = hal_handle->DemuxMtpMemPool->header.shared_buf_wr_ptr;
    info_t.data_size	 = info.data_size;
    info_t.iframe_offset = info.iframe_offset;
    info_t.iframe_size   = info.iframe_size;
//    RTKHAL_INF("[%s] zzz phyaddr=0x%x, total=%x, I offset=%x, I size = %x\n", __FUNCTION__,
//        info_t.data_phyaddr, info_t.data_size, info_t.iframe_offset, info_t.iframe_size);


    INT8_T ret = rtk_porting_send_Iframe_info(hal_handle->av_handle, info_t);

    return (RTK_Error)ret;
}

/**
** @brief
** sets the player with specific handle video plane visible or not
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		mute 			defines set video mute or not, RTK_FALSE means 
**								set video plane  visible, RTK_TRUE means not.  
**
** @retval		RTK_OK			set the specific player video plane visible mute successfully.
** @retval		RTK_Fail 			parameters error occurred or set mute failed.
**
*/
RTK_Error RHAL_Base::Player_SetVideoMute(RTK_Player player, RTK_Bool mute)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	RTKHAL_INF("[%s]:%p, mute=%d\n", __FUNCTION__, player, mute);

	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);

	rtk_porting_video_set_visible(av_handle, RTK_DISPLAY_VIDEO, !mute);
	return RTK_OK;
}

/**
** @brief
** gets a specific player video visible status
**
** @param[in]		player		 	handle of player to deal with
** @param[out]		mute 			the value of video visible status currently	
**
** @retval		RTK_OK			get the specific player video visible status successfully.
** @retval		RTK_Fail 			parameters error occurred or got video visible status failed.
**
*/
RTK_Error RHAL_Base::Player_GetVideoMute(RTK_Player player, RTK_Bool * mute)
{
	if((player == NULL) || (mute == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p enter\n", __FUNCTION__, player);

	UINT32_T av_handle =  _xGet_AvHandle((HAL_HANDLE_S*)player);
	INT8_T visible = true;
	rtk_porting_video_get_visible(av_handle,RTK_DISPLAY_VIDEO, &visible);
	*mute = (RTK_Bool)!visible;

	RTKHAL_INF("[%s] exit mute=%d\n", __FUNCTION__, *mute);
	
	return RTK_OK;
}
/**
** @brief
** sets the player with specific handle audio mute.
**
** NOT system wide mute, just for player. (used while trick playing)
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		mute 			defines set audio mute or not, RTK_FALSE 
**								means not , RTK_TRUE means set mute
**
** @retval		RTK_OK			set the specific player mute successfully.
** @retval		RTK_ERR 			parameters error occurred or set mute failed.
**
*/

RTK_Error RHAL_Base::Player_SetAudioMute(RTK_Player player, RTK_Bool mute)
{
if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p, mute=%d enter\n", __FUNCTION__, player, mute);
	
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);
	rtk_porting_audio_setDecMute(av_handle,mute);

	rtk_store_system_cmd(RTK_AUDIO_MUTE,RTK_SYSTEM_TYPE_INT,(UINT32_T *)mute);	
	return RTK_OK;

}

/**
** @brief
** gets a specific player audio mute status
**
** @param[in]		player		 	handle of player to deal with
** @param[out]		mute_status 		get the value of audio mute status currently,
**								RTK_FALSE means not mute, RTK_TRUE means mute 
**
** @retval		RTK_OK			get the specific player mute status successfully.
** @retval		RTK_ERR 			parameters error occurred or got mute status failed. 
**
*/
RTK_Error RHAL_Base::Player_GetAudioMute(RTK_Player player, RTK_Bool * mute)
{
  if((player == NULL) || (mute == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p enter\n", __FUNCTION__, player);
	
	UINT32_T av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);
	rtk_porting_audio_getDecMuteStatus(av_handle,(INT8_T*)mute);
	
	RTKHAL_INF("[%s] exit mute=%d\n", __FUNCTION__, *mute);
	return RTK_OK;
}

RTK_Error RHAL_Base::Player_EnableSecurePlayShareMem(RTK_Player player, RTK_Bool en)
{
	HAL_HANDLE_S* hal_handle=(HAL_HANDLE_S*)player;
	char bufNm[128]={0};

	if(hal_handle==NULL)
	{
		RTKHAL_ERR("[%s:%d]:invalid paramter\n", __func__, __LINE__);
		return RTK_Fail;
	}

	if(en)
	{
		if(rtk_porting_av_enableSecurePlayShm(hal_handle->av_handle, RTK_TRUE)!=RTK_OK)
		{
			RTKHAL_ERR("rtk_porting_av_enableSecurePlayShm failed\n");
			return RTK_Fail;
		}
		//map secure play share memory
		if(hal_handle->securePlayShm_fd>0 || hal_handle->pSecurePlayShmHandle)
		{
			return RTK_OK;
		}
		
		sprintf(bufNm, "play_secshm_fd%d", hal_handle->channel);
		if(rtk_porting_FDSHMClient_GetFd(bufNm, &(hal_handle->securePlayShm_fd))!=RTK_OK)
		{
			RTKHAL_ERR("[%s:%d]:get fd fail\n", __func__, __LINE__);
			return RTK_Fail;		
		}
		hal_handle->pSecurePlayShmHandle=rtk_porting_map_ionmem(hal_handle->securePlayShm_fd, 
			&(hal_handle->pSecurePlayShm_virt), &(hal_handle->securePlayShm_size));

		if(hal_handle->pSecurePlayShmHandle==NULL ||
			hal_handle->pSecurePlayShm_virt==NULL || hal_handle->securePlayShm_size==0)
		{
			RTKHAL_ERR("[%s:%d]:map secure play share memory failed\n", __func__, __LINE__);
			if(hal_handle->securePlayShm_fd>0)
			{
				close(hal_handle->securePlayShm_fd);
				hal_handle->securePlayShm_fd=-1;
			}
			return RTK_Fail;
		}

		RTKHAL_INF("channel(%d), secure play shm map success:fd=%d, pSecurePlayShm_virt=%p, securePlayShm_size=%u\n",
			hal_handle->channel, hal_handle->securePlayShm_fd, (hal_handle->pSecurePlayShm_virt), 
			hal_handle->securePlayShm_size);

		hal_handle->isSecurePlayShmUsed=true;
		
	}
	else
	{
		//unmap secure play share memory
		if(hal_handle->pSecurePlayShmHandle)
		{
			rtk_porting_unmap_ionmem(hal_handle->pSecurePlayShmHandle);
			hal_handle->pSecurePlayShmHandle=NULL;
			hal_handle->pSecurePlayShm_virt=NULL;
			hal_handle->securePlayShm_size=0;
		}
		if(hal_handle->securePlayShm_fd>0)
		{
			close(hal_handle->securePlayShm_fd);
			hal_handle->securePlayShm_fd=-1;
		}
		if(rtk_porting_av_enableSecurePlayShm(hal_handle->av_handle, RTK_FALSE)!=RTK_OK)
		{
			RTKHAL_ERR("rtk_porting_av_enableSecurePlayShm failed\n");
			return RTK_Fail;
		}
		hal_handle->isSecurePlayShmUsed=false;
	}

	return RTK_OK;
}

RTK_Error RHAL_Base::Player_SetTrickMode(RTK_Player player, RTK_HAL_avTrickMode_e trickMode)
{
	HAL_HANDLE_S* hal_handle=(HAL_HANDLE_S*)player;
	RTK_AV_TRICK_MODE_e port_trickMode=RTK_AV_TRICK_MODE_IONLY;
	if(hal_handle==NULL)
	{
		RTKHAL_ERR("[%s:%d]:invalid paramter\n", __func__, __LINE__);
		return RTK_Fail;
	}
	
	switch(trickMode)
	{
	case RHAL_AV_TRICK_IONLY:
		port_trickMode=RTK_AV_TRICK_MODE_IONLY;
		break;
	case RHAL_AV_TRICK_FULLTS:
		port_trickMode=RTK_AV_TRICK_MODE_FULLTS;
		break;
	default:
		port_trickMode=RTK_AV_TRICK_MODE_IONLY;
		break;
	}

	if(rtk_porting_av_setTrickMode(hal_handle->av_handle, port_trickMode)!=RTK_OK)
		return RTK_Fail;
	
	return RTK_OK;
}

/**
** @brief
** Get Ts data input bitrate which calculated with PCR info.
**
** @param[in]	player		 	handle of player to deal with
** @param[out]	pullBitrate 	pointer of the variable witch will store the result.
**
** @retval		RTK_OK			success.
** @retval		RTK_ERR 		failed. 
**
*/
RTK_Error RHAL_Base::Player_GetTsInputBitrate(RTK_Player player, UINT64_T* pullBitrate)
{
	if((player == NULL) || (pullBitrate == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p Enter >>\n", __FUNCTION__, player);

	UINT32_T uiAvHandle = _xGet_AvHandle((HAL_HANDLE_S*)player);
	INT8_T cRet = rtk_porting_av_getTsInputBitrate(uiAvHandle, pullBitrate);
	if (cRet != RTK_OK)
	{
		RTKHAL_ERR("[%s] fail!!\n", __FUNCTION__);
	}
	RTKHAL_INF("[%s] End << bitrate:%llu\n", __FUNCTION__, *pullBitrate);
	return (RTK_Error)cRet;
}

/**
   * @brief
   * Record start.
   *
   * @param[in] 	player			handle of player to deal with
   *
   * @retval		RTK_OK			success.
   * @retval		RTK_ERR 		failed. 
   *
   */
RTK_Error RHAL_Base::Record_Start(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);

	RTK_Error ret = RTK_Fail;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(hal_handle == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	if(hal_handle->isRecording == RTK_TRUE)
	{
		RTKHAL_ERR("[%s]already start\n", __FUNCTION__);
		ret = RTK_OK;
	}
	else
	{
		RTK_REC_CONFIG_t rec_config;
		rec_config.mode = (RTK_REC_MODE_e)hal_handle->demux_config.rec.mode;
		rec_config.enc_method = (RTK_REC_METHOD_e)hal_handle->demux_config.rec.enc_method;
		
		if (hal_handle->uiTsFilterCnt == 0)
		{
			if(rtk_porting_record_create(hal_handle->av_handle, rec_config) != RTK_OK)
			{
				RTKHAL_ERR("[%s]rtk_porting_record_create failed.........\n", __FUNCTION__);
				ret = RTK_Fail;
				goto END_FUNC;
			}		
			INT32_T iRecShareMemFd = -1;
#ifdef ENABLE_TS_CALLBACK_RECORD
			char cName[64];
			snprintf(cName, sizeof(cName) - 1, "%s%d", DTV_REC_SHAREMEM_NAME, hal_handle->channel);
			if (rtk_porting_FDSHMClient_GetFd(cName, &iRecShareMemFd) != RTK_OK || iRecShareMemFd < 0)
			{
				RTKHAL_ERR("[%s:%d] Get %s share memory fd fail!!\n", __func__, __LINE__, cName);
				ret = RTK_Fail;
				goto END_FUNC;
			}

			RTKHAL_INF("[%s]chan_index=%d RecSharefd=%d\n", __func__, hal_handle->channel, iRecShareMemFd);
#endif

			for(int i = 0; i < m_dtvflow_num; i++)
			{
				if(hal_handle->channel == m_ionmem_sharefd[i].channel)
				{
					m_ionmem_sharefd[i].RecSharefd = iRecShareMemFd;
					hal_handle->pulRecShareMemFd = &m_ionmem_sharefd[i].RecSharefd;
					break;
				}
			}
		}
		
		hal_handle->isRecording = RTK_TRUE;

		//create record callback thread.
		RHAL_ThreadParam_t *pThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
		pThreadParam->halHandle=hal_handle;
		pThreadParam->instance=this;
		pthread_create(&(hal_handle->rec_callback_thread), NULL, mThreadRecordEntry, pThreadParam); 

		if(rtk_porting_record_start(hal_handle->av_handle) != RTK_OK)
		{
			RTKHAL_ERR("[%s]rtk_porting_record_start failed.........\n", __FUNCTION__);
			hal_handle->isRecording = RTK_FALSE;
			if(hal_handle->rec_callback_thread)
			{
				pthread_join(hal_handle->rec_callback_thread, NULL);
				hal_handle->rec_callback_thread = 0;
			}
			ret = RTK_Fail;
			goto END_FUNC;
		}
		else
		{
			ret = RTK_OK;
		}		

	}

END_FUNC:	
	return ret;
}

/**
   * @brief
   * Record stop.
   *
   * @param[in] 	player			handle of player to deal with
   *
   * @retval		RTK_OK			success.
   * @retval		RTK_ERR 		failed. 
   *
   */
RTK_Error RHAL_Base::Record_Stop(RTK_Player player)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	RTK_Error ret = RTK_OK;
	HAL_HANDLE_S *hal_handle=(HAL_HANDLE_S*)player;
	
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	if(hal_handle->isRecording == RTK_TRUE)
	{
	    INT8_T result = rtk_porting_record_stop(hal_handle->av_handle);
		hal_handle->isRecording = RTK_FALSE;
		if(hal_handle->rec_callback_thread)
		{
			pthread_join(hal_handle->rec_callback_thread, NULL);
			hal_handle->rec_callback_thread = 0;
		}
	    
		if (result != RTK_OK)
		{
			RTKHAL_ERR("[%s]rtk_porting_record_stop failed.........\n", __FUNCTION__);
			ret = RTK_Fail;
		}

		if (hal_handle->uiTsFilterCnt == 0)
		{			
			if (hal_handle->pulRecShareMemFd && (int)(*hal_handle->pulRecShareMemFd) != -1)
			{
				close(*hal_handle->pulRecShareMemFd);
				*hal_handle->pulRecShareMemFd = -1;
			}
			rtk_porting_record_destory(_xGet_AvHandle(hal_handle));
		}
	}
	else
	{
		RTKHAL_ERR("[%s]already stoped!!\n", __FUNCTION__);
		ret = RTK_OK;
	}
	
	if(hal_handle->stop_cc_thread == RTK_FALSE)
	{
		hal_handle->stop_cc_thread = RTK_TRUE;		
	}
	
	return ret;
}

//RTKHAL 2.0 remove TS demux and EMM demux.
//RTKHAL 2.1 add TS demux. by YZX 7-29
#if 1
/**
** @brief
** creates Demux for recording
**
** @param[out]		demux			return the Demux handle created by this function
** @param[in]		demux_config 	the configs used when creating the Demux
**
** @retval		RTK_OK			Demux created successfully
** @retval		RTK_Fail 			Demux created fail
**
*/
RTK_Error RHAL_Base::Demux_Create(RTK_Demux * demux, RTK_DemuxConfig * demux_config)
{
	RTKHAL_INF("[%s]\n", __FUNCTION__);

	HAL_HANDLE_S *hal_handle;
	RTK_Error ret = RTK_Fail;
    	int channel_index =-1;	
	if((demux == NULL) || (demux_config == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
    	pthread_mutex_lock(&m_av_create_mutex);

	if(demux_config->input.isUseAssignedChannelId)
	{
		RTKHAL_INF("[%s] isUseAssignedChannelId (%d) \n", __FUNCTION__, demux_config->input.assignedChannelId);
		if(mForceUseChannelIndex(HAL_TYPE_DEMUX_ONLY, demux_config->input.assignedChannelId)!= true)
		{
			RTKHAL_ERR("[%s] mForceUseChannelIndex (%d) error\n", __FUNCTION__, demux_config->input.assignedChannelId);
			pthread_mutex_unlock(&m_av_create_mutex);
			return RTK_Fail;
		}
		channel_index=demux_config->input.assignedChannelId;
	}
	else 
	{
	    	if (mAllocate_Channel_Index(HAL_TYPE_DEMUX_ONLY,channel_index)!= RTK_OK) {
			RTKHAL_ERR("[%s] mCheck_and_Allocte_Channel error\n", __FUNCTION__);
			pthread_mutex_unlock(&m_av_create_mutex);
			return RTK_Fail;
	    	}
	}

	ret = mOnceInit_AV(demux_config->input, channel_index,HAL_TYPE_DEMUX_ONLY);
	if( ret != RTK_OK)
	{
      		pthread_mutex_unlock(&m_av_create_mutex);
		return RTK_Fail;
	}

	ret = mCreate( demux_config->input, demux_config->rec, (HAL_HANDLE_S**)demux, HAL_TYPE_DEMUX_ONLY, channel_index);
    	pthread_mutex_unlock(&m_av_create_mutex);
	if( ret != RTK_OK)
	{
		return RTK_Fail;
	}

	hal_handle = (HAL_HANDLE_S*)*demux;
	hal_handle->type = HAL_TYPE_DEMUX_ONLY;
	hal_handle->demux_config = *demux_config;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, *demux);
	
	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	m_pCurHal_Handle[hal_handle->channel] = hal_handle;
	rtk_porting_register_displayready_callback(hal_handle->av_handle, mPlayback_Callback_Entry);
	rtk_porting_register_firstAudioFrameDecoded_callback(hal_handle->av_handle, mFirstAudioFrame_Callback_Entry);
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);

	//if(rtk_porting_record_create(hal_handle->av_handle) != RTK_OK)
	//{
	//	RTKHAL_ERR("rtk_porting_rec_create2 failed.........\n");
	//	return RTK_Fail;
	//}
#if 0
#if defined(USE_SIGNAL_HANDLER)
	if(add_allocated(g_allocated_demuxes, *demux) != RTK_OK)
	{
		return RTK_Fail;
	}
#endif
#endif

	return RTK_OK;
}

/**
** @brief
** destroys the Demux
**
** @param[in]		demux 	the Demux handle, this handle must be same with the 
created one
**
** @retval		RTK_OK			RTK_ Demux_Destroy has successfully processed
** @retval		RTK_Fail 			parameters error occurred or _xDestroy return failed.
**
*/
RTK_Error RHAL_Base::Demux_Destroy(RTK_Demux demux)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;

	if(demux == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	else
	{
		Demux_Stop(demux);
	}
	
#if 0
#if defined(USE_SIGNAL_HANDLER)
	if(!remove_allocated(g_allocated_demuxes, demux))
		return RTK_Fail;
#endif
#endif

	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	rtk_porting_unregister_displayready_callback(hal_handle->av_handle);
	rtk_porting_unregister_firstAudioFrameDecoded_callback(hal_handle->av_handle);
	m_pCurHal_Handle[hal_handle->channel] = NULL;
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);
	return mDestroy((HAL_HANDLE_S*)demux);
}

/**
** @brief
** lets Demux running
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			RTK_ Demux_Start has successfully processed.
** @retval		RTK_Fail 			parameters error occurred or started the Demux failed.
**
*/
RTK_Error RHAL_Base::Demux_Start(RTK_Demux demux)
{
	RTK_Error Ret = RTK_OK;
	HAL_HANDLE_S* hal_handle = (HAL_HANDLE_S*)demux;
	if (hal_handle == NULL)
	{
		RTKHAL_ERR("[%s] demux is NULL!!\n", __func__);
		return RTK_Fail;
	}	
	pthread_mutex_lock(&hal_handle->mutex);
	Ret = Record_Start((RTK_Player)demux);
	pthread_mutex_unlock(&hal_handle->mutex);
	return Ret;
}

/**
** @brief
** stops Demux
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			RTK_ Demux_Stop has successfully processed.
** @retval		RTK_Fail 			parameters error occurred or stopped the Demux failed.
**
*/
RTK_Error RHAL_Base::Demux_Stop(RTK_Demux demux)
{
	RTK_Error Ret = RTK_OK;
	HAL_HANDLE_S* hal_handle = (HAL_HANDLE_S*)demux;
	if (hal_handle == NULL)
	{
		RTKHAL_ERR("[%s] demux is NULL!!\n", __func__);
		return RTK_Fail;
	}
	pthread_mutex_lock(&hal_handle->mutex);
	Ret = Record_Stop((RTK_Player)demux);
	pthread_mutex_unlock(&hal_handle->mutex);
	return Ret;
}

RTK_Error RHAL_Base::Demux_Pause(RTK_Demux demux)
{
	HAL_HANDLE_S* hal=(HAL_HANDLE_S*)demux;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	if(rtk_porting_av_pause(hal->av_handle, RTK_FALSE)!=RTK_OK)
		return RTK_Fail;
	else
		return RTK_OK;
	
}
RTK_Error RHAL_Base::Demux_Resume(RTK_Demux demux)
{
	HAL_HANDLE_S* hal=(HAL_HANDLE_S*)demux;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	if(rtk_porting_av_resume(hal->av_handle)!=RTK_OK)
		return RTK_Fail;
	else
		return RTK_OK;
}

/**
** @brief
** opens and sets sectionFilter by specific pid, add the SectionFilter into SI engine with the demux handle
**
** @param[in]		demux		 handle of demux to add section filter
** @param[out]		filter_handle 	 handle of filter to specify
** @param[in]		pattern		 defines filter pattern,include pid, mask, mode, compose type, monitor mode,and so on
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RHAL_Base::Demux_AddSectionFilter(RTK_Demux demux, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);
	#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)demux)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret =  _xAddSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle, pattern);
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret =  _xAddSectionFilter((HAL_HANDLE_S*)demux, filter_handle, pattern);
	#endif
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	return ret;
}

/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		demux		 handle of demux 
** @param[in]		filter_handle 	 handle of filter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RHAL_Base::Demux_RemoveSectionFilter(RTK_Demux demux, RTK_SectionFilter filter_handle)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);
	#ifdef ENABLE_SOURCE_FILTER	
	int s_dmx_i=-1;
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)demux)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle);
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret = _xRemoveSectionFilter((HAL_HANDLE_S*)demux, filter_handle);
	#endif

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	return ret;
}

/**
** @brief
** stops all sectionFilters demux added, then sectionFilters will not work 
**
** @param[in]		demux		 handle of demux to deal with
**
** @retval		RTK_OK			remove all success
** @retval		RTK_Fail 			remove all fail
**
*/
RTK_Error RHAL_Base::Demux_RemoveAllSectionFilters(RTK_Demux demux)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	RTK_Error ret=RTK_Fail;
	RTK_GET_TIME(&start1);
	#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(((HAL_HANDLE_S *)demux)->connect_source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveAllSectionFilters(m_sourceDmxHandle[s_dmx_i].dmx_handle);
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#else
	ret =  _xRemoveAllSectionFilters((HAL_HANDLE_S*)demux);
	#endif
	
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

/*
 * TS filter
 * 		- These functions can be called multiple times.
 */
 
/**
** @brief
** adds TSFilter for demux
**
** @param[in]		demux		 	handle of demux to add 
** @param[in]		pattern 	 		defines filter pattern ,include pid, encrypted or not, A/V codec types, get PTS and Frame type or not
** @param[out]		filter_handle		handle of filter to specify
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RHAL_Base::Demux_AddTSFilter(RTK_Demux demux, RTK_TSFilterPattern * pattern, RTK_TSFilter * filter_handle)
{
	RTK_Error ret;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);

	RTK_GET_TIME(&start1);
	ret =  _xAddTSFilter((HAL_HANDLE_S*)demux, pattern, filter_handle);

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

/**
** @brief
** removes the TSFilter, then it should not parse the specific TS data
**
** @param[in]		demux		 	handle of player to deal with
** @param[in]		filter_handle		handle of TsFilter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RHAL_Base::Demux_RemoveTSFilter(RTK_Demux demux, RTK_TSFilter filter_handle)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	RTK_GET_TIME(&start1);

	HAL_HANDLE_S* handle = (HAL_HANDLE_S*)demux;

	RTK_Error ret = _xRemoveTSFilter(handle, filter_handle);
	if (ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] _xRemoveTSFilter fail!!\n", __func__);
		goto END_FUNC;
	}

	pthread_mutex_lock(&handle->mutex);
	
	if (handle->uiTsFilterCnt > 0)
	{
		handle->uiTsFilterCnt--;
	}
	
	if (handle->uiTsFilterCnt == 0)
	{
		if (handle->isRecording == true)
		{		
			ret = Record_Stop(handle);
			if (ret != RTK_OK)
			{
				RTKHAL_ERR("[%s] Record_Stop fail!!\n", __func__);
				//goto END_FUNC;
			}
		}
		
		if (handle->pulRecShareMemFd && (int)(*handle->pulRecShareMemFd) != -1)
		{
			close(*handle->pulRecShareMemFd);
			*handle->pulRecShareMemFd = -1;
		}
		rtk_porting_record_destory(_xGet_AvHandle(handle));
	}
	pthread_mutex_unlock(&handle->mutex);

END_FUNC:
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	return ret;
}

/**
** @brief
** stops all TSFilter demux added, then TSFilter will not work 
**
** @param[in]		demux		 	handle of player to deal with
**
** @retval		RTK_OK			remove all success
** @retval		RTK_Fail 			remove all fail
**
*/
RTK_Error RHAL_Base::Demux_RemoveAllTSFilters(RTK_Demux demux)
{
	RTK_Error ret;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	HAL_HANDLE_S* handle = (HAL_HANDLE_S*)demux;

	RTK_GET_TIME(&start1);

	ret = _xRemoveAllTSFilters((HAL_HANDLE_S*)demux);
	if (ret != RTK_OK)
	{
		RTKHAL_ERR("[%s] _xRemoveAllTSFilters fail!!\n", __func__);
		goto END_FUNC;
	}
	
	pthread_mutex_lock(&handle->mutex);
	
	handle->uiTsFilterCnt = 0;
	
	if (handle->isRecording == true)
	{		
		ret = Record_Stop(handle);
		if (ret != RTK_OK)
		{
			RTKHAL_ERR("[%s] Record_Stop fail!!\n", __func__);
			//goto END_FUNC;
		}
	}
	
	if (handle->pulRecShareMemFd && (int)(*handle->pulRecShareMemFd) != -1)
	{
		close(*handle->pulRecShareMemFd);
		*handle->pulRecShareMemFd = -1;
	}
	rtk_porting_record_destory(_xGet_AvHandle(handle));
	pthread_mutex_unlock(&handle->mutex);

END_FUNC:
	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);

	return ret;
}

RTK_Error RHAL_Base::Demux_EnableTSFilterSecurebuf(RTK_Demux demux, RTK_Bool isSecure)
{
//	RTK_Error ret=RTK_Fail;
	HAL_HANDLE_S* hal_handle=(HAL_HANDLE_S*)demux;
	RTK_BOOL en=isSecure?1:0;
	char bufNm[128]={0};
	
	if(demux==NULL)
	{
		RTKHAL_INF("[%s:%d]:invalid param\n", __func__, __LINE__);
		return RTK_Fail;
	}
	hal_handle->rec_inSecurebuf=isSecure;
	//TODO: tell server record use secure share buffer.
	
	if(rtk_porting_record_enableSecureBuf(hal_handle->av_handle, en)!=RTK_OK)
	{
		RTKHAL_ERR("[%s:%d]:rtk_porting_record_enableSecureBuf fail\n", __func__, __LINE__);
		return RTK_Fail;
	}

	if(isSecure)
	{
		if(hal_handle->rec_secbuf_fd==-1 || hal_handle->rec_secbuf_fd==0)
		{
			sprintf(bufNm, "rec_secshm_fd%d", hal_handle->channel);
			if(rtk_porting_FDSHMClient_GetFd(bufNm, &(hal_handle->rec_secbuf_fd))!=RTK_OK)
			{
				RTKHAL_ERR("[%s:%d]:get fd fail\n", __func__, __LINE__);
				return RTK_Fail;		
			}
		}

		if(hal_handle->rec_secbuf_fd<=0)
		{
			RTKHAL_ERR("[%s:%d]:invalid fd fail\n", __func__, __LINE__);
			return RTK_Fail;	
		}
		//hal_handle->rec_secbuf_fd will be close when demux destroy called.
	}
	
	return RTK_OK;
}

RTK_Error RHAL_Base::Demux_ResetTSFilterParser(RTK_Demux demux)
{
	RTK_Error ret;
	HAL_HANDLE_S* hal=(HAL_HANDLE_S*)demux;

	if(hal==NULL)
		return RTK_Fail;
	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	RTK_GET_TIME(&start1);

	if(rtk_porting_record_reset(hal->av_handle)!=RTK_OK)
	{
		ret=RTK_Fail;
	}
	else
		ret=RTK_OK;

	RTK_GET_TIME(&end1);
	RTK_GET_SPEND_TIME(&start1,&end1, &timeuse);
	RTK_INFO_ZAPPING_TIME(__FUNCTION__, timeuse);
	
	return ret;
}

/*
 * Memory input
 */
 
/**
** @brief
** gets a buffer from share memory to reserve TS data
**
** @param[in]		demux		 	handle of player to deal with
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			get success
** @retval		RTK_Fail 			get fail
**
*/
RTK_Error RHAL_Base::Demux_GetInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	if((demux == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;
	return mGetInputBuffer( (HAL_HANDLE_S*)demux, buffer, hal_handle->type);
}

/**
** @brief
** feeds TS data to input buffer for play
**
** @param[in]		demux		 	handle of player to reserve play data and share memory information
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			feed success
** @retval		RTK_Fail 			feed fail
**
*/
RTK_Error RHAL_Base::Demux_FeedInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	if((demux == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;
	return mFeedInputBuffer((HAL_HANDLE_S*)demux, buffer, hal_handle->type);
}

/**
** @brief
** discards input buffer
**
** @param[in]		demux		 	handle of player to deal with
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			 discard success
** @retval		RTK_Fail 			 discard fail
**
*/
RTK_Error RHAL_Base::Demux_DiscardInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);
	if((demux == NULL) || (buffer == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;	
	return mDiscardInputBuffer((HAL_HANDLE_S*)demux, buffer, hal_handle->type);
}


RTK_Error RHAL_Base::Demux_AddPESFilter(RTK_Demux demux , RTK_PESFilterPattern * pattern)
{
	RTK_Error ret;
	ret = _xAddPESFilter(demux, pattern);
	return ret;
}

RTK_Error RHAL_Base::Demux_RemovePESFilter(RTK_Demux demux,UINT8_T u8FilterID)
{
	RTK_Error ret;
	ret = _xRemovePESFilter(demux,u8FilterID);
	return ret;
}

RTK_Error RHAL_Base::Demux_SetSubtitle(RTK_Demux demux, RTK_SubtitleConfig ptrSubtitleTrackInfo)
{
	INT8_T ret ;
	if(demux == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}   
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, demux);

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;

	Rtk_Subtitle_Info_t  tsSubtitleTrackInfo;
	tsSubtitleTrackInfo.bshow=  ptrSubtitleTrackInfo.bshow;
	tsSubtitleTrackInfo.idx= ptrSubtitleTrackInfo.idx;
	tsSubtitleTrackInfo.langcode=ptrSubtitleTrackInfo.langcode;
	tsSubtitleTrackInfo.pid= ptrSubtitleTrackInfo.pid;
	tsSubtitleTrackInfo.subtype=(RTK_AP_SUBTITLE_TYPE_e)ptrSubtitleTrackInfo.subtype;
	ret=rtk_porting_av_SetSubtitle( hal_handle->av_handle,tsSubtitleTrackInfo);

	if(ret == RTK_OK)
	return RTK_OK;

	return RTK_Fail;
}


#endif

//RTKHAL 2.0 remove EMM demux.
#if 0
/***************************************************************************************
 * EmmDemux
 ***************************************************************************************/

/* It creates Demux(or TP) match with demux_number. */
/* Currently, We MUST always use TP0 as it is globally used in CAS Module(DAL). So, TVS will always set 'demux_number' parameter to 0. */
/* You need to consider life cycle of TP. */
/* + if(TP has already existed by another module such as RTK_Player, RTK_Demux) */
RTK_Error RHAL_Base::EmmDemux_Create(RTK_EmmDemux *emmdemux, RTK_EmmDemuxConfig *config)
{
	RTKHAL_INF("[%s] enter \n", __FUNCTION__);
	HAL_HANDLE_S *hal_handle;
	RTK_Error ret = RTK_Fail;

	if((emmdemux == NULL) || (config == NULL))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

#if 0
#if defined(USE_SIGNAL_HANDLER)
	if( g_cleanup == RTK_TRUE)
	{
		return RTK_Fail;
	}
#endif
#endif

	ret = mOnceInit_AV(config->input);
	if( ret != RTK_OK) 
	{
		return RTK_Fail;
	}
	
	ret = mCreate( config->input, (HAL_HANDLE_S**)emmdemux, HAL_TYPE_EMMDEMUX);
	if( ret != RTK_OK) 
	{
		return RTK_Fail;
	}

	hal_handle = (HAL_HANDLE_S*)*emmdemux;
	hal_handle->type = HAL_TYPE_EMMDEMUX;
	hal_handle->emmdemux_config = *config;
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, *emmdemux);

#if 0
#if defined(USE_SIGNAL_HANDLER)
	if( add_allocated(g_allocated_emmdmx, *emmdemux) != RTK_OK)
	{
		return RTK_Fail;
	}
#endif
#endif

	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);
	m_pCurEmmDemux_Handle[hal_handle->channel] = hal_handle;
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);

	RTKHAL_INF("[%s] exit \n", __FUNCTION__);
	return RTK_OK;

}

/* It destroys Demux(or TP) match with demux_number */
/* EMM Receiving is always turned on which means we'll never call it until STB is turned off. */
/* You need to consider life cycle of TP. */
/* + if(TP has already existed by another module such as RTK_Player, RTK_Demux) */
RTK_Error RHAL_Base::EmmDemux_Destroy(RTK_EmmDemux emmdemux)
{
	RTKHAL_INF("[%s]:%p enter\n", __FUNCTION__, emmdemux);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)emmdemux;
	RTK_Error ret;

	if(emmdemux == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

#if 0
#if defined(USE_SIGNAL_HANDLER)
	if(!remove_allocated(g_allocated_emmdmx, emmdemux))
	{
		return RTK_Fail;
	}
#endif
#endif

	pthread_mutex_lock(&m_rtk_hal_mutex[hal_handle->channel]);	
	m_pCurEmmDemux_Handle[hal_handle->channel] = NULL;
	pthread_mutex_unlock(&m_rtk_hal_mutex[hal_handle->channel]);

	ret = mDestroy((HAL_HANDLE_S*)emmdemux);	 

	RTKHAL_INF("[%s] exit\n", __FUNCTION__);

	return ret;


}

/* Buffer control interfaces for EMM. */
/* Currently, as TP0 is globally used in CAS Module(DAL). TVS will always set 'demux_number' parameter to 0. */
RTK_Error RHAL_Base::EmmDemux_GetInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, emmdemux);
	return mGetInputBuffer( (HAL_HANDLE_S*)emmdemux, buffer, HAL_TYPE_EMMDEMUX);
}

RTK_Error RHAL_Base::EmmDemux_FeedInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, emmdemux);
	return mFeedInputBuffer((HAL_HANDLE_S*)emmdemux, buffer, HAL_TYPE_EMMDEMUX);
}

RTK_Error RHAL_Base::EmmDemux_DiscardInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	//RTKHAL_INF("[%s]:%p\n", __FUNCTION__, emmdemux);
	return mDiscardInputBuffer((HAL_HANDLE_S*)emmdemux, buffer, HAL_TYPE_EMMDEMUX);
}

/**
** @brief
** opens and sets sectionFilter by specific PID, add the SectionFilter into SI engine with the emmdemux handle
**
** @param[in]		emmdemux		handle of emmdemux to add section filter
** @param[out]		filter_handle		handle of filter to specify
** @param[in]		pattern			defines filter PID, mask, mode, compose type, monitor mode,
**								user parameter and a function pointer to SI section filter callback
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RHAL_Base::EmmDemux_AddSectionFilter(RTK_EmmDemux emmdemux, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, emmdemux);
	return _xAddSectionFilter( emmdemux, filter_handle, pattern);
}


/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		emmdemux		handle of emmdemux to deal with
** @param[in]		filter_handle		handle of filter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RHAL_Base::EmmDemux_RemoveSectionFilter(RTK_EmmDemux emmdemux, RTK_SectionFilter filter_handle)
{
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, emmdemux);
	return _xRemoveSectionFilter(emmdemux, filter_handle);
}
#endif


  /**
** @brief
**[]set audio volume;          
** @param[in]			i32volume			the volume value to set, range:0~31    
**0=> Manimum , 31=> is Maxmum
** @retval			void
*/	
void RHAL_Base:: Player_SetAudioVolume(uint32_t i32volume)
{
	RTKHAL_INF("[%s]:set Volume %d \n", __FUNCTION__, i32volume);
	rtk_porting_audio_setVolume(i32volume);
	return ;
}
  
void RHAL_Base::  Player_GetAudioVolume(uint32_t* i32volume)
{
       INT32_T volume=0;
	rtk_porting_audio_getVolume(&volume);
	*i32volume=(uint32_t)volume;
	RTKHAL_INF("[%s]: getVolume%d\n", __FUNCTION__, *i32volume);
	return ;
}



RTK_Error RHAL_Base::TunerInit(void)
{
    if (RTK_OK != rtk_porting_tuner_init())
    {
        RTKHAL_ERR("[%s] failed\n", __FUNCTION__);
        return RTK_Fail;
    }
    return RTK_OK;
}

RTK_Error RHAL_Base::TunerUnInit(void)
{
    if (RTK_OK != rtk_porting_tuner_uninit())
    {
        RTKHAL_ERR("[%s] failed\n", __FUNCTION__);
        return RTK_Fail;
    }
    return RTK_OK;
}

RTK_Error RHAL_Base::TunerScan(uint8_t ucTunerID, RTK_TunerParam_t param)
{
    Rtk_Tuner_Param_t tuner_param;

    RTKHAL_INF("[%s] 0x%x enter\n", __FUNCTION__, ucTunerID);
    if(param.type == RTK_TUNER_TYPE_DVBC)
    {
        //input ex:730,1,6875000
        tuner_param.type = RTK_TUNER_TYPE_DVB_C;
        tuner_param.bandwidth =(Rtk_Tuner_Bandwidth_e) param.bandwidth;
        tuner_param.tnr_param.dvb_c_param.u32frequency = param.tnr_param.dvb_c_param.u32frequency*1000*1000;
        tuner_param.tnr_param.dvb_c_param.u32symbol_rate = param.tnr_param.dvb_c_param.u32symbol_rate;
        tuner_param.tnr_param.dvb_c_param.modulation = (Rtk_CableTnr_Modulation_e)param.tnr_param.dvb_c_param.modulation;
        tuner_param.tnr_param.dvb_c_param.annex_type = (Rtk_DVBC_ANNEX_TYPE_e)param.tnr_param.dvb_c_param.annex_type;
        RTKHAL_INF("DVBC: tuner.u32frequency=%u\n", tuner_param.tnr_param.dvb_c_param.u32frequency);
        RTKHAL_INF("DVBC: tuner.u32symbol_rate=%u\n", tuner_param.tnr_param.dvb_c_param.u32symbol_rate);
        RTKHAL_INF("DVBC: tuner.modulation=%d\n", (int)tuner_param.tnr_param.dvb_c_param.modulation);
        RTKHAL_INF("DVBC: tuner.annex_type=%d\n", (int)tuner_param.tnr_param.dvb_c_param.annex_type);
    }
    else if(param.type == RTK_TUNER_TYPE_DVB_T )
    {
        //input ex:730
        tuner_param.type = RTK_TUNER_TYPE_DVBT;
        tuner_param.tnr_param.dvb_t_param.u32frequency = param.tnr_param.dvb_t_param.u32frequency*1000*1000;
        tuner_param.bandwidth = (Rtk_Tuner_Bandwidth_e)param.bandwidth;
        RTKHAL_INF("DVBT: tuner.u32frequency = %u bandwidth = %s\n",
            tuner_param.tnr_param.dvb_t_param.u32frequency,
            GET_BANDWIDTH_STR(tuner_param.bandwidth));
    }
    else if(param.type == RTK_TUNER_TYPE_DVB_T2 )
    {
        //input ex:730
        tuner_param.type = RTK_TUNER_TYPE_DVBT2;
        tuner_param.tnr_param.dvb_t_param.u32frequency = param.tnr_param.dvb_t_param.u32frequency*1000*1000;
        tuner_param.bandwidth = (Rtk_Tuner_Bandwidth_e)param.bandwidth;
        RTKHAL_INF("DVBT2: tuner.u32frequency = %u bandwidth = %s\n",
            tuner_param.tnr_param.dvb_t_param.u32frequency,
            GET_BANDWIDTH_STR(tuner_param.bandwidth));
    }
    else if(param.type == RTK_TUNER_TYPE_DTMB)
    {
        //input ex:730
        tuner_param.type = RTK_TUNER_TYPE_DTMB_T;
        tuner_param.tnr_param.dtmb_t_param.u32frequency = param.tnr_param.dtmb_t_param.u32frequency*1000*1000;
        RTKHAL_INF("DTMB: tuner.u32frequency=%u\n", tuner_param.tnr_param.dtmb_t_param.u32frequency);
    }
    else if(param.type == RTK_TUNER_TYPE_ABS)
    {
        //input ex:730
        tuner_param.type = RTK_TUNER_TYPE_ABS_S;
        tuner_param.tnr_param.abs_s_param.u32frequency = param.tnr_param.abs_s_param.u32frequency*1000*1000;
        RTKHAL_INF("ABS: tuner.u32frequency=%u\n", tuner_param.tnr_param.abs_s_param.u32frequency);
    }
    else if(param.type == RTK_TUNER_TYPE_DVB_S)
    {
        tuner_param.type = RTK_TUNER_TYPE_DVBS;
        tuner_param.tnr_param.dvb_s_param.u32frequency = param.tnr_param.dvb_s_param.u32frequency*1000*1000;
        tuner_param.tnr_param.dvb_s_param.lnbmode = (Rtk_LNB_MODE_e)param.tnr_param.dvb_s_param.lnbmode;
        tuner_param.tnr_param.dvb_s_param.u32symbol_rate = param.tnr_param.dvb_s_param.u32symbol_rate ;
        RTKHAL_INF("DVBS: tuner.u32frequency = %u lnbmode = %s symbolrate = %u\n",
            tuner_param.tnr_param.dvb_t_param.u32frequency,
            GET_LNBMODE_STR(tuner_param.tnr_param.dvb_s_param.lnbmode),
            tuner_param.tnr_param.dvb_s_param.u32symbol_rate);
    }
    else if(param.type == RTK_TUNER_TYPE_DVB_S2)
    {
        tuner_param.type = RTK_TUNER_TYPE_DVBS2;
        tuner_param.tnr_param.dvb_s_param.u32frequency = param.tnr_param.dvb_s_param.u32frequency*1000*1000;
        tuner_param.tnr_param.dvb_s_param.lnbmode = (Rtk_LNB_MODE_e)param.tnr_param.dvb_s_param.lnbmode;
        tuner_param.tnr_param.dvb_s_param.u32symbol_rate = param.tnr_param.dvb_s_param.u32symbol_rate ;
        RTKHAL_INF("DVBS2: tuner.u32frequency = %u lnbmode = %s symbolrate = %u\n",
            tuner_param.tnr_param.dvb_t_param.u32frequency,
            GET_LNBMODE_STR(tuner_param.tnr_param.dvb_s_param.lnbmode),
            tuner_param.tnr_param.dvb_s_param.u32symbol_rate);
    }

    if (param.type >= RTK_TUNER_TYPE_DVBC && param.type <= RTK_TUNER_TYPE_DVB_T2)
    {
        if (rtk_porting_tuner_scan(ucTunerID, tuner_param) != RTK_OK)
        {
            RTKHAL_ERR("[%s] 0x%x tuner scan failed\n", __FUNCTION__, ucTunerID);
            return RTK_Fail;
        }
    }
    else
    {
        RTKHAL_ERR("[%s] 0x%x tuner scan param error\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
    }
    return RTK_OK;
}

RTK_Error RHAL_Base::TunerIsLock(uint8_t ucTunerID)
{
    Rtk_Tuner_State_e tnr_state = RTK_TUNER_STATE_UNKNOWN;

    if (RTK_OK != rtk_porting_tuner_isLock(ucTunerID, &tnr_state))
    {
        RTKHAL_ERR("[%s] 0x%x failed\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
    }

    RTKHAL_INF("[%s] 0x%x tnr_state=%d\n", __FUNCTION__, ucTunerID, tnr_state);
    return (tnr_state == RTK_TUNER_STATE_LOCKED) ? RTK_OK : RTK_Fail;
}

RTK_Error RHAL_Base::TunerGetInfo(uint8_t ucTunerID, RTK_TunerInfo * info)
{
    Rtk_Tuner_State_e tnr_state = RTK_TUNER_STATE_UNKNOWN;
    Rtk_Signal_ALLInfo_t signal;

    if (info == NULL)
    {
        RTKHAL_ERR("[%s] 0x%x info parameter is null\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
    }

    if (RTK_OK != rtk_porting_tuner_isLock(ucTunerID, &tnr_state))
    {
        RTKHAL_ERR("[%s] 0x%x get isLock failed\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
    }
    RTKHAL_INF("[%s] 0x%x tnr_state=%d\n",__FUNCTION__, ucTunerID, tnr_state);

    memset(&signal,0x0,sizeof(Rtk_Signal_ALLInfo_t));
    if (RTK_OK != rtk_porting_tuner_getSignalInfo(ucTunerID, &signal))
    {
        RTKHAL_ERR("[%s] 0x%x get signal info failed\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
    }

    info->number = ucTunerID;
    info->locked = (tnr_state == RTK_TUNER_STATE_LOCKED) ? RTK_TRUE : RTK_FALSE;
    info->strength = signal.u32signal_strength;
    info->quality = signal.u32signal_quality;
    info->snr = signal.signal_snr;
    info->ber = signal.signal_ber;
    info->lber = signal.signal_lber;
    info->agc = signal.signal_agc;
    info->powerLevel = signal.powerlevel;
    info->packetError = signal.signal_per;
    info->mer = 10 * log10(1 - signal.signal_per);
    info->temperature = signal.temperature;
	
    return RTK_OK;
}

RTK_Error RHAL_Base::Tuner_GetDeviceChipid(uint32_t uiTunerID,uint8_t * pDevicechipid)
{
    uint8_t Devicechipid;
    *pDevicechipid = 0xFF;
#if 1
    if(rtk_porting_tuner_getTunerChipid(uiTunerID, &Devicechipid) != RTK_OK)
    {
        return RTK_Fail;
    }
#else
	UNUSED(uiTunerID);
	if(rtk_porting_source_getChipID(m_pCurHal_Handle[m_uiTunerChannel]->connect_source, &Devicechipid) != RTK_OK)
	{
        return RTK_Fail;
	}
#endif
    *pDevicechipid = Devicechipid;
    return RTK_OK;
}

RTK_Error RHAL_Base::TunerRelease(uint8_t ucTunerID)
{
	if (rtk_porting_tuner_release(ucTunerID) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u release failed!!\n", __FUNCTION__, ucTunerID);
        return RTK_Fail;
	}
	return RTK_OK;
}
RTK_Error RHAL_Base::TunerSetChannelNum(uint8_t ucTunerIndex,uint8_t ucTotalTunerNum)
{
    if (rtk_porting_tuner_setTunerChannelNum(ucTunerIndex,ucTotalTunerNum) != RTK_OK)
    {
        RTKHAL_ERR("[%s] tuner_index:%u set total channel num failed!!\n", __FUNCTION__, ucTunerIndex);
        return RTK_Fail;
    }
    return RTK_OK;
}

/**
   * @brief 
   * This function can be used to control LNB.
   *
   * @param[in]	   tunerid         tuner ID
   * @param[in]    eLNBMode        target LNB mode
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_SetLNBMode(uint32_t uiTunerID, enum RTK_LNB_MODE eLNBMode)
{
	if (rtk_porting_tuner_SetLNBMode(uiTunerID, (Rtk_LNB_MODE_e)eLNBMode) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u rtk_porting_tuner_SetLNBMode mode:%d failed!!\n", __FUNCTION__, uiTunerID, eLNBMode);
        return RTK_Fail;
	}
	return RTK_OK;
}

/**
   * @brief 
   * This function can be used to get current LNB status.
   *
   * @param[in]	   tunerid         tuner ID
   * @param[out]   ptLNBStatus     current LNB status
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_GetLNBStatus(uint32_t uiTunerID, RTK_LNB_STATUS_t* ptLNBStatus)
{
	if (rtk_porting_tuner_GetLNBStatus(uiTunerID, (Rtk_LNB_STATUS_t*)ptLNBStatus) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u GetLNBStatus failed!!\n", __FUNCTION__, uiTunerID);
        return RTK_Fail;
	}
	return RTK_OK;
}

/**
   * @brief 
   * This function can be used to send DiSEqC tone burst.
   *
   * @param[in]	   tunerid         tuner ID
   * @param[in]    eTone           tone burst type
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_SendDiSEqCToneBurst(uint32_t uiTunerID, enum RTK_TONE_BURST eTone)
{
	if (rtk_porting_tuner_SendDiSEqCToneBurst(uiTunerID, (Rtk_TONE_BURST_e)eTone) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u SendDiSEqCToneBurst ToneBurst:%u failed!!\n", __FUNCTION__, uiTunerID, eTone);
        return RTK_Fail;
	}
	return RTK_OK;
}

/**
   * @brief 
   * This function can be used to enable or disable 22KHz continues output.
   *
   * @param[in]	   tunerid         tuner ID
   * @param[in]    eEnable         enable or disable
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_Set22KContinues(uint32_t uiTunerID, RTK_Bool eEnable)
{
	if (rtk_porting_tuner_Set22KContinues(uiTunerID, eEnable) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u Set22KContinues eEnable:%u failed!!\n", __FUNCTION__, uiTunerID, eEnable);
        return RTK_Fail;
	}
	return RTK_OK;
}

/**
   * @brief 
   * This function can be used to send DiSEqC command.
   *
   * @param[in]	   tunerid         tuner ID
   * @param[in]    tCmdMsg         DiSEqC command message struct
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_SendDiSEqCCmd(uint32_t uiTunerID, RTK_DISEQC_MSG_t tCmdMsg)
{
	Rtk_DISEQC_MSG_t tMsgTemp;

	memcpy(tMsgTemp.ucMsgBuf, tCmdMsg.ucMsgBuf, tCmdMsg.ucMsgLen);
	tMsgTemp.ucMsgLen = tCmdMsg.ucMsgLen;
	if (rtk_porting_tuner_SendDiSEqCCmd(uiTunerID, tMsgTemp) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u SendDiSEqCCmd failed!!\n", __FUNCTION__, uiTunerID);
        return RTK_Fail;
	}
	return RTK_OK;
}

/**
   * @brief 
   * This function can be used to get DiSEqC reply message.
   *
   * @param[in]    tunerid         tuner ID
   * @param[in]    ptReplyMsg      DiSEqC replay message struct
   * @retval       RTK_OK          success.
   * @retval       RTK_Fail        fail.
   *
   */
RTK_Error RHAL_Base::Tuner_GetDiSEqCReply(uint32_t uiTunerID, RTK_DISEQC_MSG_t* ptReplyMsg)
{
	if (rtk_porting_tuner_GetDiSEqCReply(uiTunerID, (Rtk_DISEQC_MSG_t*)ptReplyMsg) != RTK_OK)
	{
		RTKHAL_ERR("[%s] tuner_id:%u GetDiSEqCReply failed!!\n", __FUNCTION__, uiTunerID);
		return RTK_Fail;
	}
	return RTK_OK;
}

RTK_Error RHAL_Base::CreateSurface(RTK_WinConfig win_cfg)
{
#if !defined(USE_RTKHAL_IN_ANDROID10)
	RTK_WIN_CONFIG win;   
	win.surface = (win_cfg.plane != RTK_WIN_PIP) ? RTK_SURFACE_V1:RTK_SURFACE_V2;   
	win.pos_x = win_cfg.pos_x;
	win.pos_y = win_cfg.pos_y;
	win.width = win_cfg.width;
	win.height = win_cfg.height;
	rtk_porting_create_winSurface(win);   
#endif
#if defined(USE_RTKHAL_IN_ANDROID10)
	pthread_mutex_lock(&surface_mutex);

	RTKHAL_INF("[%s]: start plane=%d \n", __FUNCTION__,win_cfg.plane);
	if(win_cfg.plane == RTK_WIN_PIP){
		const char *fifo_name_w_pip = "/dev/create_surface_lifecycle_wp";
		const char *fifo_name_r_pip = "/dev/create_surface_lifecycle_rp";
		char c_win_p[40]; 
	
		int fd_w_p = -1,fd_r_p = -1;
		int res_p = -1;
		char buf_p[PIPE_BUF-1] = {0};

		res_p = mkfifo(fifo_name_w_pip, 0666);
		if (res_p <0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_w_pip %s strerror =%s \n", __FUNCTION__,fifo_name_w_pip,strerror(errno));
		}
	
	
			res_p = mkfifo(fifo_name_r_pip, 0666);
		if (res_p < 0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_r_pip %s strerror = %s\n", __FUNCTION__,fifo_name_r_pip,strerror(errno));
		
		}
		
		RTKHAL_INF("[%s]: open start \n", __FUNCTION__);
	
		fd_w_p = open(fifo_name_w_pip, O_WRONLY);
	
		RTKHAL_INF("[%s]:fd_w_p = %d open end\n", __FUNCTION__, fd_w_p);
	
		sprintf(c_win_p, "create_p%d:%d:%d:%d",  win_cfg.pos_x, win_cfg.pos_y,win_cfg.width,win_cfg.height); 
		write(fd_w_p , c_win_p, sizeof(c_win_p));
		
		RTKHAL_INF("[%s]: open start  \n", __FUNCTION__);
		fd_r_p = open(fifo_name_r_pip, O_RDONLY);
		RTKHAL_INF("[%s]:fd_r_p = %d open end2\n", __FUNCTION__, fd_r_p);
		read(fd_r_p, buf_p, PIPE_BUF-1); 
		RTKHAL_INF("[%s]: end plane=%d \n", __FUNCTION__,win_cfg.plane);

	 }else{
		const char *fifo_name_w_main = "/dev/create_surface_lifecycle_wm";
		const char *fifo_name_r_main = "/dev/create_surface_lifecycle_rm";
		char c_win_m[40]; 
	
		int fd_w_m = -1,fd_r_m = -1;
		int res_m = -1;
		char buf_m[PIPE_BUF-1] = {0};

		res_m = mkfifo(fifo_name_w_main, 0666);
		if (res_m <0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_w_main %s strerror =%s \n", __FUNCTION__,fifo_name_w_main,strerror(errno));
		}
	
	
		res_m = mkfifo(fifo_name_r_main, 0666);
		if (res_m < 0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_r_main %s strerror = %s\n", __FUNCTION__,fifo_name_r_main,strerror(errno));
		}
		
		RTKHAL_INF("[%s]: open start \n", __FUNCTION__);
	
		fd_w_m = open(fifo_name_w_main, O_WRONLY);
	
		RTKHAL_INF("[%s]:fd_w_m = %d open end\n", __FUNCTION__, fd_w_m);
	
	
		sprintf(c_win_m, "create_m%d:%d:%d:%d",  win_cfg.pos_x, win_cfg.pos_y,win_cfg.width,win_cfg.height); 
		write(fd_w_m , c_win_m, sizeof(c_win_m));

		RTKHAL_INF("[%s]: open start  \n", __FUNCTION__);
		fd_r_m = open(fifo_name_r_main, O_RDONLY);
		RTKHAL_INF("[%s]:fd_r_m = %d open end2\n", __FUNCTION__, fd_r_m);
		read(fd_r_m, buf_m, PIPE_BUF-1); 
		RTKHAL_INF("[%s]: end plane=%d \n", __FUNCTION__,win_cfg.plane);
	}

	pthread_mutex_unlock(&surface_mutex);


#endif
	return RTK_OK;
}

RTK_Error RHAL_Base::DestorySurface(RTK_WinPlane plane)
{
#if !defined(USE_RTKHAL_IN_ANDROID10)
	RTK_WIN_SURFACE surface = (plane != RTK_WIN_PIP) ? RTK_SURFACE_V1:RTK_SURFACE_V2;   
	rtk_porting_destory_winSurface(surface); 
#endif	

#if defined(USE_RTKHAL_IN_ANDROID10)
	pthread_mutex_lock(&surface_mutex);

	RTKHAL_INF("[%s]: start plane=%d \n", __FUNCTION__,plane);
	if(plane == RTK_WIN_PIP){
		
		const char *fifo_name_w_pip = "/dev/create_surface_lifecycle_wp";
		const char *fifo_name_r_pip = "/dev/create_surface_lifecycle_rp";
		int fd_w_p = -1,fd_r_p = -1;
		int res_p = -1;
		char buf_p[PIPE_BUF-1] = {0};
		res_p = mkfifo(fifo_name_w_pip, 0666);
		if (res_p <0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_w_pip  %s error =%s\n", __FUNCTION__,fifo_name_w_pip,strerror(errno));
		
		}
		
		
		res_p = mkfifo(fifo_name_r_pip, 0666);
		if (res_p < 0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_r_pip %s error = %s\n", __FUNCTION__,fifo_name_r_pip,strerror(errno));
		
		}
		
		RTKHAL_INF("[%s]:fd  open start\n", __FUNCTION__);
		fd_w_p= open(fifo_name_w_pip, O_WRONLY);
		RTKHAL_INF("[%s]:open end fd_w_p = %d\n", __FUNCTION__, fd_w_p);
		write(fd_w_p , "delete_p", 8);
		RTKHAL_INF("[%s]: open start2 \n", __FUNCTION__);
		fd_r_p = open(fifo_name_r_pip, O_RDONLY);
		RTKHAL_INF("[%s]:fd_r = %d open end2\n", __FUNCTION__, fd_r_p);
		
		read(fd_r_p, buf_p, PIPE_BUF-1);
		
		RTKHAL_INF("[%s]: end plane=%d \n", __FUNCTION__,plane);


	}else{
		const char *fifo_name_w_main = "/dev/create_surface_lifecycle_wm";
		const char *fifo_name_r_main = "/dev/create_surface_lifecycle_rm";
		int fd_w_m = -1,fd_r_m = -1;
		int res_m = -1;
		char buf_m[PIPE_BUF-1] = {0};
		res_m = mkfifo(fifo_name_w_main, 0666);
		if (res_m <0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_w_main  %s error =%s\n", __FUNCTION__,fifo_name_w_main,strerror(errno));
		
		}
		
		
		res_m = mkfifo(fifo_name_r_main, 0666);
		if (res_m < 0 && errno!=EEXIST)
		{
			RTKHAL_ERR("[%s] Could not create fifo_name_r_main %s error = %s\n", __FUNCTION__,fifo_name_r_main,strerror(errno));
		}
		
		RTKHAL_INF("[%s]:fd  open start\n", __FUNCTION__);
		fd_w_m= open(fifo_name_w_main, O_WRONLY);
		RTKHAL_INF("[%s]:open end fd_w_m = %d\n", __FUNCTION__, fd_w_m);
		write(fd_w_m , "delete_m", 8);
		
		RTKHAL_INF("[%s]: open start2 \n", __FUNCTION__);
		fd_r_m = open(fifo_name_r_main, O_RDONLY);
		RTKHAL_INF("[%s]:fd_r_m = %d open end2\n", __FUNCTION__, fd_r_m);
		
		read(fd_r_m, buf_m, PIPE_BUF-1);
		
		RTKHAL_INF("[%s]: end plane=%d \n", __FUNCTION__,plane);

	}

	pthread_mutex_unlock(&surface_mutex);

#endif

	return RTK_OK;
}

/**
** @brief
** Start DVR record.
**
** @param[in]		player		 	handle of player
**
** @retval		RTK_OK			DVR successfully stared.
** @retval		RTK_Fail 			DVR start failed.
**
*/
RTK_Error RHAL_Base::Player_DVRStart(RTK_Player player)
{
	RTK_Error Ret = RTK_OK;
	HAL_HANDLE_S* hal_handle = (HAL_HANDLE_S*)player;
	if (hal_handle == NULL)
	{
		RTKHAL_ERR("[%s] demux is NULL!!\n", __func__);
		return RTK_Fail;
	}	
	pthread_mutex_lock(&hal_handle->mutex);	
	Ret = Record_Start(player);
	pthread_mutex_unlock(&hal_handle->mutex);
	return Ret;

}

/**
** @brief
** Stop DVR record.
**
** @param[in]		player		 	handle of player
**
** @retval		RTK_OK			DVR successfully stoped.
** @retval		RTK_Fail 			DVR stop failed.
**
*/
RTK_Error RHAL_Base::Player_DVRStop(RTK_Player player)
{
	RTK_Error Ret = RTK_OK;
	HAL_HANDLE_S* hal_handle = (HAL_HANDLE_S*)player;
	if (hal_handle == NULL)
	{
		RTKHAL_ERR("[%s] player is NULL!!\n", __func__);
		return RTK_Fail;
	}	
	pthread_mutex_lock(&hal_handle->mutex);
	Ret = Record_Stop(player);
	pthread_mutex_unlock(&hal_handle->mutex);
	return Ret;
}

/**
   * @brief
   * Set SPDIF output mode.
   *
   * @param[in]		outputMode             SPDIF output mode
   *
   * @retval		RTK_OK			Set success.
   * @retval		RTK_Fail 			Set failed.
   *
   */
RTK_Error RHAL_Base::System_Set_Spdif_Output_Mode(Hal_Spdif_Mode_e outputMode)
{
	Rtk_Spdif_Mode_e e_mode=RTK_SPDIF_OFF;
	switch(outputMode){
		case HAL_SPDIF_OFF:
			e_mode=RTK_SPDIF_OFF;
			break;
		case HAL_SPDIF_RAW:
			e_mode=RTK_SPDIF_RAW;
			break;
		case HAL_SPDIF_LPCM:
			e_mode=RTK_SPDIF_LPCM;
			break;
	}
	rtk_porting_audio_setSPDIFOutputMode(e_mode);
	return RTK_OK;
}

/**
   * @brief
   * Get SPDIF output mode.
   *
   * @param[out]	outputMode             a pointer for getting SPDIF output mode
   *
   * @retval		RTK_OK			Set success.
   * @retval		RTK_Fail 			Set failed.
   *
   */
RTK_Error RHAL_Base::System_Get_Spdif_Output_Mode(Hal_Spdif_Mode_e *outputMode)
{
	rtk_porting_audio_getSPDIFOutputMode((Rtk_Spdif_Mode_e*)outputMode);
	return RTK_OK;
}

/**
   * @brief
   * Set HDMI output mode.
   *
   * @param[in]		outputMode             HDMI output mode
   *
   * @retval		RTK_OK			Set success.
   * @retval		RTK_Fail 			Set failed.
   *
   */
RTK_Error RHAL_Base::System_Set_Hdmi_Output_Mode(Hal_Hdmi_Mode_e outputMode)
{
	Rtk_HDMI_Mode_e  e_mode=RTK_HDMI_LPCM;
	switch(outputMode){
		case HAL_HDMI_RAW:
			e_mode=RTK_HDMI_RAW;
			break;
		case HAL_HDMI_LPCM:
			e_mode=RTK_HDMI_LPCM;
			break;
		case HAL_HDMI_LPCM_MULTI_CH:
			e_mode=RTK_HDMI_LPCM_MULTI_CH;
			break;
		case HAL_HDMI_AUTO:
			e_mode=RTK_HDMI_AUTO;
			break;				
	}
	rtk_porting_audio_setHDMIOutputMode(e_mode);
	return RTK_OK;
}


/**
   * @brief
   * Get HDMI output mode.
   *
   * @param[in]		outputMode             a pointer for getting HDMI output mode
   *
   * @retval		RTK_OK			Set success.
   * @retval		RTK_Fail 			Set failed.
   *
   */
RTK_Error RHAL_Base::System_Get_Hdmi_Output_Mode(Hal_Hdmi_Mode_e *outputMode)
{
	rtk_porting_audio_getHDMIOutputMode((Rtk_HDMI_Mode_e*)outputMode);
	return RTK_OK;
}

/**
   * @brief
   * Set Audio output mode.
   *
   * @param[in]		ch_output_mode       audio output mode
   *
   * @retval		RTK_OK			Set success.
   * @retval		RTK_Fail 			Set failed.
   *
   */
RTK_Error RHAL_Base::System_SetAudioOutputMode(Hal_Audio_Output_Mode_e ch_output_mode)
{
	Rtk_Audio_Output_Mode_e rtk_ch_mode=RTK_AUDIO_STEREO;
	switch(ch_output_mode){
		case HAL_AUDIO_STEREO:
			rtk_ch_mode=RTK_AUDIO_STEREO;
			break;
		case HAL_AUDIO_MAIN_BILINGUAL:
			rtk_ch_mode=RTK_AUDIO_MAIN_BILINGUAL;
			break;
		case HAL_AUDIO_SUB_BILINGUAL:
			rtk_ch_mode=RTK_AUDIO_SUB_BILINGUAL;
			break;
		case HAL_AUDIO_FLASH_STEREO:
			rtk_ch_mode=RTK_AUDIO_FLASH_STEREO;
			break;
		case HAL_AUDIO_FLASH_MAIN_BILINGUAL:
			rtk_ch_mode=RTK_AUDIO_FLASH_MAIN_BILINGUAL;
			break;
		case HAL_AUDIO_FLASH_SUB_BILINGUAL:
			rtk_ch_mode=RTK_AUDIO_FLASH_SUB_BILINGUAL;
			break;
	}
	if(rtk_porting_audio_setAudioOutputMode(rtk_ch_mode)!=RTK_OK)
		return RTK_Fail;
	else
		return RTK_OK;
}	   

RTK_Error RHAL_Base::Player_AddPESFilter(RTK_Player player , RTK_PESFilterPattern * pattern)
{
	RTK_Error ret;
	ret = _xAddPESFilter(player, pattern);
	return ret;
}

RTK_Error RHAL_Base::Player_RemovePESFilter(RTK_Player player,UINT8_T u8FilterID)
{
	RTK_Error ret;
	ret = _xRemovePESFilter(player,u8FilterID);
	return ret;
}


RTK_Error RHAL_Base::Player_SetSubtitle(RTK_Player player, RTK_SubtitleConfig ptrSubtitleTrackInfo)
{
	INT8_T ret ;
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}   
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	if(hal_handle->m_subtitle.pid != TS_INVALID_PID)
	{
		RTKHAL_ERR("%s,%d,pid = %d ,subtitle was setted already\n",__func__,__LINE__,hal_handle->m_subtitle.pid);
		return RTK_Fail;
	}

	Rtk_Subtitle_Info_t  tsSubtitleTrackInfo;
	tsSubtitleTrackInfo.bshow=  ptrSubtitleTrackInfo.bshow;
	tsSubtitleTrackInfo.idx= ptrSubtitleTrackInfo.idx;
	tsSubtitleTrackInfo.langcode=ptrSubtitleTrackInfo.langcode;
	tsSubtitleTrackInfo.pid= ptrSubtitleTrackInfo.pid;
	tsSubtitleTrackInfo.subtype=(RTK_AP_SUBTITLE_TYPE_e)ptrSubtitleTrackInfo.subtype;
	memcpy(&hal_handle->m_subtitle,&tsSubtitleTrackInfo,sizeof(Rtk_Subtitle_Info_t));
	ret=rtk_porting_av_SetSubtitle( hal_handle->av_handle,tsSubtitleTrackInfo);

	if(ret == RTK_OK)
	return RTK_OK;

	return RTK_Fail;
}

RTK_Error RHAL_Base::Player_RemoveSubtitle(RTK_Player player)
{
	INT8_T ret ;
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(hal_handle->m_subtitle.pid == TS_INVALID_PID)
	{
		RTKHAL_ERR("[%s] no subtitle to remove\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	ret=rtk_porting_av_RemoveSubtitle(hal_handle->av_handle,hal_handle->m_subtitle.pid,hal_handle->m_subtitle.subtype);
	memset(&hal_handle->m_subtitle,0,sizeof(Rtk_Subtitle_Info_t));
	hal_handle->m_subtitle.pid = TS_INVALID_PID;
	
	if(ret == RTK_OK)
		return RTK_OK;
	
	return RTK_Fail;
}


RTK_Error RHAL_Base::Player_SetErrorConcealLevel(RTK_Player player, uint32_t level, int32_t delayTime)
{
    if(player == NULL)
    {
        RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
        return RTK_Fail;
    }

    RTKHAL_INF("[%s]:%p, level:%d, delayTime:%d\n", __FUNCTION__, player, level, delayTime);

    uint32_t frmCnt = 5;

   HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

    if(RTK_OK != rtk_porting_av_set_error_conceal_level(hal_handle->av_handle, level, frmCnt, delayTime))
        return RTK_Fail;

    return RTK_OK;
}

RTK_Error RHAL_Base::Player_SetShowMode_OnVideoChanged(RTK_Player player, RTK_VideoShowMode_OnChanged_e mode)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	RTK_AV_SHOW_MODE_e xMode=RTK_SHOW_NONE;

	if(mode==RTK_VO_AUTOSHOW_INACTIVE)
	{
		xMode=RTK_SHOW_NONE;
	}
	else if(mode==RTK_VOBLACK_AND_AUTOSHOW_AF_DECODED)
	{
		xMode=RTK_SHOW_BLACK;
	}
	else if(mode==RTK_VOFRAME_AND_AUTOSHOW_AF_DECODED)
	{
		xMode=RTK_SHOW_LASTFRAME;
	}
	else if(mode==RTK_VOSHOW_AF_DECODED_IFRAME)
	{
		xMode=RTK_SHOW_AF_DECODE_IFRAME;
	}

	if(RTK_OK != rtk_porting_av_setShowMode_onVideoChanged(hal_handle->av_handle, xMode))
		return RTK_Fail;

	return RTK_OK;
}


#if 0
RTK_Error RHAL_Base::Player_SetSlowAvSync(RTK_Player player, RTK_Bool enable)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]:%p enable=%d\n", __FUNCTION__, player, enable);

    HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(RTK_OK !=rtk_porting_av_enableSlowAvSync(hal_handle->av_handle, enable))	
	{
		return RTK_Fail;
	}
	return RTK_OK;

}
#endif

 RTK_Error RHAL_Base::Player_GetScrambleStatus(RTK_Player player, RTK_Bool* isScramble)
 {
 	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	
       HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	RTK_BOOL isScrambleBOOL = RTK_FALSE;

	rtk_porting_av_get_scrambleStatus(hal_handle->av_handle, &isScrambleBOOL);
	
	if( RTK_TRUE ==isScrambleBOOL )
		*isScramble = RTK_TRUE;
	else
		*isScramble = RTK_FALSE;
	
	RTKHAL_INF("[%s]:%p isScramble=%d\n", __FUNCTION__, player, *isScramble);
	return RTK_OK;
 }
RTK_Error RHAL_Base::DvbResourceConfig(RTK_DvbResourceConfig_t *pConfig)
{
	if((pConfig->demux_usenum+pConfig->playerWithTP_usenum)>HWTP_MAX_NUM)
	{
		return RTK_Fail;
	}

	/*m_dtvflow_num=pConfig->demux_usenum+pConfig->playerWithTP_usenum+
		pConfig->player_usenum+pConfig->esplayer_usenum;*/
	//always let m_dtvflow_num is the max dtvflow numbers.
	
	if(m_dtvflow_num> RTK_MAX_DTVFLOW_NO)
	{
		return RTK_Fail;	
	}

	m_dvbResourceConfig=*pConfig;
	return RTK_OK;
}

/**
* @brief
* Set Secure Meida Path enable or disable.
*
* @param[in]	channel_id	     DVB channel id, it normally mean the decoder id.
* @param[in]	enable	     	 when enable is RTK_TRUE, it mean SMP enabled.
*
* 
* @retval		RTK_OK	     success.            
* @retval		RTK_Fail 	 failed.   
*
*/
RTK_Error RHAL_Base::DvbSetSMP(uint32_t channel_id, RTK_Bool enable)
{
	if(rtk_porting_av_setSMP(channel_id, (RTK_BOOL)(enable))!=RTK_ERR)
	{
		return RTK_OK;
	}
	else
		return RTK_Fail;
		
}

/**
* @brief
* Get Secure Meida Path enable or disable.
*
* @param[in]	channel_id	  DVB channel id, it normally mean the decoder id.
* 
* @retval		RTK_TRUE	  SMP is enabled.            
* @retval		RTK_FALSE 	 SMP is disabled.   
*
*/
RTK_Bool RHAL_Base::DvbGetSMP(uint32_t channel_id)
{
	RTK_BOOL b=rtk_porting_av_getSMP(channel_id);
	
	return b?RTK_TRUE:RTK_FALSE;
}

/**
** @brief
** enable ccDecoder in order to create cc thread in unittest to get ccdata and deal cc data through player callback
**
** @param[in]		player		 	handle of player to deal with
**
** @retval		RTK_OK			enable transporting cc data  to player callback  successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/

RTK_Error RHAL_Base::Player_EnableCCDecoder(RTK_Player player)
{		
	HAL_HANDLE_S *hal_handle;
	INT8_T ret = RTK_OK;
	RTKHAL_INF("[%s] Player_EnableCCDecoder......\n", __FUNCTION__);
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	hal_handle = (HAL_HANDLE_S*)player;
	UINT32_T av_handle = hal_handle->av_handle;
	
	hal_handle ->stop_cc_thread = RTK_FALSE;
	
	ret = rtk_porting_enable_CCDecoder(av_handle, true);
	if(ret == RTK_ERR)
	{
		RTKHAL_ERR("enable CC Decoder error......\n");
		return RTK_Fail;
	}       
	RHAL_ThreadParam_t *pThreadParam=(RHAL_ThreadParam_t*)malloc(sizeof(RHAL_ThreadParam_t));
	pThreadParam->halHandle=hal_handle;
	pThreadParam->instance=this;
	ret = pthread_create(&(hal_handle->cc_recvdata_thread), NULL, mThreadCCEnableEntry, pThreadParam);
	if(ret != 0)
	{
		RTKHAL_ERR("create CC thread error......\n");
		return RTK_Fail;
	}
	return (RTK_Error)ret;
}
/**
** @brief
** get cc data 
**
** @param[in]		player		 	handle of player to deal with
**
** @retval		RTK_OK			disable  transporting cc data successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/
RTK_Error RHAL_Base::Player_GetCCData(RTK_Player player,unsigned char** pCCData,unsigned int* pLen)
{
	*pLen = 0;
	if(player == NULL){
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	if(!hal_handle->m_bGetCCdata){
		hal_handle->m_bGetCCdata = true;
	}

	if(hal_handle->cc_recvdata_thread == 0){
		if(RTK_OK != Player_EnableCCDecoder(player)){
			RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
			return RTK_Fail;
		}
	}
	
	if(readCCData(hal_handle,pCCData,pLen)){
		return RTK_OK;
	}

	return RTK_Fail;
}
/**
** @brief
** disable ccDecoder in order to destroy cc thread , notice DvdPlayer to stop read and transport ccdata out.
**
** @param[in]		player		 	handle of player to deal with
**
** @retval		RTK_OK			disable  transporting cc data successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/
RTK_Error RHAL_Base::Player_DisableCCDecoder(RTK_Player player)
{
	
	HAL_HANDLE_S *hal_handle;
	int32_t status, rc;
	INT8_T ret = RTK_OK;
	RTKHAL_INF("[%s] Player_DisableCCDecoder......\n", __FUNCTION__);
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	hal_handle = (HAL_HANDLE_S*)player;
	UINT32_T av_handle = hal_handle->av_handle;
	hal_handle ->stop_cc_thread = RTK_TRUE;
	hal_handle->m_bGetCCdata = false;

	ret = rtk_porting_enable_CCDecoder(av_handle, false);
	if(ret == RTK_ERR)
	{
		RTKHAL_ERR("disable CC Decoder error......\n");
		return RTK_Fail;
	}       
	if(hal_handle->cc_recvdata_thread != 0)
	{
		rc = pthread_join(hal_handle->cc_recvdata_thread, (void **)&status);
		if (rc != 0)
		{
			RTKHAL_ERR("ERROR; return code from cc_recvdata_thread pthread_join() is %d\n", rc);
			return RTK_Fail;
		}
		else
		{
			hal_handle->cc_recvdata_thread = 0;
			RTKHAL_INF("cc_recvdata_thread Thread joined\n");
		}
	}
			
	return (RTK_Error)ret;
}

/**
** @brief
** This function control ccdata whether to show with special channel number.
** When bEnable is true, it will create playback cc thread, false will disable playback cc thread.
** Playback cc thread will check the index and whether ccdata is changed to decide show or not.
** If bEnable is true and index is correct, playback cc thread will be created and the cc can be shown. 
** If bEnable is true and index is error, playback cc thread will be created and the cc cann't be shown. 
** If bEnable is false,playback cc thread will be destroyed and the cc cann't be shown,whether index is correct.
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		bEnable		 	true to enable show,false to disable show
** @param[in]		index		 	begin with 0, lower than ccStreamNum
**
** @retval		RTK_OK			to set cc show status successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/
RTK_Error RHAL_Base::Player_SetCCPlayback(RTK_Player player,bool bEnable,int index)
{
	INT8_T ret = RTK_OK;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	ret = rtk_porting_av_SetCCPlayback(hal_handle->av_handle,bEnable,index);
	if(ret ==RTK_OK)
	{
		RTKHAL_INF("set cc playback ok\n");
		return RTK_OK;
	}
	else
	{
		RTKHAL_ERR("ERROR; set cc playback fail\n");
		return RTK_Fail;	
	}
}
/**
** @brief
** This function to get cc information,such as stream number,ccType index and ccType String.
** Here eight cc streams are supported,you can get how many cc stream in the video with this function.
** This functio can tell you whether there are ccdata according to info->ccStreamNum.
** If info->ccStreamNum is 0,there is no cc data.
** If info->ccStreamNum is larger than 0,you can use Player_SetCCPlayback to show it.
** you can get ccType string from  info->ccTypeString[i],i is from 0 to ccStreamNum-1
**
** @param[in]		player		handle of player to deal with
** @param[out]		info		 	pointer to struct RTK_ClosedCaption_Param with cc information
**
** @retval		RTK_OK			get cc information successfully.
** @retval		RTK_Fail 			get cc information fail
**
*/
RTK_Error RHAL_Base::Player_GetCCInfo(RTK_Player player,RTK_ClosedCaption_Param_t* info)
{
	INT8_T ret = RTK_OK;
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	RtkClosedCaption_Param_t *minfo =(RtkClosedCaption_Param_t*)info;
	ret = rtk_porting_av_GetCCInfo(hal_handle->av_handle,minfo);
	if(ret ==RTK_OK)
	{
		RTKHAL_INF("get cc information ok\n");
		return RTK_OK;
	}
	else
	{
		RTKHAL_ERR("ERROR; get cc information fail\n");
		return RTK_Fail;	
	}
}

/**
* @brief
*  Get TP buffer status.
*
* @param[in]		player		 	handle of player 
* @param[out]		pFreeSize 		buffer free size.
* @param[out]		pDataSize 		the size of data in buffer.
*
* @retval		RTK_OK				successfully processed
* @retval		RTK_Fail 			fail.
*
*/
RTK_Error RHAL_Base::Player_GetTPBufferStatus(RTK_Player player, uint32_t* pFreeSize, uint32_t *pDataSize)
{
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	if(hal_handle==NULL || pFreeSize==NULL)
	{
		RTKHAL_ERR("invalid paramter\n");
		return RTK_Fail;
	}

	if(hal_handle->connect_source==NULL)
	{
		*pFreeSize=0;
		if(pDataSize)
			*pDataSize=0; //TODO, now not support.
			
		RTKHAL_ERR("connect source is NULL!!!\n");
		return RTK_Fail;
	}
	
	if(RTK_OK != rtk_porting_source_getTPBufFreeSize(hal_handle->connect_source, pFreeSize))
	{
		RTKHAL_ERR("[%s]rtk_porting_source_getTPBufFreeSize failed\n", __FUNCTION__);
		return RTK_Fail;
	}

	if(pDataSize)
		*pDataSize=0; //TODO, now not support.

	return RTK_OK;
}


/**
* @brief
*  Feed DMA buffer into player.
*
* @param[in]		player		 	handle of player 
* @param[in]		phyaddr 		DMA buffer physical address.
* @param[in]		size 			feed size.
* @param[in]		timeout 		wait timeout(millisecond)	
* @param[in]		is_last 		imply EOS
*
* @retval		RTK_OK				successfully processed
* @retval		RTK_Fail 			fail or timeout.
*
*/
RTK_Error RHAL_Base::Player_FeedDMABuffer(RTK_Player player, uint32_t phyaddr, uint32_t size, uint32_t timeout, bool isLast)
{
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

#ifdef CLIENT_DTVSOURCE
	RTK_Error ret = RTK_Fail;
	
	if((size > 0) || isLast)
	{
		int64_t time0,time1;;
		struct timeval tv;

		gettimeofday(&tv, NULL);
		time0 = (int64_t)tv.tv_sec*1000+tv.tv_usec/1000;

		while(1)
		{
			if( RTK_OK != rtk_porting_source_feed(hal_handle->connect_source, phyaddr, size, isLast,false))
			{
				gettimeofday(&tv, NULL);
				time1 = (int64_t)tv.tv_sec*1000+tv.tv_usec/1000;
				if (time1 - time0 > timeout)
				{
					ret = RTK_Fail;
					break;
				}
				usleep(10000);	//wait 10ms
				continue;
			}
			ret = RTK_OK;
			break;
		}
	}

	if (ret == RTK_Fail)
	{
		RTKHAL_ERR("RHAL_Base::%s() size=%d failed\n", __FUNCTION__,size);
	}
	
	return ret;
#else
	UNUSED(isLast);
	
	if(rtk_porting_MTPFeedData((UINT8_T)(hal_handle->channel), phyaddr, size, timeout)!=RTK_OK)
	{
		return RTK_Fail;

	}
#endif

	return RTK_OK;
}

// 
/**
* @brief
* Set frequency for multi channel-tuner.
*
* @param[in]		tunerid		       tuner id
* @param[out]		MultiCH_param      multich tuner paramters.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/
RTK_Error RHAL_Base::Tuner_Multich_SetFreq(int tunerid, RTKMultiCH_Param_t MultiCH_param)
{
	//	RTK_Error ret;
	
	Rtk_MultiCH_Param_t MultiCHparam;
	Rtk_Tuner_Param_t tuner_param;
	
	RTKHAL_INF("DVBC rtk_porting_tuner_Multiscanning rtk_porting_tuner_Multiscanning\n");
	tuner_param.bandwidth = Rtk_TUNER_BANDWIDTH_8M;
	switch(MultiCH_param.tunerType)
	{
		case RTK_TUNER_TYPE_DVBC:
			tuner_param.type=RTK_TUNER_TYPE_DVB_C;
			tuner_param.tnr_param.dvb_c_param.annex_type = RTK_ANNEX_A;
			break;
		case RTK_TUNER_TYPE_ABS:
			tuner_param.type=RTK_TUNER_TYPE_ABS_S;
			break;
		case RTK_TUNER_TYPE_DTMB:
			tuner_param.type=RTK_TUNER_TYPE_DTMB_T;
			break;
		case RTK_TUNER_TYPE_DVB_T:
			tuner_param.type=RTK_TUNER_TYPE_DVBT;
			break;
		case RTK_TUNER_TYPE_DVB_S:
			tuner_param.type=RTK_TUNER_TYPE_DVBS;
			break;
		case RTK_TUNER_TYPE_DVB_S2:
			tuner_param.type=RTK_TUNER_TYPE_DVBS2;
			break;
		default:
			tuner_param.type=RTK_TUNER_TYPE_DVB_C;
			break;
	}
	
	MultiCHparam.Channel_count = MultiCH_param.Channel_count;
	for(int i =0; i < MultiCH_param.Channel_count ;i++)
	{
		MultiCHparam.MultiCH[i].program_id = MultiCH_param.MultiCH[i].program_id;
		MultiCHparam.MultiCH[i].freq = MultiCH_param.MultiCH[i].freq ;
		MultiCHparam.MultiCH[i].vedio_pid = MultiCH_param.MultiCH[i].vedio_pid;
		MultiCHparam.MultiCH[i].audio_pid = MultiCH_param.MultiCH[i].audio_pid;

		
		switch (MultiCH_param.MultiCH[i].qam)
		{
			case 16:
				MultiCHparam.MultiCH[i].dvbc_qam =RTK_CABLETNR_QAM_16;
				break;
			case 32:
				MultiCHparam.MultiCH[i].dvbc_qam =RTK_CABLETNR_QAM_32;
				break;
			case 64:				  
				MultiCHparam.MultiCH[i].dvbc_qam =RTK_CABLETNR_QAM_64;
				break;
			case 128:
				MultiCHparam.MultiCH[i].dvbc_qam=RTK_CABLETNR_QAM_128;
				break;
			case 256:
				MultiCHparam.MultiCH[i].dvbc_qam =RTK_CABLETNR_QAM_256;
				break;
			default:
				MultiCHparam.MultiCH[i].dvbc_qam=RTK_CABLETNR_QAM_256;
				break;
		}
		
		switch (MultiCH_param.MultiCH[i].lnb_mode)
		{
			case 0xff:				
				MultiCHparam.MultiCH[i].dvbs_lnbmode=RTK_LNB_MODE_OFF;
				break;
			case 0:
				MultiCHparam.MultiCH[i].dvbs_lnbmode=RTK_LNB_MODE_OFF;
				break;
			case 13:
				MultiCHparam.MultiCH[i].dvbs_lnbmode =RTK_LNB_MODE_13V;
				break;
			case 18:				  
				MultiCHparam.MultiCH[i].dvbs_lnbmode =RTK_LNB_MODE_18V;
				break;
			case 1322:
				MultiCHparam.MultiCH[i].dvbs_lnbmode=RTK_LNB_MODE_13V_WITH_22K_BURST;
				break;
			case 1822:
				MultiCHparam.MultiCH[i].dvbs_lnbmode =RTK_LNB_MODE_18V_WITH_22K_BURST;
				break;
			default:
				MultiCHparam.MultiCH[i].dvbs_lnbmode=RTK_LNB_MODE_OFF;
				break;

		}
		
		MultiCHparam.MultiCH[i].symbol_rate = MultiCH_param.MultiCH[i].symbol_rate;
			  
		//RTKHAL_INF("id %d freq %d vpid %d  apid %d \n",MultiCHparam.MultiCH[i].program_id,MultiCHparam.MultiCH[i].freq,MultiCHparam.MultiCH[i].vedio_pid,MultiCHparam.MultiCH[i].audio_pid);
		//RTKHAL_INF("id %d QAM %d LNB %d \n",MultiCHparam.MultiCH[i].program_id,MultiCHparam.MultiCH[i].dvbc_qam,MultiCHparam.MultiCH[i].dvbs_lnbmode);
		//RTKHAL_INF("id %d freq %d vpid %d  apid %d \n",MultiCHparam.MultiCH[i].program_id,MultiCHparam.MultiCH[i].freq,MultiCHparam.MultiCH[i].vedio_pid,MultiCHparam.MultiCH[i].audio_pid);
	}

	
	rtk_porting_tuner_Multiscanning(tunerid, tuner_param, MultiCHparam);

#if 0
	usleep(100*1000);
	Rtk_Tuner_State_e tnr_state;
	for(int i=0;i< 6;i++)
	{
		rtk_porting_tuner_get_Multistate(tunerid,i, &tnr_state);
		RTKHAL_INF("DVBC  tnr_state  tnr_state tnr_state %d\n",tnr_state);
	}
#endif
	return RTK_OK;	
}


/**
* @brief
* Get tuner signal info in multi channel mode. For FCC V2
*
* @param[in]		tunerid			tuner ID
* @param[in]		ucProgID		program ID
* @param[out]		pInfo			result tuner info
*
* @retval		RTK_OK			
* @retval		RTK_Fail		
*
*/
RTK_Error RHAL_Base::Tuner_Multich_GetSignalInfo(int tunerid, unsigned char ucProgID, RTK_TunerInfo * pInfo)
{
	if(pInfo == NULL)
	{
		RTKHAL_ERR("[%s]info parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}

	if(tunerid != 0)
	{
		RTKHAL_ERR("[%s]this platform have one tuner(#0), requested (%u)\n", __FUNCTION__, tunerid);
		return RTK_Fail;
	}
	
    Rtk_Tuner_State_e eState = RTK_TUNER_STATE_UNKNOWN;      
    Rtk_Signal_ALLInfo_t tSignalInfo;	
	memset(&tSignalInfo, 0x00, sizeof(Rtk_Signal_ALLInfo_t));
	
	RTKHAL_INF("[%s] rtk_porting_tuner_get_Multistate \r\n", __FUNCTION__);
    if(RTK_OK != rtk_porting_tuner_get_Multistate(tunerid, ucProgID, &eState))
    {
		RTKHAL_ERR("[%s] rtk_porting_tuner_get_Multistate fail!!\r\n", __FUNCTION__);
		return RTK_Fail;
    }
    RTKHAL_INF("tuner number(%u), program ID(%u) tuner state(%d)\n", tunerid, ucProgID, eState);
    
    if(RTK_OK != rtk_porting_tuner_multich_get_signal_info(tunerid, ucProgID, &tSignalInfo))
    {
		return RTK_Fail;
	}

    /*
    * return tuner data.
    */
    pInfo->number = tunerid;
    pInfo->locked = (eState == RTK_TUNER_STATE_LOCKED) ? RTK_TRUE : RTK_FALSE;

    pInfo->strength = tSignalInfo.u32signal_strength;
    pInfo->quality = tSignalInfo.u32signal_quality;
    pInfo->snr = tSignalInfo.signal_snr;
    pInfo->ber = tSignalInfo.signal_ber;
	pInfo->lber = tSignalInfo.signal_lber;
    pInfo->agc = 0xFF;  
	if(tSignalInfo.powerlevel != 0xff)
	  {
	  //	  info->powerLevel = signal.powerlevel*DBSWITCHTODBM+DBMSWITCHTODBMV;
		  pInfo->powerLevel = tSignalInfo.powerlevel;
	  }	
	  else
		  pInfo->powerLevel = 0XFF;
    
    pInfo->packetError = tSignalInfo.signal_per;
    pInfo->mer = 10 * log10(1 - tSignalInfo.signal_per);       
       
	return RTK_OK;
}

/**
* @brief
* Set PID filters for multich tp, this function only for FCC. 
*
* @param[in]		player		       tuner id
* @param[in]		MultiCHPID_param   the PID parameters to set into multich tp.
* @param[in]		channel_count      indicate the count of multi channel PID parameter.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/
RTK_Error RHAL_Base::Player_SetMultiPIDFilters(
	RTK_Player player, 
	RTKMultich_Pids_t* MultiCHPID_param, 
	int channel_count)
{
	Rtk_Multich_Pids_t   *MultiCHPIDparam=NULL;
	if(NULL== player )
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	MultiCHPIDparam  = (Rtk_Multich_Pids_t * )malloc(channel_count * sizeof(Rtk_Multich_Pids_t));
	for(int i = 0;i<channel_count;i++ )
	{
		MultiCHPIDparam[i].prog_id =  MultiCHPID_param[i].prog_id;
		MultiCHPIDparam[i].pid_num = MultiCHPID_param[i].pid_num ;
		MultiCHPIDparam[i].pid[0]= MultiCHPID_param[i].pid[0];
		MultiCHPIDparam[i].pid[1] = MultiCHPID_param[i].pid[1];
		MultiCHPIDparam[i].codec[0]= MultiCHPID_param[i].codec[0];
		MultiCHPIDparam[i].codec[1]= MultiCHPID_param[i].codec[1];
		//printf("\n prog_id %d pid %d %d codec %d %d \n",MulitCHPIDparam[i].prog_id,MulitCHPIDparam[i].pid[0],MulitCHPIDparam[i].pid[1],MulitCHPIDparam[i].codec[0],	MulitCHPIDparam[i].codec[1]);
	}

	RTKHAL_INF("DVBC rtk_porting_av_set_multich_pids rtk_porting_av_set_multich_pids\n");
	rtk_porting_av_set_multich_pids(hal_handle->av_handle, MultiCHPIDparam, channel_count);

	if(MultiCHPIDparam)
		free(MultiCHPIDparam);
	
	return RTK_OK;	
}


RTK_Error RHAL_Base::Player_EnableKeepLastFrameForChangeChannel(RTK_Player player, RTK_Bool enable)
{
    RTK_Error ret;
    if(NULL== player )
    {
        RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
        return RTK_Fail;
    }
    HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
    RTK_BOOL __enable = (enable == RTK_TRUE ?1:0);
    if(rtk_porting_av_enableKeepLastFrameForChangeChannel(hal_handle->av_handle, __enable)!=0)
        ret=RTK_Fail;
    else
        ret=RTK_OK;
    return ret;
}

/**
* @brief
* Fast change video and audio, this function only for FCC. 
*
* @param[in]		player		player handle
* @param[in]		pVideo   	a pointer of video config.
* @param[in]		pAudio      a pointer of audio config.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/
RTK_Error RHAL_Base::Player_ChangeChannel(RTK_Player player, RTK_VideoConfig *pVideo, RTK_AudioConfig *pAudio)
{
	RTK_Error ret;
	if(NULL== player || NULL==pVideo || NULL==pAudio)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	Rtk_ChannelChange_Pids_t * p_changeCh_pids=(Rtk_ChannelChange_Pids_t *)malloc(sizeof (Rtk_ChannelChange_Pids_t));

	if(p_changeCh_pids==NULL)
	{
		RTKHAL_ERR("[%s]p_changeCh_pids malloc fail\n", __FUNCTION__);
		return RTK_Fail;
	}
	
	p_changeCh_pids->pid_num = 2;
	p_changeCh_pids->pid[0] = pVideo->pid;
	p_changeCh_pids->codec[0] = RHAL_Transfer_Video_Codec(pVideo->codec);
	p_changeCh_pids->pidType[0] = RTK_PID_TYPE_VIDEO;		
	RTKHAL_INF("video codec=%d\n", p_changeCh_pids->codec[0]);

	p_changeCh_pids->pid[1] = pAudio->pid;
	p_changeCh_pids->codec[1] = RHAL_Transfer_Audio_Codec(pAudio->codec);
	p_changeCh_pids->pidType[1] = RTK_PID_TYPE_AUDIO;
	RTKHAL_INF("audio codec=%d\n", p_changeCh_pids->codec[1]);

	RTKHAL_INF("sizeof Rtk_ChannelChange_Pids_t =%d\n", sizeof (Rtk_ChannelChange_Pids_t));
	
	if(rtk_porting_av_changeChannel(hal_handle->av_handle, p_changeCh_pids)!=0)
		ret=RTK_Fail;
	else
	{
		ret=RTK_OK;
		hal_handle->player_config.video = *pVideo;
		hal_handle->player_config.audio = *pAudio;
	}

	free(p_changeCh_pids);

	return ret;
}

/**
** @brief
** changes multi-channel's program(source)
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		program_id 	 	program id
**
** @retval		RTK_OK				change program id successfully.
** @retval		RTK_Fail 			parameters error such as player or audio equals NULL
**
*/
RTK_Error RHAL_Base::Player_ChangeProgram(RTK_Player player, UINT8_T program_id)
{
	RTK_Error ret = RTK_Fail;
	if(NULL== player)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	// TODO: check if support multi program and program id is correct

	rtk_porting_av_SetMultiChProgram(hal_handle->av_handle,program_id);
	return ret;
}

RTK_Error RHAL_Base::Player_SetSource(RTK_Player player, RTK_Source source)
{
#ifdef CLIENT_DTVSOURCE
	if(NULL == player)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	if(RTK_OK != rtk_porting_av_SetSource(hal_handle->av_handle , (void*)source))
	{
		RTKHAL_ERR("[%s]rtk_porting_av_SetSource %p faild\n", __FUNCTION__, source);
		return RTK_Fail;
	}
	if(_xGet_DmxHandle(hal_handle))
	{
		if (RTK_OK != rtk_porting_SectionFilterSetSource(_xGet_DmxHandle(hal_handle), source))
		{
			RTKHAL_ERR("[%s]rtk_porting_SectionFilterSetSource %p faild\n", __FUNCTION__, source);
			return RTK_Fail;
		}
	}
	hal_handle->connect_source = (Source_Handle)source;

	return RTK_OK;
#endif
	(void)player;//fix warning
	(void)source;//fix warning
	return RTK_Fail;
}

RTK_Error RHAL_Base::Source_SetRecKey(RTK_Source source, const char* pRecKey, unsigned int length)
{
	if(source == NULL)
	{
		RTKHAL_ERR("[%s]source parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(RTK_OK != rtk_porting_source_setRecKey(source,pRecKey,length))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}

RTK_Error RHAL_Base::Player_GetPacketDemuxInfo(RTK_Player player, Hal_Demux_Info_t* demuxInfo)
{	
	if((player== NULL) ||(NULL == demuxInfo))
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	//RTKHAL_INF("[%s]: %p \n",__FUNCTION__,player);
	HAL_HANDLE_S *hal_handle=(HAL_HANDLE_S*)player;
	Rtk_Demux_Info_t rtk_demuxInfo;
	memset(&rtk_demuxInfo,0,sizeof(Rtk_Demux_Info_t));
    
	if(rtk_porting_av_getDemuxInfo(hal_handle->av_handle,&rtk_demuxInfo) == RTK_OK)
	{
		demuxInfo->videoPacketCount=rtk_demuxInfo.videoPacketCount;
		demuxInfo->videoPacketLost=rtk_demuxInfo.videoPacketLost;
		demuxInfo->videoPacketLostCount=rtk_demuxInfo.videoPacketLostCount;
		demuxInfo->videoPESCount=rtk_demuxInfo.videoPESCount;
		demuxInfo->videoPESError=rtk_demuxInfo.videoPESError;
		demuxInfo->videoLength=rtk_demuxInfo.videoLength;
		demuxInfo->audioPacketCount=rtk_demuxInfo.audioPacketCount;
		demuxInfo->audioPacketLost=rtk_demuxInfo.audioPacketLost;
		demuxInfo->audioPacketLostCount=rtk_demuxInfo.audioPacketLostCount;
		demuxInfo->audioPESCount=rtk_demuxInfo.audioPESCount;
		demuxInfo->audioPESError=rtk_demuxInfo.audioPESError;
		demuxInfo->audioLength=rtk_demuxInfo.audioLength;
	}
	else
	{
		RTKHAL_ERR("rtk_porting_av_getDemuxInfo failed\n");
		return RTK_Fail;
	}
#if 1 // for debug
	RTKHAL_INF("[%s:%d]video PacketCount = %lld. PacketLost = %lld. PacketLostCount = %lld."
		"PESCount = %lld, PESError = %lld. Length = %lld\n", __func__,__LINE__,
		demuxInfo->videoPacketCount, demuxInfo->videoPacketLost, demuxInfo->videoPacketLostCount, 
		demuxInfo->videoPESCount, demuxInfo->videoPESError, demuxInfo->videoLength);

	RTKHAL_INF("[%s:%d]audio PacketCount = %lld. PacketLost = %lld. PacketLostCount = %lld."
		"PESCount = %lld, PESError = %lld. Length = %lld\n", __func__,__LINE__,
		demuxInfo->audioPacketCount, demuxInfo->audioPacketLost, demuxInfo->audioPacketLostCount, 
		demuxInfo->audioPESCount, demuxInfo->audioPESError, demuxInfo->audioLength);
#endif
	return RTK_OK;
}

RTK_Error RHAL_Base::Player_AddAvEventCallback(RTK_Player player, RTK_HAL_AV_EVENT av_event, RTK_HAL_AV_EVENT_FUNC callback)
{
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	if(hal_handle == NULL)
	{
		RTKHAL_ERR("%s(%d) parameter error ...\n",__func__,__LINE__);
		return RTK_Fail;
	}
	
	if(rtk_porting_av_add_event_callback(hal_handle->av_handle, (RTK_AV_EVENT)av_event, (RTK_AV_EVENT_FUNC)callback) != RTK_OK)
	{
		RTKHAL_ERR("%s(%d) rtk_porting_av_add_event_callback() fail ...\n",__func__,__LINE__);
		return RTK_Fail;
	}
	
	return RTK_OK;
}

RTK_Error RHAL_Base::Player_RemoveAvEventCallback(RTK_Player player, RTK_HAL_AV_EVENT av_event, RTK_HAL_AV_EVENT_FUNC callback)
{
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	
	if(hal_handle == NULL)
	{
		RTKHAL_ERR("%s(%d) parameter error ...\n",__func__,__LINE__);
		return RTK_Fail;
	}
	
	if(rtk_porting_av_add_event_callback(hal_handle->av_handle, (RTK_AV_EVENT)av_event, (RTK_AV_EVENT_FUNC)callback) != RTK_OK)
	{
		RTKHAL_ERR("%s(%d) rtk_porting_av_add_event_callback() fail ...\n",__func__,__LINE__);
		return RTK_Fail;
	}
	
	return RTK_OK;
}

RTK_Error RHAL_Base::Demux_SetSource(RTK_Demux demux, RTK_Source source)
{
#ifdef CLIENT_DTVSOURCE
	if(NULL == demux)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)demux;
	if(RTK_OK != rtk_porting_av_SetSource(hal_handle->av_handle , (void*)source))
	{
		RTKHAL_ERR("[%s]rtk_porting_av_SetSource %p faild\n", __FUNCTION__, source);
		return RTK_Fail;
	}
	if(_xGet_DmxHandle(hal_handle))
	{
		if (RTK_OK != rtk_porting_SectionFilterSetSource(_xGet_DmxHandle(hal_handle), source))
		{
			RTKHAL_ERR("[%s]rtk_porting_SectionFilterSetSource %p faild\n", __FUNCTION__, source);
			return RTK_Fail;
		}
	}
	hal_handle->connect_source = (Source_Handle)source;

	return RTK_OK;
#endif
	(void)demux;//fix warning
	(void)source;//fix warning
	return RTK_Fail;
}

RTK_Error RHAL_Base::Source_Create(RTK_Source *source, RTK_SourceParam_t param)
{
	RTK_Error ret = RTK_OK;
	ION_DATA* mtp_ion = NULL;

	Rtk_Porting_Source_Param_t source_param;
	source_param.type = RTK_PORTING_SOURCE_TYPE_UNDEFINE;
	source_param.bandwidth =(Rtk_Tuner_Bandwidth_e) param.bandwidth;
	source_param.isSMP = param.isSMP;
	source_param.cas_param.type = (Rtk_Porting_CAS_Type_e)param.cas_param.type;
	source_param.cas_param.tsid_sidx = param.cas_param.tsid_sidx;
	source_param.isPullMode = false;

	if(m_dtvSource_isInit==false)
	{
		mMtpBufInit();
		if(RTK_OK != rtk_porting_source_init())
		{
			RTKHAL_ERR("[%s]rtk_porting_source_init failed\n", __FUNCTION__);
		}
		m_dtvSource_isInit=true;
	}

	
	if(param.type == RTK_SOURCE_TYPE_DVBC)
	{
		//input ex:730,1,6875000
		source_param.type = RTK_PORTING_SOURCE_TYPE_DVB_C;
		source_param.tnr_param.dvb_c_param.u32frequency=param.tnr_param.dvb_c_param.u32frequency*1000*1000;
		source_param.tnr_param.dvb_c_param.u32symbol_rate=param.tnr_param.dvb_c_param.u32symbol_rate;
		source_param.tnr_param.dvb_c_param.modulation=(Rtk_CableTnr_Modulation_e)param.tnr_param.dvb_c_param.modulation;
		source_param.tnr_param.dvb_c_param.annex_type = (Rtk_DVBC_ANNEX_TYPE_e)param.tnr_param.dvb_c_param.annex_type;
	}
	else if(param.type == RTK_SOURCE_TYPE_MTP)
	{
		source_param.type = RTK_PORTING_SOURCE_TYPE_MTP;
		source_param.isPullMode = true;
		mtp_ion = mMtpBufPreLend();
		if (mtp_ion == NULL)
		{
			RTKHAL_ERR("[%s]mMtpBufPreLend failed\n", __FUNCTION__);
			return RTK_Fail;
		}
		source_param.tnr_param.mm_param.phyAddr = (unsigned int)mtp_ion->ion_phy;
		source_param.tnr_param.mm_param.len = MTP_BUF_SIZE;
	}
	else if(param.type == RTK_SOURCE_TYPE_MCP)
	{
		source_param.type = RTK_PORTING_SOURCE_TYPE_MCP;
		source_param.isPullMode = true;
		mtp_ion = mMtpBufPreLend();
		if (mtp_ion == NULL)
		{
			RTKHAL_ERR("[%s]mMtpBufPreLend failed\n", __FUNCTION__);
			return RTK_Fail;
		}
		source_param.tnr_param.mm_param.phyAddr = (unsigned int)mtp_ion->ion_phy;
		source_param.tnr_param.mm_param.len = MTP_BUF_SIZE;
	}
	else if(param.type == RTK_SOURCE_TYPE_MD)
	{
		source_param.type = RTK_PORTING_SOURCE_TYPE_MD;
	}
	else if(param.type == RTK_SOURCE_TYPE_TP)
	{
		source_param.type = RTK_PORTING_SOURCE_TYPE_TP;
		source_param.TunerID = param.TunerID;
	}
	else if(param.type == RTK_SOURCE_TYPE_DVB_S || param.type == RTK_SOURCE_TYPE_DVB_S2)
	{
		source_param.type = (param.type == RTK_SOURCE_TYPE_DVB_S) ? RTK_PORTING_SOURCE_TYPE_DVBS : RTK_PORTING_SOURCE_TYPE_DVBS2;
		source_param.tnr_param.dvb_s_param.u32frequency = param.tnr_param.dvb_s_param.u32frequency*1000*1000;
		source_param.tnr_param.dvb_s_param.u32symbol_rate = param.tnr_param.dvb_c_param.u32symbol_rate;
		source_param.tnr_param.dvb_s_param.lnbmode = (Rtk_LNB_MODE_e)param.tnr_param.dvb_s_param.lnbmode;
	}

	if(source_param.type != RTK_PORTING_SOURCE_TYPE_UNDEFINE)
	{
		if(RTK_OK != rtk_porting_source_create(source_param, (Source_Handle *)source))
		{
			RTKHAL_ERR("[%s]rtk_porting_source_create failed\n", __FUNCTION__);
			ret = RTK_Fail;
		}
		if(source_param.type==RTK_PORTING_SOURCE_TYPE_MTP || source_param.type==RTK_PORTING_SOURCE_TYPE_MCP)
		{
			mMtpBufSetSource(mtp_ion, *source, source_param.type);
		}
		int i=0;
		for(i=0; i<RTK_MAX_DTVSOURCE_MUM; i++)
		{
			if(m_pCurSource_Handle[i]==NULL)
				break;
		}

		if(i<RTK_MAX_DTVSOURCE_MUM)
		{
			m_pCurSource_Handle[i]=*source;
		}
		else 
		{
			RTKHAL_ERR("m_pCurSource_Handle is full!!!\n");
		}

#ifdef ENABLE_SOURCE_FILTER
		MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
		if(mCreateSourceSectionFilter(*source)!=RTK_OK)
		{
			if(mtp_ion) mMtpBufReturn(mtp_ion);
			Source_Destroy(*source);
			ret=RTK_Fail;
		}		
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
#endif

	}
	else
	{
		ret = RTK_Fail;
	}
	return ret;
}

RTK_Error RHAL_Base::Player_GetAudioTrackInfo(RTK_Player player, RTK_Audio_TrackInfo * ptrAudioTrackInfo)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	Rtk_Audio_FrameInfo_t  tsAudioTrackInfo;
	memset(&tsAudioTrackInfo, 0x00, sizeof(Rtk_Audio_FrameInfo_t));
	
	rtk_porting_av_getAudioTrackInfo(hal_handle->av_handle, &tsAudioTrackInfo);

	ptrAudioTrackInfo->type = tsAudioTrackInfo.type;
	ptrAudioTrackInfo->channelCount = tsAudioTrackInfo.channelCount;
	ptrAudioTrackInfo->bps = tsAudioTrackInfo.bps;
	ptrAudioTrackInfo->sampleRate = tsAudioTrackInfo.sampleRate;

	RTKHAL_INF("[%s:%d:%s].type=%ld,channelCount=%ld.bps=%ld.sampleRate=%ld\n",__FILE__,__LINE__,__func__,
		ptrAudioTrackInfo->type, ptrAudioTrackInfo->channelCount,ptrAudioTrackInfo->bps,ptrAudioTrackInfo->sampleRate);

	return RTK_OK;
}

RTK_Error RHAL_Base::Player_GetVideoTrackInfo(RTK_Player player, RTK_Video_TrackInfo * ptsVideoTrackInfo)
{
	if(player == NULL)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}	
	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);
	
	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;

	Rtk_Video_FrameInfo_t  tsVideoTrackInfo;
	memset(&tsVideoTrackInfo, 0x00, sizeof(Rtk_Video_FrameInfo_t));
	
	rtk_porting_av_getVideoTrackInfo(hal_handle->av_handle, &tsVideoTrackInfo);
	
	ptsVideoTrackInfo->type = tsVideoTrackInfo.type; 
	ptsVideoTrackInfo->hor_size = tsVideoTrackInfo.hor_size;
	ptsVideoTrackInfo->ver_size  = tsVideoTrackInfo.ver_size;
	ptsVideoTrackInfo->frame_rate = tsVideoTrackInfo.frame_rate;
	ptsVideoTrackInfo->bit_rate = tsVideoTrackInfo.bit_rate;
	ptsVideoTrackInfo->isProg = tsVideoTrackInfo.isProg;	// progressive or interlaced
	ptsVideoTrackInfo->isMVC = tsVideoTrackInfo.isMVC;
	ptsVideoTrackInfo->isHDR = tsVideoTrackInfo.isHDR;
	ptsVideoTrackInfo->isCompressBufferMode = tsVideoTrackInfo.isCompressBufferMode;
	ptsVideoTrackInfo->offsetTable_ysize = tsVideoTrackInfo.offsetTable_ysize;
	ptsVideoTrackInfo->offsetTable_csize = tsVideoTrackInfo.offsetTable_csize;
	
	switch (tsVideoTrackInfo.aspect_ratio)
	{
		case RTK_VSPEC_ASPECT_RATIO_Forbidden:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_Forbidden;
			break;
		case RTK_VSPEC_ASPECT_RATIO_SquareSample:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_SquareSample;
			break;
		case RTK_VSPEC_ASPECT_RATIO_4_3:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_4_3;
			break;
		case RTK_VSPEC_ASPECT_RATIO_16_9:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_16_9;
			break;
		case RTK_VSPEC_ASPECT_RATIO_221_1:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_221_1;
			break;
		default:
			ptsVideoTrackInfo->aspect_ratio = RTK_VSPEC_ASPECT_RATIO_Reserved;
			break;
	}

	RTKHAL_INF("[%s:%d:%s].aspect_ratio=%d\n",__FILE__,__LINE__,__FUNCTION__,ptsVideoTrackInfo->aspect_ratio);
	RTKHAL_INF("[%s:%d:%s].type=%ld.hor_size=%ld.ver_size=%ld.frame_rate=%ld.bit_rate=%ld.isProg=%ld.isMVC=%ld.\n",__FILE__,__LINE__,__FUNCTION__,
		ptsVideoTrackInfo->type, ptsVideoTrackInfo->hor_size,ptsVideoTrackInfo->ver_size,ptsVideoTrackInfo->frame_rate,ptsVideoTrackInfo->bit_rate,ptsVideoTrackInfo->isProg,ptsVideoTrackInfo->isMVC);
	RTKHAL_INF("[%s:%d:%s].isCompressBufferMode=%ld.offsetTable_ysize=%ld.offsetTable_csize=%ld..\n",__FILE__,__LINE__,__FUNCTION__,
		ptsVideoTrackInfo->offsetTable_ysize,ptsVideoTrackInfo->offsetTable_ysize,ptsVideoTrackInfo->offsetTable_csize);
	//rtk_store_system_cmd(RTK_VIDEO_PROG, RTK_SYSTEM_TYPE_INT, (UINT32_T *) &ptsVideoTrackInfo->isProg);

	return RTK_OK;
}

RTK_Error RHAL_Base::Source_Destroy(RTK_Source source)
{
	if(NULL == source)
	{
		RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
		return RTK_Fail;
	}

#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	mDestroySourceSectionFilter(source);
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
#endif

	ION_DATA* mtp_ion = mMtpBufFind((Source_Handle)source, NULL);
	if(mtp_ion != NULL)
	{
		RTKHAL_ERR("[%s]MTP buffer not return before destory source!!!\n", __FUNCTION__);
		mMtpBufReturn(mtp_ion);
	}

	for(int i=0; i<RTK_MAX_DTVSOURCE_MUM; i++)
	{
		if(m_pCurSource_Handle[i]==source)
		{
			m_pCurSource_Handle[i]=NULL;
		}
	}

	if(RTK_OK != rtk_porting_source_destroy((Source_Handle)source))
	{
		RTKHAL_ERR("[%s]rtk_porting_source_destroy %p failed\n", __FUNCTION__, source);
		return RTK_Fail;
	}
	return RTK_OK;
}

RTK_Error RHAL_Base::Source_SetRfDemod(RTK_Source source, RTK_RfDemodParam_t param)
{
	RTK_Error ret = RTK_OK;
	Rtk_Porting_RfDemod_Param_t rf_param;

	rf_param.type = RTK_PORTING_SOURCE_TYPE_UNDEFINE;
	rf_param.bandwidth =(Rtk_Tuner_Bandwidth_e) param.bandwidth;

	if (param.type == RTK_SOURCE_TYPE_DVBC)
	{
		//input ex:730,1,6875000
		rf_param.type = RTK_PORTING_SOURCE_TYPE_DVB_C;
		rf_param.tnr_param.dvb_c_param.u32frequency=param.tnr_param.dvb_c_param.u32frequency*1000*1000;
		rf_param.tnr_param.dvb_c_param.u32symbol_rate=param.tnr_param.dvb_c_param.u32symbol_rate;
		rf_param.tnr_param.dvb_c_param.modulation=(Rtk_CableTnr_Modulation_e)param.tnr_param.dvb_c_param.modulation;
		rf_param.tnr_param.dvb_c_param.annex_type = (Rtk_DVBC_ANNEX_TYPE_e)param.tnr_param.dvb_c_param.annex_type;
	}
	else if (param.type == RTK_SOURCE_TYPE_DVB_S || param.type == RTK_SOURCE_TYPE_DVB_S2)
	{
		rf_param.type = (param.type == RTK_SOURCE_TYPE_DVB_S) ? RTK_PORTING_SOURCE_TYPE_DVBS : RTK_PORTING_SOURCE_TYPE_DVBS2;
		rf_param.tnr_param.dvb_s_param.u32frequency = param.tnr_param.dvb_s_param.u32frequency*1000*1000;
		rf_param.tnr_param.dvb_s_param.u32symbol_rate = param.tnr_param.dvb_c_param.u32symbol_rate;
		rf_param.tnr_param.dvb_s_param.lnbmode = (Rtk_LNB_MODE_e)param.tnr_param.dvb_s_param.lnbmode;
	}
	else
	{
		RTKHAL_ERR("[%s] %p type %d is not tuner\n", __FUNCTION__, source, param.type);
		ret = RTK_Fail;
	}

	if(rf_param.type != RTK_PORTING_SOURCE_TYPE_UNDEFINE)
	{
		if (RTK_OK != rtk_porting_source_setRfDemod((Source_Handle)source, rf_param))
		{
			RTKHAL_ERR("[%s]rtk_porting_source_setRfDemod %p failed\n", __FUNCTION__, source);
			ret = RTK_Fail;
		}
	}
	return ret;
}

RTK_Error RHAL_Base::Source_PresetPidFilter(RTK_Source source, uint16_t* pids, unsigned char numPID)
{
	Rtk_Source_PidFilter_Param_t* pPIDs = NULL;
	RTK_Error ret = RTK_OK;
	int iValidNum = 0;

	if(numPID>0)
	{
		pPIDs = (Rtk_Source_PidFilter_Param_t*)malloc(sizeof(Rtk_Source_PidFilter_Param_t)*numPID);
		if(pPIDs == NULL)
		{
			return RTK_Fail;
		}		
		
		for(int i = 0; i< numPID; i++)
		{
			if (pids[i] > 0x1fff)
			{
				continue;
			}
			pPIDs[iValidNum].PID = (unsigned short) pids[i];
			pPIDs[iValidNum].KeySel = 0;
			pPIDs[iValidNum].ProtectedRegion = 0;
			pPIDs[iValidNum].ChId = 0;
			iValidNum++;
		}
	}

	if (iValidNum == 0)
	{
		RTKHAL_WRN("[%s] no valid pid found!!\n", __FUNCTION__);
	}
	
	if(iValidNum == 0 || RTK_OK != rtk_porting_source_presetPidFilter((Source_Handle)source, pPIDs, iValidNum))
	{
		ret = RTK_Fail;
	}
	if(pPIDs)
	{
		free(pPIDs);
	}
	return ret;
}

RTK_Error RHAL_Base::Source_GetIsLocked(RTK_Source source)
{
	Rtk_Tuner_State_e tnr_state = RTK_TUNER_STATE_UNKNOWN;
	if(RTK_OK != rtk_porting_source_getState((Source_Handle)source, &tnr_state))
	{
		return RTK_Fail;
	}
	RTKHAL_INF("[%s]source(%p), tnr_state(%d)\n", __FUNCTION__, source, tnr_state);
	return (tnr_state == RTK_TUNER_STATE_LOCKED) ? RTK_OK : RTK_Fail;
}

RTK_Error RHAL_Base::Source_GetSignalInfo(RTK_Source source, RTK_TunerInfo* info)
{
    Rtk_Tuner_State_e tnr_state = RTK_TUNER_STATE_UNKNOWN;
    Rtk_Signal_ALLInfo_t signal;

	if(info == NULL)
	{
		RTKHAL_ERR("[%s]info parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(source == NULL)
	{
		RTKHAL_ERR("[%s]source parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}

	memset(&signal,0x0,sizeof(Rtk_Signal_ALLInfo_t));
    if(RTK_OK != rtk_porting_source_getState((Source_Handle)source, &tnr_state))
    {
		return RTK_Fail;
    }
    RTKHAL_INF("[%s]source(%p), tnr_state(%d)\n", __FUNCTION__, source, tnr_state);
    if(RTK_OK != rtk_porting_source_getSignalInfo((Source_Handle)source, &signal))
    {
		return RTK_Fail;
	}
    info->number = (uint32_t)source;
    info->locked = (tnr_state == RTK_TUNER_STATE_LOCKED) ? RTK_TRUE : RTK_FALSE;
    info->strength = signal.u32signal_strength;
    info->quality = signal.u32signal_quality;
    info->snr = signal.signal_snr;
    info->ber = signal.signal_ber;
	info->lber = signal.signal_lber;
    info->agc = signal.signal_agc;
    if(signal.powerlevel != 0xff)
    {
  //  	info->powerLevel = signal.powerlevel*DBSWITCHTODBM+DBMSWITCHTODBMV;
  		info->powerLevel = signal.powerlevel;
    }
  	
	else
		info->powerLevel = signal.powerlevel;
    info->packetError = signal.signal_per;
    info->mer = 10 * log10(1-signal.signal_per);
    info->temperature = signal.temperature;
	return RTK_OK;
}

RTK_Error RHAL_Base::Source_GetInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
	unsigned int limit_free_size = 0;
	unsigned int total_free_size = 0;
	unsigned int useable_free = 0;
//	RTKHAL_INF("[%s]: enter\n", __FUNCTION__);
	if(buffer == NULL)
	{
		RTKHAL_ERR("[%s]buffer parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(source == NULL)
	{
		RTKHAL_ERR("[%s]source parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}

	memset(buffer, 0, sizeof(RTK_TSInputBuffer));
	buffer->isLast = RTK_FALSE;

	int i=0;
	pthread_mutex_lock(&mtp_mutex);

	//Find mtp buffer according source
	for(i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == source)
		{	
			break;
		}	
	}
	if(i>=MTP_BUF_COUNT)
	{
		RTKHAL_ERR("[%s]mtp buffer not found\n", __FUNCTION__);
		pthread_mutex_unlock(&mtp_mutex);
		return RTK_Fail;
	}

	if(mtp_buf[i].type == RTK_PORTING_SOURCE_TYPE_MTP)
	{
		if(mtp_buf[i].freesize == 0)
		{
			if(RTK_OK != rtk_porting_source_getMTPBufFreeSize((Source_Handle)source, &limit_free_size, &total_free_size))
			{
				RTKHAL_ERR("[%s]rtk_porting_source_getMTPBufFreeSize failed\n", __FUNCTION__);
				pthread_mutex_unlock(&mtp_mutex);
				return RTK_Fail;
			}
			mtp_buf[i].freesize = limit_free_size;
		}
		if (mtp_buf[i].freesize > (mtp_buf[i].cache_ofs - mtp_buf[i].write_ofs))
		{
			useable_free = mtp_buf[i].freesize - (mtp_buf[i].cache_ofs - mtp_buf[i].write_ofs);
		}

//		RTKHAL_INF("[%s] cache_ofs=%d write_ofs=%d limit_free_size=%d total_free_size=%d, useable_free=%d\n", __FUNCTION__,
//			mtp_buf[i].cache_ofs, mtp_buf[i].write_ofs, limit_free_size, total_free_size, useable_free);
	}
	else // type=RTK_PORTING_SOURCE_TYPE_MCP
	{
		if(RTK_OK != rtk_porting_source_getTPBufFreeSize((Source_Handle)source, &total_free_size))
		{
			RTKHAL_ERR("[%s]rtk_porting_source_getTPBufFreeSize failed\n", __FUNCTION__);
			pthread_mutex_unlock(&mtp_mutex);
			return RTK_Fail;
		}

		if (total_free_size > (2*188))
		{
			total_free_size -= 2*188;
			total_free_size = (total_free_size/ALIGN_PKT_SIZE)*ALIGN_PKT_SIZE;

			useable_free = MTP_BUF_SIZE - (2*188) - mtp_buf[i].cache_ofs;
			useable_free = (useable_free/ALIGN_PKT_SIZE)*ALIGN_PKT_SIZE;

			useable_free = (total_free_size > useable_free) ? useable_free : total_free_size;
		}
	}

	if (useable_free > 0)
	{
		buffer->memory = (void*)(mtp_buf[i].ion.ion_virt + mtp_buf[i].cache_ofs);
		buffer->size = useable_free;
	}
	else
	{
		RTKHAL_INF("[%s] full\n", __FUNCTION__);
	}

	pthread_mutex_unlock(&mtp_mutex);

//	RTKHAL_INF("[%s]: exit\n", __FUNCTION__);
	if(buffer->size==0){
		return RTK_BUFFER_NOT_AVAILABLE;
	}

	return RTK_OK;
}

RTK_Error RHAL_Base::Source_FeedInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
	RTK_Bool cached_enough = RTK_FALSE;
	uint32_t cached_size;
	struct timeval cur_time;
	int i=0;
	long mtp_qtime=0;

	//RTKHAL_INF("[%s]: enter\n", __FUNCTION__);
	if(buffer == NULL || buffer->filled_size == 0)
	{
		RTKHAL_ERR("[%s]buffer parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(source == NULL)
	{
		RTKHAL_ERR("[%s]source parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}

	//Find mtp buffer according source
	pthread_mutex_lock(&mtp_mutex);
	for(i = 0; i < MTP_BUF_COUNT; i++)
	{
		if(mtp_buf[i].source == source)
		{
			break;
		}
	}

	if(i>=MTP_BUF_COUNT)
	{
		RTKHAL_ERR("[%s]mtp buffer not lend\n", __FUNCTION__);
		pthread_mutex_unlock(&mtp_mutex);
		return RTK_Fail;
	}

	RTK_GET_TIME(&cur_time);
	long start_time = mtp_buf[i].last_time.tv_sec*1000+mtp_buf[i].last_time.tv_usec/1000;
	long end_time = cur_time.tv_sec*1000+cur_time.tv_usec/1000;
	mtp_qtime = end_time - start_time;

	//update cache offset
	mtp_buf[i].cache_ofs += buffer->filled_size;
	if (mtp_buf[i].cache_ofs >= mtp_buf[i].bufsize) // ring back
	{
		mtp_buf[i].cache_ofs -= mtp_buf[i].bufsize;
	}

	// calculate cache size
	if (mtp_buf[i].cache_ofs >= mtp_buf[i].write_ofs)
	{
		cached_size = mtp_buf[i].cache_ofs - mtp_buf[i].write_ofs;
		if (cached_size > MTP_BUF_SIZE/2 || mtp_buf[i].freesize == cached_size)
		{
			cached_enough = RTK_TRUE;
		}
	}
	else //ringback, always do
	{
		cached_size = mtp_buf[i].bufsize - mtp_buf[i].write_ofs;
		cached_enough = RTK_TRUE;
	}

//	RTKHAL_INF("[%s] cache_ofs=%d write_ofs=%d filled_size=%d, cached_size=%d\n", __FUNCTION__,
//		mtp_buf[i].cache_ofs, mtp_buf[i].write_ofs, buffer->filled_size, cached_size);

	if ((buffer->isFeedAsync == RTK_FALSE) || (cached_enough == RTK_TRUE) || buffer->isLast || (mtp_qtime > 10))
	{
		rtk_ion_flush_handle_fd(mtp_buf[i].ion.mmap_fd);
		unsigned int start_phy = (unsigned int)(mtp_buf[i].ion.ion_phy) + mtp_buf[i].write_ofs;
//		RTKHAL_INF("[%s] actual feed isFeedAsync=%d cached_enough=%d mtp_qtime=%ld\n", __FUNCTION__ ,buffer->isFeedAsync, cached_enough, mtp_qtime);
		if( RTK_OK !=rtk_porting_source_feed((Source_Handle)source, start_phy, cached_size, buffer->isLast, (bool) buffer->isFrameEnd))
		{
			RTKHAL_ERR("[%s]rtk_porting_source_feed failed\n", __FUNCTION__);
			pthread_mutex_unlock(&mtp_mutex);
			return RTK_Fail;
		}

		if(mtp_buf[i].type == RTK_PORTING_SOURCE_TYPE_MTP)
		{
			mtp_buf[i].write_ofs += cached_size;

			if (mtp_buf[i].write_ofs == mtp_buf[i].bufsize)
			{// ring back
				mtp_buf[i].write_ofs = 0;
			}
			mtp_buf[i].freesize -= cached_size;
		}
		else // type=RTK_PORTING_SOURCE_TYPE_MCP
		{
			mtp_buf[i].write_ofs = 0;
			mtp_buf[i].cache_ofs = 0;
		}

		mtp_buf[i].last_time = cur_time;
	}

	//RTKHAL_INF("[%s]: exit\n", __FUNCTION__);
	pthread_mutex_unlock(&mtp_mutex);

	buffer->size = 0;
	return RTK_OK;
}

RTK_Error RHAL_Base::Source_DiscardInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
	if(buffer == NULL)
	{
		RTKHAL_ERR("[%s]buffer parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}
	if(source == NULL)
	{
		RTKHAL_ERR("[%s]source parameter is null\n", __FUNCTION__);
		return RTK_Fail;
	}

	buffer->size = 0;
	return RTK_OK;
}

RTK_Error RHAL_Base::Source_Flush(RTK_Source source)
{
	int i=0;
	RTKHAL_INF("[%s]:%p Enter\n", __FUNCTION__, source);
	pthread_mutex_lock(&mtp_mutex);
	if(source)
	{
		for(i = 0; i < MTP_BUF_COUNT; i++)
		{
			if(mtp_buf[i].source == source)
			{	
				break;
			}	
		}

		if(i<MTP_BUF_COUNT)
		{
			mtp_buf[i].cache_ofs=0;
			mtp_buf[i].write_ofs=0;
			mtp_buf[i].freesize = 0;
			memset(&mtp_buf[i].last_time, 0, sizeof(struct timeval));
		}
	}
	pthread_mutex_unlock(&mtp_mutex);	
	rtk_porting_source_flush((Source_Handle)source);
	RTKHAL_INF("[%s]:%p Exiit\n", __FUNCTION__, source);

	return RTK_OK;
}

RTK_Error RHAL_Base::Source_SetTsidSidx(RTK_Source source, unsigned int tsid_sidx)
{
	RTKHAL_INF("[%s]source(%p), tsid_sidx(%d)\n", __FUNCTION__, source, tsid_sidx);

	if(RTK_OK != rtk_porting_source_setTSID((Source_Handle)source, tsid_sidx))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}


RTK_Error RHAL_Base::Source_SetTsidSid_Ex(RTK_Source source, unsigned int tsid_sidx, unsigned char numPID, unsigned short* pPIDs)
{
	RTKHAL_INF("[%s]source(%p), tsid_sidx(%d) numPid (%d)\n", __FUNCTION__, source, tsid_sidx,numPID);

	if(RTK_OK != rtk_porting_source_setTSID_Ex((Source_Handle)source, tsid_sidx,numPID,pPIDs))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}


RTK_Error RHAL_Base::Source_SetKeyUpdateMode(unsigned int tsid_sidx,unsigned int is_encrypt,Hal_Key_UpdateMode_e update_mode)
{
	RTKHAL_INF("[%s]  tsid_sidx(%d) , is_encrypt(%d) update mode (%d) \n",__FUNCTION__,tsid_sidx,is_encrypt, update_mode);
	Rtk_Key_UpdateMode_e key_update_mode =_lookup_rtk_key_update_mode(update_mode);
	if(RTK_OK != rtk_porting_key_UpdateMode(tsid_sidx,is_encrypt,key_update_mode))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}

RTK_Error RHAL_Base::Source_AddSectionFilter(RTK_Source source, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	RTK_Error ret=RTK_Fail;
	UNUSED(source);
	UNUSED(filter_handle);
	UNUSED(pattern);
	#ifdef ENABLE_SOURCE_FILTER	
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret =  _xAddSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle, pattern);	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#endif

	return ret;
}
RTK_Error RHAL_Base::Source_RemoveSectionFilter(RTK_Source source, RTK_SectionFilter filter_handle)
{
	RTK_Error ret=RTK_Fail;
	UNUSED(source);
	UNUSED(filter_handle);
	
	#ifdef ENABLE_SOURCE_FILTER	
	int s_dmx_i=-1;
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	s_dmx_i=mFindSourceDmxIndex_bySource(source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveSectionFilter(m_sourceDmxHandle[s_dmx_i].dmx_handle, filter_handle);
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#endif
	return ret;
	
}
RTK_Error RHAL_Base::Source_RemoveAllSectionFilters(RTK_Source source)
{
	RTK_Error ret=RTK_Fail;
	UNUSED(source);
	
	#ifdef ENABLE_SOURCE_FILTER
	MUTEX_CHECKSIG_AND_LOCK(&m_sourceDmxHandle_mutex);
	int s_dmx_i=-1;
	s_dmx_i=mFindSourceDmxIndex_bySource(source);
	if(s_dmx_i<0 || s_dmx_i>=RTK_MAX_DTVSOURCE_MUM)
	{
		RTKHAL_ERR("can not find dmx handle in this source!!!\n");
		MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
		return RTK_Fail;
	}
	ret = _xRemoveAllSectionFilters(m_sourceDmxHandle[s_dmx_i].dmx_handle);
	
	MUTEX_CHECKSIG_AND_UNLOCK(&m_sourceDmxHandle_mutex);
	#endif
	return ret;
}

RTK_Error RHAL_Base::Source_GetIsIdle(RTK_Source source, RTK_Bool* is_idle)
{
	RTKHAL_INF("[%s]source(%p)\n", __FUNCTION__, source);

	if(RTK_OK != rtk_porting_source_getIsIdle((Source_Handle)source, (RTK_BOOL*)is_idle))
	{
		return RTK_Fail;
	}
	return RTK_OK;
}

////

/**
** @brief
** Audio behind or early video output
**
** @param[in]		delayInMs			delay ms (+3000 ~ -3000)
**
**
*/
void RHAL_Base::SetHdmiOutVSDBDelay(int delayInMs)
{
    rtk_porting_setHdmiOutVSDBDelay( delayInMs);
}


void RHAL_Base::SetAudioHdmiDelay(char enable,int delayInMs)
{
    rtk_porting_setAudioHdmiDelay(enable, delayInMs);
}


RTK_Error RHAL_Base::Player_GetDecodeStatus(RTK_Player player,uint32_t* pGoodDecodedFrmNum, uint32_t* pErrorDecodedFrmNum)
{
    RTKHAL_INF("[%s]:enter %p\n", __FUNCTION__, player);
    if(player == NULL)
    {
        RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
        return RTK_Fail;
    }    
    INT8_T ret;
    HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
#if 0
    UINT32_T u32av_handle = _xGet_AvHandle((HAL_HANDLE_S*)player);
    AV_HANDLE_S* av_handle = (AV_HANDLE_S*)u32av_handle;
    if(av_handle == NULL)
    {
        RTKHAL_ERR("[%s][%d] *** error: illegal av handle\n",__func__,__LINE__);
        return RTK_Fail;
    }   
    int channel_id =  av_handle->attr.channel_id ;
#endif
    int channel_id = hal_handle->channel;
    ret = rtk_porting_getDecodeStatus((RTK_RVSD_SOCKET_e)channel_id,pGoodDecodedFrmNum, pErrorDecodedFrmNum);    
    RTKHAL_INF("[%s] exit\n", __FUNCTION__);
    return (ret == RTK_ERR?RTK_Fail:RTK_OK);

}

RTK_Error RHAL_Base::Player_SendDisplayInfoToHdmiSer(RTK_Player  player,RTK_WinPlane vo_plane)
{
  if(player == NULL)
  	{
  	    RTKHAL_ERR("[%s]param error......\n", __FUNCTION__);
            return RTK_Fail;
  	}

	RTKHAL_INF("[%s]:%p\n", __FUNCTION__, player);

	HAL_HANDLE_S *hal_handle = (HAL_HANDLE_S*)player;
	Rtk_Video_FrameInfo_t  tsVideoTrackInfo;
	memset(&tsVideoTrackInfo, 0x00, sizeof(Rtk_Video_FrameInfo_t));
	if(hal_handle->av_handle == 0)
	{
	        RTKHAL_ERR("[%s][%d] *** error: illegal av handle\n",__func__,__LINE__);
	        return RTK_Fail;
	}   
	rtk_porting_av_getVideoTrackInfo(hal_handle->av_handle, &tsVideoTrackInfo);
	RTKHAL_INF("[%s:%d].isHDR=%ld.hor_size=%ld.ver_size=%ld\n",__FUNCTION__,__LINE__, tsVideoTrackInfo.isHDR, tsVideoTrackInfo.hor_size,tsVideoTrackInfo.ver_size);

#if defined(USE_RTKHAL_IN_ANDROID9) 
	VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN disp_plane_id;
	VIDEO_RPC_VOUT_QUERY_DISP_WIN_OUT disp_out;
	memset(&disp_plane_id, 0x00, sizeof(VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN));
	memset(&disp_out, 0x00, sizeof(VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN));

	if(vo_plane==RTK_WIN_MAIN)
	 	disp_plane_id.plane=VO_VIDEO_PLANE_V1;
	 else if(vo_plane==RTK_WIN_PIP)
		disp_plane_id.plane=VO_VIDEO_PLANE_V2;
	else
	{
 		RTKHAL_ERR("[%s:%d] vo_plane(%d) error!!!\n",__FUNCTION__,__LINE__,disp_plane_id.plane);
  		return RTK_Fail;
	}
	
        struct timeval old_time,cur_time;	
	memset(&old_time,0,sizeof(struct timeval));
	memset(&cur_time,0,sizeof(struct timeval));
	gettimeofday(&old_time,0);
	gettimeofday(&cur_time,0);	
	int queryTimeOutFlag = 1;	
	
 while (( (cur_time.tv_sec -old_time.tv_sec)*1000+(cur_time.tv_usec -old_time.tv_usec)/1000) <= 2000) 	
 	{         	
	         if (S_OK==VoutUtil::instance().QueryDisplayWin(disp_plane_id, &disp_out))
	         {
	         	RTKHAL_INF("[%s:%d].configWin.x=%d.configWin.y=%d.configWin.width=%d,configWin.height=%d\n",__FUNCTION__,__LINE__,
					( int32_t)(disp_out.configWin.x), ( int32_t)(disp_out.configWin.y),( int32_t) (disp_out.configWin.width),(int32_t) (disp_out.configWin.height));
			queryTimeOutFlag = 0;
			break;
	         }			 
		 else
		 {
		  	RTKHAL_INF("[%s:%d] wait vo ready\n",__FUNCTION__,__LINE__);
		 	gettimeofday(&cur_time,0);		
			usleep(1000);
		 }
 	}

      if(queryTimeOutFlag)
      	{
      		RTKHAL_ERR("[%s:%d] wait vo ready timeOut\n",__FUNCTION__,__LINE__);
		return RTK_Fail;
      	}
	 
	#if 0   
	 if(mhal_hdmiLib!=NULL)	 	
 		mhal_hdmiLib->updateVideoPlaneUsage(HDRTOPO_SOURCE_HWC,( int32_t)(disp_out.configWin.x), ( int32_t)(disp_out.configWin.y),( int32_t) (disp_out.configWin.width),
                                                                             (int32_t) (disp_out.configWin.height),( int32_t )(tsVideoTrackInfo.isHDR),( int32_t)(disp_plane_id.plane));
	 else
	 {
 		RTKHAL_ERR("[%s:%d] mhal_hdmiLib is null !!!\n",__FUNCTION__,__LINE__);
  		return RTK_Fail;
	 }
     #endif
	 
#else
	UNUSED(vo_plane);
	return RTK_Fail;
 #endif
   return RTK_OK;

}

RTK_Bool RHAL_Base::System_VOisUsing(RTK_WinPlane vo_plane)
{

#if defined(USE_RTKHAL_IN_ANDROID9)
	HRESULT h_ret=S_OK;
	
	VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN disp_plane_id;
	VIDEO_RPC_VOUT_QUERY_DISP_WIN_OUT out;

	memset(&disp_plane_id, 0x00, sizeof(VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN));
	memset(&out, 0x00, sizeof(VIDEO_RPC_VOUT_QUERY_DISP_WIN_IN));

	if(vo_plane==RTK_WIN_MAIN)
		disp_plane_id.plane=VO_VIDEO_PLANE_V1;
	else if(vo_plane==RTK_WIN_PIP)
		disp_plane_id.plane=VO_VIDEO_PLANE_V2;
	else
		return RTK_FALSE;

	
	h_ret=VoutUtil::instance().QueryDisplayWin(disp_plane_id, &out);
	
	return (h_ret==S_OK)?RTK_TRUE:RTK_FALSE;
#else
	UNUSED(vo_plane);
	return RTK_FALSE;
#endif
	
}

/*********************************************************************************
* 							Player Interface Begin 
**********************************************************************************/

/**
** @brief
** creates player and does initial works for this player
**
** @param[out]		player		 	return the Player handle created by this function
** @param[in]		config			the configs used when creating the player
**
** @retval		RTK_OK			 RTK_Player_Creat has successfully processed.
** @retval		RTK_Fail 			 parameters error occurred or _xCreate return failed.
**
*/
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V1)
RTK_Error RTK_Player_Create(RTK_Player * player, RTK_PlayerConfig * config, HAL_TYPE type)
{
	RTK_Error ret;
	
	pthread_mutex_lock(&RHAL_Base_mutex);
	ret = RHAL_GetHalInstance()->Player_Create(player, config, type);
	pthread_mutex_unlock(&RHAL_Base_mutex);

	return ret;
}


/**
    ** @brief
    ** update vo plane after player started.
    **
    ** @param[in]		player		 	the player
    ** @param[in]		plane			the plane
    **
    ** @retval		RTK_OK			 success.
    ** @retval		RTK_Fail 		 failed.
    **
*/
RTK_Error RTK_Player_Update_VO_Plane(RTK_Player player, RTK_WinPlane plane)
{
	return RHAL_GetHalInstance()->Player_Update_VO_Plane(player, plane);
}


/**
** @brief
** starts player
**
** @param[in]		player		 	the player handle
**
** @retval		RTK_OK			the player starts playing successfully.
** @retval		RTK_Fail 			parameters error occurred or the player doesn't start to play.
**
*/
RTK_Error RTK_Player_Start(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_Start(player);
}

/**
** @brief
** stop player
**
** @param[in]		player		 	the player handle
**
** @retval		RTK_OK			 RTK_Player_Stop has successfully processed
** @retval		RTK_Fail 			 parameters error occurred or the player doesn't stop to play.
**
*/
RTK_Error RTK_Player_Stop(RTK_Player player, RTK_Bool keepLastFrame)
{
	return RHAL_GetHalInstance()->Player_Stop(player, keepLastFrame);
}

/**
** @brief
** destroys the player
**
** @param[in]		player		 	the player handle
**
** @retval		RTK_OK			 RTK_Player_Destroy has successfully processed
** @retval		RTK_Fail 			 parameters error occurred or _xDestroy return failed
**
*/
RTK_Error RTK_Player_Destroy(RTK_Player player)
{
	RTK_Error ret;
	
	pthread_mutex_lock(&RHAL_Base_mutex);
	ret = RHAL_GetHalInstance()->Player_Destroy(player);
	pthread_mutex_unlock(&RHAL_Base_mutex);

	return ret;
}

/**
** @brief
** pauses the player
**
** @param[in]		player		 	 the Player handle
**
** @retval		RTK_OK			 RTK_Player_Pause has successfully processed
** @retval		RTK_Fail 			 parameters error occurred or the player doesn't stop to play
**
*/
RTK_Error RTK_Player_Pause(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_Pause(player);
}

/**
** @brief
**resumes the Player
**
** @param[in]		player		 	the Player handle
**
** @retval		RTK_OK			 the player replays again successfully
** @retval		RTK_Fail 			 parameters error occurred or the player doesn't replay.
**
*/
RTK_Error RTK_Player_Resume(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_Resume(player);
}

/**
** @brief
**Drops all previously fed TS data from internal buffer which is not yet processed
**
** @param[in]		player		 	the Player handle
**
** @retval		RTK_OK			 RTK_Player_DropData has successfully processed
** @retval		RTK_Fail 			 Dvbapp instance does not exist.
**
*/
RTK_Error RTK_Player_DropData(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_DropData(player);
}

/**
** @brief
** opens and sets sectionFilter by specific pid, add the SectionFilter into SI engine with the player handle
**
** @param[in]		player		 	handle of player to add section filter
** @param[out]		filter_handle 	 	handle of filter to specify
** @param[in]		pattern			defines filter pid, mask, mode, compose type, monitor mode, 
**								user param and a function pointer to SI section filter callback
**
** @retval		RTK_OK			_xAddSectionFilter has successfully processed
** @retval		RTK_Fail 			parameters error occurred or filter open failed.
**
*/
RTK_Error RTK_Player_AddSectionFilter(RTK_Player player, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	return RHAL_GetHalInstance()->Player_AddSectionFilter(player, filter_handle, pattern);
}

/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		player		 	handle of player 
** @param[in]		filter_handle 	 	handle of filter to stop
**
** @retval		RTK_OK			section filter has been stopped parsing with 
**								specific filter_handle successfully.
** @retval		RTK_Fail 			parameters error occurred or SI engine PID 
**								filter remove failed
**
*/
RTK_Error RTK_Player_RemoveSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle)
{
	return RHAL_GetHalInstance()->Player_RemoveSectionFilter(player, filter_handle);
}

/**
** @brief
** enable the sectionFilter status
**
** @param[in]		player			handle of player 
** @param[in]		filter_handle  handle of filter to enable
** @param[in]		enable 	 		enable or disable section fitler
**
** @retval		RTK_OK			section filter has been enable or disable success
** @retval		RTK_Fail 		parameters error occurred or SI engine PID 
**								filter enable or disable failed
**
*/
RTK_Error RTK_Player_ControlSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle,RTK_Bool enable)
{
	return RHAL_GetHalInstance()->Player_ControlSectionFilter(player, filter_handle,enable);
}


/**
** @brief
** stops all sectionFilters player added, then sectionFilters will not work 
**
** @param[in]		player		 	handle of player 
**
** @retval		RTK_OK			all section filters have been stopped parsing successfully.
** @retval		RTK_Fail 			parameters error occurred or SI engine PID filter remove failed.
**
*/
RTK_Error RTK_Player_RemoveAllSectionFilters(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_RemoveAllSectionFilters(player);
}

/*
 * Change A/V
 */
 

/*
 * TS filter
 * 		- These functions can be called multiple times.
 */
 
/**
** @brief
** adds TSFilter for demux
**
** @param[in]		demux		 	handle of demux to add 
** @param[in]		pattern 	 		defines filter pattern ,include pid, encrypted or not, A/V codec types, get PTS and Frame type or not
** @param[out]		filter_handle		handle of filter to specify
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RTK_Player_AddTSFilter(RTK_Player player, RTK_TSFilterPattern * pattern, RTK_TSFilter * filter_handle)
{
	return RHAL_GetHalInstance()->Player_AddTSFilter(player, pattern, filter_handle);
}

/**
** @brief
** removes the TSFilter, then it should not parse the specific TS data
**
** @param[in]		demux		 	handle of player to deal with
** @param[in]		filter_handle		handle of TsFilter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RTK_Player_RemoveTSFilter(RTK_Player player, RTK_TSFilter filter_handle)
{
	return RHAL_GetHalInstance()->Player_RemoveTSFilter(player, filter_handle);
}

/**
** @brief
** stops all TSFilter demux added, then TSFilter will not work 
**
** @param[in]		demux		 	handle of player to deal with
**
** @retval		RTK_OK			remove all success
** @retval		RTK_Fail 			remove all fail
**
*/
RTK_Error RTK_Player_RemoveAllTSFilters(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_RemoveAllTSFilters(player);
}

/**
   * @brief
   * Reset TS filter.
   *
   * After this operation, the TS Filter Parser will be reset to the init state. It mean all the 
   * TS callback buffer will be reset, include pts, frames...  
   *
   * @param[in]      player		 	handle of player to deal with
   *
   * @retval		RTK_OK			success
   * @retval		RTK_Fail 			fail
   *
   */
RTK_Error RTK_Player_ResetTSFilterParser(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_ResetTSFilterParser(player);
}

/**
** @brief
** modifies pid of PCR
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		pcr_pid		 	pcr pid which the player will change to p
**
** @retval		RTK_OK			the PCR has changed successfully.
** @retval		RTK_Fail 			parameters error occurred or PCR change failed.
**
*/

RTK_Error RTK_Player_ChangePCR(RTK_Player player, uint16_t pcr_pid)
{
	return RHAL_GetHalInstance()->Player_ChangePCR(player, pcr_pid);
}

/**
** @brief
** changes audio pid, audio codec type, then play back the audio
**
** @param[in]		player		 	handle of player to change audio configuration
** @param[in]		audio		 	pointer to a prepared RTK_AudioConfig object
**
** @retval		RTK_OK			change audio and play successfully.
** @retval		RTK_Fail 			parameter input error such as player or audio equals NULL.
**
*/
RTK_Error RTK_Player_ChangeAudio(RTK_Player player, RTK_AudioConfig * audio)
{
	return RHAL_GetHalInstance()->Player_ChangeAudio(player, audio);
}

/** @brief
** @brief
** changes each track audio PID, codec type, then plays back the multi-audio
**
** @param[in]           player                  handle of player to change audio configuration
** @param[in]           audio                   pointer to an Array of RTK_AudioConfig object
** @param[in]           count                   the amount number of audio track
**
** @retval              RTK_OK                  change audio and play successfully.
** @retval              RTK_Fail                        parameter input error such as player or audio equals NULL.
**
*/
RTK_Error RTK_Player_ChangeAudioEx(RTK_Player player, RTK_AudioConfig **audio, uint8_t count)
{
	return RHAL_GetHalInstance()->Player_ChangeAudioEx(player, audio, count);
}


/**
** @brief
** changes video PID, video codec type, then play back the audio
**
** @param[in]		player		 	handle of player to deal with	
** @param[in]		video 	 		defines video PID, codec type, a flag indicate PID stream 
**									is encrypted or not, Video window type
**
** @retval		RTK_OK			change video and play successfully.
** @retval		RTK_Fail 			parameters error such as player or audio equals NULL
**
*/
RTK_Error RTK_Player_ChangeVideo(RTK_Player player, RTK_VideoConfig * video)
{
	return RHAL_GetHalInstance()->Player_ChangeVideo(player, video);
}

/*
 * Memory input
 */
 /**
** @brief
**applys a buffer from share memory for reserving TS data
**
**if apply successfully ,return the buffer information back, this information includes the pointer of share  
**memory, the total size of memory, the used size ,and a flag to judge whether there is memory left
**
** @param[in]		player		 	handle of player to deal with
** @param[out]		buffer 			define input buffer viraddr, size, filled_size, Islast
**
** @retval		RTK_OK			got the buffer information successfully
** @retval		RTK_Fail 			parameters error occurred or share buff has full
**
*/
RTK_Error RTK_Player_GetInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Player_GetInputBuffer(player, buffer);
}

RTK_Error RTK_Player_GetInputInfoBuffer(RTK_Player player, unsigned char **ppInfoBuf, unsigned int *pInfoBufSize)
{
    return RHAL_GetHalInstance()->Player_GetInputInfoBuffer(player, ppInfoBuf, pInfoBufSize);
}

RTK_Error RTK_Player_DecryptResetOffset(RTK_Player player, uint64_t ofs)
{
	return RHAL_GetHalInstance()->Player_DecryptResetOffset(player, ofs);
}

RTK_Error RTK_Player_WaitDataGone(RTK_Player player, int32_t timeOut_MS)
{
    return RHAL_GetHalInstance()->Player_WaitDataGone(player, timeOut_MS);
}

RTK_Error RTK_Player_InputRedirect(RTK_Player player, bool isEnable, RTK_Demux redirect_from)
{
	return RHAL_GetHalInstance()->Player_InputRedirect(player, isEnable, redirect_from);
}

/**
** @brief
**feeds some TS data used for playing in input_buffer
**
** @param[in]		player		 	handle of player to reserve play data and share memory information
** @param[in]		buffer 			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			_xFeedInputBuffer has successfully processed.
** @retval		RTK_Fail 			parameters error occurred or file size not packet align
**
*/
RTK_Error RTK_Player_FeedInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Player_FeedInputBuffer(player, buffer);
}

/**
** @brief
** discards input buffer
**
** @param[in]		player		 	handle of player 
** @param[out]		buffer 			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			_xDiscardInputBuffer has successfully processed
** @retval		RTK_Fail 			parameters error occurred or doesn't get buffer first
**
*/
RTK_Error RTK_Player_DiscardInputBuffer(RTK_Player player, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Player_DiscardInputBuffer(player, buffer);
}

/**
   * @brief
   * Set input buffer align.
   *
   * @param[in]		player		 	handle of player. 
   * @param[in]		align 			byte align.(if set zero, align not required)
   *
   * @retval		RTK_OK			successful
   * @retval		RTK_Fail 			failed
   *
   */
RTK_Error RTK_Player_SetInputBufferAlign(RTK_Player player, uint32_t align)
{
	return RHAL_GetHalInstance()->Player_SetInputBufferAlign(player, align);
}

/**
** @brief
** sets AV_sync_mode of a specific player
**
** @param[in]		player		 	handle of player 
** @param[in]		AvSyncMode 		avsync type
**
** @retval		RTK_OK			set the avsync mode successfully.
** @retval		RTK_Fail 			parameters error occurred or rtk_porting_av_set_AV_sync_mode 
**								return error.
**
*/
RTK_Error RTK_Player_SetAVSyncMode(RTK_Player player, RTK_AVsyncMode AvSyncMode)
{
	return RHAL_GetHalInstance()->Player_SetAVSyncMode(player, AvSyncMode);
}

/**
   * @brief
   * sets SLOW AV SYNC of a specific player
   *
   * @param[in]		player		 	handle of player 
   * @param[in]		enable 		true or false
   *
   * @retval		RTK_OK			enable successfully.
   * @retval		RTK_Fail 			parameters error occurred or RTK_Player_SetSlowAvSync 
   *								return error.
   *
   */
#if 0   
RTK_Error RTK_Player_SetSlowAvSync(RTK_Player player, RTK_Bool enable)
{
	return RHAL_GetHalInstance()->Player_SetSlowAvSync(player, enable);

}
#endif

RTK_Error RTK_Player_GetScrambleStatus(RTK_Player player, RTK_Bool* isScramble)
{
	return RHAL_GetHalInstance()->Player_GetScrambleStatus(player, isScramble);

}

/**
** @brief
** sets the video surface of the upper player
**
** @param[in]		player		 	handle of player to clear data buffer
** @param[in]		nativeWindow 	pointer to a ANativeWindow object
**
** @retval		RTK_OK			player successfully connect to a video surface
** @retval		RTK_Fail 			NATIVE_WINDOW_API_DISCONNECT status occurs in nativeWindow. 
**
*/
#ifdef ANDROID
void * RTK_Player_GetSidebandHandle(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_GetSidebandHandle(player);
}
#endif

/**
** @brief
** sets the speed of play
**
** @param[in]		player		 	handle of player to deal with	
** @param[in]		speed 	 		multiplier factor of change
**
** @retval		RTK_OK			the play speed has changed successfully.
** @retval		RTK_Fail 			parameters error occurred or the play speed change failed.
**
*/
RTK_Error RTK_Player_SetPlaySpeed(RTK_Player player, float speed)
{
	return RHAL_GetHalInstance()->Player_SetPlaySpeed(player, speed);
}

/**
** @brief
** gets play speed of current
**
** @param[in]		player		 	handle of player to deal with	
** @param[out]		speed 	 		get the multiplier factor of current paly speed 
**
** @retval		RTK_OK			the play speed has got successfully
** @retval		RTK_Fail 			parameters error occurred or play speed get failed.
**
*/
RTK_Error RTK_Player_GetPlaySpeed(RTK_Player player, float * speed)
{
	return RHAL_GetHalInstance()->Player_GetPlaySpeed(player, speed);
}

/**
** @brief
** gets the current displaying frame's pts
**
** @param[in]		player		 	handle of player to deal with	
** @param[out]		*_pts 	 		get the current displaying frame's pts
**
** @retval		RTK_OK			the current displaying PTS has got successfully
** @retval		RTK_Fail 			parameters error occurred or PTS get failed
**
*/
RTK_Error RTK_Player_GetCurrentDisplayingPTS(RTK_Player player, uint64_t * _pts)
{
	return RHAL_GetHalInstance()->Player_GetCurrentDisplayingPTS(player, _pts);
}

/**
** @brief
** gets the current displaying frame's video and audio pts
**
** @param[in]		player		handle of player to deal with	
** @param[out]		*pts_info 	get the current displaying frame's video and audio pts
**
** @retval		RTK_OK			the current displaying PTS has got successfully
** @retval		RTK_Fail 		parameters error occurred or PTS get failed
**
*/
RTK_Error RTK_Player_GetCurrentDisplayingPTSInfo(RTK_Player player, RTK_PTSInfo * pts_info)
{
	return RHAL_GetHalInstance()->Player_GetCurrentDisplayingPTSInfo(player, pts_info);
}

/**
** @brief
** sets the player with specific handle video plane visible or not
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		mute 			defines set video mute or not, RTK_FALSE means 
**								set video plane  visible, RTK_TRUE means not.  
**
** @retval		RTK_OK			set the specific player video plane visible mute successfully.
** @retval		RTK_Fail 			parameters error occurred or set mute failed.
**
*/
RTK_Error RTK_Player_SetVideoMute(RTK_Player player, RTK_Bool mute)
{
	return RHAL_GetHalInstance()->Player_SetVideoMute(player, mute);
}

/**
** @brief
** gets a specific player video visible status
**
** @param[in]		player		 	handle of player to deal with
** @param[out]		mute 			the value of video visible status currently	
**
** @retval		RTK_OK			get the specific player video visible status successfully.
** @retval		RTK_Fail 			parameters error occurred or got video visible status failed.
**
*/
RTK_Error RTK_Player_GetVideoMute(RTK_Player player, RTK_Bool * mute)
{
	return RHAL_GetHalInstance()->Player_GetVideoMute(player, mute);
}




/**
** @brief
** send I frame info to dvdplayer when it's in I-frame-only mode
**
** @param[in]		info 			object composed of frame info
**
** @retval		RTK_OK			send info successfully.
** @retval		RTK_Fail 			parameters error occurred or sending info failed.
**
*/
RTK_Error RTK_Player_SendIFrameInfo(RTK_Player player, RTK_IframeOffset_t info)
{
	return RHAL_GetHalInstance()->Player_SendIFrameInfo(player, info);
}


/**
** @brief
** Start DVR record.
**
** @param[in]		player		 	handle of player
**
** @retval		RTK_OK			DVR successfully stared.
** @retval		RTK_Fail 			DVR start failed.
**
*/
RTK_Error RTK_Player_DVRStart(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_DVRStart(player);
}

/**
** @brief
** Stop DVR record.
**
** @param[in]		player		 	handle of player
**
** @retval		RTK_OK			DVR successfully stoped.
** @retval		RTK_Fail 			DVR stop failed.
**
*/
RTK_Error RTK_Player_DVRStop(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_DVRStop(player);
}

/**
* @brief
*  Enable or disable secure play share memory.
*
*  This function should be called once player was created. When player destroy, 
*  the secure share memory will be force released.
*
* @param[in]		player		 	handle of player 
* @param[in]		en 				enable or disable flag
*
* @retval		RTK_OK				successfully processed
* @retval		RTK_Fail 				fail.
*
*/
RTK_Error RTK_Player_EnableSecurePlayShareMem(RTK_Player player, RTK_Bool en)
{
	return RHAL_GetHalInstance()->Player_EnableSecurePlayShareMem(player, en);
}

RTK_Error RTK_Player_SetTrickMode(RTK_Player player, RTK_HAL_avTrickMode_e trickMode)
{
	return RHAL_GetHalInstance()->Player_SetTrickMode(player, trickMode);
}

/*********************************************************************************
* 							Player Interface End 
**********************************************************************************/

//RTKHAL2.0 remove TS demux and EMM demux.
#if 0
/**
** @brief creates EmmDemux.
**
** It creates Demux(or TP) match with demux_number,
** Currently, We MUST always use TP0 as it is globally used in CAS Module(DAL),
** So, customer will always set scrambled parameter to true; RTK_InputType to MEMORY, 
** You need to consider life cycle of TP,
** if(TP has already existed by another module such as RTK_Player, RTK_Demux)
**
** @param[out]		emmdemux		return the EmmDemux handle created by this function
** @param[in]		config 			the configs used when creating the Player
**
** @retval		RTK_OK			create success
** @retval		RTK_Fail 			create fail
**
*/
RTK_Error RTK_EmmDemux_Create(RTK_EmmDemux *emmdemux, RTK_EmmDemuxConfig *config)
{
	return RHAL_GetHalInstance()->EmmDemux_Create(emmdemux, config);
}


/**
** @brief
** destroys the EmmDemux.
**
** It destroys Demux(or TP) match with demux_number 
** EMM Receiving is always turned on which means we'll never call it until STB is turned off. 
** You need to consider life cycle of TP. 
** + if(TP has already existed by another module such as RTK_Player, RTK_Demux) 
**
** @param[in]		emmdemux		the EmmDemux handle.
**
** @retval		RTK_OK			destroy success
** @retval		RTK_Fail 			destroy fail
**
*/
RTK_Error RTK_EmmDemux_Destroy(RTK_EmmDemux emmdemux)
{
	return RHAL_GetHalInstance()->EmmDemux_Destroy(emmdemux);
}

/* Buffer control interfaces for EMM. */
/**
** @brief
** gets a buffer from share memory to reserve TS data
**
** @param[in]		emmdemux		the EmmDemux handle.
** @param[out]		buffer			define input buffer viraddr,size,filled_size,islast 
**
** @retval		RTK_OK			get success
** @retval		RTK_Fail 			get fail
**
*/
RTK_Error RTK_EmmDemux_GetInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->EmmDemux_GetInputBuffer(emmdemux, buffer);
}


/**
** @brief
** feeds TS data to input buffer for play.
**
** @param[in]		emmdemux		the EmmDemux handle.
** @param[in]		buffer			define input buffer viraddr,size,filled_size,islast 
**
** @retval		RTK_OK			feed success
** @retval		RTK_Fail 			feed fail
**
*/
RTK_Error RTK_EmmDemux_FeedInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->EmmDemux_FeedInputBuffer(emmdemux, buffer);
}

/**
** @brief
** discards input buffer.
**
** @param[in]		emmdemux		the EmmDemux handle.
** @param[out]		buffer			define input buffer viraddr,size,filled_size,islast 
**
** @retval		RTK_OK			discard success
** @retval		RTK_Fail 			discard fail
**
*/
RTK_Error RTK_EmmDemux_DiscardInputBuffer(RTK_EmmDemux emmdemux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->EmmDemux_DiscardInputBuffer(emmdemux, buffer);
}


/**
** @brief
** opens and sets sectionFilter by specific PID, add the SectionFilter into SI engine with the emmdemux handle
**
** @param[in]		emmdemux		handle of emmdemux to add section filter
** @param[out]		filter_handle		handle of filter to specify
** @param[in]		pattern			defines filter PID, mask, mode, compose type, monitor mode,
**								user parameter and a function pointer to SI section filter callback
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RTK_EmmDemux_AddSectionFilter(RTK_EmmDemux emmdemux, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	return RHAL_GetHalInstance()->EmmDemux_AddSectionFilter(emmdemux, filter_handle, pattern);
}


/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		emmdemux		handle of emmdemux to deal with
** @param[in]		filter_handle		handle of filter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RTK_EmmDemux_RemoveSectionFilter(RTK_EmmDemux emmdemux, RTK_SectionFilter filter_handle)
{
	return RHAL_GetHalInstance()->EmmDemux_RemoveSectionFilter(emmdemux, filter_handle);
}
#endif

/*********************************************************************************
* 							Demux Interface Begin 
**********************************************************************************/

/**/
//RTKHAL2.0 remove TS demux and EMM demux.
//RTKHAL 2.1 add TS demux.
#if 1
/**
** @brief
** creates Demux for recording
**
** @param[out]		demux			return the Demux handle created by this function
** @param[in]		demux_config 	the configs used when creating the Demux
**
** @retval		RTK_OK			Demux created successfully
** @retval		RTK_Fail 			Demux created fail
**
*/
RTK_Error RTK_Demux_Create(RTK_Demux * demux, RTK_DemuxConfig * demux_config)
{
	RTK_Error ret;
	
	pthread_mutex_lock(&RHAL_Base_mutex);
	ret = RHAL_GetHalInstance()->Demux_Create(demux, demux_config);
	pthread_mutex_unlock(&RHAL_Base_mutex);
	
	return ret;
}

/**
** @brief
** destroys the Demux
**
** @param[in]		demux 	the Demux handle, this handle must be same with the created one
**
** @retval		RTK_OK			RTK_ Demux_Destroy has successfully processed
** @retval		RTK_Fail 			parameters error occurred or _xDestroy return failed.
**
*/
RTK_Error RTK_Demux_Destroy(RTK_Demux demux)
{
	RTK_Error ret;
	
	pthread_mutex_lock(&RHAL_Base_mutex);
	ret = RHAL_GetHalInstance()->Demux_Destroy(demux);
	pthread_mutex_unlock(&RHAL_Base_mutex);

	return ret;
}

/**
** @brief
** lets Demux running
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			RTK_ Demux_Start has successfully processed.
** @retval		RTK_Fail 			parameters error occurred or started the Demux failed.
**
*/
RTK_Error RTK_Demux_Start(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_Start(demux);
}

/**
** @brief
** stops Demux
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			RTK_ Demux_Stop has successfully processed.
** @retval		RTK_Fail 			parameters error occurred or stopped the Demux failed.
**
*/
RTK_Error RTK_Demux_Stop(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_Stop(demux);
}

/**
** @brief
** pause Demux
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			successfully processed.
** @retval		RTK_Fail 			parameters error occurred or stopped the Demux failed.
**
*/
RTK_Error RTK_Demux_Pause(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_Pause(demux);
}

/**
** @brief
** resume Demux
**
** @param[in]		demux 	the Demux handle
**
** @retval		RTK_OK			successfully processed.
** @retval		RTK_Fail 			parameters error occurred or stopped the Demux failed.
**
*/
RTK_Error RTK_Demux_Resume(RTK_Demux demux)	
{
	return RHAL_GetHalInstance()->Demux_Resume(demux);
}

/**
** @brief
** opens and sets sectionFilter by specific pid, add the SectionFilter into SI engine with the demux handle
**
** @param[in]		demux		 handle of demux to add section filter
** @param[out]		filter_handle 	 handle of filter to specify
** @param[in]		pattern		 defines filter pattern,include pid, mask, mode, compose type, monitor mode,and so on
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RTK_Demux_AddSectionFilter(RTK_Demux demux, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	return RHAL_GetHalInstance()->Demux_AddSectionFilter(demux, filter_handle, pattern);
}


/**
** @brief
** stops the sectionFilter, then it should not parse the specific sections
**
** @param[in]		demux		 handle of demux 
** @param[in]		filter_handle 	 handle of filter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RTK_Demux_RemoveSectionFilter(RTK_Demux demux, RTK_SectionFilter filter_handle)
{
	return RHAL_GetHalInstance()->Demux_RemoveSectionFilter(demux, filter_handle);
}

/**
** @brief
** stops all sectionFilters demux added, then sectionFilters will not work 
**
** @param[in]		demux		 handle of demux to deal with
**
** @retval		RTK_OK			remove all success
** @retval		RTK_Fail 			remove all fail
**
*/
RTK_Error RTK_Demux_RemoveAllSectionFilters(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_RemoveAllSectionFilters(demux);
}

/*
 * TS filter
 * 		- These functions can be called multiple times.
 */
 
/**
** @brief
** adds TSFilter for demux
**
** @param[in]		demux		 	handle of demux to add 
** @param[in]		pattern 	 		defines filter pattern ,include pid, encrypted or not, A/V codec types, get PTS and Frame type or not
** @param[out]		filter_handle		handle of filter to specify
**
** @retval		RTK_OK			add success
** @retval		RTK_Fail 			add fail
**
*/
RTK_Error RTK_Demux_AddTSFilter(RTK_Demux demux, RTK_TSFilterPattern * pattern, RTK_TSFilter * filter_handle)
{
	return RHAL_GetHalInstance()->Demux_AddTSFilter(demux, pattern, filter_handle);
}

/**
** @brief
** removes the TSFilter, then it should not parse the specific TS data
**
** @param[in]		demux		 	handle of player to deal with
** @param[in]		filter_handle		handle of TsFilter to stop
**
** @retval		RTK_OK			remove success
** @retval		RTK_Fail 			remove fail
**
*/
RTK_Error RTK_Demux_RemoveTSFilter(RTK_Demux demux, RTK_TSFilter filter_handle)
{
	return RHAL_GetHalInstance()->Demux_RemoveTSFilter(demux, filter_handle);
}

/**
** @brief
** stops all TSFilter demux added, then TSFilter will not work 
**
** @param[in]		demux		 	handle of player to deal with
**
** @retval		RTK_OK			remove all success
** @retval		RTK_Fail 			remove all fail
**
*/
RTK_Error RTK_Demux_RemoveAllTSFilters(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_RemoveAllTSFilters(demux);
}

/**
** @brief
** Set the ts data buffer type of the TS Filter callback.
**
** This function must be called before RTK_Demux_Start and RTK_Demux_AddTSFilter.
**
** @param[in]		demux		 	handle of player to deal with
** @param[in]		isSecureBuf		secure buffer flag.

**
** @retval		RTK_OK			success
** @retval		RTK_Fail 			fail
**
*/
RTK_Error RTK_Demux_EnableTSFilterSecurebuf(RTK_Demux demux, RTK_Bool isSecureBuf)
{
	return RHAL_GetHalInstance()->Demux_EnableTSFilterSecurebuf(demux, isSecureBuf);
}

/**
   * @brief
   * Reset TS filter parser.
   *
   * After this operation, the TS Filter Parser will be reset to the init state. It mean all the 
   * TS callback buffer will be reset, include pts, frames...
   *
   * @param[in]      demux		 	handle of player to deal with
   *
   * @retval		RTK_OK			success
   * @retval		RTK_Fail 			fail
   *
   */
RTK_Error RTK_Demux_ResetTSFilterParser(RTK_Demux demux)
{
	return RHAL_GetHalInstance()->Demux_ResetTSFilterParser(demux);
}

/*
 * Memory input
 */
 
/**
** @brief
** gets a buffer from share memory to reserve TS data
**
** @param[in]		demux		 	handle of player to deal with
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			get success
** @retval		RTK_Fail 			get fail
**
*/
RTK_Error RTK_Demux_GetInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Demux_GetInputBuffer(demux, buffer);
}

/**
** @brief
** feeds TS data to input buffer for play
**
** @param[in]		demux		 	handle of player to reserve play data and share memory information
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			feed success
** @retval		RTK_Fail 			feed fail
**
*/
RTK_Error RTK_Demux_FeedInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Demux_FeedInputBuffer(demux, buffer);
}

/**
** @brief
** discards input buffer
**
** @param[in]		demux		 	handle of player to deal with
** @param[out]		buffer			define input buffer viraddr, size, filled_size, islast
**
** @retval		RTK_OK			 discard success
** @retval		RTK_Fail 			 discard fail
**
*/
RTK_Error RTK_Demux_DiscardInputBuffer(RTK_Demux demux, RTK_TSInputBuffer * buffer)
{
	return RHAL_GetHalInstance()->Demux_DiscardInputBuffer(demux, buffer);
}

/*
 * In-band PES filter for DVB subtitle
 */

/**
  * @brief
  * This function add PES filter and parse the PES data through callback function.
  *
  * @param[in] demux		   handle of demux to add PES filter
  * @param[in] pattern		   defines filter pid,filterID, callback function
  *
  * @retval 	   RTK_OK		   AddPESFilter has successfully processed
  * @retval 	   RTK_Fail 		   parameters error occurred or add filter failed
  *
  */
RTK_Error RTK_Demux_AddPESFilter(RTK_Demux demux, RTK_PESFilterPattern * pattern)
{
	RTKHAL_INF("[%s]:demux%p,  pattern=%p\n", __FUNCTION__, demux, pattern);
	return RHAL_GetHalInstance()->Demux_AddPESFilter(demux, pattern);
}

/**
   * @brief
   * removes the PESFilter, then it should not parse the specific PES data
   *
   * @param[in]	demux		 	  handle of demux to deal with
   * @param[in] u8FilterID         only support filter ID 0x00 or x001 now
   *
   * @retval		RTK_OK			PES filter has been stopped parsing with specific filter_handle successfully
   * @retval		RTK_Fail 			parameters error occurred or ts filter remove failed
   *
   */
RTK_Error RTK_Demux_RemovePESFilter(RTK_Demux demux, uint8_t u8FilterID)
{
	RTKHAL_INF("[%s]:demux=%p, u8FilterID=0x%x\n", __FUNCTION__, demux,u8FilterID);
	return RHAL_GetHalInstance()->Demux_RemovePESFilter(demux, u8FilterID);
}


/**
   * @brief
   * This function will add subtitle to the player.
   *
   * @param[in]	demux		         handle of demux to deal with
   * @param[in]	ptrSubtitleTrackInfo  the subtitle information  
   *
   * @retval		RTK_OK	                 add subtitle to the player ok
   * @retval		RTK_Fail 	                 add subtitle to the player failed
   *
   */
RTK_Error RTK_Demux_SetSubtitle(RTK_Demux demux, RTK_SubtitleConfig ptrSubtitleTrackInfo)
{
	RTKHAL_INF("[%s]:demux=%p\n", __FUNCTION__, demux);
	return RHAL_GetHalInstance()->Demux_SetSubtitle(demux, ptrSubtitleTrackInfo);
}

#endif

/*********************************************************************************
* 							Demux Interface End 
**********************************************************************************/

  /**
** @brief
**[]set audio volume;          
** @param[in]			i32volume			the volume value to set, range:0~31    
**0=> Manimum , 31=> is Maxmum
** @retval			void
*/

void RTK_audio_SetVolume(uint32_t i32volume)
{
	 RHAL_GetHalInstance()->Player_SetAudioVolume(i32volume);
	 return;
}

void RTK_audio_GetVolume(uint32_t* i32volume)
{
	 RHAL_GetHalInstance()->Player_GetAudioVolume(i32volume);
	 return;
	
}

/**
   * @brief
   * sets the player with specific handle audio mute.
   *
   * NOT system wide mute, just for player. (used while trick playing)
   *
   * @param[in]		player		handle of player to deal with
   * @param[in]		mute 		defines set audio mute or not, RTK_FALSE 
   *								means not , RTK_TRUE means set mute
   *
   * @retval		RTK_OK			set the specific player mute successfully.
   * @retval		RTK_ERR 		parameters error occurred or set mute failed.
   *
   */
RTK_Error RTK_Player_SetAudioMute(RTK_Player player, RTK_Bool mute)
{
 return RHAL_GetHalInstance()->Player_SetAudioMute(player, mute);
}

/**
   * @brief
   * gets a specific player audio mute status
   *
   * @param[in]		player		 	handle of player to deal with
   * @param[out]		mute_status 		get the value of audio mute status currently,
   *								RTK_FALSE means not mute, RTK_TRUE means mute 
   *
   * @retval		RTK_OK			get the specific player mute status successfully.
   * @retval		RTK_ERR 			parameters error occurred or got mute status failed. 
   *
   */
RTK_Error RTK_Player_GetAudioMute(RTK_Player player, RTK_Bool * mute)
{
	return RHAL_GetHalInstance()->Player_GetAudioMute(player, mute);
}

/**
   * @brief
   * Get Ts data input bitrate which calculated with PCR info.
   *
   * @param[in]		player		 	handle of player to deal with
   * @param[out]	pullBitrate 	pointer of the variable witch will store the result.
   *
   * @retval		RTK_OK			success.
   * @retval		RTK_ERR 		failed. 
   *
   */
RTK_Error RTK_Player_GetTsInputBitrate(RTK_Player player, UINT64_T* pullBitrate)
{
	return RHAL_GetHalInstance()->Player_GetTsInputBitrate(player, pullBitrate);
}

/*********************************************************************************
* 							Tuner Interface Begin 
**********************************************************************************/

RTK_Error RTK_Tuner_Init(void)
{
    return RHAL_GetHalInstance()->TunerInit();
}

RTK_Error RTK_Tuner_UnInit(void)
{
    return RHAL_GetHalInstance()->TunerUnInit();
}



RTK_Error RTK_Tuner_GetInfo(uint8_t ucTunerID, RTK_TunerInfo *info)
{
    return RHAL_GetHalInstance()->TunerGetInfo(ucTunerID, info);
}

RTK_Error RTK_Tuner_IsLocked(uint8_t ucTunerID)
{
    return RHAL_GetHalInstance()->TunerIsLock(ucTunerID);
}

/*********************************************************************************
* 							Tuner Interface Eed 
**********************************************************************************/


/*********************************************************************************
* 							Other Interface Begin 
**********************************************************************************/

RTK_Error RTK_CreateSurface(RTK_WinConfig win_cfg)
{   
	return RHAL_GetHalInstance()->CreateSurface(win_cfg); 
}

RTK_Error RTK_DestorySurface(RTK_WinPlane plane)
{   
	return RHAL_GetHalInstance()->DestorySurface(plane);
}

/**
   * @brief
   * This function will set spdif output mode.
   *
   * @param[in]	outputMode	     specified spdif output mode,such as off,raw and lpcm mode.
   * 
   * @retval		RTK_OK		    set the spdif output mode successfully.
   * @retval		RTK_Fail 		    set the spdif output mode failed
   *
   */
RTK_Error RTK_Set_Spdif_Output_Mode(Hal_Spdif_Mode_e outputMode)
{
	return RHAL_GetHalInstance()->System_Set_Spdif_Output_Mode(outputMode);
}

/**
   * @brief
   * This function will get spdif output mode.
   *
   * @param[out]	outputMode	    return spdif output mode,such as off,raw and lpcm mode.
   * 
   * @retval		RTK_OK		    get the spdif output mode successfully.
   * @retval		RTK_Fail 		    get the spdif output mode failed
   *
   */
RTK_Error RTK_Get_Spdif_Output_Mode(Hal_Spdif_Mode_e* outputMode)
{
	return RHAL_GetHalInstance()->System_Get_Spdif_Output_Mode(outputMode);
}

/**
   * @brief
   * This function will set hdmi output mode.
   *
   * @param[in]	e_mode	    specified hdmi output mode,such as off,raw and lpcm mode.
   * 
   * @retval		RTK_OK		    set the spdif output mode successfully.
   * @retval		RTK_Fail 		    set the spdif output mode failed
   *
   */
RTK_Error RTK_Set_Hdmi_Output_Mode(Hal_Hdmi_Mode_e outputMode)
{
	return RHAL_GetHalInstance()->System_Set_Hdmi_Output_Mode(outputMode);
}

/**
   * @brief
   * This function will get hdmi output mode.
   *
   * @param[out]	outputMode	    return hdmi output mode,such as raw, lpcm and auto mode.
   * 
   * @retval		RTK_OK		    get the hdmi output mode successfully.
   * @retval		RTK_Fail 		    get the hdmi output mode failed
   *
   */
RTK_Error RTK_Get_Hdmi_Output_Mode(Hal_Hdmi_Mode_e* outputMode)
{
	return RHAL_GetHalInstance()->System_Get_Hdmi_Output_Mode(outputMode);
}

/**
   * @brief
   * This function will set the audio output mode.
   *
   * @param[in]	ch_output_mode	    a enumeration type value to indicate audio output mode.
   *
   * @retval		RTK_OK		           Set Audio OutputMode successfully.
   * @retval		RTK_ERR 		    Set Audio OutputMode is not support.
   *
   */
RTK_Error RTK_SetAudioOutputMode(Hal_Audio_Output_Mode_e ch_output_mode)
{
	return RHAL_GetHalInstance()->System_SetAudioOutputMode(ch_output_mode);	
}

/*
 * In-band PES filter for DVB subtitle
 */

/**
  * @brief
  * This function add PES filter and parse the PES data through callback function.
  *
  * @param[in] player		   handle of player to add PES filter
  * @param[in] pattern		   defines filter pid,filterID, callback function
  *
  * @retval 	   RTK_OK		   AddPESFilter has successfully processed
  * @retval 	   RTK_Fail 		   parameters error occurred or add filter failed
  *
  */
RTK_Error RTK_Player_AddPESFilter(RTK_Player player, RTK_PESFilterPattern * pattern)
{
	RTKHAL_INF("[%s]:player=%p,  pattern=%p\n", __FUNCTION__, player, pattern);
	return RHAL_GetHalInstance()->Player_AddPESFilter(player, pattern);
}

/**
   * @brief
   * removes the PESFilter, then it should not parse the specific PES data
   *
   * @param[in]	player		 	  handle of player to deal with
   * @param[in] u8FilterID         only support filter ID 0x00 or x001 now
   *
   * @retval		RTK_OK			PES filter has been stopped parsing with specific filter_handle successfully
   * @retval		RTK_Fail 			parameters error occurred or ts filter remove failed
   *
   */
RTK_Error RTK_Player_RemovePESFilter(RTK_Player player, uint8_t u8FilterID)
{
	RTKHAL_INF("[%s]:player=%p, u8FilterID=0x%x\n", __FUNCTION__, player,u8FilterID);
	return RHAL_GetHalInstance()->Player_RemovePESFilter(player, u8FilterID);
}


/**
   * @brief
   * This function will add subtitle to the player.
   *
   * @param[in]	player		         handle of player to deal with
   * @param[in]	ptrSubtitleTrackInfo  the subtitle information  
   *
   * @retval		RTK_OK	                 add subtitle to the player ok
   * @retval		RTK_Fail 	                 add subtitle to the player failed
   *
   */
RTK_Error RTK_Player_SetSubtitle(RTK_Player player, RTK_SubtitleConfig ptrSubtitleTrackInfo)
{
	RTKHAL_INF("[%s]:player=%p\n", __FUNCTION__, player);
	return RHAL_GetHalInstance()->Player_SetSubtitle(player, ptrSubtitleTrackInfo);
}


/**
   * @brief
   * This function will remove subtitle from the player.
   *
   * @param[in] player				 handle of player to deal with
   *
   * @retval		RTK_OK					 add subtitle to the player ok
   * @retval		RTK_Fail					 add subtitle to the player failed
   *
   */
RTK_Error RTK_Player_RemoveSubtitle(RTK_Player player)
{
	RTKHAL_INF("[%s]:player=%p\n", __FUNCTION__, player);
	return RHAL_GetHalInstance()->Player_RemoveSubtitle(player);
}

/**
   * @brief
   * This function will set ErrorConcealLevel of a specific player
   *
   * @param[in] 	player			handle of player 
   * @param[in] 	level			conceallLevel want to be set, Value from 0 to 4096
   * @param[in] 	delayTime		after delay time(in milliseconds)will apply error concelment level,
   *								0 means run immediately 
   *
   * @retval		RTK_OK			set the ErrorConcealLevel successfully.
   * @retval		RTK_Fail			rtk_porting_av_set_error_conceal_level return error or parameters
   *								error occurred.
   *
   */
RTK_Error RTK_Player_SetErrorConcealLevel(RTK_Player player, uint32_t level, uint32_t delayTime)
{
	return RHAL_GetHalInstance()->Player_SetErrorConcealLevel(player, level,delayTime);
}

/**
* @brief
* Set video show mode when video changed. And this mode will force inactive when RTK_Player_Stop called.
*
* @param[in]		player 		handle of player to deal with
* @param[in]		mode 		video show mode.
*
* @retval		RTK_OK			success.
* @retval		RTK_Fail 		failed.
*
*/
RTK_Error RTK_Player_SetShowMode_OnVideoChanged(RTK_Player player, RTK_VideoShowMode_OnChanged_e mode)
{
	return RHAL_GetHalInstance()->Player_SetShowMode_OnVideoChanged(player, mode);
}


/**
* @brief
* This function initialise all the resource used in RTK HAL.
*
* @retval		RTK_OK	    initialise success.             
* @retval		RTK_Fail 	initialise failed.                
*
*/
RTK_Error RTK_initialize(void)
{
	RTK_Error ret;
	
	pthread_mutex_lock(&RHAL_Base_mutex);
	ret = RHAL_GetHalInstance()->m_halInitSuccess; 	
	pthread_mutex_unlock(&RHAL_Base_mutex);

	return ret;
}

/**
* @brief
* This function finalize all the resource used in RTK HAL.
*
* @retval		RTK_OK	     finalize success.            
* @retval		RTK_Fail 	 finalize failed.   
*
*/
RTK_Error RTK_finalize(void)
{
	pthread_mutex_lock(&RHAL_Base_mutex);
	RHAL_HalInstanceCleanup();
	pthread_mutex_unlock(&RHAL_Base_mutex);
	
	return RTK_OK;
}

/**
* @brief
* This function provide a methord to config DVB resource.
*
* @param[in]	pConfig	     DVB resource config
* 
* @retval		RTK_OK	     finalize success.            
* @retval		RTK_Fail 	 finalize failed.   
*
*/
RTK_Error RTK_DvbResourceConfig(RTK_DvbResourceConfig_t *pConfig)
{
	return RHAL_GetHalInstance()->DvbResourceConfig(pConfig);
}


/**
* @brief
* Set Secure Meida Path enable or disable.
*
* @param[in]	channel_id	     DVB channel id, it normally mean the decoder id.
* @param[in]	enable	     	 when enable is RTK_TRUE, it mean SMP enabled.
*
* 
* @retval		RTK_OK	     success.            
* @retval		RTK_Fail 	 failed.   
*
*/
RTK_Error RTK_DvbSetSMP(uint32_t channel_id, RTK_Bool enable)
{
	return RHAL_GetHalInstance()->DvbSetSMP(channel_id, enable);
}

/**
* @brief
* Get Secure Meida Path enable or disable.
*
* @param[in]	channel_id	  DVB channel id, it normally mean the decoder id.
* 
* @retval		RTK_TRUE	  SMP is enabled.            
* @retval		RTK_FALSE 	 SMP is disabled.   
*
*/
RTK_Bool RTK_DvbGetSMP(uint32_t channel_id)
{
	return RHAL_GetHalInstance()->DvbGetSMP(channel_id);
}


/*********************************************************************************
* 							Other Interface End 
**********************************************************************************/

/**
** @brief
** enable ccDecoder in order to create cc thread in unittest to get ccdata and deal cc data through player callback
**
** @param[in]		player		 	handle of player to deal with
**
** @retval		RTK_OK			enable transporting cc data  to player callback  successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/

RTK_Error RTK_Player_EnableCCDecoder(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_EnableCCDecoder(player);

}

/**
** @brief
** get ccdata from player. 
**
** @param[in]		player		 	handle of player to deal with
** @param[out]		pCCData		 	handle of cc data
** @param[out]		pLen		 	handle of cc data length of cc data -- note:0 means no data
**
** @retval		RTK_OK			
** @retval		RTK_Fail 	    
**
*/

RTK_Error RTK_Player_GetCCData(RTK_Player player,unsigned char** pCCData,unsigned int* pLen)
{
	return RHAL_GetHalInstance()->Player_GetCCData(player,pCCData,pLen);
}

/**
** @brief
** disable ccDecoder in order to destroy cc thread , notice DvdPlayer to stop read and transport ccdata out.
**
** @param[in]		player		 	handle of player to deal with
**
** @retval		RTK_OK			disable  transporting cc data successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/
RTK_Error RTK_Player_DisableCCDecoder(RTK_Player player)
{
	return RHAL_GetHalInstance()->Player_DisableCCDecoder(player);

}

/**
** @brief
** This function control ccdata whether to show with special channel number.
** When bEnable is true, it will create playback cc thread, false will disable playback cc thread.
** Playback cc thread will check the index and whether ccdata is changed to decide show or not.
** If bEnable is true and index is correct, playback cc thread will be created and the cc can be shown. 
** If bEnable is true and index is error, playback cc thread will be created and the cc cann't be shown. 
** If bEnable is false,playback cc thread will be destroyed and the cc cann't be shown,whether index is correct.
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		bEnable		 	true to enable show,false to disable show
** @param[in]		index		 	begin with 0, lower than ccStreamNum
**
** @retval		RTK_OK			to set cc show status successfully.
** @retval		RTK_Fail 			parameters error such as player equals NULL
**
*/
RTK_Error RTK_Player_SetCCPlayback(RTK_Player player,bool bEnable,int index)
{
	return RHAL_GetHalInstance()->Player_SetCCPlayback(player,bEnable,index);
}
/**
** @brief
** This function to get cc information,such as stream number,ccType index and ccType String.
** Here eight cc streams are supported,you can get how many cc stream in the video with this function.
** This functio can tell you whether there are ccdata according to info->ccStreamNum.
** If info->ccStreamNum is 0,there is no cc data.
** If info->ccStreamNum is larger than 0,you can use Player_SetCCPlayback to show it.
** you can get ccType string from  info->ccTypeString[i],i is from 0 to ccStreamNum-1
**
** @param[in]		player		handle of player to deal with
** @param[out]		info		 	pointer to struct RTK_ClosedCaption_Param with cc information
**
** @retval		RTK_OK			get cc information successfully.
** @retval		RTK_Fail 			get cc information fail
**
*/
RTK_Error RTK_Player_GetCCInfo(RTK_Player player,RTK_ClosedCaption_Param_t* info)
{
	return RHAL_GetHalInstance()->Player_GetCCInfo(player,info);
}

/**
** @brief
** Audio behind or early video output
**
** @param[in]		delayInMs			delay ms (+3000 ~ -3000)
**
**
*/
void RTK_SetHdmiOutVSDBDelay(int delayInMs)
{
	return RHAL_GetHalInstance()->SetHdmiOutVSDBDelay(delayInMs);
}


void RTK_SetAudioHdmiDelay(bool enable,int delayInMs)
{
    char isEnable = enable?1:0;
    return RHAL_GetHalInstance()->SetAudioHdmiDelay(isEnable,delayInMs);
}


/**
* @brief
*  Get TP buffer status.
*
* @param[in]		player		 	handle of player 
* @param[out]		pFreeSize 		buffer free size.
* @param[out]		pDataSize 		the size of data in buffer.
*
* @retval		RTK_OK				successfully processed
* @retval		RTK_Fail 			fail.
*
*/
RTK_Error RTK_Player_GetTPBufferStatus(RTK_Player player, uint32_t* pFreeSize, uint32_t *pDataSize)
{
	return RHAL_GetHalInstance()->Player_GetTPBufferStatus(player, pFreeSize, pDataSize);
}

/**
* @brief
*  Feed DMA buffer into player.
*
* @param[in]		player		 	handle of player 
* @param[in]		phyaddr 		DMA buffer physical address.
* @param[in]		size 			feed size.
* @param[in]		timeout 		wait timeout(millisecond)	
* @param[in]		is_last 		imply EOS
*
* @retval		RTK_OK				successfully processed
* @retval		RTK_Fail 			fail or timeout.
*
*/
RTK_Error RTK_Player_FeedDMABuffer(RTK_Player player, uint32_t phyaddr, uint32_t size, uint32_t timeout, bool is_last)
{
	return RHAL_GetHalInstance()->Player_FeedDMABuffer(player, phyaddr, size, timeout, is_last);
}

/**
* @brief 
* This function will get the tuner chip id.
*
* @param[in]    tunerid               tuner ID
* @param[out]    *pDevicechipid        tuner chipid
* @retval        RTK_OK            the tuner chipid is got.
* @retval        RTK_Fail             the tuner chipid get fail.
*
*/

RTK_Error RTK_Tuner_GetDeviceChipid(uint32_t uiTunerID,uint8_t * pDevicechipid)
{
    return RHAL_GetHalInstance()->Tuner_GetDeviceChipid(uiTunerID, pDevicechipid);   
}

/**
* @brief
* Feed element stream into es buffer.
*
* @param[in]		player		 	handle of player 
* @param[in]		buffer 			element stream input buffer.
* @param[in]		timeout 		feed timeout.(millisecond)
*
* @retval		RTK_OK			_xDiscardInputBuffer has successfully processed
* @retval		RTK_Fail 			parameters error occurred or doesn't get buffer first
*
*/
RTK_Error RTK_Player_FeedEsInputBuffer(RTK_Player player, RTK_EsInputBuf_t *buffer, int32_t timeout)
{
	return RHAL_GetHalInstance()->Player_FeedEsInputBuffer(player, buffer, timeout);  	
}

// 

/**
* @brief
* Set frequency for multi channel-tuner.
*
* @param[in]		tunerid		       tuner id
* @param[out]		MultiCH_param      multich tuner paramters.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/
#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V1)  
RTK_Error RTK_Tuner_Multich_SetFreq(int tunerid, RTKMultiCH_Param_t MultiCH_param)
{
#ifdef CLIENT_DTVSOURCE
	RTKHAL_ERR("enable DTVSOURCE should not call this function\n");
	return RTK_Fail;
#endif
	return RHAL_GetHalInstance()->Tuner_Multich_SetFreq(tunerid, MultiCH_param);
}

/**
* @brief
* Get tuner signal info in multi channel mode. For FCC V2
*
* @param[in]		tunerid			tuner ID
* @param[in]		ucProgID		program ID
* @param[out]		pInfo			result tuner info
*
* @retval		RTK_OK			
* @retval		RTK_Fail		
*
*/
RTK_Error RTK_Tuner_Multich_GetSignalInfo(int tunerid, UINT8_T ucProgID, RTK_TunerInfo * pInfo)
{
#ifdef CLIENT_DTVSOURCE
	RTKHAL_ERR("enable DTVSOURCE should not call this function\n");
	return RTK_Fail;
#endif
	return RHAL_GetHalInstance()->Tuner_Multich_GetSignalInfo(tunerid, ucProgID, pInfo);
}

/**
* @brief
* Set PID filters for multich tp, this function only for FCC. 
*
* @param[in]		player		       tuner id
* @param[in]		MultiCHPID_param   the PID parameters to set into multich tp.
* @param[in]		channel_count      indicate the count of multi channel PID parameter.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/	
RTK_Error RTK_Player_SetMultiPIDFilters(RTK_Player player, RTKMultich_Pids_t* MultiCHPID_param,int channel_count)
{
#ifdef CLIENT_DTVSOURCE
	RTKHAL_ERR("enable DTVSOURCE should not call this function\n");
	return RTK_Fail;
#endif
	return RHAL_GetHalInstance()->Player_SetMultiPIDFilters(player, MultiCHPID_param, channel_count);
}

/**
** @brief
** changes multi-channel's program(source)
**
** @param[in]		player		 	handle of player to deal with
** @param[in]		program_id 	 	program id
**
** @retval		RTK_OK				change program id successfully.
** @retval		RTK_Fail 			parameters error such as player or audio equals NULL
**
*/
RTK_Error RTK_Player_ChangeProgram(RTK_Player player, UINT8_T program_id)
{
#ifdef CLIENT_DTVSOURCE
	RTKHAL_ERR("enable DTVSOURCE should not call this function\n");
	return RTK_Fail;
#endif
	return RHAL_GetHalInstance()->Player_ChangeProgram(player, program_id);
}

#endif //(RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V1)

RTK_Error RTK_Player_EnableKeepLastFrameForChangeChannel(RTK_Player player, RTK_Bool enable)
{
    return RHAL_GetHalInstance()->Player_EnableKeepLastFrameForChangeChannel(player, enable);
}

/**
* @brief
* Fast change video and audio, this function only for FCC. 
*
* @param[in]		player		player handle
* @param[in]		pVideo   	a pointer of video config.
* @param[in]		pAudio      a pointer of audio config.
*
* @retval		RTK_OK			
* @retval		RTK_Fail 		
*
*/
RTK_Error RTK_Player_ChangeChannel(RTK_Player player, RTK_VideoConfig *pVideo, RTK_AudioConfig *pAudio)
{
	return RHAL_GetHalInstance()->Player_ChangeChannel(player, pVideo, pAudio);
}

/**
** @brief
** Get the transport steam packets infomation after demux.
**
** @param[in]		player		 	handle of player
** @param[out]		pDemuxInfo 	 	A poiner for returned demux info.
**
** @retval		RTK_OK			Get demux info success.
** @retval		RTK_Fail 			Failed.
**
*/
RTK_Error RTK_Player_GetPacketDemuxInfo(RTK_Player player, Hal_Demux_Info_t *pDemuxInfo)
{
	return RHAL_GetHalInstance()->Player_GetPacketDemuxInfo(player, pDemuxInfo);
}

/////

#ifdef ANDROID
/**
** @brief
** This function will sets the video surface of the upper player.
** 
** @param[in]	plane_id		The plane id to deal with, MAIN or PIP on the window to be managed.
** @param[in]	native_window	The pointer to a ANativeWindow object. If it is NULL, it will unset the video surface.
   **
** @retval		RTK_OK			Set Video Surface successfully.
** @retval		RTK_Fail		Error occurred.
**
**/
RTK_Error RTK_SetVideoSurfaceEx(RTK_WinPlane plane_id, void* native_window)
{
	RTKHAL_INF("native_window = %p , plane id = %d\n", native_window, plane_id);

	android::status_t err = android::NO_ERROR;
	RTK_Bool setPlaneV2 = isPlaneV2Set(plane_id);

#if     defined(USE_RTKHAL_IN_ANDROID8)
        const int window_api = NATIVE_WINDOW_API_RTK_SIDEBAND;
#elif   defined(USE_RTKHAL_IN_ANDROID9)
        const int window_api = NATIVE_WINDOW_API_MEDIA;
#elif   defined(USE_RTKHAL_IN_ANDROID10)
        const int window_api = NATIVE_WINDOW_API_MEDIA;
#else
        const int window_api = ((setPlaneV2 == RTK_TRUE)
				? NATIVE_WINDOW_API_RTK_VIDEO2
				: NATIVE_WINDOW_API_RTK_VIDEO);
#endif
	RTKHAL_INF("setv2 %d", setPlaneV2);


	if (g_spNativeWindow[plane_id] != NULL)
	{
		//disconnect the prev ANativeWindow
		err = g_spNativeWindow[plane_id].get()->perform(
			g_spNativeWindow[plane_id].get(), NATIVE_WINDOW_API_DISCONNECT, window_api);
		if (android::NO_ERROR == err)
		{
			RTKHAL_INF("Disconnect the prev ANativeWindow(%p) successfully\n", g_spNativeWindow[plane_id].get());
		}
		else
		{
			RTKHAL_ERR("Return an error when disconnecting the prev ANativeWindow(%p): %s (%d)",
                    g_spNativeWindow[plane_id].get(), strerror(-err), err);
			//return RTK_Fail;
		}
	}
	else
	{
		RTKHAL_INF("NO TARGET TO DISCONNECT!\n");
	}
	g_spNativeWindow[plane_id].clear();


	if (native_window != NULL)
	{
		sp<ANativeWindow>  sp_native_window = (ANativeWindow *)native_window;
		err = sp_native_window.get()->perform(sp_native_window.get(),
		      NATIVE_WINDOW_API_CONNECT, window_api);
		if (err != android::NO_ERROR)
		{
			RTKHAL_ERR("Return an error when connecting the ANativeWindow(%p): %s (%d)",
                    sp_native_window.get(), strerror(-err), err);
			return RTK_Fail;
		}
		else
		{
			RTKHAL_INF("Connect the ANativeWindow(%p)", sp_native_window.get());
		}
	        
#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10)
	    native_handle_t *handle = NULL;
	    SidebandClient::createDvdSBStream(&handle, (int)(plane_id+1)); 
	    err = sp_native_window.get()->perform(sp_native_window.get(), NATIVE_WINDOW_SET_SIDEBAND_STREAM, handle);
	    if (err != android::NO_ERROR)
	    {
	        RTKHAL_ERR("NATIVE_WINDOW_SET_SIDEBAND_STREAM returned an error: %s (%d)\n", strerror(-err), err);
			err = sp_native_window.get()->perform(sp_native_window.get(), NATIVE_WINDOW_API_DISCONNECT, window_api);
			if (err != android::NO_ERROR)
			{
				RTKHAL_ERR("Return an error when connecting the ANativeWindow(%p): %s (%d)",
	                    sp_native_window.get(), strerror(-err), err);
			}
	        return RTK_Fail;
	    }
#endif
		g_spNativeWindow[plane_id] = sp_native_window;
	}

	
	return RTK_OK;
}
#endif


/**
** @brief
** return version string of librtk_halPlayer.so.
** 
** @param[out]	version		    tag info of version.
   **
** @retval		0			success.
** @retval		-1		    failue.
**
**/
int RTK_Player_GetVersion(char version[])
{

#ifndef ENABLE_GLINUX_RTK_PORTING
typedef char * (* func_get_version)(void);

#ifdef EXTERN_FUNC_NAME
    extern char * EXTERN_FUNC_NAME();
    func_get_version p_func_get_version =  EXTERN_FUNC_NAME;
#else    
    extern char * GetGitSha();
    func_get_version p_func_get_version =  GetGitSha;
#endif

    char *raw_info = p_func_get_version();
    if (raw_info == NULL) return -1;
    RTKHAL_INF("%s,raw_info = %s\r\n",__func__,raw_info);
    char * tag = strstr(raw_info,"TAG_");
    if (tag == NULL) return -1;

    char tmp[256]={0};
    memcpy(tmp,tag,strlen(tag));
    RTKHAL_INF("%s,tag = %s\r\n",__func__,tmp);

    char *sub = strtok(tmp,"_");
    while(sub != NULL)
    {
        RTKHAL_INF("%s,sub = %s\r\n",__func__,sub);
        if (sub[0] - 'v' == 0)
        {
            int dot_count=0;
            char tmp1[256]={0};
            memcpy(tmp1,sub,strlen(sub));
            char * dot= strtok(tmp1,".");
            while (dot != NULL)
            {
                RTKHAL_INF("%s,dot = %s\r\n",__func__,dot);
                dot_count+=1;
                dot = strtok(NULL,".");
            }

            RTKHAL_INF("%s,dot_count = %d\r\n",__func__,dot_count);
            if (dot_count == 3)
            {
                int str_len = strlen(sub);
                printf("%s,str_len = %d\r\n",__func__,str_len);
                if (str_len > 0)
                {
                    memcpy(version,sub,str_len);
                    return 1;
                }
            }
        }
        sub = strtok(NULL,"_");
    }
#endif
    return -1;
}


RTK_Error RTK_Player_GetDecodeStatus(RTK_Player player,uint32_t* pGoodDecodedFrmNum, uint32_t* pErrorDecodedFrmNum)
{
    return RHAL_GetHalInstance()->Player_GetDecodeStatus(player,pGoodDecodedFrmNum,pErrorDecodedFrmNum);
}

RTK_Error RTK_Player_GetAudioTrackInfo(RTK_Player player, RTK_Audio_TrackInfo * ptrAudioTrackInfo)
{
	return RHAL_GetHalInstance()->Player_GetAudioTrackInfo(player, ptrAudioTrackInfo);
}

RTK_Error RTK_Player_GetVideoTrackInfo(RTK_Player player, RTK_Video_TrackInfo* ptsVideoTrackInfo)
{
	return RHAL_GetHalInstance()->Player_GetVideoTrackInfo(player,ptsVideoTrackInfo);
}

RTK_Error RTK_Player_GetChannelId(RTK_Player player,unsigned int *p_channelId)
{
	if(player == NULL || p_channelId == NULL)
	{
		RTKHAL_ERR("param error......\n");
		return RTK_Fail;
	}

	HAL_HANDLE_S* halHandle=(HAL_HANDLE_S*)player;	
	*p_channelId = halHandle->channel;
	return RTK_OK;
}

RTK_Error RTK_Player_AddAvEventCallback(RTK_Player player, RTK_HAL_AV_EVENT av_event, RTK_HAL_AV_EVENT_FUNC callback)
{
	return RHAL_GetHalInstance()->Player_AddAvEventCallback(player, av_event, callback);
}

RTK_Error RTK_Player_RemoveAvEventCallback(RTK_Player player, RTK_HAL_AV_EVENT av_event, RTK_HAL_AV_EVENT_FUNC callback)
{
	return RHAL_GetHalInstance()->Player_RemoveAvEventCallback(player, av_event, callback);
}

RTK_Bool RTK_System_VOisUsing(RTK_WinPlane vo_plane)
{
	return RHAL_GetHalInstance()->System_VOisUsing(vo_plane);
}
#endif //(RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V1)

#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2)  
RTK_Error RTK_Demux_SetSource(RTK_Player player, RTK_Source source)
{
    return RHAL_GetHalInstance()->Demux_SetSource(player, source);
}

RTK_Error RTK_Source_Create(RTK_Source* source,RTK_SourceParam_t param)
{
    return RHAL_GetHalInstance()->Source_Create(source, param);
}

RTK_Error RTK_Source_Destroy(RTK_Source source)
{
    return RHAL_GetHalInstance()->Source_Destroy(source);
}

RTK_Error RTK_Source_PresetPidFilter(RTK_Source source, uint16_t* pids, unsigned char numPID)
{
    return RHAL_GetHalInstance()->Source_PresetPidFilter(source, pids, numPID);
}

#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V2)
RTK_Error RTK_Source_SetRfDemod(RTK_Source source, RTK_RfDemodParam_t param)
{
    return RHAL_GetHalInstance()->Source_SetRfDemod(source, param);
}

RTK_Error RTK_Source_GetIsLocked(RTK_Source source)
{
    return RHAL_GetHalInstance()->Source_GetIsLocked(source);
}

RTK_Error RTK_Source_GetSignalInfo(RTK_Source source, RTK_TunerInfo * info)
{
    return RHAL_GetHalInstance()->Source_GetSignalInfo(source, info);
}
#endif //(RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V2)

RTK_Error RTK_Source_GetInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
    return RHAL_GetHalInstance()->Source_GetInputBuffer(source, buffer);
}

RTK_Error RTK_Source_FeedInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
    return RHAL_GetHalInstance()->Source_FeedInputBuffer(source, buffer);
}

RTK_Error RTK_Source_DiscardInputBuffer(RTK_Source source, RTK_TSInputBuffer * buffer)
{
    return RHAL_GetHalInstance()->Source_DiscardInputBuffer(source, buffer);
}

/**
** @brief
**  Flush data in source. 
**
** @param[in]       source    source handle.
**
** @retval          RTK_OK
** @retval          RTK_Fail
**/
RTK_Error RTK_Source_Flush(RTK_Source source)
{
    return RHAL_GetHalInstance()->Source_Flush(source);
}

/**
** @brief
** set source tsid/sidx
**
** @param[in]      source     source handle.
** @param[in]      tsid_sidx  NAGRA tsid or VMX service index or ...
**
** @retval         RTK_OK
** @retval         RTK_Fail
*/
RTK_Error RTK_Source_SetTsidSidx(RTK_Source source, unsigned int tsid_sidx)
{
    return RHAL_GetHalInstance()->Source_SetTsidSidx(source, tsid_sidx);
}

RTK_Error RTK_Source_SetTsidSid_Ex(RTK_Source source, unsigned int tsid_sidx, unsigned char numPID, unsigned short* pPIDs)
{
    return RHAL_GetHalInstance()->Source_SetTsidSid_Ex(source, tsid_sidx,numPID,pPIDs);
}


RTK_Error RTK_Source_SetKeyUpdateMode(unsigned int tsid_sidx,unsigned int is_encrypt,Hal_Key_UpdateMode_e update_mode){
	return RHAL_GetHalInstance()->Source_SetKeyUpdateMode(tsid_sidx,is_encrypt,update_mode);
}

RTK_Error RTK_Player_SetSource(RTK_Player player, RTK_Source source)
{
    return RHAL_GetHalInstance()->Player_SetSource(player, source);
}

RTK_Error RTK_Source_SetRecKey(RTK_Source source, const char* pRecKey, unsigned int length)
{
	return RHAL_GetHalInstance()->Source_SetRecKey(source, pRecKey, length);
}
/**
   * @brief
   * opens and sets sectionFilter by specific pid, add the SectionFilter into SI engine with the source handle
   *
   * @param[in]		source		 	handle of source to add section filter
   * @param[out]		filter_handle 	 	handle of filter to specify
   * @param[in]		pattern			defines filter pid, mask, mode, compose type, monitor mode, 
   *								user param and a function pointer to SI section filter callback
   *
   * @retval		RTK_OK			_xAddSectionFilter has successfully processed
   * @retval		RTK_Fail 			parameters error occurred or filter open failed.
   *
   */
RTK_Error RTK_Source_AddSectionFilter(RTK_Source source, RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
	return RHAL_GetHalInstance()->Source_AddSectionFilter(source, filter_handle, pattern);
}

/**
   * @brief
   * stops the sectionFilter, then it should not parse the specific sections
   *
   * @param[in]		source		 	handle of source 
   * @param[in]		filter_handle 	 	handle of filter to stop
   *
   * @retval		RTK_OK			section filter has been stopped parsing with 
   *								specific filter_handle successfully.
   * @retval		RTK_Fail 			parameters error occurred or SI engine PID 
   *								filter remove failed
   *
   */
RTK_Error RTK_Source_RemoveSectionFilter(RTK_Source source, RTK_SectionFilter filter_handle)
{
	return RHAL_GetHalInstance()->Source_RemoveSectionFilter(source, filter_handle);
}

/**
   * @brief
   * stops all sectionFilters source added, then sectionFilters will not work 
   *
   * @param[in]		source		 	handle of source 
   *
   * @retval		RTK_OK			all section filters have been stopped parsing successfully.
   * @retval		RTK_Fail 			parameters error occurred or SI engine PID filter remove failed.
   *
   */
RTK_Error RTK_Source_RemoveAllSectionFilters(RTK_Source source)
{
	return RHAL_GetHalInstance()->Source_RemoveAllSectionFilters(source);
}

/**
** @brief
** get source idle status
**
** @param[in]      source     source handle.
** @param[out]     is_idle    source is idle or not.
**
** @retval         RTK_OK
** @retval         RTK_Fail
*/
RTK_Error RTK_Source_GetIsIdle(RTK_Source source, RTK_Bool* is_idle)
{
	return RHAL_GetHalInstance()->Source_GetIsIdle(source, is_idle);
}

#endif //(RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2)

#if (RTKPLAYER_ARCH_VER <= RTKPLAYER_ARCH_V2)  
// TODO:: naming not correct -> should replace by RTK_Tuner_Scan()
RTK_Error RTK_Set_TunerScanning(uint32_t uiTunerID,RTK_TunerParam_t param)
{
    return RHAL_GetHalInstance()->TunerScan((uint8_t)uiTunerID, param);
}
#endif //(RTKPLAYER_ARCH_VER <= RTKPLAYER_ARCH_V2)


#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V3) 
RTK_Error RTK_Tuner_Scan(uint8_t ucTunerID, RTK_TunerParam_t param)
{
    return RHAL_GetHalInstance()->TunerScan(ucTunerID, param);
}

RTK_Error RTK_Tuner_Release(uint8_t ucTunerID)
{
	return RHAL_GetHalInstance()->TunerRelease(ucTunerID);
}


/**
* @brief 
* This function can be used to control LNB.
*
* @param[in]	tunerid         tuner ID
* @param[in]    eLNBMode        target LNB mode
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_SetLNBMode(uint32_t uiTunerID, enum RTK_LNB_MODE eLNBMode)
{
	return RHAL_GetHalInstance()->Tuner_SetLNBMode(uiTunerID, eLNBMode);
}

/**
* @brief 
* This function can be used to get current LNB status.
*
* @param[in]	tunerid         tuner ID
* @param[out]   ptLNBStatus     current LNB status
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_GetLNBStatus(uint32_t uiTunerID, RTK_LNB_STATUS_t* ptLNBStatus)
{
	return RHAL_GetHalInstance()->Tuner_GetLNBStatus(uiTunerID, ptLNBStatus);
}

/**
* @brief 
* This function can be used to enable or disable 22KHz continues output.
*
* @param[in]	tunerid         tuner ID
* @param[in]    eEnable       	enable or disable
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_Set22KContinues(uint32_t uiTunerID, RTK_Bool eEnable)
{
	return RHAL_GetHalInstance()->Tuner_Set22KContinues(uiTunerID, eEnable);
}

/**
* @brief 
* This function can be used to send DiSEqC tone burst.
*
* @param[in]	tunerid         tuner ID
* @param[in]    eTone        	tone burst type
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_SendDiSEqCToneBurst(uint32_t uiTunerID, enum RTK_TONE_BURST eTone)
{
	return RHAL_GetHalInstance()->Tuner_SendDiSEqCToneBurst(uiTunerID, eTone);
}

/**
* @brief 
* This function can be used to send DiSEqC command.
*
* @param[in]	tunerid         tuner ID
* @param[in]    tCmdMsg         DiSEqC command message struct
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_SendDiSEqCCmd(uint32_t uiTunerID, RTK_DISEQC_MSG_t tCmdMsg)
{
	return RHAL_GetHalInstance()->Tuner_SendDiSEqCCmd(uiTunerID, tCmdMsg);
}

/**
* @brief 
* This function can be used to get DiSEqC reply message.
*
* @param[in]	tunerid         tuner ID
* @param[in]    ptReplyMsg      DiSEqC replay message struct
* @retval       RTK_OK          success.
* @retval       RTK_Fail        fail.
*
*/
RTK_Error RTK_Tuner_GetDiSEqCReply(uint32_t uiTunerID, RTK_DISEQC_MSG_t* ptReplyMsg)
{
	return RHAL_GetHalInstance()->Tuner_GetDiSEqCReply(uiTunerID, ptReplyMsg);
}

#endif //(RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V3)

RTK_Error RTK_Tuner_SetChannelNum(uint8_t ucTunerID,uint8_t channelnum)
{
	return RHAL_GetHalInstance()->TunerSetChannelNum(ucTunerID,channelnum);
}




