//#include "rtk_middleware_test.h"
#include <stdio.h>
#include<string.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#include "rtk_UDPReceiver.h"
#include "rtk_UDP_hal.h"

////////////////////////////////////////////////////////////////////////////////
// Macro definition
////////////////////////////////////////////////////////////////////////////////
//#define RTK_UDP_HAL_DBG_ENABLE
#define RTK_UDP_HAL_INF(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][INF]" fmt "",__func__, __LINE__, ##args)
#define RTK_UDP_HAL_ERR(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][ERR]" fmt "",__func__, __LINE__, ##args)

#ifdef RTK_UDP_HAL_DBG_ENABLE
#define RTK_UDP_HAL_DBG(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][DBG]" fmt "",__func__, __LINE__, ##args)
#else
#define RTK_UDP_HAL_DBG(fmt, args...) 
#endif
//#define DUMP_UDP_BUFFER
FILE* gDumpUDPBufferFile = NULL;

////////////////////////////////////////////////////////////////////////////////
// rtk udp hal Implementation
////////////////////////////////////////////////////////////////////////////////
/**
** @brief 
**	Read UDP data from share buffer.
**
** @param udp_handle handle.
** @param buffer the ts buffer
** @retval	The read return.
** 
*/ 
RTK_UDP_Error RTK_UDPReceiver_ReadFromUDPShareBuffer(RTK_UDP_HANDLE_t *udp_handle, RTK_TSInputBuffer *buffer)
{
	if((udp_handle == NULL) || (buffer == NULL))
	{
		RTK_UDP_HAL_ERR("%p:%p, param error......\n", udp_handle, buffer);
	}
	
	INT32_T src_wr = 0, src_rd = 0, src_begin = 0, src_end = 0, src_total_size = 0, src_remainBuffer_size = 0, src_update_rd = 0;
	src_wr = udp_handle->udp_mem_buffer.writePtr;
	src_rd = udp_handle->udp_mem_buffer.readPtr;
	src_begin = udp_handle->udp_mem_buffer.begin;
	src_end = udp_handle->udp_mem_buffer.end;
	src_update_rd = udp_handle->udp_mem_buffer.readPtr;
	
	if(src_rd == src_wr)
	{
		buffer->filled_size = 0;
		RTK_UDP_HAL_INF("[READ][%p] rd(0x%x) = wr(0x%x) get udp sharebuffer data is 0 !! \n", udp_handle, src_rd, src_wr);
		return RTK_UDP_DATA_NOT_ENOUGH;
	}
	else if(src_rd < src_wr)
	{
		src_total_size = src_wr - src_rd;
	}
	else if(src_rd > src_wr)
	{
		src_total_size = (src_end - src_rd) + (src_wr - src_begin);
	}
	src_total_size -=  src_total_size%188;

	INT32_T des_need_read_size = 0, des_wr = 0, des_begin = 0, des_end = 0, des_remainBuffer_size = 0;
	des_need_read_size = buffer->size;
	des_begin = (int)buffer->begin;
	des_end = (int)buffer->end;
	des_wr = (int)buffer->memory;
	
	//RTK_UDP_HAL_INF("[READ]src:rd=%d, wr=%d, begin=%d, end=%d, total_size=%d\n", src_rd, src_wr, src_begin, src_end, src_total_size);
	//RTK_UDP_HAL_INF("[READ]des:des_wr=%d, begin=0x%x, end=0x%x, des_need_read_size=%d\n", des_wr, des_begin, des_end, des_need_read_size);

	if(src_total_size < des_need_read_size)
	{
		//des_need_read_size = src_total_size;
		buffer->filled_size = 0;
		//RTK_UDP_HAL_INF("[%p] RTK_UDP_DATA_NOT_ENOUGH !! \n", udp_handle);
		return RTK_UDP_DATA_NOT_ENOUGH;
	}
	#if 0
	INT32_T src_cp_len1 = 0, src_cp_len2 = 0;
	if((src_rd + des_need_read_size) == src_end)
	{
		src_cp_len1 = des_need_read_size;
		src_update_rd = src_begin;
	}
	if((src_rd + des_need_read_size) <= src_end)
	{
		src_cp_len1 = des_need_read_size;
		src_update_rd += des_need_read_size;
	}
	else
	{
		src_cp_len1 = src_end - src_rd;
		src_cp_len2 = des_need_read_size - src_cp_len1;
		src_update_rd = src_begin + src_cp_len2;
	}

	des_remainBuffer_size = des_end - des_wr;
	if(des_remainBuffer_size < src_cp_len1)
	{
		memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, des_remainBuffer_size);
		memcpy(buffer->begin, udp_handle->udp_mem_buffer.buffer + src_rd + des_remainBuffer_size, src_cp_len1 - des_remainBuffer_size);
		memcpy((char*)buffer->begin + (src_cp_len1 - des_remainBuffer_size), 
			udp_handle->udp_mem_buffer.buffer + src_begin, src_cp_len2);
	}
	else if(des_remainBuffer_size >= src_cp_len1)
	{
		memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, src_cp_len1);
		if((des_remainBuffer_size - src_cp_len1) >= src_cp_len2)
		{
			memcpy((char*)buffer->memory + src_cp_len1, udp_handle->udp_mem_buffer.buffer + src_begin, src_cp_len2);
		}
		else
		{
			memcpy((char*)buffer->memory + src_cp_len1, udp_handle->udp_mem_buffer.buffer + src_begin, des_remainBuffer_size - src_cp_len1);
			memcpy(buffer->begin, udp_handle->udp_mem_buffer.buffer + src_begin + des_remainBuffer_size - src_cp_len1, 
				src_cp_len2 - (des_remainBuffer_size - src_cp_len1));
		}
	}

	//update buffer filled_size
	buffer->filled_size = des_need_read_size;
	//update udp sharebuffer rd pointer
	udp_handle->udp_mem_buffer.readPtr = src_update_rd;
	#endif
	#if 1
	if((src_rd + des_need_read_size) <= src_end)
	{
		if((des_wr + des_need_read_size) <= des_end)
		{
			memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, des_need_read_size);
		}
		else// if((des_wr + des_need_read_size) > des_end)
		{
			des_remainBuffer_size = des_end - des_wr;
			memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, des_remainBuffer_size);	
			memcpy(buffer->begin, udp_handle->udp_mem_buffer.buffer + src_rd + des_remainBuffer_size, des_need_read_size - des_remainBuffer_size);
		}
		src_rd += des_need_read_size;
		if(src_rd == src_end)
		{
			src_rd = src_begin;
		}
	}
	else// if((src_rd + des_need_read_size) > src_end)
	{
		src_remainBuffer_size = src_end - src_rd;
		if((des_wr + des_need_read_size) <= des_end)
		{
			memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, src_remainBuffer_size);
			memcpy((char*)buffer->memory + src_remainBuffer_size, udp_handle->udp_mem_buffer.buffer + src_begin, des_need_read_size - src_remainBuffer_size);
			src_rd = src_begin + (des_need_read_size - src_remainBuffer_size);
		}
		else// if((des_wr + des_need_read_size) > des_end)
		{
			des_remainBuffer_size = des_end - des_wr;
			if(src_remainBuffer_size == des_remainBuffer_size)
			{
				memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, des_remainBuffer_size);
				memcpy(buffer->begin, udp_handle->udp_mem_buffer.buffer + src_begin, des_need_read_size - src_remainBuffer_size);
			}
			else if(src_remainBuffer_size < des_remainBuffer_size)
			{
				memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, src_remainBuffer_size);
				memcpy((char*)buffer->memory + src_remainBuffer_size, udp_handle->udp_mem_buffer.buffer + src_begin, des_remainBuffer_size - src_remainBuffer_size);
				memcpy((char*)buffer->begin, udp_handle->udp_mem_buffer.buffer + src_begin + (des_remainBuffer_size - src_remainBuffer_size), 
					des_need_read_size - des_remainBuffer_size);
			}
			else// if(src_remainBuffer_size > des_remainBuffer_size)
			{
				memcpy(buffer->memory, udp_handle->udp_mem_buffer.buffer + src_rd, des_remainBuffer_size);
				memcpy(buffer->begin, udp_handle->udp_mem_buffer.buffer + src_rd + des_remainBuffer_size, src_remainBuffer_size - des_remainBuffer_size);
				memcpy((char*)buffer->begin + (src_remainBuffer_size - des_remainBuffer_size), 
					udp_handle->udp_mem_buffer.buffer + src_begin, des_need_read_size - src_remainBuffer_size);
			}
			src_rd = src_begin + (des_need_read_size - src_remainBuffer_size);
		}
	}

	//update buffer filled_size
	buffer->filled_size = des_need_read_size;

	//update udp sharebuffer rd pointer
	udp_handle->udp_mem_buffer.readPtr = src_rd;
	#endif	
	return RTK_UDP_OK;
}

/**
** @brief 
**	Read UDP data from share buffer.
**
** @param udp_handle handle.
** @param need_read_size read size from socket
** @retval	The read return.
** 
*/ 
RTK_UDP_Error _xReadDataToUDPShareBuffer(RTK_UDP_HANDLE_t *udp_handle, UINT32_T need_read_size)	
{
	if(udp_handle == NULL)
	{
		RTK_UDP_HAL_ERR("%p, param error......\n", udp_handle);
		return RTK_UDP_Fail;
	}
	udp_handle->udpReceiver;
	if(udp_handle->udpReceiver == NULL)
	{
		RTK_UDP_HAL_ERR("%p, param error......\n", udp_handle->udpReceiver);
		return RTK_UDP_Fail;
	}
	
	if( udp_handle->got_sharebuf == RTK_TRUE)
	{
		//pthread_mutex_unlock(&g_rtk_hal_mutex[handle->channel]);
		RTK_UDP_HAL_ERR("Had get udp buffer before, please Discard first!\n");
		return RTK_UDP_Fail;
	}
	else
	{
		udp_handle->got_sharebuf = RTK_TRUE;
	}
	//pthread_mutex_unlock(&g_rtk_hal_mutex[handle->channel]);

#ifdef DUMP_UDP_BUFFER
	if(gDumpUDPBufferFile == NULL)
	{
		gDumpUDPBufferFile = fopen("/data/dump_udp_buffer.ts", "wb");
	}
#endif

	UINT32_T wr = 0, rd = 0, begin=0, end=0, writable_size=0;
	wr = udp_handle->udp_mem_buffer.writePtr;
	rd = udp_handle->udp_mem_buffer.readPtr;
	begin = udp_handle->udp_mem_buffer.begin;
	end = udp_handle->udp_mem_buffer.end;

	if(rd <= wr)
	{
		if(rd != begin)
		{
			writable_size = (end - wr) + (rd - begin);
		}
		else
		{
			writable_size = end - wr;
		}
	}
	else//rd > wr
	{
		writable_size = rd - wr;
	}
	if(writable_size < need_read_size)
	{
		need_read_size = writable_size;
	}
	
	UINT32_T recvLen = 0;
	UINT32_T bufferRemainSize = end - wr;

	//RTK_UDP_HAL_INF("[UDP]start:rd=%d, wr=%d, begin=%d, end=%d\n", rd, wr, begin, end);
	//RTK_UDP_HAL_INF("[UDP]writable_size=%d, need_read_size=%d, bufferRemainSize=%d\n", writable_size, need_read_size, bufferRemainSize);
	
	if(rd <= wr)
	{
		if(need_read_size <= bufferRemainSize)
		{
			//SOCKET_INF("[GRACE]rd <= wr; need_read_size(%d) <= bufferRemainSize(%d)\n", need_read_size, bufferRemainSize);
			
			recvLen = udp_handle->udpReceiver->Read((char*)udp_handle->udp_mem_buffer.buffer + wr, need_read_size);			
			if((recvLen <= 0) || (recvLen != need_read_size))
			{	
				RTK_UDP_HAL_ERR("something error!!\n");
			}
#ifdef DUMP_UDP_BUFFER
			if(gDumpUDPBufferFile != NULL)//DEBUG:dump udp buffer that read from udp socket
			{
				fwrite((char*)udp_handle->udp_mem_buffer.buffer + wr, recvLen, 1, gDumpUDPBufferFile);
			}
#endif			
			wr += recvLen;//update wr
			if(wr == end)//if(need_read_size == bufferRemainSize), when end->cycle to start
			{
				wr = begin;
				RTK_UDP_HAL_DBG("[FEED]wr=%d,cycle to start\n", wr);
			}
		}
		else if(need_read_size > bufferRemainSize)
		{
			//RTK_UDP_HAL_INF("[FEED]rd <= wr; need_read_size(%d) > bufferRemainSize(%d)\n", need_read_size, bufferRemainSize);
			
			recvLen = udp_handle->udpReceiver->Read((char*)udp_handle->udp_mem_buffer.buffer + wr, bufferRemainSize);
#ifdef DUMP_UDP_BUFFER
			if(gDumpUDPBufferFile != NULL)//DEBUG:dump udp buffer that read from udp socket
			{
				fwrite((char*)udp_handle->udp_mem_buffer.buffer + wr, recvLen, 1, gDumpUDPBufferFile);
			}
#endif
			if((recvLen <= 0) || (recvLen != bufferRemainSize))
			{	
				RTK_UDP_HAL_ERR("something error!!\n");
			}
			wr = begin; //update wr, start
			
			recvLen = udp_handle->udpReceiver->Read((char*)udp_handle->udp_mem_buffer.buffer + begin, need_read_size - bufferRemainSize);
#ifdef DUMP_UDP_BUFFER
			if(gDumpUDPBufferFile != NULL)//DEBUG:dump udp buffer that read from udp socket
			{
				fwrite((char*)udp_handle->udp_mem_buffer.buffer + begin, recvLen, 1, gDumpUDPBufferFile);
			}
#endif
			if((recvLen <= 0) || (recvLen != need_read_size - bufferRemainSize))
			{	
				RTK_UDP_HAL_ERR("something error!!\n");
			}
			wr += recvLen;//update wr,

			RTK_UDP_HAL_DBG("[FEED]wr=%d, need_read_size(%d) > bufferRemainSize(%d)\n", need_read_size, bufferRemainSize, wr);
		}
	}
	else //rd > wr
	{
		RTK_UDP_HAL_DBG("[FEED]rd > wr; need_read_size(%d)\n", need_read_size);
		recvLen = udp_handle->udpReceiver->Read((char*)udp_handle->udp_mem_buffer.buffer + wr, need_read_size);
#ifdef DUMP_UDP_BUFFER
		if(gDumpUDPBufferFile != NULL)//DEBUG:dump udp buffer that read from udp socket
		{
			fwrite((char*)udp_handle->udp_mem_buffer.buffer + wr, recvLen, 1, gDumpUDPBufferFile);
		}
#endif
		if((recvLen <= 0) || (recvLen != need_read_size))
		{	
			RTK_UDP_HAL_ERR("something error!!\n");
		}
		wr += recvLen;
	}

	//update writePtr
	udp_handle->udp_mem_buffer.writePtr = wr;
	RTK_UDP_HAL_DBG("[FEED]over:rd=%d, wr=%lu, begin=%d, end=%d\n", rd, udp_handle->udp_mem_buffer.writePtr, begin, end);
	
	udp_handle->got_sharebuf = RTK_FALSE;	
	return RTK_UDP_OK;
}

/**
** @brief 
**	recv thread.
**
** @param udp_handle handle.
** 
*/ 
void *_xUDPRecvThread(void *arg)
{		
	RTK_UDP_HANDLE_t* udp_handle = (RTK_UDP_HANDLE_t*)arg;
	if(udp_handle == NULL)
	{
		RTK_UDP_HAL_ERR("RTKUDPHandle is null !!\n");
		return NULL;
	}
	while(true)
	{
		_xReadDataToUDPShareBuffer(udp_handle, RECV_UDP_DATA_MAX_SIZE_ONCE);
		usleep(300);
	}

	return NULL;
}

/**
** @brief 
**	create.
**
** @param p_udp_handle handle.
** @param rtk_socket socket info
** @retval	RTK_UDP_Error The return.
** 
*/ 
RTK_UDP_Error RTK_UDPReceiver_Create(RTK_UDP_HANDLE_t **p_udp_handle, RTK_SOCKET_t* rtk_socket)
{
	if(*p_udp_handle != NULL)
	{
		RTK_UDP_HAL_ERR("UDPHandle is exit !!\n");
		return RTK_UDP_Fail;
	}
	if(rtk_socket == NULL)
	{
		RTK_UDP_HAL_ERR("rtk_socket is null !!\n");
		return RTK_UDP_Fail;
	}

	*p_udp_handle = (RTK_UDP_HANDLE_t*)malloc(sizeof(RTK_UDP_HANDLE_t));
	if(*p_udp_handle == NULL)
	{
		RTK_UDP_HAL_ERR("UDPHandle is null !!\n");
		return RTK_UDP_Fail;
	}

	RTK_UDP_HANDLE_t *udp_handle = *p_udp_handle;
	memset(udp_handle, 0x00, sizeof(RTK_UDP_HANDLE_t));
	udp_handle->udp_mem_buffer.begin = 0;
	udp_handle->udp_mem_buffer.end = udp_handle->udp_mem_buffer.begin + sizeof(udp_handle->udp_mem_buffer.buffer);
	udp_handle->udp_mem_buffer.readPtr = udp_handle->udp_mem_buffer.begin;
	udp_handle->udp_mem_buffer.writePtr = udp_handle->udp_mem_buffer.begin;
	udp_handle->rtk_socket.e_socket_type = rtk_socket->e_socket_type;
	udp_handle->rtk_socket.iPort = rtk_socket->iPort;
	strcpy(udp_handle->rtk_socket.iStrIP,rtk_socket->iStrIP);
	
	RTK_UDP_HAL_INF("udphandle=%p, begin=%lu, end=%lu, rp=%lu, wp=%lu, buffer=%p, IP:Port=%s:%d\n", 
		udp_handle,
		udp_handle->udp_mem_buffer.begin, 
		udp_handle->udp_mem_buffer.end,
		udp_handle->udp_mem_buffer.readPtr,
		udp_handle->udp_mem_buffer.writePtr,
		udp_handle->udp_mem_buffer.buffer,
		udp_handle->rtk_socket.iStrIP, 
		udp_handle->rtk_socket.iPort);

	udp_handle->udpReceiver = new UDPReceiver();
	if(udp_handle->udpReceiver == NULL)
	{
		RTK_UDP_HAL_ERR("pUdpReceiver is NULL !\n");
		return RTK_UDP_Fail;
	}
	
	INT8_T socketRet = RTK_ERR;
	socketRet = udp_handle->udpReceiver->Open(udp_handle->rtk_socket.iPort, udp_handle->rtk_socket.iStrIP);
	if(socketRet != RTK_OK)
	{
		RTK_UDP_HAL_ERR("pUdpReceiver socket open fail!\n");
		return RTK_UDP_SOCKET_OPEN_Fail;
	}
	//pUdpReceiver->DumpReceivedData("/media/usb0/dump_udp_read.ts");
	
	return RTK_UDP_OK;
}

/**
** @brief 
**	start.
**
** @param udp_handle handle.
** @retval	RTK_UDP_Error The return.
** 
*/ 
RTK_UDP_Error RTK_UDPReceiver_Start(RTK_UDP_HANDLE_t* udp_handle)
{
	if(udp_handle == NULL)
	{
		RTK_UDP_HAL_ERR("UDPHandle is null !!\n");
		return RTK_UDP_Fail;
	}

	pthread_create(&(udp_handle->UDPRecvThread_t), NULL, _xUDPRecvThread,  (void*)udp_handle);

	return RTK_UDP_OK;
}

/**
** @brief 
**	destory.
**
** @param udp_handle handle.
** @retval RTK_UDP_Error	The return.
** 
*/ 
RTK_UDP_Error RTK_UDPReceiver_Destory(RTK_UDP_HANDLE_t* udp_handle)
{
	if(udp_handle == NULL)
	{
		return RTK_UDP_OK;
	}
	int status, rc;
	rc = pthread_join(udp_handle->UDPRecvThread_t, (void **)&status);
	if (rc != 0)
	{
		RTK_UDP_HAL_ERR("ERROR; return code from pthread_join() is %d\n", rc);
		return RTK_UDP_Fail;
	}
	if(udp_handle->udpReceiver)
	{
		delete udp_handle->udpReceiver;
		udp_handle->udpReceiver = NULL;
	}
	if(udp_handle)
	{
		free(udp_handle);
	}
	
	return RTK_UDP_OK;
}

////////////////////////////////////////////////////////////////////////////////
