#include "rtk_test_menu_common_util.h"
#include "rtk_hal_test_util.h"
////////////////////////////////////////////////////////////////////////////////
// Macro definition
////////////////////////////////////////////////////////////////////////////////
//#define RTK_UDP_HAL_DBG_ENABLE
#define RTK_UDP_HAL_INF(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][INF]" fmt "",__func__, __LINE__, ##args)
#define RTK_UDP_HAL_ERR(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][ERR]" fmt "",__func__, __LINE__, ##args)

#ifdef RTK_UDP_HAL_DBG_ENABLE
#define RTK_UDP_HAL_DBG(fmt, args...) printf("[%s:%d][RTK_UDP_HAL][DBG]" fmt "",__func__, __LINE__, ##args)
#else
#define RTK_UDP_HAL_DBG(fmt, args...) 
#endif

////////////////////////////////////////////////////////////////////////////////
// rtk udp hal Implementation
////////////////////////////////////////////////////////////////////////////////
/**
** @brief 
**	Read UDP data from share buffer.
**
** @param udp_handle handle.
** @param buffer the ts buffer
** @retval	The read return.
** 
*/ 
int rtkmid_input_AV_type_pid(RTK_VideoConfig *pVideoConfig, RTK_AudioConfig *pAudioConfig, unsigned short *pPcrPid)
{
	if(!pVideoConfig && !pAudioConfig && !pPcrPid)
		return RTK_Fail;
	
	//input video type/pid & audio type/pid
		int ret = RTK_Fail;
	if(pVideoConfig)
	{
		//choose video types
			printf("\nchoose video type: \n");
		list_item video_types_list[] = 
			{		 
				{"MPEG1",	 RTK_CODEC_VIDEO_MPEG1 },
				{"MPEG2",	 RTK_CODEC_VIDEO_MPEG2 },
				{"MPEG4",	RTK_CODEC_VIDEO_MPEG4_PART2 },		
				{"H264",	RTK_CODEC_VIDEO_H264 },
				{"H265",	RTK_CODEC_VIDEO_H265 },
			};
		RTK_Codec video_type = (RTK_Codec)show_list("Video Type List", video_types_list, list_item_cnt(video_types_list));
		pVideoConfig->codec = video_type;
	}
	
	if(pAudioConfig)
	{
		//choose audio types
		printf("\nchoose audio type: \n");
		list_item audio_types_list[] = 
			{		 
				{"MPEG1",	 RTK_CODEC_AUDIO_MPEG1 },
				{"MPEG2",	 RTK_CODEC_AUDIO_MPEG2 },
				{"MPEG4",	 RTK_CODEC_AUDIO_MP4 },
				{"AAC",   RTK_CODEC_AUDIO_AAC },	  
				{"AACPLUS",    RTK_CODEC_AUDIO_AACPLUS },
				{"AC3",    RTK_CODEC_AUDIO_AC3 },
				{"AC3_TRUE_HD",    RTK_CODEC_AUDIO_AC3_TRUE_HD },
				{"AC3_PLUS",	RTK_CODEC_AUDIO_AC3_PLUS },
				{"EAC3",   RTK_CODEC_AUDIO_EAC3 },
				{"DTS",   RTK_CODEC_AUDIO_DTS },
				
			};
		RTK_Codec audio_type = (RTK_Codec) show_list("Audio Type List", audio_types_list, list_item_cnt(audio_types_list));
		pAudioConfig->codec= audio_type;
	}
	//input video pid & audio pid
	if(pVideoConfig)
	{
		long int video_pid = 0; 
		do
		{
			printf("\nvideo_pid pid (decimal base) >> ");
			  video_pid = 0;
				if (_get_number_with_range(&video_pid, 0x0 ,0xffff)<0)	  
				ret = RTK_Fail;
			else
				ret =RTK_OK;
		}while(ret == RTK_Fail);
		pVideoConfig->pid = (uint16_t)video_pid;
		
		//default parameter
		pVideoConfig->encrypted = RTK_FALSE;
	}
	
	if(pAudioConfig)
	{
		long int audio_pid = 0;   
		do
		{
			printf("\naudio pid (decimal base) >> ");
			  audio_pid = 0;
				if (_get_number_with_range(&audio_pid, 0x0 ,0xffff)<0)	  
				ret = RTK_Fail;
			else
				ret =RTK_OK;
		}while(ret == RTK_Fail);
		pAudioConfig->pid = (uint16_t)audio_pid;
		
		//default parameter
		//pAudioConfig->encrypted = RTK_FALSE;
		//pAudioConfig->enable_raw_output_mode = RTK_FALSE;
		//pAudioConfig->focused = RTK_FALSE;
	}

	if(pPcrPid)
	{
		long int pcr_pid = 0;	
		do
		{
			printf("\npcr pid (decimal base): >> ");
			pcr_pid = 0;
			if (_get_number_with_range(&pcr_pid, 0x0 ,0xffff)<0)	
				ret = RTK_Fail;
			else
				ret =RTK_OK;
		}while(ret == RTK_Fail);
		* pPcrPid = (uint16_t)pcr_pid;
	}
	
	return ret;
}

int rtkmid_input_Tuner_Param(RTK_TunerParam_t *tuner)
{
	if(!tuner)
		return RTK_Fail;

	int ret = RTK_Fail;
	long int freq = 0; 
	long int symbolrate = 0; 
	do
	{
		printf("\n Enter freq(MHZ): >>\n");
		freq = 0;
		if (_get_number_with_range(&freq, 0x0 ,0xffff)<0)	
			ret = RTK_Fail;
		else
			ret =RTK_OK;
	}while(ret == RTK_Fail);

#if 1 // for developer, most setting is using default
	printf("\ndefault setting:\n");
	printf("    tuner type:  DVBC\n");
	printf("    bandwidth:   8M\n");
	printf("    qam:         256QAM\n");
	printf("    annex type:  DVBC_ANNEX_A\n");
	printf("    symbol rate: 6875000\n");
	printf("\nuse default tuner setting? (y/n) \n");

	if (1 == rtkmid_get_yes_no())
	{
		tuner->type = RTK_TUNER_TYPE_DVBC;
		tuner->bandwidth = RTK_TUNER_BANDWIDTH_8M;
		tuner->tnr_param.dvb_c_param.u32frequency = freq;
		tuner->tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
		tuner->tnr_param.dvb_c_param.annex_type = RTK_DVBC_ANNEX_A;
		tuner->tnr_param.dvb_c_param.u32symbol_rate = 6875000;
		return RTK_OK;
	}
#endif

	printf("\nchoose tuner type: \n");
	list_item tuner_types_list[] = 
	{		 
		{"DVBC",	RTK_TUNER_TYPE_DVBC },
		{"ABS",	 	RTK_TUNER_TYPE_ABS },
		{"DTMB",	RTK_TUNER_TYPE_DTMB },		
		{"DVBT",	RTK_TUNER_TYPE_DVB_T },
		{"DVBT2",	RTK_TUNER_TYPE_DVB_T2 },
		{"DVBS",	RTK_TUNER_TYPE_DVB_S },
		{"DVBS2",	RTK_TUNER_TYPE_DVB_S2 },
	};
	RTK_Tuner_Type_e Tuner_type = (RTK_Tuner_Type_e)show_list("Tuner Type List", tuner_types_list, list_item_cnt(tuner_types_list));
	tuner->type= Tuner_type;

	printf("\n choose tuner bandwidth(M), default is bandwidth_8M : \n");
	list_item tuner_bandwidth_list[] = 
	{
		{"bandwidth_5M",	RTK_TUNER_BANDWIDTH_5M },
		{"bandwidth_6M",	RTK_TUNER_BANDWIDTH_6M },
		{"bandwidth_7M",	RTK_TUNER_BANDWIDTH_7M },
		{"bandwidth_8M",	RTK_TUNER_BANDWIDTH_8M },
	};
	RTK_Tuner_Bandwidth_e Tuner_bandwidth = (RTK_Tuner_Bandwidth_e)show_list("Tuner Bandwidth List", tuner_bandwidth_list, list_item_cnt(tuner_bandwidth_list));
	tuner->bandwidth = Tuner_bandwidth;

	if( tuner->type == RTK_TUNER_TYPE_DVBC)
	{
		tuner->tnr_param.dvb_c_param.u32frequency = freq;
		printf("\n Enter QAM: \n");
		list_item Qam_types_list[] = 
		{		 
			{"16QAM",	RTK_CABLETNR_16QAM },
			{"32QAM",	RTK_CABLETNR_32QAM },
			{"64QAM",	RTK_CABLETNR_64QAM },		
			{"128QAM",	RTK_CABLETNR_128QAM },
			{"256QAM",	RTK_CABLETNR_256QAM },
		};
		RTK_CableTnr_Mod_e Qam_type = (RTK_CableTnr_Mod_e)show_list("Qam Type List", Qam_types_list, list_item_cnt(Qam_types_list));
		tuner->tnr_param.dvb_c_param.modulation= Qam_type;
		
		printf("\n Enter QAM ANNEX TYPE (default ANNEX_A): \n");
		list_item Annex_types_list[] = 
		{
			{"ANNEX_B",	RTK_DVBC_ANNEX_B },
			{"ANNEX_A",	RTK_DVBC_ANNEX_A },
		};
		RTK_DVBC_ANNEX_TYPE_e Annex_type = (RTK_DVBC_ANNEX_TYPE_e)show_list("Annex Type List", Annex_types_list, list_item_cnt(Annex_types_list));
		tuner->tnr_param.dvb_c_param.annex_type= Annex_type;
		
		do
		{
			printf("\n Enter symbolrate: >>\n");
			symbolrate = 0;
			if (_get_number_with_range(&symbolrate, 0x0 ,0xffffff)<0)	
			ret = RTK_Fail;
			else
			ret =RTK_OK;
		}while(ret == RTK_Fail);

		tuner->tnr_param.dvb_c_param.u32symbol_rate = symbolrate;
		//printf("\n DVBC freq %d qam %d sym %d \n",tuner->tnr_param.dvb_c_param.u32frequency,tuner->tnr_param.dvb_c_param.modulation,symbolrate);
	}
	else if (tuner->type == RTK_TUNER_TYPE_ABS)
	{
		tuner->tnr_param.abs_s_param.u32frequency = freq;
		do
		{
			printf("\n Enter symbolrate: >>\n");
			symbolrate = 0;
			if (_get_number_with_range(&symbolrate, 0x0 ,0xffffff)<0) 
			ret = RTK_Fail;
			else
			ret =RTK_OK;
		}while(ret == RTK_Fail);
		tuner->tnr_param.abs_s_param.u32symbol_rate = symbolrate;
	}
	else if ( tuner->type == RTK_TUNER_TYPE_DTMB )
	{
		tuner->tnr_param.dtmb_t_param.u32frequency = freq;

	}
	else if ( tuner->type == RTK_TUNER_TYPE_DVB_T ||
			tuner->type == RTK_TUNER_TYPE_DVB_T2)
	{
		tuner->tnr_param.dvb_t_param.u32frequency = freq;
	}
	else if (tuner->type == RTK_TUNER_TYPE_DVB_S || 
			tuner->type == RTK_TUNER_TYPE_DVB_S2)
	{
		tuner->tnr_param.dvb_s_param.u32frequency = freq;
		do
		{
			printf("\n Enter symbolrate: >>\n");
			symbolrate = 0;
			if (_get_number_with_range(&symbolrate, 0x0 ,0xffffff)<0)	
			ret = RTK_Fail;
			else
			ret =RTK_OK;
		}while(ret == RTK_Fail);

		tuner->tnr_param.dvb_s_param.u32symbol_rate = symbolrate;

		printf("\n Enter LNB type: \n");
		list_item LNB_types_list[] = 
		{		 
			{"OFF",	 RTK_LNBMODE_OFF },
			{"13V",	 RTK_LNBMODE_13V },
			{"18V",	RTK_LNBMODE_18V },		
			{"13V22K",	RTK_LNBMODE_13V_WITH_22K_BURST },
			{"18V22KK",	RTK_LNBMODE_18V_WITH_22K_BURST },
		};
		RTK_LNB_MODE_e LNB_type = (RTK_LNB_MODE_e)show_list("LNB Type List", LNB_types_list, list_item_cnt(LNB_types_list));
		tuner->tnr_param.dvb_s_param.lnbmode= LNB_type;
		//printf("\n freq %d lnb %d sym %d \n",tuner->tnr_param.dvb_s_param.u32frequency,LNB_type,tuner->tnr_param.dvb_s_param.u32symbol_rate );
	}

	return RTK_OK;

}


////////////////////////////////////////////////////////////////////////////////
