/*****************************************************************************
* Copyright (c) Realtek, Inc. All rights reserved.
* FileName: rtk_list.c
* Create Time: 2017. 5. 19.
* Description:
* Note:
*****************************************************************************/
#include <assert.h>
#include "rtk_list.h"

#ifdef __cplusplus
extern "C" {
#endif

List* createList()
{
    List* list = (List*) malloc (sizeof(List));
    list->size = 0;
    list->front = list->back = NULL;

    return list;
}

void destroyList(List* list)
{
    assert(list);

    while (!isEmpty(list))
    {
        removeFront(list);
    }

    free (list);
    list = NULL;
}


bool isEmpty(List* list)
{
    assert(list);
    return list->size == 0;
}

ListNode* getFront(List* list)
{
    assert(list);
    return list->front;
}

ListNode* getBack(List* list)
{
    assert(list);
    return list->back;
}

void addFront(List* list, RTK_SectionData* node)
{
    assert(list);
    ListNode* n = (ListNode*) malloc (sizeof(ListNode));
    n->data = node;
    n->next = NULL;

    if (isEmpty(list))  // add first node
    {
        list->front = list->back = n;
    }
    else
    {
        n->next = list->front;
        list->front = n;
    }
    list->size++;
}

void addBack(List* list, RTK_SectionData* node)
{
    assert(list);
    ListNode* n = (ListNode*) malloc (sizeof(ListNode));
    n->data = node;
    n->next = NULL;

    if (isEmpty(list))  // add first node
    {
        list->front = list->back = n;
    }
    else
    {
        list->back->next = n;
        list->back = n;
    }
    list->size++;
}

void removeFront(List* list)
{
    assert(list);

    if(isEmpty(list))
    {
        printf("Error: List is Empty.\n");
        return;
    }

    ListNode* tmp = list->front->next;
    free (list->front);
    
    if (tmp)    // Before remove, # of node > 1
        list->front = tmp;
    else        // Before remove, # of node == 1
        list->front = list->back = tmp;

    list->size--;
}

void removeBack(List* list)
{
    assert(list);

    if(isEmpty(list))
    {
        printf("Error: List is Empty.\n");
        return;
    }

    ListNode* tmp = list->front;

    if (tmp == list->back)  // Before remove, # of node == 1
    {
        free (list->back);
        list->front = list->back = NULL;
    }
    else                    // Before remove, # of node > 1
    {
        while(tmp->next != list->back)  // find node pointing node to be removed
            tmp=tmp->next;

        free (list->back);
        tmp->next = NULL;
        list->back = tmp;
    }

    list->size--;
}

#ifdef __cplusplus
}
#endif
