##############################################################
# Copyright (C) 2008 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
###############################################################

LOCAL_PATH := $(call my-dir)
ifneq ($(filter 9%,$(PLATFORM_VERSION)),)
BUILD_IN_ANDROID9 = YES
else
BUILD_IN_ANDROID9 = NO
endif

LOCAL_PATH := $(call my-dir)
ifneq ($(filter 10%,$(PLATFORM_VERSION)),)
BUILD_IN_ANDROID10 = YES
else
BUILD_IN_ANDROID10 = NO
endif


ifeq ($(BUILD_DVB_HYBRID_CUSTOMER),)
BUILD_SOURCE_PLAYER = YES
HAL_PATH_SUFFIX=GOLDEN
else ifeq ($(BUILD_DVB_HYBRID_CUSTOMER), GOLDEN)
BUILD_SOURCE_PLAYER = YES
HAL_PATH_SUFFIX=GOLDEN
else ifneq ($(filter MOD SKB, $(BUILD_DVB_HYBRID_CUSTOMER)),)
BUILD_SOURCE_PLAYER = NO
else ifneq ($(filter VEPL PESI HANDAN, $(BUILD_DVB_HYBRID_CUSTOMER)),)
HAL_LIB_SUFFIX = _$(BUILD_DVB_HYBRID_CUSTOMER)
HAL_PATH_SUFFIX = $(BUILD_DVB_HYBRID_CUSTOMER)
BUILD_SOURCE_PLAYER = NO
else
HAL_PATH_SUFFIX = $(BUILD_DVB_HYBRID_CUSTOMER)
BUILD_SOURCE_PLAYER = NO
endif

$(warning "HAL_PATH_SUFFIX is $(HAL_PATH_SUFFIX), HAL_LIB_SUFFIX=$(HAL_LIB_SUFFIX)")

ifeq ($(BUILD_SOURCE_PLAYER), YES)
###############################################################
#lib rtk_DvbSourcePlayer
###############################################################
include $(CLEAR_VARS)
LOCAL_MODULE := librtk_DvbSourcePlayer
LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES:= \
                src/rtk_player.cpp \
		src/CDvbSourcePlayer.cpp 

LOCAL_C_INCLUDES:= \
                external/stlport/stlport \
                system/core/include/ion \
		bionic \
		system/core/include/cutils \
                frameworks/native/include \
                frameworks/native/libs/nativewindow/include \
                frameworks/native/libs/nativebase/include \
                frameworks/native/libs/arect/include \
                
LOCAL_C_INCLUDES+= \
                vendor/realtek/RTKHAL/Include \
                vendor/realtek/RTKPLAYER/RTKHAL_Base/inc \
                vendor/realtek/RTKPLAYER/RTK_HAL_PLAYER_$(HAL_PATH_SUFFIX)/inc \
                vendor/realtek/RTKPLAYER/RTK_DataSourcePlayer/DvdIptv/inc \
                vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc \
                vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc \
		  vendor/realtek/RTKPLAYER/Rtk_CaIntf/include \
		  
LOCAL_SHARED_LIBRARIES := \
                liblog \
                librtksdk \
                librtk_halPlayer$(HAL_LIB_SUFFIX) \
                libion \
                libutils 

LOCAL_CFLAGS := -DANDROID

ifeq ($(BUILD_IN_ANDROID9),YES)
LOCAL_C_INCLUDES += system/core/libcutils/include

LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9
endif

ifeq ($(BUILD_IN_ANDROID10),YES)
LOCAL_C_INCLUDES += system/core/libcutils/include

LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
endif

LIBVERSION:=\"$(shell cd $(LOCAL_PATH);git log -1 --format=%h_%cd --date=format:'%Y%m%d_%H:%M:%S_Android'$(PLATFORM_VERSION))\\n\"
$(warning "the librtk_DvbSourcePlayer_$(HAL_PATH_SUFFIX)_version_$(LIBVERSION)")
LOCAL_CFLAGS     += -DEXTERN_FUNC_NAME=$(LOCAL_MODULE)_getGitSha
LOCAL_CFLAGS     += -DGIT_VERSION=\"$(LOCAL_MODULE)_$(HAL_PATH_SUFFIX)_version_\"$(LIBVERSION)
LOCAL_SRC_FILES  += ../../.RTKRevision.cpp

LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V1=$(RTKPLAYER_ARCH_V1)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V2=$(RTKPLAYER_ARCH_V2)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V3=$(RTKPLAYER_ARCH_V3)

ifeq ($(RTKPLAYER_ARCH_VER), )
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_V3)
else 
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_VER)
endif
include $(BUILD_SHARED_LIBRARY)

######################################################################
# build CDvbPlayerTest_main 
######################################################################
include $(CLEAR_VARS)

LOCAL_MODULE:= CDvbPlayerTest_main
LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES:= \
        src/CDvbPlayerTest_main.cpp \

LOCAL_C_INCLUDES:= \
        vendor/realtek/RTKPLAYER/RTK_DataSourcePlayer/DvdIptv/inc\
        vendor/realtek/RTKPLAYER/RTKHAL_Base/inc \
        vendor/realtek/RTKPLAYER/RTK_HAL_PLAYER_$(HAL_PATH_SUFFIX)/inc \
        vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc \
        vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc \
        device/realtek/video/rvsd/$(TARGET_BOARD_PLATFORM) \

LOCAL_SHARED_LIBRARIES:= \
        liblog \
        librtksdk \
        librtk_halPlayer$(HAL_LIB_SUFFIX) \
        librtk_DvbSourcePlayer \
#        librvsd \

ifeq ($(BUILD_IN_ANDROID9), YES)
LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9
endif

ifeq ($(BUILD_IN_ANDROID10), YES)
LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
endif

include $(BUILD_EXECUTABLE)

endif ##end  BUILD_SOURCE_PLAYER 
