/**
    *@copyright 
    * Copyright (c) Realtek, Inc. http://www.realtek.com. All rights reserved.
    * Realtek PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
    * 
    * @file  
    * @brief  
    *
    *
    */

#ifndef __CDVB_SOURCE_PLAYER_H__
#define __CDVB_SOURCE_PLAYER_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef void* RTKDVB_Player_t;

/**
* @brief
* Create DVB/IPTV player
*
* @param[out]		handle		 	return the DVB/IPTV player handle
* @param[in]		pInitParams		reserved.
*	
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerCreate(RTKDVB_Player_t *handle, void *pInitParams);

/**
* @brief
* Destory DVB/IPTV player
*
* @param[in]		handle		 	the DVB/IPTV player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerDestory(RTKDVB_Player_t handle);

/**
* @brief
* Set data source.
*
* @param[in]		handle		 	the DVB/IPTV player handle
* @param[in]		url		 		play source url
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerSetDataSource(RTKDVB_Player_t handle, const char* url);

/**
* @brief
* Start play.
*
* @param[in]		handle		 	the DVB/IPTV player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerStart(RTKDVB_Player_t handle);

/**
* @brief
* Stop play.
*
* @param[in]		handle		 	the DVB/IPTV player handle
* @param[in]		isKeepLastFrame 0:Not keep last frame, other value :keep last frame.
* 
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerStop(RTKDVB_Player_t handle, int isKeepLastFrame);




#ifdef __cplusplus
}
#endif

#endif

