/*
 * rtk_player_GOLDEN.h
 *
 *	Created on: 2019. 6. 20.
 */
 
#ifndef __INC_RTK_PLAYER_GOLDEN__
#define __INC_RTK_PLAYER_GOLDEN__


#include <pthread.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <cutils/log.h>
#include <vector>
#include <map>
#include <utility>
#include <system/window.h>

#include "rtk_hal.h"
#include "rtk_psi.h"  //for psi parse.


#define RTK_PLAYER_INF_EN
#define RTK_PLAYER_WRN_EN
#define RTK_PLAYER_ERR_EN

#ifdef RTK_PLAYER_INF_EN
#define RTK_PLAYER_INF(fmt, args...)          ALOGD("[RT_Player][INF]" fmt, ##args)
#else
#define RTK_PLAYER_INF(fmt, args...)
#endif
#ifdef RTK_PLAYER_WRN_EN
#define RTK_PLAYER_WRN(fmt, args...)          ALOGW("[RT_Player][WRN]" fmt, ##args)
#else
#define RTK_PLAYER_WRN(fmt, args...)
#endif
#ifdef RTK_PLAYER_ERR_EN
#define RTK_PLAYER_ERR(fmt, args...)          ALOGE("[RT_Player][ERR]" fmt, ##args)
#else
#define RTK_PLAYER_ERR(fmt, args...)
#endif
class Irtk_CaIntf;
typedef Irtk_CaIntf* (*GET_CA_INSTANCE_FUNC)(void);
typedef void (*PUT_CA_INSTANCE_FUNC)(void);
typedef enum 
{
	RTK_PLAYER_SECTION_PAT,
	RTK_PLAYER_SECTION_PMT,
	RTK_PLAYER_SECTION_CAT,
	RTK_PLAYER_SECTION_SDT,
	RTK_PLAYER_SECTION_TIMEOUT,
	RTK_PLAYER_SECTION_PROGRAMINFO,
	RTK_PLAYER_TS_FIRSTRECEIVE,
	RTK_PLAYER_FIRSTIFRAME_DISPLAYED,
	RTK_PLAYER_EOS,
	// For PVR error handling
	/* Any other recording error not listed below */
	RTK_PLAYER_PVR_ERROR_RECORDING_ERROR,
	/* Recorder initialization fail */
	RTK_PLAYER_PVR_ERROR_RECORDER_NOT_AVAILABLE,
	/* No more storage capacity */
	RTK_PLAYER_PVR_ERROR_RECORDER_DISK_FULL,
	/* File size reach filesystem's limit */
	RTK_PLAYER_PVR_ERROR_RECORDER_MAX_FILE_SIZE,
	/* No permission to record */
	RTK_PLAYER_PVR_ERROR_RECORDER_NO_PERMISSION,
	RTK_PLAYER_UDP_TIMEOUT,
	RTK_PLAYER_DECODE_FAIL,
	RTK_PLAYER_FINGER_PRINT_REQUIRED
}RTK_PLAYER_CB_TYPE_e;

typedef void (*RTK_PLAYER_CALLBACK)(RTK_PLAYER_CB_TYPE_e type, void* data, void* user_param );

typedef enum 
{
	RTK_MEDIA_TRACK_TYPE_VIDEO,
	RTK_MEDIA_TRACK_TYPE_AUDIO,
	RTK_MEDIA_TRACK_TYPE_SUBTITLE,
}RTK_MEDIA_TRACK_TYPE_e;


typedef enum
{
	PLAY_FROM_MEM=0,
	PLAY_FROM_FILE,	
}PLAY_INPUT_SOURCE;


typedef struct {
	unsigned int wr;
	unsigned int rd;
	unsigned int size;
	unsigned int phyAddr;
	unsigned char* pCachedVirAddr;
	unsigned char* pBufferVirAddr;
} DemuxMemory;

typedef enum
{
	RTKPLAYER_SOURCE_NONE=0,
	RTKPLAYER_SOURCE_TCP,
	RTKPLAYER_SOURCE_UDP,
	RTKPLAYER_SOURCE_HTTP,
	RTKPLAYER_SOURCE_FILE,
	RTKPLAYER_SOURCE_TUNER,
}RTKPLAYER_SOURCE;

// -1 means unknown
typedef struct {
	RTKPLAYER_SOURCE source;
	long long duration; // 90KHz based
	long long firstPTS;
	long long ctrlSampleDuration;
	long long ByteRate;
	long long TotalBytes;
	long long TotalSeconds;
	bool ctrlDataSupport;
} RTK_MediaInfo;

typedef enum
{
	ARCH_PLAY=1,
	ARCH_DEMUX,
	ARCH_DEMUX_AND_PLAY,
}RTKPLAYER_ARCH;



#define FULLSACN_PROGRAME_CNT 64
typedef struct {
	unsigned int program_cnt;
	unsigned int program_bw[FULLSACN_PROGRAME_CNT];
	unsigned int program_freq[FULLSACN_PROGRAME_CNT];
	unsigned int program_lnb_or_qam[FULLSACN_PROGRAME_CNT];
	unsigned int program_rate[FULLSACN_PROGRAME_CNT];
	TS_PSI_Program psi_program[FULLSACN_PROGRAME_CNT];
} FullSacnProInfo;

typedef struct {
    uint64_t start;
    uint32_t size;
    uint32_t idx;
} IFrameElement;

typedef struct {
    uint32_t currentFilePosition;
    uint32_t Isize;
    uint32_t buffer_size;
    uint32_t align_end_offset;
    uint64_t min_Ioffset;
    uint64_t max_Ioffset;
    bool     end_of_IFrame;
    std::vector<IFrameElement>::iterator cur_it;
    std::vector<IFrameElement>::reverse_iterator cur_rit;
} FeedDataInfo;

typedef enum
{
	UNMUTE=0,
	MUTE_BY_USER = 0x1<<0,
	MUTE_BY_TRICKPLAY = 0x1<<1,
	MUTE_BY_AVSYNC = 0x1<<2,
}RTKPLAYER_MUTE;

typedef enum
{
	RTKPLAYER_INPUT_TUNER,
	RTKPLAYER_INPUT_FILE,
	RTKPLAYER_INPUT_IPTV,
}
RTKPLAYER_INPUT;


/*===========================================================================*/
/*RTKPLAYER_STATUS:                                                          */
/*                         start                                             */
/*                      |--------> [RUN] ------|                             */
/*       create      |             ^           | stop         destory        */
/*[NONE] -----> [INIT] -|            |start    |-----> [INIT] -------> [NONE]*/
/*                      | preparse   |         |                             */
/*                      |--------> [PREPARSE] -|                             */
/*                                                                           */
/*===========================================================================*/
typedef enum
{
	RTKPLAYER_STATUS_NONE=0,
	RTKPLAYER_STATUS_INIT,
	RTKPLAYER_STATUS_PREPARSE,
	RTKPLAYER_STATUS_RUN,
}RTKPLAYER_STATUS;

typedef enum
{
	RTK_TRICKPLAY_NORMAL = 0,//default value, trick normal speed
	RTK_TRICKPLAY_STEP_BY_IFRAME = 1,//jump IFRAME, just send IFRAME
	RTK_TRICKPLAY_STEP_BY_VOBU = 2, //jump data,and send VOBU+ new DATA, VOBU+ new DATA, ......
}RTK_PLAYER_TRICK_MODE;

#define CHANNEL_LIST_VERSION 1 // TODO: Once you change the structure of either RTK_CHANNELINFO or RTK_CHANNELLIST, be sure to define a larger version number than current one
#define CHANNEL_LIST_PATCH  "/data/mediadrm/channellist.dat"

typedef struct
{
	int   videopid;
	RTK_Codec   videocodec;
	int   audiopid;
	RTK_Codec   audiocodec;
}RTK_CHANNELINFO;

typedef struct
{
	int  currtotalchannelnum;
	int  update_version;
	std::map<unsigned long long,RTK_CHANNELINFO> channellist;
}RTK_CHANNELLIST;


typedef struct
{
       int  freq;
	int   videopid;
	RTK_Codec   videocodec;
	int   audiopid;
	RTK_Codec   audiocodec;
        int    qam;
        int    lnbmode;
        int    symbolrate;
        RTK_Tuner_Bandwidth    bandwidth;
}RTK_FCCHANNELLIST;

typedef enum
{
	RTK_SEEKWHENCE_SET,
	RTK_SEEKWHENCE_CUR,
	RTK_SEEKWHENCE_END,
}RTK_SEEK_WHENCE;

#define RTK_GETSEEKWHENCE_STR(x)	((x == RTK_SEEKWHENCE_CUR) ? "RTK_SEEKWHENCE_CUR" : \
										(x == RTK_SEEKWHENCE_SET) ? "RTK_SEEKWHENCE_SET" : "RTK_SEEKWHENCE_END")
		
///define void*  with RTK_Demux
typedef void * RTK_Demux;
///define void*  with RTK_EmmDemux
typedef void * RTK_EmmDemux;

/***************************************************************************************
 * Common struct
 ***************************************************************************************/
/**
 *@brief emm demux config.
 *
    */
typedef struct
{
	RTK_InputConfig input; /*!< input config, @see RTK_InputConfig   */
}
RTK_EmmDemuxConfig;

// Already defined in RTKHAL_Base/inc/Rtk_hal_base.h
#if 0
/**
    *@brief
    * It defines the demux configure structure.
    */
typedef struct
{
	RTK_CallbackConfig callback;///the callback function to execute when demux 

	RTK_InputConfig input;///the input data source config,including type,data source struct,and encrypted flag

	RTK_VideoConfig video; ///the video pid,codec mask information used to parsed the video data
	RTK_AudioConfig audio;///the audio pid,codec mask information used to parsed the aduio data
	uint16_t	pcr_pid;		//	pid of pcr.
	RTK_DescrambleInfo descrambler;
	RTK_SubtitleConfig subtitle;
}
RTK_DemuxConfig;
#endif

class RTKPlayer
{
public:

	RTKPlayer(RTKPLAYER_ARCH arch=ARCH_PLAY, bool isBackground=false);
	virtual ~RTKPlayer();

	int  RT_PlayerOpenPVR(const char *strPath);
	char RT_PlayerStartPVR(void);
	char RT_PlayerStopPVR(void);
	char RT_PlayerClosePVR(void);
	char RT_PlayerUpTsTSFilter(TS_PSI_Program program);

	char RT_PlayerCreate(const char *sourceUrl,int updateinfo=1);
	char RT_PlayerPreparse(int predict_pmt_pid);
	char RT_PlayerStart(int channelIndex=0);
	char RT_PlayerStop(RTK_Bool keepLastFrame=(RTK_Bool)RTK_FALSE);
	char RT_PlayerDestory(void);
	static char RT_PlayerFinalize(void);
	
	char RT_PlayerSetVideoMute(RTK_Bool mute);
//	char RT_PlayerSetVideoScale(RTK_Aspect_Ratio ratio);
	char RT_PlayerPause(RTK_Bool enableTimeShift);
	char RT_PlayerResume(void);
	char RT_PlayerExitFileMode(void);
	
	char RT_PlayerSetPlaySpeed(float speed);
	char RT_PlayerGetPlaySpeed(float *speed);
	
	char RT_PlayerSeekTo(int64_t seekPTS);
	char RT_PlayerGetCurrentDisplayingPTS(long long * pCurrentPTS);
	void RT_PlayerGetFirstDisplayingPTS(long long * pFirstPTS);
	void RT_PlayerGetMediaInfo(RTK_MediaInfo* info);

//	char RT_GetVideoTrackInfo(RTK_Video_TrackInfo *pTSVideoTrackInfo);
//	char RT_GetAudioTrackInfo(RTK_Audio_TrackInfo *pTSAudioTrackInfo, int *trackCount);
//	char RT_GetSubtitleTrackInfo(RTK_Subtitle_TrackInfo *pTSSubtitleTrackInfo, int *trackCount);
//	int RT_GetSelectedTrackIndex(RTK_MEDIA_TRACK_TYPE_e type);
//	char RT_SetTrack(RTK_MEDIA_TRACK_TYPE_e type, int index);	

	char RT_PlayerCreateWindow(void *nativeWindow);
	char RT_PlayerSetVideoOutputMode(RTK_WinPlane win_plane);
	char RT_CreateSurface(int plane, int x, int y, int w, int h);
	char RT_DestorySurface(int plane);
	char RT_MonitorPSI();

	void RT_PlayerCallbackRegister(RTK_PLAYER_CALLBACK fct, void* user_param);
	void RT_PlayerNotify(RTK_PLAYER_CB_TYPE_e type, void* data);

	char RT_GetProgramInfoList (FullSacnProInfo * ptrInfo);

#ifdef ENABLE_VO_SEND_FRAME
	void RT_PlayerMultiview(const char* url1, const char *url2,  const char *url3);
	void RT_PlayerStopMultiview(void);
	void RT_PlayerGetMultiviewBuffer(uint8_t** ptr_buffer, unsigned int *avhandle);
	
#endif
//	RTK_Error RT_GetDemuxInfo(Hal_Demux_Info_t* DemuxInfo);
//	RTK_Error RT_SetAudioFocus(RTK_Bool isFocus, uint16_t pid = 0x1FFF);
	RTK_Error RT_SetAudioMute(RTK_Bool isMute);
	RTK_Error RT_GetAudioMute(RTK_Bool *isMute);
	
	char RT_PlayerGetPlayBackStatus();
	char RT_PlayerGetPacketCount(int* packetCount);
	char RT_PlayerGetPacketErrors(int* PacketErrors);
	char RT_PlayerGetVideoPesCount(int * pesCount);
	char RT_PlayerGetVideoPesErrors(int* pesErrors);

//	char RT_PlayerGetControlProtocol(int* controlProtocol);
	char RT_PlayerSeekToEx(int msec);
	void  RT_PlayerSendVOBU();
	int check_channellist(char *strUrl);
	void update_channellist();

	int RT_Player_ChangeChannel(RTK_VideoConfig *pVideo, RTK_AudioConfig *pAudio);
	int RT_Player_SetMultiFreq(RTKMultiCH_Param_t MultiCH_param);
	int RT_Player_SetMultiPIDFilters(RTKMultich_Pids_t* MultiCHPID_param,int channel_count);
	void RT_Player_SetLoop(bool enable);
	int RT_Player_ChangeProgram(int  program_num);
	int RT_Player_ChangeVideo(RTK_VideoConfig *pVideo);
	int RT_Player_ChangeAudio(RTK_AudioConfig *pAudio);

    int RT_Player_StartDescrambler(uint16_t sid, std::vector<std::pair<uint16_t /*ECM PID*/,uint16_t /*stream PID*/>> & ecmPidList);
	int RT_Player_StopDescrambler();
	int RT_Player_setEmmPid(uint16_t caSystemId, uint16_t pid);
			
	TS_PSI_Program RT_Player_getPogramInfo(int index);
	int RT_Source_Create(RTK_Source* source, RTK_SourceParam_t param);
	int RT_Source_Destory(RTK_Source source);
	int RT_Source_PresetPidFilter(RTK_Source source, uint16_t* pids, unsigned char numPID);
	int RT_Player_SetSource(RTK_Source source);
	int RT_Source_GetIsLocked();
	int RT_playerSeek(int seek_value);
	char RT_GetEpgInfo(TS_Program_Info* programInfo,time_t *now_time);
	void RT_OpenEpgInfo(RTK_Bool openEpg);
	time_t RT_GetEpgNowTime();
    void RT_Tuner_GetInfo(RTK_TunerInfo *tuner_info);
//////////////////FCC test start////////////////////////////////////
		int RT_Player_FCC_test_start(int version,int current_idx);
		int RT_Player_FCC_test_stop();
		int RT_Player_FCC_test_next_channel();
		int RT_Player_FCC_test_prev_channel();
	int RT_Player_PopupToForeground(bool isToForeground);	
//////////////////FCC test end////////////////////////////////////
        int RT_Player_TunerIsLocked();
        int RT_Tuner_Scan(uint32_t uiTunerID,RTK_TunerParam_t param);
        
		int RT_Player_SetAVSyncMode(int mode);
		int RT_Player_SetErrorConcealLevel(int  level);
		int RT_Player_SetAudioFocused(bool audioFocusedState);
        RTK_FCCHANNELLIST FCCList[100];
        int m_totalFCCcount;
        int m_firstplayready;
        RTKPLAYER_STATUS m_status;
        int m_updateinfoflag;

	//ca interface
	static void* m_cadlhandler;
	static RTK_Player m_FCCMainPlayerHandle;

protected:

	RTKPLAYER_ARCH m_arch;
	RTKPLAYER_INPUT m_InputType;
	unsigned char m_MuteState;

	RTK_Player m_demux;
	RTK_Bool m_isPlayAudio;
	RTK_PlayerConfig m_demuxConfig;
	RTK_Bool m_isAddEPG;

	RTK_Player m_player;
	RTK_PlayerConfig m_playerConfig;
	unsigned char *m_pDurationBuffer;
	long long        m_beginPCR;

	
	float m_speed;
	int64_t m_current_PTS;

	// For "jump-I" trick-play use
	RTK_PLAYER_TRICK_MODE m_trickPlaying;
	bool m_IdxDataSupport;
	bool m_LeftDataWaitToSend;
	uint32_t m_idx;
	long m_idxLastReadStopPosition;

	pthread_mutex_t m_rtkPTSMutex; // for protect m_firstDisplayingPTS
	long long m_firstDisplayingPTS;
	char m_SeekFlag;
	int64_t m_seekOffset;
	
	char m_playerPauseFlag;
	volatile char m_sourceFeedPauseFlag;
	long m_playerPausePoint;
	unsigned long long m_dataSendOffset;

	const char* m_recordingFilePath;

	FILE * m_recordingCtrl_Wr; // write only, not for read
	FILE * m_recordingCtrl_Rd; // read only, not for write
	FILE * m_recordingIdx_Wr;  // write only, not for read
	FILE * m_recordingIdx_Rd;  // read only, not for write
	char m_startRecording;

	FILE *m_TSDataFile;
	long m_demuxFilePoint;
	long m_playerFilePoint;

	char m_firstReceiveTSData;
	int m_writeEnable;

	
	int m_prevPATVersion;
	int m_prevSDTVersion;
	long long m_parseSdtStartTime;
	bool m_isMonitorPSI;
	int m_receivedProgramCount;

	int m_playProgramNum;
	int m_channelIndex;
	int m_audioIndex;
	TS_PSI_Program m_RecProgram;

	TS_Program_Info m_programInfo;
	FullSacnProInfo m_fullscanInfo;
	int m_receivedFullScanProCount;
	
	PLAY_INPUT_SOURCE m_playerInputSource;
	PLAY_INPUT_SOURCE m_replaySwitch;
	
	DemuxMemory m_dataStoreMemory;

	RTK_TSFilter m_patTSFilterHandle;
	RTK_TSFilter m_pmtTSFilterHandle;
	RTK_TSFilter m_videoTSFilterHandle;
	RTK_TSFilter m_audioTSFilterHandle[TSPSIMGR_MAX_PIDS];
	RTK_TSFilter m_subtitleTSFilterHandle[TSPSIMGR_MAX_PIDS];

	RTK_PLAYER_CALLBACK m_playerCallBackFct;
	void* m_playerCallBackUserParam;
	int m_SendVOBUdatatimes ;
#ifdef ENABLE_VO_SEND_FRAME
	void *m_rtkffdecode1;
	void *m_rtkffdecode2;
	void *m_rtkffdecode3;
#endif

	bool m_ForceAudioFocused;
	RTK_Bool m_ForceAudioFocusedState;
	bool m_LoopFeedEnable;
	RTK_AVsyncMode m_av_sync_mode; 
	RTK_Source m_source;
	int m_tuner_id;
       int m_player_id;
	bool m_isPvr;
	int m_pvr_index;
	RTK_Source* m_rtkSource = NULL;
	int m_rtkSourceNum = 0;
	RTK_TunerParam_t  tunerParam;
	int m_dtvs_tsid;

	//ca interface
	GET_CA_INSTANCE_FUNC m_getCaInstanceFunc;
	PUT_CA_INSTANCE_FUNC m_putCaInstanceFunc;	
	Irtk_CaIntf* m_CaIntf;

	//FCC background player
	bool m_isBackground;

	RTK_CAS_Type_e mCasType;
	
	
protected:

	char xParseCtrlData(void);
	char xParseFileInfo(void);
	char xSetDataSource(const char *sourceUrl);
	int xReadDataFromFile(void *inHandle, unsigned char *data, unsigned int size);
	inline void xExtrackURLInfo(char *url, int protocol_len);
	inline void xResetProgramInfo();
	inline char xConvertURLtoKeyNum(unsigned long long * result);
	void xCleanRecordProgram(void);
	void xUpdateRecordProgram(TS_PSI_Program program);
	char xAddPAT(void);
	void xRemovePAT(void);
	char xAddCAT(void);
	void xRemoveCAT(void);
	char xAddPMT(uint16_t pid);
	char xAddSDT(void);
	char xAddEIT(void);
	char xAddTDT(void);
	void xRemoveTDT(void);
	void xRemovePMT(RTK_SectionFilter handle);
	void xChangeAvParm(int channelIndex);
	void xCopyToDataStoreMemory(char *pData, uint32_t dataSize);
	char xfreeProgramInfoServiceData (FullSacnProInfo * ptrInfo);
	char xSeekToPts(FILE* fp, uint64_t dstPTS, int64_t &foundOffset);
	char xSeekToSecond( int startSeconds,int64_t *postion);
	char xStepToNextIFrame_Forward(std::vector<IFrameElement> *IList, FeedDataInfo* info, uint64_t *new_pos);
	char xStepToNextIFrame_Backward(std::vector<IFrameElement> *IList, FeedDataInfo* info, uint64_t *new_pos);
	char xTraverseIFrame(FILE* fp, std::vector<IFrameElement> *IList, FeedDataInfo* info, RTK_TSInputBuffer* buffer);
	void xExtractIFrameInfo(std::vector<IFrameElement> *IFrameList, FeedDataInfo* info);
	char xSourceCreateAndSet(void);
	int xReadFixedSizeDataByIndex(FILE* pFile, uint32_t uiFixedDataSize, uint64_t ulIndex, uint8_t* pucBuf);
	int xFindTargetPTSInfo(FILE* pPTSFile, uint64_t ulTargetPTS, uint64_t* pulIndex, RTK_TS_Ctrl* ptPTSInfo);
	int xPVR_Replay_Seek(FILE* pfTSFile, FILE* pfPTSFile, FILE* pfFrameFile, uint64_t ulPTSCur, int32_t iSeekTimeMs, RTK_SEEK_WHENCE eSeekWhence);
	int xFindTargetFrameInfo(FILE* pfFrameFile, uint64_t ulTargetOffset, uint64_t* pulFrameOffset, RTK_FrameType eTargetType);

	uint32_t xReadNextScanningStep(FILE* fp, uint32_t readSize ,RTK_TSInputBuffer* buffer);

	void SectionCallback(const RTK_SectionFilter handle,const uint8_t *_section, const uint32_t length);
	static void SectionCallbackEntry(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam);

	void HalCallback(RTK_CallbackEvent event, HAL_TYPE type, void * data, uint32_t data_size);
	static void HalCallbackEntry(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size);
	long xGetPCR(unsigned char* pBuffer, int bufferSize, long long* pPCRPos, long long* pPCR,int* pPCRPID, bool* pbLinear, bool isForward);
	long xGetMiddleRate(long long* pTime, long long* pPos, int entrySize, unsigned int* pRate, bool* pbLinear);
	void xEstimateByteRate(FILE *pfile, int bufferSize);
	static int xReSyncStream(unsigned char* pData, unsigned int bytes);
        char xParseExmInfo(const char *sourceUrl, struct RTKCA_Descramble_ECM_info *exmInfo); //for descramble fcc
        char* m_sourceUrl;

#ifdef RTKPLAYER_MINI_SI    
	char ParseChannelInfo(unsigned char *pStreamBuffer, int streamBufferBytes, TS_PSI_Program* tmpInfo,unsigned short *pmt_pid);
#endif
	//demux feed thread
	char m_demuxFeedStop;
	pthread_t rtkDemuxFeedThread;
	static void* ThreadProcDemuxFeedEntry(void* pInstance);
	void* ThreadProcDemuxFeed();

	//play feed thread, together with demux, for timeshift.
	char m_playerFeedStop;
	pthread_t rtkPlayFeedThread;
	static void* ThreadProcPlayFeedEntry(void* pInstance);
	void* ThreadProcPlayFeed();
	char m_waitPMTStop;
	pthread_t waitPMTThread;
	static void* ThreadWaitPMTEntry(void* pInstance);	
	void*  ThreadWaitPMT();

	 //for timeshift.
	pthread_mutex_t m_rtkDataCallBackMutex;

	RTK_MediaInfo m_mediaInfo;
	pthread_mutex_t m_mediaInfoMutex;

#ifdef RTKPLAYER_MINI_SI
        pthread_t rtkDemuxPreparseThread;
        static void* ThreadProcPreParsePMTEntry(void* pInstance);
        void* ThreadProcPreParsePMT();
        char m_PreparseFeedStop;
        unsigned char *pStreamBuffer;
        int m_readdatasize;
#endif

	void* m_pSource;
	RTK_SectionFilter m_patHandle;
	RTK_SectionFilter m_catHandle;
	RTK_SectionFilter m_pmtHandle[PROGRAME_CNT];
	RTK_SectionFilter m_tdtHandle = NULL;
	uint16_t m_pmtFilterPID[PROGRAME_CNT];
	FILE *m_channellistFileRd;
	FILE *m_channellistFileWr;
	int    m_saveurlflag;
	RTK_CHANNELLIST storedchannellist;
	std::map<unsigned long long,RTK_CHANNELINFO>::iterator cur_it;

	FILE *m_DumpFd;
	long m_error_conceal_start;

	bool xCheckCC(RTK_TSInputBuffer *buffer);
	bool xCheckPCR(RTK_TSInputBuffer *buffer);
	volatile int m_searchDiscontinue;
	int m_last_PAT_cc;
	int m_last_video_cc;
	int m_last_audio_cc;
	volatile int m_dropFlag;
	long long m_last_pcr;

// --------------------------------------------------------------------
// Hwacom
protected:
   RTK_SourceParam_t m_SourceParam;
   unsigned char m_tunerId;
   bool m_preload;

public:
    void setTunerId(unsigned char tunerId) { m_tunerId = tunerId; }
    unsigned char getTunerId(void) { return m_tunerId; }
    void setPreload(bool preload) { m_preload = preload; }
    bool isPreload(void) { return m_preload; }

};

char RT_setVideoSurface(RTK_WinPlane plane_id, void* native_window);
int RT_GetSMP();
int RT_SetSMP(RTK_Bool enable);
int RT_writeMultichFile(const char *path,const char *content,bool apped);
bool RT_openTifFccFlag(RTK_Bool enable);

RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec);
RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec);

#endif

