#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include "CDvbSourcePlayer.h"
#include "rtk_hal.h"


#define CMP(s)        (strncasecmp(s, command, strlen(s))== 0)
#define UNUSED(x)	(void)(x)

int main(int argc, char *argv[])
{

	int duration = 0;
    int cur_sec;
    long long cur_pts;
    char command[256], command_tmp[256], command_final[256];
    char *pCmd, *pToken;
    char cmd_good;
	int need_quit = 0;
	RTK_WinConfig win;

	RTKDVB_Player_t dvbPlayer=NULL;
	int ret;

	UNUSED(command_tmp);
	UNUSED(command_final);
	UNUSED(pToken);
	UNUSED(cmd_good);
	UNUSED(pCmd);
	UNUSED(argc);

	if(argc!=2)
	{
		printf("\nUsage: \n"
			"    CDvbPlayerTest_main {url}\n"
			"Example:\n"
			"    CDvbPlayerTest_main udp://172.29.163.112/1.ts\n"
			"    CDvbPlayerTest_main tuner://DVBC:730:64:6875000\n"
			"    CDvbPlayerTest_main tsfile:///data/1.ts\n");
	}

	

	win.plane=RTK_WIN_MAIN;
	win.pos_x=0;
	win.pos_y=0;
	win.width=1920;
	win.height=1080;
	RTK_CreateSurface(win);
	
	RTK_DVBSource_PlayerCreate(&dvbPlayer, NULL);   

    printf("SetDataSource %s\n", argv[1]);

   	ret=RTK_DVBSource_PlayerSetDataSource(dvbPlayer, argv[1]);
    printf("setDataSource return %d\n", ret);
    printf("start .... ");
    RTK_DVBSource_PlayerStart(dvbPlayer);

    printf("start return %d\n", ret);

    while(need_quit == 0) {

        // get command from user input
        printf("\nCommand list : \n");
        //printf("          n  seek +10 sec\n");
        //printf("          b  seek -10 sec\n");
        //printf("          s  change subtitle\n");
        //printf("unknown cmd  current position\n");
        printf("          q  quit\n");
        printf("\nCommand>\n");

        fgets(command, 256, stdin);
        *(strchr(command, '\n')) = '\0'; // trim the newline character

        if(strlen(command)==0)
        {
            //pClient->getCurrentPosition(cur_sec, &cur_pts);
            //printf(" duration=%d Cur sec=%d PTS=(%.4f)\n", duration, cur_sec, (float)cur_pts/90000.0);
            continue;
        }
        printf("get key = %s\n", command);

        if (CMP("quit") || CMP("q")) {
            printf("quit playback\n");
            break;
        }
        else if (CMP("n"))
        {
            /*int seek_to = 0;
            if (duration == 0)
                pClient->getDuration(duration);
            pClient->getCurrentPosition(cur_sec, &cur_pts);
            if ((cur_sec + 10) < duration)
            {
                seek_to = cur_sec + 10;
            }
            else
            {
                seek_to = duration - 1;
            }
            printf(" duration=%d Cur sec=%d PTS=(%.4f)\n", duration, cur_sec, (float)cur_pts/90000.0);
            pClient->seekTo(seek_to);*/
        }
        else if (CMP("b"))
        {
            /*int seek_to = 0;
            if (duration == 0)
                pClient->getDuration(duration);
            pClient->getCurrentPosition(cur_sec, &cur_pts);
            if ((cur_sec - 10) >= 0)
            {
                seek_to = cur_sec - 10;
            }
            else
            {
                seek_to = 0;
            }
            printf(" duration=%d Cur sec=%d PTS=(%.4f)\n", duration, cur_sec, (float)cur_pts/90000.0);
            pClient->seekTo(seek_to);*/
        }
        else if (CMP("s"))
        {
            /*SPU_STREAM_INFO sInfo;
            VIDEO_STREAM_INFO vInfo;
            status_t ret = pClient->getVideoStreamInfo(&vInfo);
            ret = pClient->getSpuStreamInfo(&sInfo);
            printf(" ret = %d numStreams=%d, currentStreamNum=%d, languageCode=%d\n", ret, sInfo.numStreams, sInfo.currentStreamNum, (int)sInfo.languageCode);
            pClient->setSpuStream(1, 1, 0, 0, 20);*/
        }
        else {
            printf("unknown command : \n");
            //pClient->getCurrentPosition(cur_sec, &cur_pts);
            //printf(" duration=%d Cur sec=%d PTS=(%.4f)\n", duration, cur_sec, (float)cur_pts/90000.0);
        }
    }

    RTK_DVBSource_PlayerStop(dvbPlayer, 0);
	RTK_DVBSource_PlayerDestory(dvbPlayer);
	
	RTK_DestorySurface(RTK_WIN_MAIN);
    	
    return 0;
}

