/**
    *@copyright 
    * Copyright (c) Realtek, Inc. http://www.realtek.com. All rights reserved.
    * Realtek PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
    * 
    * @file  
    * @brief  
    *
    *
    */

#include <string.h>
#include <stdio.h>
#include "rtk_player.h"
#include "CDvbSourcePlayer.h"

#define RTKDVB_INF(fmt, args...) ALOGD("[RTKDVB_Splayer][INF]" fmt, ##args)	
#define RTKDVB_ERR(fmt, args...) ALOGE("[RTKDVB_Splayer][ERR]" fmt, ##args)

#define UNUSED(x)	(void)(x)


/**
* @brief
* Create DVB/IPTV player
*
* @param[out]		handle		 	return the DVB/IPTV player handle
* @param[in]		pInitParams		reserved.
*	
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerCreate(RTKDVB_Player_t *handle, void *pInitParams)
{
	UNUSED(pInitParams);
	RTKPlayer *pSplayer=new RTKPlayer(ARCH_PLAY);
	if(pSplayer==NULL)
	{
		RTKDVB_ERR("new RTKPlayer failed\n");
		return -1;
	}

	*handle=(void*)pSplayer;

	return 0;
}

/**
* @brief
* Destory DVB/IPTV player
*
* @param[in]		handle		 	the DVB/IPTV player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerDestory(RTKDVB_Player_t handle)
{
	char ret;
	RTKPlayer *pSplayer=(RTKPlayer *)handle;

	if(pSplayer==NULL)
	{
		RTKDVB_ERR("invalid handle\n");
		return -1;
	}
	
	if(pSplayer->m_status!=RTKPLAYER_STATUS_NONE)
	{
		ret=pSplayer->RT_PlayerDestory();
	}
	
	delete pSplayer;

	return 0;
}

/**
* @brief
* Set data source.
*
* @param[in]		handle		 	the DVB/IPTV player handle
* @param[in]		url		 		play source url
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerSetDataSource(RTKDVB_Player_t handle, const char* url)
{
	char ret;
	RTKPlayer *pSplayer=(RTKPlayer *)handle;

	if(pSplayer==NULL)
	{
		RTKDVB_ERR("invalid handle\n");
		return -1;
	}
	ret=pSplayer->RT_PlayerCreate(url);

	return (ret==RTK_OK)?0:-1;
}

/**
* @brief
* Start play.
*
* @param[in]		handle		 	the DVB/IPTV player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerStart(RTKDVB_Player_t handle)
{
	char ret;
	RTKPlayer *pSplayer=(RTKPlayer *)handle;

	if(pSplayer==NULL)
	{
		RTKDVB_ERR("invalid handle\n");
		return -1;
	}
	ret=pSplayer->RT_PlayerStart(0);

	return (ret==RTK_OK)?0:-1;
}

/**
* @brief
* Stop play.
*
* @param[in]		handle		 	the DVB/IPTV player handle
* @param[in]		isKeepLastFrame 0:Not keep last frame, other value :keep last frame.
* 
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_DVBSource_PlayerStop(RTKDVB_Player_t handle, int isKeepLastFrame)
{
	char ret;
	RTKPlayer *pSplayer=(RTKPlayer *)handle;

	if(pSplayer==NULL)
	{
		RTKDVB_ERR("invalid handle\n");
		return -1;
	}

	RTK_Bool keepLastFrame=(isKeepLastFrame)?RTK_TRUE:RTK_FALSE;
	
	ret=pSplayer->RT_PlayerStop(keepLastFrame);

	return (ret==RTK_OK)?0:-1;
}

