/*****************************************************************************
 * Copyright (c) Realtek, Inc. All rights reserved.
 * FileName: rtk_player.cpp
 * Create Time: 2017. 5. 19.
 * Description:
 * Note:
 *****************************************************************************/
#include <pthread.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <inttypes.h>
#include <utils/Timers.h>
#include "Irtk_CaIntf.h"
#include <dlfcn.h>
#include "rtk_TCPReceiver.h"
#include "rtk_UDPReceiver.h"
#ifdef USE_RTK_EXTRACTOR
#include "HttpIOPluginProxy.h"
#endif
#ifdef ENABLE_VO_SEND_FRAME
#include "CVpudecoder.h"
#endif
#include "rtk_porting_rec.h"
#include "rtk_player.h"
#include "rtk_tee_share_mem.h"
#include "rtk_monitor.h"

#ifdef RTKPLAYER_MINI_SI
#include "rtk_player_minisi.h"
#endif

#include <sys/system_properties.h>
#include <cutils/properties.h>
#undef  UNUSED
#define UNUSED(x)	((void)(x))	/* to avoid warnings */

#define ENCRYPT_DATA_SIZE  (188*12*16)			//shoule be the same with server.
#define MAX_FILE_SIZE (ENCRYPT_DATA_SIZE*20000)	//700M
#define SDT_TABLE_INTERVAL_TIME_MAX (3000) 		// 3000ms
#define FREE_BUFFER_SIZE (3*1024*1024)
#define PTS_MAXMUN 0x1FFFFFFFF

#define CALLBACK_BUFFER_SIZE (188*12*1024)//the same with server.
#define STORE_BUFFER_SIZE (CALLBACK_BUFFER_SIZE*8)//about 16M for store avdata.
#define CALLBACK_BUFFER_OFFSET (32)//for wr&rd
#define READ_DATA_MAXMUN_SIZE  (188*256) // 47KB
#define MTP_BUFFER_ALIGNMENT (376*2) //for cached memory. 16 Byte align
#define SOURCE_RETRY_COUNTER 10

#define FEED_DBG 0 // 0: no debug; 1:first feed debug; 2: all feed debug; 3: all feed debug + read time
#if (FEED_DBG == 1)
#define feed_debug_init() bool first_feed = true;
#define feed_debug_read(buf_size) if(first_feed)RTK_PLAYER_INF("(%s) [first] read buffer size %d",__FUNCTION__, buf_size);
#define feed_debug_feed(feed_size) if(first_feed)RTK_PLAYER_INF("(%s) [first] feed filled size %d",__FUNCTION__, feed_size);
#define feed_debug_first_update() if(first_feed){first_feed = false; RTK_PLAYER_INF("(%s) [first] feed success" ,__FUNCTION__);}
#elif (FEED_DBG == 2)
#define feed_debug_init()
#define feed_debug_read(buf_size) RTK_PLAYER_INF("(%s) read buffer size %d",__FUNCTION__, buf_size);
#define feed_debug_feed(feed_size) RTK_PLAYER_INF("(%s) feed filled size %d",__FUNCTION__, feed_size);
#define feed_debug_first_update() RTK_PLAYER_INF("(%s) feed success" ,__FUNCTION__);
#elif (FEED_DBG == 3)
#define feed_debug_init() long long read_before, read_after;
#define feed_debug_read(buf_size) read_before = systemTime(SYSTEM_TIME_MONOTONIC)/1000000;RTK_PLAYER_INF("(%s) read buffer size %d",__FUNCTION__, buf_size);
#define feed_debug_feed(feed_size) read_after = systemTime(SYSTEM_TIME_MONOTONIC)/1000000;RTK_PLAYER_INF("(%s) feed filled size %d spend %lld ms",__FUNCTION__, feed_size, read_after - read_before);
#define feed_debug_first_update() RTK_PLAYER_INF("(%s) feed success" ,__FUNCTION__);
#else
#define feed_debug_init()
#define feed_debug_read(buf_size)
#define feed_debug_feed(feed_size)
#define feed_debug_first_update()
#endif

//#define DUMP_FEED // for debug

// for starting 10 sec error conceal
#define ERRORCONCEAL_TIMEOUT 1000*10 // 10 sec
/*#define START_ERRORCONCEAL(handle) \
	do{ \
		m_error_conceal_start = systemTime(SYSTEM_TIME_MONOTONIC)/1000000; \
		RTK_Player_AvSetErrorConcealLevel(handle, 4096, 0); \
	}while(0)

#define STOP_ERRORCONCEAL(handle) \
	do{ \
		m_error_conceal_start = -1; \
		RTK_Player_AvSetErrorConcealLevel(handle, 0, 0); \
	}while(0)

#define CHECK_TIMEOUT_ERRORCONCEAL(handle) \
	do{ \
		if(m_error_conceal_start != -1){ \
			long cur_time = systemTime(SYSTEM_TIME_MONOTONIC)/1000000; \
			if(cur_time - m_error_conceal_start > ERRORCONCEAL_TIMEOUT) { \
				STOP_ERRORCONCEAL(handle); \
			} \
		} \
	}while(0)*/

#define TS_INVALID_PID (0x1FFF)

#define RTK_MAX_TUNER_FREQUENCE_MHZ (2200)

static struct flock m_tsFileLock;
static FILE *m_recordingFile = NULL;
static const unsigned int g_scanningJumpTable[] = {
    2,  //   0x ~  15x
    2,  //  15x ~  30x
    3,  //  30x ~  45x
    4,  //  45x ~  60x
    5,  //  60x ~  75x
    6,  //  75x ~  90x
    7,  //  90x ~ 105x
    8,  // 105x ~ 120x
    9   // 120x ~
};
RTK_Bool g_is_tif_fcc = RTK_FALSE;
static FILE *s_PvrTsFile = NULL;
time_t nowTime=0;
//uint8_t g_tuner_id = 0;

#define CA_INTF_DLL_PATH "/vendor/lib/"

#define RTK_MIN_SCAN_SPEED	(15*256)
#define ABS(x)  ((x < 0)? -x : x)
static void _xSetFileBusyFlag(int fd, long  start)
{
	bzero(&m_tsFileLock, sizeof(m_tsFileLock));
	m_tsFileLock.l_type = F_WRLCK; 
	m_tsFileLock.l_whence = SEEK_SET;
	m_tsFileLock.l_start = start;
	m_tsFileLock.l_len = 0;
	int retValue = fcntl(fd, F_SETLKW, &m_tsFileLock);
	if(retValue < 0){
		RTK_PLAYER_ERR("%s %d fcntl fail!!\n",__FUNCTION__, __LINE__);
	}
}

static void _xClearFileBusyFlag(int fd)
{
	m_tsFileLock.l_type = F_UNLCK;
	int retValue = fcntl(fd, F_SETLKW, &m_tsFileLock);
	if(retValue < 0){
		RTK_PLAYER_ERR("%s %d fcntl fail!!\n",__FUNCTION__, __LINE__);
	}
}

static char _xGetDemuxMemory(DemuxMemory* m_dataStoreMemory)
{
	unsigned char * pNonCachedVirAddr = NULL;
	unsigned char * pCachedVirAddr = NULL;
	unsigned int PhyAddr = 0;

	unsigned int m_dataStoreMemorySize = (STORE_BUFFER_SIZE + CALLBACK_BUFFER_OFFSET);
	pCachedVirAddr=(unsigned char*)RTK_TEE_ShareMem_malloc(m_dataStoreMemorySize, (unsigned char**)&pNonCachedVirAddr, &PhyAddr);
	if(pCachedVirAddr==NULL)
	{
		RTK_PLAYER_ERR(" %s, %d, pCachedVirAddr alloc fail!!\n", __FUNCTION__, __LINE__);
		return RTK_ERR;
	}
	m_dataStoreMemory->wr = 0;
	m_dataStoreMemory->rd = 0;
	m_dataStoreMemory->size = 0;
	m_dataStoreMemory->phyAddr = PhyAddr;
	m_dataStoreMemory->pCachedVirAddr = pCachedVirAddr;
	m_dataStoreMemory->pBufferVirAddr = (unsigned char*)((unsigned long)pNonCachedVirAddr + CALLBACK_BUFFER_OFFSET);

	return RTK_OK;
}

static void  _xReleaseDemuxMemory(DemuxMemory* m_dataStoreMemory)
{
	if(m_dataStoreMemory->pCachedVirAddr)
	{
		RTK_TEE_ShareMem_free(m_dataStoreMemory->pCachedVirAddr, (STORE_BUFFER_SIZE + CALLBACK_BUFFER_OFFSET));
		m_dataStoreMemory->pCachedVirAddr = NULL;
		m_dataStoreMemory->pBufferVirAddr = NULL;
	}	
}

RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec)
{
	RTK_Codec eRtkVideoCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG1;
			break;
		case TS_PSI_ST_ATSC_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_13818_2_Video://TS_PSI_DT_VideoStream
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_14496_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG4_PART2;
			break;			
		case TS_PSI_ST_14496_10_Video:// TS_PSI_DT_MPEG4_Video
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexG_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexH_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_23008_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H265;
			break;
		case TS_PSI_DT_AVC:
			break;
		case TS_PSI_ST_AVS_Video:
			//eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_AVS;
			break;
		default:
			break;
	}

	return eRtkVideoCodec;
}

RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec)
{
	RTK_Codec eRtkAudioCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG1;
			break;
		case TS_PSI_ST_13818_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG2;
			break;
		case TS_PSI_ST_13818_7_AAC:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AAC;
			break;
		case TS_PSI_ST_14496_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MP4;
			break;
		case TS_PSI_ST_ATSC_AC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3;
			break;
		case TS_PSI_ST_ATSC_EAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3_PLUS;//RTK_AUDIO_CODEC_TYPE_AAC_PLUS_LOAS
			break;
		case TS_PSI_ST_ATSC_DTS:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS;
			break;
		case TS_PSI_ST_ATSC_DTS_HD:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS_HD;
			break;
		case TS_PSI_ST_DRA_Audio:
			//eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DRA;
			break;
		case TS_PSI_DT_DVB_EnhancedAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_EAC3;
			break;
		default:
			break;
	}

	return eRtkAudioCodec;
}

#if 0
static char _xSaveRecordingTS(unsigned char* buffer, unsigned int size, unsigned int count, FILE* stream)
{
	fwrite(buffer, size, count, stream);
	return RTK_OK;
}
#endif

/*******************************************************************
* unique id for tuner and player.
********************************************************************/
typedef enum
{
	TUNER_ID_TYPE=0,
	PLAYER_ID_TYPE,	
}RtkUniqueIdType_t;

static pthread_mutex_t gTunerIdAllocMutex=PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t gPlayerIdAllocMutex=PTHREAD_MUTEX_INITIALIZER;

static unsigned char gTunerId_used[8] = {0};
static unsigned char gPlayerId_used[8] = {0};
static int g_ID_allocate(RtkUniqueIdType_t type)
{
	if(type==TUNER_ID_TYPE)
	{
		int i=0;
		pthread_mutex_lock(&gTunerIdAllocMutex);
		for(i=0; i<8; i++)
		{
			if(gTunerId_used[i]==0)
			{
				gTunerId_used[i]=1;
				pthread_mutex_unlock(&gTunerIdAllocMutex);
				return i;
			}
		}
		pthread_mutex_unlock(&gTunerIdAllocMutex);
		if(i>=8)
			return -1;	
	}
	else if(type==PLAYER_ID_TYPE)
	{
		int i=0;
		pthread_mutex_lock(&gPlayerIdAllocMutex);
		for(i=0; i<8; i++)
		{
			if(gPlayerId_used[i]==0)
			{
				gPlayerId_used[i]=1;
				pthread_mutex_unlock(&gPlayerIdAllocMutex);
				return i;
			}
		}
		pthread_mutex_unlock(&gPlayerIdAllocMutex);
	
		if(i>=8)
			return -1;
	}

	return -1;
}
static void g_ID_free(RtkUniqueIdType_t type, int id)
{
	if((type==TUNER_ID_TYPE) && id>=0 && id<8)
	{
		pthread_mutex_lock(&gTunerIdAllocMutex);	
		gTunerId_used[id]=0;
		pthread_mutex_unlock(&gTunerIdAllocMutex);
	}	
	else if((type==PLAYER_ID_TYPE) && id>=0 && id<8)
	{
		pthread_mutex_lock(&gPlayerIdAllocMutex);
		gPlayerId_used[id]=0;
		pthread_mutex_unlock(&gPlayerIdAllocMutex);
	}
	return;
}

void* RTKPlayer::m_cadlhandler=NULL;
void* RTKPlayer::m_FCCMainPlayerHandle=NULL;

RTKPlayer::RTKPlayer(RTKPLAYER_ARCH arch, bool isBackground) :
    m_source(NULL),
    mCasType(RTK_CAS_TYPE_NONE)
{
	int ca_ret=-1;
	m_arch = arch;
	m_channellistFileRd = NULL;
	m_channellistFileWr = NULL;
	m_CaIntf = NULL;
	m_getCaInstanceFunc = NULL;
	m_putCaInstanceFunc = NULL;
	m_rtkSource = NULL;
	m_pDurationBuffer = NULL;
	m_cadlhandler = NULL;
	m_status = RTKPLAYER_STATUS_NONE;
	m_InputType = RTKPLAYER_INPUT_IPTV;
	m_demux = NULL;
	m_player = NULL;
	m_MuteState = UNMUTE;
	m_isPlayAudio=RTK_TRUE;
	
	m_speed = 1.0;
	m_current_PTS = -1;

	m_trickPlaying = RTK_TRICKPLAY_NORMAL;
	m_IdxDataSupport = false;
	m_LeftDataWaitToSend = false;
	m_idx = 0;
	m_idxLastReadStopPosition = 0;

	m_playerPauseFlag = RTK_FALSE;
	m_sourceFeedPauseFlag = RTK_FALSE;
	m_playerPausePoint = 0;
	m_dataSendOffset=0;
	m_SeekFlag = RTK_FALSE;
	m_seekOffset = 0;

        
	m_recordingFilePath = NULL;
	m_recordingCtrl_Wr = NULL;
	m_recordingCtrl_Rd = NULL;
	m_recordingIdx_Wr = NULL;
	m_recordingIdx_Rd = NULL;
	m_startRecording = RTK_FALSE;

	m_TSDataFile = NULL;
	m_demuxFilePoint = 0;
	m_playerFilePoint = 0;

	m_firstDisplayingPTS = -1;
	m_firstReceiveTSData = 0;
	m_writeEnable = 0;

	m_prevPATVersion = -1;
	m_prevSDTVersion = -1;
	m_parseSdtStartTime = 0;
	m_isMonitorPSI = false;
	m_receivedProgramCount = 0;
	m_receivedFullScanProCount = 0;
	
	m_playProgramNum = -1;
	m_channelIndex = -1;
	m_audioIndex = 0; // default first audio
	m_updateinfoflag = 1;
	xResetProgramInfo();

	m_playerInputSource=PLAY_FROM_MEM;
	m_replaySwitch=m_playerInputSource;

	m_rtkDataCallBackMutex = PTHREAD_MUTEX_INITIALIZER;
	m_rtkPTSMutex = PTHREAD_MUTEX_INITIALIZER;
	m_playerFeedStop  = RTK_FALSE;
	m_demuxFeedStop = RTK_TRUE;
	m_waitPMTStop = RTK_TRUE;
	m_playerCallBackFct = NULL;
	m_playerCallBackUserParam = NULL;
	bzero(&m_demuxConfig, sizeof(RTK_DemuxConfig));
	bzero(&m_playerConfig, sizeof(RTK_PlayerConfig));

	m_mediaInfoMutex = PTHREAD_MUTEX_INITIALIZER;
	m_mediaInfo.source = RTKPLAYER_SOURCE_NONE;
	m_mediaInfo.duration = -1;
	m_mediaInfo.firstPTS = -1;
	m_mediaInfo.ctrlSampleDuration = -1;
	m_mediaInfo.ByteRate=-1;
	m_mediaInfo.TotalBytes=-1;
	m_mediaInfo.TotalSeconds=-1;
	m_mediaInfo.ctrlDataSupport = false;
	m_ForceAudioFocused = RTK_FALSE;
	xCleanRecordProgram();
#ifdef ENABLE_VO_SEND_FRAME
	m_rtkffdecode1 = NULL;
	m_rtkffdecode2 = NULL;
	m_rtkffdecode3 = NULL;
#endif

#ifdef RTKPLAYER_MINI_SI
       pStreamBuffer = NULL;
       m_readdatasize = 2*47*1024;
	rtkDemuxPreparseThread = 0;
	m_PreparseFeedStop = RTK_TRUE;
#endif
	m_pSource = NULL;
	m_patHandle = NULL;
	m_catHandle = NULL;
	memset(m_pmtHandle,0,sizeof(m_pmtHandle));
	memset(m_pmtFilterPID,0,sizeof(m_pmtFilterPID));
	m_DumpFd = NULL;
	m_error_conceal_start = -1;
	m_searchDiscontinue = 0;
	m_last_PAT_cc = -1;
	m_last_video_cc = -1;
	m_last_audio_cc = -1;
	m_last_pcr = -1;
	m_dropFlag = 0;
	m_LoopFeedEnable=false;
	m_isPvr = false;
	m_pvr_index = -1;
	m_dtvs_tsid=-1;
	m_isAddEPG = RTK_FALSE;
	m_source = NULL;
	m_ForceAudioFocusedState = RTK_FALSE;

    m_player_id = -1;
    m_sourceUrl = NULL;
        
	char value[PROPERTY_VALUE_MAX]={0};
	char caLibPath[256] = {0};
	//load ca interface lib
	if(property_get("persist.vendor.calib", value, "cdca") > 0)
	{
		mCasType = RTK_CAS_TYPE_3RDPARTY_CA;

		sprintf(caLibPath,"%slib%s_casIntf.so", CA_INTF_DLL_PATH, value);
		if(m_cadlhandler==NULL)
			m_cadlhandler = dlopen(caLibPath, RTLD_LAZY);
	       if(m_cadlhandler == NULL)
	       {
	       	m_getCaInstanceFunc = NULL;
			m_putCaInstanceFunc = NULL;
	              RTK_PLAYER_ERR("%s\n",	dlerror());
	       }
	       else
	       {
	       	m_getCaInstanceFunc = (GET_CA_INSTANCE_FUNC)dlsym(m_cadlhandler, "Rtk_GetCaIntfInstance");
			if(m_getCaInstanceFunc)
			{
				m_CaIntf = m_getCaInstanceFunc();
				if(m_CaIntf==NULL)
					RTK_PLAYER_ERR("call Rtk_GetCaIntfInstance failed\n");
				else
				{
					if(m_CaIntf->Init()!=RTKCA_OK)
					{
						RTK_PLAYER_ERR("Ca init failed\n");
					}
				}
			}
			m_putCaInstanceFunc = (PUT_CA_INSTANCE_FUNC)dlsym(m_cadlhandler, "Rtk_PutCaIntfInstance");
			
	       }
	}
	m_tunerId = 0;
	m_preload = false;


	//back ground player flag
	m_isBackground=isBackground;
	m_tuner_id=-1;
	RTK_PLAYER_INF("[%s] m_isBackground is %d\n", __func__, m_isBackground);
}

RTKPlayer::~RTKPlayer()
{
	RT_PlayerStop();
	RT_PlayerDestory();

	m_demux = NULL;
	m_player = NULL;

	if(m_recordingFilePath!=NULL) free((void*)m_recordingFilePath);

	if(m_recordingCtrl_Wr!=NULL) fclose(m_recordingCtrl_Wr);
	m_recordingCtrl_Wr = NULL;
	if(m_recordingCtrl_Rd!=NULL) fclose(m_recordingCtrl_Rd);
	m_recordingCtrl_Rd = NULL;

	if(m_recordingIdx_Wr!=NULL) fclose(m_recordingIdx_Wr);
	m_recordingIdx_Wr = NULL;
	if(m_recordingIdx_Rd!=NULL) fclose(m_recordingIdx_Rd);
	m_recordingIdx_Rd = NULL;

	m_TSDataFile = NULL;

	m_playerCallBackFct = NULL;
	m_playerCallBackUserParam = NULL;
	s_PvrTsFile = NULL;
	if(m_pSource != NULL )
	{
		if(m_demuxConfig.input.iptv.e_socket_type == RTK_UDP_SOCKET)
		{
			UDPReceiver* pUdpReceiver = (UDPReceiver*)m_pSource;
			pUdpReceiver->Close();
			delete(pUdpReceiver);
			m_pSource = NULL;
		}
	}
	g_is_tif_fcc = RTK_FALSE;

        if(NULL != m_sourceUrl)
        {
            free(m_sourceUrl);
            m_sourceUrl = NULL;
        }

	//unload ca lib
	if(m_cadlhandler)
	{
		if(m_CaIntf)
		{
			//FIXME: do'nt destroy Rtk_CDCa object to prevent the race condition in CDCAS callback
			//if(m_CaIntf->UnInit()!=RTKCA_OK)
			{
				RTK_PLAYER_ERR("Ca uninit failed\n");
			}
		}
		/*We do not delete the ca interface instance. because it is a singleton.*/
	}
#ifdef DUMP_FEED
	if(m_DumpFd!=NULL)
	{
		int fd = 0;
		fflush(m_DumpFd);
		fd = fileno(m_DumpFd);
		fsync(fd);
		fclose(m_DumpFd);
		m_DumpFd = NULL;
		RTK_PLAYER_INF("[DUMP]%d: close dumpfile!\n", __LINE__);
	}
#endif
}

#define DEFAULT_READ_WRITE_SIZE		(188*1024)
#define FILE_BUFFER_RSVR_BYTES   (4096)
#define SECTOR_SIZE        FILE_BUFFER_RSVR_BYTES 
#define NUM_PARSE_BLOCK         8
#define MIN_PARSE_BLOCK_SIZE    204
#define SMALL_FILE_READ_SIZE    4*1024 

static int gcd(int a,int b)
{
	int c=0;
	c = a % b;
	if (c==0) 
	{
		return b;
	}
	return gcd(b,c);
}

static int lcm(int a,int b)
{
	return b/gcd(a,b)*a;
}

long RTKPlayer::xGetPCR(unsigned char* pBuffer, int bufferSize, long long* pPCRPos, long long* pPCR, int* pPCRPID, bool* pbLinear, bool isForward)
{
	if((bufferSize <= 0) || (pBuffer[0] != 0x47))    return RTK_ERR;

	unsigned char* pTSPacket;
	long long      PCRPos = *pPCRPos;
	long long      PCRBase = 0; 
	unsigned short PCRExt = 0;
	unsigned char  isError = 0, AFControl = 0, PCRFlag = 0;
	int            AFLen = 0;
	unsigned short PID = 0x1fff;

	if(isForward)
	{
		pTSPacket = pBuffer;
		PCRPos = *pPCRPos;
	}
	else
	{
		pTSPacket = pBuffer + bufferSize - (bufferSize % 188) - 188;
		PCRPos = *pPCRPos  + bufferSize - (bufferSize % 188) - 188;
	}

	while(bufferSize >= 188)
	{
		if(pTSPacket[0] != 0x47)    goto LABEL_GETPCR_JUMP_TO_NEXT_PACKET;

		// check if there are some errors in this packet
		isError = (pTSPacket[1] & 0x80) ;
		if(isError)    goto LABEL_GETPCR_JUMP_TO_NEXT_PACKET;

		// check if adaptation field exist
		PID = ((pTSPacket[1] & 0x1F) << 8) | pTSPacket[2];
		AFControl = (pTSPacket[3] & 0x30) >> 4;

		if((AFControl == 0x02) || (AFControl == 0x03))
		{
			AFLen = pTSPacket[4];
			if((AFLen <= 0) || (AFLen > 183))    goto LABEL_GETPCR_JUMP_TO_NEXT_PACKET;

			PCRFlag = (pTSPacket[5] & 0x10);
			if(!PCRFlag)    goto LABEL_GETPCR_JUMP_TO_NEXT_PACKET;

			if(*pPCRPID == 0x1fff)    *pPCRPID = PID;
			if(*pPCRPID != PID)		
			{
				*pbLinear = false;
				RTK_PLAYER_INF("bLinear=false!!!");
				goto LABEL_GETPCR_JUMP_TO_NEXT_PACKET;
			}
			else
				*pbLinear = true;
			PCRBase = ((((long long)pTSPacket[6]) << 25) | (((long long)pTSPacket[7]) << 17) | (((long long)pTSPacket[8]) << 9) | (((long long)pTSPacket[9]) << 1) | ((((long long)pTSPacket[10]) & 0x80) >> 7));
			PCRExt = (((pTSPacket[10] & 0x01) << 8) | pTSPacket[11]);
			//*pPCR = PCRBase * 300 + PCRExt; 
			*pPCR = PCRBase;
			*pPCRPos = PCRPos;
			RTK_PLAYER_INF("PCR=%lld, Pos=%lld, Pid=0x%04x\n", PCRBase, PCRPos,PID);
			return RTK_OK;
		}

LABEL_GETPCR_JUMP_TO_NEXT_PACKET:
		if(isForward)
		{
			pTSPacket += 188;
			PCRPos += 188;
		}
		else
		{
			pTSPacket -= 188;
			PCRPos -= 188;
			if (pTSPacket < pBuffer)
			{
				break;
			}
		}
		bufferSize -= 188;
	}

	return RTK_ERR;
}


long RTKPlayer::xGetMiddleRate(long long* pTime, long long* pPos, int entrySize, unsigned int* pRate, bool* pbLinear)
{
	if(entrySize <= 0)    return RTK_ERR;

	int rate[NUM_PARSE_BLOCK];
	long long prevTime = pTime[0];
	long long prevPos = pPos[0];
	int idx = 0;

	/* calculate bit rate */
	for(int i = 1; i < entrySize; i++)
	{
		if(pTime[i] > prevTime)
		{
			rate[idx] = (pPos[i] - prevPos) / ((pTime[i] - prevTime)/90000);
			idx++;
		}
		else
			*pbLinear = false;
		
		prevTime = pTime[i];
		prevPos = pPos[i];
	}

	/* get middle */
	int swap, midRate = 0;
	if(idx > 2)
	{

		// plain old bubble-sort
		for(int i = 0; i < idx - 1; i ++)
			for(int j = 0; j < idx - 1 - i; j ++)
				if(rate[j] > rate[j+1])
				{
					swap = rate[j];
					rate[j] = rate[j+1];
					rate[j+1] = swap;
				}

		midRate = rate[idx >> 1];
	}
	else if(idx > 0)
		midRate = rate[0];

	if(midRate > 0)
	{
		*pRate = midRate;
		RTK_PLAYER_INF("[%d] bit rate = %d\n", __LINE__, midRate);
	}

	return RTK_OK;
}


int RTKPlayer::xReSyncStream(unsigned char* pData, unsigned int bytes)
{
	int offset=0;
	
	while(offset < (int)bytes) 
	{
		if(pData[offset] != 0x47)
		{ 
			offset++;
		}
		else
		{
			if((offset+188)<(int)bytes)
			{
				// check next sync word
				if(pData[offset+188] == 0x47)
					break;
				else
				{
					offset++;
					continue;
				}
					
			}
			else
			{ 
				offset=-1;
				break;
			}
		}
	}
	return offset;

}


void RTKPlayer::xEstimateByteRate(FILE *pfile, int bufferSize)
{
	int totalBytes = bufferSize;
	int PCRPID = 0x1fff;
	int result = 0;
	int m_pTsBufferSize = DEFAULT_READ_WRITE_SIZE;
	int sector_size = lcm(188, SECTOR_SIZE);
	int readSize = m_pTsBufferSize;
	RTK_PLAYER_INF("sector_size=%d.readSize=%d.m_pTsBufferSize=%d.\n",sector_size,readSize,m_pTsBufferSize);

	int idx = 0, offset = 0;
	long long pTime[NUM_PARSE_BLOCK];
	long long pPosition[NUM_PARSE_BLOCK]; // in bytes
	long long blockSize = totalBytes/ NUM_PARSE_BLOCK;

	RTK_PLAYER_INF("blockSize=%lld.totalBytes=%d.MIN_PARSE_BLOCK_SIZE=%d.SECTOR_SIZE=%d.\n",blockSize,totalBytes,MIN_PARSE_BLOCK_SIZE,sector_size);


	if (blockSize < MIN_PARSE_BLOCK_SIZE)	return;
	if (blockSize < readSize) {
		readSize = blockSize/sector_size * sector_size;
	}

	bool bLinear = true;
	int readIteration = blockSize / readSize;

	if (readIteration == 0)
	{
		readSize = SMALL_FILE_READ_SIZE;
		readIteration = blockSize / readSize;
	}

	RTK_PLAYER_INF("readIteration=[%d] blockSize=[%lld] readSize=[%d]\n",readIteration, blockSize, readSize);
	readIteration = (readIteration > 5) ? 5 : readIteration;


	for (int i = 0; i < NUM_PARSE_BLOCK; i++)
	{
		pPosition[idx] = (i * blockSize) / sector_size * sector_size;
		RTK_PLAYER_INF("seek to sec.%d ->%lld\n",i,pPosition[idx]);
		fseek(pfile,pPosition[idx],SEEK_SET);
		for (int j = 0; j < readIteration; j++)
		{
			fread(m_pDurationBuffer, readSize, 1, pfile);
			result = readSize;
			offset = xReSyncStream(m_pDurationBuffer, readSize);
			if (offset>=0 && xGetPCR(m_pDurationBuffer+offset, readSize-offset, &pPosition[idx], &pTime[idx], &PCRPID, &bLinear, true) == RTK_OK)
			{
				idx++;
				break;
			}
		}
	}

	unsigned int byteRate = 0;
	if (idx != NUM_PARSE_BLOCK) {
		bLinear = false;
		RTK_PLAYER_INF("idx=%d != NUM_PARSE_BLOCK.bLinear = false.\n",idx);
	}

	if (xGetMiddleRate(pTime, pPosition, idx, &byteRate, &bLinear) != RTK_OK) {
		return;
	}
	RTK_PLAYER_INF("GetMiddleRate().bLinear=%d.byteRate=%d.\n",bLinear,byteRate);

	if (bLinear)//calculate ts duration
	{
		m_beginPCR = pTime[0];
		RTK_PLAYER_INF("[%d] m_beginPCR = %lld, PCRID=0x%x\n", __LINE__, m_beginPCR, PCRPID);

		/* Get the last PCR to calculate totalSeconds */
		long long blockBoundary = (blockSize > readSize) ?( totalBytes - blockSize) : (totalBytes - readSize);
		pPosition[0] = totalBytes;
		RTK_PLAYER_INF("[%d].pPosition[0]=%lld.blockBoundary=%lld.\n",__LINE__,pPosition[0],blockBoundary);

		/* If there is a chunk of stuffing byte (0x0) in the file end,
			it will take a long time to find sync word.
			Therefore, we should reduce the re-try iteration to 100.
		*/

		int count = 0;
		while (pPosition[0] >= blockBoundary && count <= 10)
		{
			pPosition[0] = (pPosition[0] - readSize) / sector_size * sector_size;

			fseek(pfile,pPosition[0],SEEK_SET);

			if (fread(m_pDurationBuffer, readSize, 1, pfile) > 0)
			{
				offset = xReSyncStream(m_pDurationBuffer, readSize);
				if (offset>=0)
				{
					xGetPCR(m_pDurationBuffer+offset, readSize-offset, &pPosition[0], &pTime[0], &PCRPID, &bLinear, false);
				}
				if (pTime[0] > m_beginPCR)
				{
					m_mediaInfo.TotalSeconds = (pTime[0] - m_beginPCR ) / 90000;
					RTK_PLAYER_INF("[%d:%s].calculated byteRate=%d by PCR.totalSeconds=%lld.\n",__LINE__,__func__,byteRate,m_mediaInfo.TotalSeconds);
					break;
				}
				count++;
			}
		}
		m_mediaInfo.duration = m_mediaInfo.TotalSeconds*90000;
	}
	m_mediaInfo.ByteRate = byteRate;
	return;
}

char RTKPlayer::xParseFileInfo()
{
	FILE *fp;
	char strCtrlName[256]={0x00};
	unsigned int filesize;

	if(m_InputType != RTKPLAYER_INPUT_FILE)
		return RTK_ERR;
	//open  file.
	snprintf(strCtrlName, 256, "%s", m_demuxConfig.input.memory.filePath);
	fp = fopen(strCtrlName, "rb+");
	if(fp == NULL)
	{
		RTK_PLAYER_ERR("%s %d: ERROR to open %s file!\n", __FUNCTION__, __LINE__, strCtrlName);
		return RTK_ERR;
	}
	RTK_PLAYER_INF("%s %d: success to open %s file!\n", __FUNCTION__, __LINE__, strCtrlName);

	// read first / last pts
	fseek(fp,0,SEEK_END); 
	filesize = ftell(fp); 
	m_mediaInfo.TotalBytes = filesize;
	m_pDurationBuffer=(unsigned char*)malloc(188*1024);

	xEstimateByteRate(fp,filesize);
		
	//if(m_mediaInfo.ByteRate != 0)
		//m_mediaInfo.TotalSeconds = filesize /m_mediaInfo.ByteRate;
	fclose(fp);


	if(m_pDurationBuffer != NULL)
		free(m_pDurationBuffer);
	
	return RTK_OK;

}


char RTKPlayer::xParseCtrlData()
{
	FILE *fp;
	char strCtrlName[256]={0x00};
	PTS_OFFSET_T first, temp, last;
	int i=0;
	UINT64_T minPtsDiff = 0, previousPts = 0;
	memset(&first, 0, sizeof(PTS_OFFSET_T));

	if(m_InputType != RTKPLAYER_INPUT_FILE)
		return RTK_ERR;

	//open ctrl file.
	snprintf(strCtrlName, 256, "%s_ctrl.dat", m_demuxConfig.input.memory.filePath);
	fp = fopen(strCtrlName, "rb+");
	if(fp == NULL)
	{
		RTK_PLAYER_ERR("%s %d: ERROR to open %s file!\n", __FUNCTION__, __LINE__, strCtrlName);
		m_mediaInfo.ctrlDataSupport = false;
		return RTK_ERR;
	}
	RTK_PLAYER_INF("%s %d: success to open %s file!\n", __FUNCTION__, __LINE__, strCtrlName);
	m_mediaInfo.ctrlDataSupport = true;
	
	// read first / last pts
	while(i < 10)
	{
		if( 1 != fread( &temp, sizeof(PTS_OFFSET_T), 1, fp))
		{
			RTK_PLAYER_INF("%s %s %d: fail to read file\n", __FILE__, __FUNCTION__, __LINE__);
			break;
		}

		if(i==0)
		{
			first = temp;
		}
		else
		{
			if(first.pts > temp.pts )
				first = temp;

			if(i==1)
				minPtsDiff = temp.pts - previousPts;

			if(minPtsDiff > temp.pts - previousPts && temp.pts > previousPts)
				minPtsDiff = temp.pts - previousPts;
		}
		previousPts = temp.pts;
		i++;
	}

	int retValue = fseek( fp, -(sizeof(PTS_OFFSET_T)) ,SEEK_END);
	if(retValue < 0){
		RTK_PLAYER_ERR("%s %s %d: failed fseek last PTS\n", __FILE__, __FUNCTION__, __LINE__);
	}
	if( 1 != fread( (void*)&last, sizeof(PTS_OFFSET_T), 1, fp))
	{
		RTK_PLAYER_ERR("%s %s %d: failed read last PTS\n", __FILE__, __FUNCTION__, __LINE__);
		fclose(fp);
		return RTK_ERR;
	}
	RTK_PLAYER_INF("first %llx last %llx\n", first.pts, last.pts);

	fclose(fp);

	//update duration
	m_mediaInfo.duration = last.pts - first.pts;
	m_mediaInfo.firstPTS = first.pts;
	m_mediaInfo.ctrlSampleDuration = minPtsDiff;
	if(m_mediaInfo.duration < 0) m_mediaInfo.duration += PTS_MAXMUN; // ringback
	return RTK_OK;
}


char RTKPlayer::xParseExmInfo(const char *sourceUrl, RTKCA_Descramble_ECM_info_t *exmInfo)
{
        char ret = RTK_OK;
	char *strUrl, *strUrlInfo;
	char *pDupUrl=(char*)strdup(sourceUrl);
	
	strUrl = strtok (pDupUrl, "?");
	strUrlInfo = strtok (NULL, "?"); // derive the stream info
	
	// parse exmInfo (emm, ecm)
	char *pch;
	int info = 0;
        int ecmNum = 0;
	pch = strtok(strUrlInfo,"&");
	while (pch != NULL)
	{
        	if(strncmp(pch, "mp=", 3) ==0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("emm pid:0x%x \n",info);
			exmInfo->emm_pid =static_cast<uint16_t>(info);        
		}
		else if (strncmp(pch, "cp=", 3) == 0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("ecm pid: 0x%x \n",info);
			exmInfo->ecm_AVPids[ecmNum].ecm_pid = static_cast<uint16_t>(info);
                      pch = strtok(NULL,"&");
                      if(strncmp(pch, "vp=", 3) == 0)
        		{
        			info = atoi(pch+3);
        			RTK_PLAYER_INF("video pid: %d\n", info);
        			exmInfo->ecm_AVPids[ecmNum].stream_pid = static_cast<uint16_t>(info);
        		}
        		else if(strncmp(pch, "ap=", 3) == 0)
        		{
        			info = atoi(pch+3);
        			RTK_PLAYER_INF("audio pid: %d\n", info);
        			exmInfo->ecm_AVPids[ecmNum].stream_pid = static_cast<uint16_t>(info);
        		 }
                        else
                        {
                            ret = RTK_ERR;
                            RTK_PLAYER_ERR("ecm pid [0x%x] has no A/V pid, Plz check source URL!!\n", exmInfo->ecm_AVPids[ecmNum].ecm_pid);
                        }
                        ecmNum++;

		}

            pch = strtok(NULL,"&");
	}

    if(NULL != pDupUrl)
   {
        free(pDupUrl);
        pDupUrl = NULL;
   }
    if(0 == ecmNum || exmInfo->emm_pid == 0x00)
    {
        RTK_PLAYER_ERR("Parse exm info error case \n");
        ret = RTK_ERR;
    }
    return ret;
}


char RTKPlayer::xSetDataSource(const char *sourceUrl)
{
	if(sourceUrl == NULL)
	{
		RTK_PLAYER_ERR("Input File Path Error, is NULL");
		return RTK_ERR;
	}
	RTK_PLAYER_INF("strUrl=%s", sourceUrl);
	char *strUrl, *strUrlInfo;
	char *pDupUrl=(char*)strdup(sourceUrl);
	
	strUrl = strtok (pDupUrl, "?");
	strUrlInfo = strtok (NULL, "?"); // derive the stream info
	
#ifdef DUMP_FEED
	char dumppath[] = "/data/mediadrm/dumpfeed";
	m_DumpFd = fopen(dumppath, "wb+");
	if(m_DumpFd == NULL)
	{
		RTK_PLAYER_ERR("[DUMP]%d: fail!! ERROR to open %s dumpfile!\n", __LINE__, dumppath);
	}
	else
	{
		RTK_PLAYER_INF("[DUMP]%d: success!! Success to open %s dumpfile!\n", __LINE__, dumppath);
	}
#endif

	if((strncmp(strUrl, "udp://", 6) == 0)||(strncmp(strUrl, "tcp://", 6) == 0))
	{
		if(strncmp(strUrl, "udp://", 6) == 0)
			m_mediaInfo.source = RTKPLAYER_SOURCE_UDP;
		else if(strncmp(strUrl, "tcp://", 6) == 0)
			m_mediaInfo.source = RTKPLAYER_SOURCE_TCP;

		m_InputType = RTKPLAYER_INPUT_IPTV;
	}
	else if(strncmp(strUrl, "pvr://", 6) == 0 || strncmp(strUrl, "tsfile://", 9) == 0)
	{
		m_mediaInfo.source = RTKPLAYER_SOURCE_FILE;
		m_InputType = RTKPLAYER_INPUT_FILE;
		if(strncmp(strUrl, "pvr://", 6) == 0){
			m_isPvr = true;
		}
	}
	else if(strncmp(strUrl, "tuner://", 8) == 0)
	{
		m_mediaInfo.source = RTKPLAYER_SOURCE_TUNER;
		m_InputType = RTKPLAYER_INPUT_TUNER;
		m_firstplayready = 0;
		memset(&tunerParam, 0, sizeof(RTK_TunerParam_t));
	}
		
	RTK_PLAYER_INF("[%d]m_arch=%d m_InputType=%d", __LINE__,m_arch,m_InputType);

 	m_demuxConfig.callback.user_param= (void*)this;
	m_demuxConfig.callback.function = HalCallbackEntry;
	m_demuxConfig.input.type = RTK_INPUT_SOURCE;
	m_demuxConfig.input.enableTimeShift= (m_arch == ARCH_DEMUX_AND_PLAY)? RTK_TRUE : RTK_FALSE;
	m_demuxConfig.input.isEncrypt = RTK_FALSE;
	if(m_ForceAudioFocused == RTK_TRUE)
	{
        m_demuxConfig.audio.focused = m_ForceAudioFocusedState;
		
	}else if(m_demuxConfig.video.output != RTK_WIN_PIP) 
		m_demuxConfig.audio.focused =RTK_TRUE; 

	if(m_InputType == RTKPLAYER_INPUT_TUNER)
	{
		RTK_PLAYER_INF("Input Tuner :: strUrl=%s", strUrl);
	
		if(strncmp(strUrl, "tuner://DVBC:", 13) == 0)
		{
			strUrl += 13;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DVBC;
		}
		else if(strncmp(strUrl, "tuner://DVBS:", 13) == 0)
		{
			strUrl += 13;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DVB_S;
		}
		else if(strncmp(strUrl, "tuner://DVBS2:", 14) == 0)
		{
			strUrl += 14;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DVB_S2;
		}
		else if(strncmp(strUrl, "tuner://DTMB:", 13) == 0)
		{
			strUrl += 13;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DTMB;
		}
		else if(strncmp(strUrl, "tuner://DVBT:", 13) == 0)
		{
			strUrl += 13;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DVB_T ;
		}
		else if(strncmp(strUrl, "tuner://DVBT2:", 14) == 0)
		{
			strUrl += 14;
			m_demuxConfig.input.tuner.type = RTK_TUNER_TYPE_DVB_T2 ;
		}
		else
		{
			RTK_PLAYER_ERR("Input Tuner parameter error!");
                      if(pDupUrl)                      
                      {
                            free(pDupUrl);
                      }

			return RTK_ERR;
		}
		tunerParam.type = m_demuxConfig.input.tuner.type;

		if(m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVB_S2 || 
			m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVB_S || 
			m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVBC)
		{
			unsigned int uiFreq = 0, uiRate = 0, uiLnbOrQam = 0;
			char uiBandw[3]={"8M"};
			sscanf(strUrl, "%d:%d:%d:%2s", &uiFreq, &uiLnbOrQam, &uiRate,uiBandw);
		    RTK_PLAYER_INF("[%s,%d] freq = %d, qam = %d, rate = %d bandwidth = %s ,", __func__, __LINE__, uiFreq, uiLnbOrQam, uiRate,uiBandw);
			if (m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVBC)
				{
					RTK_PLAYER_INF("Input Tuner qam=%d", uiLnbOrQam);
					switch (uiLnbOrQam)
					{
						case 16:
					 		m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation =RTK_CABLETNR_16QAM;
						break;
						
						case 32:
							m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_32QAM;
						break;
						
						case 64:						
							m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_64QAM;
						break;
						
						case 128:
							m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_128QAM;
						break;
						
						case 256:
							m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
						break;
						
						default:
							m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_64QAM;
						break;						
					}
					m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32frequency = uiFreq;
					m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32symbol_rate = uiRate;
					
					tunerParam.tnr_param.dvb_c_param.modulation = m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation;
					if(strncmp(uiBandw, "6M ", 2) == 0){
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_6M;
					}else if(strncmp(uiBandw, "7M ", 2) == 0){
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_7M;
					}else{
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_8M;
					}

					tunerParam.tnr_param.dvb_c_param.u32symbol_rate = uiRate;
					tunerParam.tnr_param.dvb_c_param.annex_type = RTK_DVBC_ANNEX_A;
					tunerParam.tnr_param.dvb_c_param.u32frequency = uiFreq;
					m_demuxConfig.input.tuner.bandwidth = tunerParam.bandwidth ;

					RTK_PLAYER_INF("Input Tuner DVBC freq=%d,qam=%d, modulation=%d ,tunerParam.bandwidth =%d", uiFreq, uiLnbOrQam, uiRate,tunerParam.bandwidth);
				}
				else
				{
					RTK_PLAYER_INF("Input Tuner lnb=%d", uiLnbOrQam);
					switch (uiLnbOrQam)
					{
						case 0:
					 		m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
						break;
						
						case 13:
							m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V;
						break;
						
						case 18:						
							m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V;
						break;
						
						case 1322:
							m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V_WITH_22K_BURST;
						break;
						
						case 1822:
							m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V_WITH_22K_BURST;
						break;
						
						default:
							m_demuxConfig.input.tuner.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
						break;						
					}
					m_demuxConfig.input.tuner.tnr_param.dvb_s_param.u32frequency = uiFreq;
					m_demuxConfig.input.tuner.tnr_param.dvb_s_param.u32symbol_rate = uiRate;
					if(strncmp(uiBandw, "6M ", 2) == 0){
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_6M;
					}else if(strncmp(uiBandw, "7M ", 2) == 0){
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_7M;
					}else{
							tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_8M;
					}

					m_demuxConfig.input.tuner.bandwidth = tunerParam.bandwidth ;
					if(m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVB_S)
					{
						RTK_PLAYER_INF("Input Tuner DVBS freq=%d,lnb=%d, rate=%d", uiFreq, uiLnbOrQam, uiRate);
					}
					else
					{
						RTK_PLAYER_INF("Input Tuner DVBS2 freq=%d,lnb=%d, rate=%d", uiFreq, uiLnbOrQam, uiRate);
					}
				}
				
				if(/*uiFreq < 0 || */uiFreq > RTK_MAX_TUNER_FREQUENCE_MHZ)
				{
					RTK_PLAYER_ERR("Input Tuner freq=%d is out of range", uiFreq);
					if(pDupUrl)
					{
						free(pDupUrl);
					}					
					return RTK_ERR;
				}
			
		}		
	        else if(m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVB_T ||
	                        m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DVB_T2)
	        {
	            unsigned int uiFreq = 0;
	            char uiBandw[3]={"8M"};
	            sscanf(strUrl, "%d:%2s", &uiFreq,uiBandw);
	            RTK_PLAYER_INF("[%s,%d] freq = %d,    bandwidth = %s ,", __func__, __LINE__, uiFreq,uiBandw);
	            m_demuxConfig.input.tuner.tnr_param.dvb_t_param.u32frequency = uiFreq;
	            RTK_PLAYER_INF("Input Tuner DVBT u32frequency=%d", uiFreq);
	            if(strncmp(uiBandw, "5M ", 2) == 0)
	            {
	                tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_5M;
	            }else if(strncmp(uiBandw, "6M ", 2) == 0)
	            {
	                tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_6M;
	            }else if(strncmp(uiBandw, "7M ", 2) == 0)
	            {
	                tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_7M;
	            }else
	            {
	                tunerParam.bandwidth = RTK_TUNER_BANDWIDTH_8M;
	            }
	            m_demuxConfig.input.tuner.bandwidth = tunerParam.bandwidth ;

	            RTK_PLAYER_INF("Input Tuner DVBT/DVBT2 freq=%d,tunerParam.bandwidth =%d", uiFreq,tunerParam.bandwidth);

	            if(/*uiFreq < 0 || */uiFreq > RTK_MAX_TUNER_FREQUENCE_MHZ)
	            {
	                RTK_PLAYER_ERR("Input Tuner freq=%d is out of range", uiFreq);
	                if(pDupUrl)
	                {
	                    free(pDupUrl);
	                }                    
	                    return RTK_ERR;
	            }
	        }
		else if(m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DTMB)
		{
			unsigned int uiFreq = 0;
			if(1 == sscanf(strUrl, "%d", &uiFreq))
			{
				if (m_demuxConfig.input.tuner.type == RTK_TUNER_TYPE_DTMB)
				{
					m_demuxConfig.input.tuner.tnr_param.dtmb_t_param.u32frequency = uiFreq;
					RTK_PLAYER_INF("Input Tuner DTMB u32frequency=%d", uiFreq);
				}
				
			}
			else
			{
				RTK_PLAYER_ERR("Input Tuner parameter error!");
				return RTK_ERR;
			}
		}
		memcpy(&tunerParam,&m_demuxConfig.input.tuner,sizeof(RTK_TunerParam_t));	
	}

	else if( m_InputType == RTKPLAYER_INPUT_FILE )
	{
		RTK_PLAYER_INF("Input File !!");

		if(m_demuxConfig.input.memory.filePath == NULL)
		{
			m_demuxConfig.input.memory.filePath = (INT8_T *)malloc(strlen(strUrl)+1);
		}
		if(m_demuxConfig.input.memory.filePath)
		{
			memset(m_demuxConfig.input.memory.filePath,0x00,strlen(strUrl)+1);
			if(strncmp(strUrl, "pvr://", 6) == 0)
			{
				memcpy(m_demuxConfig.input.memory.filePath, strUrl+6, strlen(strUrl)-6);
				m_demuxConfig.input.isEncrypt = RTK_TRUE;
			}
			else // "tsfile://xxxxx"
			{
				memcpy(m_demuxConfig.input.memory.filePath, strUrl+9, strlen(strUrl)-9);
			}
		}

		//open ctrl file.
		char strCtrlName[256]={0x00};
		snprintf(strCtrlName, 256, "%s_ctrl.dat", m_demuxConfig.input.memory.filePath);
		m_recordingCtrl_Rd = fopen(strCtrlName, "rb+");
	}	
	else if(m_InputType == RTKPLAYER_INPUT_IPTV )
	{	
		RTK_PLAYER_INF("Input IPTV:: strUrl=%s", strUrl);
		if(strncmp(strUrl, "udp://", 6) == 0)
		{
			//ex: udp://239.192.150.122:49220
			m_demuxConfig.input.iptv.e_socket_type = RTK_UDP_SOCKET;
			xExtrackURLInfo(strUrl, 6);
		}
		else if(strncmp(strUrl, "tcp://", 6) == 0)
		{
			//ex : tcp://239.192.150.122:49220
			m_demuxConfig.input.iptv.e_socket_type = RTK_TCP_SOCKET;
			xExtrackURLInfo(strUrl, 6);
		}
		else if(strncmp(strUrl, "http://", 7) == 0)
		{
			m_demuxConfig.input.iptv.e_socket_type = RTK_HTTP_SOCKET;
			xExtrackURLInfo(strUrl, 7);
		}
	}
	else
	{
		RTK_PLAYER_ERR("Param Error!!");
		if(pDupUrl)
			free(pDupUrl);
		return RTK_ERR;
	}


	// parse stream info (pid, codec)
	char *pch;
	int info = 0;
	pch = strtok(strUrlInfo,"&");
	while (pch != NULL)
	{
		if(strncmp(pch, "vp=", 3) == 0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("video pid: %d\n", info);
			m_demuxConfig.video.pid  = static_cast<uint16_t>(info);
			m_playerConfig.video.pid = static_cast<uint16_t>(info);
		}
		else if(strncmp(pch, "ap=", 3) == 0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("audio pid: %d\n", info);
			m_demuxConfig.audio.pid      = static_cast<uint16_t>(info);
			m_playerConfig.audio.pid     = static_cast<uint16_t>(info);

			if(m_demuxConfig.video.output != RTK_WIN_PIP) 
				m_playerConfig.audio.focused=m_demuxConfig.audio.focused=RTK_TRUE;
			else
				m_playerConfig.audio.focused=m_demuxConfig.audio.focused=RTK_FALSE;
		}
		else if(strncmp(pch, "vc=", 3) == 0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("video codec: %d\n", info);
			if (m_InputType == RTKPLAYER_INPUT_TUNER)
			{
				m_demuxConfig.video.codec  = _xTS_Transfer_Video_Codec(info);
				m_playerConfig.video.codec = _xTS_Transfer_Video_Codec(info);
			}
			else
			{
				m_demuxConfig.video.codec  = (RTK_Codec)info;
				m_playerConfig.video.codec = (RTK_Codec)info;

			}
		}
		else if(strncmp(pch, "ac=", 3) == 0)
		{
			info = atoi(pch+3);
			RTK_PLAYER_INF("audio codec: %d\n", info);
			if (m_InputType == RTKPLAYER_INPUT_TUNER)
			{
				m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(info);
				m_playerConfig.audio.codec = _xTS_Transfer_Audio_Codec(info);
			}
			else
			{
				m_demuxConfig.audio.codec  = (RTK_Codec)info;
				m_playerConfig.audio.codec = (RTK_Codec)info;
			}
		}
		pch = strtok(NULL, "&");
	}

	// TODO: for stream encrypt&decrypt.
	//m_demuxConfig.video.encrypted = RTK_TRUE;
	//m_demuxConfig.audio.encrypted = RTK_FALSE;	

	if(m_InputType == RTKPLAYER_INPUT_IPTV && m_mediaInfo.source == RTKPLAYER_SOURCE_UDP)
	{
		int ret = 0;
		ret = check_channellist(strUrl);

		if(ret == -1)
		{
			m_saveurlflag = 1;
			//new url info;
		}
		else if(ret == 0)
		{
			m_demuxConfig.video.pid  = cur_it->second.videopid;
			m_playerConfig.video.pid = cur_it->second.videopid;
			m_demuxConfig.video.codec  = cur_it->second.videocodec;
			m_playerConfig.video.codec = cur_it->second.videocodec;
			m_demuxConfig.audio.pid  = cur_it->second.audiopid;
			m_playerConfig.audio.pid = cur_it->second.audiopid;
			m_demuxConfig.audio.codec = cur_it->second.audiocodec;
			m_playerConfig.audio.codec = cur_it->second.audiocodec;
			m_saveurlflag = 0;
			// this url areadly exist in channellist;
		}
		else if(ret == 1)
		{
			m_saveurlflag = -1;
			// something wrong might happen
		}
	}
	else
	{
		m_saveurlflag = -1; //need not save url info
	}

	if (m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		//memcpy(&m_playerConfig.callback,&m_demuxConfig.callback, sizeof(RTK_CallbackConfig));
		//memcpy(&m_playerConfig.input, &m_demuxConfig.input, sizeof(RTK_InputConfig));
		memcpy(&m_playerConfig, &m_demuxConfig, sizeof(RTK_PlayerConfig));
	}
	if(m_updateinfoflag ==1){
		m_receivedProgramCount = 0;
		xResetProgramInfo();
	}
	if(pDupUrl)
		free(pDupUrl);
	
	return RTK_OK;

}

inline void RTKPlayer::xExtrackURLInfo(char * url, int protocol_len)
{
	unsigned int i=0;
	for(i=protocol_len; i<strlen(url); i++)
	{
		if(*(url+i)== ':')
		{
			break;
		}
	}

	memset(m_demuxConfig.input.iptv.iStrIP,0,sizeof(m_demuxConfig.input.iptv.iStrIP));
	//should do this, it may occur url not corrert after memcpy ,or can use strcpy
	
	memcpy(m_demuxConfig.input.iptv.iStrIP, url+protocol_len, i-protocol_len);
	
	char *str=(char*)malloc(strlen(url)+1);
	if(str==NULL)
	{
		RTK_PLAYER_ERR("mallloc (%d) fail\n", strlen(url)+1);
		return;
	}	
	memset(str, 0x00, strlen(url)+1);
	
	strncpy(str, url+i+1, strlen(url)-i-1);
	m_demuxConfig.input.iptv.iPort = atoi(str);
	
	free(str);
}

inline void RTKPlayer::xResetProgramInfo()
{
	bzero(&m_programInfo, sizeof(TS_Program_Info));
	m_programInfo.pat_program.version = 0xff;
	m_programInfo.cat_program.version = 0xff;

	bzero(&m_fullscanInfo, sizeof(FullSacnProInfo));
	for(int i=0;i<FULLSACN_PROGRAME_CNT;i++) m_fullscanInfo.psi_program[i].version= 0xff;

}

void RTKPlayer::xCleanRecordProgram(void)
{
	if( m_demux != NULL)
	{
		if( RTK_Player_RemoveAllTSFilters(m_demux) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to remove all ts filters.\n");
		}
	}
	bzero(&m_RecProgram, sizeof(TS_PSI_Program));
	m_patTSFilterHandle = NULL;
	m_pmtTSFilterHandle = NULL;
	m_videoTSFilterHandle = NULL;
	memset(m_audioTSFilterHandle, 0x00, sizeof(m_audioTSFilterHandle));
	memset(m_subtitleTSFilterHandle, 0x00, sizeof(m_subtitleTSFilterHandle));
}

void RTKPlayer::xUpdateRecordProgram(TS_PSI_Program program)
{
	RTK_TSFilter filterHandle;
	RTK_TSFilterPattern filterPattern;

	// PAT
	if(m_patTSFilterHandle == NULL)
	{
		filterPattern.pid = 0x00;
		filterPattern.codec = RTK_CODEC_NONE;
		filterPattern.encrypt = RTK_FALSE;
		filterPattern.isAnchor = RTK_FALSE;
		if(RTK_Player_AddTSFilter(m_demux, &filterPattern, &filterHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("%s add PAT error!\n", __FUNCTION__);
			return;
		}
		m_patTSFilterHandle = filterHandle;
	}

	if( program.map_pid == 0x00 )
	{
		RTK_PLAYER_ERR("%s program not ready\n",__FUNCTION__);
		return;
	}

	if( m_RecProgram.program_number == program.program_number &&
		m_RecProgram.map_pid == program.map_pid &&
		m_RecProgram.version == program.version )
	{
		RTK_PLAYER_INF("%s program not change\n",__FUNCTION__);
		return;
	}

	// PMT
	if( m_RecProgram.map_pid != program.map_pid )
	{
		// remove old PMT
		if(m_pmtTSFilterHandle != NULL)
		{
			if(RTK_Player_RemoveTSFilter(m_demux, m_pmtTSFilterHandle) != RTK_OK)
			{
				RTK_PLAYER_ERR("%s remove PMT error!\n",__FUNCTION__);
			}
		}

		// add new PMT
		filterPattern.pid = program.map_pid;
		filterPattern.codec = RTK_CODEC_NONE;
		filterPattern.encrypt = RTK_FALSE;
		filterPattern.isAnchor = RTK_FALSE;
		if(RTK_Player_AddTSFilter(m_demux, &filterPattern, &filterHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("%s add PMT 0x%x error!\n", __FUNCTION__, filterPattern.pid);
		}
		m_pmtTSFilterHandle = filterHandle;
	}

	// video
	if( (m_RecProgram.video_pids[0].pid != program.video_pids[0].pid) ||
		(m_RecProgram.video_pids[0].codec != program.video_pids[0].codec) )
	{
		// remove old video
		if(m_videoTSFilterHandle != NULL)
		{
			if(RTK_Player_RemoveTSFilter(m_demux, m_videoTSFilterHandle) != RTK_OK)
			{
				RTK_PLAYER_ERR("%s remove video error!\n",__FUNCTION__);
			}
		}

		// add new video
		filterPattern.pid = program.video_pids[0].pid;
		filterPattern.codec = _xTS_Transfer_Video_Codec(program.video_pids[0].codec);
		filterPattern.encrypt = RTK_TRUE;	//captured packets encrypted or not. (AV pids for recording)
		filterPattern.isAnchor = RTK_TRUE;
		if(RTK_Player_AddTSFilter(m_demux, &filterPattern, &filterHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("%s add video 0x%x error!\n",__FUNCTION__, filterPattern.pid);
		}
		m_videoTSFilterHandle = filterHandle;
	}

	// audio
	RTK_TSFilter new_audioTSFilterHandle[TSPSIMGR_MAX_PIDS];
	memset(new_audioTSFilterHandle, 0x00, sizeof(new_audioTSFilterHandle));

	// check old audio
	for(int i=0; i<m_RecProgram.num_audio_pids; i++)
	{
		int new_num = -1;
		for(int j=0; j<program.num_audio_pids; i++)
		{
			if( (m_RecProgram.audio_pids[i].pid == program.audio_pids[j].pid) &&
				(m_RecProgram.audio_pids[i].codec == program.audio_pids[j].codec) )
			{
				new_num = j;
				break;
			}
		}

		if(new_num == -1) // not exist any more => remove
		{
			if(m_audioTSFilterHandle[i] != NULL)
			{
				if(RTK_Player_RemoveTSFilter(m_demux, m_audioTSFilterHandle[i]) != RTK_OK)
				{
					RTK_PLAYER_ERR("%s remove audio error!\n",__FUNCTION__);
				}
			}
		}
		else // continue use
		{
			new_audioTSFilterHandle[new_num] = m_audioTSFilterHandle[i];
		}
	}
	// add new audio
	for(int j=0; j<program.num_audio_pids; j++)
	{
		if(new_audioTSFilterHandle[j] == NULL)
		{
			filterPattern.pid = program.audio_pids[j].pid;
			filterPattern.codec = _xTS_Transfer_Audio_Codec(program.audio_pids[j].codec);
			filterPattern.encrypt = RTK_TRUE;	//captured packets encrypted or not. (AV pids for recording)
			filterPattern.isAnchor = RTK_FALSE;
			if(RTK_Player_AddTSFilter(m_demux, &filterPattern, &filterHandle) != RTK_OK)
			{
				RTK_PLAYER_ERR("%s add audio 0x%x error!\n",__FUNCTION__, filterPattern.pid);
			}
			new_audioTSFilterHandle[j] = filterHandle;
		}
	}
	memcpy(m_audioTSFilterHandle, new_audioTSFilterHandle,sizeof(m_audioTSFilterHandle));

	// subtitle
	RTK_TSFilter new_subtitleTSFilterHandle[TSPSIMGR_MAX_PIDS];
	memset(new_subtitleTSFilterHandle, 0x00, sizeof(new_subtitleTSFilterHandle));

	// check old subtitle
	for(int i=0; i<m_RecProgram.num_subtitle_pids; i++)
	{
		int new_num = -1;
		for(int j=0; j<program.num_subtitle_pids; i++)
		{
			if( m_RecProgram.subtitle_pids[i].pid == program.subtitle_pids[j].pid )
			{
				new_num = j;
				break;
			}
		}

		if(new_num == -1) // not exist any more => remove
		{
			if(m_subtitleTSFilterHandle[i] != NULL)
			{
				if(RTK_Player_RemoveTSFilter(m_demux, m_subtitleTSFilterHandle[i]) != RTK_OK)
				{
					RTK_PLAYER_ERR("%s remove subtitle error!\n",__FUNCTION__);
				}
			}
		}
		else // continue use
		{
			new_subtitleTSFilterHandle[new_num] = m_subtitleTSFilterHandle[i];
		}
	}
	// add new subtitle
	for(int j=0; j<program.num_subtitle_pids; j++)
	{
		if(new_subtitleTSFilterHandle[j] == NULL)
		{
			filterPattern.pid = program.subtitle_pids[j].pid;
			filterPattern.codec = RTK_CODEC_NONE;
			filterPattern.encrypt = RTK_TRUE;
			filterPattern.isAnchor = RTK_FALSE;
			if(RTK_Player_AddTSFilter(m_demux, &filterPattern, &filterHandle) != RTK_OK)
			{
				RTK_PLAYER_ERR("%s add subtitle 0x%x error!\n",__FUNCTION__, filterPattern.pid);
			}
			new_subtitleTSFilterHandle[j] = filterHandle;
		}
	}
	memcpy(m_subtitleTSFilterHandle, new_subtitleTSFilterHandle,sizeof(m_subtitleTSFilterHandle));


	m_RecProgram = program;
	return;
}

char RTKPlayer::xAddPAT(void)
{
	RTK_SectionFilter patHandle;
	RTK_SectionFilterMask patPattern;

	if(m_patHandle == NULL)
	{
		bzero(patPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(patPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(patPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		patPattern.comp[0] = TS_PSI_TID_PAT;
		patPattern.mask[0] = 0xFF;
		patPattern.pid = TS_PSI_PID_PAT;
		patPattern.section_user_param = (void*)this;
		patPattern.callback_01 = SectionCallbackEntry;
		patPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		patPattern.options = 1;
		patPattern.u32byWaitTimeoutMs = 0;
		if (RTK_Player_AddSectionFilter(m_demux, &patHandle, &patPattern) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to add PAT section filter.\n");
			return RTK_ERR;
		}
		RTK_PLAYER_INF("xAddPAT\n");
		m_patHandle = patHandle;
	}
	return RTK_OK;
}

void RTKPlayer::xRemovePAT(void)
{
	if(m_patHandle)
	{
		if (RTK_Player_RemoveSectionFilter(m_demux, m_patHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to remove PAT section filter.\n");
		}
		RTK_PLAYER_INF("xRemovePAT\n");
		m_patHandle = NULL;
	}
	return;
}

char RTKPlayer::xAddCAT(void)
{
	RTK_SectionFilter catHandle;
	RTK_SectionFilterMask catPattern;

	if(m_catHandle == NULL)
	{
		bzero(catPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		catPattern.comp[0] = TS_PSI_TID_CAT;
		catPattern.mask[0] = 0xFF;
		catPattern.pid = TS_PSI_TID_CAT;
		catPattern.section_user_param = (void*)this;
		catPattern.callback_01 = SectionCallbackEntry;
		catPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(m_demux, &catHandle, &catPattern) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to add CAT section filter.\n");
			return RTK_ERR;
		}
		RTK_PLAYER_INF("xAddCAT\n");
		m_catHandle = catHandle;
	}
	return RTK_OK;
}

void RTKPlayer::xRemoveCAT(void)
{
	if(m_catHandle)
	{
		if (RTK_Player_RemoveSectionFilter(m_demux, m_catHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to remove CAT section filter.\n");
		}
		RTK_PLAYER_INF("xRemoveCAT\n");
		m_catHandle = NULL;
	}
	return;
}

char  RTKPlayer::xAddSDT(void)
{
    RTK_SectionFilter filter_handle;
    RTK_SectionFilterMask pattern;
//Create a sdt section filter.
    
    memset(pattern.comp, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mask, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mode, 0x00, RTK_MAX_SECTION_MASK_LENGTH);

    //SDT table id : 0x42
    pattern.comp[0] = 0x42;
    pattern.mask[0] = 0xFF;

    pattern.pid = 0x11;
    pattern.u32byWaitTimeoutMs = 0;
    pattern.section_user_param = (void*)this;
    pattern.callback_01 = SectionCallbackEntry;
    pattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;

    if (RTK_Player_AddSectionFilter(m_demux, &filter_handle, &pattern) != RTK_OK)
    {
        RTK_PLAYER_INF("Failed to add section filter. SDT SDT SDT\n");
        return RTK_ERR;
    }

	return RTK_OK;
}

char  RTKPlayer::xAddEIT(void)
{
    RTK_SectionFilter filter_handle;
    RTK_SectionFilterMask pattern;
//Create a sdt section filter.
    
    memset(pattern.comp, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mask, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mode, 0x00, RTK_MAX_SECTION_MASK_LENGTH);

    pattern.comp[0] = 0x00;
    pattern.mask[0] = 0x00;

    pattern.pid = 0x12;
    pattern.u32byWaitTimeoutMs = 0;
    pattern.section_user_param = (void*)this;
    pattern.callback_01 = SectionCallbackEntry;
    pattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;

    if (RTK_Player_AddSectionFilter(m_demux, &filter_handle, &pattern) != RTK_OK)
    {
        RTK_PLAYER_INF("Failed to add section filter. SDT SDT SDT\n");
        return RTK_ERR;
    }

	return RTK_OK;
}

char RTKPlayer::xAddTDT(void)
{
    RTK_SectionFilter filter_handle = NULL;
    RTK_SectionFilterMask pattern;
//Create a sdt section filter.
    
    memset(pattern.comp, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mask, 0x00, RTK_MAX_SECTION_MASK_LENGTH);
    memset(pattern.mode, 0x00, RTK_MAX_SECTION_MASK_LENGTH);

    pattern.comp[0] = 0x70;
    pattern.mask[0] =  0xFF;

    pattern.pid = 0x14;
    pattern.u32byWaitTimeoutMs = 0;
    pattern.section_user_param = (void*)this;
    pattern.callback_01 = SectionCallbackEntry;
    pattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;

    if (RTK_Player_AddSectionFilter(m_demux, &filter_handle, &pattern) != RTK_OK)
    {
        RTK_PLAYER_INF("Failed to add section filter: TDT \n");
        return RTK_ERR;
    }
	m_tdtHandle = filter_handle;
	return RTK_OK;
}

void RTKPlayer::xRemoveTDT(void)
{
	if(m_tdtHandle)
	{
		if (RTK_Player_RemoveSectionFilter(m_demux, m_tdtHandle) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to remove DTD section filter.\n");
		}
		RTK_PLAYER_INF("xRemoveCAT\n");
		m_tdtHandle = NULL;
	}
	return;
}


char RTKPlayer::xAddPMT(uint16_t pid)
{
	RTK_SectionFilter pmtHandle;
	RTK_SectionFilterMask pmtPattern;
	int index = -1;

	// check if add before
	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtFilterPID[i]== 0) // find out free space
		{
			if(index== -1) index = i;
			continue;
		}
		else if(m_pmtFilterPID[i] == pid) // already exist
		{
			index = i;
			break;
		}
	}

	if( index != -1 && m_pmtHandle[index] == NULL)
	{
		bzero(pmtPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		pmtPattern.comp[0] = TS_PSI_TID_PMT;
		pmtPattern.mask[0] = 0xFF;
		pmtPattern.options = 1;
		pmtPattern.u32byWaitTimeoutMs = 0;
		pmtPattern.pid = pid;
		pmtPattern.section_user_param = (void*)this;
		pmtPattern.callback_01 = SectionCallbackEntry;
		pmtPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(m_demux, &pmtHandle, &pmtPattern) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to add PMT section filter.\n");
			return RTK_ERR;
		}
		RTK_PLAYER_INF("xAddPMT PID 0x%x to index %d %p\n", pid, index, pmtHandle);
		m_pmtHandle[index] = pmtHandle;
		m_pmtFilterPID[index] = pid;
	}
	return RTK_OK;
}

void RTKPlayer::xRemovePMT(RTK_SectionFilter handle)
{
	int index = -1;

	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtHandle[i] == handle) // find out
		{
			index = i;
			break;
		}
	}
	if(index != -1)
	{
		if (RTK_Player_RemoveSectionFilter(m_demux, m_pmtHandle[index]) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to remove PAT section filter.\n");
			return;
		}
		RTK_PLAYER_INF("xRemovePMT PID 0x%x from index %d %p\n", m_pmtFilterPID[index], index, m_pmtHandle[index]);
		m_pmtHandle[index] = NULL;
		m_pmtFilterPID[index] = 0;
	}
	return;
}

void RTKPlayer::xChangeAvParm(int channelIndex)
{
        UNUSED(channelIndex);
	RTK_Player playerHandle = m_demux;
	RTK_Player tsFilterHandle = m_demux;
	bool video_isChanged=false;
	bool audio_isChanged=false;

	if( m_status != RTKPLAYER_STATUS_RUN )
	{
		return;
	}

	if( m_programInfo.psi_program[channelIndex].version == 0xff) // not ready
		return;

	if( !m_programInfo.psi_program[channelIndex].received ) // not ready
		return;

	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY ||m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	if((m_arch == ARCH_DEMUX)||(m_arch == ARCH_DEMUX_AND_PLAY))
	{
		tsFilterHandle = m_demux;
	}

	if((m_demuxConfig.video.pid != m_programInfo.psi_program[channelIndex].video_pids[0].pid)
			||(m_demuxConfig.video.codec != _xTS_Transfer_Video_Codec(m_programInfo.psi_program[channelIndex].video_pids[0].codec)))
	{
		m_playerConfig.video.pid = m_demuxConfig.video.pid = m_programInfo.psi_program[channelIndex].video_pids[0].pid;
		m_playerConfig.video.codec = m_demuxConfig.video.codec = _xTS_Transfer_Video_Codec(m_programInfo.psi_program[channelIndex].video_pids[0].codec);
		video_isChanged=true;
	}

	// audio count may change and index may larger than it => switch to 1st audio
	if( m_audioIndex >= m_programInfo.psi_program[channelIndex].num_audio_pids ) m_audioIndex = 0;

	if((m_demuxConfig.audio.pid != m_programInfo.psi_program[channelIndex].audio_pids[m_audioIndex].pid)
			||(m_demuxConfig.audio.codec != _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[channelIndex].audio_pids[m_audioIndex].codec)))
	{
		m_playerConfig.audio.pid = m_demuxConfig.audio.pid = m_programInfo.psi_program[channelIndex].audio_pids[m_audioIndex].pid;
		m_playerConfig.audio.codec = m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[channelIndex].audio_pids[m_audioIndex].codec);
		audio_isChanged=true;
	}

		if(video_isChanged==true)
		{
			//chage video pid and codec
			if(RTK_Player_ChangeVideo(playerHandle, &m_demuxConfig.video) != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to change video.\n");
			}	
		}

		if(audio_isChanged==true)
		{
			//change audio pid and codec
			if(RTK_Player_ChangeAudio(playerHandle, &m_demuxConfig.audio) != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to change audio.\n");
			}
		
		}
		
		int ex_audio_num = m_programInfo.psi_program[channelIndex].num_audio_pids;

		if(ex_audio_num > 1)
		{
			RTK_AudioConfig* audioConfig = (RTK_AudioConfig*)malloc(sizeof(RTK_AudioConfig)*ex_audio_num);
			int focus_index = -1;
			for(int idx=0;idx<ex_audio_num;idx++)	//ignore first Audioconfig info start form second audio
			{
				audioConfig[idx].pid                    = m_programInfo.psi_program[channelIndex].audio_pids[idx].pid;
				audioConfig[idx].codec                  = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[channelIndex].audio_pids[idx].codec);
				audioConfig[idx].encrypted              = RTK_FALSE;
				audioConfig[idx].enable_raw_output_mode = RTK_FALSE;
				audioConfig[idx].focused                = RTK_FALSE;
				if ((m_demuxConfig.audio.pid == audioConfig[idx].pid) && (m_demuxConfig.audio.focused == RTK_TRUE))
				{
					focus_index = idx;
                    audioConfig[idx].focused                = RTK_TRUE;
				}
			}
			
			if (focus_index == -1)
			{
				audioConfig[0].focused = m_demuxConfig.audio.focused;
				m_demuxConfig.audio.pid                    = audioConfig[0].pid;
				m_demuxConfig.audio.codec                  = audioConfig[0].codec;
				m_demuxConfig.audio.encrypted              = audioConfig[0].encrypted;
				m_demuxConfig.audio.enable_raw_output_mode = audioConfig[0].enable_raw_output_mode;
				m_demuxConfig.audio.focused                = audioConfig[0].focused;
			}

			RTK_Player_ChangeAudioEx(playerHandle,&audioConfig,ex_audio_num);	//ccc
		}	
#if 0
		if(m_demuxConfig.pcr_pid!= m_programInfo.psi_program[channelIndex].pcr_pid)
		{
			m_playerConfig.pcr_pid = m_demuxConfig.pcr_pid = m_programInfo.psi_program[channelIndex].pcr_pid;
			if(RTK_Player_ChangePCR(playerHandle, m_playerConfig.pcr_pid) != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to change pcr.\n");
			}
		}
#endif
		if((m_demuxConfig.subtitle.pid != m_programInfo.psi_program[channelIndex].subtitle_pids[0].pid)
			&&(m_programInfo.psi_program[channelIndex].subtitle_pids[0].pid !=0))
		{
			m_playerConfig.subtitle.pid = m_demuxConfig.subtitle.pid = m_programInfo.psi_program[channelIndex].subtitle_pids[0].pid;
			m_playerConfig.subtitle.bshow =m_demuxConfig.subtitle.bshow=true;
			m_playerConfig.subtitle.langcode = m_demuxConfig.subtitle.langcode=m_programInfo.psi_program[channelIndex].subtitle_pids[0].langcode;
			m_playerConfig.subtitle.subtype = m_demuxConfig.subtitle.subtype = RTKTYPE_DVB_SUBTITLE;
			//m_playerConfig.audio.codec = m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[channelIndex].audio_pids[0].codec);
			/*if(RTK_Player_SetSubtitle(playerHandle,m_demuxConfig.subtitle) != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to change subtitle.\n");
			}*/
		}	
}
char RTKPlayer::xSourceCreateAndSet(void){
	
	RTK_SourceParam_t & sourceParam = m_SourceParam;
	m_rtkSource = new RTK_Source[1];
	m_rtkSourceNum = 1;

	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = RTK_CAS_TYPE_NONE;
	sourceParam.cas_param.tsid_sidx = UNKNOWN_TSID_SIDX;

	// TODO: need fix me!!!
	sourceParam.isSMP = (RTK_Bool)RTK_DvbGetSMP(0); 

		
	if(m_InputType == RTKPLAYER_INPUT_TUNER)
	{
#if 0  //FIXME
		m_tuner_id=g_ID_allocate(TUNER_ID_TYPE);
		if(m_tuner_id<0)
		{
			RTK_PLAYER_ERR("%s: no free tuner id can used!!",__func__);
			return RTK_ERR;
		}	
#else
        // sync to the dtvkit tuner management
		m_tuner_id = m_tunerId;
#endif
		sourceParam.TunerID = m_tuner_id;
		sourceParam.type = RTK_SOURCE_TYPE_TP;
		sourceParam.bandwidth = RTK_TUNER_BANDWIDTH_6M;
     	memcpy (&sourceParam.tnr_param, &tunerParam.tnr_param, sizeof(tunerParam.tnr_param));
		RTK_Tuner_Init();
#if (RTKPLAYER_ARCH_VER <= RTKPLAYER_ARCH_V2)  
		if(RTK_OK != RTK_Set_TunerScanning(sourceParam.TunerID, tunerParam))		  
#else          
		if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam))
#endif              
		{
			g_ID_free(TUNER_ID_TYPE, m_tuner_id);
			m_tuner_id=-1;
			RTK_PLAYER_ERR("%s: RTK_Tuner_Scan failed!!",__func__);	
			return RTK_ERR;
		}				
	}else{
	
		sourceParam.type = RTK_SOURCE_TYPE_MTP;
		RTK_PLAYER_INF("in  %s %d, is pvr = %d !", __func__, __LINE__,m_isPvr);
		if(m_isPvr){
			sourceParam.cas_param.type = RTK_CAS_TYPE_PRIVATE_REC;
			sourceParam.cas_param.tsid_sidx = 55;
		}else{
			sourceParam.cas_param.type = RTK_CAS_TYPE_NONE;
			sourceParam.cas_param.tsid_sidx = UNKNOWN_TSID_SIDX;
		}
	}
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
#if 1
	//FIXME: need to init mCasType for other CA libs
	if(false == m_isPvr && RTK_CAS_TYPE_3RDPARTY_CA == mCasType)
	{
		sourceParam.cas_param.type = mCasType;
	}
#else
	char value[PROPERTY_VALUE_MAX]={0};
	if(false == m_isPvr && property_get("persist.vendor.calib", value, NULL) > 0)
	{
		sourceParam.cas_param.type = RTK_CAS_TYPE_3RDPARTY_CA;
	}
#endif
	if(RTK_Source_Create(&m_rtkSource[0], sourceParam) != RTK_OK){
		RTK_PLAYER_ERR("RTK_Source_Create error !");
		g_ID_free(TUNER_ID_TYPE, m_tuner_id);
		m_tuner_id=-1;
		return RTK_ERR;
	}
	m_dtvs_tsid=sourceParam.cas_param.tsid_sidx;
	m_source =	m_rtkSource[0];

	if(m_isBackground==true) //FCC, maybe foreground PIDs also need preset.
	{
		uint16_t pre_pids[2]={0x1FFF, 0x1FFF};
		pre_pids[0]=m_playerConfig.video.pid;
		pre_pids[1]=m_playerConfig.audio.pid;
		
		if(RTK_Source_PresetPidFilter(m_source, pre_pids, 2)!=RTK_OK)
		{
			RTK_PLAYER_ERR("preset pid %d, %d failed\n", pre_pids[0], pre_pids[1]);
			return RTK_ERR;
		}
	}	
#if 0
	//only foreround player need set souce when creating.
	if(m_isBackground==false && RTK_Player_SetSource(m_demux, m_rtkSource[0]) != RTK_OK){
		return RTK_ERR;
	}
#else
	if(m_isBackground==false) {
        int rr = RTK_OK;
        if (m_arch == ARCH_DEMUX) {
            if (false == m_preload)
                rr = RTK_Demux_SetSource((RTK_Demux)m_demux, m_rtkSource[0]);
        }
        else
            rr = RTK_Player_SetSource(m_demux, m_rtkSource[0]);

        if(rr != RTK_OK){
            return RTK_ERR;
        }
    }
#endif
#endif 
	return RTK_OK;
}


int RTKPlayer::xReadFixedSizeDataByIndex(FILE* pFile, uint32_t uiFixedDataSize, uint64_t ulIndex, uint8_t* pucBuf)
{
	if (pFile == NULL || uiFixedDataSize == 0 || pucBuf == NULL)
	{
		printf("[%s %d] Parameter error!! pFile=%p uiFixedDataSize=%u ulIndex=%llu pcBuf=%p\n", 
				__FUNCTION__, __LINE__, pFile, uiFixedDataSize, ulIndex, pucBuf);
		return -1;
	}

	rewind(pFile);
	
	fseek(pFile, uiFixedDataSize * ulIndex, SEEK_SET);
	if (fread(pucBuf, 1, uiFixedDataSize, pFile) == uiFixedDataSize)
	{
		return 0;
	}	
	printf("[%s %d] ulIndex=%llu out of range,or some other error!!\n", __FUNCTION__, __LINE__, ulIndex);
	return -3;	
}

int RTKPlayer::xFindTargetPTSInfo(FILE* pPTSFile, uint64_t ulTargetPTS, uint64_t* pulIndex, RTK_TS_Ctrl* ptPTSInfo)
{
	if (pPTSFile == NULL || ptPTSInfo == NULL || pulIndex == NULL)
	{
		printf("[%s %d] Parameter error!! pFile=%p ulTargetPTS=%llu ulIndex=%p ptPTSInfo=%p\n", 
				__FUNCTION__, __LINE__, pPTSFile, ulTargetPTS, pulIndex, ptPTSInfo);
		return -1;
	}

	uint64_t ulFileSize = 0;
	uint64_t ulPTSNum = 0;
	uint64_t ulPTSFirst = 0, ulPTSFirstIndex = 0;
	
	uint64_t ulPTSLast = 0, ulPTSLastIndex = 0;
	uint64_t ulPTSTemp = 0, ulPTSTempIndex = 0;
	RTK_TS_Ctrl tPTSInfoTemp;
	
	fseek(pPTSFile, 0, SEEK_END);
	ulFileSize = ftell(pPTSFile);
	rewind(pPTSFile);
	
	ulPTSNum = ulFileSize / sizeof(RTK_TS_Ctrl);

	if (ulPTSNum <= 3)
	{
		printf("[%s %d] File too small!!\n", __FUNCTION__, __LINE__);
		return -1;
	}
	
	ulPTSFirstIndex = 0;
	ulPTSLastIndex = ulPTSNum - 1;
	ulPTSTempIndex = ulPTSLastIndex / 2;

	while (ulPTSFirstIndex != ulPTSTempIndex)
	{
		fseek(pPTSFile, ulPTSFirstIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read first PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSFirstIndex);
			return -1;
		}
		ulPTSFirst = tPTSInfoTemp.pts;		
		//printf("[%s %d] ulPTSFirst=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSFirst, ulPTSFirstIndex);
		if ((abs((int64_t)ulPTSFirst - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSFirstIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}

		fseek(pPTSFile, ulPTSTempIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read middle PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSTempIndex);
			return -1;
		}
		ulPTSTemp = tPTSInfoTemp.pts;
		//printf("[%s %d] ulPTSTemp=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSTemp, ulPTSTempIndex);

		if ((abs((int64_t)ulPTSTemp - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSTempIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}
		
		fseek(pPTSFile, ulPTSLastIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read last PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSLastIndex);
			return -1;
		}
		ulPTSLast = tPTSInfoTemp.pts;
		//printf("[%s %d] ulPTSLast=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSLast, ulPTSLastIndex);

		if ((abs((int64_t)ulPTSLast - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSLastIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}

		if ((ulPTSFirst < ulTargetPTS && ulPTSTemp > ulTargetPTS) ||
			(ulPTSFirst < ulTargetPTS && ulPTSTemp < ulPTSFirst))
		{
			ulPTSFirstIndex += 1;
			ulPTSLastIndex = ulPTSTempIndex - 1;			
		}
		else if ((ulPTSFirst < ulTargetPTS && ulPTSTemp < ulTargetPTS && ulPTSLast < ulTargetPTS) ||
				 (ulPTSFirst > ulTargetPTS && ulPTSTemp > ulTargetPTS && ulPTSLast > ulTargetPTS))
		{
			printf("[%s %d] Couldn't find target PTS info!!\n",__FUNCTION__,__LINE__);
			return -1;
		}
		else
		{
			ulPTSFirstIndex = ulPTSTempIndex + 1;
			ulPTSLastIndex -= 1;
		}	
		ulPTSTempIndex = (ulPTSLastIndex - ulPTSFirstIndex) / 2 + ulPTSFirstIndex;
	}	

	if (ulPTSFirstIndex == ulPTSTempIndex)
	{
		*pulIndex = ulPTSTempIndex;
		fseek(pPTSFile, *pulIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(ptPTSInfo, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read target PTS error!! index=%llu\n", __FUNCTION__, __LINE__, *pulIndex);
			return -1;
		}
		return 0;
	}
	
	
	return -1;
}

int RTKPlayer::xFindTargetFrameInfo(FILE* pfFrameFile, uint64_t ulTargetOffset, uint64_t* pulFrameOffset, RTK_FrameType eTargetType)
{
	if (pfFrameFile == NULL || pulFrameOffset == NULL)
	{
		printf("[%s %d] Parameter error!! pfFrameFile=%p ulTargetOffset=%llu pulFrameOffset=%p eTargetType=%u\n", 
				__FUNCTION__, __LINE__, pfFrameFile, ulTargetOffset, pulFrameOffset, eTargetType);
		return -1;
	}

	uint64_t ulFileSize = 0;
	uint64_t ulFrameNum = 0;
	uint64_t ulFirstIndex = 0;
	uint64_t ulFirstOffset = 0;
	uint64_t ulLastIndex = 0;
	uint64_t ulLastOffset = 0;
	uint64_t ulMiddleIndex = 0;
	uint64_t ulMiddleOffset = 0;
	uint64_t ulTargetIndex = 0;
	RTK_TS_Index tFrameInfoTemp;
	
	fseek(pfFrameFile, 0, SEEK_END);
	ulFileSize = ftell(pfFrameFile);
	rewind(pfFrameFile);
	
	ulFrameNum = ulFileSize / sizeof(RTK_TS_Index);

	if (ulFrameNum <= 3)
	{
		printf("[%s %d] File too small!!\n", __FUNCTION__, __LINE__);
		return -1;
	}
	
	ulLastIndex = 0;
	ulLastIndex = ulFrameNum - 1;
	ulMiddleIndex = ulLastIndex / 2;

	while (ulFirstIndex != ulMiddleIndex)
	{
		if(0 != fseek(pfFrameFile, ulFirstIndex * sizeof(RTK_TS_Index), SEEK_SET))
		{
			printf("[%s %d] fseek first frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulFirstIndex);
			return -1;
		}
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read first frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulFirstIndex);
			return -1;
		}
		ulFirstOffset = tFrameInfoTemp.offset;		
		//printf("[%s %d] ulFirstOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulFirstOffset, ulFirstIndex);
		if ((abs((int64_t)ulFirstOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulFirstIndex;
			break;
		}

		fseek(pfFrameFile, ulMiddleIndex * sizeof(RTK_TS_Index), SEEK_SET);
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read middle frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulMiddleIndex);
			return -1;
		}
		ulMiddleOffset = tFrameInfoTemp.offset;
		//printf("[%s %d] ulMiddleOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulMiddleOffset, ulMiddleIndex);
		if ((abs((int64_t)ulMiddleOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulMiddleIndex;
			break;
		}
		
		fseek(pfFrameFile, ulLastIndex * sizeof(RTK_TS_Index), SEEK_SET);
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read last frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulMiddleIndex);
			return -1;
		}
		ulLastOffset = tFrameInfoTemp.offset;
		//printf("[%s %d] ulLastOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulLastOffset, ulLastIndex);
		if ((abs((int64_t)ulLastOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulLastIndex;
			break;
		}

		if ((ulFirstOffset < ulTargetOffset && ulMiddleOffset > ulTargetOffset) ||
			(ulFirstOffset < ulTargetOffset && ulMiddleOffset < ulFirstOffset))
		{
			ulFirstIndex += 1;
			ulLastIndex = ulMiddleIndex - 1;			
		}
		else if ((ulFirstOffset < ulTargetOffset && ulMiddleOffset < ulTargetOffset && ulLastOffset < ulTargetOffset) || 
				 (ulFirstOffset > ulTargetOffset && ulMiddleOffset > ulTargetOffset && ulLastOffset > ulTargetOffset))
		{
			return -1;
		}
		else
		{
			ulFirstIndex = ulMiddleIndex + 1;
			ulLastIndex -= 1;	
		}
		
		ulMiddleIndex = (ulLastIndex - ulFirstIndex) / 2 + ulFirstIndex;
	}	

	if (ulFirstIndex == ulMiddleIndex)
	{
		ulTargetIndex = ulMiddleIndex;
	}
	
	if (tFrameInfoTemp.frame_type == eTargetType)
	{
		*pulFrameOffset = tFrameInfoTemp.offset;
		return 0;
	}
	else
	{
		int64_t i;
		uint64_t j;
		uint64_t ulTemp = 0;
		for(i = ulTargetIndex - 1; i >= 0; i--)
		{
			xReadFixedSizeDataByIndex(pfFrameFile, sizeof(RTK_TS_Index), i, (uint8_t*)&tFrameInfoTemp);
			if (tFrameInfoTemp.frame_type == eTargetType)
			{
				ulTemp = tFrameInfoTemp.offset;
				break;
			}
		}

		for(j = ulTargetIndex + 1; j < ulFrameNum; j++)
		{
			xReadFixedSizeDataByIndex(pfFrameFile, sizeof(RTK_TS_Index), j, (uint8_t*)&tFrameInfoTemp);
			if (tFrameInfoTemp.frame_type == eTargetType)
			{
				if ((ulTargetIndex - i) > (j - ulTargetIndex))
				{
					*pulFrameOffset = tFrameInfoTemp.offset;
				}
				else
				{
					*pulFrameOffset = ulTemp;
				}
				return 0;
			}
		}
		return -1;
	}
	
	return 0;
}


int RTKPlayer::xPVR_Replay_Seek(FILE* pfTSFile, FILE* pfPTSFile, FILE* pfFrameFile, uint64_t ulPTSCur, int32_t iSeekTimeMs, RTK_SEEK_WHENCE eSeekWhence)
{
	RTK_PLAYER_INF("[%s %d] begin>>>\n",__FUNCTION__,__LINE__ );
	RTK_PLAYER_INF("[%s %d] ulPTSCur=%llu SeekTimeMs=%d SeekWhence=%s\n",__FUNCTION__,__LINE__, ulPTSCur, iSeekTimeMs, RTK_GETSEEKWHENCE_STR(eSeekWhence));

	uint64_t ulTSPosTar = 0;
	uint64_t ulPtsNumToSeek = 0;
	uint64_t ulPtsTar = 0;
	uint64_t ulPtsTarIndex = 0;
	uint64_t ulPtsInfoFileSize = 0;
	RTK_TS_Ctrl tPtsInfo;	
	
	bool bSeekBack = iSeekTimeMs > 0 ? false : true;
	
	if (pfTSFile == NULL || pfPTSFile == NULL || pfFrameFile == NULL || abs(iSeekTimeMs) < 90)
	{
		RTK_PLAYER_INF("[%s %d] Parameter error!! pfTSFile=%p pfPTSFile=%p pfFrameFile=%p iSeekTimeMs=%d\n",
				__FUNCTION__, __LINE__, pfTSFile, pfPTSFile, pfFrameFile, iSeekTimeMs);
		return -1;
	}

	if ((bSeekBack == true && iSeekTimeMs < 0 && eSeekWhence == RTK_SEEKWHENCE_SET) || 
		(bSeekBack == false && iSeekTimeMs > 0 && eSeekWhence == RTK_SEEKWHENCE_END))
	{
		RTK_PLAYER_INF("[%s %d] Can't seek forward from end or seek backward from begin!!\n",__FUNCTION__,__LINE__);
		return -1;
	}

	fseek(pfPTSFile, 0, SEEK_END);
	ulPtsInfoFileSize = ftell(pfPTSFile);
	rewind(pfPTSFile);
	RTK_PLAYER_INF("[%s %d] PTS info file size=%llukB Number of PTS=%llu.\n", __FUNCTION__, __LINE__, (ulPtsInfoFileSize >> 10), (ulPtsInfoFileSize / sizeof(RTK_TS_Ctrl)));

	// compute the target number of pts that need seek
	ulPtsNumToSeek = abs(iSeekTimeMs) * 90;
	if (eSeekWhence == RTK_SEEKWHENCE_CUR)
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), 0, (uint8_t*)&tPtsInfo);
		if (iSeekTimeMs < 0 && ulPTSCur < ulPtsNumToSeek)
		{
			ulPtsTar = tPtsInfo.pts;
		}
		else
		{
			ulPtsTar = ulPTSCur + (iSeekTimeMs * 90);
		}
	}
	else if (eSeekWhence == RTK_SEEKWHENCE_SET)
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), 0, (uint8_t*)&tPtsInfo);
		ulPtsTar = tPtsInfo.pts + (iSeekTimeMs * 90);
	}
	else
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), ulPtsInfoFileSize / sizeof(RTK_TS_Ctrl) - 1, (uint8_t*)&tPtsInfo);
		ulPtsTar = tPtsInfo.pts + (iSeekTimeMs * 90);
	}
	RTK_PLAYER_INF("[%s %d] Number of PTS needs to seek:%llu PTSTar=%llu.\n", __FUNCTION__, __LINE__, ulPtsNumToSeek, ulPtsTar);

	if (xFindTargetPTSInfo(pfPTSFile, ulPtsTar, &ulPtsTarIndex, &tPtsInfo))
	{		
		RTK_PLAYER_INF("[%s %d] Couldn't find target PTS info!! ulPtsTar=%llu\n", __FUNCTION__, __LINE__, ulPtsTar);
		return -1;			
	}	
	RTK_PLAYER_INF("[%s %d] Find target PTS info successed!! PTS=%llu offset=%llu index=%llu \n", __FUNCTION__, __LINE__, tPtsInfo.pts, tPtsInfo.offset, ulPtsTarIndex);

	if (xFindTargetFrameInfo(pfFrameFile, tPtsInfo.offset, &ulTSPosTar, RTK_FRAME_TYPE_I))
	{	
		ulTSPosTar = tPtsInfo.offset;	
		RTK_PLAYER_INF("[%s %d] Couldn't find target I frame info!! use PTSoffset=%llu \n", __FUNCTION__, __LINE__, ulTSPosTar);		
	}
	else
	{
		RTK_PLAYER_INF("[%s %d] Find target I frame info successed!! offset=%llu \n", __FUNCTION__, __LINE__, ulTSPosTar);
	}	
	
	RTK_PLAYER_INF("[%s %d] Seek TS file to TSPosTar=%llu.\n", __FUNCTION__, __LINE__, ulTSPosTar);
	
	fseek(pfTSFile, ulTSPosTar, SEEK_SET);

	RTK_PLAYER_INF("[%s %d] end<<<\n",__FUNCTION__,__LINE__ );
	return 0;
}
//////////////////////////player Seek end//////////////////////////////////////


char RTKPlayer::RT_PlayerCreate(const char *sourceUrl,int updateinfo)
{
        m_sourceUrl = (char*)strdup(sourceUrl);
	m_updateinfoflag = updateinfo;
	char ret = RTK_ERR;	
	if( m_status != RTKPLAYER_STATUS_NONE)
		return RTK_ERR;
	RTK_PLAYER_INF("m_demuxConfig.rec.mode = %d\n", (int)m_demuxConfig.rec.mode);
	ret = xSetDataSource(sourceUrl);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("xSetDataSource fail\n");
		return RTK_ERR;
	}
	
	
	
	RTK_PLAYER_INF("\n RT_PlayerCreate updateinfo =%d \n",m_updateinfoflag);
	//-------------------------------------------------------------------------
	//	demux create
	//-------------------------------------------------------------------------
	if(m_isBackground==false) {
        RTK_Error rr = RTK_OK;
        if (m_arch == ARCH_DEMUX) {
           if (false == m_preload)
              rr = RTK_Demux_Create((RTK_Demux *)&m_demux, (RTK_DemuxConfig *)&m_demuxConfig);
        }
        else
           rr = RTK_Player_Create(&m_demux, &m_demuxConfig, HAL_TYPE_DEMUX);

	    if(rr != RTK_OK)
        {
		    RTK_PLAYER_ERR("Failed to create demux.\n");
		    return RTK_ERR;
	    }
    }
   
    if (false == m_preload) {
	    if (m_isBackground==false && m_demux == NULL)
	    {
	        RTK_PLAYER_ERR("Demux is NULL!!");
		    return RTK_ERR;
	    }

        //save the fcc main player handle
        if(m_isBackground==false)
            m_FCCMainPlayerHandle=m_demux;

	    if(m_arch == ARCH_DEMUX)
	    {
		    m_startRecording = true;
		    //RTK_Player_DVRCreate(m_demux);
	    }
    }

	//-------------------------------------------------------------------------
	//	create create when timeshift mode.
	//-------------------------------------------------------------------------
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		/*
		**Because demux and player use the same channelid, so that now no need to open player, need to do duplicate.
		*/
		//m_player = RTK_Player_duplicate(m_demux);
		//RTK_Player_Update_Config(m_player, &m_playerConfig);
	}
	
	m_status = RTKPLAYER_STATUS_INIT;
	
#ifdef CLIENT_DTVSOURCE
    	if(xSourceCreateAndSet()!= RTK_OK)
	{
		RTK_PLAYER_ERR("xSourceCreateAndSet error!!");
		return RTK_ERR;
	}
#endif
	if(m_CaIntf)
	{
		m_player_id = g_ID_allocate(PLAYER_ID_TYPE);
		m_CaIntf->DescramblerInit(m_player_id);
	}

	RTK_PLAYER_INF("RT_PlayerCreate m_demux=%p done", m_demux);

	return RTK_OK;
}

char RTKPlayer::RT_PlayerPreparse(int predict_pmt_pid)
{
	RTK_PLAYER_INF("RT_PlayerPreparse m_demux=%p m_status=%d", m_demux, m_status);

	if( m_status != RTKPLAYER_STATUS_INIT)
		return RTK_ERR;

	//background player no need to preparse.
	if(m_isBackground==true)
		return RTK_ERR;
	
#ifdef RTKPLAYER_MINI_SI
	if(m_InputType == RTKPLAYER_INPUT_IPTV)
	{
		m_PreparseFeedStop = RTK_FALSE;
		pthread_create(&rtkDemuxPreparseThread, NULL, ThreadProcPreParsePMTEntry, (void*)this);
		m_status = RTKPLAYER_STATUS_PREPARSE;
		return RTK_OK;
	}
#endif

	if(m_InputType != RTKPLAYER_INPUT_TUNER)
	{
		m_demuxFeedStop = RTK_FALSE;
		m_playerPauseFlag = RTK_TRUE;
		pthread_create(&rtkDemuxFeedThread, NULL, ThreadProcDemuxFeedEntry, (void*)this);
	}

	// Add sectionfilter PAT table id : 0x00
	if( xAddPAT() != RTK_OK)
		return RTK_ERR;

	if( xAddTDT() != RTK_OK)
	{
		RTK_PLAYER_INF(" xAddDTD() error...");
	}
	// Add predict PMT
	predict_pmt_pid &= 0x1FFF;
	if( predict_pmt_pid != -1 && predict_pmt_pid != 0x1FFF && predict_pmt_pid != 0)
	{
		xAddPMT(predict_pmt_pid); // failed is ok because we still add PAT
	}

    if( xAddCAT() != RTK_OK)
    {
        return RTK_ERR;
    }
	m_playerPauseFlag = RTK_FALSE;
	m_status = RTKPLAYER_STATUS_PREPARSE;
	return RTK_OK;
}

char RTKPlayer::RT_PlayerStart(int channelIndex)
{
//	RTKPLAYER_STATUS pre_status = m_status;
	RTK_PLAYER_INF("RT_PlayerStart m_demux=%p m_status=%d", m_demux, m_status);
	if(m_isPvr){
		channelIndex = m_pvr_index;
		RTK_PLAYER_INF("RT_PlayerStart pvr channelIndex = %d ", m_pvr_index);
	}
	
	if( m_arch == ARCH_DEMUX
		&& (m_startRecording != RTK_TRUE))
	{
		RTK_PLAYER_WRN("before RT_PlayerStart, sould setup RT_PlayerOpenPVR first\n");
		// if not setup ready before start, index and ctrl data may not match ts file
		// because RTK_HAL already create rtk_porting_record in create stage
	}


	if( m_status != RTKPLAYER_STATUS_INIT && m_status != RTKPLAYER_STATUS_PREPARSE )
		return RTK_ERR;

	m_channelIndex = channelIndex;
	m_playProgramNum = m_programInfo.psi_program[channelIndex].program_number;
	RTK_PLAYER_INF("program . video_pids =%d , audio_id = %d  !!!\n",m_programInfo.psi_program[channelIndex].video_pids[0].pid, m_programInfo.psi_program[channelIndex].audio_pids[0].pid);

	if(m_InputType != RTKPLAYER_INPUT_TUNER && m_status == RTKPLAYER_STATUS_INIT)
	{
		m_demuxFeedStop = RTK_FALSE;
		m_playerPauseFlag = RTK_TRUE;
		pthread_create(&rtkDemuxFeedThread, NULL, ThreadProcDemuxFeedEntry, (void*)this);
	}
	else if(m_status == RTKPLAYER_STATUS_PREPARSE && m_InputType == RTKPLAYER_INPUT_FILE)
	{ // seek to specific position (default is head) after preparse

		m_playerPauseFlag = RTK_TRUE;
        if (NULL != m_demux) {
		    RTK_Player_Pause(m_demux);

		    m_SeekFlag = RTK_TRUE;
        }

		//make sure source feed thread paused
		while(m_sourceFeedPauseFlag == RTK_FALSE)
		{
			usleep(1000);
		}
		RTK_Player_DropData(m_demux);
		m_playerPauseFlag = RTK_FALSE;
	}
#ifdef RTKPLAYER_MINI_SI
	else if(m_status == RTKPLAYER_STATUS_PREPARSE && m_InputType == RTKPLAYER_INPUT_IPTV)
	{
		m_demuxFeedStop = RTK_FALSE;
		m_playerPauseFlag = RTK_TRUE;
		pthread_create(&rtkDemuxFeedThread, NULL, ThreadProcDemuxFeedEntry, (void*)this);
	}
#endif


	//-------------------------------------------------------------------------
	//	demux start
	//-------------------------------------------------------------------------
	if(m_isBackground==false)
    {
        int rr = RTK_ERR;
        if(m_arch == ARCH_DEMUX) {
            if (NULL != m_demux)
                rr = RTK_Demux_Start(m_demux);
        }
        else
            rr = RTK_Player_Start(m_demux);
	
	    if(rr != RTK_OK)
	    {
	        RTK_PLAYER_ERR("Failed to start demux.\n");
	 	    return RTK_ERR;
	    }
    }

	//start descramble
	if(m_CaIntf)
	{
#if 0
		RTK_BOOL isEncrypt = RTK_FALSE;
		unsigned int cas_id = 0;
		RTKCA_Descramble_ECM_info_t ecm_info;
		
		cas_id = m_CaIntf->GetCaSystemID();
		memset(&ecm_info, 0x00, sizeof(ecm_info));
		uint8_t video_nums = m_programInfo.psi_program[m_channelIndex].num_video_pids;
		uint8_t audio_nums = m_programInfo.psi_program[m_channelIndex].num_audio_pids;
		for(int index = 0;index < m_programInfo.psi_program[m_channelIndex].CasIDCount;index++)
		{
			if(cas_id == m_programInfo.psi_program[m_channelIndex].cas_id[index])
			{
			        isEncrypt = RTK_TRUE;
				 //video                      
				for(int i = 0 ; i < video_nums; i++)
				{
					ecm_info.ecm_AVPids[i].ecm_pid = m_programInfo.psi_program[m_channelIndex].ca_pid[0];             
					ecm_info.ecm_AVPids[i ].stream_pid = m_programInfo.psi_program[m_channelIndex].video_pids[i].pid;
				}
	                      //audio
				for(int i = 0; i <audio_nums; i++)
				{
	                            if(video_nums+i >= RTKCA_MAX_STREAM_PID_NUM)
	                            {
	                                RTK_PLAYER_ERR("Stream pid over RTKCA_MAX_STREAM_PID_NUM = %d!!!\n", (int)RTKCA_MAX_STREAM_PID_NUM);
	                                break;
	                            }
					ecm_info.ecm_AVPids[video_nums+i].ecm_pid = m_programInfo.psi_program[m_channelIndex].ca_pid[0];
					ecm_info.ecm_AVPids[video_nums + i].stream_pid=m_programInfo.psi_program[m_channelIndex].audio_pids[i].pid;
	                      }
			}
		}
		
		if(isEncrypt == RTK_FALSE)
		{
			int avPidNum = 0;
			for(int index = 0;index < m_programInfo.psi_program[m_channelIndex].video_pids[0].CasIDCount;index++)
			{
				if(cas_id == m_programInfo.psi_program[m_channelIndex].video_pids[0].cas_id[index])
				{
					isEncrypt = RTK_TRUE;
					for(int i = 0 ; i < video_nums; i++)
					{			
						ecm_info.ecm_AVPids[avPidNum].ecm_pid = m_programInfo.psi_program[m_channelIndex].video_pids[i].ca_pid[0];
						ecm_info.ecm_AVPids[avPidNum].stream_pid = m_programInfo.psi_program[m_channelIndex].video_pids[i].pid;
						avPidNum++;
		                      }
				}

			}
			for(int index = 0;index < m_programInfo.psi_program[m_channelIndex].audio_pids[0].CasIDCount;index++)
			{
				if(cas_id == m_programInfo.psi_program[m_channelIndex].audio_pids[0].cas_id[index])
				{
					isEncrypt = RTK_TRUE;
					for(int i = 0; i <audio_nums; i++)
		                      {
		                            if(avPidNum >= RTKCA_MAX_STREAM_PID_NUM - 1)
		                            {
		                                RTK_PLAYER_ERR("Stream pid over RTKCA_MAX_STREAM_PID_NUM = %d!!!\n", (int)RTKCA_MAX_STREAM_PID_NUM);
		                                break;
		                            }
						ecm_info.ecm_AVPids[avPidNum].ecm_pid = m_programInfo.psi_program[m_channelIndex].audio_pids[i].ca_pid[0];		                         
		                            ecm_info.ecm_AVPids[avPidNum].stream_pid=m_programInfo.psi_program[m_channelIndex].audio_pids[i].pid;
						avPidNum++;
		                      }
				}
			}
		}
		if(isEncrypt == RTK_TRUE)
		{
			ecm_info.source_handle=(int)m_source;
			ecm_info.emm_pid = m_programInfo.cat_program.ca_pid[0];
			ecm_info.program_id=m_playProgramNum; ;
			//algo
			if(m_programInfo.psi_program[m_channelIndex].descramble_info.descramble_algorithm==DESCRAMBLE_ALGO_CSA)
				ecm_info.algo=RTKCA_ALGO_CSA;
			else if(m_programInfo.psi_program[m_channelIndex].descramble_info.descramble_algorithm==DESCRAMBLE_ALGO_CSA2)
				ecm_info.algo=RTKCA_ALGO_CSA2;
			else if(m_programInfo.psi_program[m_channelIndex].descramble_info.descramble_algorithm==DESCRAMBLE_ALGO_AES_128_ECB)
				ecm_info.algo=RTKCA_ALGO_AES_128_ECB;
			m_CaIntf->StartDescramble(m_player_id, ecm_info);
		}
		else
               {
        		RTK_PLAYER_INF("cas id not match\n");
                      if(NULL != m_sourceUrl && RTK_OK == xParseExmInfo(m_sourceUrl,  &ecm_info))
                      {
        		      RTK_PLAYER_INF("Fcc (descramble) case\n");
                            ecm_info.program_id = 1;
                            ecm_info.source_handle = (int)m_source;
                            m_CaIntf->StartDescramble(m_player_id, ecm_info);
                      }
                      else
                      {
                            RTK_PLAYER_INF("normal case\n");
                      }
        	}
#endif
	}
	

	//-------------------------------------------------------------------------
	//	add ts filter for record & timeshift
	//-------------------------------------------------------------------------
	if((m_arch == ARCH_DEMUX_AND_PLAY)||(m_arch == ARCH_DEMUX))
	{

		TS_PSI_Program program = m_programInfo.psi_program[channelIndex];
		RTK_PLAYER_INF("11program . video_pids =%d , audio_id = %d  !!!\n",program.video_pids[0].pid, program.audio_pids[0].pid);
		xUpdateRecordProgram(program);
	}

	//-------------------------------------------------------------------------
	//	getDemuxMemory for timeshift
	//-------------------------------------------------------------------------
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		if(RTK_OK != _xGetDemuxMemory(&m_dataStoreMemory))
		{
			RTK_PLAYER_ERR("  %s %s %d:fail!! _xGetDemuxMemory fail!\n", __FILE__, __FUNCTION__, __LINE__);
			return RTK_ERR;
		}
	
		m_playerFeedStop = RTK_FALSE;
		pthread_create(&rtkPlayFeedThread, NULL, ThreadProcPlayFeedEntry, (void*)this); 
	
		if(RTK_Player_Start(m_player) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to start player.\n");
			int32_t status, rc;
			m_playerFeedStop = RTK_TRUE;
			rc = pthread_join(rtkPlayFeedThread, (void **)&status);
			if (rc != 0)
			{
				RTK_PLAYER_ERR("ERROR; return code from rtkPlayFeedThread pthread_join() is %d\n", rc);
				return RTK_ERR;
			}
			else
			{
				RTK_PLAYER_INF("rtkPlayFeedThread Thread joined\n");
			}
	
			return RTK_ERR;
		}			
	}

	//mantis 0013663 :because the audio come out much more than video,so mute it at first
	if((m_isBackground==false) && m_demuxConfig.video.output != RTK_WIN_PIP) 
	{
		if(m_av_sync_mode == RTK_AVSYNC_AUDIO_MASTER_AUTO || m_av_sync_mode ==  RTK_AVSYNC_AUDIO_MASTER_AUTO_SKIP){
		//set audio mute for av sync
		INT8_T ret = RTK_Player_SetAudioMute(m_demux, RTK_TRUE);
		if(ret==RTK_OK)
		{
			m_MuteState |= MUTE_BY_AVSYNC;
			RTK_PLAYER_INF("[%d][%s] set audio mute\n", m_demuxConfig.video.output,  __FUNCTION__);
			}
		}
		
	}
	
	
	m_status = RTKPLAYER_STATUS_RUN;

	// Add sectionfilter PAT table id : 0x00
	if(m_InputType != RTKPLAYER_INPUT_TUNER)
	{
		if( xAddPAT() != RTK_OK)
			return RTK_ERR;
	}

	m_playerPauseFlag = RTK_FALSE;
	return RTK_OK;
}

char RTKPlayer::RT_PlayerStop(RTK_Bool keepLastFrame)
{
	int32_t status, rc;
	bool wait_DemuxFeed_join = false;
	bool wait_PlayFeed_join = false;
	RTK_PLAYER_INF("RT_PlayerStop m_demux=%p m_status=%d", m_demux, m_status);

	if( m_status != RTKPLAYER_STATUS_RUN && m_status != RTKPLAYER_STATUS_PREPARSE )
		return RTK_OK;

	if (m_demux == NULL && false == m_isBackground) // already Destory
	{
		return RTK_OK;
	}

	if(m_demuxFeedStop == RTK_FALSE) // Exit source feed thread
	{
		m_demuxFeedStop = RTK_TRUE;
		wait_DemuxFeed_join = true;
	}

	if((m_arch == ARCH_DEMUX)||(m_arch == ARCH_DEMUX_AND_PLAY))
	{
		xCleanRecordProgram();
	}
	
#ifdef RTKPLAYER_MINI_SI
	if(m_PreparseFeedStop == RTK_FALSE) // Exit source feed thread
	{
		m_PreparseFeedStop = RTK_TRUE;
	}

	if(rtkDemuxPreparseThread != 0)
	{
		rc = pthread_join(rtkDemuxPreparseThread, (void **)&status);
		if (rc != 0)
		{
			RTK_PLAYER_ERR("ERROR; return code from rtkDemuxFeedThread pthread_join() is %d\n", rc);
			return RTK_ERR;
		}
		else
		{
			rtkDemuxPreparseThread = 0;
			RTK_PLAYER_INF("rtkDemuxPreparseThread Thread joined\n");
		}
	}
#endif

	// if it's running trick-play, we should unmute before doing stop
	// however, if USER has set mute, we keep player mute
	if(!m_isBackground)
	{
		m_MuteState &= ~MUTE_BY_TRICKPLAY;
		RTK_Player_SetAudioMute(m_demux, (m_MuteState==UNMUTE)?RTK_FALSE:RTK_TRUE );
	}
	
	if(m_arch == ARCH_DEMUX)
	{
		if(RTK_Player_DVRStop(m_demux) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to stop record.\n");
			return RTK_ERR;
		}
	}

	//stop descramble
	if(m_CaIntf)
	{
#if 0
		m_CaIntf->StopDescramble(m_player_id);
#endif
	}
		if(RTK_Player_Stop(m_demux, keepLastFrame) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to stop record.\n");
			return RTK_ERR;
		}

	
	if(wait_DemuxFeed_join)
	{
		rc = pthread_join(rtkDemuxFeedThread, (void **)&status);
		if (rc != 0)
		{
			RTK_PLAYER_ERR("ERROR; return code from rtkDemuxFeedThread pthread_join() is %d\n", rc);
			return RTK_ERR;
		}
		else
		{
			RTK_PLAYER_INF("rtkDemuxFeedThread Thread joined\n");
		}
	}

	if(m_arch == ARCH_DEMUX_AND_PLAY)//demux+player
	{
		if(m_playerFeedStop == RTK_FALSE) // Exit timeshift feed thread
		{
			m_playerFeedStop = RTK_TRUE;
			wait_PlayFeed_join = true;
		}

		if(RTK_Player_Stop(m_player, keepLastFrame) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to stop player.\n");
			return RTK_ERR;
		}

		if(wait_PlayFeed_join)
		{
			rc = pthread_join(rtkPlayFeedThread, (void **)&status);
			if (rc != 0)
			{
				RTK_PLAYER_ERR("ERROR; return code from rtkPlayFeedThread pthread_join() is %d\n", rc);
				return RTK_ERR;
			}
			else
			{
				RTK_PLAYER_INF("rtkPlayFeedThread Thread joined\n");
			}
		}

		pthread_mutex_lock(&m_rtkDataCallBackMutex);
		_xReleaseDemuxMemory(&m_dataStoreMemory);
		pthread_mutex_unlock(&m_rtkDataCallBackMutex);

	}

	if( m_InputType == RTKPLAYER_INPUT_FILE )
	{


		// Close ctrl_rd and idx_rd files. ctrl_wr and idx_wr are handled in RT_PlayerClosePVR
		if(m_recordingCtrl_Rd!=NULL) fclose(m_recordingCtrl_Rd);
		m_recordingCtrl_Rd = NULL;

		if(m_recordingIdx_Rd!=NULL) fclose(m_recordingIdx_Rd);
		m_recordingIdx_Rd = NULL;
		
		RTK_Player_SetTrickMode(m_demux,RHAL_AV_TRICK_IONLY);
	}else if( m_InputType == RTKPLAYER_INPUT_TUNER ){
		m_demuxConfig.audio.pid =TS_INVALID_PID; //clear pid 
		m_demuxConfig.video.pid =TS_INVALID_PID; //clear pid 
	}

	if(m_waitPMTStop == RTK_FALSE){
		m_waitPMTStop = RTK_TRUE;
		int rc,status;
	    rc = pthread_join(waitPMTThread, (void **)&status);
		if (rc != 0)
		{
			RTK_PLAYER_ERR("ERROR; return code from rtkPlayFeedThread pthread_join() is %d\n", rc);
			return RTK_ERR;
		}
		else
		{
			waitPMTThread = 0;
			RTK_PLAYER_INF("rtkPlayFeedThread Thread joined\n");
		}
	}
	
	if(m_TSDataFile!=NULL)
	{
		int fd = 0;
		fflush(m_TSDataFile);
		fd = fileno(m_TSDataFile); 
		fsync(fd); 
		fclose(m_TSDataFile);
		m_TSDataFile = NULL;
	}
	m_firstReceiveTSData = 0;
	m_demuxFilePoint = 0;
	m_playerFilePoint = 0;
	m_dataSendOffset=0;
	m_playerPauseFlag = RTK_FALSE;
	m_sourceFeedPauseFlag = RTK_FALSE;
	m_startRecording = RTK_FALSE;

	m_playProgramNum = -1;
	m_status = RTKPLAYER_STATUS_INIT;

	
	return RTK_OK;
}


char RTKPlayer::RT_PlayerDestory()
{
#if 0
	if( m_status != RTKPLAYER_STATUS_INIT )
		return RTK_ERR;
#endif	

   if (m_preload)
      goto end;

   if (NULL == m_demux)
      return RTK_OK;	

	RTK_PLAYER_ERR("RT_PlayerDestory m_demux=%p", (m_demux!=NULL)?m_demux:0 );

	//Uninit Descrambler.
	if(m_CaIntf)
	{
		m_CaIntf->DescramblerUninit(m_player_id);
	}
	
	if( m_InputType == RTKPLAYER_INPUT_FILE )
	{
	   if(m_demuxConfig.input.memory.filePath)
	   {
		  free(m_demuxConfig.input.memory.filePath);
		  m_demuxConfig.input.memory.filePath = NULL;
		  m_demuxConfig.input.memory.filePathLen = 0;
	   }
	}

#if 0  // FIXME: handled in RealtekPlayer
    if(m_InputType == RTKPLAYER_INPUT_TUNER){
		RTK_Tuner_UnInit();
	}
#endif

	if((m_isBackground==false) && (m_MuteState&MUTE_BY_AVSYNC))
	{
		m_MuteState &= ~MUTE_BY_AVSYNC;
		INT8_T ret = RTK_Player_SetAudioMute(m_demux, (m_MuteState==UNMUTE)?RTK_FALSE:RTK_TRUE );
		if(ret==RTK_OK)
			RTK_PLAYER_INF("[%d][%s] set audio unmute\n", m_demuxConfig.video.output,  __FUNCTION__);
	}
					
	if(m_isBackground==false)
    {
        int ret;
        if(m_arch == ARCH_DEMUX)
            ret = RTK_Demux_Destroy(m_demux);
        else
            ret = RTK_Player_Destroy(m_demux);
   			
        if(ret != RTK_OK)
	    {
		    RTK_PLAYER_ERR("Failed to destory player.\n");
            return RTK_ERR;
        }
    }
	m_demux = NULL;

	if(m_arch == ARCH_DEMUX_AND_PLAY)//demux+player
	{
		if(RTK_Player_Destroy(m_player) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to stop player.\n");
			return RTK_ERR;
		}
		m_player = NULL;
	}

#ifdef DUMP_FEED
	if(m_DumpFd!=NULL)
	{
		int fd = 0;
		fflush(m_DumpFd);
		fd = fileno(m_DumpFd);
		fsync(fd);
		fclose(m_DumpFd);
		m_DumpFd = NULL;
		RTK_PLAYER_INF("[DUMP]%d: close dumpfile!\n", __LINE__);
	}
#endif

end:
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
   m_source = NULL; 
	if(m_rtkSource != NULL)
	{
		for(int i = 0; i < m_rtkSourceNum; i++)
		{	
            if (NULL != m_rtkSource[i])
			    RTK_Source_Destroy(m_rtkSource[i]);
		}
		delete []m_rtkSource;
		m_rtkSource = NULL;
		m_rtkSourceNum= 0;
	}
	if(m_tuner_id>=0)
	{	
		g_ID_free(TUNER_ID_TYPE, m_tuner_id);
		m_tuner_id=-1;
	}

#endif
	m_status = RTKPLAYER_STATUS_NONE;

        if(m_player_id >=0 )
        {
            g_ID_free(PLAYER_ID_TYPE, m_player_id);
            m_player_id = -1;
        }
        if(NULL != m_sourceUrl)
        {
               free(m_sourceUrl);
               m_sourceUrl = NULL;
        }
	return RTK_OK;
}

char RTKPlayer::RT_PlayerFinalize(void)
{
	RTK_finalize();
	return RTK_OK;
}

int RTKPlayer::RT_PlayerOpenPVR(const char *strPath)
{
	//open ts file.
	m_recordingFilePath = strdup(strPath);
	m_recordingFile  = fopen(strPath, "wb+");
	if(m_recordingFile == NULL)
	{
		RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strPath);
		int errNum = errno;
		return errNum;
	}
	else
	{	
		RTK_PLAYER_INF("%s %s %d:success!! Success to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strPath);
	}

	//open ctrl file.
	char strCtrlName[256]={0};
	snprintf(strCtrlName, 256, "%s_ctrl.dat", strPath);
	m_recordingCtrl_Wr = fopen(strCtrlName, "wb+");
	if(m_recordingCtrl_Wr == NULL)
	{
		RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strCtrlName);
		int errNum = errno;
		return errNum;
	}
	else
	{	
		RTK_PLAYER_INF("%s %s %d:success!! Success to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strCtrlName);
	}


	//open idx file.
	char strIdxName[256]={0};
	snprintf(strIdxName, 256, "%s_idx.dat", strPath);
	m_recordingIdx_Wr = fopen(strIdxName, "wb+");
	if(m_recordingIdx_Wr == NULL)
	{
		RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strIdxName);
		int errNum = errno;
		return errNum;
	}
	else
	{	
		RTK_PLAYER_INF("%s %s %d:success!! Success to open %s file!\n", __FILE__, __FUNCTION__, __LINE__, strIdxName);
	}

	m_startRecording = RTK_TRUE;
	return RTK_OK;
}

char RTKPlayer::RT_PlayerStartPVR()
{	m_arch = ARCH_DEMUX;
	//background player no need this.
	if(m_isBackground==true)		
            return RTK_ERR;
    
	if(RTK_Player_DVRStart(m_demux) != RTK_OK)
	{
		RTK_PLAYER_ERR("%s %s %d:DVR start failed !!!\n", __FILE__, __FUNCTION__, __LINE__);
		RT_PlayerClosePVR();
		return RTK_Fail;
	}
	
	

	return RTK_OK;
}
char RTKPlayer::RT_PlayerUpTsTSFilter(TS_PSI_Program program){

	RTK_PLAYER_INF("22program . video_pids =%d , audio_id = %d	!!!\n",program.video_pids[0].pid, program.audio_pids[0].pid);
	xUpdateRecordProgram(program);
	return RTK_OK;
}

char RTKPlayer::RT_PlayerStopPVR()
{
	m_arch = ARCH_PLAY;
	//background player no need this.	
	if(m_isBackground==true)		
            return RTK_ERR;    
    
	xCleanRecordProgram();
	if(RTK_Player_DVRStop(m_demux) != RTK_OK){
		RTK_PLAYER_ERR("%s %s %d:DVR stop failed !!!\n", __FILE__, __FUNCTION__, __LINE__);
		return RTK_Fail;
	}
	
	return RTK_OK;
}

char RTKPlayer::RT_PlayerClosePVR()
{
	m_startRecording = RTK_FALSE;
    
	if(m_isBackground==true)		
            return RTK_ERR;
    
	if(m_recordingFile != NULL)
	{
		int fd = 0;
		fflush(m_recordingFile);
		fd = fileno(m_recordingFile); 
		fsync(fd); 
		fclose(m_recordingFile);
		m_recordingFile = NULL;
	}

	if(m_recordingCtrl_Wr != NULL)
	{
		int fd = 0;
		fflush(m_recordingCtrl_Wr);
		fd = fileno(m_recordingCtrl_Wr);
		fsync(fd);
		fclose(m_recordingCtrl_Wr);
		m_recordingCtrl_Wr = NULL;
	}

	if(m_recordingIdx_Wr != NULL)
	{
		int fd = 0;
		fflush(m_recordingIdx_Wr);
		fd = fileno(m_recordingIdx_Wr);
		fsync(fd);
		fclose(m_recordingIdx_Wr);
		m_recordingIdx_Wr = NULL;
	}

	return RTK_OK;
}



/*
** 1. pasue avplay;
** 2. change input from memory  to file;
*/
char RTKPlayer::RT_PlayerPause(RTK_Bool enableTimeShift)
{
	(void)enableTimeShift;
	INT8_T ret = RTK_OK;
	RTK_Player playerHandle = m_demux;
    
	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}


	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		//-------------------------------------------------------------------------
		//	open dvr file
		//-------------------------------------------------------------------------
		m_TSDataFile = fopen("/data/mediadrm/dvr.ts", "wb+");
		if(m_TSDataFile == NULL)
		{
			RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open avdata file!\n", __FILE__, __FUNCTION__, __LINE__);
			return RTK_ERR;
		}
		else
		{	
			RTK_PLAYER_INF("%s %s %d:success!! Success to open avdata file!\n", __FILE__, __FUNCTION__, __LINE__);
		}

		m_replaySwitch = PLAY_FROM_FILE;

	}

	m_playerPauseFlag = RTK_TRUE;

	RTK_PLAYER_INF("m_playerPausePoint =%ld\n", m_playerPausePoint);

	ret = RTK_Player_Pause(playerHandle);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to pause av.\n");
	}

	return ret;
}


/*
** 1. resume avplay;
*/
char RTKPlayer::RT_PlayerResume()
{
	INT8_T ret = RTK_OK;
	m_playerPauseFlag = RTK_FALSE;
	RTK_Player playerHandle = m_demux;

    	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	ret = RTK_Player_Resume(playerHandle);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to resume av.\n");
	}


	return ret;
}

/*
** return RTK_TRUE(1), means stop;
** return RTK_FALSE( !RTK_TRUE ) ,means play;
*/
char RTKPlayer::RT_PlayerGetPlayBackStatus()
{
    INT8_T ret = RTK_FALSE;
    ret = m_playerPauseFlag;
    return ret;
}

/*char RTKPlayer::RT_PlayerGetControlProtocol(int* controlProtocol)
{
	INT8_T ret = RTK_OK;
	RTK_Player playerHandle = m_demux;
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}
        ret = RT_Player_GetControlProtocol(playerHandle,controlProtocol);  
        return ret;
}*/





/*
** 1. pasuse avplay;
** 1. DropData;
** 1. resume avplay;
** 2. change input from file  to memory;
*/
char RTKPlayer::RT_PlayerExitFileMode()
{
	INT8_T ret = RTK_OK;
	m_playerPauseFlag = RTK_TRUE;
	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	
	ret = RTK_Player_Pause(playerHandle);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to pause av.\n");
		return ret;
	}

	ret = RTK_Player_DropData(playerHandle);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to exitFileMode.\n");
		return ret;
	}

	m_replaySwitch = PLAY_FROM_MEM;
	m_playerPauseFlag = RTK_FALSE;
	
	ret = RTK_Player_Resume(playerHandle);
	if(ret != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to resume av.\n");
	}

	if(m_TSDataFile != NULL)
	{
		fclose(m_TSDataFile);
		m_TSDataFile = NULL;
	}

	return ret;
}

char RTKPlayer::RT_PlayerSetPlaySpeed(float speed)
{
	INT8_T ret = RTK_OK;
	float speedToDvdPlayer = 0.0;
	float prevSpeed = m_speed;
	RTK_Player playerHandle = m_demux;
	RTK_PlayerConfig playerConfig = m_demuxConfig;
	int oriPauseFlag = m_playerPauseFlag;
	int64_t cur_PTS = -1;

    	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
		playerConfig = m_playerConfig;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
		playerConfig = m_demuxConfig;
	}

	if (prevSpeed == speed)
	{
		return RTK_OK;
	}
	
	speedToDvdPlayer = speed;

	//set source feed pause
	m_playerPauseFlag = RTK_TRUE;
	while(m_sourceFeedPauseFlag == RTK_FALSE)
	{
		usleep(1000);
	}
	if(m_IdxDataSupport){
		 ret |= RTK_Player_SetTrickMode(playerHandle,RHAL_AV_TRICK_IONLY);
	}else{
		 ret |=  RTK_Player_SetTrickMode(playerHandle,RHAL_AV_TRICK_FULLTS);
	}
	//set speed
	ret |= RTK_Player_SetPlaySpeed(playerHandle, speedToDvdPlayer);		
	if((speed >= 2)||(speed <= -2))
	{
		//pvr use RTK_TRICKPLAY_STEP_BY_IFRAME, other(tsfile) source use RTK_TRICKPLAY_STEP_BY_VOBU
		if(m_IdxDataSupport || m_InputType == RTKPLAYER_INPUT_IPTV)
		{
			m_trickPlaying = RTK_TRICKPLAY_STEP_BY_IFRAME;
		}		 
		else
		{
			if((speed>2)||(speed<-2) )
			{
				m_trickPlaying = RTK_TRICKPLAY_STEP_BY_VOBU;
			}
			else
			{
				 m_trickPlaying = RTK_TRICKPLAY_NORMAL ;
			}
		}
		/////m_trickPlaying = (m_IdxDataSupport) ? RTK_TRICKPLAY_STEP_BY_IFRAME : RTK_TRICKPLAY_STEP_BY_VOBU;
		//set av free run
		ret |= RTK_Player_SetAVSyncMode(playerHandle, RTK_AVSYNC_SYSTEM_MASTER);
		//set audio mute
		ret |= RTK_Player_SetAudioMute(playerHandle, RTK_TRUE);
		if(ret==RTK_OK) m_MuteState |= MUTE_BY_TRICKPLAY;
	}
	else
	{
		m_trickPlaying = RTK_TRICKPLAY_NORMAL;
		//set sync by audio
		if(m_IdxDataSupport)
			ret |= RTK_Player_SetAVSyncMode(playerHandle, RTK_AVSYNC_AUDIO_MASTER_AUTO_SKIP);
		else 
			ret |= RTK_Player_SetAVSyncMode(playerHandle, RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
		
		//set audio unmute
		m_MuteState &= ~MUTE_BY_TRICKPLAY;
		if(m_MuteState == UNMUTE)
			ret |= RTK_Player_SetAudioMute(playerHandle, RTK_FALSE);
	}

	if(RTK_TRICKPLAY_STEP_BY_VOBU == m_trickPlaying)
	{
		ret |= RTK_Player_DropData(playerHandle);
		RT_PlayerSendVOBU();		
	}

	if(m_IdxDataSupport)
	{
		// for trick play I frame based in file mode,
		// only (normal <=> trick) switch or (forward <=> backward) switch
		// need flush and start in new position
		//if( prevSpeed == 1 || speed == 1 || (speed>0 && prevSpeed<0) || (speed<0 && prevSpeed>0) )
		{
			if(RT_PlayerGetCurrentDisplayingPTS(&cur_PTS) != RTK_OK)
			{
				cur_PTS = m_current_PTS;
				RTK_PLAYER_ERR("Failed to GetCurrentDisplayingPTS");
			}

			m_current_PTS = cur_PTS;
			RTK_PLAYER_INF("ttt get cur_PTS 0x%llx\n", cur_PTS);

			ret |= RT_PlayerSeekTo(cur_PTS);
			if(ret != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to seek 0x%llx", cur_PTS);
			}

			m_LeftDataWaitToSend = false;
		}
	}
	else if( m_InputType == RTKPLAYER_INPUT_IPTV)
	{
		RTK_Player_DropData(playerHandle);
	}

	//set source feed resume
	m_playerPauseFlag = oriPauseFlag;

	m_speed = speed;

	if ((speed == 1) && (prevSpeed != 1) && (oriPauseFlag == RTK_FALSE) )	// trick to normal play need to restart
	{
	RTK_PLAYER_INF("do not stop ...\n");
	/*
		RTK_Player_Stop(playerHandle,RTK_TRUE);
		RTK_Player_ChangeAudio(playerHandle, &playerConfig.audio);	
		RTK_Player_ChangeVideo(playerHandle, &playerConfig.video);
		RTK_Player_Start(playerHandle);
		*/
	}

	return ((ret == RTK_OK) ? RTK_OK : RTK_ERR);
}

char RTKPlayer::RT_PlayerGetPlaySpeed(float  *speed)
{
	INT8_T ret = RTK_OK;
	RTK_Player playerHandle = m_demux;

    	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	ret = RTK_Player_GetPlaySpeed(playerHandle, speed);
	
	return ret;
}


char RTKPlayer::xSeekToSecond( int startSeconds, int64_t *postion)
{
	if(startSeconds == 0)
	{
		*postion = 0;
		return RTK_OK;  
	}
	if((long long)startSeconds > m_mediaInfo.TotalSeconds  ||  startSeconds < 0)
	{
		RTK_PLAYER_ERR("[%s]the seek time is out of  range  \n", __FUNCTION__);
		return RTK_ERR;  
	}		
	if(m_mediaInfo.TotalSeconds <= 0 || m_mediaInfo.TotalBytes <= 0)
	{
		RTK_PLAYER_ERR("[%s]durationTime(%lld) or TotalBytes(%lld) is 0 \n", __FUNCTION__, m_mediaInfo.TotalSeconds, m_mediaInfo.TotalBytes);
		return RTK_ERR; 
	}

	*postion = (uint64_t)(startSeconds* m_mediaInfo.ByteRate);
	if(*postion >= m_mediaInfo.TotalBytes)
	{
		RTK_PLAYER_ERR("[%s] the postion we seek to is over, so seek to head......\n", __FUNCTION__);
		*postion = 0;
		return RTK_OK;
	}
	RTK_PLAYER_ERR("[%s] the postion we seek to is %lld.\n", __FUNCTION__, *postion);

    return RTK_OK;
}

//msec --means seek to msec 
char RTKPlayer::RT_PlayerSeekToEx(int msec)
{
	RTK_PLAYER_INF("RT_PlayerSeekToEx m_demux=%p msec=%d", m_demux, msec);

	INT8_T ret = RTK_OK;
	int sec = 0;
	RTK_Player playerHandle = m_demux;
	int64_t foundOffset = 0;

	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	if(msec % 1000 > 500)
	{
		sec = msec/1000+1;
	}
	else
	{
		sec = msec/1000;
	}

	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY|| m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	if( m_InputType == RTKPLAYER_INPUT_IPTV )
	{
		ret = RTK_Player_Pause(playerHandle);
		m_playerPauseFlag = RTK_FALSE; // to prevend stuck in ThreadProcDemuxFeed
		m_searchDiscontinue = 1;
		do{
			usleep(1000);
		}while(	m_dropFlag == 1 || m_searchDiscontinue == 1);
		RTK_Player_Resume(playerHandle);
	}
	else
	{
		// pause
		m_playerPauseFlag = RTK_TRUE;
		ret = RTK_Player_Pause(playerHandle);

		// search seek point
		m_seekOffset = 0;
		if(  m_InputType == RTKPLAYER_INPUT_FILE)
		{
			if(xSeekToSecond(sec, &foundOffset) != RTK_OK)
			{
			        RTK_PLAYER_ERR("[%s] xSeekToSecond is err......\n", __FUNCTION__);
				return RTK_ERR;
			}
			m_seekOffset = foundOffset;
		}
		m_SeekFlag = RTK_TRUE;

		//make sure source feed thread paused
		if(m_demuxFeedStop != RTK_TRUE)
		{
			while(m_sourceFeedPauseFlag == RTK_FALSE)
			{
				usleep(1000);
			}
		}

		ret |= RTK_Player_DropData(playerHandle);

		m_playerPauseFlag = RTK_FALSE;
		ret |= RTK_Player_Resume(playerHandle);
	}
	return ret;
}



// seekPTS -1 means seek to HEAD
char RTKPlayer::RT_PlayerSeekTo(int64_t seekPTS)
{	
	RTK_PLAYER_INF("RT_PlayerSeekTo m_demux=%p seekPTS=%lld", m_demux, seekPTS);

	RTK_Player playerHandle = m_demux;
	int64_t foundOffset = 0;
	INT8_T ret = RTK_OK;

    	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	// pause
	m_playerPauseFlag = RTK_TRUE;
	ret = RTK_Player_Pause(playerHandle);

	// search seek point
	m_seekOffset = 0;
	if( seekPTS != -1 && (m_arch == ARCH_DEMUX_AND_PLAY || m_InputType == RTKPLAYER_INPUT_FILE))
	{
		if(xSeekToPts(m_recordingCtrl_Rd, seekPTS, foundOffset) != RTK_OK)
		{
			return RTK_ERR;
		}
		m_seekOffset = foundOffset;
	}
	m_SeekFlag = RTK_TRUE;


	//make sure source feed thread paused
	if(m_demuxFeedStop != RTK_TRUE)
	{
		while(m_sourceFeedPauseFlag == RTK_FALSE)
		{
			usleep(1000);
		}
	}

	ret |= RTK_Player_DropData(playerHandle);

	m_playerPauseFlag = RTK_FALSE;
	ret |= RTK_Player_Resume(playerHandle);
        return ret;

}

char RTKPlayer::xSeekToPts(FILE* fp, uint64_t dstPTS, int64_t &foundOffset)
{
    PTS_OFFSET_T ptsInfo;
    if(fp == NULL)
    {
        RTK_PLAYER_ERR("%s %d:fail!! ERROR to open file!\n", __FUNCTION__, __LINE__);
        return RTK_ERR;
    }
    else
    {
        RTK_PLAYER_INF("%s %d:success!! Success to open file!\n", __FUNCTION__, __LINE__);
        fseek(fp, 0, SEEK_SET); //roll to the head of file
    }

    ptsInfo.offset = 0;
    ptsInfo.pts = 0;

    while(ptsInfo.pts < dstPTS)
    {
        if( 1 != fread( (void*)&ptsInfo, sizeof(PTS_OFFSET_T), 1, fp) )
        {
            RTK_PLAYER_INF("%s %d: to the end of ctrl file.\n", __FUNCTION__, __LINE__);
            break;
        }
    }

    foundOffset = ptsInfo.offset;
    RTK_PLAYER_INF("%s %d: seekToPTS=(%lld)0x%llx, findPTS=(%llu)0x%llx, findOffset=(%llu)0x%llx\n", __FUNCTION__, __LINE__,
        dstPTS,  dstPTS, ptsInfo.pts, ptsInfo.pts, ptsInfo.offset, ptsInfo.offset);

    return RTK_OK;
}

char RTKPlayer::RT_PlayerSetVideoMute(RTK_Bool mute)
{
	INT8_T ret = RTK_ERR;
	RTK_Player playerHandle = m_demux;

    	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	ret = RTK_Player_SetVideoMute(playerHandle,mute);
	return ret;
}

/*char RTKPlayer::RT_PlayerSetVideoScale(RTK_Aspect_Ratio ratio) 
{
	INT8_T ret = RTK_ERR;		
	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}

	ret = RTK_Player_SetVideoScale(playerHandle, ratio);
	return ret;
}*/

char RTKPlayer::RT_PlayerSetVideoOutputMode(RTK_WinPlane win_plane)
{	
	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	m_playerConfig.video.output = m_demuxConfig.video.output = win_plane;
	
	return RTK_OK;
}

// next two API only used in test bin
// Can't use it in android APK, APK need use RT_PlayerCreateWindow API
char RTKPlayer::RT_CreateSurface(int plane, int x, int y, int w, int h)
{
	INT8_T ret = RTK_OK;
	RTK_WinConfig win;
	win.plane = (RTK_WinPlane)plane;
	win.pos_x = x;
	win.pos_y = y;
	win.width = w;
	win.height = h;
	ret = RTK_CreateSurface(win);
	return ret;
}

char RTKPlayer::RT_DestorySurface(int plane)
{
	INT8_T ret = RTK_OK;
	ret = RTK_DestorySurface((RTK_WinPlane)plane);
	return ret;
}

char RTKPlayer::RT_MonitorPSI()
{
	m_isMonitorPSI = true;

	//PAT table id : 0x00 , pmt monitor will open in pat callback.
	if( xAddPAT() != RTK_OK)
		return RTK_ERR;

	//CAT table id : 0x01
	if( xAddCAT() != RTK_OK)
		return RTK_ERR;
	
	return RTK_OK;
}

/*char RTKPlayer::RT_GetVideoTrackInfo(RTK_Video_TrackInfo *pTSVideoTrackInfo)
{
	RTK_Player playerHandle = m_demux;
	int channelIndex = (m_channelIndex == -1)? 0 : m_channelIndex; // default channel 0 if not start play

	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}

	if (m_programInfo.psi_program[channelIndex].num_video_pids == 0)
	{
		if(m_saveurlflag == 0)
		{
			pTSVideoTrackInfo->pid = m_demuxConfig.video.pid;
			pTSVideoTrackInfo->type = m_demuxConfig.video.codec;
			return RTK_OK;
		}
		RTK_PLAYER_ERR("No video track found in channel %d\n", channelIndex);
		return RTK_ERR;
	}
	else if (RTK_Player_GetVideoTrackInfo(playerHandle, pTSVideoTrackInfo) != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to add CAT section filter.\n");
		return RTK_ERR;
	}
	pTSVideoTrackInfo->pid = m_programInfo.psi_program[channelIndex].video_pids[0].pid;
	pTSVideoTrackInfo->type = _xTS_Transfer_Video_Codec(m_programInfo.psi_program[channelIndex].video_pids[0].codec);
	return RTK_OK;
}

char RTKPlayer::RT_GetAudioTrackInfo(RTK_Audio_TrackInfo *pTSAudioTrackInfo, int *trackCount)
{
	RTK_Player playerHandle = m_demux;
	int channelIndex = (m_channelIndex == -1)? 0 : m_channelIndex; // default channel 0 if not start play

	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}

	unsigned char audio_num = m_programInfo.psi_program[channelIndex].num_audio_pids;
	if(*trackCount < audio_num)
	{
		RTK_PLAYER_ERR("Need more track space, audio_num=%d trackCount=%d \n", audio_num, *trackCount);
		return RTK_ERR;
	} 

	int index, count;
	count = m_programInfo.psi_program[channelIndex].num_audio_pids;
	if(count == 0)
	{
		if(m_saveurlflag == 0)
		{
			pTSAudioTrackInfo->pid = m_demuxConfig.audio.pid;
			pTSAudioTrackInfo->type = m_demuxConfig.audio.codec;
			*trackCount = 1;
			return RTK_OK;
		}
	}
	
	for (index = 0; index < count; index++)
	{
		if(m_playerConfig.audio.pid == m_programInfo.psi_program[channelIndex].audio_pids[index].pid)
		{
			break;
		}
	}

	if (index != count) // get playing audio info
	{
		if (RTK_Player_GetAudioTrackInfo(playerHandle,pTSAudioTrackInfo+index) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to get Audio TrackInfo\n");
			return RTK_ERR;
		}
	}

	for(int i = 0; i< audio_num; i++)
	{ 
		(pTSAudioTrackInfo+i)->idx = i;
		(pTSAudioTrackInfo+i)->pid = m_programInfo.psi_program[channelIndex].audio_pids[i].pid;
		(pTSAudioTrackInfo+i)->langCode = m_programInfo.psi_program[channelIndex].audio_pids[i].langCode[0];
		(pTSAudioTrackInfo+i)->type	= _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[channelIndex].audio_pids[i].codec);
	}
 
	*trackCount = audio_num;   
	
	return RTK_OK;
}

char RTKPlayer::RT_GetSubtitleTrackInfo(RTK_Subtitle_TrackInfo *pTSSubtitleTrackInfo, int *trackCount)
{
//    INT8_T ret = RTK_OK;
	int channelIndex = (m_channelIndex == -1)? 0 : m_channelIndex; // default channel 0 if not start play

//    int index =0;
    char subtitlecount = 0;
  	subtitlecount = m_programInfo.psi_program[channelIndex].num_subtitle_pids;

    if (subtitlecount == 0)
    {
         RTK_PLAYER_ERR("No subtitle track found \n");
         return RTK_ERR;
    }

    for(int i = 0; i< subtitlecount; i++)
    {
        (pTSSubtitleTrackInfo+i)->pid      = m_programInfo.psi_program[channelIndex].subtitle_pids[i].pid;
        (pTSSubtitleTrackInfo+i)->langcode = m_programInfo.psi_program[channelIndex].subtitle_pids[i].langcode;
        (pTSSubtitleTrackInfo+i)->idx      = i;
        (pTSSubtitleTrackInfo+i)->subtype  = RTKTYPE_DVB_SUBTITLE;
    }

    *trackCount = subtitlecount;

    return RTK_OK;
}


int RTKPlayer::RT_GetSelectedTrackIndex(RTK_MEDIA_TRACK_TYPE_e type)
{
	int index = 0;
	int channelIndex = (m_channelIndex == -1)? 0 : m_channelIndex; // default channel 0 if not start play

	if(type == RTK_MEDIA_TRACK_TYPE_VIDEO)
	{
		if(m_programInfo.psi_program[channelIndex].num_video_pids==0) return -1; // no video

		index = 0;
	}
	else if(type == RTK_MEDIA_TRACK_TYPE_AUDIO)
	{
		char count = 0;
		count = m_programInfo.psi_program[channelIndex].num_audio_pids;

		if(count==0) return -1; // no audio

		for(int i=0; i< count; i++)
		{
			if(m_playerConfig.audio.pid == m_programInfo.psi_program[channelIndex].audio_pids[i].pid)
			{
				index = i;
				break;
			}
		}
	}
	else if(type == RTK_MEDIA_TRACK_TYPE_SUBTITLE)
	{
		char subtitlecount = 0;
		subtitlecount = m_programInfo.psi_program[channelIndex].num_subtitle_pids;

		if(subtitlecount==0) return -1; // no subtitle

		for(int i=0; i< subtitlecount; i++)
		{
			if(m_playerConfig.subtitle.pid == m_programInfo.psi_program[channelIndex].subtitle_pids[i].pid)
			{
				index = i;
				break;
			}
		}
	}
	
	return index;
}

char RTKPlayer::RT_SetTrack(RTK_MEDIA_TRACK_TYPE_e type, int index)
{	
	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}
	else if(m_arch == ARCH_DEMUX)
	{
		RTK_PLAYER_ERR("ARCH_DEMUX can not use RT_SetTrack\n");
		return RTK_OK;
	}

	if(type == RTK_MEDIA_TRACK_TYPE_VIDEO)
	{
		//nothing to do now, only one video.
	}
	else if(type == RTK_MEDIA_TRACK_TYPE_AUDIO)
	{
		char audioChangeFlag = 0;

		for(int i=0; i< m_programInfo.psi_program[m_channelIndex].num_audio_pids; i++)
		{
			if(m_playerConfig.audio.pid != m_programInfo.psi_program[m_channelIndex].audio_pids[index].pid)
			{
				audioChangeFlag = 1;
				break;
			}
		}

		if(audioChangeFlag == 1)
		{
			RTK_PLAYER_INF("change audio pid.\n");
			//change audio pid
			m_playerConfig.audio.pid = m_demuxConfig.audio.pid = m_programInfo.psi_program[m_channelIndex].audio_pids[index].pid;
			m_playerConfig.audio.codec = m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[m_channelIndex].audio_pids[index].codec);
			m_playerConfig.audio.focused = m_demuxConfig.audio.focused=RTK_TRUE;
			RTK_AudioConfig* audio =&m_demuxConfig.audio;
			if(RTK_Player_ChangeAudioEx(playerHandle, &audio,1) != RTK_OK)
			{
				RTK_PLAYER_ERR("Failed to change audio.\n");
			}
			m_audioIndex = index;
		}
		else
		{
			RTK_PLAYER_INF("the audio index is playing now, no nned to change.\n");
		}
	}
	else if(type == RTK_MEDIA_TRACK_TYPE_SUBTITLE)
	{
		char subtitleChangeFlag = 0;

		if(m_playerConfig.subtitle.pid != m_programInfo.psi_program[m_channelIndex].subtitle_pids[index].pid)
		{
			subtitleChangeFlag = 1;
		}

		if(subtitleChangeFlag == 1)
		{
			RTK_PLAYER_INF("change subtitle pid.\n");
			m_playerConfig.subtitle.pid = m_demuxConfig.subtitle.pid = m_programInfo.psi_program[m_channelIndex].subtitle_pids[index].pid;

			//change subtitle TS filter
			RTK_SubtitleConfig Subtitleinfo;
			Subtitleinfo.idx = index;
			Subtitleinfo.pid = m_demuxConfig.subtitle.pid;
			Subtitleinfo.langcode = m_programInfo.psi_program[m_channelIndex].subtitle_pids[index].langcode;
			Subtitleinfo.subtype = m_demuxConfig.subtitle.subtype;
			Subtitleinfo.bshow = m_demuxConfig.subtitle.bshow;
			RTK_Player_SetSubtitle(playerHandle,Subtitleinfo);
		}
	}

	return RTK_OK;
}*/

char RTKPlayer::RT_PlayerGetCurrentDisplayingPTS(long long * pCurrentPTS)
{
	INT8_T ret = RTK_OK;
	RTK_Player playerHandle = m_demux;
    
	//background player no need this.
	if(m_isBackground==true)
            return RTK_ERR;
    
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	unsigned long long currentPTS = 0;
	ret = RTK_Player_GetCurrentDisplayingPTS(playerHandle, &currentPTS);
	if(ret == RTK_OK && currentPTS !=0 )
	{
		pthread_mutex_lock(&m_rtkPTSMutex);
		if( m_firstDisplayingPTS == -1)
		{
			RTK_PLAYER_INF("RT_PlayerGetCurrentDisplayingPTS update m_firstDisplayingPTS 0x%llx",currentPTS);
			m_firstDisplayingPTS = currentPTS;
		}
		pthread_mutex_unlock(&m_rtkPTSMutex);
		* pCurrentPTS = (long long)currentPTS;
	}
	else
	{
		RTK_PLAYER_ERR("fail !! RTK_Player_GetCurrentDisplayingPTS cannot get pts!\n");
	}
	
	return ret;
}

void RTKPlayer::RT_PlayerGetFirstDisplayingPTS(long long * pFirstPTS)
{
	INT8_T ret = RTK_OK;
	unsigned long long pts = 0;
	RTK_Player playerHandle = m_demux;

    	//background player no need this.
	if(m_isBackground==true)
            return ;
    	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	
	pthread_mutex_lock(&m_rtkPTSMutex);
	if( m_firstDisplayingPTS == -1)
	{
		ret = RTK_Player_GetCurrentDisplayingPTS(playerHandle, &pts);
		if(ret == RTK_OK && pts != 0)
		{
			RTK_PLAYER_INF("RT_PlayerGetFirstDisplayingPTS update m_firstDisplayingPTS 0x%llx", pts);
			m_firstDisplayingPTS = pts;
		}
	}
	* pFirstPTS = m_firstDisplayingPTS;
	pthread_mutex_unlock(&m_rtkPTSMutex);
}

void RTKPlayer::RT_PlayerGetMediaInfo(RTK_MediaInfo* info)
{
	char ret = RTK_ERR; 
	pthread_mutex_lock(&m_mediaInfoMutex);

	if(m_InputType == RTKPLAYER_INPUT_FILE)
	{
		ret=xParseCtrlData(); // update duration
		if(ret!=RTK_OK)
			xParseFileInfo();
	}
	else
	{
		m_mediaInfo.ctrlDataSupport = false;
	}

	memcpy(info, &m_mediaInfo, sizeof(RTK_MediaInfo) );

	pthread_mutex_unlock(&m_mediaInfoMutex);
	return;
}

char RTKPlayer::xfreeProgramInfoServiceData (FullSacnProInfo * ptrInfo)
 {
	TS_SDT_services *service;

	for(unsigned int i =0; i< ptrInfo->program_cnt; i++)
	{
		service = &((ptrInfo->psi_program[i]).services);        
		if(service->service_provide_name)
		{
			free(service->service_provide_name);
			service->service_provide_name = NULL;
		}
               
		if(service->service_name)
		{
			free(service->service_name);
			service->service_name = NULL;
		}
	}
       return RTK_OK;
}

char RTKPlayer::RT_GetProgramInfoList (FullSacnProInfo * ptrInfo)
{
	xfreeProgramInfoServiceData(ptrInfo);
	*ptrInfo = m_fullscanInfo;
	
	return RTK_OK;
}

int RTKPlayer::xReadDataFromFile(void *inHandle, unsigned char *data, unsigned int size)
{
	
	unsigned int realReadSize=0;
	unsigned int remainReadSize=0;

	_xSetFileBusyFlag((int)inHandle, m_playerFilePoint);
	fseek((FILE*)(inHandle), m_playerFilePoint, SEEK_SET);
	realReadSize = fread(data, 1, size, (FILE*)(inHandle));
	m_playerFilePoint = ftell((FILE*)(inHandle));	

	if((m_playerFilePoint >= MAX_FILE_SIZE)&&(feof((FILE*)(inHandle))))
	{
		m_playerFilePoint = 0;
		if(realReadSize < size)
		{
			fseek((FILE*)(inHandle), 0, SEEK_SET);
			remainReadSize = fread(data+realReadSize, 1, size-realReadSize, (FILE*)(inHandle));
		}
	}
	_xClearFileBusyFlag((int)inHandle);

	return (realReadSize+remainReadSize);

}

char RTKPlayer::xStepToNextIFrame_Forward(std::vector<IFrameElement> *IList, FeedDataInfo* info, uint64_t* new_pos)
{
	// current is the final I frame, no next I frame
	if(info->cur_it == IList->end()-1)
	{
		return RTK_Fail;
	}
	else if (info->cur_it == IList->begin())
	{
		info->cur_it += (info->currentFilePosition/info->max_Ioffset);
		for (std::vector<IFrameElement>::iterator it = info->cur_it; it != IList->end(); ++it)
		{
 			if(it->start > (uint64_t)(info->currentFilePosition))
			{
				info->cur_it = it;
				break;
			}
		}
 		info->cur_it = (info->cur_it == IList->begin()) ? info->cur_it + 1 : info->cur_it;
	}
	else
	{
		info->cur_it++;
	}

	*new_pos = info->cur_it->start;
	info->Isize = info->cur_it->size;
	
	return RTK_OK;
}
      
void RTKPlayer:: RT_PlayerSendVOBU()
{    	
	RTK_Player playerHandle = m_demux;
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	//RTK_Player_SendVOBU(playerHandle);
	return;

}
char RTKPlayer::xStepToNextIFrame_Backward(std::vector<IFrameElement> *IList, FeedDataInfo* info, uint64_t* new_pos)
{
	// current is the first I frame, no next I frame
	if (info->cur_rit == IList->rend()-1)
	{
		return RTK_Fail;
	}
	else if (info->cur_rit == IList->rbegin())
	{
		if (info->cur_rit->start > info->currentFilePosition)
		{
			info->cur_rit += (info->cur_rit->start - info->currentFilePosition)/info->max_Ioffset;
		}

		for (std::vector<IFrameElement>::reverse_iterator it = info->cur_rit ; it != IList->rend(); ++it)
		{
 			if(it->start+it->size < info->currentFilePosition)
			{
				info->cur_rit = it;
				break;
			}
		}
 		info->cur_rit = (info->cur_rit == IList->rbegin()) ? info->cur_rit + 1 : info->cur_rit;
	}
	else
	{
		info->cur_rit++;
	}

	*new_pos = info->cur_rit->start;
	info->Isize = info->cur_rit->size;
	
	return RTK_OK;
}

char RTKPlayer::xTraverseIFrame(FILE* fp, std::vector<IFrameElement> *IList, FeedDataInfo* info, RTK_TSInputBuffer* buffer)
{
    uint64_t new_pos = 0;
    uint32_t align_start_offset = 0, align_end_offset = 0;
    char has_next_IFrame;

    if(IList->empty())
    {
        RTK_PLAYER_ERR("%s %d: List doesn't contain any I frame info!!!\n", __FUNCTION__, __LINE__);
        return RTK_Fail;
    }

    if(fp == NULL)
    {
        RTK_PLAYER_ERR("%s %d: file not exist!!!\n", __FUNCTION__, __LINE__);
        return RTK_Fail;
    }

    // if current I frame has not finished feeding up yet, we jump to the feeding part
    if(m_LeftDataWaitToSend)
    {
        goto feed_data;
    }

    if(m_speed > 0) // fast-forward (speed >= 2)
    {
        has_next_IFrame = xStepToNextIFrame_Forward(IList, info, &new_pos);
    }
    else // fast-rewind (speed <= -2)
    {
        has_next_IFrame = xStepToNextIFrame_Backward(IList, info, &new_pos);
    }

    if (has_next_IFrame != RTK_OK)
    {
        info->end_of_IFrame = true;
        return RTK_Fail;
    }
    else
    {
        info->end_of_IFrame = false;
    }

    //RTK_PLAYER_INF("%s %d: new_pos:%llx Isize:%x\n", __FUNCTION__, __LINE__, new_pos, info->Isize);

    // To match alignment rule, feeding data should be stuffed with extra packing size base on MTP_BUFFER_ALIGNMENT
    align_start_offset = (uint32_t)(new_pos % (uint64_t)MTP_BUFFER_ALIGNMENT);
    new_pos -= (uint64_t)align_start_offset;
    info->Isize += align_start_offset;
    align_end_offset = (info->Isize%MTP_BUFFER_ALIGNMENT == 0)? 0: (MTP_BUFFER_ALIGNMENT - info->Isize%MTP_BUFFER_ALIGNMENT);
    info->Isize += align_end_offset;
    info->align_end_offset = align_end_offset;

    fseek(fp, new_pos, SEEK_SET);

feed_data:

    if(info->Isize > info->buffer_size)
    {
        if(fread(buffer->memory, info->buffer_size, 1, fp)!=1)
        {
            RTK_PLAYER_ERR("%s %d: fail to read file(%d).\n", __FUNCTION__, __LINE__, errno);
            return RTK_Fail;
        }
        buffer->filled_size = info->buffer_size;
        buffer->isLast = RTK_FALSE;
        info->Isize -= info->buffer_size;

        //--- send I frame info to dvdplayer using rpc
        RTK_IframeOffset_t subpart_I;
        memset(&subpart_I, 0, sizeof(subpart_I));
        subpart_I.data_size     = buffer->filled_size;
        subpart_I.iframe_offset = (m_LeftDataWaitToSend) ? 0 : align_start_offset;
        subpart_I.iframe_size   = (m_LeftDataWaitToSend) ? (buffer->filled_size) : (buffer->filled_size - align_start_offset);
        RTK_Player_SendIFrameInfo(m_demux, subpart_I);
        //--- end

        m_LeftDataWaitToSend = true;
    }
    else if (info->Isize > 0)
    {
        if(fread(buffer->memory, info->Isize, 1, fp)!=1)
        {
            RTK_PLAYER_ERR("%s %d: fail to read file(%d).\n", __FUNCTION__, __LINE__, errno);
            return RTK_Fail;
        }
        
		if(m_speed > 0)
		{
			buffer->isLast = (info->cur_it == (IList->end()-1)) ? RTK_TRUE : RTK_FALSE;
			RTK_PLAYER_INF("%s %d: (%d/%d) isLast:%d\n", __FUNCTION__, __LINE__, info->cur_it->idx, IList->size(), buffer->isLast);
		}
		else
		{
			buffer->isLast = (info->cur_rit == (IList->rend()-1)) ? RTK_TRUE : RTK_FALSE;
			RTK_PLAYER_INF("%s %d: (%d/%d) isLast:%d\n", __FUNCTION__, __LINE__, info->cur_rit->idx, IList->size(), buffer->isLast);
		}

        buffer->filled_size = info->Isize;
        info->Isize = 0;
        m_LeftDataWaitToSend = false;

        //--- send I frame info to dvdplayer using rpc
        RTK_IframeOffset_t subpart_I;
        memset(&subpart_I, 0, sizeof(subpart_I));
        subpart_I.data_size     = buffer->filled_size;
        subpart_I.iframe_offset = 0;
        subpart_I.iframe_size   = buffer->filled_size - info->align_end_offset;
        RTK_Player_SendIFrameInfo(m_demux, subpart_I);
        //--- end
    }

    return RTK_OK;
}

void RTKPlayer::xExtractIFrameInfo(std::vector<IFrameElement> * IFrameList, FeedDataInfo* info)
{
    if(m_recordingIdx_Rd==NULL)
    {
        RTK_PLAYER_ERR("%s %d: idx file not exist\n", __FUNCTION__, __LINE__);
        return;
    }

    if(feof(m_recordingIdx_Rd))
    {
        fseek(m_recordingIdx_Rd, 0, SEEK_END);
        //RTK_PLAYER_ERR("%s %d: already end of file(size:%ld), no more info to extract\n", __FUNCTION__, __LINE__, ftell(m_recordingIdx_Rd));
        return;
    }

    FRAME_OFFSET_T last_pFrameInfo;
    FRAME_OFFSET_T pFrameInfo;
    IFrameElement  pFrameElement;
    bool gotI = false;

    memset(&last_pFrameInfo, 0, sizeof(FRAME_OFFSET_T));
    memset(&pFrameInfo, 0, sizeof(FRAME_OFFSET_T));
    memset(&pFrameElement, 0, sizeof(IFrameElement));

    // start reading idx.dat from the last stop position (especially for the case "watch A, record A")
    fseek(m_recordingIdx_Rd, m_idxLastReadStopPosition, SEEK_SET);

    while(1)
    {
        if(fread(&pFrameInfo, sizeof(FRAME_OFFSET_T), 1, m_recordingIdx_Rd)!=1)
        {
            //RTK_PLAYER_INF("%s %d: to the end of idx file.\n", __FUNCTION__, __LINE__);
            break;
        }
        else
        {
            if(pFrameInfo.frame == 0)
            {
                last_pFrameInfo.offset = pFrameInfo.offset;
                last_pFrameInfo.frame = pFrameInfo.frame;
                gotI = true;
            }
            else
           {
                if(gotI)
                {
                    pFrameElement.start = last_pFrameInfo.offset;
                    pFrameElement.size = static_cast<uint32_t>(pFrameInfo.offset - last_pFrameInfo.offset);
                    pFrameElement.idx = m_idx++;
                    IFrameList->push_back(pFrameElement);
                    gotI = false;
                }
            }
        }
    }

    // note the temporary end position of idx.dat (especially for the case "watch A, record A")
    m_idxLastReadStopPosition = ftell(m_recordingIdx_Rd);

    // collect min/max info for trick-playing use
    for (std::vector<IFrameElement>::iterator it = IFrameList->begin(); it != IFrameList->end(); ++it)
    {
        if(it == IFrameList->begin())
        {
            info->min_Ioffset = it->start;
            info->max_Ioffset = it->start;
            continue;
        }
        if(it->start - (it-1)->start < info->min_Ioffset) info->min_Ioffset = it->start - (it-1)->start;
        if(it->start - (it-1)->start > info->max_Ioffset) info->max_Ioffset = it->start - (it-1)->start;
    }
    //RTK_PLAYER_INF("%s %d:: min(%llu) max(%llu)\n", __FUNCTION__, __LINE__, info->min_Ioffset, info->max_Ioffset);
}

uint32_t RTKPlayer::xReadNextScanningStep(FILE* fp, uint32_t readSize, RTK_TSInputBuffer* buffer)
{
	if(fp == NULL)
    	{
       	RTK_PLAYER_ERR("%s %d: file not exist!!!\n", __FUNCTION__, __LINE__);
        	return RTK_Fail;
	}
	if(buffer== NULL)
    	{
       	RTK_PLAYER_ERR("%s %d: buffer not exist!!!\n", __FUNCTION__, __LINE__);
        	return RTK_Fail;
   	}
	long cur_pos = 0;
	int64_t seek_offset = 0;
	int offset = 0;
	unsigned int scanningSecStride = 0;
    	 if( m_SendVOBUdatatimes == 0)
	 {       	
		RT_PlayerSendVOBU();		
		unsigned int i = (ABS(m_speed) - 1) / RTK_MIN_SCAN_SPEED;
		if(i >= (sizeof(g_scanningJumpTable)/sizeof(g_scanningJumpTable[0])))
		{
			i = (sizeof(g_scanningJumpTable)/sizeof(g_scanningJumpTable[0])) - 1;
		}
		scanningSecStride = g_scanningJumpTable[i];
		unsigned int byteRate = m_mediaInfo.ByteRate ;
		unsigned int scanningPosStride = (scanningSecStride * byteRate) >> 12;
		cur_pos = ftell(fp);	
		long  m_scanningStepBegin = cur_pos;
		m_scanningStepBegin >>= 12;
		m_scanningStepBegin += scanningPosStride;
		seek_offset= (m_scanningStepBegin<<12);
		if(0 != fseek(fp, seek_offset, SEEK_SET))
		{
			RTK_PLAYER_INF("%s %d:fseek error.\n", __FUNCTION__, __LINE__);
		}
		int realReadSize = fread(m_pDurationBuffer,1,  readSize, fp);
		(void)realReadSize;
		//RTK_PLAYER_INF("%s %d:realReadSize=%d\n", __FUNCTION__, __LINE__, realReadSize);

		offset = xReSyncStream(m_pDurationBuffer, readSize);
		seek_offset += offset;
		fseek(fp, seek_offset,SEEK_SET);
		cur_pos = ftell(fp);
		if(cur_pos > m_mediaInfo.TotalBytes) // the data less than 188,so seek to head
		{
			fseek(fp, 0, SEEK_CUR);		
		}	  
			
	}
	m_SendVOBUdatatimes++;
	int sendVOBUdatatimeslimit = (8*188*1024) /readSize;
	if( m_SendVOBUdatatimes == (sendVOBUdatatimeslimit+1))
	{
		m_SendVOBUdatatimes =0;
	}
    	        
	buffer->filled_size= fread(buffer->memory, 1, readSize, fp);   	
       return buffer->filled_size;
}


void RTKPlayer::HalCallback(RTK_CallbackEvent event, HAL_TYPE type, void * data, uint32_t data_size)
{
	(void) type; // fix unused compile warning
//	void * pData = data;
	RTK_PLAYER_INF("player_callback(%p) event: %d, data_size=%d\n", this, event, data_size);
	switch(event)
	{
		case RTK_CLEANUP:
			RT_PlayerStop();
			RT_PlayerDestory();
			
			break;
		case RTK_FIRST_IFRAME_DISPLAYED:
		{
			RT_PlayerNotify(RTK_PLAYER_FIRSTIFRAME_DISPLAYED, NULL);
			RTK_PLAYER_INF("HalCallback : RTK_FIRST_IFRAME_DISPLAYED...\n");

			int retry = 0;
			RTK_Player playerHandle = m_demux;
			m_firstplayready = 1; 
			if(m_arch == ARCH_DEMUX_AND_PLAY)
			{
				playerHandle = m_player;
			}
			else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
			{
				playerHandle = m_demux;
			}
			
			pthread_mutex_lock(&m_rtkPTSMutex);
			while( m_firstDisplayingPTS == -1 && retry <= 50)
			{
				unsigned long long firstDisplayingPTS = 0;
				if(RTK_Player_GetCurrentDisplayingPTS(playerHandle, &firstDisplayingPTS) == RTK_OK && firstDisplayingPTS > 0)
				{
					m_firstDisplayingPTS = (long long)firstDisplayingPTS;
					RTK_PLAYER_INF("HalCallback : m_firstDisplayingPTS=%lld (0x%llx) (retry %d)\n", m_firstDisplayingPTS, m_firstDisplayingPTS, retry);
					break;
				}
				pthread_mutex_unlock(&m_rtkPTSMutex);
				retry++;
				usleep(1000);
				pthread_mutex_lock(&m_rtkPTSMutex);
			}
			pthread_mutex_unlock(&m_rtkPTSMutex);
			if(retry>50)
			{
				RTK_PLAYER_ERR("HalCallback : update m_firstDisplayingPTS failed");
				break;
			}
			break;
		}

		case RTK_EOS:
			RT_PlayerNotify(RTK_PLAYER_EOS, NULL);
			RTK_PLAYER_INF("player_callback : RTK_EOS...\n");
			break;
		case RTK_VORUN_AFTER_AVSYNC:
			{
				RTK_PLAYER_INF("player_callback : RTK_VORUN_AFTER_AVSYNC...\n");
				if(m_demuxConfig.video.output != RTK_WIN_PIP) 
				{	
					if(m_MuteState&MUTE_BY_AVSYNC)
					{
						m_MuteState &= ~MUTE_BY_AVSYNC;
						INT8_T ret = RTK_Player_SetAudioMute(m_demux, (m_MuteState==UNMUTE)?RTK_FALSE:RTK_TRUE );
						if(ret==RTK_OK)
						{
							RTK_PLAYER_INF("[%d][%s] set audio unmute\n", m_demuxConfig.video.output, __FUNCTION__);
						}
					}
				}
				break;
			}
		case RTK_AVPLAY_VIDEO_LOST:
			{
				RTK_PLAYER_INF("player_callback : RTK_AVPLAY_VIDEO_LOST...\n");
				if(m_demuxConfig.video.output != RTK_WIN_PIP) 
				{	
					if(m_MuteState&MUTE_BY_AVSYNC)
					{
						m_MuteState &= ~MUTE_BY_AVSYNC;
						INT8_T ret = RTK_Player_SetAudioMute(m_demux, (m_MuteState==UNMUTE)?RTK_FALSE:RTK_TRUE );
						if(ret==RTK_OK)
						{
							RTK_PLAYER_INF("[%d][%s] set audio unmute\n", m_demuxConfig.video.output, __FUNCTION__);
						}
					}
				}
				break;
			}
		case RTK_FILTER_TS_DATA:
			{
				//RTK_PLAYER_INF("player_callback : RTK_FILTER_TS_DATA... m_startRecording=%d, data_size=%d\n", m_startRecording, data_size);
#if (0)//for test. store src file to compile.
				static FILE * callback_file = NULL;
				if(callback_file == NULL)
				{
					callback_file = fopen("/data/callback.ts", "wb+");
				}
				if(callback_file == NULL)
				{
					RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open callback file!\n", __FILE__, __FUNCTION__, __LINE__);
					return;
				}
				else
				{	
					RTK_PLAYER_INF("%s %s %d:success!! Success to open callback file!\n", __FILE__, __FUNCTION__, __LINE__);
				}
		
				if(data_size != 0)
				{
					fwrite(data, data_size, 1, callback_file);
				}
#endif

				
				//PVR: save recording.ts.
				if(m_startRecording == RTK_TRUE)
				{
					// check if free space is enough
					struct statvfs buf;
					int ret_stat;
					int64_t d_avail;

					ret_stat = statvfs(m_recordingFilePath,&buf);

					if(ret_stat==0)
					{
						d_avail= (int64_t)buf.f_bavail * buf.f_bsize;
						//RTK_PLAYER_INF("Current available space: (%ld,%ld,%" PRId64 ")\n", buf.f_bsize, buf.f_bavail, d_avail);

						if(d_avail <= static_cast<int64_t>(data_size)) // free space is not enough
						{
							RTK_PLAYER_ERR("Out of storage memory");
							RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_DISK_FULL, NULL);
							return;
						}
					}
					else
					{
						RTK_PLAYER_ERR("[%d] statvfs fail(%d)", __LINE__, errno);
						switch(errno){
							case EACCES:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_NO_PERMISSION, NULL);
								break;
							default:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
								break;
						}
						return;
					}

					// max file size check
					struct stat fileStat;

					fstat(fileno(m_recordingFile), &fileStat);
					if(data_size+fileStat.st_size > 4294967295) // reach max file size 4GB for filesystem FAT32
					{
						RTK_PLAYER_ERR("Reach max file size limit, stop recording.");
						RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_MAX_FILE_SIZE, NULL);
						return;
					}
					RTK_PLAYER_INF("Current file size is %lld bytes\n", fileStat.st_size);

					// pass the check, then write data to file
					if(fwrite(data, data_size, 1, m_recordingFile)!=1)
					{
						fflush(m_recordingFile);
						RTK_PLAYER_ERR("Write recording file error!!");
						RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
						return;
					}
					fflush(m_recordingFile);
				}

				//copy data to buffer to Encrypt.
				if(data_size != 0 && m_arch == ARCH_DEMUX_AND_PLAY)
				{
					pthread_mutex_lock(&m_rtkDataCallBackMutex);
					xCopyToDataStoreMemory((char*)data, data_size);
					pthread_mutex_unlock(&m_rtkDataCallBackMutex);
				}

				if(m_firstReceiveTSData == 0)
				{
					RTK_PLAYER_INF("player_callback : First Receive RTK_FILTER_TS_DATA...\n");
					m_firstReceiveTSData = 1;
					RT_PlayerNotify(RTK_PLAYER_TS_FIRSTRECEIVE, NULL);
				}
				break;
			}
		case RTK_FILTER_TS_CTRL:
			{
				//PVR: save ctrl.dat. 8bit: offset, 8bit: pts.
				if(m_startRecording == RTK_TRUE)
				{
					if(m_recordingCtrl_Wr == NULL)
					{
						RTK_PLAYER_ERR("player_callback : there is no file to save pts info!!\n");
						m_recordingCtrl_Wr = fopen("/data/1_ctrl.dat", "wb+");
					}

					// check if free space is enough
					struct statvfs buf;
					int ret_stat;
					int64_t d_avail;

					ret_stat = statvfs(m_recordingFilePath,&buf);

					if(ret_stat==0)
					{
						d_avail= (int64_t)buf.f_bavail * buf.f_bsize;

						if(d_avail <= static_cast<int64_t>(data_size)) // free space is not enough
						{
							RTK_PLAYER_ERR("Out of storage memory");
							RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_DISK_FULL, NULL);
							return;
						}
					} else {
						RTK_PLAYER_ERR("[%d] statvfs fail(%d)", __LINE__, errno);
						switch(errno){
							case EACCES:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_NO_PERMISSION, NULL);
								break;
							default:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
								break;
						}
						return;
					}

					//store PTS_OFFSET_T.
					PTS_OFFSET_T *ptsInfo = (PTS_OFFSET_T *)data;
					unsigned int info_cnt = data_size/sizeof(PTS_OFFSET_T);
#if 0 // for debug
					for(int ii=0; ii < info_cnt; ii++)
					{
						RTK_PLAYER_INF("ptsInfo : pts %llx offset %llx\n", ptsInfo[ii].pts ,ptsInfo[ii].offset);
					}
#endif
					if(fwrite(ptsInfo, sizeof(PTS_OFFSET_T), info_cnt, m_recordingCtrl_Wr) != (size_t)info_cnt)
					{
						RTK_PLAYER_ERR("Write ts ctrl file error!!");
						RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
					}
					fflush(m_recordingCtrl_Wr);
				}
				break;
			}
		case RTK_FILTER_TS_INDEX:
			{
				//PVR: save idx.dat. 8bit: offset, 8bit: frameType.
				if(m_startRecording == RTK_TRUE)
				{
					if(m_recordingIdx_Wr == NULL)
					{
						RTK_PLAYER_ERR("player_callback : there is no file to save frame info!!\n");
						m_recordingIdx_Wr = fopen("/data/1_idx.dat", "wb+");
					}

					// check if free space is enough
					struct statvfs buf;
					int ret_stat;
					int64_t d_avail;

					ret_stat = statvfs(m_recordingFilePath,&buf);

					if(ret_stat==0)
					{
						d_avail= (int64_t)buf.f_bavail * buf.f_bsize;

						if(d_avail <= static_cast<int64_t>(data_size)) // free space is not enough
						{
							RTK_PLAYER_ERR("Out of storage memory");
							RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_DISK_FULL, NULL);
							return;
						}
					} else {
						RTK_PLAYER_ERR("[%d] statvfs fail(%d)", __LINE__, errno);
						switch(errno){
							case EACCES:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDER_NO_PERMISSION, NULL);
								break;
							default:
								RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
								break;
						}
						return;
					}
					
					//store FRAME_OFFSET_T.
					FRAME_OFFSET_T * pFrameInfo = (FRAME_OFFSET_T* )data;
					unsigned int info_cnt = data_size/sizeof(FRAME_OFFSET_T);
#if 0 // for debug
					for(int ii=0; ii < info_cnt; ii++)
					{
						if(INDEX_FRAME_TYPE_B == pFrameInfo[ii].frame)
							RTK_PLAYER_INF("frameInfo : frame B offset %llx\n" ,pFrameInfo[ii].offset);
						else if(INDEX_FRAME_TYPE_P == pFrameInfo[ii].frame)
							RTK_PLAYER_INF("frameInfo : frame P offset %llx\n" ,pFrameInfo[ii].offset);
						else if(INDEX_FRAME_TYPE_I == pFrameInfo[ii].frame)
							RTK_PLAYER_INF("frameInfo : frame I offset %llx\n" ,pFrameInfo[ii].offset);
						else
							RTK_PLAYER_INF("frameInfo : frame type %d offset %llx\n" ,pFrameInfo[ii].frame, pFrameInfo[ii].offset);
					}
#endif
					if(fwrite(pFrameInfo, sizeof(FRAME_OFFSET_T), info_cnt, m_recordingIdx_Wr) != (size_t)info_cnt)
					{
						RTK_PLAYER_ERR("Write ts index file error!!");
						RT_PlayerNotify(RTK_PLAYER_PVR_ERROR_RECORDING_ERROR, NULL);
					}
					fflush(m_recordingIdx_Wr);
				}				
				break;
			}

		default:
			RTK_PLAYER_INF("unhandled event: %d\n", event);
			break;
	}
}

void RTKPlayer::HalCallbackEntry(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	RTKPlayer* pThis = (RTKPlayer*)user_param;
	
	pThis->HalCallback(event, type, data, data_size);
}

void RTKPlayer::RT_PlayerNotify(RTK_PLAYER_CB_TYPE_e type, void* data)
{
	if(m_playerCallBackFct)
	{
		m_playerCallBackFct(type ,data, m_playerCallBackUserParam);
	}
}

void RTKPlayer::RT_PlayerCallbackRegister(RTK_PLAYER_CALLBACK fct , void* user_param)
{
	m_playerCallBackFct = fct;
	m_playerCallBackUserParam = user_param;
}

void* RTKPlayer::ThreadWaitPMTEntry(void* pInstance)
{
	RTKPlayer* pThis = (RTKPlayer*)pInstance;

	pThis->ThreadWaitPMT();

	return NULL;

}
void*  RTKPlayer::ThreadWaitPMT()
{
    struct timeval old_time,cur_time;
	int flag = 1; 
	memset(&old_time,0,sizeof(struct timeval));
	memset(&cur_time,0,sizeof(struct timeval));
	gettimeofday(&old_time,0);	
	
	while(flag)
	{	
		if(m_waitPMTStop == RTK_TRUE){
		 break;
		}
		gettimeofday(&cur_time,0);
		if(cur_time.tv_sec -old_time.tv_sec+(cur_time.tv_usec -old_time.tv_usec)/1000000L >= 5)
		   flag = 0;
		usleep(10*1000); 
	}
		
	if(m_waitPMTStop == RTK_TRUE){
		return NULL;
	}
//	uint32_t rc, status;
	 if(m_receivedProgramCount != m_programInfo.program_cnt  )//not got all pmt tables.
		{
			m_receivedFullScanProCount += m_receivedProgramCount ;
			RTK_PLAYER_INF("[%s:%d]timeout m_receivedFullScanProCount:%d, \n",__FUNCTION__,__LINE__,m_receivedFullScanProCount);

			int channelIndex = 0;
			int idx;
			for (idx = 0; idx < m_receivedProgramCount; idx++)
			{
				if(((m_demuxConfig.audio.pid == m_programInfo.psi_program[idx].audio_pids[m_audioIndex].pid) &&
					(m_demuxConfig.audio.codec == _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[idx].audio_pids[m_audioIndex].codec)))
					||((m_demuxConfig.video.pid == m_programInfo.psi_program[idx].video_pids[0].pid) &&
					 (m_demuxConfig.video.codec == _xTS_Transfer_Video_Codec(m_programInfo.psi_program[idx].video_pids[0].codec))))
					{
						RTK_PLAYER_INF("m_playingProgramNum existed in pat.\n");
						channelIndex = idx;
						m_playProgramNum = m_programInfo.psi_program[channelIndex].program_number;	
						break;
					}
			}
			
			if(idx >= m_receivedProgramCount)
			{
				RTK_PLAYER_INF("[%s:%d]play the first pn.\n",__FUNCTION__,__LINE__);
				m_playProgramNum = m_programInfo.psi_program[0].program_number;
				channelIndex = 0;
			}						
			
			int j=m_fullscanInfo.program_cnt;
			for(int i=0 ;i< m_receivedProgramCount; i++)
			{
				m_fullscanInfo.program_bw[i+j]=m_demuxConfig.input.tuner.bandwidth;		
				m_fullscanInfo.program_freq[i+j]=m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32frequency;
				memcpy(&(m_fullscanInfo.psi_program[i+j]), &(m_programInfo.psi_program[i]), sizeof(TS_PSI_Program));
				m_fullscanInfo.program_rate[i+j] = m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32symbol_rate;
				m_fullscanInfo.program_lnb_or_qam[i+j] =  m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation;
				RTK_PLAYER_INF("llldebug [%s:%d] m_programInfo.psi_program[%d].video_pids:%d. \n",__FUNCTION__,__LINE__,i,m_programInfo.psi_program[i].video_pids[0].pid);
				m_fullscanInfo.program_cnt = m_receivedFullScanProCount;
			}
				
				if(m_updateinfoflag == 1){
					RTK_PLAYER_INF("[%s:%d] call apk to show programlist m_updateinfoflag %d \n",__FUNCTION__,__LINE__,m_updateinfoflag);
					RT_PlayerNotify(RTK_PLAYER_SECTION_PROGRAMINFO, &m_fullscanInfo);	
	 			}
				// set AV pid .
				xChangeAvParm(channelIndex);                       
			
			if(m_saveurlflag >=0 )
			{
				RTK_PLAYER_INF("[%s:%d] update channel list\n",__FUNCTION__,__LINE__);
				update_channellist();
			}
	  }

	 return NULL;
		
}

void RTKPlayer::SectionCallback(	const RTK_SectionFilter handle,const uint8_t *_section, const uint32_t length)
{
	TS_PSI_header PATHeader;
	TS_PSI_header CATHeader;
	TS_PSI_header PMTheader;
	TS_SI_header SDTHeader;
	TS_PSI_Program PMTprogramInfo;
	TS_CAT_program CATprogramInfo;
	TS_PAT_program PATprogram;

	const unsigned char* sectionData = _section;
	const uint32_t  sectionLen = length;

	do
	{
		if (TS_PSI_TID_PAT == sectionData[0]) //PAT
		{
			//-------------------------------------------------------------------------
			//	Parse Header info from PAT table
			//-------------------------------------------------------------------------
			int32_t numOfProgram=0, i=0, rc=-1;
			bzero(&PATHeader, sizeof(PATHeader));
			bzero(&PATprogram, sizeof(PATprogram));
			TS_PSI_getSectionHeader(sectionData, &PATHeader);

			// add to check av again from preparse mode to start play mode
			if(m_updateinfoflag == 1)
				xChangeAvParm(m_channelIndex);

			if (m_programInfo.pat_program.version == PATHeader.version_number)
			{
				if(!m_isMonitorPSI)
					RTK_PLAYER_INF("Received same version PAT. Skip this\n");
			}
			else
			{
				RTK_PLAYER_INF("###### Received new PAT ###!!! vsersion old:new 0x%x:0x%x\n",   m_programInfo.pat_program.version,PATHeader.version_number);
				m_programInfo.pat_program.version = PATHeader.version_number;
				RT_PlayerNotify(RTK_PLAYER_SECTION_PAT, &m_programInfo);

				numOfProgram = TS_PAT_getNumPrograms(sectionData);
				RTK_PLAYER_INF("[%d] Received PAT :  %d programs\n",__LINE__,numOfProgram);
				m_programInfo.program_cnt = numOfProgram;
				int program_index = 0; 
				for (i = 0; i < numOfProgram; i++)
				{
					RTK_PLAYER_INF("[%d] Received PAT (index:%d) %d programs\n",__LINE__,i, numOfProgram);
					rc = TS_PAT_getProgram((const unsigned char*)sectionData, sectionLen, i,  &PATprogram);

					if(PATprogram.program_number == TS_PSI_TID_NETWORK) //network
					{
						m_programInfo.program_cnt --;
						continue;
					}
					if (!rc && PATprogram.program_number) 
					{
						RTK_PLAYER_INF("*********************PAT Information*********************\n");
						RTK_PLAYER_INF("Parsed Program PID    : 0x%04X\n", PATprogram.PID);
						RTK_PLAYER_INF("Parsed Program number : 0x%04X\n", PATprogram.program_number);
						RTK_PLAYER_INF("*********************************************************\n");
						m_programInfo.psi_program[program_index].program_number = PATprogram.program_number;
						m_programInfo.psi_program[program_index].map_pid = PATprogram.PID;
						program_index ++;

						if(!m_isMonitorPSI)//to get PMT, because thres is no PMT now.
						{
							xAddPMT(PATprogram.PID);
						}
					}
				}// for loop numOfProgram
			}

			// for Monitor PSI.
			if(m_isMonitorPSI)//always has PMT, just monitor the correct PMT..
			{
				unsigned short pmtPid = 0;
				for (i = 0; i < numOfProgram; i++)
				{
					if(m_programInfo.psi_program[i].program_number == m_playProgramNum)
					{
						RTK_PLAYER_INF("m_playingProgramNum exsited in pat.\n");
						pmtPid = m_programInfo.psi_program[i].map_pid;
						break;
					}
				}
				if(i > numOfProgram)
				{
					RTK_PLAYER_INF("m_playingProgramNum not exsited in pat, play the first pn.\n");
					m_playProgramNum = m_programInfo.psi_program[0].program_number;
					pmtPid = m_programInfo.psi_program[0].map_pid;
				}

				xAddPMT(pmtPid);
			}
			else  // !m_isMonitorPSI
			{
				xRemovePAT();
			}
		}
		else if (TS_PSI_TID_CAT == sectionData[0]) //CAT
		{
		
			//-------------------------------------------------------------------------
			//	Parse Header info from CAT table
			//-------------------------------------------------------------------------
			bzero(&CATHeader, sizeof(CATHeader));
			bzero(&CATprogramInfo, sizeof(CATprogramInfo));
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &CATHeader);

			if (m_programInfo.cat_program.version != CATHeader.version_number)
			{
				RTK_PLAYER_INF("#### Received new CAT ####!!oldCATVersion=0x%x,newCATVersion=0x%x \n",m_programInfo.cat_program.version,CATHeader.version_number);
				m_programInfo.cat_program.version = CATHeader.version_number;

				RT_PlayerNotify(RTK_PLAYER_SECTION_CAT, &m_programInfo);

				//-------------------------------------------------------------------------
				//	Parse EMM PID from CAT table
				//-------------------------------------------------------------------------
				CATprogramInfo.version = CATHeader.version_number;
				TS_PSI_parseCAT((const uint8_t *)sectionData, sectionLen, &CATprogramInfo);

				RTK_PLAYER_INF("*********************CAT Information*********************\n");
				RTK_PLAYER_INF("CAT version    : 0x%04x\n", CATprogramInfo.version );
				RTK_PLAYER_INF("CAT CasIDCount	: 0x%04x\n", CATprogramInfo.CasIDCount );

				for(int index = 0; index <CATprogramInfo.CasIDCount;index++ )
				{
					RTK_PLAYER_INF("CAT cas_id[%d]: 0x%04x, EMM PID:0x%04x\n",index, CATprogramInfo.cas_id[index],CATprogramInfo.ca_pid[index] ); 
				}

				//moniter PSI for emm pid changed
				if(m_isMonitorPSI)//always has CAT, change CATInfo when CAT changed.
				{
					unsigned short cas_id = 0xffff;
					unsigned short emm_pid = 0xffff;

					RTK_PLAYER_INF("[%s:%d]current CA system ID:0x%04x ",__func__,__LINE__,cas_id);

					for(int index = 0;index < CATprogramInfo.CasIDCount;index++)
					{
						if(cas_id == CATprogramInfo.cas_id[index])
						{
							emm_pid = CATprogramInfo.ca_pid[index];
							break;
						}
					}

					if((m_demuxConfig.descrambler.emm_pid != emm_pid) &&(0xffff != emm_pid))
					{
						RTK_PLAYER_INF("EMM_PID Changed : old - 0x%04x, new - 0x%04x\n", m_demuxConfig.descrambler.emm_pid, emm_pid);
						m_demuxConfig.descrambler.emm_pid = emm_pid;
					}
				}
				m_programInfo.cat_program = CATprogramInfo;
			}

			if(!m_isMonitorPSI)
			{
				xRemoveCAT();
			}
		}
		else if (sectionData[0] == TS_PSI_TID_PMT) /* PMT */
		{	
			//-------------------------------------------------------------------------
			//	init param
			//-------------------------------------------------------------------------
			bzero(&PMTheader, sizeof(PMTheader));
			bzero(&PMTprogramInfo, sizeof(PMTprogramInfo));

			int index = 0;
			int program_index = -1;
			bool received_same_version_PMT = false;
			int i = 0;
			//-------------------------------------------------------------------------
			//	parse PMT Header
			//-------------------------------------------------------------------------
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &PMTheader );
			//-------------------------------------------------------------------------
			//	check received same version pmt
			//-------------------------------------------------------------------------

			for(index=0; index<m_programInfo.program_cnt; index++)
			{
				if((m_programInfo.psi_program[index].program_number == PMTheader.table_id_extension)&& (m_programInfo.psi_program[index].received == true))
				{
					if(PMTheader.version_number == m_programInfo.psi_program[index].version)
					{
						received_same_version_PMT = true;
						break;
					}
				}
			}

			if(true == received_same_version_PMT)
			{
				if(!m_isMonitorPSI)
					xRemovePMT(handle);
				break;
			}

			for(index=0; index<m_programInfo.program_cnt; index++)
			{
				if(m_programInfo.psi_program[index].program_number == PMTheader.table_id_extension)
				{
					//RTK_PLAYER_INF("########################## Received PMT ##########################\n");
					program_index = index;
					break;
				}
			}
			if(program_index == -1)
			{
				RTK_PLAYER_ERR("Received PMT program_number = 0x%04x but NOT in PAT (%d)\n",PMTheader.table_id_extension, m_programInfo.program_cnt);
				break;
			}

			//-------------------------------------------------------------------------
			//	Store the main information about the program
			//-------------------------------------------------------------------------
			PMTprogramInfo.program_number	= PMTheader.table_id_extension;
			PMTprogramInfo.version			= PMTheader.version_number;
			PMTprogramInfo.pcr_pid			= TS_PMT_getPcrPid((const uint8_t *)sectionData, sectionLen);
			PMTprogramInfo.descramble_info.descramble_algorithm = DESCRAMBLE_ALGO_UNKNOW;

			//-------------------------------------------------------------------------
			//	Parse programe info from PMT table
			//-------------------------------------------------------------------------
			TS_PSI_parsePMT((const uint8_t *)sectionData, sectionLen, &PMTprogramInfo);
			if(m_isPvr && m_pvr_index == -1){
				m_pvr_index = program_index;
			}
			RTK_PLAYER_INF("*********************PMT Information********************* %d\n",program_index);
			RTK_PLAYER_INF("Program number           : 0x%04x\n", PMTprogramInfo.program_number);
			RTK_PLAYER_INF("Program version           : 0x%04x\n", PMTprogramInfo.version);
			RTK_PLAYER_INF("Program pcrPID            : 0x%04x\n", PMTprogramInfo.pcr_pid);

			RTK_PLAYER_INF("Program CasIDCount      :%d\n", PMTprogramInfo.CasIDCount);

			for(int index = 0;index <  PMTprogramInfo.CasIDCount;index++)
			{
				RTK_PLAYER_INF("Program CA_system_ID[%d]    : 0x%04x\n", index,PMTprogramInfo.cas_id[index]);     
				RTK_PLAYER_INF("Program ECM_PID[%d]         : 0x%04x\n", index,PMTprogramInfo.ca_pid[index]);
			}

			RTK_PLAYER_INF("Program scramble_algo   : 0x%04x\n", PMTprogramInfo.descramble_info.descramble_algorithm);
			RTK_PLAYER_INF("Program IV_value_avai   : 0x%04x\n", PMTprogramInfo.descramble_info.IV_value_available);
			RTK_PLAYER_INF("Program numOfVideoPID   : 0x%04x\n", PMTprogramInfo.num_video_pids);
			RTK_PLAYER_INF("Program numOfAudioPID   : 0x%04x\n", PMTprogramInfo.num_audio_pids);
			RTK_PLAYER_INF("Program numOfOtherPID   : 0x%04x\n", PMTprogramInfo.num_other_pids);
                      	RTK_PLAYER_INF("Program numOfSubtitlePID   : 0x%04x\n", PMTprogramInfo.num_subtitle_pids);
			RTK_PLAYER_INF("=============== Video ===============\n");

			for (i = 0; i < PMTprogramInfo.num_video_pids; i++)
			{
				RTK_PLAYER_INF("Program %d'th VideoES_PID: 0x%04x\n", i, PMTprogramInfo.video_pids[i].pid);
				RTK_PLAYER_INF("Program %d'th Video_Codec: 0x%04x\n", i, PMTprogramInfo.video_pids[i].codec);
				int32_t index;
				for (index = 0; index < PMTprogramInfo.video_pids[i].CasIDCount; index++)
				{
					RTK_PLAYER_INF("video Program %d'th cas_id: 0x%04x\n", index, PMTprogramInfo.video_pids[i].cas_id[index]);
					RTK_PLAYER_INF("video Program %d'th ecm pid: 0x%04x\n", index, PMTprogramInfo.video_pids[i].ca_pid[index]);                        
				}
			}

			RTK_PLAYER_INF("=============== Audio ===============\n");

			for (i = 0; i < PMTprogramInfo.num_audio_pids; i++)
			{
				RTK_PLAYER_INF("Program %d'th AudioES_PID: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].pid);
				RTK_PLAYER_INF("Program %d'th Audio_Codec: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].codec);

				int32_t index;
				for (index = 0; index < PMTprogramInfo.audio_pids[i].CasIDCount; index++)
				{
					RTK_PLAYER_INF("audio Program %d'th cas_id: 0x%04x\n", index, PMTprogramInfo.audio_pids[i].cas_id[index]);
					RTK_PLAYER_INF("audio Program %d'th ecm pid: 0x%04x\n", index, PMTprogramInfo.audio_pids[i].ca_pid[index]);                        
				}

			}
			RTK_PLAYER_INF("=============== Others ===============\n");

			for (i = 0; i < PMTprogramInfo.num_other_pids; i++)
			{
				RTK_PLAYER_INF("Program %d'th OtherES_PID : 0x%04x\n", i, PMTprogramInfo.other_pids[i].pid);
				RTK_PLAYER_INF("Program %d'th Other_stream: 0x%04x\n", i, PMTprogramInfo.other_pids[i].stream_type);
				int32_t index;
				for (index = 0; index < PMTprogramInfo.other_pids[i].CasIDCount; index++)
				{
					RTK_PLAYER_INF("audio Program %d'th cas_id: 0x%04x\n", index, PMTprogramInfo.other_pids[i].cas_id[index]);
					RTK_PLAYER_INF("audio Program %d'th ecm pid: 0x%04x\n", index, PMTprogramInfo.other_pids[i].ca_pid[index]);                        
				}
			}

                    	RTK_PLAYER_INF("=============== Subtilte===============\n");

			for (i = 0; i < PMTprogramInfo.num_subtitle_pids; i++)
			{
				RTK_PLAYER_INF("Program %d'th num_subtitle_pids : 0x%04x\n", i, PMTprogramInfo.subtitle_pids[i].pid);
				
			}
			RTK_PLAYER_INF("***********************************************************\n");

			//-------------------------------------------------------------------------
			//	callback program info
			//-------------------------------------------------------------------------
			PMTprogramInfo.map_pid = m_programInfo.psi_program[program_index].map_pid;//add by yunlong_ma,map_pid will be covered.
			m_programInfo.psi_program[program_index] = PMTprogramInfo;
			m_programInfo.psi_program[program_index].received = true;

			// update record
			if( m_status == RTKPLAYER_STATUS_RUN &&
				program_index == m_channelIndex &&
				( m_arch == ARCH_DEMUX || m_arch == ARCH_DEMUX_AND_PLAY ) )
			{
				xUpdateRecordProgram(PMTprogramInfo);
			}

			if(!m_isMonitorPSI)//not has PMT.
			{
				//got pmt,  remove pmt sectionfilter
				RT_PlayerNotify(RTK_PLAYER_SECTION_PMT, &m_programInfo);
				xRemovePMT(handle);
				
				m_receivedProgramCount++;

				RTK_PLAYER_INF("[%s:%d]m_receivedProgramCount:%d, m_programInfo.program_cnt:%d \n",__FUNCTION__,__LINE__,m_receivedProgramCount,m_programInfo.program_cnt);
				if(m_receivedProgramCount == 1){	
					m_waitPMTStop = false;
					pthread_create(&waitPMTThread, NULL,ThreadWaitPMTEntry,(void*)this);
				}	

				if(m_receivedProgramCount == m_programInfo.program_cnt)//got all pmt tables.
				{
					m_receivedFullScanProCount += m_programInfo.program_cnt ;
					RTK_PLAYER_INF("[%s:%d]m_receivedFullScanProCount:%d, \n",__FUNCTION__,__LINE__,m_receivedFullScanProCount);
					int channelIndex = 0;
					int idx;
					for (idx = 0; idx < m_programInfo.program_cnt; idx++)
					{
						if(((m_demuxConfig.audio.pid == m_programInfo.psi_program[idx].audio_pids[m_audioIndex].pid) &&
							 (m_demuxConfig.audio.codec == _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[idx].audio_pids[m_audioIndex].codec)))
						  ||((m_demuxConfig.video.pid == m_programInfo.psi_program[idx].video_pids[0].pid) &&
							 (m_demuxConfig.video.codec == _xTS_Transfer_Video_Codec(m_programInfo.psi_program[idx].video_pids[0].codec))))
						{
							RTK_PLAYER_INF("m_playingProgramNum existed in pat.\n");
							channelIndex = idx;
							m_playProgramNum = m_programInfo.psi_program[channelIndex].program_number;
							break;
						}
					}
					if(idx > m_programInfo.program_cnt)
					{
						RTK_PLAYER_INF("play the first pn.\n");
						m_playProgramNum = m_programInfo.psi_program[0].program_number;
						channelIndex = 0;
					}
					
					
					// set AV pid .
					if(m_updateinfoflag == 1)
						xChangeAvParm(channelIndex);

// For some use case, there are more than two pid need AES ECB decrambler.
// So mark this and shold modify with following patch
// http://dhc.sdlc.rd.realtek.com/gerrit/#/c/realtek/dvdplayer-system/+/108312/

					int j=m_fullscanInfo.program_cnt;
					for(int i=0 ;i< m_receivedProgramCount; i++)
					{
						// comment add by:DHC YZX
						/*
						m_fullscanInfo.program_freq[i+j]=m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32frequency;
						m_fullscanInfo.psi_program[i+j].program_number = m_programInfo.psi_program[i].program_number;
						m_fullscanInfo.psi_program[i+j].video_pids[0].pid = m_programInfo.psi_program[i].video_pids[0].pid;
						m_fullscanInfo.psi_program[i+j].audio_pids[0].pid = m_programInfo.psi_program[i].audio_pids[0].pid;
						m_fullscanInfo.psi_program[i+j].isEncrypt = m_programInfo.psi_program[i].isEncrypt;
						m_fullscanInfo.program_cnt = m_receivedFullScanProCount;
						*/
						// copy full data to m_fullscanInfo.  add by:DHC YZX
						m_fullscanInfo.program_bw[i+j]=m_demuxConfig.input.tuner.bandwidth;
						m_fullscanInfo.program_freq[i+j]=m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32frequency;
						m_fullscanInfo.program_rate[i+j] = m_demuxConfig.input.tuner.tnr_param.dvb_c_param.u32symbol_rate;
						m_fullscanInfo.program_lnb_or_qam[i+j] =  m_demuxConfig.input.tuner.tnr_param.dvb_c_param.modulation;
						memcpy(&m_fullscanInfo.psi_program[i+j], &m_programInfo.psi_program[i], sizeof(TS_PSI_Program));
						m_fullscanInfo.program_cnt = m_receivedFullScanProCount;
					}
					if(m_updateinfoflag == 1)
					{
						RT_PlayerNotify(RTK_PLAYER_SECTION_PROGRAMINFO, &m_fullscanInfo);									
						RTK_PLAYER_INF("[%s:%d] call apk to show programlist m_updateinfoflag %d \n",__FUNCTION__,__LINE__,m_updateinfoflag);
					}
					if(m_saveurlflag >=0 )
					{
						RTK_PLAYER_INF("[%s:%d] update channel list\n",__FUNCTION__,__LINE__);
						update_channellist();
					}
				}

			}

			if(m_isMonitorPSI)//already has PMT, change PMTInfo when PMT changed.
			{
				bool ecm_pid_from_loop1 = false;
				bool ecm_pid_from_loop2 = false;

				RTK_Player playerHandle = m_demux;
				
				if(m_arch == ARCH_DEMUX_AND_PLAY)
				{
					playerHandle = m_player;
				}
				else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
				{
					playerHandle = m_demux;
				}

				if(m_demuxConfig.video.pid != PMTprogramInfo.video_pids[0].pid)
				{
					m_playerConfig.video.pid = m_demuxConfig.video.pid = PMTprogramInfo.video_pids[0].pid;
					m_playerConfig.video.codec = m_demuxConfig.video.codec = _xTS_Transfer_Video_Codec(PMTprogramInfo.video_pids[0].codec);
					if(RTK_Player_ChangeVideo(playerHandle, &m_demuxConfig.video) != RTK_OK)
					{
						RTK_PLAYER_ERR("Failed to change video.\n");
					}
				}

				// audio count may change and index may larger than it => switch to 1st audio
				if( m_audioIndex >= PMTprogramInfo.num_audio_pids ) m_audioIndex = 0;

				if((m_demuxConfig.audio.pid != PMTprogramInfo.audio_pids[m_audioIndex].pid)
					||(m_demuxConfig.audio.codec != _xTS_Transfer_Audio_Codec(PMTprogramInfo.audio_pids[m_audioIndex].codec)))
				{
					m_playerConfig.audio.pid = m_demuxConfig.audio.pid = PMTprogramInfo.audio_pids[m_audioIndex].pid;
					m_playerConfig.audio.codec= m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(PMTprogramInfo.audio_pids[m_audioIndex].codec);
					if(RTK_Player_ChangeAudio(playerHandle, &m_demuxConfig.audio) != RTK_OK)
					{
						RTK_PLAYER_ERR("Failed to change audio.\n");
					}
				}


				/*if((m_demuxConfig.subtitle.pid != PMTprogramInfo.subtitle_pids[0].pid)&&(PMTprogramInfo.subtitle_pids[0].pid != 0))
				{
					//change Subtitle pid
					m_playerConfig.subtitle.pid = m_demuxConfig.subtitle.pid = PMTprogramInfo.subtitle_pids[0].pid;
					m_playerConfig.subtitle.bshow =m_demuxConfig.subtitle.bshow=true;
					m_playerConfig.subtitle.langcode = m_demuxConfig.subtitle.langcode=PMTprogramInfo.subtitle_pids[0].langcode;
					m_playerConfig.subtitle.subtype = m_demuxConfig.subtitle.subtype = RTKTYPE_DVB_SUBTITLE;

					if(RTK_Player_SetSubtitle(playerHandle,m_demuxConfig.subtitle) != RTK_OK)
					{
						RTK_PLAYER_ERR("Failed to change subtitle.\n");
					}
	                			
	                		}*/

				uint16_t cas_id = 0xffff;
				uint16_t ecm_pid = 0xffff;


				RTK_PLAYER_INF("[%s:%d]current CA system ID:0x%04x ",__func__,__LINE__,cas_id);

				for(int index = 0;index < PMTprogramInfo.CasIDCount;index++)
				{
					if(cas_id == PMTprogramInfo.cas_id[index])
					{
						ecm_pid = PMTprogramInfo.ca_pid[index];
						ecm_pid_from_loop1 = true;    

						m_demuxConfig.descrambler.pmtInfo.pawEcmPid[0] = ecm_pid;
						m_demuxConfig.descrambler.pmtInfo.pawEcmPid[1] = ecm_pid;  
						m_demuxConfig.descrambler.pmtInfo.index = 2; 
						m_demuxConfig.descrambler.pmtInfo.pawStreamPid[0] = PMTprogramInfo.video_pids[0].pid;
						m_demuxConfig.descrambler.pmtInfo.pawStreamPid[1] = PMTprogramInfo.audio_pids[0].pid;

						break;
					}
				}


				if(false ==  ecm_pid_from_loop1)
				{
					m_demuxConfig.descrambler.pmtInfo.index = 0;     
					for(int index = 0;index < PMTprogramInfo.video_pids[0].CasIDCount;index++)
					{
						if(cas_id == PMTprogramInfo.video_pids[0].cas_id[index])
						{
							ecm_pid = PMTprogramInfo.video_pids[0].ca_pid[index];
							ecm_pid_from_loop2 = true;       
							m_demuxConfig.descrambler.pmtInfo.pawEcmPid[m_demuxConfig.descrambler.pmtInfo.index ] = ecm_pid;
							m_demuxConfig.descrambler.pmtInfo.pawStreamPid[m_demuxConfig.descrambler.pmtInfo.index ] = PMTprogramInfo.video_pids[0].pid;
							m_demuxConfig.descrambler.pmtInfo.index++; 
							break;
						}
					}  

					for(int index = 0;index < PMTprogramInfo.audio_pids[0].CasIDCount;index++)
					{
						if(cas_id == PMTprogramInfo.audio_pids[0].cas_id[index])
						{
							ecm_pid = PMTprogramInfo.audio_pids[0].ca_pid[index];
							ecm_pid_from_loop2 = true;       
							m_demuxConfig.descrambler.pmtInfo.pawEcmPid[m_demuxConfig.descrambler.pmtInfo.index ] = ecm_pid;
							m_demuxConfig.descrambler.pmtInfo.pawStreamPid[m_demuxConfig.descrambler.pmtInfo.index ] = PMTprogramInfo.audio_pids[0].pid;
							m_demuxConfig.descrambler.pmtInfo.index++; 

							break;
						}
					}  

					for(int index = 0;index < PMTprogramInfo.other_pids[0].CasIDCount;index++)
					{
						if(cas_id == PMTprogramInfo.other_pids[0].cas_id[index])
						{
							ecm_pid = PMTprogramInfo.other_pids[0].ca_pid[index];
							m_demuxConfig.descrambler.pmtInfo.pawEcmPid[m_demuxConfig.descrambler.pmtInfo.index ] = ecm_pid;
							m_demuxConfig.descrambler.pmtInfo.pawStreamPid[m_demuxConfig.descrambler.pmtInfo.index ] = PMTprogramInfo.other_pids[0].pid;
							m_demuxConfig.descrambler.pmtInfo.index++; 
							ecm_pid_from_loop2 = true;                                
							break;
						}
					} 
				}

				if((ecm_pid != 0xffff) && (m_demuxConfig.descrambler.pmtInfo.pawEcmPid[0] != ecm_pid))
				{
					m_demuxConfig.descrambler.pmtInfo.serviceId = m_playProgramNum;                

					/*
					m_demuxConfig.descrambler.pmtInfo.pawEcmPid[0] = ecm_pid;
					m_demuxConfig.descrambler.pmtInfo.pawEcmPid[1] = ecm_pid;
					m_demuxConfig.descrambler.pmtInfo.pawStreamPid[0] = m_demuxConfig.video.pid;
					m_demuxConfig.descrambler.pmtInfo.pawStreamPid[1] = m_demuxConfig.audio.pid;
					*/
				}
			}
		}
		else if (sectionData[0] == TS_PSI_TID_SDT) /* SDT */
		{
			//-------------------------------------------------------------------------
			//	Parse Header info from SDT table
			//-------------------------------------------------------------------------
			bzero(&SDTHeader, sizeof(SDTHeader));
			TS_SI_SDT_getSectionHeader((const unsigned char*)sectionData, &SDTHeader);

			if (m_prevSDTVersion == SDTHeader.version_number)
			{
				break;
			}
			else
			{
				RTK_PLAYER_INF("####new Received SDT #######,old SDTversion:0x%x,new SDTversion:0x%x\n",m_prevSDTVersion,SDTHeader.version_number);
				m_prevSDTVersion = SDTHeader.version_number;
			}

			TS_SI_parseSDT((const uint8_t *)sectionData, sectionLen, &m_programInfo);

			if(!m_isMonitorPSI)//not has sdt.
			{
				//got sdt,  remove sdt sectionfilter
				RT_PlayerNotify(RTK_PLAYER_SECTION_SDT, &m_programInfo);

				if (RTK_Player_RemoveSectionFilter(m_demux, handle) != RTK_OK)
				{
					RTK_PLAYER_ERR("Failed to remove SDT section filter.\n");
				}						

			}

		}
		else if (((0x4f < sectionData[0])&&(sectionData[0] < 0x60))||(sectionData[0] == 0x4e)) /* EIT */
		 {
			RTK_PLAYER_INF("EIT sectionData[0] = 0x%x \n" , sectionData[0]);
			if(m_isAddEPG){
				TS_SI_parseEIT((const uint8_t *)sectionData, sectionLen, &m_programInfo);
			}
		}
		else if(sectionData[0] == 0x70)
		{
			time_t	utcTime;
			TS_TDT_GetTimeInSI((unsigned char*)sectionData,sectionLen,&utcTime);
			nowTime = utcTime;
			if(nowTime != 0)
			{
				xRemoveTDT();
			}
		}
		else
		{
			RTK_PLAYER_ERR("Can not parse table id! TID = %d\n", sectionData[0]);
		}
	}while(0);
	return ;
}


void RTKPlayer::SectionCallbackEntry(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	RTKPlayer* pThis = (RTKPlayer*)userParam;
	UNUSED(enStatus);
	
	pThis->SectionCallback(handle, section, length);
}

#define PID(p)            ( ( (((int)p[1]) & 0x1F) << 8 ) | p[2] )
#define CONTI_COUNT(p)    ( p[3] & 0x0F )
#define HAS_PCR(p)        ( ( p[5] & 0x10 ) != 0 )
#define PCR(p)            ( (((int64_t)p[6]) << 25) | (((int)p[7]) << 17) | (((int)p[8]) << 9) | (((int)p[9]) << 1) | ((p[10]>>7) & 0x1) )
#define HAS_AF(p)         ( ( p[3] & 0x20 ) != 0 )
#define AF_LENGTH(p)      ( p[4] )

// check video/audio/PAT cc
// true: continue; false: cc discontinue
bool RTKPlayer::xCheckCC(RTK_TSInputBuffer *buffer)
{
	char* p = (char*)buffer->memory;
	char* p_end = ((char*) buffer->memory+buffer->filled_size);
	bool ret = true;

	while(p < p_end)
	{
		if(PID(p) == 0) // PAT
		{
			if( m_last_PAT_cc != -1 && ((m_last_PAT_cc+1)&0xF) != CONTI_COUNT(p))
			{
				//RTK_PLAYER_ERR("xCheckCC PAT discontinue pred=%d actual=%d\n", (m_last_PAT_cc+1)&0xF, CONTI_COUNT(p));
				ret = false;
			}
			m_last_PAT_cc = CONTI_COUNT(p);
		}
		else if(PID(p) == m_demuxConfig.video.pid)
		{
			if( m_last_video_cc != -1 && ((m_last_video_cc+1)&0xF) != CONTI_COUNT(p))
			{
				//RTK_PLAYER_ERR("xCheckCC video discontinue pred=%d actual=%d\n", (m_last_video_cc+1)&0xF, CONTI_COUNT(p));
				ret = false;
			}
			m_last_video_cc = CONTI_COUNT(p);
		}
		else if(PID(p) == m_demuxConfig.audio.pid)
		{
			if( m_last_audio_cc != -1 && ((m_last_audio_cc+1)&0xF) != CONTI_COUNT(p))
			{
				//RTK_PLAYER_ERR("xCheckCC audio discontinue pred=%d actual=%d\n", (m_last_audio_cc+1)&0xF, CONTI_COUNT(p));
				ret = false;
			}
			m_last_audio_cc = CONTI_COUNT(p);
		}

		p += 188;
	}
	return ret;
}

bool RTKPlayer::xCheckPCR(RTK_TSInputBuffer *buffer)
{
	char* p = (char*)buffer->memory;
	char* p_end = ((char*) buffer->memory+buffer->filled_size);
	bool ret = true;

	if(m_searchDiscontinue == 1)
	{
		RTK_PLAYER_INF("xCheckPCR m_demux=%p", m_demux);
	}

	while(p < p_end)
	{
		long long new_pcr = -1;
		if( HAS_AF(p) && AF_LENGTH(p) >= 7 && HAS_PCR(p) )
		{
			new_pcr = PCR(p);
			if(m_last_pcr != -1)
			{
				if( (new_pcr > m_last_pcr) && (new_pcr - m_last_pcr > 90000*10) )
				{
					RTK_PLAYER_ERR("xCheckPCR PCR gap old:%lld new:%lld %lldms\n", m_last_pcr, new_pcr, (new_pcr - m_last_pcr)/90);
				}
				else if( new_pcr < m_last_pcr )
				{
					RTK_PLAYER_ERR("xCheckPCR PCR gap back old:%lld new:%lld %lldms\n", m_last_pcr, new_pcr, (m_last_pcr -new_pcr)/90);
				}
			}
			m_last_pcr = new_pcr;
		}
		p += 188;
	}
	return ret;
}


void* RTKPlayer::ThreadProcDemuxFeed()
{
	FILE * file=NULL;
	RTK_SOCKET_t rtk_socket;
	UDPReceiver* pUdpReceiver = NULL;
	TCPReceiver* pTcpReceiver = NULL;
	int retryCounter = SOURCE_RETRY_COUNTER;
	int searchDiscontinue_retry = 0;
	#ifdef USE_RTK_EXTRACTOR
	HttpIOPluginProxy* pHttpProxyReceiver =NULL;
	#endif
	UINT32_T read_size = READ_DATA_MAXMUN_SIZE;
	int32_t ret_size;
	RTK_TSInputBuffer buffer;
	RTK_Bool got_eof = RTK_FALSE;
	char idx_source[256];
	FeedDataInfo cur_I;
	std::vector<IFrameElement> IFrameList;
	bool isContinue = true;
	bool IsLast = RTK_FALSE;
	memset(&cur_I, 0, sizeof(FeedDataInfo));

	feed_debug_init();

	buffer.isLast = RTK_FALSE;
	m_sourceFeedPauseFlag = RTK_FALSE;
	if( m_InputType == RTKPLAYER_INPUT_FILE)
	{        RTK_PLAYER_ERR(" input file !!!\n");
		if(m_demuxConfig.input.memory.filePath == NULL)
		{
			RTK_PLAYER_ERR(" input file null!!!\n");
			return NULL;
		}
		//RTK_PLAYER_INF(" inputFile=%s\n", m_demuxConfig.input.memory.filePath);
		file = fopen(m_demuxConfig.input.memory.filePath, "rb");
		if(file == NULL)
		{
			RTK_PLAYER_ERR(" open input file error, filePath=%s!!!\n", m_demuxConfig.input.memory.filePath);
			return NULL;
		}
		else
		{
			s_PvrTsFile = file;
			RTK_PLAYER_INF(" open input file success, filePath=%s!!!\n", m_demuxConfig.input.memory.filePath);
		}

		do{
			strncpy(idx_source, m_demuxConfig.input.memory.filePath, sizeof(idx_source));
			m_recordingIdx_Rd = fopen(strcat(idx_source, "_idx.dat"), "rb");
			if(m_recordingIdx_Rd == NULL)
			{
				RTK_PLAYER_ERR("%s %d: open idx file error, filePath=%s!!!\n", __FUNCTION__, __LINE__ , idx_source);
				break;
			}

			m_IdxDataSupport = true;

			// collect all I frames into a list from idx.dat
			memset(&cur_I, 0, sizeof(FeedDataInfo));
			xExtractIFrameInfo(&IFrameList, &cur_I);

			// initializing I data info for trick-playing use
			m_LeftDataWaitToSend = false;
			cur_I.cur_it  = IFrameList.begin();
			cur_I.cur_rit = IFrameList.rbegin();
		}while(0);
	}
	else if(m_InputType == RTKPLAYER_INPUT_IPTV)
	{
		//set socket param
		#define BUFFER_SIZE   (32 * 1024)
		rtk_socket.e_socket_type = m_demuxConfig.input.iptv.e_socket_type;
		memcpy(rtk_socket.iStrIP, m_demuxConfig.input.iptv.iStrIP, sizeof(m_demuxConfig.input.iptv.iStrIP));
		rtk_socket.iPort = m_demuxConfig.input.iptv.iPort;
		RTK_PLAYER_INF("IPTV[%d][%s]\n",m_demuxConfig.input.iptv.iPort, m_demuxConfig.input.iptv.iStrIP);

		INT8_T socketRet = RTK_ERR;
		if(rtk_socket.e_socket_type == RTK_UDP_SOCKET)	
		{
			if(m_pSource)
				pUdpReceiver = (UDPReceiver*)m_pSource;
			else
			{
				pUdpReceiver = new UDPReceiver();
				if(pUdpReceiver == NULL)
				{
					return NULL;
				}
				socketRet = pUdpReceiver->Open(rtk_socket.iPort, (const char*)rtk_socket.iStrIP);
				if(socketRet != RTK_OK)
				{
					RTK_PLAYER_ERR(" udp open fail!!!\n");
                                     if(pUdpReceiver != NULL)
                                     {
                                               delete(pUdpReceiver);
                                               pUdpReceiver = NULL;
                                     }

					return NULL;
				}
			}
			RTK_PLAYER_INF(" udp open success!!!\n");
		}
		else if(rtk_socket.e_socket_type == RTK_TCP_SOCKET)
		{
			pTcpReceiver = new TCPReceiver();
			if(pTcpReceiver == NULL)
			{
				return NULL;
			}
			socketRet = pTcpReceiver->Open(rtk_socket.iPort);
			if(socketRet != RTK_OK)
			{
				delete pTcpReceiver;
				RTK_PLAYER_ERR(" tcp open fail!!!\n");
				return NULL;
			}
			RTK_PLAYER_INF(" tcp open success!!!\n");
		}
		#ifdef USE_RTK_EXTRACTOR
		else if(rtk_socket.e_socket_type == RTK_HTTP_SOCKET)	
		{
		       pHttpProxyReceiver = new HttpIOPluginProxy();
		       if(pHttpProxyReceiver == NULL)
			{
				return NULL;
			}
			memcpy(rtk_socket.iStrHttp, m_demuxConfig.input.iptv.iStrHttp, sizeof(m_demuxConfig.input.iptv.iStrHttp));
			RTK_PLAYER_INF(" http io path = %s \n" ,rtk_socket.iStrHttp );
		       socketRet = pHttpProxyReceiver->open(rtk_socket.iStrHttp , 0);
			if(socketRet != RTK_OK)
			{
				RTK_PLAYER_ERR(" http open fail!!!\n");
				return NULL;
			}
			RTK_PLAYER_INF(" http open success!!!\n");
		}
		#endif
	}
	else
	{
		RTK_PLAYER_ERR(" [%s] input type error!!!\n", __FUNCTION__);
		return NULL;
	}

	//START_ERRORCONCEAL(m_demux);

	while(1)
	{
		if(m_demuxFeedStop == RTK_TRUE)
		{
			break;
		}

		if(m_dropFlag == 1)
		{
			RTK_PLAYER_ERR("%s RTK_Player_DropData\n",__FUNCTION__);
			RTK_Player_DropData(m_demux);
			m_dropFlag = 0;
		}

		if(m_SeekFlag == RTK_TRUE)
		{
			if( m_InputType == RTKPLAYER_INPUT_FILE )
			{
				if(m_seekOffset > 0) m_seekOffset = (m_seekOffset/MTP_BUFFER_ALIGNMENT)*MTP_BUFFER_ALIGNMENT; // alignment for block decrypt
				fseek(file, m_seekOffset, SEEK_SET);
			}
			
			cur_I.cur_rit = IFrameList.rbegin();
			cur_I.cur_it = IFrameList.begin();
			
			got_eof = RTK_FALSE;
			m_SeekFlag = RTK_FALSE;
			IsLast = RTK_TRUE;
		}

		if(m_playerPauseFlag == RTK_TRUE)
		{
			m_sourceFeedPauseFlag = RTK_TRUE;
			usleep(10*1000);	//	10ms.
			continue;
		}
		m_sourceFeedPauseFlag = RTK_FALSE;

	  char   err = RTK_Fail;
		//get dma buffer.
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
		
			err = RTK_Source_GetInputBuffer(m_source, &buffer);
	
#else //get dma buffer.
			err = RTK_Player_GetInputBuffer(m_demux, &buffer);
#endif
RTK_PLAYER_INF("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		switch(err)
		{
			case RTK_OK:
				read_size = (buffer.size > READ_DATA_MAXMUN_SIZE)? READ_DATA_MAXMUN_SIZE : buffer.size;
				feed_debug_read(buffer.size);
				if( m_InputType == RTKPLAYER_INPUT_FILE )
				{			
					uint32_t file_size, curr_pos;
					struct stat fileStat;

					buffer.filled_size = 0;
					buffer.isLast = RTK_FALSE;

					fstat(fileno(file), &fileStat);
					file_size = fileStat.st_size;
					
					//curr_pos = ftell (file);
					curr_pos = ftello(file);					
						
					cur_I.currentFilePosition = curr_pos;
					cur_I.buffer_size = read_size;

					if(m_IdxDataSupport)
					{
						//xExtractIFrameInfo(&IFrameList, &cur_I);
					}

					if ((file_size -ftello(file))  >= 188)
					{
					    if( file_size - curr_pos <=  read_size)
					    	{
						 read_size = file_size - curr_pos;						 
						 cur_I.buffer_size = read_size;
					    	}

						
						if(RTK_TRICKPLAY_STEP_BY_IFRAME == m_trickPlaying)
						{
							// display the I frame only
							if(xTraverseIFrame(file, &IFrameList, &cur_I, &buffer)!=RTK_OK)
							{
								if(! cur_I.end_of_IFrame)
								{
									// trick-play fail befor reaching the end of I frame list
									RTK_PLAYER_ERR("xTraverseIFrame fail\n");
								}
							}
						}
						else if(RTK_TRICKPLAY_STEP_BY_VOBU == m_trickPlaying)
						{
							//TODO:
							//implement new API   							
							buffer.filled_size = xReadNextScanningStep(file, read_size, &buffer);							
						}
						else
						{
						   if(m_demuxConfig.input.isEncrypt == RTK_TRUE)												
							 buffer.filled_size = fread(buffer.memory, 1, read_size, file);						        
						  else if(m_demuxConfig.input.isEncrypt == RTK_FALSE){
						  	unsigned char *data = (unsigned char*)buffer.memory;
							unsigned int cnt =0;	bool  flag = 1;						
							read_size = read_size -read_size%188;	
							RTK_PLAYER_ERR("llldebug size=%d\n",read_size);
							while(cnt < read_size && flag ==1){
								if((file_size -ftello(file)) /188 >= 2)
								{
									fread(data, 1, 189, file);
							              if(data[0] == 0x47 && data[188] == 0x47)
									{
							 			cnt += 188;
										data += 188;
										fseek(file,ftello(file)-1,SEEK_SET);
							               }
									else									
									 	fseek(file,ftello(file)-188,SEEK_SET);	
								}
								else if((file_size -ftello(file)) >= 188 && (file_size -ftello(file)) < 188*2)
								{
									fread(data, 1, 1, file);
								    if(data[0] == 0x47 && file_size - ftello(file) >=187)
									{
									fread(data+1, 1, 187, file);
									cnt += 188;
									data +=188;
								    	}
								else if(data[0] == 0x47 && file_size - ftello(file) < 187)
									flag = 0;	
								}
								else if(file_size -ftello(file) < 188)							
									flag = 0;										 
							  	}
							buffer.filled_size = cnt;							
							 }
									
						    }
					  }						

					if ((feof(file) ||(file_size -ftello(file)) <188))
					{
						if(m_LoopFeedEnable==false)
						{
							if(IsLast)
							{
								buffer.isLast = RTK_TRUE;
							}
							if(got_eof == RTK_FALSE)
							{
								RTK_PLAYER_INF("%s isLast filled_size=%d\n",__FUNCTION__,buffer.filled_size);
								got_eof = RTK_TRUE;
							}
							
							fseek(file, 0, SEEK_END); //back to the head of file
						}

						//if(buffer.filled_size > 0)
						//{
 							//buffer.filled_size = buffer.filled_size / MTP_BUFFER_ALIGNMENT *MTP_BUFFER_ALIGNMENT;
						//}

						if(m_LoopFeedEnable==true)
							fseek(file, 0, SEEK_SET); //back to the head of file
					}
				}
				else if(m_InputType == RTKPLAYER_INPUT_IPTV)
				{
					//	read ts data from network socket.
					if(rtk_socket.e_socket_type == RTK_UDP_SOCKET)	
					{
						ret_size = pUdpReceiver->Read((char*)buffer.memory, read_size);

						if(ret_size <= 0)
						{
							retryCounter--;
							if(retryCounter == 0)
							{
								RTK_PLAYER_ERR("[%s][%d]UdpReceive Read error %d \n",__FUNCTION__,__LINE__, ret_size);
								RT_PlayerNotify(RTK_PLAYER_UDP_TIMEOUT, NULL);
								retryCounter = SOURCE_RETRY_COUNTER;
							}
							buffer.filled_size = 0;
						}
						else
						{
							retryCounter = SOURCE_RETRY_COUNTER;
							buffer.filled_size = ret_size;

							isContinue = xCheckCC(&buffer);
							if(m_searchDiscontinue == 1)
							{
								if( !isContinue || searchDiscontinue_retry > SOURCE_RETRY_COUNTER)
								{
									RTK_PLAYER_INF("%s set m_dropFlag = 1 %d\n", __FUNCTION__, searchDiscontinue_retry);
									buffer.filled_size = 0;
									m_dropFlag = 1;
									m_searchDiscontinue = 0;
									searchDiscontinue_retry = 0;
								}
								else
								{
									searchDiscontinue_retry++;
								}
							}
							if( !isContinue && m_speed == 1.0 )
								RTK_PLAYER_WRN("%s CC discontinue happened\n",__FUNCTION__);
						}
					}
					else if(rtk_socket.e_socket_type == RTK_TCP_SOCKET)
					{
						ret_size = pTcpReceiver->Read((char*)buffer.memory, read_size);

						if(ret_size < 0)
						{
							RTK_PLAYER_ERR("[%s][%d]TcpReceiver Read error %d \n",__FUNCTION__,__LINE__, ret_size);
							buffer.filled_size = 0;
						}
						else
							buffer.filled_size = ret_size;
						
					}
					#ifdef USE_RTK_EXTRACTOR
					else if(rtk_socket.e_socket_type == RTK_HTTP_SOCKET)	
					{
						buffer.filled_size = pHttpProxyReceiver->read((unsigned char*)buffer.memory, read_size,NULL);
						RTK_PLAYER_INF("Demux::  buffer.filled_size=%d \n",buffer.filled_size);
					}
					#endif
				}

				//RTK_PLAYER_INF("(%p): buffer.memory=%p buffer.size=%d buffer.filled_size=%d\n",this, buffer.memory,buffer.size,buffer.filled_size);

				feed_debug_feed(buffer.filled_size);
				if(buffer.filled_size > 0)
				{
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
					err = RTK_Source_FeedInputBuffer(m_source, &buffer);
#else
					err = RTK_Player_FeedInputBuffer(m_demux, &buffer);
#endif
#ifdef DUMP_FEED
					if(m_DumpFd!=NULL)
					{
						if(fwrite(buffer.memory, buffer.filled_size, 1, m_DumpFd)!=1)
						{
							RTK_PLAYER_ERR("[DUMP]%d: Write dump file error!!",__LINE__);
						}
					}
#endif
					if( err == RTK_OK)
					{
						feed_debug_first_update();
#ifndef CLIENT_DTVSOURCE
			
					    	RTK_Player_DiscardInputBuffer(m_demux, &buffer);
#endif
					}
					else
					{
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
					
							RTK_Source_DiscardInputBuffer(m_source, &buffer);
						
#else
						RTK_Player_DiscardInputBuffer(m_demux, &buffer);
#endif					
					}
				}
				else
				{
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
				
							RTK_Source_DiscardInputBuffer(m_source, &buffer);
					
#else
						RTK_Player_DiscardInputBuffer(m_demux, &buffer);
#endif
				}
				usleep(500); // sleep 0.5 ms
				break;
			default:
				usleep(10*1000); // sleep 10 ms when full
				break;
		}
		rtk_store_system_cmd(RTK_DEMUX_FEED_SIZE,RTK_SYSTEM_TYPE_INT,&buffer.filled_size);

		if( m_InputType != RTKPLAYER_INPUT_FILE )
		{
			//CHECK_TIMEOUT_ERRORCONCEAL(m_demux);
		}
	}

	//STOP_ERRORCONCEAL(m_demux);

	if(pUdpReceiver != NULL)
	{
		pUdpReceiver->Close();
		delete(pUdpReceiver);
		pUdpReceiver = NULL;
		m_pSource = NULL;
	}
	if(pTcpReceiver != NULL)
	{
		pTcpReceiver->Close();
		delete(pTcpReceiver);
		pTcpReceiver = NULL;
	}
	#ifdef USE_RTK_EXTRACTOR
	if(pHttpProxyReceiver != NULL)
	{
		pHttpProxyReceiver->Close();
		delete(pHttpProxyReceiver);
		pHttpProxyReceiver = NULL;
	}
	#endif

	return NULL;
}

void* RTKPlayer::ThreadProcDemuxFeedEntry(void* pInstance)
{
	RTKPlayer* pThis = (RTKPlayer*)pInstance;

	pThis->ThreadProcDemuxFeed();

	return NULL;

}

void* RTKPlayer::ThreadProcPlayFeed()
{
	 
	RTK_TSInputBuffer buffer;

	unsigned int inAvailableSize=0;


	m_replaySwitch=m_playerInputSource;

	feed_debug_init();

	while(1)
	{
		
		
		if(m_playerFeedStop == RTK_TRUE)
		{
			break;
		}

		if(m_playerPauseFlag == RTK_TRUE)
		{
			if(m_playerPausePoint==0)
			{
				m_playerPausePoint = (long)m_dataSendOffset;
				RTK_PLAYER_INF("m_playerPausePoint =%ld\n", m_playerPausePoint);
			}
			usleep(10*1000);
			continue;
		}


		//get dma buffer.
		char err = RTK_Player_GetInputBuffer(m_player, &buffer);

		switch(err)
		{
			case RTK_OK:
				
				buffer.size = buffer.size / MTP_BUFFER_ALIGNMENT *MTP_BUFFER_ALIGNMENT;//for cached memory.
				if(buffer.size == 0)
				{
					RTK_Player_DiscardInputBuffer(m_player, &buffer);
					usleep(10*1000); // sleep 10 ms when full
					break;
				}

				//read ts data from file or memory.
				feed_debug_read(buffer.size);
				if(m_replaySwitch!=m_playerInputSource)
				{
					m_playerInputSource=m_replaySwitch;
				}
				
				if(m_playerInputSource==PLAY_FROM_MEM)
				{
					if(m_dataStoreMemory.wr!=m_dataStoreMemory.rd)
					{
						if(m_dataStoreMemory.wr > m_dataStoreMemory.rd)
						{
							inAvailableSize=m_dataStoreMemory.wr-m_dataStoreMemory.rd;
						}
						else
						{
							inAvailableSize=STORE_BUFFER_SIZE-m_dataStoreMemory.rd;
						}

						buffer.filled_size = (buffer.size<=inAvailableSize?buffer.size:inAvailableSize);
						buffer.filled_size = buffer.filled_size / MTP_BUFFER_ALIGNMENT *MTP_BUFFER_ALIGNMENT;
						buffer.isLast= RTK_FALSE;
						memcpy(buffer.memory, m_dataStoreMemory.pBufferVirAddr+m_dataStoreMemory.rd, buffer.filled_size);
					}
					else
					{
						inAvailableSize=0;
						usleep(10*1000);
						break;
					}

					unsigned int rd=m_dataStoreMemory.rd;
					rd+=buffer.filled_size;
					rd=(rd>=STORE_BUFFER_SIZE)?0:rd;
					m_dataStoreMemory.rd=rd;

					
				}
				else //if(m_playerInputSource==PLAY_FROM_FILE)
				{
					//	read ts data from file.
					
					buffer.filled_size =  xReadDataFromFile((void *)m_TSDataFile, (unsigned char *)buffer.memory, buffer.size);
					buffer.filled_size = buffer.filled_size / MTP_BUFFER_ALIGNMENT *MTP_BUFFER_ALIGNMENT;

					buffer.isLast= RTK_FALSE;
					m_dataSendOffset+=buffer.filled_size;
				}

				feed_debug_feed(buffer.filled_size);
				if(buffer.filled_size > 0)
				{
					err = RTK_Player_FeedInputBuffer(m_player, &buffer);
					if( err == RTK_OK) feed_debug_first_update();
				}
				RTK_Player_DiscardInputBuffer(m_player, &buffer);
				usleep(2*1000);	// sleep 2 ms
				break;
			default:
				usleep(10*1000);	// sleep 10 ms when full
				break;
		}
		
			
	}

	
	return NULL;
}

void* RTKPlayer::ThreadProcPlayFeedEntry(void* pInstance)
{
	RTKPlayer* pThis = (RTKPlayer*)pInstance;

	pThis->ThreadProcPlayFeed();

	return NULL;

}

void RTKPlayer::xCopyToDataStoreMemory(char *pData, uint32_t dataSize)
{
	unsigned int FreeSize = 0;
	unsigned int store_memory_rd = 0, store_memory_wr = 0;

	if (dataSize == 0)
	{
		return;
	}

	store_memory_wr = m_dataStoreMemory.wr;
	
	while(1)
	{
		if(m_dataStoreMemory.pBufferVirAddr == NULL)
		{
			return;
		}
		
		store_memory_rd = m_dataStoreMemory.rd;
		FreeSize = (store_memory_wr >= store_memory_rd)?(STORE_BUFFER_SIZE-store_memory_wr+store_memory_rd):(store_memory_rd-store_memory_wr);

		if (FreeSize >= dataSize)
		{
			if((store_memory_wr + dataSize) < STORE_BUFFER_SIZE)
			{
				memcpy(m_dataStoreMemory.pBufferVirAddr+ store_memory_wr, pData, dataSize);
				m_dataStoreMemory.wr = (store_memory_wr + dataSize);
			}
			else
			{
				memcpy(m_dataStoreMemory.pBufferVirAddr+ store_memory_wr, pData, (STORE_BUFFER_SIZE - store_memory_wr));
				memcpy(m_dataStoreMemory.pBufferVirAddr, (pData+(STORE_BUFFER_SIZE - store_memory_wr)), (dataSize-(STORE_BUFFER_SIZE - store_memory_wr)));
				m_dataStoreMemory.wr = (dataSize-(STORE_BUFFER_SIZE - store_memory_wr));
			}
		
			//save data to file.
			if(m_replaySwitch == PLAY_FROM_FILE)
			{
				_xSetFileBusyFlag((int)m_TSDataFile, m_demuxFilePoint);

				fseek(m_TSDataFile, m_demuxFilePoint, SEEK_SET);
				if((store_memory_wr + dataSize)<STORE_BUFFER_SIZE)
				{
					fwrite(m_dataStoreMemory.pBufferVirAddr+ store_memory_wr, dataSize, 1, m_TSDataFile);
				}
				else
				{
					fwrite(m_dataStoreMemory.pBufferVirAddr+ store_memory_wr, (STORE_BUFFER_SIZE - store_memory_wr), 1, m_TSDataFile);
					dataSize -= (STORE_BUFFER_SIZE - store_memory_wr);
					fwrite(m_dataStoreMemory.pBufferVirAddr, dataSize, 1, m_TSDataFile);
				}
				
				m_demuxFilePoint = ftell(m_TSDataFile);

				_xClearFileBusyFlag((int)m_TSDataFile);
			
				if(m_demuxFilePoint >= MAX_FILE_SIZE)
				{
					m_demuxFilePoint = 0;
				}
			}
			break;
		}
		else
		{
			usleep(1*1000);
		}
	}
}

#ifdef ENABLE_VO_SEND_FRAME
void RTKPlayer::RT_PlayerMultiview(const char* url1, const char *url2,  const char *url3)
{

	RTK_Player playerHandle = m_demux;
	uint8_t* multiviewBuffer = NULL;
	unsigned int avhandle = 0;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}
	
	CVpudecoder* decode1 = NULL;
	CVpudecoder* decode2 = NULL;
	CVpudecoder* decode3 = NULL;
		
	if(m_rtkffdecode1 == NULL)              
		m_rtkffdecode1 = new CVpudecoder(url1,NULL);

	if(m_rtkffdecode2 == NULL)
		m_rtkffdecode2 = new CVpudecoder(url2,NULL);

	if(m_rtkffdecode3 == NULL)
		m_rtkffdecode3 = new CVpudecoder(url3,NULL);

	decode1 = (CVpudecoder *)m_rtkffdecode1;
	decode2 = (CVpudecoder *)m_rtkffdecode2;
	decode3 = (CVpudecoder *)m_rtkffdecode3;

	RTK_Player_GetMultiviewBuffer(playerHandle, &multiviewBuffer,&avhandle);
	RTK_Player_SendFrameInit(playerHandle);
	decode1->SetFramebuffer(multiviewBuffer,avhandle);

	decode1->Initial();
	decode1->SetMergePosition(1);
	decode1->StartDecode();

	decode2->Initial();
	decode2->SetMergePosition(2);
	decode2->StartDecode();
	
	decode3->Initial();
	decode3->SetMergePosition(3);
	decode3->StartDecode();
	
}

void RTKPlayer::RT_PlayerGetMultiviewBuffer(uint8_t** ptr_buffer, unsigned int *avhandle)
{

	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	RTK_Player_GetMultiviewBuffer(playerHandle, ptr_buffer,avhandle);
	RTK_Player_SendFrameInit(playerHandle);
}

void RTKPlayer::RT_PlayerStopMultiview(void)
{
	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	CVpudecoder * decode1 =NULL;
	CVpudecoder * decode2 =NULL;
	CVpudecoder * decode3 =NULL;
	
	decode1 = (CVpudecoder *)m_rtkffdecode1;
	decode2 = (CVpudecoder *)m_rtkffdecode2;
	decode3 = (CVpudecoder *)m_rtkffdecode3;
	
	if(decode1)		
	{
		//decode1->UnInit();
		delete decode1;
		decode1 = NULL;
		RTK_PLAYER_INF("m_rtkffdecode1 byby success\n");
	}

	if(decode2)
	{
		//decode2->UnInit();
		delete decode2;
		decode2 = NULL;
		RTK_PLAYER_INF("m_rtkffdecode2 byby success\n");
	}

	if(decode3)
	{
		//decode3->UnInit();
		//decode3->ResetVO();
		delete decode3;
		decode3 = NULL;
		RTK_PLAYER_INF("m_rtkffdecode2 byby success\n");
	}

	RTK_Player_StopSendFrame(playerHandle);
}

#endif

/*RTK_Error RTKPlayer::RT_GetDemuxInfo(Hal_Demux_Info_t* DemuxInfo){
	RTK_Player playerHandle = m_demux;
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}
	return RTK_GetDemuxInfo(playerHandle,DemuxInfo);
}

RTK_Error RTKPlayer::RT_SetAudioFocus(RTK_Bool isFocus,uint16_t pid)
{
	RTK_Player playerHandle = m_demux;
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY)
	{
		playerHandle = m_demux;
	}
	
	RTK_Player_ChangeAudioFocus(playerHandle,isFocus, pid);
	
	return  RTK_OK;
}*/

RTK_Error RTKPlayer::RT_SetAudioMute(RTK_Bool isMute)
{
	RTK_Error ret = RTK_OK;
	RTK_Player playerHandle=m_demux;
	unsigned char tmp_status = m_MuteState;
    
	//background player no need this.
	if(m_isBackground==true)
            return RTK_Fail;
    
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle= m_demux;
	}

	if(isMute==RTK_TRUE)
		tmp_status |= MUTE_BY_USER;
	else
		tmp_status &= ~MUTE_BY_USER;

	ret = RTK_Player_SetAudioMute(playerHandle, (tmp_status==UNMUTE)? RTK_FALSE: RTK_TRUE );
	if(ret == RTK_OK)
		m_MuteState = tmp_status;

	return ret;
}

RTK_Error RTKPlayer::RT_GetAudioMute(RTK_Bool *isMute)
{
	RTK_Player playerHandle=m_demux;
    
	//background player no need this.
	if(m_isBackground==true)
            return RTK_Fail;
    
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle= m_demux;
	}
	return RTK_Player_GetAudioMute(playerHandle, isMute);
}

#ifdef RTKPLAYER_MINI_SI
char RTKPlayer::ParseChannelInfo(
	unsigned char *pStreamBuffer, 
	int streamBufferBytes, 
	TS_PSI_Program* tmpInfo,
	unsigned short *pmt_pid)
{
        char ret;
        RTK_PLAYER_INF("ParseChannelInfo streamBufferBytes=0x%x ", streamBufferBytes);
        ret=Parse_ChannelInfo(pStreamBuffer,streamBufferBytes,tmpInfo,pmt_pid);	
	return ret;

}


void* RTKPlayer::ThreadProcPreParsePMTEntry(void* pInstance)
{
        RTKPlayer* pThis = (RTKPlayer*)pInstance;
        pThis->ThreadProcPreParsePMT();
        return NULL;
}

void* RTKPlayer::ThreadProcPreParsePMT()
{
        int retryCounter = SOURCE_RETRY_COUNTER;
        RTK_SOCKET_t rtk_socket;
        UDPReceiver* pUdpReceiver = NULL;
        TCPReceiver* pTcpReceiver = NULL;
	 unsigned short pmtpid;
#ifdef USE_RTK_EXTRACTOR
        HttpIOPluginProxy* pHttpProxyReceiver =NULL;
#endif
        int ret_size;
	pmtpid = 0xffff;
        TS_PSI_Program channelinfo;
        m_readdatasize = 2*47*1024;
        if(pStreamBuffer == NULL)
            pStreamBuffer =(unsigned char *) malloc( sizeof(unsigned char )*200*1024);
        //set socket param
        rtk_socket.e_socket_type = m_demuxConfig.input.iptv.e_socket_type;
        memcpy(rtk_socket.iStrIP, m_demuxConfig.input.iptv.iStrIP, sizeof(m_demuxConfig.input.iptv.iStrIP));
        rtk_socket.iPort = m_demuxConfig.input.iptv.iPort;
        INT8_T socketRet = RTK_ERR;
        if(rtk_socket.e_socket_type == RTK_UDP_SOCKET)	
        {
            pUdpReceiver = new UDPReceiver();
            if(pUdpReceiver == NULL)
            {
                if(pStreamBuffer != NULL)
                    free(pStreamBuffer);
                return NULL;
            }
            m_pSource = (void*) pUdpReceiver;
            socketRet = pUdpReceiver->Open(rtk_socket.iPort, (const char*)rtk_socket.iStrIP);
            if(socketRet != RTK_OK)
            {
                RTK_PLAYER_ERR(" udp open fail!!!\n");
                if(pStreamBuffer != NULL)
                free(pStreamBuffer);
                return NULL;
            }
            RTK_PLAYER_INF(" udp open success!!!\n");
        }
	else if(rtk_socket.e_socket_type == RTK_TCP_SOCKET)
	{
            pTcpReceiver = new TCPReceiver();
            if(pTcpReceiver == NULL)
            {
                if(pStreamBuffer != NULL)
                    free(pStreamBuffer);
                return NULL;
            }
            socketRet = pTcpReceiver->Open(rtk_socket.iPort);
            if(socketRet != RTK_OK)
            {
                RTK_PLAYER_ERR(" tcp open fail!!!\n");
                if(pStreamBuffer != NULL)
                    free(pStreamBuffer);
                return NULL;
            }
            RTK_PLAYER_INF(" tcp open success!!!\n");		
	}
#ifdef USE_RTK_EXTRACTOR
        else if(rtk_socket.e_socket_type == RTK_HTTP_SOCKET)	
        {
            pHttpProxyReceiver = new HttpIOPluginProxy();
            if(pHttpProxyReceiver == NULL)
            {
                if(pStreamBuffer != NULL)
                    free(pStreamBuffer);
                return NULL;
            }
            memcpy(rtk_socket.iStrHttp, m_demuxConfig.input.iptv.iStrHttp, sizeof(m_demuxConfig.input.iptv.iStrHttp));
            RTK_PLAYER_INF(" http io path = %s \n" ,rtk_socket.iStrHttp );
            socketRet = pHttpProxyReceiver->open(rtk_socket.iStrHttp , 0);
            if(socketRet != RTK_OK)
            {
                RTK_PLAYER_ERR(" http open fail!!!\n");
                if(pStreamBuffer != NULL)
                    free(pStreamBuffer);
                return NULL;
            }
            RTK_PLAYER_INF(" http open success!!!\n");
        }
#endif
      
                //	read ts data from network socket.
	while(1)
	{

		if(m_PreparseFeedStop == RTK_TRUE)
		{
			if(pUdpReceiver != NULL)
			{
				pUdpReceiver->Close();
				delete(pUdpReceiver);
				pUdpReceiver = NULL;
				m_pSource = NULL;
			}
			if(pTcpReceiver != NULL)
			{
				pTcpReceiver->Close();
				delete(pTcpReceiver);
				pTcpReceiver = NULL;
			}
#ifdef USE_RTK_EXTRACTOR
			if(pHttpProxyReceiver != NULL)
			{
				pHttpProxyReceiver->Close();
				delete(pHttpProxyReceiver);
				pHttpProxyReceiver = NULL;
			}
#endif
			if(pStreamBuffer != NULL)
				free(pStreamBuffer);
			return NULL;
		}
		if(rtk_socket.e_socket_type == RTK_UDP_SOCKET)	
		{
			ret_size = pUdpReceiver->Read((char*)pStreamBuffer, m_readdatasize);
			if(ret_size <= 0)
			{
				retryCounter--;
				if(retryCounter == 0)
				{
					RTK_PLAYER_ERR("[%s][%d]UdpReceive Read error %d \n",__FUNCTION__,__LINE__, ret_size);
					RT_PlayerNotify(RTK_PLAYER_UDP_TIMEOUT, NULL);
					retryCounter = SOURCE_RETRY_COUNTER;
				}
				m_readdatasize = 0;
			}
			else
			{
				retryCounter = SOURCE_RETRY_COUNTER;
				m_readdatasize = ret_size;
			}
		}
		else if(rtk_socket.e_socket_type == RTK_TCP_SOCKET)
		{
			ret_size = pTcpReceiver->Read((char*)pStreamBuffer, m_readdatasize);
			if(ret_size < 0)
			{
				RTK_PLAYER_ERR("[%s][%d]TcpReceiver Read error %d \n",__FUNCTION__,__LINE__, ret_size);
				m_readdatasize= 0;
			}
			else
				m_readdatasize = ret_size;
		}
#ifdef USE_RTK_EXTRACTOR
		else if(rtk_socket.e_socket_type == RTK_HTTP_SOCKET)	
		{
			ret_size= pHttpProxyReceiver->read((unsigned char*)pStreamBuffer, m_readdatasize,NULL);
			RTK_PLAYER_INF("Demux::  pStreamBuffer size=%d \n",m_readdatasize);
		}
#endif
		char ret;
		ret=ParseChannelInfo(pStreamBuffer,m_readdatasize,&channelinfo,&pmtpid);
		if(ret == 0)
		{
			m_PreparseFeedStop = RTK_TRUE ;
			break;
		}

		m_readdatasize = 47*1024;
		usleep(1);
	}
        m_programInfo.program_cnt = 1;
        m_programInfo.psi_program[0] = channelinfo;
        m_programInfo.psi_program[0].received = true;
        
        RT_PlayerNotify(RTK_PLAYER_SECTION_PROGRAMINFO, &m_programInfo);

        RTK_PLAYER_INF(" notify success!!!  \n");

        RTK_Player playerHandle = m_demux;

        if(m_arch == ARCH_DEMUX_AND_PLAY)
        {
            playerHandle = m_player;
        }
        else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
        {
            playerHandle = m_demux;
        }

        if((m_demuxConfig.video.pid != m_programInfo.psi_program[0].video_pids[0].pid)
            ||(m_demuxConfig.video.codec != _xTS_Transfer_Video_Codec(m_programInfo.psi_program[0].video_pids[0].codec)))
        {
            m_playerConfig.video.pid = m_demuxConfig.video.pid = m_programInfo.psi_program[0].video_pids[0].pid;
            m_playerConfig.video.codec = m_demuxConfig.video.codec = _xTS_Transfer_Video_Codec(m_programInfo.psi_program[0].video_pids[0].codec);
            if(RTK_Player_ChangeVideo(playerHandle, &m_demuxConfig.video) != RTK_OK)
            {
                RTK_PLAYER_ERR("Failed to change video.\n");
            }
        }
        if((m_demuxConfig.audio.pid != m_programInfo.psi_program[0].audio_pids[m_audioIndex].pid)
                ||(m_demuxConfig.audio.codec != _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[0].audio_pids[m_audioIndex].codec)))
		{
            m_playerConfig.audio.pid = m_demuxConfig.audio.pid = m_programInfo.psi_program[0].audio_pids[m_audioIndex].pid;
            m_playerConfig.audio.codec= m_demuxConfig.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[0].audio_pids[m_audioIndex].codec);
            if(RTK_Player_ChangeAudio(playerHandle, &m_demuxConfig.audio) != RTK_OK)
            {
                RTK_PLAYER_ERR("Failed to change audio.\n");
            }
        }

#if 0 // don't close udp because it will open again when start
        if(pUdpReceiver != NULL)
        {
            pUdpReceiver->Close();
            delete(pUdpReceiver);
            pUdpReceiver = NULL;
        }
#endif
        if(pTcpReceiver != NULL)
        {
            pTcpReceiver->Close();
            delete(pTcpReceiver);
            pTcpReceiver = NULL;
        }
#ifdef USE_RTK_EXTRACTOR
	if(pHttpProxyReceiver != NULL)
	{
		pHttpProxyReceiver->Close();
		delete(pHttpProxyReceiver);
		pHttpProxyReceiver = NULL;
	}
#endif
        if(pStreamBuffer != NULL)
            free(pStreamBuffer);

      return NULL;
}

#endif

inline char RTKPlayer::xConvertURLtoKeyNum(unsigned long long * result)
{
	if(strlen(m_demuxConfig.input.iptv.iStrIP)==0)
		return RTK_ERR;

	char *pch;
	char temp[16];
	unsigned long long ipNum = 0;
	unsigned long long rate = 100000000000000;
	strncpy(temp,m_demuxConfig.input.iptv.iStrIP,16);
	pch = strtok(temp,".");
	while (pch != NULL)
	{
		ipNum = atoll(pch);
		*result += ipNum * rate;
		rate = rate / 1000;
		pch = strtok(NULL, ".");
	}
	*result += m_demuxConfig.input.iptv.iPort;

	return RTK_OK;
}

int RTKPlayer::check_channellist(char *strUrl)
{
	RTK_PLAYER_INF("%s strUrl=%s", __func__, strUrl);
	m_channellistFileRd = fopen(CHANNEL_LIST_PATCH,"rb");
	if(m_channellistFileRd== NULL)
	{
		RTK_PLAYER_ERR("%s %s %d:fail!! ERROR to open %s !(%d)\n", __FILE__, __FUNCTION__, __LINE__,CHANNEL_LIST_PATCH,errno);
		storedchannellist.currtotalchannelnum = 0;
		storedchannellist.update_version = CHANNEL_LIST_VERSION;
		return -1;
	}
	else
	{
		std::map<unsigned long long,RTK_CHANNELINFO>::iterator iter;
		unsigned long long UrlKey = 0;
		if(xConvertURLtoKeyNum(&UrlKey)!=RTK_OK)
		{
			fclose(m_channellistFileRd);
			return 1;
		}

		fread(&storedchannellist.currtotalchannelnum,4,1,m_channellistFileRd);
		fread(&storedchannellist.update_version,4,1,m_channellistFileRd);

		if(storedchannellist.update_version != CHANNEL_LIST_VERSION)
		{
			RTK_PLAYER_ERR("%s %d:ERROR!! your channellist.dat is not compatible with this librtk_halPlayer_MOD.so\n", __FUNCTION__, __LINE__);
			RTK_PLAYER_ERR("%s %d:We help create a new one\n", __FUNCTION__, __LINE__);
			fclose(m_channellistFileRd);
			// create a new file to overlap this old one
			storedchannellist.currtotalchannelnum = 0;
			storedchannellist.update_version = CHANNEL_LIST_VERSION;
			return -1;
		}

		unsigned long long map_key = 0;
		RTK_CHANNELINFO map_value;
		while(fread(&map_key,8,1,m_channellistFileRd))
		{
			fread(&map_value,sizeof(RTK_CHANNELINFO),1,m_channellistFileRd);
			storedchannellist.channellist[map_key] = map_value;
		}

		cur_it = storedchannellist.channellist.find(UrlKey);
		if(cur_it == storedchannellist.channellist.end())
		{
			RTK_PLAYER_INF("[%s:%d] new key=%llu\n",__FUNCTION__,__LINE__, UrlKey);
			fclose(m_channellistFileRd);
			return -1;
		}
		fclose(m_channellistFileRd);
	}

	return 0;
}

void RTKPlayer::update_channellist()
{
	std::map<unsigned long long,RTK_CHANNELINFO>::iterator iter;

	if(m_saveurlflag == 1)
	{
		unsigned long long UrlKey = 0;
		RTK_CHANNELINFO info;
		memset(&info, 0x0, sizeof(RTK_CHANNELINFO));
		info.videopid = m_demuxConfig.video.pid;
		info.videocodec = m_demuxConfig.video.codec;
		info.audiopid = m_demuxConfig.audio.pid;
		info.audiocodec = m_demuxConfig.audio.codec;
		if(xConvertURLtoKeyNum(&UrlKey)!=RTK_OK)
		{
			return;
		}
		storedchannellist.channellist.insert( std::pair<unsigned long long,RTK_CHANNELINFO>(UrlKey,info) );
		storedchannellist.currtotalchannelnum = storedchannellist.channellist.size();
	}
	else if(m_saveurlflag == 0)
	{
		if(cur_it->second.videopid == m_demuxConfig.video.pid     &&
		   cur_it->second.videocodec == m_demuxConfig.video.codec &&
		   cur_it->second.audiopid == m_demuxConfig.audio.pid     &&
		   cur_it->second.audiocodec == m_demuxConfig.audio.codec
		)
		{
			RTK_PLAYER_INF("%s %d: this channel info is unchanged, no need to write back\n", __FUNCTION__, __LINE__);
			return;
		}
		else
		{
			cur_it->second.videopid = m_demuxConfig.video.pid;
			cur_it->second.videocodec = m_demuxConfig.video.codec;
			cur_it->second.audiopid = m_demuxConfig.audio.pid;
			cur_it->second.audiocodec = m_demuxConfig.audio.codec;
		}
	}

	// update/add channel info to the list
	m_channellistFileWr= fopen(CHANNEL_LIST_PATCH,"wb");

	if(m_channellistFileWr== NULL)
	{
		RTK_PLAYER_ERR("%s %s %d:write channellist fail!! ERROR to open&create  %s \n", __FILE__, __FUNCTION__, __LINE__,CHANNEL_LIST_PATCH);
		return;
	}

	fwrite(&storedchannellist.currtotalchannelnum,4,1,m_channellistFileWr);
	fwrite(&storedchannellist.update_version,4,1,m_channellistFileWr);
	for(iter=storedchannellist.channellist.begin(); iter!=storedchannellist.channellist.end(); iter++)
	{
		if(fwrite(&iter->first,8,1,m_channellistFileWr)!=1)
		{
			RTK_PLAYER_ERR("%s %d:ERROR!! fail writing channel info to file!\n", __FUNCTION__, __LINE__);
		}
		if(fwrite(&iter->second,sizeof(RTK_CHANNELINFO),1,m_channellistFileWr)!=1)
		{
			RTK_PLAYER_ERR("%s %d:ERROR!! fail writing channel info to file!\n", __FUNCTION__, __LINE__);
		}
	}
	fflush(m_channellistFileWr);
	fclose(m_channellistFileWr);
	return ;
}

int RTKPlayer::RT_Player_ChangeChannel(RTK_VideoConfig *pVideo, RTK_AudioConfig *pAudio)
{
	return RTK_Player_ChangeChannel(m_demux, pVideo, pAudio);
}

void RTKPlayer::RT_Player_SetLoop(bool enable)
{
	m_LoopFeedEnable=enable;
	return;
}

int RTKPlayer::RT_Player_SetMultiFreq(RTKMultiCH_Param_t MultiCH_param)
{
#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V1)  
    return RTK_Tuner_Multich_SetFreq(0, MultiCH_param);
#else
	(void)MultiCH_param;
    return RTK_Fail;
#endif
}

int RTKPlayer::RT_Player_SetMultiPIDFilters(RTKMultich_Pids_t* MultiCHPID_param,int channel_count)
{ 
#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V1)  
    return RTK_Player_SetMultiPIDFilters(m_demux,MultiCHPID_param,channel_count);
#else
	(void)MultiCHPID_param;	// unused
	(void)channel_count;	// unused
    return RTK_Fail;
#endif    
}

int RTKPlayer::RT_Player_ChangeProgram(int  program_num) 
{
	if (m_demux == NULL)
	{
		RTK_PLAYER_ERR("Demux is NULL!!");
		return RTK_ERR;
	}
#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V1)
	return RTK_Player_ChangeProgram(m_demux, program_num);
#else
	(void)program_num;	// unused
    return RTK_Fail;
#endif    	
}

int RTKPlayer::RT_Player_ChangeVideo(RTK_VideoConfig *pVideo)
{
	RTK_Error ret=RTK_Fail;
	if (m_demux == NULL)
	{
		RTK_PLAYER_ERR("Demux is NULL!!");
		return RTK_ERR;
	}
	memcpy(&m_playerConfig.video, pVideo, sizeof(RTK_VideoConfig));
	memcpy(&m_demuxConfig.video, pVideo, sizeof(RTK_VideoConfig));

	if(m_isBackground==false)	
		ret=RTK_Player_ChangeVideo(m_demux, pVideo);
	else
	{
		uint16_t pre_pids[2]={0x1FFF, 0x1FFF};
		pre_pids[0]=m_playerConfig.video.pid;
		pre_pids[1]=m_playerConfig.audio.pid;

		//reset preset pids.
		if(RTK_Source_PresetPidFilter(m_source, pre_pids, 2)!=RTK_OK)
		{
			RTK_PLAYER_ERR("preset pid %d, %d failed\n", pre_pids[0], pre_pids[1]);
			return RTK_ERR;
		}
	}

	return ret;
}

int RTKPlayer::RT_Player_ChangeAudio(RTK_AudioConfig *pAudio)
{
	RTK_Error ret=RTK_Fail;
	if (m_demux == NULL)
	{
		RTK_PLAYER_ERR("Demux is NULL!!");
		return RTK_ERR;
	}
	memcpy(&m_playerConfig.audio, pAudio, sizeof(RTK_AudioConfig));
	memcpy(&m_demuxConfig.audio, pAudio, sizeof(RTK_AudioConfig));

	if(m_isBackground==false)	
		ret=RTK_Player_ChangeAudio(m_demux, pAudio);
	else
	{
		uint16_t pre_pids[2]={0x1FFF, 0x1FFF};
		pre_pids[0]=m_playerConfig.video.pid;
		pre_pids[1]=m_playerConfig.audio.pid;

		//reset preset pids.
		if(RTK_Source_PresetPidFilter(m_source, pre_pids, 2)!=RTK_OK)
		{
			RTK_PLAYER_ERR("preset pid %d, %d failed\n", pre_pids[0], pre_pids[1]);
			return RTK_ERR;
		}
	}

	return ret;
}

int RTKPlayer::RT_Player_StartDescrambler(uint16_t sid, std::vector<std::pair<uint16_t /*ECM PID*/,uint16_t/*stream PID*/>> & ecmPidList)
{
	if(NULL == m_CaIntf)
	   return RTK_Fail;


	if (ecmPidList.empty())
	   return RTK_OK;

	RTKCA_Descramble_ECM_info_t ecm_info;
	memset(&ecm_info, 0, sizeof(RTKCA_Descramble_ECM_info_t));
	
	uint16_t streamPid, ecmPid;
	int i = 0;
	for (auto& it : ecmPidList) {
		ecm_info.ecm_AVPids[i].ecm_pid = it.first;
		ecm_info.ecm_AVPids[i].stream_pid = it.second;
		i++; 
	}

	ecm_info.source_handle=(int)m_source;
	ecm_info.emm_pid = 0x1FFF;
	ecm_info.program_id = sid;
	ecm_info.algo = RTKCA_ALGO_CSA2;

	return m_CaIntf->StartDescramble(m_player_id, ecm_info);
}

int RTKPlayer::RT_Player_StopDescrambler()
{
    if (NULL != m_CaIntf)
		m_CaIntf->StopDescramble(m_player_id);

	return 0;
}

int RTKPlayer::RT_Player_setEmmPid(uint16_t caSystemId, uint16_t pid)
{
	if (NULL != m_CaIntf)
	   m_CaIntf->SetEmmPid(caSystemId, pid, (int)m_source);
	   
	return 0;
}

#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
int RTKPlayer::RT_Source_Create(RTK_Source* source, RTK_SourceParam_t param)
{
	return RTK_Source_Create(source, param);
}

int RTKPlayer::RT_Source_Destory(RTK_Source source)
{
	return RTK_Source_Destroy(source);
}

int RTKPlayer::RT_Source_PresetPidFilter(RTK_Source source, uint16_t* pids, unsigned char numPID)
{
	return RTK_Source_PresetPidFilter(source, pids, numPID);
}

int RTKPlayer::RT_Player_SetSource(RTK_Source source)
{
	if (m_demux == NULL)
	{
		RTK_PLAYER_ERR("Demux is NULL!!");
		return RTK_ERR;
	}
	m_source = source;
	return RTK_Player_SetSource(m_demux, source);
}
#endif
int RTKPlayer::RT_Source_GetIsLocked()
{
#if (RTKPLAYER_ARCH_VER == RTKPLAYER_ARCH_V2)     
	return RTK_Source_GetIsLocked(m_source);
#else
    return RTK_Tuner_IsLocked(0);
#endif
}

int RTKPlayer::RT_Player_TunerIsLocked( )
{ 
    return RTK_Tuner_IsLocked(0);
}

int RTKPlayer::RT_Player_SetAVSyncMode(int mode){
   RTK_Player playerHandle = m_demux;
   m_av_sync_mode = (RTK_AVsyncMode)mode;  

      //background player no need this.
   if(m_isBackground==true)
		return RTK_ERR;
   
   return  (int)RTK_Player_SetAVSyncMode(playerHandle, (RTK_AVsyncMode)mode);
}

int RTKPlayer::RT_Tuner_Scan(uint32_t uiTunerID,RTK_TunerParam_t param) {
#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V3) 
    return (int)RTK_Tuner_Scan(uiTunerID, param);
#elif (RTKPLAYER_ARCH_VER <= RTKPLAYER_ARCH_V2)  
    return (int)RTK_Set_TunerScanning(uiTunerID, param);
#else
    return RTK_Fail;
#endif    
}


int RTKPlayer::RT_Player_SetErrorConcealLevel(int level){
  RTK_Player playerHandle = m_demux;
  INT32_T delayTime = 0;
  return (int)RTK_Player_SetErrorConcealLevel(playerHandle,level,delayTime);
}

TS_PSI_Program RTKPlayer::RT_Player_getPogramInfo(int index){
  
	if(m_programInfo.program_cnt < index){
		index = 0;
	}
	TS_PSI_Program ts_program;
	memset(&ts_program, 0, sizeof(TS_PSI_Program));

	TS_PSI_Program tmp_program = m_programInfo.psi_program[index];
	
	for(int i =0 ;i < tmp_program.num_audio_pids ; i++){
      ts_program.audio_pids[i].pid = tmp_program.audio_pids[i].pid;
	  ts_program.audio_pids[i].codec = _xTS_Transfer_Audio_Codec(tmp_program.audio_pids[i].codec);
	  RTK_PLAYER_INF("%s %d: old codec = %d change to RTK code = %d\n", __FUNCTION__, __LINE__,tmp_program.audio_pids[i].codec,ts_program.audio_pids[i].codec);
	}
	for(int i =0 ;i < tmp_program.num_video_pids; i++){
	  ts_program.video_pids[i].pid = tmp_program.video_pids[i].pid;
	  ts_program.video_pids[i].codec = _xTS_Transfer_Video_Codec(tmp_program.video_pids[i].codec);
	}

   return  ts_program;
 }

int RTKPlayer::RT_Player_SetAudioFocused(bool audioFocused){
	 m_ForceAudioFocusedState = (RTK_Bool)audioFocused;;
	 m_ForceAudioFocused = RTK_TRUE;
 return (int)m_ForceAudioFocusedState;
}

int RTKPlayer:: RT_playerSeek(int seek_value) {
	RTK_Player playerHandle = m_demux;
	uint64_t ulPtsCurr = 0;

      //background player no need this.
       if(m_isBackground==true)
    		return RTK_ERR;
    
	RTK_Player_GetCurrentDisplayingPTS(playerHandle, &ulPtsCurr);
	if(s_PvrTsFile == NULL)
	{
		RTK_PLAYER_ERR("Open target recored file:%s failed!!\n\n", m_demuxConfig.input.memory.filePath);
		return RTK_Fail;
	}

	if(m_recordingCtrl_Rd == NULL)
	{	
		char strCtrlName[256]={0};
		snprintf(strCtrlName, 256, "%s_ctrl.dat", m_demuxConfig.input.memory.filePath);
		m_recordingCtrl_Rd= fopen(strCtrlName, "rb");
		if(m_recordingCtrl_Rd == NULL){
			RTK_PLAYER_ERR("Open target recored file:%s failed!!\n\n", m_demuxConfig.input.memory.filePath);
			return RTK_Fail;
		}else{
			RTK_PLAYER_INF("Open target recored file:%s successed.\n", m_demuxConfig.input.memory.filePath);
		}			
	}

	if (xPVR_Replay_Seek(s_PvrTsFile, m_recordingCtrl_Rd, m_recordingIdx_Rd, ulPtsCurr, seek_value, RTK_SEEKWHENCE_CUR))
	{
		RTK_PLAYER_ERR("Seek video play by %dms from current failed!!\n", seek_value);
		return RTK_Fail;
	}
	else
	{
		RTK_PLAYER_INF("Seek video play by %dms from current successed.\n", seek_value);
		RTK_Player_DropData(playerHandle);
		//RTK_Player_Resume(gPlayer_1);
	}

	return RTK_OK;
}

char RTKPlayer::RT_GetEpgInfo(TS_Program_Info	*programInfo,time_t *now_time)
{
	RTK_PLAYER_INF("RT_GetEpgInfo  start  %d nowTime = %ld \n",m_programInfo.program_cnt, nowTime);
	if(m_isAddEPG){
		*programInfo = m_programInfo;
		*now_time = nowTime;
	}
	return true;
}

void RTKPlayer::RT_OpenEpgInfo(RTK_Bool openEpg)
{
	m_isAddEPG = openEpg;
	if(m_isAddEPG)
	{
		xAddSDT();
		xAddEIT();
	}
	return;
}

time_t RTKPlayer::RT_GetEpgNowTime()
{
	return nowTime;
}

void RTKPlayer::RT_Tuner_GetInfo(RTK_TunerInfo *tuner_info)
{
	if(m_tuner_id>=0)
		RTK_Tuner_GetInfo(m_tuner_id, tuner_info);
	return;
}


//////////////////////////FCC test start//////////////////////////////////////
#define FCC_CHLIST_FILE_PATH	"/data/vendor/multich_list.txt"
#define FCC_CHLIST_FILE_PATH_2	"/data/vendor/mediadrm/multich_list.txt"
#define FCC_CHLIST_FILE_PATH_TIF	"/data/vendor/mediadrm/multich_list_tif.txt"

//#define RTK_PLAYER_INF(fmt, args...)	printf(fmt, ##args)	
#define FCC_CHLIST_MAX_CH_COUNT (100)

RTK_Player gPlayer = NULL;
int g_fcc_isFirstPlay = 1;
int g_fcc_curChannelIndex = 0;
int g_fcc_g_fcc_MaxChannelNum = 0; //shpule be parse from file.
int g_FCC_total_ChCount=0;
int g_fcc_preChannelindex = 0;
FILE *g_fcc_chlist_pf = NULL;
RTK_FCCHANNELLIST *g_pFCC_chlist = NULL;
RTK_Tuner_Type_e gFCC_tunerType = RTK_TUNER_TYPE_DVBC;


static int _parse_FastChangeChannellist(RTK_FCCHANNELLIST *pFCC_chlist, int *pChCount, char *url)
{
	FILE *m_FCCchannellistFile=NULL;

	char strUrl[100];
	char *pch;
	int info = 0;
	int updatelnbmodeflag = 0;
	int m_totalFCCcount=0;
	
	memset(pFCC_chlist, 0, FCC_CHLIST_MAX_CH_COUNT*sizeof(RTK_FCCHANNELLIST));
	if(g_is_tif_fcc == RTK_TRUE){
		if(!access(FCC_CHLIST_FILE_PATH_TIF, 0)){
			m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH_TIF,"rb");
		}else{
			RTK_PLAYER_ERR("fcc multich list path_tif: %s no file\n", FCC_CHLIST_FILE_PATH);
		}
	}else if(!access(FCC_CHLIST_FILE_PATH, 0)){
	    m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH,"rb");
		RTK_PLAYER_INF("fcc multich lis path1: %s\n", FCC_CHLIST_FILE_PATH);
	}else{
		m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH_2,"rb");
		RTK_PLAYER_INF("fcc multich lis path2: %s\n", FCC_CHLIST_FILE_PATH_2);
	}
	if(m_FCCchannellistFile == NULL)
	{
		RTK_PLAYER_ERR("\n open %s err \n", FCC_CHLIST_FILE_PATH);
		return -1;
	}
	
	for(int i = 0; i < FCC_CHLIST_MAX_CH_COUNT; i++)
	{
		memset(strUrl,0,100);
		updatelnbmodeflag = 0;
		if(fgets(strUrl,100,m_FCCchannellistFile)== NULL)
		{
			break;
		}

		//Do not process comments
		if(strncmp(strUrl, "#", 1) == 0)
		{
			continue;
		}

		//get url
		if(strncmp(strUrl, "tuner://", 8) == 0)
		{
			memcpy(url, strUrl, strlen(strUrl) + 1);
			RTK_PLAYER_INF("Update_FastChangeChannellist URL: %s\n", url);
		}
		pFCC_chlist[m_totalFCCcount].bandwidth = RTK_TUNER_BANDWIDTH_8M;

		if(strncmp(strUrl, "fq=", 3) == 0)
		{
			pch = strtok(strUrl,"&");				
			while (pch != NULL)
			{
				if(strncmp(pch, "vp=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist video pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videopid = info;
				}
				else if(strncmp(pch, "ap=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist audio pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiopid= info;
				}
				else if(strncmp(pch, "vc=", 3) == 0)
				{
					RTK_PLAYER_INF("Update_FastChangeChannellist video codec strings: %s\n", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG2;
					}
					else if(strncmp((pch+3), "MPEG4_PART2", strlen("MPEG4_PART2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG4_PART2;
					}
					else if(strncmp((pch+3), "H264", strlen("H264")) == 0)
					{
						info = RTK_CODEC_VIDEO_H264;
					}
					else if(strncmp((pch+3), "H265", strlen("H265")) == 0)
					{
						info = RTK_CODEC_VIDEO_H265;
					}
					else
					{
						info = RTK_CODEC_NONE;
					}
					RTK_PLAYER_INF("Update_FastChangeChannellist video codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videocodec =(RTK_Codec) info;
				}
				else if(strncmp(pch, "ac=", 3) == 0)
				{	
					RTK_PLAYER_INF("Update_FastChangeChannellist audio codec strings: %s", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG2;
					}
					else if(strncmp((pch+3), "AACPLUS", strlen("AACPLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AACPLUS;
					}
					else if(strncmp((pch+3), "AAC", strlen("AAC")) == 0)
					{
						info = RTK_CODEC_AUDIO_AAC;
					}
					else if(strncmp((pch+3), "AC3_TRUE_HD", strlen("AC3_TRUE_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_TRUE_HD;
					}
					else if(strncmp((pch+3), "AC3_PLUS", strlen("AC3_PLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_PLUS;
					}
					else if(strncmp((pch+3), "EAC3", strlen("EAC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_EAC3;
					}
					else if(strncmp((pch+3), "AC3", strlen("AC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3;
					}
					else if(strncmp((pch+3), "DTS_HD", strlen("DTS_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS_HD;
					}
					else if(strncmp((pch+3), "DTS", strlen("DTS")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS;
					}
					else if(strncmp((pch+3), "LPCM", strlen("LPCM")) == 0)
					{
						info = RTK_CODEC_AUDIO_LPCM;
					}
					else if(strncmp((pch+3), "MP3", strlen("MP3")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP3;
					}
					else if(strncmp((pch+3), "MP4", strlen("MP4")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP4;
					}				
					else
					{
						info = RTK_CODEC_NONE;
					}
					RTK_PLAYER_INF("Update_FastChangeChannellist audio codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiocodec = (RTK_Codec) info;
				}
				else if(strncmp(pch, "fq=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist freq: %d\n", info);
					pFCC_chlist[m_totalFCCcount].freq = info;
				}			
				else if(strncmp(pch, "qa=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist qam: %d\n", info);
					pFCC_chlist[m_totalFCCcount].qam= info;
				}
			   	else if(strncmp(pch, "ln=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist lnbmode: %d\n", info);
					pFCC_chlist[m_totalFCCcount].lnbmode= info;
					updatelnbmodeflag = 1;
				}
				else if(strncmp(pch, "sr=", 3) == 0)
				{
					info = atoi(pch+3);
					RTK_PLAYER_INF("Update_FastChangeChannellist symbolrate: %d\n", info);
					pFCC_chlist[m_totalFCCcount].symbolrate= info;
				}
				else if(strncmp(pch, "bw=", 3) == 0)
				{					
					if(strncmp((pch+3), "6M ", 2) == 0){
						pFCC_chlist[m_totalFCCcount].bandwidth = RTK_TUNER_BANDWIDTH_6M;
					}else if(strncmp((pch+3), "7M ", 2) == 0){
						pFCC_chlist[m_totalFCCcount].bandwidth = RTK_TUNER_BANDWIDTH_7M;
					}else{
						pFCC_chlist[m_totalFCCcount].bandwidth= RTK_TUNER_BANDWIDTH_8M;
					}
					RTK_PLAYER_INF("Update_FastChangeChannellist bandwidth: %d\n", pFCC_chlist[m_totalFCCcount].bandwidth);
				}
				
				pch = strtok(NULL, "&");
			}
			if(updatelnbmodeflag != 1)
				pFCC_chlist[m_totalFCCcount].lnbmode = 0xff;

			m_totalFCCcount += 1;
		}
		
	}
	
	fclose(m_FCCchannellistFile);
	*pChCount=m_totalFCCcount;
	
	return 0;
}

// only filled cur / up / down
static int g_CH_index_V2[3] ={-1,-1,-1}; // channel number in source program
static RTK_Source g_source[3] ={0,0,0};
static RTK_SourceParam_t _multich_fill_V3(RTK_FCCHANNELLIST* pFCC_chlist, int index)
{
	RTK_SourceParam_t source_param;

	memset(&source_param, 0, sizeof(RTK_SourceParam_t));
	source_param.type = RTK_SOURCE_TYPE_UNKNOWN;
	source_param.isSMP = RTK_FALSE;	
	
	if(RTK_DvbGetSMP(0) == RTK_TRUE)	
	{		
		source_param.isSMP = RTK_TRUE;	
	}
	
	if(gFCC_tunerType == RTK_TUNER_TYPE_DVBC)
	{
		source_param.type = RTK_SOURCE_TYPE_DVBC;
		source_param.tnr_param.dvb_c_param.u32frequency = pFCC_chlist[index].freq;
		source_param.tnr_param.dvb_c_param.u32symbol_rate = pFCC_chlist[index].symbolrate;
		source_param.bandwidth = pFCC_chlist[index].bandwidth;
		switch (pFCC_chlist[index].qam)
		{
			case 16:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_16QAM;
				break;
			case 32:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_32QAM;
				break;
			case 64:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_64QAM;
				break;
			case 128:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_128QAM;
				break;
			case 256:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
				break;
			default:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
				break;
		}
		source_param.tnr_param.dvb_c_param.annex_type = RTK_DVBC_ANNEX_A;
	}
	else if(gFCC_tunerType == RTK_TUNER_TYPE_DVB_S || gFCC_tunerType == RTK_TUNER_TYPE_DVB_S2)
	{
		source_param.type = (gFCC_tunerType == RTK_TUNER_TYPE_DVB_S) ? RTK_SOURCE_TYPE_DVB_S : RTK_SOURCE_TYPE_DVB_S2;
		source_param.tnr_param.dvb_s_param.u32frequency = pFCC_chlist[index].freq;
		source_param.tnr_param.dvb_s_param.u32symbol_rate = pFCC_chlist[index].symbolrate;
		source_param.bandwidth = pFCC_chlist[index].bandwidth;
		switch (pFCC_chlist[index].lnbmode)
		{
			case 0xff:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
			case 0:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
			case 13:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V;
				break;
			case 18:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V;
				break;
			case 1322:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V_WITH_22K_BURST;
				break;
			case 1822:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V_WITH_22K_BURST;
				break;
			default:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
		}
	}
	return source_param;
}

static int _multich_UpdateSource_V3(RTK_FCCHANNELLIST* pFCC_chlist, int FCC_chcount, int channel_index)
{
	int down_index = 0;
	int up_index = 0;

	int cur_need_update = 1;
	int down_need_update = 1;
	int up_need_update = 1;

	RTK_PLAYER_INF("_multich_UpdateSource_V3 enter, change to %d\n",channel_index);

	// calculate down/up index
	down_index = (channel_index + 1) % FCC_chcount;
	up_index   = (channel_index - 1 + FCC_chcount) % FCC_chcount;

	// check cur program need remove or resue
	for(int i=0;i<3;i++)
	{
		if( g_CH_index_V2[i] == channel_index && cur_need_update == 1)
		{
			cur_need_update = 0;
		}
		else if(g_CH_index_V2[i] == down_index && down_need_update == 1)
		{
			down_need_update = 0;
		}
		else if(g_CH_index_V2[i] == up_index && up_need_update == 1)
		{
			up_need_update = 0;
		}
		else
		{
			g_CH_index_V2[i] = -1;
		}
	}

	#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
	// add need update index to free program
	for(int i=0;i<3;i++)
	{
		RTK_SourceParam_t source_param;
		uint16_t pid2[PIDSMAXNUM_IN_ONE_PROGRAM];
		if(g_CH_index_V2[i] == -1 )
		{
			if(cur_need_update)
			{
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, channel_index);
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[channel_index].videopid;
				pid2[1] = pFCC_chlist[channel_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				cur_need_update = 0;
				g_CH_index_V2[i] = channel_index;
			}
			else if(down_need_update)
			{
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, down_index);
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[down_index].videopid;
				pid2[1] = pFCC_chlist[down_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				down_need_update = 0;
				g_CH_index_V2[i] = down_index;
			}
			else
			{
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, up_index);
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[up_index].videopid;
				pid2[1] = pFCC_chlist[up_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				up_need_update = 0;
				g_CH_index_V2[i] = up_index;
			}
		}
	}
	#endif
	for(int i=0;i<3;i++)
	{
		RTK_PLAYER_INF("after _multich_UpdateSource_V3 program[%d] is channel %d\n", i ,g_CH_index_V2[i] );
	}
	return 0;
}

static int _multich_firstPlay(RTK_FCCHANNELLIST *pFCC_chlist, int FCC_chcount, int channel_index)
{
	RTK_VideoConfig video;
	RTK_AudioConfig audio;

	g_CH_index_V2[0] = -1;
	g_CH_index_V2[1] = -1;
	g_CH_index_V2[2] = -1;
	g_source[0] = 0;
	g_source[1] = 0;
	g_source[2] = 0;

	RTK_Source cur_source = 0;
	_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
	for(int i=0;i<3;i++)
	{
		if( g_CH_index_V2[i] == channel_index)
		{
			cur_source = g_source[i];
			break;
		}
	}
	#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
	RTK_Player_SetSource(gPlayer, cur_source);
	#endif
	video.pid=pFCC_chlist[channel_index].videopid;
	video.codec=pFCC_chlist[channel_index].videocodec;
	audio.pid=pFCC_chlist[channel_index].audiopid;
	audio.codec=pFCC_chlist[channel_index].audiocodec;
	audio.focused=RTK_TRUE;
	RTK_Player_ChangeVideo(gPlayer, &video);
	RTK_Player_ChangeAudio(gPlayer, &audio);
	RTK_Player_Start(gPlayer);

	return 0;
}

static int _multich_ChangeCh(RTK_FCCHANNELLIST *pFCC_chlist, int FCC_chcount, int channel_index,int pre)
{
	RTK_VideoConfig video;
	RTK_AudioConfig audio;
	int program_num = -1;
	int update_program = 1;
	RTK_Source cur_source = 0;
	UNUSED(pre);
	RTK_Player_Pause(gPlayer);


__SEARCH_PROG_V3:

	for(int i=0;i<3;i++)
	{
		if( g_CH_index_V2[i] == channel_index)
		{
			program_num = i;
			cur_source = g_source[i];
			break;
		}
	}

	if(program_num == -1)
	{
		RTK_PLAYER_INF("new current channel is not in list, update program first\n");
		_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
		update_program = 0; // no need update program after change channel
		goto __SEARCH_PROG_V3;
	}
	else
	{
		RTK_PLAYER_INF("new current channel is in list, change play program first\n");
	}
	#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
	RTK_Player_SetSource(gPlayer, cur_source);
	#endif
	video.pid=pFCC_chlist[channel_index].videopid;
	video.codec=pFCC_chlist[channel_index].videocodec;
	audio.pid=pFCC_chlist[channel_index].audiopid;
	audio.codec=pFCC_chlist[channel_index].audiocodec;
	audio.focused=RTK_TRUE;
	RTK_Player_ChangeChannel(gPlayer, &video, &audio);

	if(update_program == 1)
	{
		_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
	}

	return 0;
}

void rtk_hal_test_FCC(void)
{	
	RTK_PlayerConfig config;

	char chlist_url[128];
	memset(chlist_url, 0x00, 128);

	g_pFCC_chlist=(RTK_FCCHANNELLIST *)malloc(FCC_CHLIST_MAX_CH_COUNT*sizeof(RTK_FCCHANNELLIST));
	if(g_pFCC_chlist==NULL)
	{
		RTK_PLAYER_ERR("g_pFCC_chlist malloc failed\n");
		return;
	}
	
	if(_parse_FastChangeChannellist(g_pFCC_chlist, &g_FCC_total_ChCount, chlist_url) != 0)
	{
		RTK_PLAYER_ERR("parse " FCC_CHLIST_FILE_PATH " failed\n");
		return;
	}

	RTK_PLAYER_INF("\ng_FCC_total_ChCount   === %d \n",g_FCC_total_ChCount);

	if(strncmp(chlist_url, "tuner://DVBC:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVBC;		
	}
	else if(strncmp(chlist_url, "tuner://DVBS:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_S;
	}
	else if(strncmp(chlist_url, "tuner://DVBS2:", 14) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_S2;
	}
	else if(strncmp(chlist_url, "tuner://DTMB:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DTMB;
	}
	else if(strncmp(chlist_url, "tuner://DVBT:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_T ;
	}
	else
	{
		RTK_PLAYER_INF("Input Tuner parameter error, force DVBC!");
		gFCC_tunerType = RTK_TUNER_TYPE_DVBC;	
	}
	
	//rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	RTK_WinConfig rtk_win_config;
	rtk_win_config.plane = RTK_WIN_MAIN;
	rtk_win_config.pos_x = 0;
	rtk_win_config.pos_y = 0;
	rtk_win_config.width = 1920;
	rtk_win_config.height = 1080;
	//RTK_CreateSurface(rtk_win_config);
	
	RTK_Tuner_Init();

	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_TUNER;
	if(RTK_Player_Create(&gPlayer, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		RTK_PLAYER_ERR("Failed to create player.\n");
		return;
	}
	if (gPlayer == NULL)
	{
		RTK_PLAYER_ERR("Player is NULL!!");
		return ;
	}

	return;

}

void rtk_hal_test_FCC_V3(void)
{
	RTK_PLAYER_INF("rtk_hal_test_FCC_V3\n");
#ifdef CLIENT_DTVSOURCE
	rtk_hal_test_FCC();
#else
	RTK_PLAYER_INF("ERROR! Must open ENABLE_DTVSOURCE close ENABLE_FAST_CHANNEL_CHANGE in DvdPlayer And CLIENT_DTVSOURCE in RTKPLAYER\n");
#endif
}

int RTKPlayer::RT_Player_FCC_test_start(int keep_last_frame,int current_idx)
{
	RTK_PLAYER_INF("RT_Player_FCC_test_start V3: keep_last_frame(%d) \n",keep_last_frame);
	rtk_hal_test_FCC_V3();
	
       char value[50] = "";
	const char product_property[] = "ro.board.platform";
	if(__system_property_get(product_property, value) != 0 
        && strcmp(value, "hank") == 0)
	{
		int ret =RTK_Player_SetErrorConcealLevel(gPlayer , 4096 , 0);
		RTK_PLAYER_INF("RTK_Player_SetErrorConcealLevel ret = %d, value = %s \n " , ret , value);
	}	
	RTK_Player_EnableKeepLastFrameForChangeChannel(gPlayer,(RTK_Bool)(keep_last_frame ==0 ? 0 : 1));							
	if(g_fcc_isFirstPlay)
	{
	    //fixed SA5-429 fcc test failued. 
	    if (g_pFCC_chlist == NULL || g_FCC_total_ChCount ==0)
	    {
    	    RTK_PLAYER_ERR("%s:%d g_pFCC_chlist=%p,g_FCC_total_ChCount=%d\n", __func__, __LINE__,g_pFCC_chlist,g_FCC_total_ChCount);
	        return -1;
	    }
	    
		g_fcc_curChannelIndex = current_idx;
		RTK_PLAYER_INF("playing CH %d\n", g_fcc_curChannelIndex);
		_multich_firstPlay(g_pFCC_chlist, g_FCC_total_ChCount, g_fcc_curChannelIndex);
		g_fcc_g_fcc_MaxChannelNum=g_FCC_total_ChCount -1;
		g_fcc_isFirstPlay=0;
	}
	else
		RTK_PLAYER_INF("already start!!!\n");
	return 0;
}

int RTKPlayer::RT_Player_FCC_test_stop()
{
	if(!g_fcc_isFirstPlay)
	{
		RTK_PLAYER_INF("RT_Player_FCC_test_stop\n");
		if(RTK_Player_Stop(gPlayer,RTK_FALSE) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to stop player.\n");
		}
		if(RTK_Player_Destroy(gPlayer) != RTK_OK)
		{
			RTK_PLAYER_ERR("Failed to destroy player.\n");
		}
		
		{
			#if (RTKPLAYER_ARCH_VER >= RTKPLAYER_ARCH_V2) 
			RTK_Source_Destroy(g_source[0]);
			RTK_Source_Destroy(g_source[1]);
			RTK_Source_Destroy(g_source[2]);
			g_source[0] = 0;
			g_source[1] = 0;
			g_source[2] = 0;
			#endif
		}
		gPlayer = NULL;
		RTK_DestorySurface(RTK_WIN_MAIN);
		RTK_Tuner_UnInit();
		g_fcc_isFirstPlay=1;
	}
	if(g_pFCC_chlist != NULL)
	{
		free(g_pFCC_chlist);
		g_pFCC_chlist = NULL;
	}
		g_is_tif_fcc = RTK_FALSE;
	return 0;
}

int RTKPlayer::RT_Player_FCC_test_next_channel()
{
	RTK_PLAYER_INF("RT_Player_FCC_test_next_channel\n");
	if(g_FCC_total_ChCount > 1)
	{
		g_fcc_preChannelindex = g_fcc_curChannelIndex;
		if(!g_fcc_isFirstPlay)
		{
			g_fcc_curChannelIndex = (g_fcc_curChannelIndex + 1) % g_FCC_total_ChCount;
			
			RTK_PLAYER_INF("playing CH %d\n", g_fcc_curChannelIndex);
			_multich_ChangeCh(g_pFCC_chlist, g_FCC_total_ChCount, g_fcc_curChannelIndex,g_fcc_preChannelindex);
		}
		else
			RTK_PLAYER_INF("please start first!!\n");
	}
	return 0;
}

int RTKPlayer::RT_Player_FCC_test_prev_channel()
{
	RTK_PLAYER_INF("RT_Player_FCC_test_prev_channel\n");
	if(g_FCC_total_ChCount > 1)
	{
		g_fcc_preChannelindex = g_fcc_curChannelIndex;
		if(!g_fcc_isFirstPlay)
		{
			g_fcc_curChannelIndex = (g_fcc_curChannelIndex -1 + g_FCC_total_ChCount) % g_FCC_total_ChCount;
			
			RTK_PLAYER_INF("playing CH %d\n", g_fcc_curChannelIndex);
			_multich_ChangeCh(g_pFCC_chlist, g_FCC_total_ChCount, g_fcc_curChannelIndex,g_fcc_preChannelindex);
		}
		else
			RTK_PLAYER_INF("please start first!!\n");
	}
	return 0;
}

int RTKPlayer::RT_Player_PopupToForeground(bool isToForeground)
{
	RTK_Error ret=RTK_Fail;
	if(m_isBackground==true && isToForeground==true)
	{
		ret=RTK_Player_SetSource(m_FCCMainPlayerHandle, m_source);
		if(ret!=RTK_OK)
		{
			RTK_PLAYER_ERR("[%s] player %p, set source %p failed\n", 
				__func__, m_FCCMainPlayerHandle, m_source);
			return RTK_ERR;
		}
		m_demux=m_FCCMainPlayerHandle;
		
		ret=RTK_Player_ChangeChannel(m_demux, &(m_playerConfig.video), &(m_playerConfig.audio));

		if(ret!=RTK_OK)
		{
			RTK_PLAYER_ERR("[%s] player %p, change channel failed\n", 
				__func__, m_demux);
			return RTK_ERR;
		}
		m_isBackground=false;
	}

	if(m_isBackground==false && isToForeground==false)
	{
		RTK_Player_Pause(m_demux);
		ret=RTK_Player_SetSource(m_demux, NULL);
		if(ret!=RTK_OK)
		{
			RTK_PLAYER_ERR("[%s] player %p, unset source failed\n", 
				__func__, m_demux);
			return RTK_ERR;
		}
		m_demux=NULL;
		m_isBackground=true;
	}

	return RTK_OK;
}
//////////////////////////FCC test end////////////////////////////////////////

char RT_setVideoSurface(RTK_WinPlane plane_id, void* native_window)
{
#ifdef ANDROID
	return RTK_SetVideoSurfaceEx(plane_id, native_window);
#else
	return -1;
#endif
}

int RT_GetSMP()
{
	return RTK_DvbGetSMP(0);
}

int RT_SetSMP(RTK_Bool enable)
{
	RTK_DvbSetSMP(0, enable);
	RTK_DvbSetSMP(1, enable);
   
	RTK_DvbSetSMP(16, enable);
	RTK_DvbSetSMP(17, enable);
   
	return 0;
}


int RT_writeMultichFile(const char *path,const char *content,bool apped) {
 
	RTK_PLAYER_INF(" path = %s, apped = %d", path, apped);

    FILE *fp = NULL; 
	if(apped){
		fp  = fopen(path, "a+");
	}else{
		fp  = fopen(path, "w+");
	}

    if(fp == NULL)
    {
        RTK_PLAYER_INF("[%s,%d]  open %s err \n",  __func__, __LINE__,path);
		return RTK_Fail;
    }
	if(fwrite(content, strlen(content),1, fp) != 1){
		RTK_PLAYER_INF("write fail !!!");
		fclose(fp);
		return RTK_Fail;
	}
	
	fflush(fp);
	fclose(fp);

	return RTK_OK;
}

bool RT_openTifFccFlag(RTK_Bool flag) {
	RTK_PLAYER_INF("openTifFccFlag ");
	g_is_tif_fcc = flag;
	return true;
}
