/**
    *@copyright 
    * Copyright (c) Realtek, Inc. http://www.realtek.com. All rights reserved.
    * Realtek PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
    * 
    * @file  
    * @brief  
    *
    *
    */

#ifndef __OTT_SOURCE_PLAYER_H__
#define __OTT_SOURCE_PLAYER_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef void* RTKOTT_Player_t;

/**
* @brief
* Create OTT player
*
* @param[out]		handle		 	return the OTT player handle
* @param[in]		pInitParams		reserved.
*	
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerCreate(RTKOTT_Player_t *handle, void *pInitParams);

/**
* @brief
* Destory OTT player
*
* @param[in]		handle		 	the OTT player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerDestory(RTKOTT_Player_t handle);

/**
* @brief
* Set data source.
*
* @param[in]		handle		 	the OTT player handle
* @param[in]		url		 		play source url
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerSetDataSource(RTKOTT_Player_t handle, const char* url);

/**
* @brief
* Start play.
*
* @param[in]		handle		 	the OTT player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerStart(RTKOTT_Player_t handle);

/**
* @brief
* Stop play.
*
* @param[in]		handle		 	the OTT player handle
* @param[in]		isKeepLastFrame 0:Not keep last frame, other value :keep last frame.
* 
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerStop(RTKOTT_Player_t handle, int isKeepLastFrame);

/**
* @brief
* Reset player, after reset, can set another data source.
*
* @param[in]		handle		 	the OTT player handle
*
* @retval		0			 success
* @retval		-1 			 failed
*
*/
int RTK_OTTSource_PlayerReset(RTKOTT_Player_t handle);



#ifdef __cplusplus
}
#endif

#endif