#ifndef STATUS_T_H_
#define STATUS_T_H_

typedef enum {
    OK                	= 1,    // Everything's swell.
    NO_ERROR          	= 1,    // No errors.

    UNKNOWN_ERROR		= -1,
    NO_MEMORY,
    INVALID_OPERATION,
    BAD_VALUE,
    TIME_OUT,

} status_t;

//#define NO_THREAD
#ifdef NO_THREAD
	#define MUTEX_INIT(_mtx)
	#define MUTEX_DESTROY(_mtx)
	#define MUTEX_LOCK(_mtx)
	#define MUTEX_UNLOCK(_mtx)
#else
	#include <pthread.h>
	#define MUTEX_INIT(_mtx)	do{pthread_mutex_init((_mtx), NULL);}while(0)
	#define MUTEX_DESTROY(_mtx) do{pthread_mutex_destroy((_mtx));   }while(0)
	#define MUTEX_LOCK(_mtx)	do{pthread_mutex_lock((_mtx));      }while(0)
	#define MUTEX_UNLOCK(_mtx)  do{pthread_mutex_unlock((_mtx));    }while(0)
#endif

#define RTCLIENT_BITSTREAM_BUF_SIZE	(16*1024*1024)
#define RTCLIENT_COMMAND_BUF_SIZE   (256*1024)

#endif /* STATUS_T_H_ */
