#include "realtek_player.h"

pthread_mutex_t RealtekPlayer::mutex = PTHREAD_MUTEX_INITIALIZER;
unsigned int RealtekPlayer::objectCount = 0;

void RealtekPlayer::rtk_middleware_player_callback(RTK_PLAYER_CB_TYPE_e type, void* data, void* user_param)
{
   if (NULL == user_param)
      return;

   RealtekPlayer *pRealtekPlayer = (RealtekPlayer *)user_param;
   pRealtekPlayer->middlewarePlayerCallback(type, data);
}

void RealtekPlayer::middlewarePlayerCallback(RTK_PLAYER_CB_TYPE_e type, void* data)
{
	ALOGV("%s: type = %d", __func__, type);
	switch(type)
	{
		case RTK_PLAYER_SECTION_PROGRAMINFO:
			ALOGV("%s","GET  RTK_PLAYER_SECTION_PROGRAMINFO ...  >>>>>>>>>>>");		
			memset(&mProgramInfo, 0, sizeof(mProgramInfo));
			if(RT_GetProgramInfoList(&mProgramInfo) == RTK_OK) {
				ALOGV("%s %d, get programInfoList success! element count = %d", __func__, __LINE__, mProgramInfo.program_cnt);
			}
			break;
		default:
			break;
	}
}

void RealtekPlayer::switchSource(RealtekPlayer * livePlayer, RealtekPlayer * preloadPlayer)
{
   if ((NULL != livePlayer) && (NULL != preloadPlayer)) {
      //livePlayer->removeAllSectionFilters();
      //preloadPlayer->removeAllSectionFilters();

      RTK_Player_Pause(livePlayer->m_demux);

      if (NULL != preloadPlayer->m_demux)
         RTK_Demux_SetSource(preloadPlayer->m_demux, NULL);
   
      RTK_Source source = livePlayer->m_source;
      livePlayer->m_source = preloadPlayer->m_source;
      preloadPlayer->m_source = source;

      RTK_Player_SetSource(livePlayer->m_demux, livePlayer->m_source);

      RTK_Source * rtkSource = livePlayer->m_rtkSource;
      livePlayer->m_rtkSource = preloadPlayer->m_rtkSource;
      preloadPlayer->m_rtkSource = rtkSource;
      
	  int rtkSourceNum = livePlayer->m_rtkSourceNum;
      livePlayer->m_rtkSourceNum = preloadPlayer->m_rtkSourceNum;
      preloadPlayer->m_rtkSourceNum = rtkSourceNum;

	  unsigned char tunerId = livePlayer->m_tunerId;
      livePlayer->m_tunerId = preloadPlayer->m_tunerId;
      preloadPlayer->m_tunerId = tunerId;
   }
}

RealtekPlayer::RealtekPlayer(RTKPLAYER_ARCH arch, unsigned char tunerId, bool preload) :
	RTKPlayer(arch),
	mPreloaded(false)
{
   pthread_mutex_lock(&RealtekPlayer::mutex);
   if (0 == objectCount) {
      RTK_Tuner_Init();
   }
   objectCount ++;   
   pthread_mutex_unlock(&RealtekPlayer::mutex);
   
   setTunerId(tunerId);
   setPreload(preload);
}

RealtekPlayer::~RealtekPlayer()
{
   pthread_mutex_lock(&RealtekPlayer::mutex);
   objectCount --;
   if (0 == objectCount) {
      RTK_Tuner_UnInit();
   }   
   pthread_mutex_unlock(&RealtekPlayer::mutex);	
}

RTK_Player RealtekPlayer::getPlayer(void)
{
	return m_player;
}

RTK_Player RealtekPlayer::getDemux(void)
{
	return m_demux;
}

RTK_Source RealtekPlayer::getSource(void)
{
   return m_source;
}

int RealtekPlayer::preloadPidStreams(uint16_t * pids, unsigned char total)
{
   int ret = 0;

   if (false == mPreloaded) {
      mPreloaded = true;
#if 0  // FIXME: -> section callback pool overflow !!!
      if (NULL != m_source) {
         RTK_Source_Destroy(m_source);
         m_source = NULL;
		 m_rtkSource[0] = m_source;
      }
      if(RTK_Source_Create(&m_source, m_SourceParam) != RTK_OK){
		   RTK_PLAYER_ERR("RTK_Source_Create error !");
		   return RTK_Fail;
      }
      m_rtkSource[0] = m_source;
#endif
      ret = RT_Source_PresetPidFilter(m_source, pids, total);
   }
   
   return ret;
}

RTK_Error RealtekPlayer::addSectionFilter(RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern)
{
   RTK_Error rr = RTK_Fail;

   if (NULL == m_source)
      goto end;

   //if (mPreloaded)
      //return RTK_Fail;

   if (m_preload)
      rr = RTK_Source_AddSectionFilter(m_source, filter_handle, pattern);
   else if (ARCH_DEMUX == m_arch)
      rr = RTK_Source_AddSectionFilter(m_source, filter_handle, pattern);
   else
      rr = RTK_Player_AddSectionFilter(m_demux, filter_handle, pattern);

end:
   return rr;
}

RTK_Error RealtekPlayer::removeSectionFilter(RTK_SectionFilter filter_handle)
{
   RTK_Error rr = RTK_Fail;

   if (NULL == m_source)
      goto end;

   if (m_preload)
      rr = RTK_Source_RemoveSectionFilter(m_source, filter_handle);
   else if (ARCH_DEMUX == m_arch)
      rr = RTK_Source_RemoveSectionFilter(m_source, filter_handle);
   else
      rr = RTK_Player_RemoveSectionFilter(m_demux, filter_handle);

end:
   return rr;
}

RTK_Error RealtekPlayer::removeAllSectionFilters(void)
{
   RTK_Error rr = RTK_Fail;
   
   if (NULL == m_source)
      goto end;

   if (m_preload)
      rr = RTK_Source_RemoveAllSectionFilters(m_source);
   else if (ARCH_DEMUX == m_arch)
      rr = RTK_Source_RemoveAllSectionFilters(m_source);
   else {
      // FIXME: only open/close the EMM in the live path
      // TBD: to be moved into the monitoring path
      RT_Player_setEmmPid(0, 0);
      rr = RTK_Player_RemoveAllSectionFilters(m_demux);
   }

end:
   return rr;
}

RTK_Error RealtekPlayer::addPESFilter(RTK_PESFilterPattern * pattern)
{
	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= false;
	tsSubtitleConfig.pid= pattern->pid;

    RTK_Player_RemoveSubtitle(m_demux);
	if(RTK_OK != RTK_Player_SetSubtitle( m_demux,  tsSubtitleConfig)) {
        RTK_PLAYER_ERR("RTK_Player_SetSubtitle: failed\n");
    }

	return RTK_Player_AddPESFilter(m_demux, pattern);
}


RTK_Error RealtekPlayer::removePESFilter(uint8_t u8FilterID)
{
	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= false;
	tsSubtitleConfig.pid= 0x1FFF;

    RTK_Player_RemoveSubtitle(m_demux);
	if(RTK_OK != RTK_Player_SetSubtitle( m_demux,  tsSubtitleConfig)) {
        RTK_PLAYER_ERR("RTK_Player_SetSubtitle: failed\n");
    }

   return RTK_Player_RemovePESFilter(m_demux, u8FilterID);
}

RTK_Error RealtekPlayer::getCurrentDisplayingPTS(uint64_t * pts)
{
    RTK_Error ret = RTK_Fail;
    
    if ((NULL != m_demux) && (NULL != pts)) {
       ret = RTK_Player_GetCurrentDisplayingPTS(m_demux, pts);
    }
    
    return ret;
}

RTK_Error RealtekPlayer::getCurrentDisplayingPTSInfo(RTK_PTSInfo * pts_info)
{
    RTK_Error ret = RTK_Fail;
    
    if ((NULL != m_demux) && (NULL != pts_info)) {
       ret = RTK_Player_GetCurrentDisplayingPTSInfo(m_demux, pts_info);
    }
    
    return ret;
}

RTK_Error RealtekPlayer::enableKeepLastFrameForChangeChannel(RTK_Bool enable)
{
    return RTK_Player_EnableKeepLastFrameForChangeChannel(m_demux, enable);
}

char RealtekPlayer::RT_PlayerUpTsTSFilter(TS_PSI_Program * program)
{
   if (NULL == program)
      program = mProgramInfo.psi_program;
   
	ALOGV("program . video_pids =%d , audio_id = %d	!!!\n",program->video_pids[0].pid, program->audio_pids[0].pid);
	xUpdateRecordProgram(*program);
	return RTK_OK;
}

char RealtekPlayer::RT_PlayerStart(int channelIndex)
{
	if (m_status == RTKPLAYER_STATUS_RUN) {
		return RTK_OK;
    }

    return RTKPlayer::RT_PlayerStart (channelIndex);
}

char RealtekPlayer::RT_PlayerPause(RTK_Bool enableTimeShift)
{
   (void)enableTimeShift;
	char ret;
	RTK_Player playerHandle = m_demux;
	
	if(m_arch == ARCH_DEMUX_AND_PLAY)
	{
		playerHandle = m_player;
	}
	else if(m_arch == ARCH_PLAY || m_arch == ARCH_DEMUX)
	{
		playerHandle = m_demux;
	}

	m_playerPauseFlag = RTK_TRUE;
	RTK_PLAYER_INF("m_playerPausePoint =%ld\n", m_playerPausePoint);

	ret = RTK_Player_Pause(playerHandle);
	if(ret != RTK_OK)
		RTK_PLAYER_ERR("Failed to pause av.\n");

	return ret;
}

char RealtekPlayer::RT_PlayerResume(void)
{
   return RTKPlayer::RT_PlayerResume();
}

char RealtekPlayer::RT_PlayerSetPlaySpeed(float speed)
{
   char ret;

   if (m_speed == speed) {
      ret = RTK_OK;
   }
   
   if (0 == m_speed) {
      // paused
      if (1.0 == speed) {
         RT_PlayerResume();
         m_speed = speed;
         ret = RTK_OK;    
      }
      else {
         ret = RTKPlayer::RT_PlayerSetPlaySpeed(speed);
         RT_PlayerResume();
      }
   }
   else if (1.0 == m_speed) {
      // 1x
      RT_PlayerPause();
      if (0.0 == speed) {
         m_speed = speed;
         ret = RTK_OK;    
      }
      else {
         ret = RTKPlayer::RT_PlayerSetPlaySpeed(speed);
         RT_PlayerResume();
      }
   }
   else {
      if (0.0 == speed) {
         //RT_PlayerPause();
         //ret = RTKPlayer::RT_PlayerSetPlaySpeed(1.0);
         //RT_PlayerResume();
         RT_PlayerPause();
         ret = RTK_OK;    
      }
      else {
         RT_PlayerPause();
         ret = RTKPlayer::RT_PlayerSetPlaySpeed(speed);
         RT_PlayerResume();
      }
      m_speed = speed;
   }

   return ret;
}

char RealtekPlayer::RT_PlayerGetPlaySpeed(float * speed)
{
   *speed = m_speed;
	return RTK_OK;
}

