#ifndef __REALTEK_PLAYER__
#define __REALTEK_PLAYER__

#include "rtk_player.h"
#include <pthread.h>

#ifdef __cplusplus


class RealtekPlayer : public RTKPlayer
{
public:
    static void rtk_middleware_player_callback(RTK_PLAYER_CB_TYPE_e type, void* data, void* user_param);
    static void switchSource(RealtekPlayer * livePlayer, RealtekPlayer * preloadPlayer);

    RealtekPlayer(RTKPLAYER_ARCH arch=ARCH_PLAY, unsigned char tunerId = 0, bool preload = false);
	 ~RealtekPlayer();
	
    void middlewarePlayerCallback(RTK_PLAYER_CB_TYPE_e type, void* data);
    RTK_Player getPlayer(void);
    RTK_Player getDemux(void);
    RTK_Source getSource(void);
    int32_t getUserData(void) { return mUserData; }
    void setUserData(int32_t userData) { mUserData = userData; }
    // FCC preload streams
    int preloadPidStreams(uint16_t * pids, unsigned char numPID);
    RTK_Error addSectionFilter(RTK_SectionFilter * filter_handle, RTK_SectionFilterMask * pattern);
    RTK_Error removeSectionFilter(RTK_SectionFilter filter_handle);
    RTK_Error removeAllSectionFilters(void);
    RTK_Error enableKeepLastFrameForChangeChannel(RTK_Bool enable);

    RTK_Error addPESFilter(RTK_PESFilterPattern * pattern);
    RTK_Error removePESFilter(uint8_t u8FilterID);
    
    RTK_Error getCurrentDisplayingPTS(uint64_t * pts);
    RTK_Error getCurrentDisplayingPTSInfo(RTK_PTSInfo * pts_info);

    char RT_PlayerUpTsTSFilter(TS_PSI_Program * program);
    char RT_PlayerStart(int channelIndex=0);
    char RT_PlayerPause(RTK_Bool enableTimeShift = RTK_FALSE);
    char RT_PlayerResume(void);
    char RT_PlayerSetPlaySpeed(float speed);
    char RT_PlayerGetPlaySpeed(float * speed);
    RTKPLAYER_STATUS getStatus(void)  { return m_status; }

protected:
   static pthread_mutex_t mutex;
   static unsigned int objectCount;

   int32_t mUserData;
   FullSacnProInfo mProgramInfo;
   bool mPreloaded;
};

#endif

#endif

