##############################################################
# Copyright (C) 2008 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
###############################################################
ENABLE_VENDOR_LIB := YES

## ENABLE_CDCA_CONFIG
ENABLE_CDCA_CONFIG := YES
ENABLE_CDCA_REMAP_ECMPID = NO
ENABLE_ALTIPROJECT_CONFIG := NO
##if BUILD_DVB_HYBRID_CUSTOMER is none or golden, compile golden
ifeq ($(BUILD_DVB_HYBRID_CUSTOMER), )
CUSTOMER := DEFAULT
else ifeq ($(BUILD_DVB_HYBRID_CUSTOMER), GOLDEN)
CUSTOMER := GOLDEN
endif

ifneq ($(filter DEFAULT GOLDEN , $(CUSTOMER)),)

LOCAL_PATH := $(call my-dir)
include $(CLEAR_VARS)
include device/realtek/proprietary/libs/rtk_libs/system/include/MakeConfig
include $(CLEAR_VARS)

$(warning "android version is $(PLATFORM_VERSION)")
ifneq ($(filter 8%,$(PLATFORM_VERSION)),)
USE_RTKHAL_IN_ANDROID8 = YES
else
USE_RTKHAL_IN_ANDROID8 = NO
endif

ifneq ($(filter 9%,$(PLATFORM_VERSION)),)
USE_RTKHAL_IN_ANDROID9 = YES
else
USE_RTKHAL_IN_ANDROID9 = NO
endif

ifneq ($(filter 10%,$(PLATFORM_VERSION)),)
USE_RTKHAL_IN_ANDROID10 = YES
else
USE_RTKHAL_IN_ANDROID10 = NO
endif

KERNEL_VERSION=$(shell grep CONFIG_LINUX_KERNEL_VERSION $(LOCAL_PATH)/../../../../../.build_config | awk '{print $$2}')
$(warning "kernel version is $(KERNEL_VERSION)")
###################################################################
HAL_PLAYER_CUSTOMER=GOLDEN
HAL_PLAYER_PATH=RTK_HAL_PLAYER_$(HAL_PLAYER_CUSTOMER)
###############################################################
#lib rtk_HalPlayer
###############################################################
include $(CLEAR_VARS)

LOCAL_MODULE := librtk_halPlayer
LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES:= \
		src/rtk_hal.cpp \
                ../RTKHAL_Base/src/RHAL_Base.cpp \

LOCAL_C_INCLUDES:= \
		device/realtek/proprietary/libs/rtk_libs/common/IPC/generate/include/system \
		device/realtek/proprietary/libs/rtk_libs/common/IPC/include \
		device/realtek/proprietary/libs/rtk_libs/common/IPC/include/xdr \
		device/realtek/proprietary/libs/rtk_libs/common/IPC/src/xdr \
		device/realtek/proprietary/libs/rtk_libs/OSAL/include \
		device/realtek/proprietary/libs/rtk_libs/OSAL/include/OSAL \
		device/realtek/proprietary/libs/RtkRpcClientServer \
		hardware/realtek \
		hardware/realtek/realtek_omx/osal_rtk \
		system/core/include/ion \
		device/realtek/proprietary/libs/RtkRpcClientServer \
		vendor/realtek/RTKHAL/Include \
		vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc \
		vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc/playlist \
		vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc \
		vendor/realtek/RTKPLAYER/RTKHAL_Base/inc \
		vendor/realtek/RTKPLAYER/$(HAL_PLAYER_PATH)/inc \
		device/realtek/proprietary/libs/libRTKExtractor/RTKExtractor/common/IPC/generate/include/system \
    		device/realtek/proprietary/libs/libRTKExtractor/RTKExtractor/Filters/NavigationFilter/IOPlugins \
		device/realtek/proprietary/libs/rtk_libs/common \
    		device/realtek/proprietary/libs/rtk_libs/common/IPC/generate/include/system \
    		device/realtek/proprietary/libs/rtk_libs/common/IPC/include \
		bionic \
		device/realtek/proprietary/libs/Include \
		system/core/include/cutils \
		vendor/realtek/RTKHAL/Extra/AndroidLayerProxy \
                vendor/realtek/RTKHAL/Extra/AndroidLayerProxy/RtkHalNativeAudioRedirect \
		hardware/realtek \
		device/realtek/proprietary/libs/rtk_libs/OSAL/include \
		device/realtek/proprietary/libs/rtk_libs/OSAL/include/OSAL \
		device/realtek/frameworks/services/jni/NativeHDMICallback \

LOCAL_STATIC_LIBRARIES := \
    libcutils \
    
LOCAL_SHARED_LIBRARIES := \
		liblog \
		libRtkRpcClientServer \
		librtksdk \
		libion \
		libutils \
        
		
ifeq ($(filter YES, $(USE_RTKHAL_IN_ANDROID9) $(USE_RTKHAL_IN_ANDROID10)),)
LOCAL_SHARED_LIBRARIES += \
    libRtkHDMICallbackNative \
    libRTKAoutUtil \
    libRTKHDMIControl \
    libRTKVoutUtil \
    libRTKSetupClass
endif


LOCAL_CFLAGS := -DANDROID
LOCAL_CFLAGS += -D__RTKPLAYER_SUPPORT_MULTIPROCESS__
LOCAL_CFLAGS += -DENABLE_2ND_AUDIO_FILTER
LOCAL_CFLAGS += -DENABLE_DATAFEED_CACHED
LOCAL_CFLAGS += -DENABLE_SOURCE_FILTER

ifeq ($(KERNEL_VERSION), kernel_4.14)
LOCAL_CFLAGS += -DION_MACH_LINUX4P14
endif

ifeq ($(USE_RTKHAL_IN_ANDROID9),YES)
LOCAL_VENDOR_MODULE := true
LOCAL_C_INCLUDES += device/realtek/video/rvsd/hercules
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/libSidebandClient/inc
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_C_INCLUDES += system/core/libcutils/include
LOCAL_C_INCLUDES += system/core/libion/include \
		device/realtek/proprietary/libs/hardware/VoutUtil \
		device/realtek/proprietary/libs/HDMILib  \

LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libSidebandClient
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui \
			libVoutUtil_internal \
			libHDMILib \

LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9


else ifeq ($(USE_RTKHAL_IN_ANDROID10),YES)
LOCAL_VENDOR_MODULE := true
LOCAL_C_INCLUDES += device/realtek/video/rvsd/hercules
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/libSidebandClient/inc
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_C_INCLUDES += system/core/libcutils/include
LOCAL_C_INCLUDES += system/core/libion/include
LOCAL_C_INCLUDES += frameworks/native/include
LOCAL_C_INCLUDES += system/core/libion
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/ext_rtk_ion
LOCAL_C_INCLUDES += system/libhidl/transport/token/1.0/utils/include
LOCAL_SHARED_LIBRARIES += librtk_ion_util
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libext_rtk_ion
LOCAL_SHARED_LIBRARIES += libSidebandClient
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui
LOCAL_SHARED_LIBRARIES += android.hardware.graphics.bufferqueue@1.0
LOCAL_SHARED_LIBRARIES += android.hardware.graphics.bufferqueue@2.0
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
else
LOCAL_SHARED_LIBRARIES += libgui
endif
LOCAL_CFLAGS += $(DEFINES)
#LOCAL_CFLAGS += -DENABLE_PIP
ifeq ($(PLATFORM_VERSION), 6.0.1)
LOCAL_CFLAGS += -DNATIVE_WINDOW_API_RTK_VIDEO2=7
endif
LOCAL_CFLAGS += -DLOG_TAG=\"RTKPLAYER\"

ifeq ($(USE_RTK_EXTRACTOR),true)
LOCAL_CFLAGS += -DUSE_RTK_EXTRACTOR
endif

ifeq ($(USE_RTKHAL_IN_ANDROID8),YES)
LOCAL_C_INCLUDES += device/realtek/video/rvsd/hercules
LOCAL_C_INCLUDES += vendor/realtek/libs/libSidebandClient/inc
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += system/core/libcutils/include
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libSidebandClient
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID8
endif

ifeq ($(USE_RTKHAL_IN_ANDROID9),YES)
LOCAL_VENDOR_MODULE := true
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_C_INCLUDES += system/core/libcutils/include
LOCAL_C_INCLUDES += system/core/libion/include
LOCAL_C_INCLUDES += device/realtek/video/rvsd/hercules
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/libSidebandClient/inc
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libSidebandClient
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9
else ifeq ($(USE_RTKHAL_IN_ANDROID10),YES)
LOCAL_VENDOR_MODULE := true
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_C_INCLUDES += system/core/libcutils/include
LOCAL_C_INCLUDES += system/core/libion/include
LOCAL_C_INCLUDES += device/realtek/video/rvsd/hercules
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/libSidebandClient/inc
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libSidebandClient
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
else
LOCAL_SHARED_LIBRARIES += libgui
endif

LIBVERSION:=\"$(shell cd $(LOCAL_PATH);git log -1 --format=%h_%cd --date=format:'%Y%m%d_%H:%M:%S_Android'$(PLATFORM_VERSION))\\n\"
$(warning "the librtk_halPlayer_$(HAL_PLAYER_CUSTOMER)_version_ is$(LIBVERSION)")
LOCAL_CFLAGS     += -DEXTERN_FUNC_NAME=$(LOCAL_MODULE)_getGitSha
LOCAL_CFLAGS     += -DGIT_VERSION=\"$(LOCAL_MODULE)_$(HAL_PLAYER_CUSTOMER)_version_\"$(LIBVERSION)
LOCAL_SRC_FILES  += ../.RTKRevision.cpp

LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V1=$(RTKPLAYER_ARCH_V1)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V2=$(RTKPLAYER_ARCH_V2)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V3=$(RTKPLAYER_ARCH_V3)

ifeq ($(RTKPLAYER_ARCH_VER), )
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_V3)
else 
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_VER)
endif

include $(BUILD_SHARED_LIBRARY)
##############################################################
#bin RTK_HAL_PLAYER_TEST
###############################################################
include $(CLEAR_VARS)

LOCAL_MODULE:= RTK_HAL_PLAYER_TEST
LOCAL_MODULE_TAGS := optional
LOCAL_CFLAGS := -DENABLE_2ND_AUDIO_FILTER

LOCAL_SRC_FILES:= \
		../RTKHAL_Base/src/rtk_UDP_hal.cpp \
		../RTKHAL_Base/src/rtk_hal_test_util.cpp 
		
ifeq ($(RTKPLAYER_ARCH_VER), )
LOCAL_SRC_FILES += src/rtk_hal_test_v3.cpp
else 

ifeq ($(RTKPLAYER_ARCH_VER), $(RTKPLAYER_ARCH_V1))
LOCAL_SRC_FILES += src/rtk_hal_test_v1.cpp
endif

ifeq ($(RTKPLAYER_ARCH_VER), $(RTKPLAYER_ARCH_V2))
LOCAL_SRC_FILES += src/rtk_hal_test_v2.cpp
endif

ifeq ($(RTKPLAYER_ARCH_VER), $(RTKPLAYER_ARCH_V3))
LOCAL_SRC_FILES += src/rtk_hal_test_v3.cpp
endif
endif

LOCAL_C_INCLUDES:= \
                vendor/realtek/RTKHAL/Include \
                vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc \
                vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc \
                vendor/realtek/RTKPLAYER/$(HAL_PLAYER_PATH)/inc \
		vendor/realtek/RTKPLAYER/RTKHAL_Base/inc \
		system/core/include/ion

ifeq ($(USE_RTKHAL_IN_ANDROID9), YES)
LOCAL_C_INCLUDES += system/core/include
endif

LOCAL_SHARED_LIBRARIES:= \
        liblog \
        librtksdk \
	libion \
	librtk_halPlayer \


ifeq ($(KERNEL_VERSION), kernel_4.14)
LOCAL_CFLAGS += -DION_MACH_LINUX4P14
endif

ifeq ($(USE_RTKHAL_IN_ANDROID8),YES)
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libgui
LOCAL_SHARED_LIBRARIES += libui
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID8
endif

ifeq ($(USE_RTKHAL_IN_ANDROID9), YES)
LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui

ifeq ($(ENABLE_DVB_HYBRID_WITH_SVP), true)
LOCAL_SHARED_LIBRARIES += libteec
LOCAL_CFLAGS += -DENABLE_DVB_HYBRID_WITH_SVP
endif

endif

ifeq ($(USE_RTKHAL_IN_ANDROID10), YES)
LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
LOCAL_C_INCLUDES += device/realtek/proprietary/libs/rtk_ion
LOCAL_C_INCLUDES += vendor/realtek/libs/gui_rtk/include
LOCAL_C_INCLUDES += frameworks/native/opengl/include
LOCAL_SHARED_LIBRARIES += librtk_ion
LOCAL_SHARED_LIBRARIES += librtk_ion_util
LOCAL_SHARED_LIBRARIES += libgui_rtk
LOCAL_SHARED_LIBRARIES += libui

ifeq ($(ENABLE_DVB_HYBRID_WITH_SVP), true)
LOCAL_SHARED_LIBRARIES += libteec
LOCAL_CFLAGS += -DENABLE_DVB_HYBRID_WITH_SVP
endif

endif

ifeq ($(ENABLE_ALTIPROJECT_CONFIG), YES)
LOCAL_CFLAGS += -DENABLE_ALTIPROJECT
LOCAL_C_INCLUDES += vendor/realtek/AltiProject/alti_client/Inc \
                        vendor/realtek/AltiProject/Util/Inc
LOCAL_SHARED_LIBRARIES += libaltiproject_client
endif

ifeq ($(ENABLE_VENDOR_LIB), YES)
LOCAL_CFLAGS += -DENABLE_SC
LOCAL_CFLAGS += -DENABLE_CDCA
#LOCAL_CFLAGS += -DENABLE_REMAP_ECMPID
LOCAL_C_INCLUDES += vendor/realtek/CDCA/CDCAClient/Inc \
			vendor/realtek/CDCA/CDCAPorting/Inc \
			vendor/realtek/CDCA/Util/Inc \
         vendor/realtek/RTKPLAYER/Rtk_CaIntf/include \
			vendor/realtek/CDCA/CDCAClient/Inc \
			device/realtek/proprietary/libs/RtkRpcClientServer \

LOCAL_SHARED_LIBRARIES += libcdca_client
LOCAL_SHARED_LIBRARIES += libcdca_casIntf
LOCAL_STATIC_LIBRARIES += libcdcas
else  #ifeq ($(ENABLE_VENDOR_LIB), YES)
ifeq ($(ENABLE_CDCA_CONFIG),YES)
ENABLE_SC = NO
ifeq ($(ENABLE_CDCA_REMAP_ECMPID), YES)
	LOCAL_CFLAGS += -DENABLE_REMAP_ECMPID
endif
LOCAL_CFLAGS += -DENABLE_CDCA
LOCAL_C_INCLUDES += vendor/realtek/CDCA/CDCAClient/Inc \
			vendor/realtek/CDCA/CDCAPorting/Inc \
			vendor/realtek/CDCA/Util/Inc \
                        vendor/realtek/RTKPLAYER/Rtk_CaIntf/include \
			vendor/realtek/CDCA/CDCAClient/Inc \
			device/realtek/proprietary/libs/RtkRpcClientServer \

#LOCAL_SHARED_LIBRARIES += libcdca_client
LOCAL_SHARED_LIBRARIES += libcdca_casIntf
#LOCAL_STATIC_LIBRARIES += libcdcas

ifeq ($(ENABLE_SC), YES)
LOCAL_CFLAGS += -DENABLE_SC
LOCAL_C_INCLUDES += vendor/realtek/CDCA/Include/SC
else
LOCAL_C_INCLUDES += vendor/realtek/CDCA/Include/NSC
endif
endif
endif  #ifeq ($(ENABLE_VENDOR_LIB), YES)

LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V1=$(RTKPLAYER_ARCH_V1)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V2=$(RTKPLAYER_ARCH_V2)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V3=$(RTKPLAYER_ARCH_V3)

ifeq ($(RTKPLAYER_ARCH_VER), )
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_V3)
else 
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_VER)
endif
include $(BUILD_EXECUTABLE)

###############################################################
endif ##end_of_ifeq ($(BUILD_DVB_HYBRID_CUSTOMER), GOLDEN)

###########################################################
