/*****************************************************************************
 * Copyright (c) Realtek, Inc. http://www.realtek.com. All rights reserved.
 * Realtek PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Description:
 * Note:
 *****************************************************************************/

#include <stdio.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <math.h>
#include <sys/time.h>
#ifdef ANDROID
#include <cutils/properties.h>
#endif

#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10) || defined(ENABLE_GLINUX_RTK_PORTING)
#include <rtk_ion.h>
#else
#include <ion.h> 
#endif

#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10)
#include <SidebandClient.h>
#endif


#include <sys/un.h>
#include <sys/socket.h>
#include "rtk_customer_interface.h"

#include "../inc/rtk_hal.h"
#include "rtk_hal_base.h"
#include "rtk_porting_util.h"
#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10)
#else
#include "Application/AppClass/AudioUtil.h"
#endif

#include "RHAL_Base.h"


#define RTKHAL_INF_EN
#define RTKHAL_WRN_EN
#define RTKHAL_ERR_EN

#ifdef RTKHAL_INF_EN
    #ifdef ANDROID
    #define RTKHAL_INF(fmt, args...)          ALOGD("[RTKHAL][INF]" fmt, ##args)
    #else
    #define RTKHAL_INF(fmt, args...)          printf("[RTKHAL][INF]" fmt, ##args)
    #endif
#else
    #define RTKHAL_INF(fmt, args...)
#endif

#ifdef RTKHAL_WRN_EN
    #ifdef ANDROID
    #define RTKHAL_WRN(fmt, args...)          ALOGW("[RTKHAL][WRN]" fmt, ##args)
    #else
    #define RTKHAL_WRN(fmt, args...)          printf("[RTKHAL][WRN]" fmt, ##args)
    #endif
#else
    #define RTKHAL_WRN(fmt, args...)
#endif

#ifdef RTKHAL_ERR_EN
    #ifdef ANDROID
    #define RTKHAL_ERR(fmt, args...)          ALOGE("[RTKHAL][ERR]" fmt, ##args)
    #else
    #define RTKHAL_ERR(fmt, args...)          printf("[RTKHAL][ERR]" fmt, ##args)
    #endif
#else
    #define RTKHAL_ERR(fmt, args...)
#endif

#define DBMSWITCHTODBMV     49
#define DBSWITCHTODBM           (0.01)


class CustomerRHAL: public RHAL_Base {

public:
	static CustomerRHAL* getInstance();
	static void deleteInstance();
	~CustomerRHAL()
	{
		RTKHAL_INF("[%s:%s]: enter\n", __FILE__, __func__);
		RTKHAL_INF("[%s:%s]: exit\n", __FILE__, __func__);
	};

	
private:
	static CustomerRHAL* m_pSingleton;
	CustomerRHAL() ;   
	CustomerRHAL(const CustomerRHAL& obj) = delete; 
	CustomerRHAL& operator=(const CustomerRHAL& obj) = delete; 

};

CustomerRHAL* CustomerRHAL::m_pSingleton = NULL;
static pthread_mutex_t mtx=PTHREAD_MUTEX_INITIALIZER;
CustomerRHAL* CustomerRHAL::getInstance()
{
	pthread_mutex_lock(&mtx);
	if(m_pSingleton == NULL)
	{
		m_pSingleton = new CustomerRHAL();
	}
	pthread_mutex_unlock(&mtx);
	return m_pSingleton;
}

void CustomerRHAL::deleteInstance()
{
	if(m_pSingleton)
	{
		RTKHAL_INF("[%s:%s]: ~delete delete delete !!!\n", __FILE__, __func__);
		delete m_pSingleton;
		m_pSingleton=NULL;
	}
}
CustomerRHAL::CustomerRHAL():RHAL_Base(2)
{
	RTKHAL_INF("[%s:%s]: enter\n", __FILE__, __func__);
	RTKHAL_INF("[%s:%s]: exit\n", __FILE__, __func__);
}

RHAL_Base * RHAL_GetHalInstance(void)
{
	return (RHAL_Base *)(CustomerRHAL::getInstance());
}

void RHAL_HalInstanceCleanup(void)
{
	CustomerRHAL::deleteInstance();
}


/***************************************************************************
*    C wrapper functions
*
****************************************************************************/


