/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name	: av_test.cpp
** @Version		: V2.0
** @Author		: mulderlance
** @Created		: 2016-07-21
** @Description	: Realtek porting init related func porting-API declaration
**-------------------------------------------------------------------------------
*/
#if (RTKPLAYER_ARCH_VER==RTKPLAYER_ARCH_V1)
#include <pthread.h>
#include "rtk_hal_test.h"
#include <sys/file.h>

#ifdef ANDROID
//#include "rtk_porting_rvsdSocket.h"
#include <cutils/properties.h>
#endif

#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10) 
//#include <rtk_ion.h>
#else
//#include <ion.h> 
#endif


#include "rtk_TCPReceiver.h"
#include "rtk_UDPReceiver.h"
#include "rtk_UDP_hal.h"
#include "rtk_hal_test_util.h"

#include "rtk_hal.h"
#include <stdio.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <ctype.h>


#ifdef ENABLE_DVB_HYBRID_WITH_SVP
#include <rtk_ion.h>
#ifdef __cplusplus
extern "C" {
#endif
#include "tee_client_api.h"
#include "tee_client_api_extensions.h"

#ifdef __cplusplus
}
#endif

#endif //end of ENABLE_DVB_HYBRID_WITH_SVP

#undef  UNUSED
#define UNUSED(x)	((void)(x))	/* to avoid warnings */

struct timeval startzaping_1, endzaping_1;
double zapingtimeuse_1 =0;
struct timeval startzaping_2, endzaping_2;
double zapingtimeuse_2 =0;

#define DEMUX_TEST_REC (0)

long g_rec_size = 500;
static bool gStopPlayTest = false;

#if 1

#define FILE_NAME_1	   ""
#define FILE_NAME_2	   ""
#define FILE_NAME_3	   ""

#define CHANNEL1_PCR_PID     	(3030)
#define CHANNEL1_VIDEO_PID     	(3030)
#define CHANNEL1_AUDIO_PID     	(3031)
#define CHANNEL1_PMT_PID 		(1303)
#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_H264)
#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AC3)

#define CHANNEL2_PCR_PID     	(4001)
#define CHANNEL2_VIDEO_PID     	(4001)
#define CHANNEL2_AUDIO_PID    	(4002)
#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_H265)
#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_MPEG2)

#define CHANNEL1_MULTI_PCR_PID     		(1010)
#define CHANNEL1_MULTI_VIDEO_PID     	(1010)
#define CHANNEL1_MULTI_AUDIO_PID     	(1011)
#define CHANNEL1_MULTI_AUDIO_EX_0_PID	(1012)
#define CHANNEL1_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
#define CHANNEL1_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
#define CHANNEL1_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#define CHANNEL2_MULTI_PCR_PID     		(2050)
#define CHANNEL2_MULTI_VIDEO_PID     	(2050)
#define CHANNEL2_MULTI_AUDIO_PID     	(2051)
#define CHANNEL2_MULTI_AUDIO_EX_0_PID	(2052)
#define CHANNEL2_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
#define CHANNEL2_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
#define CHANNEL2_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#else
//-----------------------------------------------------------------------------
//	quick setting
//-----------------------------------------------------------------------------
#if 1
	#define FILE_NAME_1	   "/data/ts18.ts"
	#define FILE_NAME_2	   "/data/zhouhuajian.ts"

	#define CHANNEL1_FLOW_NO       (0)
	#define CHANNEL1_PCR_PID     (3030)
	#define CHANNEL1_VIDEO_PID     (3030)
	#define CHANNEL1_AUDIO_PID     (3031)
	#define CHANNEL1_PMT_PID 		(1303)
	#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_H264)
	#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AC3)

	#define CHANNEL2_FLOW_NO       (1)
	#define CHANNEL2_PCR_PID     (0x1FF)
	#define CHANNEL2_VIDEO_PID     (0x100)
	#define CHANNEL2_AUDIO_PID     (0x110)
	#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_AAC)

	#define CHANNEL1_MULTI_PCR_PID     		(1010)
	#define CHANNEL1_MULTI_VIDEO_PID     	(1010)
	#define CHANNEL1_MULTI_AUDIO_PID     	(1011)
	#define CHANNEL1_MULTI_AUDIO_EX_0_PID	(1012)
	#define CHANNEL1_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL1_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
	#define CHANNEL1_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)
		
	#define CHANNEL2_MULTI_PCR_PID     		(2050)
	#define CHANNEL2_MULTI_VIDEO_PID     	(2050)
	#define CHANNEL2_MULTI_AUDIO_PID     	(2051)
	#define CHANNEL2_MULTI_AUDIO_EX_0_PID	(2052)
	#define CHANNEL2_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
	#define CHANNEL2_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#else
	#define FILE_NAME_1	   "/mnt/media_rw/B296-1EA3/zhou_hwa_jian.ts"
	#define FILE_NAME_2	   "/mnt/media_rw/B296-1EA3/tian_xian_pei.ts"

	#define CHANNEL1_FLOW_NO       (0)
	#define CHANNEL1_PCR_PID     (0x100)
	#define CHANNEL1_VIDEO_PID     (0x100)
	#define CHANNEL1_AUDIO_PID     (0x110)
	#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AAC)

	#define CHANNEL2_FLOW_NO       (1)
	#define CHANNEL2_PCR_PID     (0x200)
	#define CHANNEL2_VIDEO_PID     (0x200)
	#define CHANNEL2_AUDIO_PID     (0x28A)
	#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_MPEG2)
#endif
#endif

static pthread_t RTKChannelChangeThread;
//static pthread_t RTKRecordThread;

static pthread_t RTKTrickPlayControlThread;


static pthread_mutex_t gPlayerMutex = PTHREAD_MUTEX_INITIALIZER;
#define PLAYER_LOCK()		{ pthread_mutex_lock(&gPlayerMutex); }
#define PLAYER_UNLOCK()	{ pthread_mutex_unlock(&gPlayerMutex); }


static pthread_mutex_t gPlayerMutex_2 = PTHREAD_MUTEX_INITIALIZER;
#define PLAYER_2_LOCK()		{ pthread_mutex_lock(&gPlayerMutex_2); }
#define PLAYER_2_UNLOCK()	{ pthread_mutex_unlock(&gPlayerMutex_2); }


static RTK_Bool gThreadExit = RTK_FALSE;
static pthread_mutex_t gThreadExitMutex = PTHREAD_MUTEX_INITIALIZER;
#define THREAD_EXIT_LOCK()		{ pthread_mutex_lock(&gThreadExitMutex); }
#define THREAD_EXIT_UNLOCK()	{ pthread_mutex_unlock(&gThreadExitMutex); }

static RTK_Bool gThreadExit_2 = RTK_FALSE;
static pthread_mutex_t gThreadExitMutex_2 = PTHREAD_MUTEX_INITIALIZER;
#define THREAD_EXIT_LOCK_2()		{ pthread_mutex_lock(&gThreadExitMutex_2); }
#define THREAD_EXIT_UNLOCK_2()	{ pthread_mutex_unlock(&gThreadExitMutex_2); }


#define  WAIT_TIME_SECOND 40
#define  SECTIONFILTER_TEST_WAIT_TIME_SECOND 120

#define TUNNER_ZAPPING_MODE    (0)
#define MTP_AUDIO_CHANGE	(0)
#define TIMESHIFT_SWITCH_SEC (10)



//for pvr test
FILE *pvr_ts_fp_player = NULL;
FILE *pvr_pts_fp_player = NULL;
FILE *pvr_frame_fp_player = NULL;
FILE *pvr_pcr_fp_player = NULL;
static char timeshift_path[]="/data/timeshift.ts";



#if (MTP_AUDIO_CHANGE)
RTK_PlayerConfig config2;
INT64_T time0, time1;
#endif

//static RTK_DemuxConfig Config_demux;

typedef struct
{
	RTK_Bool eof_reached;
}
PlayerStatus;

static RTK_SectionFilterMask SectionFilterPattern0, SectionFilterPattern1,SectionFilterPattern2,SectionFilterPattern3_1,SectionFilterPattern3_2;
RTK_SectionFilter filter_handle0, filter_handle1,filter_handle2,filter_handle3_1,filter_handle3_2;
static RTK_PlayerConfig Config_1, Config_2, Config_3;
PlayerStatus player_status_1;
PlayerStatus player_status_2;
PlayerStatus player_status_3;
RTK_Player gPlayer_1 = NULL;
RTK_Player gPlayer_2 = NULL;
RTK_Player gPlayer_3 = NULL;

static RTK_CAS_Type_e gCASType = RTK_CAS_TYPE_NONE;// RTK_CAS_TYPE_NAGRA_TKL ;
	
unsigned short channel_number =0;
#define MAX_ERROR_CONCEALMENT_LEVEL 4096

typedef struct
{
  int pmt_index;
  int video_in_pmt_index;
  int audio_in_pmt_index;  
}Prog_List;

//for function x_read_input_data parameter input_type, used for file and iptv
typedef enum
{
	FILE_INPUT = 0,
	UDP_INPUT,
	TCP_INPUT,
	TUNER_INPUT,	//reserved, not use
}INPUT_TYPE_e;

//for function x_read_input_data parameter souce_info
typedef struct
{
	FILE *fp;					//for FILE_INPUT
	uint32_t totalFileSize;		//for FILE_INPUT
	UDPReceiver* udp_receive;	//for UDP_INPUT
	TCPReceiver* tcp_receive;	//for TCP_INPUT
	RTK_Codec video_codec_type;
	RTK_Bool filePlay_once;		//this flag TRUE means playing file only once, not circularly
	RTK_Bool cEncrypted;		// RTK_TRUE means file is Encrypted else is not
}INPUT_SOURCE_t;

typedef enum
{
	UNENCRYPT = 0,
	AV_ENCRYPT,
	VIDEO_ENCRYPT,
	AUDIO_ENCRYPT,
}RTK_ENCRYPT_t;

TS_Program_Info m_programInfo;
bool m_isMonitorPAT = 0;
static int m_recvProgramCnt = 0;
INPUT_SOURCE_t input_info;
RTK_SectionFilter m_pmtHandle[PROGRAME_CNT];
uint16_t m_pmtFilterPID[PROGRAME_CNT];

pthread_t waitPMTThread;
RTK_VideoConfig video_config;
RTK_AudioConfig audio_config;
unsigned short pcr_pid=-1;
Prog_List prog_list[64]={{0,0,0}};	
static int file_play_status = 0;
RTK_SectionFilter patHandle;
RTK_SectionFilterMask patPattern;
RTK_SectionFilter catHandle;
RTK_SectionFilterMask catPattern;
static int waitpmt = 1;

//before RTK_Player_FeedInputBuffer, call x_read_input_data to read data from file or iptv
//#define myPrintf(fmt, args...) printf(fmt, ##args)
#define myPrintf(fmt, args...) 
void SectionCallback(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam);
char xAddPMT(uint16_t pid);
void xRemovePMT(RTK_SectionFilter handle);
RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec);
RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec);
void xChangeAvParm(int select_index);
void ThreadWaitPMT();
void* ThreadWaitPMTEntry(void* instance);
void xAddPAT(void);
void xRemovePAT(void);
RTK_ENCRYPT_t isScramble(int index,int video_index,int audio_index);
const char* StrScramble(int index,int video_index,int audio_index);


#if 0
static int64_t pli_getMilliseconds()
{
    struct timespec tp;
    clock_gettime(CLOCK_MONOTONIC, &tp);

    return (int64_t)tp.tv_sec * 1000 + tp.tv_nsec / 1000000;
}
#endif

void rtk_test_create_winSurface(RTK_WinPlane rtk_win_plane, int x_pos, int y_pos, int width, int height)
{
	//create window
	RTK_WinConfig rtk_win_config;
	rtk_win_config.plane = rtk_win_plane;
	rtk_win_config.pos_x = x_pos;
	rtk_win_config.pos_y = y_pos;
	rtk_win_config.width = width;
	rtk_win_config.height = height;
	RTK_CreateSurface(rtk_win_config);
}

static void section_callback0(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle,enStatus, section[0], length, userParam);
}

static void section_callback1(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static void section_callback2(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static void section_callback3(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(enStatus); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	//printf("%s() handle=%p, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, section[0], length, userParam);
}

static void section_callback3_1(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);UNUSED(enStatus);;	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static volatile int flag_recieved_PAT = 0;
static void section_callback5(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
	flag_recieved_PAT = 1;
}





static uint32_t x_read_input_data(INPUT_TYPE_e input_type, INPUT_SOURCE_t souce_info,RTK_TSInputBuffer *ibuffer)
{
	myPrintf("**********x_read_input_data enter, input_type==%d**********\n",input_type);
	uint32_t rtkBufferRemainSize = 0;
	rtkBufferRemainSize = (int) ((int)ibuffer->end - (int)ibuffer->memory); //this remainSize do not include ring cycle start part
	//printf("buffer->end=%d buffer.memory=%d,rtkBufferRemainSize=%d\n\n",(int)ibuffer->end,(int)ibuffer->memory,rtkBufferRemainSize);
	myPrintf("rtkBufferRemainSize=%uB,%uKB buffer.size==%uB, %uKB \n",rtkBufferRemainSize,rtkBufferRemainSize/1024,ibuffer->size,ibuffer->size/1024);

	if(input_type == FILE_INPUT)
	{
		if(!souce_info.fp)
			return RTK_Fail;

		if(souce_info.totalFileSize == (uint32_t)-1) // don't care when timeshift
		{
			ibuffer->filled_size = fread(ibuffer->memory, 1, ibuffer->size, souce_info.fp);
			if(ibuffer->filled_size < ibuffer->size)
			{
				ibuffer->isLast = RTK_TRUE;
			}
		}
	    else	
	    {
			myPrintf("file totalFileSize==%u\n",souce_info.totalFileSize);
		
			uint32_t remainFileSize =0;
			remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);			

			if(remainFileSize<188 && remainFileSize>0)
			{
				//printf("remain datasize: %d, packet is incomplete,discard\n",remainFileSize);
				if(souce_info.filePlay_once == RTK_TRUE)
				{
					ibuffer->filled_size = 0;
					ibuffer->isLast = RTK_TRUE;
					printf("buffer->isLast==%d \n",ibuffer->isLast);
					return RTK_Fail;
				}
				else if(souce_info.filePlay_once == RTK_FALSE)
				{
					//printf("...............................................play again...........................................\n");
					fseek(souce_info.fp, 0, SEEK_SET);
					remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);
				}				
			}
			//printf("get ibuffer.size==%uB, %uKB\n",ibuffer->size,ibuffer->size/(1024));
			//printf("file unplay size==%uB, %uKB\n",remainFileSize,remainFileSize/(1024));	             

	 		if(ibuffer->size < 188)
			{
			 	//printf("buffer lower than 188, discard this time\n");  
				return RTK_Fail;
			}
			
			if(ibuffer->size > remainFileSize)			
				ibuffer->filled_size = remainFileSize;			
			else 
				 ibuffer->filled_size = ibuffer->size;
			
			if (RTK_TRUE == souce_info.cEncrypted)
			{
				uint32_t read_ret = 0;
				read_ret = fread(ibuffer->memory, 1, ibuffer->filled_size, souce_info.fp);
				ibuffer->isLast = (feof(souce_info.fp) || (souce_info.totalFileSize - ftell(souce_info.fp)) == 0) ? RTK_TRUE: RTK_FALSE;
			}
			else
			{
				if(ibuffer->filled_size >=188)
				{		
					uint32_t filled_ret = 0;			
					unsigned char *pp = (unsigned char*)ibuffer->memory;
			
					while((ibuffer->filled_size - filled_ret)/188 >0 )
					{               
						fread(pp, 1, 1, souce_info.fp);
						if(pp[0] == 0x47)
						{
							fread(pp+1, 1, 187, souce_info.fp);
							filled_ret += 188;
							pp+= 188;
						}
						else
						  	continue;
			       		}
					ibuffer->filled_size =filled_ret;			
					//printf("ftell(file)==%ldB, %ldKB,feof(file)==%d\n",ftell(souce_info.fp),ftell(souce_info.fp)/1024,feof(souce_info.fp));	
				}
			}
			
			remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);
			if(remainFileSize == 0 || feof(souce_info.fp))
			{
				//printf("file end end end %d\n", ibuffer->filled_size);
				if(souce_info.filePlay_once == RTK_TRUE)
				{
					ibuffer->isLast = RTK_TRUE;
					printf("buffer->isLast==%d \n",ibuffer->isLast);
				}
				else if(souce_info.filePlay_once == RTK_FALSE)
				{
					fseek(souce_info.fp, 0, SEEK_SET);
					//printf("...............................................play again...........................................\n");
				}
			}
				
		}
		//printf("buffer->isLast==%d \n",ibuffer->isLast);
	}
	else if(input_type == TCP_INPUT || input_type == UDP_INPUT)
	{
		ibuffer->filled_size = ibuffer->size;
		
		if(souce_info.video_codec_type == RTK_CODEC_VIDEO_H265)
		{
			if(ibuffer->size < (188*8*1100))
				ibuffer->filled_size = ibuffer->size;
			else
				ibuffer->filled_size = (188*8*1100);
		}
		
		uint32_t read_ret = 0;
		{
			if(input_type == TCP_INPUT && souce_info.tcp_receive)
				read_ret  = souce_info.tcp_receive->Read((char*)ibuffer->memory, ibuffer->filled_size);	
			else if(input_type == UDP_INPUT && souce_info.udp_receive)
			{
				read_ret = souce_info.udp_receive->Read((char*)ibuffer->memory, ibuffer->filled_size);	
			}
			else
			{
				myPrintf("input_type is not supported!\n");
				return RTK_Fail;
			}
		}
		//myPrintf("[%s,%d] read_ret = %d \n", __func__, __LINE__, read_ret);
		if(read_ret  != ibuffer->filled_size )
		{
			myPrintf("[%s,%d] iptv:  read_ret  != ibuffer->filled_size\n", __func__, __LINE__);
			return RTK_Fail;
		}
	}
	myPrintf("=========read ok=========\n");
	return RTK_OK;
}

//#define CCDUMP(fmt, args...) printf(fmt, ##args)
#define CCDUMP(fmt, args...) printf(fmt, ##args)

#define CC_USERDATA_ITUT35_H264 0xB50031
#define CC_USERDATA_STARTCODE_MPEG2 0x000001B2
#define CC_USER_IDENTIFIER 0x47413934
typedef struct _CC_DATA
{
	unsigned char cc_valid;
	unsigned char cc_type;
	unsigned char cc_data1;
	unsigned char cc_data2;
} CC_DATA_T;

void _xCC_Data_Dump(const CC_DATA_T *pccData, unsigned int cc_data_count)
{
	for(unsigned int cc_data_index=0; cc_data_index<cc_data_count; cc_data_index++)
	{
		if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
		{
			CCDUMP("cc_data_index=%d:  ", cc_data_index);
			CCDUMP("cc_valid = 0x%02x, cc_type =0x%02x, cc_data1 = 0x%02x, cc_data2 = 0x%02x \n", 
				pccData[cc_data_index].cc_valid,  
				pccData[cc_data_index].cc_type,
				pccData[cc_data_index].cc_data1,
				pccData[cc_data_index].cc_data2);
		}
	}
}


static void player_callback_1(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
		
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback1 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			gettimeofday(&endzaping_1, NULL);
	 		zapingtimeuse_1 = 1000000 * (endzaping_1.tv_sec - startzaping_1.tv_sec) + (endzaping_1.tv_usec - startzaping_1.tv_usec);
			if(zapingtimeuse_1 > 0)
	 		printf("Call [rtk_fileplay_zapping] %s()  cost %f s\n", __FUNCTION__, (zapingtimeuse_1/1000000.0));

			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback1 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("player_callback1 : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
			break;			
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						if(pccData)
						{
							delete(pccData);
							pccData= NULL;
						}

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						if(pccData)
						{
							delete(pccData);
							pccData= NULL;
						}

						
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					//printf("player_callback1 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}
			break;

		default:
			printf("player_callback_1 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}

#if 1
static void player_callback_2(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
		
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback2 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			gettimeofday(&endzaping_2, NULL);
	 		zapingtimeuse_2 = 1000000 * (endzaping_2.tv_sec - startzaping_2.tv_sec) + (endzaping_2.tv_usec - startzaping_2.tv_usec);
			if(zapingtimeuse_2 > 0)
	 		printf("Call [rtk_fileplay_zapping] %s() cost %f s\n",__FUNCTION__,  (zapingtimeuse_2/1000000.0));
			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback2 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("%s(%d) player_callback2 : RTK_EOS...\n",__FUNCTION__,__LINE__);
			status->eof_reached = RTK_TRUE;
			break;
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						if(pccData)
						{
							delete(pccData);
							pccData= NULL;
						}

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						delete(pccData);
						
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					printf("player_callback1 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}

			break;
		default:
			printf("player_callback_2 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}
#endif

#if 1
static void player_callback_3(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
	
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback3 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback3 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("player_callback3 : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
			break;
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback3 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						if(pccData)
						{
							delete(pccData);
							pccData= NULL;
						}

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						delete(pccData);
						
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					printf("player_callback3 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}

			break;
		default:
			printf("player_callback_3 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}
#endif

static void player_callback_4(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	//unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
	
	switch(event)
	{
	case RTK_FIRST_IFRAME_DISPLAYED:
		printf("player_callback4 : RTK_FIRST_IFRAME_DISPLAYED...\n");
		break;
	case RTK_FIRST_AUDIO_FRAME_DECODED:
		printf("player_callback4 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
		break;
	case RTK_EOS:
		printf("player_callback4 : RTK_EOS...\n");
		status->eof_reached = RTK_TRUE;
		break;
	case RTK_FILTER_TS_DATA:
		{
			if(pvr_ts_fp_player)
			{
				fwrite( data, data_size, 1, pvr_ts_fp_player);
			}
		}
		break;
	case RTK_FILTER_TS_INDEX:	//	data -> RTK_TS_Index
	case RTK_FILTER_TS_CTRL:		//	data -> RTK_TS_Ctrl
		break;
	default:
		printf("player_callback_4 event=%d, data=%p, data_size=%u\n",event, data, data_size);
		break;
	}

	return;
			
}


void Record_callback(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{	
	//PlayerStatus * status = (PlayerStatus*)user_param;

	(void)type;	// fix compile warning
	PlayerStatus * status = (PlayerStatus*)user_param;
	
	switch(event)
	{
		case RTK_EOS:
			printf("Record_callback : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
			break;
		case RTK_FILTER_TS_DATA:
		{
			if(pvr_ts_fp_player)
			{
				fwrite( data, data_size, 1, pvr_ts_fp_player);
			}
		}
			break;
		case RTK_FILTER_TS_INDEX:
		{
			if(pvr_frame_fp_player)
			{
				fwrite(  data, data_size, 1, pvr_frame_fp_player);
			}
		}
			break;
		case RTK_FILTER_TS_CTRL:
		{
			if(pvr_pts_fp_player)
			{
				fwrite(  data, data_size, 1, pvr_pts_fp_player);
			}
		}
			break;
		case RTK_FILTER_TS_PCR:
			if(pvr_pcr_fp_player)
			{
				fwrite( data, data_size, 1, pvr_pcr_fp_player);
			}
			break;
		default:
			printf("unhandled event: %d\n", event);
			break;
	}
}

RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec)
{
	RTK_Codec eRtkVideoCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG1;
			break;
		case TS_PSI_ST_ATSC_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_13818_2_Video://TS_PSI_DT_VideoStream
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_14496_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG4_PART2;
			break;			
		case TS_PSI_ST_14496_10_Video:// TS_PSI_DT_MPEG4_Video
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexG_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexH_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_23008_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H265;
			break;
		case TS_PSI_DT_AVC:
			break;
		case TS_PSI_ST_AVS_Video:
			//eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_AVS;
			break;
		default:
			break;
	}

	return eRtkVideoCodec;
}

RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec)
{
	RTK_Codec eRtkAudioCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG1;
			break;
		case TS_PSI_ST_13818_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG2;
			break;
		case TS_PSI_ST_13818_7_AAC:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AAC;
			break;
		case TS_PSI_ST_14496_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MP4;
			break;
		case TS_PSI_ST_ATSC_AC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3;
			break;
		case TS_PSI_ST_ATSC_EAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3_PLUS;//RTK_AUDIO_CODEC_TYPE_AAC_PLUS_LOAS
			break;
		case TS_PSI_ST_ATSC_DTS:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS;
			break;
		case TS_PSI_ST_ATSC_DTS_HD:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS_HD;
			break;
		case TS_PSI_ST_DRA_Audio:
			//eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DRA;
			break;
		case TS_PSI_DT_DVB_EnhancedAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_EAC3;
			break;
		default:
			break;
	}

	return eRtkAudioCodec;
}

const char* StrScramble(int index,int video_index,int audio_index)
   {
      	 if(isScramble(index,video_index,audio_index)==UNENCRYPT)
		return "false";
	else if(isScramble(index,video_index,audio_index)==AV_ENCRYPT)
		return  "AV Both Scramble";
	else if(isScramble(index,video_index,audio_index)==VIDEO_ENCRYPT)
		return "VIDEO  Scramble";	
	else if(isScramble(index,video_index,audio_index)==AUDIO_ENCRYPT)
		return  "AUDIO  Scramble";	
	else
		return "false";	
  }

RTK_ENCRYPT_t isScramble(int index,int video_index,int audio_index)
{

    if(m_programInfo.cat_program.CasIDCount>0)
    	{    	
    	   for(int i = 0; i<m_programInfo.psi_program[index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{					  
					   return AV_ENCRYPT;
					}
		   		}
         for(int i=0;i<m_programInfo.psi_program[index].video_pids[video_index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].video_pids[video_index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{
					  return VIDEO_ENCRYPT;
					}
		   		}
	for(int i=0;i<m_programInfo.psi_program[index].audio_pids[audio_index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].audio_pids[audio_index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{
					  return AUDIO_ENCRYPT;
					}
		   		}
			
    	}
	return UNENCRYPT;
   
}

void xChangeAvParm(int select_index)
{
	
	static int vpid_bk = -1;
	static int apid_bk = -1;
	int pmt_index = prog_list[select_index].pmt_index;
	int video_index_inpmt = prog_list[select_index].video_in_pmt_index;
	int audio_index_inpmt = prog_list[select_index].audio_in_pmt_index;
	
	if((vpid_bk == m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].pid)\
		&& (apid_bk == m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].pid)&&(file_play_status ==1))
		return;
	if( m_programInfo.psi_program[pmt_index].version == 0xff) // not ready
		return;

	if( !m_programInfo.psi_program[pmt_index].received ) // not ready
		return;

	
	vpid_bk =  m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].pid;
	apid_bk =  m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].pid;
	
      Config_1.video.pid = vpid_bk;
      Config_1.video.codec = _xTS_Transfer_Video_Codec(m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].codec);
      Config_1.audio.pid = apid_bk;
      Config_1.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].codec);
      Config_1.pcr_pid = m_programInfo.psi_program[pmt_index].pcr_pid;
	  
      if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == UNENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_FALSE;
	     Config_1.audio.encrypted = RTK_FALSE;
	     input_info.cEncrypted = RTK_FALSE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == AV_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_TRUE;
	     Config_1.audio.encrypted = RTK_TRUE;
	     input_info.cEncrypted = RTK_TRUE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == VIDEO_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_TRUE;
	     Config_1.audio.encrypted = RTK_FALSE;
	     input_info.cEncrypted = RTK_TRUE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == AUDIO_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_FALSE;
	     Config_1.audio.encrypted = RTK_TRUE;
	     input_info.cEncrypted = RTK_TRUE;
      	}	  
     
      if(m_programInfo.psi_program[pmt_index].subtitle_pids[0].pid !=0)
      	{
      	 Config_1.subtitle.pid = m_programInfo.psi_program[pmt_index].subtitle_pids[0].pid;
	 Config_1.subtitle.bshow = true;
	 Config_1.subtitle.langcode = m_programInfo.psi_program[pmt_index].subtitle_pids[0].langcode;
      	
	  if(RTK_Player_SetSubtitle(gPlayer_1,Config_1.subtitle) != RTK_OK)
	   {
		printf("Failed to change subtitle.\n");
		return;
	    }

      	}
	 //chage video pid and codec
	 if(RTK_Player_ChangeVideo(gPlayer_1, &Config_1.video) != RTK_OK)
	 {
	 	printf("failed to change video.\n");
		return;
	 }			 
		
	//change audio pid and codec
	if(RTK_Player_ChangeAudio(gPlayer_1, &Config_1.audio) != RTK_OK)
	{
	    printf("Failed to change audio.\n");
		return;
	}
	
	file_play_status = 1;
	waitpmt = 0;
	
	return;
		
}

void* ThreadWaitPMTEntry(void* instance)
{
	ThreadWaitPMT();
	UNUSED(instance);
	return NULL;
}

void  ThreadWaitPMT( )
{      
        struct timeval old_time,cur_time;
	int flag = 1;
	uint32_t rc, status;
	
	memset(&old_time,0,sizeof(struct timeval));
	memset(&cur_time,0,sizeof(struct timeval));
	gettimeofday(&old_time,0);	
	
	while(flag && (waitpmt == 1))
		{
		    gettimeofday(&cur_time,0);
		   if(cur_time.tv_sec -old_time.tv_sec+(cur_time.tv_usec -old_time.tv_usec)/1000000L >= 5)
		   	flag = 0;
		}
	if(waitpmt == 1){	
	printf("\n*********************Parsed %d pmt information*********************\n",m_recvProgramCnt);
	 if(m_recvProgramCnt != m_programInfo.program_cnt   && file_play_status == 0  )//not got all pmt tables.
		{
			bzero(&prog_list, sizeof(prog_list));
                    int  play_index = 0;
		      printf("Only Parsed some pmt information\n");	
			
               	     for(int i = 0; i < m_programInfo.program_cnt;i++)
                   	 	{
                   	 	  if(m_programInfo.psi_program[i].received == true)
                    		  	{
                    	  		  // printf("*********************program information*********************\n");
					  
					    if( m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids > 0 )
					     {
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				  	  	{
				 	   	  for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    		  	{

									
							 	 printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,vcnt,acnt));
							 	 printf("program number:0x%04x   PMT_PID:0x%04x    PCR_PID:0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
				 	      		  	 printf("VPID: 0x%04x  VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
						        	 printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
				    	         	   	prog_list[play_index].pmt_index = i;
						 	 	prog_list[play_index].video_in_pmt_index=vcnt;
						  	  	prog_list[play_index].audio_in_pmt_index=acnt;
						  	 	play_index ++;
								  
				    	  		}
				    	   	 }
				    	}
					else if (m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids==0)
					{
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				    		{
				    		       	printf("\n%d) program   isScramble:%s \n",play_index,StrScramble(i,vcnt,0));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("VPID: 0x%04x   VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
							printf("Audio none\n");
				 	       		prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=vcnt;
						 	prog_list[play_index].audio_in_pmt_index=0;
						  	 play_index ++;					  
				    	     }
					}
					else if (m_programInfo.psi_program[i].num_video_pids == 0 && m_programInfo.psi_program[i].num_audio_pids > 0)
					{
						for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    	  	{
					       
				 	       		printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,0,acnt));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("Video none\n");
							printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
							prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=0;
						  	prog_list[play_index].audio_in_pmt_index=acnt;
						   	play_index ++;								  
				    	  	}
					}
							   
                    	  	}
                      }
			 if(file_play_status == 0){
			 	 int select_index;
				while(1){
					 printf("\nPlease input play index(0~%d) to play\n",play_index-1);
					 fflush(stdin);
					 scanf("%d",&select_index);					 
					 if(select_index >= 0 &&  select_index <play_index){
						 printf("\nReceive the index you to play :%d\n",select_index);							 
						 break;}						
					 }				
				 xChangeAvParm(select_index);
			 	}
			
	         }

		}
	if(waitPMTThread){
	 rc = pthread_join(waitPMTThread, (void **)&status);
		if (rc != 0)
			{
			//	printf("ERROR; return code from waitPMTThread pthread_join() is %d\n", rc);
				return;
			}
			else
			{
				waitPMTThread = 0;
			//	printf("waitPMTThread Thread joined\n");
			}
		}		
	 return ;
		
}

void SectionCallback(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	TS_PSI_header PATHeader;
	TS_PSI_header CATHeader;
	TS_PSI_header PMTheader;
	TS_SI_header SDTHeader;
	TS_PSI_Program PMTprogramInfo;
	TS_CAT_program CATprogramInfo;
	TS_PAT_program PATprogram;

	const unsigned char* sectionData = section;
	const uint32_t  sectionLen = length;
	uint32_t rc, status;
	UNUSED(enStatus);
	UNUSED(SDTHeader);
	UNUSED(userParam);

	do
	{
		if (TS_PSI_PID_PAT == sectionData[0]) //PAT
		{
			//-------------------------------------------------------------------------
			//	Parse Header info from PAT table
			//-------------------------------------------------------------------------
			int32_t numOfProgram=0, i=0,j=0,rc=-1;
			bzero(&PATHeader, sizeof(PATHeader));
			bzero(&PATprogram, sizeof(PATprogram));
			TS_PSI_getSectionHeader(sectionData, &PATHeader);
			int program_cnt_old =0; 
			
			program_cnt_old = m_programInfo.program_cnt;
			

			if (m_programInfo.pat_program.version == PATHeader.version_number)
			{

				;
				//if(!m_isMonitorPAT)
				//	printf("Received same PAT. Skip this\n");
			}
			else//need to think about pat in many section at the same version_number ,now no think
			{
				printf("**** Received new PAT **** vsersion:  old=0x%x  new= 0x%x\n",   m_programInfo.pat_program.version,PATHeader.version_number);
				m_programInfo.pat_program.version = PATHeader.version_number;	
				numOfProgram = TS_PAT_getNumPrograms(sectionData);		
				printf(" *****Received  %d NIT/PMT****\n",numOfProgram);
				//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);
				if(numOfProgram > 0){
					
					for (i = 0; i < numOfProgram; i++)
					{
						rc = TS_PAT_getProgram((const unsigned char*)sectionData, sectionLen, i,  &PATprogram);
						
						if(PATprogram.program_number == TS_PSI_TID_NETWORK) //nit table
							{
							printf("Receive one NIT table\n");
							continue;
							}
						if (!rc && PATprogram.program_number) 
						{						   
						   if(m_programInfo.program_cnt > 0)//have parsed out some program,check if same
						   {
						         int exist_flag = 0;
						         for(j = 0; j < m_programInfo.program_cnt;j++)
						         {
						      		
						      	   	if(m_programInfo.psi_program[j].program_number == PATprogram.program_number)
						      	   		{
						      	   		 exist_flag = 1;
							  		 break; //quit from this for loop
						      	   		}														   
						         }
								 
							  if(exist_flag == 0) //not in the m_programInfo.psi_program[j],add it
							  	{									
							 		m_programInfo.psi_program[m_programInfo.program_cnt].program_number = PATprogram.program_number;
									m_programInfo.psi_program[m_programInfo.program_cnt].map_pid = PATprogram.PID;
									m_programInfo.program_cnt++;
									 
							  	}							  
						   }	
						   else
						   {
						   	  m_programInfo.psi_program[m_programInfo.program_cnt].program_number = PATprogram.program_number;
							  m_programInfo.psi_program[m_programInfo.program_cnt].map_pid = PATprogram.PID;
							  m_programInfo.program_cnt++;
							  
						   }
					    }//if (!rc && PATprogram.program_number) 
					}//for (i = 0; i < numOfProgram; i++)

					//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);


					printf("*********************PAT Information*********************\n");							
					for(int i = program_cnt_old; i< m_programInfo.program_cnt; i++)
					  {
					     printf("Parsed Program PID    : 0x%04X\n", m_programInfo.psi_program[i].map_pid);
					     printf("Parsed Program number : 0x%04X\n", m_programInfo.psi_program[i].program_number);
					  }
					printf("*********************************************************\n");


					//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);

					for(int i = program_cnt_old; i< m_programInfo.program_cnt; i++)
					  {
					     xAddPMT(m_programInfo.psi_program[i].map_pid);
					  }

					
					xRemovePAT();
				    }//if(numOfProgram > 0)
				    
				}			
				
			}
		else if (TS_PSI_TID_CAT == sectionData[0]) //CAT
		{
		  // printf("#### parse CAT ##");
			//-------------------------------------------------------------------------
			//	Parse Header info from CAT table
			//-------------------------------------------------------------------------
			bzero(&CATHeader, sizeof(CATHeader));
			bzero(&CATprogramInfo, sizeof(CATprogramInfo));
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &CATHeader);

			if (m_programInfo.cat_program.version != CATHeader.version_number)
			{
				printf("#### Received new CAT ####!!oldCATVersion=0x%x,newCATVersion=0x%x \n",m_programInfo.cat_program.version,CATHeader.version_number);
				m_programInfo.cat_program.version = CATHeader.version_number;				

				//-------------------------------------------------------------------------
				//	Parse EMM PID from CAT table
				//-------------------------------------------------------------------------
				CATprogramInfo.version = CATHeader.version_number;
				TS_PSI_parseCAT((const uint8_t *)sectionData, sectionLen, &CATprogramInfo);

				printf("*********************CAT Information*********************\n");
				printf("CAT version    : 0x%04x\n", CATprogramInfo.version );
				printf("CAT CasIDCount	: 0x%04x\n", CATprogramInfo.CasIDCount );

				for(int index = 0; index <CATprogramInfo.CasIDCount;index++ )
				{
					printf("CAT cas_id[%d]: 0x%04x, EMM PID:0x%04x\n",index, CATprogramInfo.cas_id[index],CATprogramInfo.ca_pid[index] ); 
				}				
				m_programInfo.cat_program = CATprogramInfo;	
			}
			
		}	
		
		else if ( TS_PSI_TID_PMT == sectionData[0]) /* PMT */{	
			
			//-------------------------------------------------------------------------
			bzero(&PMTheader, sizeof(PMTheader));
			bzero(&PMTprogramInfo, sizeof(PMTprogramInfo));					
					
			//	parse PMT Header			
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &PMTheader );	
			 int psi_index = 0;
			//	search index in m_programInfo.psi_program[32]	
			for(psi_index=0; psi_index<m_programInfo.program_cnt; psi_index++)
			{
				//find the pmt index according to program_number
			   if(m_programInfo.psi_program[psi_index].program_number == PMTheader.table_id_extension)					
			   {
			           //check received the same version pmt
				  if(m_programInfo.psi_program[psi_index].received == true && PMTheader.version_number == m_programInfo.psi_program[psi_index].version)
				     ;	//recv the same pmt,skip				
				 else
				 {
					//Store the main information about the program				
					PMTprogramInfo.program_number	= PMTheader.table_id_extension;
					PMTprogramInfo.version			= PMTheader.version_number;
					PMTprogramInfo.pcr_pid			= TS_PMT_getPcrPid((const uint8_t *)sectionData, sectionLen);
					PMTprogramInfo.descramble_info.descramble_algorithm = DESCRAMBLE_ALGO_UNKNOW;
					//Parse programe info from PMT table
					TS_PSI_parsePMT((const uint8_t *)sectionData, sectionLen, &PMTprogramInfo);				
				
					PMTprogramInfo.map_pid = m_programInfo.psi_program[psi_index].map_pid;//add by yunlong_ma,map_pid will be covered.
					m_programInfo.psi_program[psi_index] = PMTprogramInfo;					
					if(m_programInfo.psi_program[psi_index].received == false)	
					{
						m_recvProgramCnt++;
						;//printf("*********************Parse NEW PMT*********************\n");
					}
					else
					;//printf("********************* PMT program :0x%04x Changed******************\n",m_programInfo.psi_program[psi_index].program_number);

					m_programInfo.psi_program[psi_index].received = true;	
					
					/*
					printf("Program number           : 0x%04x\n", PMTprogramInfo.program_number);
					printf("Program version           : 0x%04x\n", PMTprogramInfo.version);
					printf("Program pcrPID            : 0x%04x\n", PMTprogramInfo.pcr_pid);
					printf("Program CasIDCount      :%d\n", PMTprogramInfo.CasIDCount);

					for(int i = 0;i <  PMTprogramInfo.CasIDCount;i++)
					{
						printf("Program CA_system_ID[%d]    : 0x%04x\n", i,PMTprogramInfo.cas_id[i]);     
						printf("Program ECM_PID[%d]         : 0x%04x\n", i,PMTprogramInfo.ca_pid[i]);
					}

					printf("Program scramble_algo   : 0x%04x\n", PMTprogramInfo.descramble_info.descramble_algorithm);
					printf("Program IV_value_avai   : 0x%04x\n", PMTprogramInfo.descramble_info.IV_value_available);
					printf("Program numOfVideoPID   : 0x%04x\n", PMTprogramInfo.num_video_pids);
					printf("Program numOfAudioPID   : 0x%04x\n", PMTprogramInfo.num_audio_pids);
					printf("Program numOfOtherPID   : 0x%04x\n", PMTprogramInfo.num_other_pids);
                      		printf("Program numOfSubtitlePID   : 0x%04x\n", PMTprogramInfo.num_subtitle_pids);
					printf("=============== Video ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_video_pids; i++)
					{
						printf("Program %d'th VideoES_PID: 0x%04x\n", i, PMTprogramInfo.video_pids[i].pid);
						printf("Program %d'th Video_Codec: 0x%04x\n", i, PMTprogramInfo.video_pids[i].codec);
											
						for (int j = 0; j < PMTprogramInfo.video_pids[i].CasIDCount; j++)
						{
							printf("video Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.video_pids[i].cas_id[j]);
							printf("video Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.video_pids[i].ca_pid[j]);                        
						}
					}

					printf("=============== Audio ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_audio_pids; i++)
					{
						printf("Program %d'th AudioES_PID: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].pid);
						printf("Program %d'th Audio_Codec: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].codec);

						
						for (int j = 0; j < PMTprogramInfo.audio_pids[i].CasIDCount; j++)
						{
							printf("audio Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.audio_pids[i].cas_id[j]);
							printf("audio Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.audio_pids[i].ca_pid[j]);                        
						}

					}
					printf("=============== Others ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_other_pids; i++)
					{
						printf("Program %d'th OtherES_PID : 0x%04x\n", i, PMTprogramInfo.other_pids[i].pid);
						printf("Program %d'th Other_stream: 0x%04x\n", i, PMTprogramInfo.other_pids[i].stream_type);
						
						for (int j = 0; j < PMTprogramInfo.other_pids[i].CasIDCount; j++)
						{
							printf("audio Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.other_pids[i].cas_id[j]);
							printf("audio Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.other_pids[i].ca_pid[j]);                        
						}
					}

                  		  	printf("=============== Subtilte===============\n");

					for (int i = 0; i < PMTprogramInfo.num_subtitle_pids; i++)
					{
						printf("Program %d'th num_subtitle_pids : 0x%04x\n", i, PMTprogramInfo.subtitle_pids[i].pid);
					
					}
					printf("***********************************************************\n");
					*/
				
			
		     xRemovePMT(handle);
	           // printf("Received pmt : %d   parse pmt form pat:%d\n",m_recvProgramCnt,m_programInfo.program_cnt);
			if(m_recvProgramCnt == 1 && waitpmt == 1){
				int rc;
				rc =pthread_create(&waitPMTThread, NULL,ThreadWaitPMTEntry,NULL);
				if(rc !=0)
					printf("can't create thread: %s\n", strerror(rc));
				}	
				
		     if(m_recvProgramCnt == m_programInfo.program_cnt && waitpmt == 1 )
		     	{
		     	       waitpmt = 0;
				 if(waitPMTThread){
					rc = pthread_join(waitPMTThread, (void **)&status);
					if (rc != 0)					
						;//printf("ERROR; return code from waitPMTThread pthread_join() is %d\n", rc);			
					else
					  {
						waitPMTThread = 0;
						//printf("waitPMTThread Thread joined\n");
					   }
				 	}
					   
		     		printf("Have Parsed all pmt information\n");					
				bzero(&prog_list, sizeof(prog_list));
				int  play_index = 0;
			
               	     for(int i = 0; i < m_programInfo.program_cnt;i++)
                   	 	{
                   	 	  if(m_programInfo.psi_program[i].received == true)
                    		  	{
                    	  		  // printf("*********************program information*********************\n");
					  
					    if( m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids > 0 )
					     {
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				  	  	{
				 	   	  for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    		  	{
					                	 printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,vcnt,acnt));
							 	 printf("program number:0x%04x   PMT_PID:0x%04x    PCR_PID:0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
				 	      		  	 printf("VPID: 0x%04x  VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
						        	 printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
				    	         	   	prog_list[play_index].pmt_index = i;
						 	 	prog_list[play_index].video_in_pmt_index=vcnt;
						  	  	prog_list[play_index].audio_in_pmt_index=acnt;
						  	 	play_index ++;
								  
				    	  		}
				    	   	 }
				    	}
					else if (m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids==0)
					{
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				    		{
				    			printf("\n%d) program   isScramble:%s \n",play_index,StrScramble(i,vcnt,0));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("VPID: 0x%04x   VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
							printf("Audio none\n");
				 	       		prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=vcnt;
						 	prog_list[play_index].audio_in_pmt_index=0;
						  	 play_index ++;					  
				    	     }
					}
					else if (m_programInfo.psi_program[i].num_video_pids == 0 && m_programInfo.psi_program[i].num_audio_pids > 0)
					{
						for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    	  	{
					       
				 	       		printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,0,acnt));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("Video none\n");
							printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
							prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=0;
						  	prog_list[play_index].audio_in_pmt_index=acnt;
						   	play_index ++;								  
				    	  	}
					}
							   
                    	  	}
                      }
			 if(file_play_status == 0){
			 	 int select_index;
				while(1){
					 printf("\nPlease input play index(0~%d) to play\n",play_index-1);
					 fflush(stdin);
					 scanf("%d",&select_index);					 
					 if(select_index >= 0 &&  select_index <play_index){
						 printf("\nReceive the index you to play :%d\n",select_index);							 
						 break;}						
					 }				
				 xChangeAvParm(select_index);
			 	}
		     }

	         }

			break;	
		}
			   			
								
		}
			 	
	      }		
		
			
		
		else
		{
			printf("Can not parse table id! TID = %d\n", sectionData[0]);
		}
	}while(0);

	return ;
}
void xAddPAT(void)
{
	if(patHandle == NULL){
	bzero(patPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(patPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(patPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
	patPattern.comp[0] = TS_PSI_TID_PAT;
	patPattern.mask[0] = 0xFF;
	patPattern.pid = TS_PSI_PID_PAT;
	patPattern.section_user_param = NULL;
	patPattern.callback_01 = SectionCallback;
	patPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	if (RTK_Player_AddSectionFilter(gPlayer_1, &patHandle, &patPattern) != RTK_OK)
	   {
		printf("Failed to add PAT section filter.\n");
		return;
	   }
      }
	return;
}
void xRemovePAT(void)
{
	if(patHandle)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, patHandle) != RTK_OK)
		{
			printf("Failed to remove PAT section filter.\n");
		}
		//printf("xRemovePAT\n");
		patHandle = NULL;
	}
	return;
}

void xAddCAT(void)
{
	if(catHandle == NULL)
	{
		bzero(catPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		catPattern.comp[0] = TS_PSI_TID_CAT;
		catPattern.mask[0] = 0xFF;
		catPattern.pid = TS_PSI_TID_CAT;
		catPattern.section_user_param = NULL;
		catPattern.callback_01 = SectionCallback;
		catPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(gPlayer_1, &catHandle, &catPattern) != RTK_OK)
		{
			printf("Failed to add CAT section filter.\n");
			return;
		}
	//	printf("xAddCAT\n");
		
	}
	return;
}

void xRemoveCAT(void)
{
	if(catHandle)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, catHandle) != RTK_OK)
		{
			printf("Failed to remove CAT section filter.\n");
		}
		//printf("xRemoveCAT\n");
		catHandle = NULL;
	}
	return;
}

char xAddPMT(uint16_t pid)
{
	RTK_SectionFilter pmtHandle;
	RTK_SectionFilterMask pmtPattern;
	int index = -1;

	// check if add before
	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtFilterPID[i]== 0) // find out free space
		{
			if(index== -1) index = i;
			continue;
		}
		else if(m_pmtFilterPID[i] == pid) // already exist
		{
			index = i;
			break;
		}
	}

	if( index != -1 && m_pmtHandle[index] == NULL)
	{
		bzero(pmtPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		pmtPattern.comp[0] = TS_PSI_TID_PMT;
		pmtPattern.mask[0] = 0xFF;
		pmtPattern.pid = pid;
		pmtPattern.section_user_param = NULL;
		pmtPattern.callback_01 = SectionCallback;
		pmtPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(gPlayer_1, &pmtHandle, &pmtPattern) != RTK_OK)
		{
			printf("Failed to add PMT section filter.\n");
			return RTK_ERR;
		}
		//printf("xAddPMT PID 0x%x to index %d %p\n", pid, index, pmtHandle);
		m_pmtHandle[index] = pmtHandle;
		m_pmtFilterPID[index] = pid;
	}
	return RTK_OK;
}

void xRemovePMT(RTK_SectionFilter handle)
{
	int index = -1;

	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtHandle[i] == handle) // find out
		{
			index = i;
			break;
		}
	}
	if(index != -1)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, m_pmtHandle[index]) != RTK_OK)
		{
			printf("Failed to remove PAT section filter.\n");
			return;
		}
		//printf("xRemovePMT PID 0x%x from index %d %p\n", m_pmtFilterPID[index], index, m_pmtHandle[index]);
		m_pmtHandle[index] = NULL;
		m_pmtFilterPID[index] = 0;
	}
	return;
}

RTK_Bool xIsPlayOnce(void)
{
	RTK_Bool is_play_once = RTK_TRUE;
	printf("\n Do you want to repeat play?(y/N):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			is_play_once = RTK_FALSE;
			break;
		}
		else if(ch == 'N'||ch =='n')
		{
			is_play_once = RTK_TRUE;
			break;
		}
	}
	fflush(stdin);
	return is_play_once;
}

int _get_number_with_range(long int* pval, long int min, long int max);
void inputHdmiDelays(long * HDMI_VSDB_delay_ms,long * HDMI_AUDIO_delay_ms) {

    int ret = RTK_Fail;
    long min = -3000;
    long max = 3000;
    do
    {
        printf("\nhdmi vsdb delay ms (decimal base range[%d,%d]) >> ",min,max);        
        if (_get_number_with_range(HDMI_VSDB_delay_ms, min ,max)<0)    
            ret = RTK_Fail;
        else
            ret =RTK_OK;
    }while(ret == RTK_Fail);
    
    do
    {
        printf("\nhdmi audio delay ms (decimal base range[%d,%d]) >> ",min,max);        
        if (_get_number_with_range(HDMI_AUDIO_delay_ms, min ,max)<0)    
            ret = RTK_Fail;
        else
            ret =RTK_OK;
    }while(ret == RTK_Fail);    

}

#define TIMESHIFT_SIZE 1024*1024*50
static void playTimeshift(RTK_PlayerConfig *config)
{
	printf("\n playTimeshift hello\n\n");
	uint32_t total_feed_size = 0;
	uint32_t last_mb = 0;

	RTK_TSInputBuffer buffer;
	FILE * file=NULL;

	memset(&buffer, 0, sizeof(buffer));

	//create surface
	if(config->video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 100, 100, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	//input file name and pids and codec.
	file = fopen(timeshift_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n",timeshift_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}

#if 0
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);
#endif

	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_2, config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_2 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	//Player start.
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	while((total_feed_size <= TIMESHIFT_SIZE))
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_2, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);

		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = (uint32_t)-1;// don't care file size;
				input_info.video_codec_type = config->video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == RTK_TRUE)
				{
					usleep(500*1000); // check 500ms
					if( !feof(file) )
						buffer.isLast = RTK_FALSE;
					else
					{
						RTK_Player_FeedInputBuffer(gPlayer_2, &buffer);
						printf("file last, there is no data to feed \n");
						goto ON_WAIT_EOS;
					}
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{
					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer);
					usleep(6*1000);
					continue;
				}
				total_feed_size += buffer.filled_size;
				if(total_feed_size > TIMESHIFT_SIZE)
				{
					buffer.isLast = RTK_TRUE;
					printf("total_feed_size reach, isLast = 1\n");
				}
				if(last_mb != total_feed_size/(1024*1024))
				{
					last_mb = total_feed_size/(1024*1024);
					printf("total_feed_size = %d MB\n", last_mb);
				}

				err = RTK_Player_FeedInputBuffer(gPlayer_2, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed InputBuffer failed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer);

					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}

		usleep(10*1000);
	
	}
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_2.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
	player_status_2.eof_reached = RTK_FALSE;
	
ON_ERROR:
	fclose(file);
	
	config->audio.pid = 0;
	config->audio.focused = RTK_FALSE;
	RTK_Player_ChangeAudio(gPlayer_2, &config->audio);
	
	if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_2 = NULL;
	RTK_DestorySurface(config->video.output);
	
	printf("Test finish.\n");

	return;

}

void xPlaySample(char *user_name, RTK_PlayerConfig playerConfig,INPUT_SOURCE_t input_info)
{
	RTK_Error ret = RTK_Fail;
	RTK_TSInputBuffer buffer;
	RTK_Player player = NULL;
//	uint32_t totleFileSize=0;
	uint32_t play_count = 0;

	if(user_name == NULL)
	{
		printf("%s user_name is NULL\n",__FUNCTION__);
		return ;
	}
	printf("%s::%s enter\n", __FUNCTION__, user_name);
	//create surface
	if(playerConfig.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}
	// create player
	ret = RTK_Player_Create(&player, &playerConfig, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || player == NULL)
	{
		printf("%s::%s Failed to create player.\n", __FUNCTION__, user_name);
		return;
	}

	// player start
	if(RTK_Player_Start(player) != RTK_OK)
	{
		printf("%s::%s Failed to start player.\n", __FUNCTION__, user_name);
		return;
	}

	while(gStopPlayTest == false)
	{
		if(input_info.fp == NULL) // tuner mode
		{
			sleep(1);
			play_count++;
			printf("%s::%s play %d sec\n", __FUNCTION__, user_name, play_count);
			continue;
		}
		else // file mode
		{
			RTK_Error err = RTK_Player_GetInputBuffer(player, &buffer);
			switch(err)
			{
				case RTK_OK:
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if (buffer.filled_size < 0)
					{
						RTK_Player_DiscardInputBuffer(player, &buffer);
						continue;
					}
					err = RTK_Player_FeedInputBuffer(player, &buffer);
					if(err != RTK_OK)
					{
						printf("%s::%s feed nputBuffer failed\n", __FUNCTION__, user_name);
						RTK_Player_DiscardInputBuffer(player, &buffer);
					}
					if(buffer.isLast == 1)
					{
						goto __PLAY_SAMPLE_EOS;
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
					//printf("%s::%s RTK_BUFFER_NOT_AVAILABLE!!\n", __FUNCTION__, user_name);
					usleep(20*0000);	//	more 20ms.
					break;
				default:
					//printf("%s::%s ERROR!!\n", __FUNCTION__, user_name);
					break;
			}

			usleep(20*0000);	//	20ms.
		}
	}

__PLAY_SAMPLE_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached ||player_status_2.eof_reached )
		{
			printf("eof_reached\n");
			break;
		}
	}

	if(RTK_Player_Stop(player,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player1.\n");
		return;
	}

	if(RTK_Player_Destroy(player) != RTK_OK)
	{
		printf("Failed to destroy player1.\n");
		return;
	}
	if(playerConfig.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	printf("%s::%s exit\n",__FUNCTION__, user_name);

}


RTK_SourceParam_t xTransferTunerToSourceParam(RTK_TunerParam_t tunerParam)
{
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));

	switch(tunerParam.type)
	{
		case RTK_TUNER_TYPE_DVBC:
			sourceParam.type = RTK_SOURCE_TYPE_DVBC;
			break;
		case RTK_TUNER_TYPE_ABS:
			sourceParam.type = RTK_SOURCE_TYPE_ABS;
			break;
		case RTK_TUNER_TYPE_DTMB:
			sourceParam.type = RTK_SOURCE_TYPE_DTMB;
			break;
		case RTK_TUNER_TYPE_DVB_T:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_T;
			break;
		case RTK_TUNER_TYPE_DVB_S:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_S;
			break;
		case RTK_TUNER_TYPE_DVB_S2:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_S2;
			break;
		case RTK_TUNER_TYPE_DVB_T2:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_T2;
			break;
		default:
			sourceParam.type = RTK_SOURCE_TYPE_DVBC;
			break;
	}
	sourceParam.bandwidth = tunerParam.bandwidth;
	memcpy( &sourceParam.tnr_param , &tunerParam.tnr_param, sizeof(tunerParam.tnr_param) );
	return sourceParam;
}

void CAS_switch()
{
	if (gCASType == RTK_CAS_TYPE_NONE)
	{
		printf("[%s][%d]: CAS_switch to RTK_CAS_TYPE_NAGRA_TKL\n", __FILE__, __LINE__);
		gCASType = RTK_CAS_TYPE_NAGRA_TKL;
		RTK_DvbSetSMP(0,RTK_TRUE);
		RTK_DvbSetSMP(1,RTK_TRUE);
	}
	else
	{
		printf("[%s][%d]: CAS_switch to RTK_CAS_TYPE_NONE\n", __FILE__, __LINE__);
		gCASType = RTK_CAS_TYPE_NONE;
		RTK_DvbSetSMP(0,RTK_FALSE);
		RTK_DvbSetSMP(1,RTK_FALSE);
	}
}

int rtkmid_input_Source_Param(RTK_SourceParam_t *source)
{
	int ret = RTK_Fail;
	RTK_Bool is_choose_source = RTK_FALSE;
	printf("\n Do you want to choose Tuner?(y/N):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			is_choose_source = RTK_TRUE;
			break;
		}
		else if(ch == 'N'||ch =='n')
		{
			is_choose_source = RTK_FALSE;
			break;
		}
	}
	fflush(stdin);

	if (RTK_TRUE == is_choose_source)
	{
		source->type = RTK_SOURCE_TYPE_TP;
		long int id = 0;
		do
		{
			printf("\n Enter Tuner id:>>\n");
			id = 0;
			if (_get_number_with_range(&id, 0x0 ,0xFF)<0)
				ret = RTK_Fail;
			else
				ret =RTK_OK;
		}while(ret == RTK_Fail);
		source->TunerID = (unsigned char)id;
	}

	return RTK_OK;
}

//Rtk_AvParam_t * avParam1
void rtk_hal_test_Player_Tuner()
{
	printf("[%s][%d]: rtk_hal_test_Tuner_Player\n", __FILE__, __LINE__);
	
	RTK_PlayerConfig config;
	unsigned char chipid;
	memset(&config, 0, sizeof(RTK_PlayerConfig));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_TUNER;
	//DVB-C setting
/*
	config.input.tuner.number = 0;		//always should be 0 when there is only one physical tuner
	config.input.tuner.bandWidthkHz = 8000; //8MHz
	config.input.tuner.modType = (RTK_ModulationType)(avParam1->QAM_modulation-1); 
	config.input.tuner.frequencykHz = (avParam1->frec)/1000;//466MHz
	config.input.tuner.symbolRatekHz = (avParam1->symbol_rate)/1000; // 6875Kmz=6.875MHz
	config.pcr_pid = avParam1->pcr_pid;
*/
	//DVB-c setting
	rtkmid_input_Tuner_Param(&config.input.tuner);
	/*
	config.input.tuner.type = RTK_TUNER_TYPE_DVBC;
	config.input.tuner.tnr_param.dvb_c_param.u32frequency = 730;//466MHz
	config.input.tuner.tnr_param.dvb_c_param.u32symbol_rate =6875000;
	config.input.tuner.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
	config.pcr_pid = 512;
*/
	if(RTK_Tuner_GetDeviceChipid(0,&chipid)!= RTK_OK)
	{
		printf("Failed to GetDeviceChipid.\n");
	}
	printf("\n chipid chipid chipid ==== %d \n",chipid);
	//create surface
	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	config.audio.encrypted=RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.audio.focused = RTK_TRUE;
	RTK_Tuner_Init();
	RTK_Set_TunerScanning(0,config.input.tuner);
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}
	
	
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

/*
	//usually, when RTK_Player_Create, it always set video/audio pid 0, when start ready, it will set correct pid 	
	//config.video.codec = (RTK_Codec)RTK_CODEC_VIDEO_MPEG2;//	it can be RTK_CODEC_NONE at initialize time.
	//config.video.pid = 512;//usually, when RTK_Player_Create first, pid always is 0
	config.video.encrypted = RTK_FALSE;
	//config.audio.codec = (RTK_Codec)(RTK_CODEC_AUDIO_MPEG2); //	it can be RTK_CODEC_NONE at initialize time.
	//config.audio.pid = 650;  	//usually, when RTK_Player_Create first, pid always is 0
	config.audio.encrypted = RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);
*/

	// receive PAT, PMT
	// change a/v pid/codec.

	RTK_TunerInfo tunerInfo;

	RTK_Tuner_GetInfo(0,&tunerInfo);
	printf("tuner info: locked status:%s, quality:%u , snr:%f \n",tunerInfo.locked ==RTK_FALSE? "unlock":"lock" , tunerInfo.quality ,tunerInfo.snr);

	int i=0;
	for(i=WAIT_TIME_SECOND;  i> 0;  i--)
	{	
		sleep(1);
		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}
#if (0) //temporary for set aspect ratio test
	printf("\n@@@@@@@@@@@@@@@@@@@Begin test setAspectRatio.@@@@@@@@@@@@@@@@@\n");
	int ratioID;
	rtk_porting_display_set_aspectratio(RTK_SLR_RATIO_4_3);
	ratioID=rtk_porting_display_get_aspectratio();
	printf("\nGet ratioID=%d[0->(ratio 4:3),1->(ratio 16:9),2->(ratio auto))@@@@@@@@\n",ratioID);
	sleep(10);
	rtk_porting_display_set_aspectratio(RTK_SLR_RATIO_16_9);
	ratioID=rtk_porting_display_get_aspectratio();
	printf("\nGet ratioID=%d[0->(ratio 4:3),1->(ratio 16:9),2->(ratio auto))@@@@@@@@\n",ratioID);
	printf("\n@@@@@@@@@@@@@@@@@@@@@End test setAspectRatio.@@@@@@@@@@@@@@@@@\n");
	 for(i=WAIT_TIME_SECOND;  i> 0;  i--)
       {
               sleep(1);
               printf("Tuner A/V is playing.....%d s to stop it", i);
       }
#endif

#if (0) //temporary for set tv system test
	printf("\n@@@@@@@@@@@@@@@@@@@Begin test set tv system.@@@@@@@@@@@@@@@@@\n");
	int tvsystemID;
	rtk_porting_display_set_tvSystem(RTK_TVSYSTEM_1080P_50HZ);
	tvsystemID=rtk_porting_display_get_tvSystem();
	printf("\nGet tvsystemID=%d@@@@@@@@@@@@@@@@@@\n",tvsystemID);
	sleep(10);
	rtk_porting_display_set_tvSystem(RTK_TVSYSTEM_720P_50HZ);
	tvsystemID=rtk_porting_display_get_tvSystem();
	printf("\nGet tvsystemID=%d@@@@@@@@@@@@@@@@@@\n",tvsystemID);
	
	printf("\n@@@@@@@@@@@@@@@@@@@@@End test tv system.@@@@@@@@@@@@@@@@@\n");
	 for(i=WAIT_TIME_SECOND;  i> 0;  i--)
       {
               sleep(1);
               printf("Tuner A/V is playing.....%d s to stop it", i);
       }
#endif
#if   (0)  //temporary for set/get video mute test 
	RTK_Bool bvideomute;
	printf("Begin test setvideoMute.\n");
	printf("\n@@@@@@@@@@@@@@@@@@@@@Begin test setvideoMute.@@@@@@@@@@@@@@@@@\n");
       //rtk_porting_display_set_visible(RTK_DISPLAY_VIDEO,RTK_FALSE);
	RTK_Player_SetVideoMute(gPlayer_1, RTK_TRUE);	
	RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
	printf("\n@@@@@@@bvideomute=%d@@@@@@@\n",bvideomute);
	sleep(10);
	RTK_Player_SetVideoMute(gPlayer_1, RTK_FALSE);
	RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
	printf("\n@@@@@@@bvideomute=%d@@@@@@@\n",bvideomute);
       for(i=WAIT_TIME_SECOND;  i> 0;  i--)
       {
               sleep(1);
               printf("Tuner A/V is playing.....%d s to stop it", i);
       }
       printf("\n@@@@@@@@@@@@@@@@@@@@@End test setvideoMute.@@@@@@@@@@@@@@@@@\n");

#endif

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	
	printf("Test finish.\n");

	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}	

	return ;
}

void rtk_hal_test_Player_TunerPIP()
{

	printf("[%s][%d]: rtk_hal_test_Player_TunerPIP\n", __FILE__, __LINE__);
	RTK_PlayerConfig config1;
	RTK_PlayerConfig config2;
	unsigned char chipid;
	RTK_Error ret;
	memset(&config1, 0, sizeof(config1));
	memset(&config2, 0, sizeof(config2));
	config1.callback.function = NULL;
	config1.input.type = RTK_INPUT_TUNER;
	config2.callback.function = NULL;
	config2.input.type = RTK_INPUT_TUNER;
	printf("\n============Input Main Channel============\n");
	rtkmid_input_Tuner_Param(&config1.input.tuner);
	rtkmid_input_AV_type_pid(&config1.video,&config1.audio, &config1.pcr_pid);
	printf("\n============Input PIP Channel============\n");
	rtkmid_input_Tuner_Param(&config2.input.tuner);
	rtkmid_input_AV_type_pid(&config2.video,&config2.audio, &config2.pcr_pid);
	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
	
		
	
	
	int videopid1 = config1.video.pid;
	int audiopid1 = config1.audio.pid;	
	int videopid2 = config2.video.pid;
	int audiopid2 = config2.audio.pid;
	config1.video.pid = 0;
	config1.audio.pid = 0;
	config2.video.pid = 0;
	config2.audio.pid = 0;
	
	RTK_Tuner_Init();
	 
	ret=RTK_Player_Create(&gPlayer_1, &config1, HAL_TYPE_DEMUX); 
	if(ret != RTK_OK || gPlayer_1 == NULL)
	{
		printf("Failed to create player1.\n");
		return;
	}
	ret = RTK_Player_Create(&gPlayer_2, &config2, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || gPlayer_2 == NULL)
	{
		printf("Failed to create player2.\n");
		return;
	}
	if(RTK_Tuner_GetDeviceChipid(0,&chipid)!= RTK_OK)
	{
		printf("Failed to GetDeviceChipid.\n");
	}
	printf("\n chipid chipid chipid ==== %d \n",chipid);
	
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player1.\n");
		return ;
	}
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("Failed to start player2.\n");
		return ;
	}
	config1.video.pid = videopid1;
	config1.audio.pid = audiopid1;
	config1.audio.focused=RTK_TRUE;
	config2.video.pid = videopid2;
	config2.audio.pid = audiopid2;
	config2.audio.focused=RTK_FALSE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config1.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config1.audio);
	RTK_Player_ChangeVideo(gPlayer_2, &config2.video);
	RTK_Player_ChangeAudio(gPlayer_2, &config2.audio);

	RTK_TunerInfo tunerInfo;

	RTK_Tuner_GetInfo(0,&tunerInfo);
	printf("tuner1 info: locked status:%s, quality:%u , snr:%f \n",tunerInfo.locked ==RTK_FALSE? "unlock":"lock" , tunerInfo.quality ,tunerInfo.snr);
	RTK_Tuner_GetInfo(1,&tunerInfo);
	printf("tuner2 info: locked status:%s, quality:%u , snr:%f \n",tunerInfo.locked ==RTK_FALSE? "unlock":"lock" , tunerInfo.quality ,tunerInfo.snr);

	int i=0;
	for(i=WAIT_TIME_SECOND;  i> 0;  i--)
	{	
		sleep(1);
		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player1.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player1.\n");
		return;
	}
	if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player2.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
	{
		printf("Failed to destroy player2.\n");
		return;
	}
	
	RTK_DestorySurface(RTK_WIN_PIP);

	RTK_DestorySurface(RTK_WIN_MAIN);
	printf("Test finish.\n");
	return ;
}

void rtk_hal_test_Player_TunerZapping()
{
	printf("[%s][%d]: rtk_hal_test_Player_TunerZapping\n", __FILE__, __LINE__);

	RTK_PlayerConfig config;
	RTK_VideoConfig video1;
	RTK_AudioConfig audio1;
	RTK_VideoConfig video2;
	RTK_AudioConfig audio2;
	RTK_VideoConfig video3;
	RTK_AudioConfig audio3;
	RTK_TunerParam_t tunerParam1;
	RTK_TunerParam_t tunerParam2;
	RTK_TunerParam_t tunerParam3;

	RTK_Error lock_ok=RTK_Fail;
	
	unsigned short pcr_pid=-1;

	//reset config, video, audio.
	memset(&config, 0, sizeof(config));
	memset(&video1, 0, sizeof(video1));
	memset(&audio1, 0, sizeof(audio1));
	memset(&video2, 0, sizeof(video2));
	memset(&audio2, 0, sizeof(audio2));
	memset(&video3, 0, sizeof(video3));
	memset(&audio3, 0, sizeof(audio3));
	memset(&tunerParam1, 0, sizeof(tunerParam1));
	memset(&tunerParam2, 0, sizeof(tunerParam2));
	memset(&tunerParam3, 0, sizeof(tunerParam3));

	//get tuner param and av pid from console.
	printf("\nPlease enter first channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam1);
	rtkmid_input_AV_type_pid(&video1,&audio1, &pcr_pid);

	printf("\nPlease enter second channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam2);
	rtkmid_input_AV_type_pid(&video2,&audio2, &pcr_pid);

	printf("\nPlease enter third channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam3);
	rtkmid_input_AV_type_pid(&video3,&audio3, &pcr_pid);


	//set tuner input.
	config.input.type = RTK_INPUT_TUNER;

	//use play_callback to receive some notify event from decoder.
	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.audio.encrypted=RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.audio.focused = RTK_TRUE;

	RTK_Tuner_Init();


	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return ;
	}


	RTK_Set_TunerScanning(0, tunerParam1);
	for(int i=0; i<20; i++) //wait 200ms
	{
		usleep(10*1000);
		lock_ok=RTK_Tuner_IsLocked(0);
		if(lock_ok==RTK_OK)
			break;		
	}

	if(lock_ok==RTK_OK)
	{
		//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
		RTK_Player_ChangeVideo(gPlayer_1, &video1);
		audio1.focused=RTK_TRUE;
		RTK_Player_ChangeAudio(gPlayer_1, &audio1);
		RTK_Player_Start(gPlayer_1);
	}
	else
	{
		printf("lock failed\n");
	}

	printf("wait 30s then change channel 2\n");
	sleep(30);

	//First stop and keep last frame.
	RTK_Player_Stop(gPlayer_1, RTK_TRUE);

	RTK_Set_TunerScanning(0, tunerParam2);
	for(int i=0; i<20; i++) //wait 200ms
	{
		usleep(10*1000);
		lock_ok=RTK_Tuner_IsLocked(0);
		if(lock_ok==RTK_OK)
			break;		
	}

	RTK_Player_ChangeVideo(gPlayer_1, &video2);
	audio2.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &audio2);
	RTK_Player_Start(gPlayer_1);

	printf("wait 30s then change channel3\n");
	sleep(30);

	//First stop and keep last frame.
	RTK_Player_Stop(gPlayer_1, RTK_TRUE);


	RTK_Set_TunerScanning(0, tunerParam3);
	for(int i=0; i<20; i++) //wait 200ms
	{
		usleep(10*1000);
		lock_ok=RTK_Tuner_IsLocked(0);
		if(lock_ok==RTK_OK)
			break;		
	}

	RTK_Player_ChangeVideo(gPlayer_1, &video3);
	audio3.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &audio3);
	RTK_Player_Start(gPlayer_1);
	

	sleep(30);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	printf("Test finish.\n");
	
	return ;
}


//Rtk_AvParam_t * avParam1
void rtk_hal_test_Player_TunerScan()
{
	printf("[%s][%d]: rtk_hal_test_Player_TunerScan\n", __FILE__, __LINE__);

	RTK_PlayerConfig config;
	RTK_TunerParam_t param;
	memset(&config, 0, sizeof(config));
	memset(&param, 0, sizeof(param));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_TUNER;

	RTK_Tuner_Init();
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}

	
	param.type = RTK_TUNER_TYPE_DVBC;
	long freq=274;
	int lock;
	while(1)
	{
		param.tnr_param.dvb_c_param.u32frequency =freq ;//MHZ
		param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
		param.tnr_param.dvb_c_param.u32symbol_rate = 6875000;
		RTK_Set_TunerScanning(0,param);
		for(int i=0;i<20;i++)
		{
			usleep(10*1000);
			lock =RTK_Tuner_IsLocked(0);
			if(lock == RTK_OK)
				break;
		}

		if(lock == RTK_OK)
		{
			printf("\n tuner  locked  in freq == %ld \n",freq);

			int i=0;
			for(i=15;  i> 0;  i--)  
			{
				sleep(1);
				printf("Tuner A/V is playing.....%d s to stop it\n", i);
			}			
		}
		else
			printf("\n tuner  unlock  in freq == %ld \n",freq);

		freq=freq+8;

		if(freq > 800)
			break;
	}

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	printf("Test finish.\n");


	return ;
}




void rtk_hal_test_Player_FileplayAuto()
{	
	printf("\n rtk_hal_test_Player_FileplayAuto hello\n\n");

	
	RTK_TSInputBuffer buffer;
	
	char file_path[256]={0};
	FILE * file=NULL;		
	file_play_status = 0;
	waitpmt = 1;
	m_recvProgramCnt = 0;

	memset(&Config_1, 0, sizeof(Config_1));	
	
	Config_1.callback.function	= player_callback_1;
	Config_1.callback.user_param	= &player_status_1;

	Config_1.input.type			= RTK_INPUT_MEMORY;
 	
	
	Config_1.video.codec			= CHANNEL1_VIDEO_CODEC;
	Config_1.video.pid			= CHANNEL1_VIDEO_PID;
	Config_1.video.encrypted		= RTK_FALSE;
	Config_1.video.output 		= RTK_WIN_MAIN;

	Config_1.audio.codec					= CHANNEL1_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	Config_1.audio.pid					= CHANNEL1_AUDIO_PID;
	Config_1.audio.focused				= RTK_TRUE;
	Config_1.audio.encrypted				= RTK_FALSE;
	Config_1.audio.enable_raw_output_mode = RTK_FALSE;

	//create surface
	if(video_config.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	

	Config_1.video.pid = 0;
	Config_1.audio.pid = 0;

	//RTK_DvbSetSMP(0, RTK_TRUE);
	//RTK_DvbSetSMP(1, RTK_TRUE);
	
	if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}


	printf("set Volume maxinum 30\n");
	RTK_audio_SetVolume(30);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);


	memset(&m_pmtFilterPID,0,sizeof(m_pmtFilterPID));
	memset(m_pmtHandle,0,sizeof(m_pmtHandle));
	bzero(&m_programInfo, sizeof(TS_Program_Info));
	m_programInfo.pat_program.version = 0xff;
	m_programInfo.cat_program.version = 0xff;
       xAddPAT();
	xAddCAT();
       int paly_from_begin = 0;
	//	feed data until end of file.
	while(1)
	{			       
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);

		
		switch(err)
		{
			case RTK_OK:
				
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;	
				if(file_play_status == 1)					
				 {
					
					if(paly_from_begin == 0)
					{
						fseek(input_info.fp,0,SEEK_SET);
						paly_from_begin = 1;										
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					}
					
					input_info.filePlay_once = RTK_TRUE;					
				  }
				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
					if(input_info.filePlay_once == RTK_TRUE)					
				       goto ON_WAIT_EOS; 
					else
						continue;
				}
				if (buffer.filled_size <= 0)  
				{
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				}

				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;						
		}



	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	xRemoveCAT();
	xRemovePAT();
	for(int i=0;i<m_programInfo.program_cnt;i++)
		xRemovePMT(m_pmtHandle[i]);	

	if(waitPMTThread){
		int rc,status;
	        rc = pthread_join(waitPMTThread, (void **)&status);
			if (rc != 0)
			{
				printf("ERROR; return code from rtkPlayFeedThread pthread_join() is %d\n", rc);
				return;
			}
			else
			{
			       waitPMTThread = 0;
				printf("rtkPlayFeedThread Thread joined\n");
			}
		}
	
	//destroy surface
	if(video_config.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}

void rtk_hal_test_Player_Fileplay()
{	
	printf("\n 1rtk_hal_test_Player_Fileplay hello\n\n");	
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	RTK_VideoConfig video_config;
	RTK_AudioConfig audio_config;
	unsigned short pcr_pid=-1;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	long ptsTestCount = 0;
	RTK_Bool bvideomute;
	RTK_Bool is_play_once = RTK_TRUE;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));
	memset(&video_config, 0, sizeof(video_config));
	memset(&audio_config, 0, sizeof(audio_config));

	video_config.codec			= CHANNEL1_VIDEO_CODEC;
	video_config.pid			= CHANNEL1_VIDEO_PID;
	video_config.encrypted		= RTK_FALSE;
	video_config.output 		= RTK_WIN_MAIN;

	audio_config.codec					= CHANNEL1_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	audio_config.pid					= CHANNEL1_AUDIO_PID;
	audio_config.focused				= RTK_TRUE;
	audio_config.encrypted				= RTK_FALSE;
	audio_config.enable_raw_output_mode = RTK_FALSE;

	config.callback.function	= player_callback_1;
	config.callback.user_param	= &player_status_1;

	config.input.type			= RTK_INPUT_MEMORY;
	config.video 				= video_config;
	config.audio 				= audio_config;
	config.pcr_pid				= CHANNEL1_PCR_PID;

	//create surface
	if(video_config.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	bool isTestMute = RTK_FALSE;
	int ch = 0;	

	
	printf("\n Do you want to test Video/Audio mute/unmute?(Y/n):");
	
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMute = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestMute = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);

	is_play_once = xIsPlayOnce();

	if (strlen(FILE_NAME_1) != 0)
	{
		file = fopen(FILE_NAME_1, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&video_config,&audio_config, &pcr_pid);

	}


	RTK_SectionFilter patHandle;
	RTK_SectionFilterMask patPattern;
	UNUSED(patHandle);
	UNUSED(patPattern);
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	config.video.pid = 0;
	config.audio.pid = 0;

	//RTK_DvbSetSMP(0, RTK_TRUE);
	//RTK_DvbSetSMP(1, RTK_TRUE);
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}


	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.?\n");
		return ;
	}
	

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &video_config);
	RTK_Player_ChangeAudio(gPlayer_1, &audio_config);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	uint32_t u32VolumeVal = 0;
	RTK_audio_GetVolume(&u32VolumeVal);
	printf("get Current Volume val:%d\n",u32VolumeVal);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	RTK_Bool   bMuteStat = RTK_FALSE;
	RTK_Player_GetAudioMute  (gPlayer_1,&bMuteStat);
	
	printf("get Current Audio Mute status :%s\n",bMuteStat == RTK_FALSE ? "UnMute":"Mute");

#if (MTP_AUDIO_CHANGE)
		config2.callback.function = NULL;
		config2.callback.user_param = NULL;
		config2.input.type = RTK_INPUT_MEMORY;
		config2.video.codec = RTK_CODEC_VIDEO_MPEG2; //	it can be RTK_CODEC_NONE at initialize time.
		config2.video.pid = 0x100;
		config2.audio.codec = RTK_CODEC_AUDIO_AAC;	//	it can be RTK_CODEC_NONE at initialize time.
		config2.audio.pid = 0x110;
		config2.video.encrypted = RTK_FALSE;
		config2.audio.encrypted = RTK_FALSE;
		config2.audio.enable_raw_output_mode = RTK_FALSE;
		config2.audio.focused = RTK_FALSE;
		config2.pcr_pid = 0xFFFF;
		RTK_audio_setVolume(30);
		RTK_AudioConfig* audio = (RTK_AudioConfig*)malloc( sizeof(RTK_AudioConfig)*2);
		memcpy( audio, &config.audio, sizeof(RTK_AudioConfig));
		memcpy( (audio+1) , &config2.audio, sizeof(RTK_AudioConfig));
		time0 = pli_getMilliseconds();
#endif

/*
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
*/

	//	feed data until end of file.
	while(1)
	{

#if (MTP_AUDIO_CHANGE)
				time1 = pli_getMilliseconds();
				if (time1 - time0 > 10000)
				{
					static int i = 1;
					if (i == 0)
					{
						audio[0].focused = RTK_TRUE;
						audio[1].focused = RTK_FALSE;
					}
					else
					{
						audio[0].focused = RTK_FALSE;
						audio[1].focused = RTK_TRUE;
					}
					printf("================================== change audio ==================================\n");
		//			RTK_Player_ChangeAudio(gPlayer, audio[i]);
					RTK_Player_ChangeAudioEx(gPlayer_1, &audio, 2);
		
					i = (i == 0) ? 1 : 0;
					//------------------------------------------------------------------------------		
					time0 = time1;
					printf("\n\ntime1-time0>10000\n");
				}
#endif

		#if 0 // DMA buffer feed test. Please include rtk_ion.h 
		{
		int ret=0;
		static unsigned char *pVirtAddr=NULL;
		static unsigned int phyAddr=0;
		int feedSize=0;

		static ION_DATA  ionHl;

		if(ionHl.ion_virt==NULL)
		{
			memset(&ionHl, 0x00, sizeof(ION_DATA));


			ret=rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
				ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

			pVirtAddr=ionHl.ion_virt;
			phyAddr=(unsigned int)ionHl.ion_phy;
		}
		
		feedSize=fread(pVirtAddr, 1, (200*1024)/188*188, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);
			if(RTK_Player_FeedDMABuffer(gPlayer_1, phyAddr, feedSize, 2000/*2000 ms*/)!=0)
			{
				printf("mtp feed failed\n");
			}
		}
		
		}
		#else
		//get dma buffer.

		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);

		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.video_codec_type = video_config.codec;
				input_info.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					usleep(6000);
				        continue;                                                
				}
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		#endif

#if 0
		if(isTestVideoScale)
		{
			property_get("enable.video.scale", pvalue, "0");
			if(pvalue[0] == '0')// '1'
			{
			    rtk_porting_destory_winSurface(RTK_SURFACE_V1);
			    rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_FALSE, 0, 0);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale",  "2");
			}
			else if(pvalue[0] == '1')
			{
				rtk_porting_destory_winSurface(RTK_SURFACE_V1);
				rtk_test_create_winSurface(RTK_WIN_MAIN, 80, 56, 544, 306);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_TRUE, 544, 306);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale", "2");
			}
		}
#endif

		ptsTestCount++;
		if(ptsTestCount%200 == 0)
		{
			uint64_t ptsValue = 0;
			RTK_Player_GetCurrentDisplayingPTS(gPlayer_1,&ptsValue);
			printf("get Current PTS value:%llu\n",ptsValue);
		}	


#if  1  //temporary for set/get video/audio mute test
		if(isTestMute)	
		{
			count ++;
			if(count == 200)
			{
				printf("\n\n@@@@@@@@@@@@@@	Video Mute  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_TRUE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}
			if(count == 400)
			{
				printf("\n\n@@@@@@@@@@@@@@  Video ***Unmute***  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_FALSE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}

		}
#endif	
		static Hal_Demux_Info_t demuxInfo;
		static int xx=0;
		if(xx%400==0)
			RTK_Player_GetPacketDemuxInfo(gPlayer_1, &demuxInfo);
		xx++;
		
		usleep(5*1000);	//	5ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(video_config.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}


void rtk_hal_test_Player_Fileplay_with_hdmi_delay() {

    long HDMI_VSDB_delay_ms=0;
    long HDMI_AUDIO_delay_ms=0;
    
    inputHdmiDelays(&HDMI_VSDB_delay_ms,&HDMI_AUDIO_delay_ms);
    
    RTK_SetHdmiOutVSDBDelay((int)HDMI_VSDB_delay_ms);
    RTK_SetAudioHdmiDelay(true,(int)HDMI_AUDIO_delay_ms);

    rtk_hal_test_Player_Fileplay();
}

void rtk_hal_test_Player_FilePIP()
{
	printf("[%s][%d]: rtk_hal_test_Player_FilePIP\n", __FILE__, __LINE__);

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid						= CHANNEL1_VIDEO_PID;
	config.video.encrypted				= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec						= CHANNEL1_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid						= CHANNEL1_AUDIO_PID;
	config.audio.focused				  = RTK_TRUE;
	config.audio.encrypted					= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;

	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	if (strlen(FILE_NAME_1) != 0)
	{
		file = fopen(FILE_NAME_1, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	config.audio.focused=RTK_TRUE;
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if (config.input.type == RTK_INPUT_MEMORY)
	{
		//RTK_Player_SetAVSyncMode(gPlayer,RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	//RTK_Player_AvSetErrorConcealLevel(gPlayer_1, MAX_ERROR_CONCEALMENT_LEVEL, 0);

	config.video.pid = videopid;
	config.audio.pid = audiopid;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

//pip
	RTK_PlayerConfig config2;
	RTK_TSInputBuffer buffer2;
	char file_path2[256]={0};
	FILE * file2=NULL;

	memset(&config2, 0, sizeof(config2));

	config2.callback.function		= player_callback_2;
	config2.callback.user_param = &player_status_2;
	config2.input.type			= RTK_INPUT_MEMORY;
	config2.video.codec 		= CHANNEL2_VIDEO_CODEC;
	config2.video.pid						= CHANNEL2_VIDEO_PID;
	config2.video.encrypted 				= RTK_FALSE;
	config2.video.output		= RTK_WIN_PIP;
	config2.audio.codec 					= CHANNEL2_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	config2.audio.pid						= CHANNEL2_AUDIO_PID;
	config2.audio.focused				   = RTK_TRUE;
	config2.audio.encrypted 				= RTK_FALSE;
	config2.audio.enable_raw_output_mode = RTK_FALSE;
	config2.pcr_pid 			= CHANNEL2_PCR_PID;
	
	//create surface
	if(config2.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


//pip
	if (strlen(FILE_NAME_2) != 0)
	{
		file2 = fopen(FILE_NAME_2, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path2);
		file2 = fopen(file_path2, "rb");
		if(file2 == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path2);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config2.video,&config2.audio, &config2.pcr_pid);
	}
	uint32_t totleFileSize2=0;
	fseek(file2,0,SEEK_END);
	totleFileSize2=ftell(file2);
	rewind(file2);
	printf("totleFileSize2==%u\n",totleFileSize2);
	fseek(file2,0,SEEK_SET);

	gettimeofday(&startzaping_2, NULL);

	int videopid2 = config2.video.pid;
	int audiopid2 = config2.audio.pid;
	config2.video.pid = 0;
	config2.audio.pid = 0;
	if(RTK_Player_Create(&gPlayer_2, &config2, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player2.\n");
		return;
	}

	if (gPlayer_2 == NULL)
	{
		printf("Player2 is NULL!!");
		return;
	}
	if (config2.input.type == RTK_INPUT_MEMORY)
	{
		//RTK_Player_SetAVSyncMode(gPlayer,RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	}


	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	//RTK_Player_AvSetErrorConcealLevel(gPlayer_2, MAX_ERROR_CONCEALMENT_LEVEL, 0);

	config2.video.pid = videopid2;
	config2.audio.pid = audiopid2;
	config2.audio.focused=RTK_FALSE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_2, &config2.video);
	RTK_Player_ChangeAudio(gPlayer_2, &config2.audio);


/*
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
*/
#ifdef __TEST_UPDATE_VO_PLANE__
	int loop=0;
	int _switch=0;
	const int max_loop=500;
#endif    
	//	feed data until end of file.
	while(1)
	{
#ifdef __TEST_UPDATE_VO_PLANE__
		loop +=1;
		if (loop >max_loop) 
		{
			if (_switch % 2 == 0) 
			{
				RTK_Player_Pause_KeepLastFrame(gPlayer_1);
				RTK_Player_Pause_KeepLastFrame(gPlayer_2);
				RTK_Player_Update_VO_Plane(gPlayer_1,RTK_WIN_PIP);
				RTK_Player_Update_VO_Plane(gPlayer_2,RTK_WIN_MAIN);  
				RTK_Player_Resume(gPlayer_1);
				RTK_Player_Resume(gPlayer_2);
			}
			else
			{
				RTK_Player_Pause_KeepLastFrame(gPlayer_1);
				RTK_Player_Pause_KeepLastFrame(gPlayer_2);
				RTK_Player_Update_VO_Plane(gPlayer_1,RTK_WIN_MAIN);
				RTK_Player_Update_VO_Plane(gPlayer_2,RTK_WIN_PIP);	
				RTK_Player_Resume(gPlayer_1);
				RTK_Player_Resume(gPlayer_2); 
			}
			_switch +=1;
			loop =0;
		}
#endif        
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
						goto ON_WAIT_EOS;					 
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
						continue;												 
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				printf("gPlayer_1 UNKNOWN ERROR!!\n");
				
		}

		//get dma buffer.
		RTK_Error err2 = RTK_Player_GetInputBuffer(gPlayer_2, &buffer2);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err2)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info2;
				memset(&input_info2,0x0,sizeof(INPUT_SOURCE_t));
				input_info2.fp = file2;
				input_info2.totalFileSize = totleFileSize2;
				input_info2.video_codec_type = config2.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info2, &buffer2);
				if(buffer2.isLast == 1 && buffer2.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer2);
					usleep(6000);
						goto ON_WAIT_EOS;					 
				}
				if (buffer2.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer2);
					usleep(6000);
						continue;												 
				} 
				err2 = RTK_Player_FeedInputBuffer(gPlayer_2, &buffer2);

				if(err2 != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer2);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer2);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				printf("gPlayer_2 UNKNOWN ERROR!!\n");
				
		}


		usleep(10000);	//	10ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached ||player_status_2.eof_reached )
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;

	fclose(file2);
	if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player2.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
	{
		printf("Failed to destroy player2.\n");
		return;
	}
	gPlayer_2 = NULL;

	//destroy surface
	RTK_DestorySurface(RTK_WIN_PIP);
	RTK_DestorySurface(RTK_WIN_MAIN);
	
	printf("fielPIP Test finish.\n");
	return ;
}


void rtk_hal_test_Player_Sectionfilter()
{
	printf("\n rtk_hal_test_Player_Sectionfilter  hello\n\n");
	RTK_PlayerConfig config;
	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_TUNER;

	//DVB-c setting
	rtkmid_input_Tuner_Param(&config.input.tuner);

	gPlayer_1 = NULL;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


//RTK_Player_AddSectionFilter Description
/*************
	prototype	RTK_Error RTK_Player_AddSectionFilter(RTK_Player player, 
	RTK_SectionFilter * filter_handle, 
	RTK_SectionFilterMask * pattern)
	brief			opens and sets sectionFilter by specific pid, add the SectionFilter into SI 
	engine with the player handle
	parameter	player:		handle of player to add section filter
				filter_handle:	handle of filter to specify
	pattern:	defines filter pid, mask, mode, compose type, monitor mode, user param and a function pointer to SI section filter callback
	return		RTK_OK, RTK_Fail
	Detailed
	This function provides an interface to add section filter to get sections data with specific pid. When sectionFilter works, pattern->callback will receive the sections.
	Player handle is assigned by RTK_Player_Create. Filter handle is assign to filter Index.
		typedef struct
		{
			UINT16_T pid;
	        UINT32_T options;
			RTK_SectionMonitoringMode monitoring_mode;
			UINT8_T mask[RTK_MAX_SECTION_MASK_LENGTH];	
			UINT8_T mode[RTK_MAX_SECTION_MASK_LENGTH];	
			UINT8_T comp[RTK_MAX_SECTION_MASK_LENGTH];	
			RTK_SectionFilterCallback callback;
			void * section_user_param;
		uint32_t u32byWaitTimeoutMs;
		RTK_SectionFilterCallback_01 callback_01;
		} RTK_SectionFilterMask;
		With the parameter pattern, it is clear to recognize filter features. At least, pattern->pid, pattern-> monitoring_mode,pattern->comp[0] ,  pattern->mask[0] and pattern->callback should be setting. 
		pattern->pid is the PID of TS package you want to get.
		pattern->monitoring_mode has two options show as RTK_SectionMonitoringMode. 	RTK_SECTION_MODE_ONESHOT means specified section callback should be called 1 time 	only. Specified section callback should be called whenever section was received if 	RTK_SECTION_MODE_CONTINOUS has been set. 
		typedef enum
		{
			RTK_SECTION_MODE_ONESHOT,	
			RTK_SECTION_MODE_CONTINOUS
		} RTK_SectionMonitoringMode;

	pattern-> mask: for all inclusion mask bits that are masked	(set to 0xff) ALL of the corresponding bits in the message must match the bits specified by the coefficient in order to be included. If one bit differs, it will be excluded.
				  note:pattern->mask[0] = 0xFF; // mask[0] must be given value 0xFF.
	pattern-> mode: reserved, we do not use this param, it can be ignored now.
	pattern-> comp: the current filter value, it equivalent to an array, the max size of this array is 16 Byte.
			note: pattern->comp[0] stands for tid and must be given a value.	
	pattern-> u32byWaitTimeoutMs:  unit is millisecond, when its value is set 0, we will not check time out; when its value is set above 0, we will check time out;

		As parameter pattern->callback01, a function pointer to the section data reception function 	must be passed. This callback function defined as below:
	typedef void (*RTK_SectionFilterCallback_01)(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam);

	typedef enum 
	{
		HAL_SECTION_FILTER_TIMEOUT,           //0x00  
		HAL_SECTION_FILTER_HIT      		  //0x01
	}RTK_HAL_SECTION_CB_STATUS;

		pattern->options default value is 0, it means to do CRC check.
		RTK_OK is returned if _xAddSectionFilter has successfully processed.
		RTK_Fail is returned if parameters error occurred or filter open failed.
***********/

	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;//PAT
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	SectionFilterPattern0.u32byWaitTimeoutMs = 0;
	SectionFilterPattern0.comp[0] = 0x00;// comp[0] stands for tid and must be given a value.		
	SectionFilterPattern0.mask[0] = 0xFF; // mask[0] must be given value 0xFF.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
	
	memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern1.pid = 0X01;//CAT
	SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern1.comp[0] = 0x01;// comp[0] stands for tid and must be given a value.		
	SectionFilterPattern1.mask[0] = 0xFF; // mask[0] must be given value 0xFF.	
	SectionFilterPattern1.callback_01 = section_callback1;
	/*****************
	 note: 	1, when section_callback2 enStatus return value is HAL_SECTION_FILTER_TIMEOUT,we will not recevie any section,
	        and the same time,we should do call RTK_Error RTK_Player_RemoveSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle) func,
	        if we want to receive section data , we need call   RTK_Player_AddSectionFilter again.	
	      
	*****************/
	SectionFilterPattern1.u32byWaitTimeoutMs = 4000;// unit is millisecond
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle1, &SectionFilterPattern1);


	memset(&SectionFilterPattern2, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern2.pid = 0X053c;//emm pid
	SectionFilterPattern2.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern2.callback_01 = section_callback2;

	SectionFilterPattern2.options = 1;
	SectionFilterPattern2.u32byWaitTimeoutMs = 0;// unit is millisecond

/********
// need not check index 1 and 2  (0x00,0xB4)
Data:   
0x82, 0x00, 0xB4, 0x3F, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x01, 0xCA, 0x01, 0xBB, 0x7E,

pattern mask set to filter as below,
comp:
0x82, 0x3F, 0x87, 0x00, 0x00,  0x00, 0x00, 0x00, 0x1A, 0x01, 0xCA, 0x01, 0x00, 0x00, 0x00, 0x00,
mask:
0xFF, 0xFF,0xFF,0xFF, 0xFF, 0xFF, 0xFF,0xFF,0xFF, 0xFF, 0xFF, 0xFF,0x00, 0x00, 0x00, 0x00,

*********/

	SectionFilterPattern2.comp[0] = 0x82;
	SectionFilterPattern2.comp[1] = 0x3F;
	SectionFilterPattern2.comp[2] = 0x87;
	SectionFilterPattern2.comp[3] = 0x00;
	SectionFilterPattern2.comp[4] = 0x00;
	SectionFilterPattern2.comp[5] = 0x00;
	SectionFilterPattern2.comp[6] = 0x00;
	SectionFilterPattern2.comp[7] = 0x00;
	SectionFilterPattern2.comp[8] = 0x1A;
	SectionFilterPattern2.comp[9] = 0x01;
	SectionFilterPattern2.comp[10] = 0xca;
	SectionFilterPattern2.comp[11] = 0x01;
	SectionFilterPattern2.comp[12] = 0x00;
	SectionFilterPattern2.comp[13] = 0x00;
	SectionFilterPattern2.comp[14] = 0x00;
	SectionFilterPattern2.comp[15] = 0x00;

	SectionFilterPattern2.mask[0] = 0xFF; 
	SectionFilterPattern2.mask[1] = 0xFF;
	SectionFilterPattern2.mask[2] = 0xFF;
	SectionFilterPattern2.mask[3] = 0xFF; 
	SectionFilterPattern2.mask[4] = 0xFF;
	SectionFilterPattern2.mask[5] = 0xFF;
	SectionFilterPattern2.mask[6] = 0xFF; 
	SectionFilterPattern2.mask[7] = 0xFF;
	SectionFilterPattern2.mask[8] = 0xFF;
	SectionFilterPattern2.mask[9] = 0xFF; 
	SectionFilterPattern2.mask[10] = 0xFF;
	SectionFilterPattern2.mask[11] = 0xFF;
	SectionFilterPattern2.mask[12] = 0x00; 
	SectionFilterPattern2.mask[13] = 0x00;
	SectionFilterPattern2.mask[14] = 0x00;
	SectionFilterPattern2.mask[15] = 0x00; 

	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle2, &SectionFilterPattern2);


	
//the follow sample code for filter ecm section
	memset(&SectionFilterPattern3_1, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern3_1.pid = 0X0575;//ecm pid
	SectionFilterPattern3_1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern3_1.callback_01 = section_callback3_1;
	SectionFilterPattern3_1.options = 1;
	SectionFilterPattern3_1.u32byWaitTimeoutMs = 0;// unit is millisecond
	SectionFilterPattern3_1.comp[0] = 0x80;// comp[0] stands for tid and must be given a value.
	SectionFilterPattern3_1.mask[0] = 0xFF; // mask[0] must be given value 0xFF.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle3_1, &SectionFilterPattern3_1);

	memset(&SectionFilterPattern3_2, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern3_2.pid = 0X0575;//ecm pid
	SectionFilterPattern3_2.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern3_2.callback_01 = section_callback3_1;
	SectionFilterPattern3_2.options = 1;
	SectionFilterPattern3_2.u32byWaitTimeoutMs = 0;// unit is millisecond
	SectionFilterPattern3_2.comp[0] = 0x81;// comp[0] stands for tid and must be given a value.
	SectionFilterPattern3_2.mask[0] = 0xFF; // mask[0] must be given value 0xFF.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle3_2, &SectionFilterPattern3_2);
	




	
	int i=0;
	for(i=SECTIONFILTER_TEST_WAIT_TIME_SECOND;  i> 0;  i--)
	{
		sleep(1);
		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle0);

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle1);

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle2);


	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle3_1);

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle3_2);





	// you can also call RTK_Player_RemoveAllSectionFilters remove all sectionflter filters
/*		
		if(RTK_Player_RemoveAllSectionFilters(gPlayer_1) != RTK_OK)
			printf("Failed to remove all sectionfilter filter\n");
*/	


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	printf("Test finish.\n");
	
	return;
}


#define ZAPPING_WAIT_TIME 10
static RTK_Bool isKeep = RTK_FALSE;
void* ChannelChangeThread(void *)
{

	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		

		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			
			PLAYER_LOCK();

			gettimeofday(&startzaping_1, NULL);

			if(gPlayer_1 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}

				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_1 = NULL;
			}

			if(gPlayer_2 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}

				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_2 = NULL;
			}


			if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("Failed to create player.\n");
				PLAYER_UNLOCK();
				return NULL;
			}

			if (gPlayer_1 == NULL)
			{
				printf("Player is NULL!!");
				PLAYER_UNLOCK();
				return NULL;
			}

			
			PLAYER_UNLOCK();
			
			player_status_1.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_1) != RTK_OK)
			{
				printf("Failed to start player.\n");
				return NULL;
			}
			channel_number = 1;

			memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern0.pid = 0x00;//PAT
			SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern0.callback_01 = section_callback2;
			SectionFilterPattern0.u32byWaitTimeoutMs = 0;
			RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
			
			
			memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern1.pid = 0X01;//CAT
			SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern1.callback_01 = section_callback3;
			SectionFilterPattern1.u32byWaitTimeoutMs = 0;
			RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle1, &SectionFilterPattern1);

			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();

			gettimeofday(&startzaping_2, NULL);
			
			if(gPlayer_1 != NULL)
			{
				
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle1);


				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_1 = NULL;
			}
			if(gPlayer_2 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_2 = NULL;
			}


			if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("Failed to create player.\n");
				PLAYER_UNLOCK();
				return NULL;
			}

			if (gPlayer_2 == NULL)
			{
				printf("Player is NULL!!");
				PLAYER_UNLOCK();
				return NULL;
			}

			PLAYER_UNLOCK();

			player_status_2.eof_reached = RTK_FALSE;
			if(RTK_Player_Start(gPlayer_2) != RTK_OK)
			{
				printf("Failed to start player.\n");
				return NULL;
			}
			channel_number = 2;

			memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern0.pid = 0x00;//PAT
			SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern0.callback_01 = section_callback2;
			RTK_Player_AddSectionFilter(gPlayer_2, &filter_handle0, &SectionFilterPattern0);
			
			
			memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern1.pid = 0X01;//CAT
			SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern1.callback_01 = section_callback3;
			RTK_Player_AddSectionFilter(gPlayer_2, &filter_handle1, &SectionFilterPattern1);
			

			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}



#define TEST_PAUSE_DROP_RESUME

void* MultiViewChannelLiveThread(void *)
{
	THREAD_EXIT_LOCK();
	gThreadExit = RTK_FALSE;
	THREAD_EXIT_UNLOCK();
	
	isKeep = RTK_FALSE;
	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}

			if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_PLAYER) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_1 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_1.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_1) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			

			if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_PLAYER) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_2 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_2.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_2) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 1;
			PLAYER_UNLOCK();
			
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_2 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
			}
			
			if(gPlayer_1 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_1 = NULL;
			}
			
			if(RTK_Player_Create(&gPlayer_3, &Config_3, HAL_TYPE_PLAYER) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_3 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_3.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_3) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			

			channel_number = 2;
			PLAYER_UNLOCK()
				
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}

void* MultiViewChannelChangeThread(void *)
{
	THREAD_EXIT_LOCK();
	gThreadExit = RTK_FALSE;
	THREAD_EXIT_UNLOCK();
	
	isKeep = RTK_TRUE;
	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_2 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
			}
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}

			if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_PLAYER) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_2 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_2.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_2) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 1;
			PLAYER_UNLOCK();
			
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_2 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
			}
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}
			
			if(RTK_Player_Create(&gPlayer_3, &Config_3, HAL_TYPE_PLAYER) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_3 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_3.eof_reached = RTK_FALSE;
			if(RTK_Player_Start(gPlayer_3) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 2;
			PLAYER_UNLOCK()
				
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}

/*simulate digicap UI advertisement fileplay circularly*/
/*unit test needs receive every EOS notify*/
/*/data/adv_files, total 20 files*/

unsigned char file_codec[1][2]={
{RTK_CODEC_VIDEO_H264,RTK_CODEC_AUDIO_AAC},
};
uint16_t av_pid[1][3]={
{512,513,512},
};
void rtk_hal_test_Player_EOS_File_Notify()
{	
	printf("\n rtk_hal_test_Player_EOS_File_Notify enter\n\n");

	static bool test_next_file = RTK_FALSE;
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(file_path);
	UNUSED(count);
	UNUSED(bvideomute);
	
	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	int ch = 0;	
	//test ts file in /data/adv_files, total 20 files

	UNUSED(ch);
	
	int fileCount = 20;
	char fileName[64] = {0};
	for(int i=0;i<fileCount;i++)
	{
		//open adv file one by one
		sprintf(fileName, "/data/adv_files/adv_%d.ts", i);
		file = fopen(fileName, "rb");
		if(file == NULL)
		{
			printf("%s %s %d:fail!! ERROR to open %s !\n", __FILE__, __FUNCTION__, __LINE__, fileName);
			return;
		}
		else
		{	
			printf("%s %s %d:success!! Success to open %s!\n", __FILE__, __FUNCTION__, __LINE__, fileName);
		}
		uint32_t totalFileSize = 0;
		fseek(file,0,SEEK_END);
		totalFileSize=ftell(file);
		rewind(file);
		printf("fileName==%s,totalFileSize==%u\n",fileName,totalFileSize);
		fseek(file,0,SEEK_SET);

		//set video audio codec & pid
		config.video.codec		= (RTK_Codec)file_codec[0][0];
		config.video.pid		= av_pid[0][0];
		config.audio.codec		= (RTK_Codec)file_codec[0][1];//	it can be RTK_CODEC_NONE at initialize time.
		config.audio.pid		= av_pid[0][1];
		config.pcr_pid			= av_pid[0][2];

		gettimeofday(&startzaping_1, NULL);

		int videopid = config.video.pid;
		int audiopid = config.audio.pid;
		config.video.pid = 0;
		config.audio.pid = 0;
	
		if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_PLAYER) != RTK_OK)
		{
			printf("Failed to create player.\n");
			return;
		}

		if (gPlayer_1 == NULL)
		{
			printf("Player is NULL!!");
			return;
		}

		if(RTK_Player_Start(gPlayer_1) != RTK_OK)
		{
			printf("Failed to start player.\n");
			return ;
		}
	
		test_next_file = RTK_FALSE;

		config.video.pid = videopid;
		config.audio.pid = audiopid;

		//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
		RTK_Player_ChangeVideo(gPlayer_1, &config.video);
		RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
		while(test_next_file == RTK_FALSE)
		{
			//get dma buffer.
			RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
					       break;                                                
					} 
					err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);
					if(buffer.isLast == RTK_TRUE)
					{
						printf("read file==%s is end\n",fileName);
						test_next_file = RTK_TRUE;
						break;
					}

					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
					//	no room of internal input buffer. wait some time until available.
					usleep(100000);	//	100ms.
					break;

				default:
					printf("UNKNOWN ERROR!!\n");
					goto ON_ERROR;
					break;
			}
		
			usleep(100000);	//	100ms.	
		}

	//	wait until end of stream event.
	if(buffer.isLast == RTK_TRUE)
	{
		while(!player_status_1.eof_reached)
		{
			sleep(1);
			printf("waiting until eos\n");
		}
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			fclose(file);
			if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
			{
				printf("Failed to stop player.\n");
				return;
			}
			if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
			{
				printf("Failed to destroy player.\n");
				return;
			}
			gPlayer_1 = NULL;
		}
	}
	if(i ==fileCount-1)
		i=0;
}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	
	printf("Test finish.\n");
	
return;

}
/*simulate digicap UI advertisement fileplay circularly*/

void rtk_hal_test_Player_Fileplay2(const char* pFilePath, uint16_t videoPid, uint16_t audioPid, RTK_Codec videoCodec, RTK_Codec audioCodec)
{	
	printf("\n rtk_hal_test_Player_Fileplay2 hello\n\n");
	RTK_Bool is_play_once = RTK_TRUE;
	if(pFilePath == NULL)
	{
		printf("pFilePath is null!!!\n\n");
		return;
	}
	FILE* file = NULL;
	file = fopen(pFilePath, "rb");
	if(file == NULL)
	{
		printf("the file open fail, please chec the file exist or file permissions!!!\n");
		return;
	}
	
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	///////////////////////////////////////////////////////////
	//init parameters
	///////////////////////////////////////////////////////////
	memset(&config, 0, sizeof(config));
	config.callback.function			= player_callback_1;
	config.callback.user_param			= &player_status_1;
	config.input.type					= RTK_INPUT_MEMORY;
	config.video.codec					= videoCodec;
	config.video.pid					= videoPid;
	config.video.encrypted				= RTK_FALSE;
	config.video.output 				= RTK_WIN_MAIN;
	config.audio.codec					= audioCodec; //	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid					= audioPid;
	config.audio.encrypted				= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid						= videoPid;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_PLAYER) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
				//	no room of internal input buffer. wait some time until available.
				usleep(100000);	//	100ms.
				break;

			default:
				printf("UNKNOWN ERROR!!\n");
				goto ON_ERROR;
				break;
		}


		usleep(100000);	//	100ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:

	if(file)
	{
		fclose(file);
		file = NULL;
	}
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;
}

RTK_Demux demux;
static void rtk_hal_test_Demux_DVR_record()
{
	printf("\n rtk_hal_test_Player_DVR_record hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	int isRecordFromFile=0;
	char ch='\0';
	uint32_t totalFileSize=0;

	UNUSED(count);

	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));

	printf("\n Do you want to record from file(Default from tuner)? (y/N):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isRecordFromFile=1;
			printf(" record from file !\n");
		}
		else
		{
			isRecordFromFile=0;
			printf(" record from tuner !\n");
		}
	}
	fflush(stdin);

	if(isRecordFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function		= player_callback_4;
		config.callback.user_param	= &player_status_1;

		//we use RTK_TSInputBuffer to feed data.
		config.input.type = RTK_INPUT_MEMORY;
	
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		config.callback.function = player_callback_4;
		config.input.type = RTK_INPUT_TUNER;
		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}
		
#if 1
	printf("\nPlease Input Record file path:\n");
	scanf("%s", file_path);
	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
#endif

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
#if 1
    RTK_Demux demux;    
    RTK_DemuxConfig Config_demux;
	memset(&Config_demux, 0, sizeof(Config_demux));
	Config_demux.callback.function = player_callback_4;
	Config_demux.callback.user_param	= &player_status_1;
	Config_demux.input.type = RTK_INPUT_TUNER;
#endif	
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Demux_Create(&demux, &Config_demux) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (demux == NULL)
	{
		printf("Player is NULL!!\n");
		return;
	}


	//Player start.
	if(RTK_Demux_Start(demux) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	//RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	//RTK_Player_ChangeAudio(gPlayer_1, &config.audio);


#if 1
#if 1
	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	videoTSFilter.encrypt = RTK_FALSE;
	videoTSFilter.pid = config.video.pid;

	if(RTK_Demux_AddTSFilter(demux, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_FALSE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;

	if(RTK_Demux_AddTSFilter(demux, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}
#else
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;//PAT
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_ONESHOT;
	SectionFilterPattern0.callback_01 = section_callback5;
	SectionFilterPattern0.u32byWaitTimeoutMs = 0;
	RTK_Demux_AddSectionFilter(demux, &filter_handle0, &SectionFilterPattern0);
#endif
#endif	

	if(isRecordFromFile)
	{
		while(1)
		{
			//get dma buffer.

			RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);

			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						usleep(6*1000);
						continue;
					} 

					err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);


					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.

						 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}

			usleep(10*1000);
		
		}
	}
	else
	{
		int i=0;
		for(i=WAIT_TIME_SECOND;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}	
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	if(isRecordFromFile)
	{
		for(int i = 0; i < 10; ++i)
		{
			sleep(1);
			printf("waiting until eos\n");
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				break;
			}
		}
	}
ON_ERROR:

	if(isRecordFromFile)
		fclose(file);

	#if 1
	//remove audio TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, audioTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) audioTSFilterHandle);
	
	//remove video TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, videoTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) videoTSFilterHandle);
	#else
	RTK_Demux_RemoveSectionFilter(demux,filter_handle0);
	#endif


	// you can also call RTK_Player_RemoveAllTSFilters   remove all ts filters
/*	
	if(RTK_Player_RemoveAllTSFilters(gPlayer_1) != RTK_OK)
		printf("Failed to remove all TS filter\n");
*/

	if(RTK_Demux_Stop(demux) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_Demux_Destroy(demux) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	demux = NULL;
	printf("Test finish.\n");

	return;

	
}

static void rtk_hal_test_Player_DVR_record()
{
	printf("\n rtk_hal_test_Player_DVR_record hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	int isRecordFromFile=0;
	char ch='\0';
	uint32_t totalFileSize=0;

	UNUSED(count);

	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));

	

	//Creat a surface.
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	printf("\n Do you want to record from file(Default from tuner)? (y/N):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isRecordFromFile=1;
			printf(" record from file !\n");
		}
		else
		{
			isRecordFromFile=0;
			printf(" record from tuner !\n");
		}
	}
	fflush(stdin);

	if(isRecordFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function	= Record_callback;
		config.callback.user_param	= &player_status_1;

		//we use RTK_TSInputBuffer to feed data.

		config.input.type = RTK_INPUT_MEMORY;

	
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		config.callback.function = player_callback_4;

		config.input.type = RTK_INPUT_TUNER;

		config.callback.function = Record_callback;
		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}

#if 1
	printf("\nPlease Input Record file path:\n");
	scanf("%s", file_path);
	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}

	pvr_pts_fp_player = fopen("/data/rec_pts.dat", "wb");
	if(pvr_pts_fp_player == NULL)
	{
		printf("failed to open pts ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open pts file\n\n");
	}

	pvr_frame_fp_player = fopen("/data/rec_frame.dat", "wb");
	if(pvr_frame_fp_player == NULL)
	{
		printf("failed to open frame ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open frame ts file\n\n");
	}

	pvr_pcr_fp_player = fopen("/data/rec_pcr.dat", "wb");
	if(pvr_pcr_fp_player == NULL)
	{
		printf("failed to open pcr ts file: /data/rec_pcr.dat\n\n");
		return;
	}
	else
	{
		printf("success to open pcr ts file\n\n");
	}

#endif

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}



	//Player start.
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);


	if(RTK_Player_DVRStart(gPlayer_1)!=RTK_OK)
	{
		printf("DVR start failed\n");
		fclose(file);
		fclose(pvr_ts_fp_player);
		fclose(pvr_pts_fp_player);
		fclose(pvr_frame_fp_player);
		fclose(pvr_pcr_fp_player);
	}

	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	videoTSFilter.encrypt = RTK_FALSE;
	videoTSFilter.pid = config.video.pid;

	if(RTK_Player_AddTSFilter(gPlayer_1, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_FALSE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;

	if(RTK_Player_AddTSFilter(gPlayer_1, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}


	if(isRecordFromFile)
	{
		while(1)
		{
			//get dma buffer.
			RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						usleep(6*1000);
						continue;
					} 

					err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.

						 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}

			usleep(10*1000);
		
		}
	}
	else
	{
		int i=0;
		for(i=WAIT_TIME_SECOND;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}	

ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	if(isRecordFromFile)
	{
		for(int i = 0; i < 300; ++i)
		{
			sleep(1);
			printf("waiting until eos\n");
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				break;
			}
		}
	}
ON_ERROR:

	//Stop and Destroy DVR.
	RTK_Player_DVRStop(gPlayer_1);
	fclose(pvr_ts_fp_player);
	fclose(pvr_pts_fp_player);
	fclose(pvr_frame_fp_player);
	fclose(pvr_pcr_fp_player);

	if(isRecordFromFile)
		fclose(file);

	//remove audio TSFilter
	if(RTK_Player_RemoveTSFilter(gPlayer_1, audioTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) audioTSFilterHandle);

	//remove video TSFilter
	if(RTK_Player_RemoveTSFilter(gPlayer_1, videoTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) videoTSFilterHandle);


	// you can also call RTK_Player_RemoveAllTSFilters   remove all ts filters
/*	
	if(RTK_Player_RemoveAllTSFilters(gPlayer_1) != RTK_OK)
		printf("Failed to remove all TS filter\n");
*/

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	RTK_DestorySurface(RTK_WIN_MAIN);

	printf("Test finish.\n");

	return;


}

void rtk_hal_test_Player_DVR_replay()
{
	printf("\n rtk_hal_test_Player_DVR_replay hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;

	UNUSED(count);
#if 0
	if(RTK_TRUE != RTK_DvbGetSMP(0))
	{
		printf("SMP off cannot run the DVR replay\n\n");
		return;
	}
#endif
	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));
	
	config.callback.function	= player_callback_4;
	config.callback.user_param	= &player_status_1;

	//we use RTK_TSInputBuffer to feed data.

	config.input.type = RTK_INPUT_MEMORY;


	printf("\n Do you want to test replay clear mode(Default is encrypt mode)? (y/N):");
	
	int ch = 0;	
	
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			config.input.isEncrypt = RTK_FALSE; //DVR recorded content is not encrypt.
			printf(" test replay clear mode !\n");
		}
		else
		{
			config.input.isEncrypt = RTK_TRUE; //DVR recorded content is encrypt.
			printf(" test replay encrypt mode !\n");
		}
	}
	fflush(stdin);
	
	//Creat a surface.
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	//input file name and pids and codec.
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	//Player start.
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	while(1)
	{
		//get dma buffer.

		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);


		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			
		switch(err)
		{
			case RTK_OK:
			{
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.cEncrypted = RTK_TRUE;
				input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6*1000);
					goto ON_WAIT_EOS;
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					usleep(6*1000);
					continue;
				} 

				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed InputBuffer failed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

				}
			}
			break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}

		usleep(10*1000);
	
	}
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	RTK_DestorySurface(RTK_WIN_MAIN);

	printf("Test finish.\n");

	return;
}




void* TrickPlayControlThread(void *)
{

	sleep(2);//wait for 2s for av play.
	float speed =0.0;


	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		printf("\n\n####################################################################\n");
		printf("Trick Play Control Input:\n");
		printf("a: x0.5\n");
		printf("b: x0.6\n");
		printf("c: x0.8\n");
		printf("d: x1\n");
		printf("e: x1.2\n");
		printf("f: x1.5\n");
		printf("g: x2\n");
		printf("h: pause\n");
		printf("i: resume\n");
		printf("####################################################################\n\n");
		int ch = getchar();
		if(ch != -1)
		{
			RTK_Player_GetPlaySpeed(gPlayer_1, &speed);
			printf("before change speed = %f\n", speed);
			if(ch == 'a')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.5);		
				RTK_Player_Resume(gPlayer_1);
			}
			else if(ch == 'b')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.6);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'c')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.8);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'd')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'e')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1.2);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'f')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1.5);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'g')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetTrickMode(gPlayer_1,RHAL_AV_TRICK_FULLTS);
				RTK_Player_SetPlaySpeed(gPlayer_1, 2);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'h')
			{
				RTK_Player_Pause(gPlayer_1);
			}
			else if(ch == 'i')
			{
				RTK_Player_Resume(gPlayer_1);
			}
			RTK_Player_GetPlaySpeed(gPlayer_1, &speed);
			printf("after change speed = %f\n", speed);
			
		}
		
		usleep(1000);
	}

	return NULL;
}




void rtk_hal_test_Player_TrickPlay(void)
{
	printf("\n rtk_hal_test_Player_TrickPlay hello\n\n");
	
	int threadFlag = 0;
	FILE * file = NULL;
	RTK_TSInputBuffer buffer;
	RTK_PlayerConfig config;
	char file_path[256]={0};

	//gPlayer_1 = NULL;
	gThreadExit = RTK_FALSE;


	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;

	config.input.type			= RTK_INPUT_MEMORY;

	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;

	//create surface
	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);	
	
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}

		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);	
		config.audio.focused = RTK_TRUE;
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);
	 

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("failed to create player.\n");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	//player_status_1.eof_reached = RTK_FALSE;
	
	//Create a thread for section filter parsing.
	pthread_create(&RTKTrickPlayControlThread, NULL, TrickPlayControlThread, (void*)&threadFlag);

	//	feed data until end of file.
	while(1)
	{
		PLAYER_LOCK();
		//get dma buffer.

		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);

		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					usleep(6000);
					goto ON_WAIT_EOS;
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					usleep(6000);
					continue;
				}

				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");

					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.

					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

				}
				usleep(500);
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				usleep(10000);
				break;
				//printf("UNKNOWN ERROR!!\n");
		}
		PLAYER_UNLOCK();

	}


	

ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
		for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
	
ON_ERROR:	
	PLAYER_UNLOCK();
	if(file != NULL)
		fclose(file);

	THREAD_EXIT_LOCK();
	gThreadExit = RTK_TRUE;
	THREAD_EXIT_UNLOCK();

	printf("av stoped, press any key to exit!!\n");
	int status, rc;
	rc = pthread_join(RTKTrickPlayControlThread, (void **)&status);
	if (rc != 0)
		printf("ERROR; return code from pthread_join() is %d\n", rc);

	printf("Thread joined\n");
	RTK_Player_SetTrickMode(gPlayer_1,RHAL_AV_TRICK_IONLY);

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
	}


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy.\n");
	}
	gPlayer_1 = NULL;

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);	
	
	printf("play finished\n");
	return;
}


void rtk_hal_test_Player_audioOutputMode()
{	
	printf("\n rtk_hal_test_Player_audioOutputMode enter\n\n");
	printf("\n you need play mediabrowser file first!\n\n");
	int ch = 0;
	printf("\n Do you want to test spdif output mode?(Y/n):");
	bool isTestSpdif = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestSpdif = RTK_TRUE;
			printf(" Test Spdif output mdoe!\n");
		}
		else
		{
			isTestSpdif = RTK_FALSE;
			printf(" Not Test Spdif output mdoe !\n");
		}
		fflush(stdin);

		if(isTestSpdif == RTK_TRUE)
		{
			printf("\nchoose spdif output mode: \n");
			list_item spdif_output_mode_list[] = 
			{		 
				{"SPDIF_OFF",	 HAL_SPDIF_OFF },
				{"SPDIF_RAW",	 HAL_SPDIF_RAW },
				{"SPDIF_LPCM",	HAL_SPDIF_LPCM },		
			};

			Hal_Spdif_Mode_e output_mode = (Hal_Spdif_Mode_e)show_list("spdif output mode List", spdif_output_mode_list, list_item_cnt(spdif_output_mode_list));
			RTK_Set_Spdif_Output_Mode(output_mode);
			usleep(100*1000);
			Hal_Spdif_Mode_e get_output_mode = HAL_SPDIF_OFF;
			RTK_Get_Spdif_Output_Mode(&get_output_mode);
			printf("get spdif output mode is %d\n",get_output_mode);
		}
	}
	
	printf("\n Do you want to test hdmi output mode?(Y/n):");
	bool isTestHDMI = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestHDMI = RTK_TRUE;
			printf(" Test HDMI output mdoe!\n");
		}
		else
		{
			isTestHDMI = RTK_FALSE;
			printf(" Not Test HDMI output mdoe !\n");
		}
		fflush(stdin);

		if(isTestHDMI == RTK_TRUE)
		{
			printf("\nchoose HDMI output mode: \n");
			list_item hdmi_output_mode_list[] = 
			{		 
				{"HDMI_RAW",	 HAL_HDMI_RAW },
				{"HDMI_LPCM",	 HAL_HDMI_LPCM },
				{"HDMI_LPCM_MULTI_CH",	HAL_HDMI_LPCM_MULTI_CH },
				{"HDMI_AUTO",	 HAL_HDMI_AUTO },	
			};

			Hal_Hdmi_Mode_e output_mode = (Hal_Hdmi_Mode_e)show_list("hdmi output mode List", hdmi_output_mode_list, list_item_cnt(hdmi_output_mode_list));
			RTK_Set_Hdmi_Output_Mode(output_mode);
			usleep(100*1000);
			Hal_Hdmi_Mode_e get_output_mode = HAL_HDMI_RAW;
			RTK_Get_Hdmi_Output_Mode(&get_output_mode);
			printf("get hdmi output mode is %d\n",get_output_mode);
		}
	}
	printf("\n Do you want to test SetAudioOutputMode?(Y/n):");
	bool isTestAudioOutputMode = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestAudioOutputMode = RTK_TRUE;
			printf(" Test SetAudioOutputMode!\n");
		}
		else
		{
			isTestAudioOutputMode = RTK_FALSE;
			printf(" Not Test SetAudioOutputMode !\n");
		}
		fflush(stdin);

		if(isTestAudioOutputMode == RTK_TRUE)
		{
			printf("\nchoose audio output mode: \n");
			list_item audio_output_mode_list[] = 
			{		 
				{"AUDIO_STEREO",	 HAL_AUDIO_STEREO },
				{"AUDIO_MAIN_BILINGUAL",	 HAL_AUDIO_MAIN_BILINGUAL },
				{"AUDIO_SUB_BILINGUAL",	HAL_AUDIO_SUB_BILINGUAL },
				{"AUDIO_FLASH_STEREO",	 HAL_AUDIO_FLASH_STEREO },
				{"AUDIO_FLASH_MAIN_BILINGUAL",	 HAL_AUDIO_FLASH_MAIN_BILINGUAL },
				{"AUDIO_FLASH_SUB_BILINGUAL",	 HAL_AUDIO_FLASH_SUB_BILINGUAL },
			};

			Hal_Audio_Output_Mode_e output_mode = (Hal_Audio_Output_Mode_e)show_list("audio output mode List", audio_output_mode_list, list_item_cnt(audio_output_mode_list));
			RTK_SetAudioOutputMode(output_mode);
		}
	}
	usleep(100*1000);
	printf("Test finish.\n");

	return;

}

/***************************************************************
* FCC Test.
****************************************************************/
#define FCC_CHLIST_FILE_PATH	"/data/vendor/multich_list.txt"
#define FCC_CHLIST_FILE_PATH_2	"/data/vendor/mediadrm/multich_list.txt"
#define halTestPrintf(fmt, args...)	printf(fmt, ##args)	

typedef struct
{
	int  freq;
	int   videopid;
	RTK_Codec   videocodec;
	int   audiopid;
	RTK_Codec   audiocodec;
	int    qam;
	int    lnbmode;
	int    symbolrate;
}RTK_FCCHANNELLIST;

#define FCC_CHLIST_MAX_CH_COUNT (100)

static int g_fcc_test_version = 3;
RTK_Tuner_Type_e gFCC_tunerType=RTK_TUNER_TYPE_DVBC;


static int _parse_FastChangeChannellist(RTK_FCCHANNELLIST *pFCC_chlist, int *pChCount, char *url)
{
	FILE *m_FCCchannellistFile=NULL;

	char strUrl[100];
	char *pch;
	int info = 0;
	int updatelnbmodeflag = 0;
	int m_totalFCCcount=0;
	
	memset(pFCC_chlist, 0, FCC_CHLIST_MAX_CH_COUNT*sizeof(RTK_FCCHANNELLIST));
	
	m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH,"rb");
	
	if(m_FCCchannellistFile == NULL)
	{
		printf("\n open %s err to open path_2\n", FCC_CHLIST_FILE_PATH);
	}

	if(m_FCCchannellistFile == NULL)
	{
		printf("\n path_2 open %s err \n", FCC_CHLIST_FILE_PATH_2);
		return -1;
	}
		
	for(int i = 0; i < FCC_CHLIST_MAX_CH_COUNT; i++)
	{
		memset(strUrl,0,100);
		updatelnbmodeflag = 0;
		if(fgets(strUrl,100,m_FCCchannellistFile)== NULL)
		{
			break;
		}

		//Do not process comments
		if(strncmp(strUrl, "#", 1) == 0)
		{
			continue;
		}

		//get url
		if(strncmp(strUrl, "tuner://", 8) == 0)
		{
			memcpy(url, strUrl, strlen(strUrl) + 1);
			printf("Update_FastChangeChannellist URL: %s\n", url);
		}

		if(strncmp(strUrl, "fq=", 3) == 0)
		{
			pch = strtok(strUrl,"&");				
			while (pch != NULL)
			{
				if(strncmp(pch, "vp=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist video pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videopid = info;
				}
				else if(strncmp(pch, "ap=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist audio pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiopid= info;
				}
				else if(strncmp(pch, "vc=", 3) == 0)
				{
					printf("Update_FastChangeChannellist video codec strings: %s\n", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG2;
					}
					else if(strncmp((pch+3), "MPEG4_PART2", strlen("MPEG4_PART2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG4_PART2;
					}
					else if(strncmp((pch+3), "H264", strlen("H264")) == 0)
					{
						info = RTK_CODEC_VIDEO_H264;
					}
					else if(strncmp((pch+3), "H265", strlen("H265")) == 0)
					{
						info = RTK_CODEC_VIDEO_H265;
					}
					else
					{
						info = RTK_CODEC_NONE;
					}
					printf("Update_FastChangeChannellist video codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videocodec =(RTK_Codec) info;
				}
				else if(strncmp(pch, "ac=", 3) == 0)
				{	
					printf("Update_FastChangeChannellist audio codec strings: %s", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG2;
					}
					else if(strncmp((pch+3), "AACPLUS", strlen("AACPLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AACPLUS;
					}
					else if(strncmp((pch+3), "AAC", strlen("AAC")) == 0)
					{
						info = RTK_CODEC_AUDIO_AAC;
					}
					else if(strncmp((pch+3), "AC3_TRUE_HD", strlen("AC3_TRUE_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_TRUE_HD;
					}
					else if(strncmp((pch+3), "AC3_PLUS", strlen("AC3_PLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_PLUS;
					}
					else if(strncmp((pch+3), "EAC3", strlen("EAC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_EAC3;
					}
					else if(strncmp((pch+3), "AC3", strlen("AC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3;
					}
					else if(strncmp((pch+3), "DTS_HD", strlen("DTS_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS_HD;
					}
					else if(strncmp((pch+3), "DTS", strlen("DTS")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS;
					}
					else if(strncmp((pch+3), "LPCM", strlen("LPCM")) == 0)
					{
						info = RTK_CODEC_AUDIO_LPCM;
					}
					else if(strncmp((pch+3), "MP3", strlen("MP3")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP3;
					}
					else if(strncmp((pch+3), "MP4", strlen("MP4")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP4;
					}				
					else
					{
						info = RTK_CODEC_NONE;
					}
					printf("Update_FastChangeChannellist audio codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiocodec = (RTK_Codec) info;
				}
				else if(strncmp(pch, "fq=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist freq: %d\n", info);
					pFCC_chlist[m_totalFCCcount].freq = info;
				}			
				else if(strncmp(pch, "qa=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist qam: %d\n", info);
					pFCC_chlist[m_totalFCCcount].qam= info;
				}
			   	else if(strncmp(pch, "ln=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist lnbmode: %d\n", info);
					pFCC_chlist[m_totalFCCcount].lnbmode= info;
					updatelnbmodeflag = 1;
				}
				else if(strncmp(pch, "sr=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist symbolrate: %d\n", info);
					pFCC_chlist[m_totalFCCcount].symbolrate= info;
				}
				
				pch = strtok(NULL, "&");
			}
			if(updatelnbmodeflag != 1)
				pFCC_chlist[m_totalFCCcount].lnbmode = 0xff;

			m_totalFCCcount += 1;
		}
		
	}
	
	fclose(m_FCCchannellistFile);
	*pChCount=m_totalFCCcount;
	
	return 0;
}

// only filled cur / up / down
static int g_CH_index_V2[3] ={-1,-1,-1}; // channel number in source program
static RTK_Source g_source[3] ={NULL,NULL,NULL};

void rtk_hal_test_Player_Timeshift()
{
	printf("\n rtk_hal_test_Player_Timeshift hello\n\n");

	RTK_PlayerConfig config;
	RTK_PlayerConfig config2;
	RTK_Bool is_play_once = RTK_TRUE;

	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	int isRecordFromFile=0;
//	char ch='\0';
	uint32_t totalFileSize = 0;

	memset(&config, 0, sizeof(config));
	memset(&config2, 0, sizeof(config2));
	memset(&buffer, 0, sizeof(buffer));

#if 0
	printf("\n Do you want to record from file(Default from tuner)? (y/N):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isRecordFromFile=1;
			printf(" record from file !\n");
		}
		else
		{
			isRecordFromFile=0;
			printf(" record from tuner !\n");
		}
	}
	fflush(stdin);
#endif

// setting config 
	config.callback.function = player_callback_4;	
	config.callback.user_param	= &player_status_1;
	if(isRecordFromFile)
	{
		is_play_once = xIsPlayOnce();

		config.input.type = RTK_INPUT_MEMORY;

		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}

		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{

		config.input.type = RTK_INPUT_TUNER;
		RTK_Tuner_Init();

		rtkmid_input_Tuner_Param(&config.input.tuner);
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	config.audio.focused = RTK_TRUE;

// setting config2
	memcpy(&config2,&config, sizeof(config));
	config2.audio.focused = RTK_TRUE;
	config2.callback.user_param	= &player_status_2;

	config2.input.type = RTK_INPUT_MEMORY;

	config2.input.isEncrypt = RTK_TRUE;
	config2.video.output = RTK_WIN_PIP;

// open timeshift file
	pvr_ts_fp_player = fopen(timeshift_path, "wb+");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open timeshift file: %s\n\n", timeshift_path);
		return;
	}
	else
	{
		printf("success to open timeshift file\n\n");
	}

// Create a surface.
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

// start a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}



	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	videoTSFilter.encrypt = RTK_FALSE;
	videoTSFilter.pid = config.video.pid;
	if(RTK_Player_AddTSFilter(gPlayer_1, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_FALSE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;
	if(RTK_Player_AddTSFilter(gPlayer_1, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}

	if(RTK_Player_DVRStart(gPlayer_1)!=RTK_OK)
	{
		printf("DVR create failed\n");
		fclose(file);
		fclose(pvr_ts_fp_player);
	}	

	if(isRecordFromFile)
	{
		while(1)
		{
			//get dma buffer.

			RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);

			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = is_play_once;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						usleep(6*1000);
						continue;
					}

					err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);


					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.

						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);

					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}

			usleep(10*1000);
		
		}
	}
	else
	{
		int i=0;
		for(i=TIMESHIFT_SWITCH_SEC;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to enter timeshift\n", i);
		}

#if 0
		if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
		{
			printf("Failed to stop player.\n");
			return;
		}
#endif
		uint16_t uiTemp = config.audio.pid;
		config.audio.pid = 0;
		config.audio.focused = RTK_FALSE;
		RTK_Player_ChangeAudio(gPlayer_1, &config.audio);
		
		playTimeshift(&config2);

		config.audio.pid = uiTemp;
		config.audio.focused = RTK_TRUE;
		RTK_Player_ChangeAudio(gPlayer_1, &config.audio);
#if 0
		RTK_Player_Start(gPlayer_1);
#endif
		printf("back to live...........................\n");

		i=TIMESHIFT_SWITCH_SEC;
		for(i=TIMESHIFT_SWITCH_SEC;  i> 0;  i--)
		{
			sleep(1);
			printf("%d s to stop test\n", i);
		}

	}	
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	if(isRecordFromFile)
	{
		for(int i = 0; i < 10; ++i)
		{
			sleep(1);
			printf("waiting until eos\n");
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				break;
			}
		}
	}
ON_ERROR:

	RTK_Player_DVRStop(gPlayer_1);

	if(pvr_ts_fp_player != NULL)
	{
		int fd = 0;
		fflush(pvr_ts_fp_player);
		fd = fileno(pvr_ts_fp_player); 
		fsync(fd); 
		fclose(pvr_ts_fp_player);
		pvr_ts_fp_player = NULL;
	}

	if(isRecordFromFile)
		fclose(file);

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;

	RTK_DestorySurface(RTK_WIN_MAIN);
	return;
}

static pthread_t RTKIPTVMultiViewThread;
UDPReceiver* pUdpReceiver_1 = NULL;
TCPReceiver* pTcpReceiver_1 = NULL;
UDPReceiver* pUdpReceiver_2 = NULL;
TCPReceiver* pTcpReceiver_2 = NULL;
UDPReceiver* pUdpReceiver_3 = NULL;
TCPReceiver* pTcpReceiver_3 = NULL;
RTK_SOCKET_t rtk_socket_1;
RTK_SOCKET_t rtk_socket_2;
RTK_SOCKET_t rtk_socket_3;
bool isTestClosePIP = RTK_FALSE;
void* IPTVMultiViewThread( void *) 
{	
	long count = 0;
	THREAD_EXIT_LOCK_2();
	gThreadExit_2 = RTK_FALSE;
	THREAD_EXIT_UNLOCK_2();
	
	INT8_T socketRet = RTK_ERR;
	RTK_TSInputBuffer buffer_2;
	
	
	if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
	{
		pUdpReceiver_2 = new UDPReceiver();
		if(pUdpReceiver_2 == NULL)
		{
			printf("[%s,%d]\n pUdpReceiver_2 NULL !\n", __func__, __LINE__);
			return NULL;
		}
		printf("[%s,%d]UDP2:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_2.iStrIP, rtk_socket_2.iPort);
		socketRet = pUdpReceiver_2->Open(rtk_socket_2.iPort, (const char*)rtk_socket_2.iStrIP);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pUdpReceiver_2 Open fail !\n", __func__, __LINE__);
			return NULL;
		}
	}
	else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
	{
		pTcpReceiver_2 = new TCPReceiver();
		if(pTcpReceiver_2 == NULL)
		{
			printf("[%s,%d]\n pTcpReceiver_2 NULL !\n", __func__, __LINE__);
			return NULL;
		}
		printf("[%s,%d]TCP2:%d\n", __func__, __LINE__,rtk_socket_2.iPort);
		socketRet = pTcpReceiver_2->Open(rtk_socket_2.iPort);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pTcpReceiver_2 Open fail !\n", __func__, __LINE__);
			return NULL;
		}
	}

	PLAYER_2_LOCK();
	if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_PLAYER) != RTK_OK)
	{
		printf("[%s,%d]Failed to create player.\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}
	if (gPlayer_2 == NULL)
	{
		printf("[%s,%d]Player is NULL!!\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}
	player_status_2.eof_reached = RTK_FALSE;
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("[%s,%d]Failed to start player.\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}	
	PLAYER_2_UNLOCK();
	
	while(1)
	{
		THREAD_EXIT_LOCK_2();
		if(gThreadExit_2 == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK_2();
			break;
		}
		THREAD_EXIT_UNLOCK_2();

		PLAYER_2_LOCK();
		if(gPlayer_2 != NULL)
		{
			//get dma buffer.
			RTK_Error err2 = RTK_Player_GetInputBuffer(gPlayer_2, &buffer_2);
			
			switch(err2)
			{
				case RTK_OK:
					{
						//	read ts data from network.
						if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
						{
							//buffer_2.filled_size = pUdpReceiver_2->Read((char*)buffer_2.memory, buffer_2.size);
							INPUT_SOURCE_t input_info;
							memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
							input_info.udp_receive = pUdpReceiver_2;
							input_info.video_codec_type = Config_2.video.codec;
							x_read_input_data(UDP_INPUT,input_info,&buffer_2);
						}
						else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
						{
							//buffer_2.filled_size = pTcpReceiver_2->Read((char*)buffer_2.memory, buffer_2.size);
							INPUT_SOURCE_t input_info;
							memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
							input_info.tcp_receive = pTcpReceiver_2;
							input_info.video_codec_type = Config_2.video.codec;
							x_read_input_data(TCP_INPUT,input_info,&buffer_2);

						}
						if (buffer_2.filled_size <= 0)	
						{  
							continue;  
						} 

						//request feed.
						err2 = RTK_Player_FeedInputBuffer(gPlayer_2, &buffer_2);
						if(err2 != RTK_OK)
						{
							//feed fail return dma buffer and goto error.
							RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer_2);
							goto ON_ERROR;
						}
						else
						{
							//feed successful return dma buffer.
							RTK_Player_DiscardInputBuffer(gPlayer_2, &buffer_2);
						}
					}
					break;
			
				case RTK_BUFFER_NOT_AVAILABLE:
					{
						//no room of internal input buffer. wait some time until available.
						usleep(100*1000);	//	100ms.
					}
					break;
			
				default:
					{
						printf("UNKNOWN ERROR!!\n");
						goto ON_ERROR;
					}
					break;
			}
		}

		if(isTestClosePIP)
		{
			count ++;
			if(count == 200)
			{
				printf("[%s,%d]Close PIP NOW!!!!\n", __func__, __LINE__);
				if(RTK_Player_Stop(gPlayer_2, RTK_FALSE) != RTK_OK)
				{
					printf("[%s,%d]Failed to stop player.\n", __func__, __LINE__);
				}

				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s,%d]Failed to destroy player.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
				goto ON_ERROR;
			}
		}
		
		PLAYER_2_UNLOCK();
		usleep(1000);
	}
ON_ERROR:

	return NULL;
}

//#define RTK_IPTV_TEST_INPUT_AUTO

void rtk_hal_test_Player_IPTV()
{	
	printf("\n rtk_hal_test_Player_IPTV hello\n\n");
	bool isTestMultiView = RTK_FALSE;
	bool isTestMultiViewChangeChannel = RTK_FALSE;
	//bool isTestHdcpNotify = RTK_FALSE;
	RTK_InputType input_type = RTK_INPUT_MEMORY;
	RTK_WinPlane video_output = RTK_WIN_MAIN;
	RTK_InputType input_type_2 = RTK_INPUT_MEMORY_PIP;
	RTK_WinPlane video_output_2 = RTK_WIN_PIP;

#if 0
	int ch = 0; 
	char pvalue[PROPERTY_VALUE_MAX];
	char hdcpvalue = '1';
	bool hdcpsupport = RTK_TRUE;

	
	printf("\n Do you want to test Multiview?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMultiView = RTK_TRUE;
			printf("\n YES !\n");
		}
		else
		{
			printf("\n Not test Multiview !\n");
		}
	}
	fflush(stdin);

	printf("\n Do you want to play zapping?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMultiViewChangeChannel = RTK_TRUE;
			printf("\n YES !\n");
		}
		else
		{
			printf("\n Not test Multiview !\n");
		}
	}
	fflush(stdin);

	if(isTestMultiViewChangeChannel == RTK_TRUE)
	{
		printf("\n Do you want to play zapping in PIP mode(default MAIN mode)?(Y/n):");

		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				input_type = RTK_INPUT_MEMORY_PIP;
				video_output = RTK_WIN_PIP;
				input_type_2 = RTK_INPUT_MEMORY;
				video_output_2 = RTK_WIN_MAIN;
			}
		}
		fflush(stdin);
	}
	
	if(isTestMultiView)
	{
		printf("\n Do you want to test close PIP channel?(Y/n):");
		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				isTestClosePIP = RTK_TRUE;
				printf("\n YES !\n");
			}
			else
			{
				printf("\n Not test close PIP !\n");
			}
		}
		fflush(stdin);
	}
	
	printf("\n Do you want to test Hdcp notify?(Y/n):");
		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				//isTestHdcpNotify = RTK_TRUE;
				printf("\n YES !\n");
			}
			else
			{
				printf("\n Not test close PIP !\n");
			}
		}
		fflush(stdin);
#endif
	
	///////////////////////////////////////////////////////////
	//init parameters
	///////////////////////////////////////////////////////////
	gPlayer_1 = NULL;
	gPlayer_2 = NULL;
	gPlayer_3 = NULL;
	RTK_TSInputBuffer buffer_1;
	RTK_TSInputBuffer buffer_3;
	memset(&Config_1, 0, sizeof(Config_1));
	memset(&Config_2, 0, sizeof(Config_2));
	memset(&Config_3, 0, sizeof(Config_3));
	memset(&rtk_socket_1, 0, sizeof(rtk_socket_1));
	memset(&rtk_socket_2, 0, sizeof(rtk_socket_2));
	memset(&rtk_socket_3, 0, sizeof(rtk_socket_3));
	INT8_T socketRet = RTK_ERR;
	player_status_1.eof_reached = RTK_FALSE;
	player_status_2.eof_reached = RTK_FALSE;
	player_status_3.eof_reached = RTK_FALSE;
	channel_number = 1;
	/////////////////////////////////////////////////////////////
	//multi-view:Config_1 set
	/////////////////////////////////////////////////////////////
	Config_1.callback.function				= player_callback_1;
	Config_1.callback.user_param			= &player_status_1;
	Config_1.input.type						= input_type;
	Config_1.video.codec					= CHANNEL1_VIDEO_CODEC;
	Config_1.video.pid                    	= CHANNEL1_VIDEO_PID;
	Config_1.video.encrypted             	= RTK_FALSE;
	Config_1.video.output					= video_output;
	Config_1.audio.codec                  = CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	Config_1.audio.pid                    = CHANNEL1_AUDIO_PID;
	Config_1.audio.encrypted              = RTK_FALSE;
	Config_1.audio.enable_raw_output_mode = RTK_FALSE;
	Config_1.pcr_pid						= CHANNEL1_PCR_PID;
	if(video_output == RTK_WIN_MAIN)
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
	}
	
	if(isTestMultiView)
	{
		/////////////////////////////////////////////////////////////
		//multi-view:Config_2 set
		/////////////////////////////////////////////////////////////
		Config_2.callback.function            = player_callback_2;
		Config_2.callback.user_param          = &player_status_2;
		Config_2.input.type                   = input_type_2;
		Config_2.video.codec                  = CHANNEL2_VIDEO_CODEC;
		Config_2.video.pid                    = CHANNEL2_VIDEO_CODEC;
		Config_2.video.encrypted              = RTK_FALSE;
		Config_2.video.output                 = video_output_2;
		Config_2.audio.codec                  = CHANNEL2_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
		Config_2.audio.pid                    = CHANNEL2_AUDIO_PID;
		Config_2.audio.encrypted              = RTK_FALSE;
		Config_2.audio.enable_raw_output_mode = RTK_FALSE;
		Config_2.pcr_pid                      = CHANNEL2_PCR_PID;
		if(video_output_2 == RTK_WIN_MAIN)
		{
			rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
		}
		else
		{
			rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
		}
	}

	if(isTestMultiViewChangeChannel)
	{
		Config_3.callback.function				= player_callback_3;
		Config_3.callback.user_param			= &player_status_3;
		Config_3.input.type 					= input_type;
		Config_3.video.codec					= CHANNEL1_VIDEO_CODEC;
		Config_3.video.pid						= CHANNEL1_VIDEO_PID;
		Config_3.video.encrypted				= RTK_FALSE;
		Config_3.video.output					= video_output;
		Config_3.audio.codec				  = CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
		Config_3.audio.pid					  = CHANNEL1_AUDIO_PID;
		Config_3.audio.encrypted			  = RTK_FALSE;
		Config_3.audio.enable_raw_output_mode = RTK_FALSE;
		Config_3.pcr_pid						= CHANNEL1_PCR_PID;
	}
	
	//set socket param
#ifndef RTK_IPTV_TEST_INPUT_AUTO
	printf("\n Please Input MAIN stream info !\n");
	rtkmid_input_socket(&rtk_socket_1);
	rtkmid_input_AV_type_pid(&Config_1.video,&Config_1.audio, &Config_1.pcr_pid);
	fflush(stdin);
#else
	rtk_socket_1.e_socket_type = RTK_UDP_SOCKET;
	rtk_socket_1.iPort = 49220;
	strcpy(rtk_socket_1.iStrIP,"239.192.38.1");
	Config_1.video.pid = 52;
	Config_1.video.codec = RTK_CODEC_VIDEO_H264;
	Config_1.audio.pid = 53;
	Config_1.audio.codec = RTK_CODEC_AUDIO_AC3;
	Config_1.pcr_pid = 52;
#endif	
	Config_1.audio.focused = RTK_TRUE;
	

	if(isTestMultiView)
	{
#ifndef RTK_IPTV_TEST_INPUT_AUTO
		printf("\n Please Input PIP stream info !\n");
		//set socket param
		rtkmid_input_socket(&rtk_socket_2);
		rtkmid_input_AV_type_pid(&Config_2.video,&Config_2.audio, &Config_2.pcr_pid);
		fflush(stdin);
#else
		rtk_socket_2.e_socket_type = RTK_UDP_SOCKET;
		rtk_socket_2.iPort=49220;
		strcpy(rtk_socket_2.iStrIP, "239.192.40.26");
		Config_2.video.pid= 1215;
		Config_2.video.codec = RTK_CODEC_VIDEO_H264;
		Config_2.audio.pid = 1216;
		Config_2.audio.codec = RTK_CODEC_AUDIO_AC3;
		Config_2.pcr_pid = 1215;
#endif
	}

	if(isTestMultiViewChangeChannel)
	{
		printf("\n Please Input change channel info !\n");
		rtkmid_input_socket(&rtk_socket_3);
		rtkmid_input_AV_type_pid(&Config_3.video,&Config_3.audio, &Config_3.pcr_pid);
		fflush(stdin);
	}
	
	if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
	{
		pUdpReceiver_1 = new UDPReceiver();
		if(pUdpReceiver_1 == NULL)
		{
			printf("[%s,%d]\n pUdpReceiver_1 NULL !\n", __func__, __LINE__);
			return;
		}
		printf("[%s,%d]UDP1:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_1.iStrIP, rtk_socket_1.iPort);
		socketRet = pUdpReceiver_1->Open(rtk_socket_1.iPort, (const char*)rtk_socket_1.iStrIP);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pUdpReceiver_1 Open fail !\n", __func__, __LINE__);
			return;
		}
	}
	else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
	{
		pTcpReceiver_1 = new TCPReceiver();
		if(pTcpReceiver_1 == NULL)
		{
			printf("[%s,%d]\n pTcpReceiver_1 NULL !\n", __func__, __LINE__);
			return;
		}
		printf("[%s,%d]TCP1:%d\n", __func__, __LINE__,rtk_socket_1.iPort);
		socketRet = pTcpReceiver_1->Open(rtk_socket_1.iPort);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pTcpReceiver_1 Open fail !\n", __func__, __LINE__);
			return;
		}
	}
	if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("[%s,%d]Failed to create player.\n", __func__, __LINE__);
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("[%s,%d]Player is NULL!!", __func__, __LINE__);
		return;
	}
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("[%s,%d]Failed to start player.\n", __func__, __LINE__);
		return ;
	}

	if(isTestMultiView)
	{
		pthread_create(&RTKIPTVMultiViewThread, NULL, IPTVMultiViewThread, NULL);
	}

	if(isTestMultiViewChangeChannel)
	{
		if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
		{
			pUdpReceiver_3 = new UDPReceiver();
			if(pUdpReceiver_3 == NULL)
			{
				printf("[%s,%d]\n pUdpReceiver_3 NULL !\n", __func__, __LINE__);
				return;
			}
			printf("[%s,%d]UDP3:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_3.iStrIP, rtk_socket_3.iPort);
			socketRet = pUdpReceiver_3->Open(rtk_socket_3.iPort, (const char*)rtk_socket_3.iStrIP);
			if(socketRet != RTK_OK)
			{
				printf("[%s,%d]\n pUdpReceiver_2 Open fail !\n", __func__, __LINE__);
				return;
			}
		}
		else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
		{
			pTcpReceiver_3 = new TCPReceiver();
			if(pTcpReceiver_3 == NULL)
			{
				printf("[%s,%d]\n pTcpReceiver_3 NULL !\n", __func__, __LINE__);
				return;
			}
			printf("[%s,%d]TCP3:%d\n", __func__, __LINE__,rtk_socket_3.iPort);
			socketRet = pTcpReceiver_3->Open(rtk_socket_3.iPort);
			if(socketRet != RTK_OK)
			{
				printf("[%s,%d]\n pTcpReceiver_3 Open fail !\n", __func__, __LINE__);
				return;
			}
		}

		//Create a thread for section filter parsing.
		pthread_create(&RTKChannelChangeThread, NULL, MultiViewChannelChangeThread, NULL);
	}
	
	//	feed data until end of file.
	while(1)
	{
		PLAYER_LOCK();
		if((gPlayer_1 != NULL) && (channel_number == 1))
		{
			//get dma buffer.
			RTK_Error err1 = RTK_Player_GetInputBuffer(gPlayer_1, &buffer_1);
			//printf("[%s,%d]buffer.memory=%p buffer.size=%d err=%d\n",__func__, __LINE__, buffer_1.memory, buffer_1.size, err1);
			switch(err1)
			{
				case RTK_OK:
					//	read ts data from network.
					if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
					{
						//buffer_1.filled_size = pUdpReceiver_1->Read((char*)buffer_1.memory, buffer_1.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						int read_ret = -1;
						input_info.udp_receive = pUdpReceiver_1;
						input_info.video_codec_type = Config_1.video.codec;
						read_ret = x_read_input_data(UDP_INPUT,input_info,&buffer_1);
					}
					else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
					{
						//buffer_1.filled_size = pTcpReceiver_1->Read((char*)buffer_1.memory, buffer_1.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.tcp_receive = pTcpReceiver_1;
						input_info.video_codec_type = Config_1.video.codec;
						x_read_input_data(TCP_INPUT,input_info,&buffer_1);
					}
					if (buffer_1.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						usleep(5000);	//	5ms.
						continue;  
					}  

					err1 = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer_1);
					//printf("[%s,%d]buffer.memory=%p buffer.size=%d err=%d\n",__func__, __LINE__, buffer_1.memory, buffer_1.size, err1);

					if(err1 != RTK_OK)
					{	
						//	feed fail return dma buffer and goto error.
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer_1);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer_1);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
			}	
		}
		else if((gPlayer_3 != NULL) && (channel_number == 2))
		{
			//get dma buffer.
			RTK_Error err3 = RTK_Player_GetInputBuffer(gPlayer_3, &buffer_3);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			switch(err3)
			{
				case RTK_OK:
					//	read ts data from network.
					if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
					{
						//buffer_3.filled_size = pUdpReceiver_3->Read((char*)buffer_3.memory, buffer_3.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.udp_receive = pUdpReceiver_3;
						input_info.video_codec_type = Config_3.video.codec;
						x_read_input_data(UDP_INPUT,input_info,&buffer_3);
					}
					else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
					{
						//buffer_3.filled_size = pTcpReceiver_3->Read((char*)buffer_3.memory, buffer_3.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.tcp_receive = pTcpReceiver_3;
						input_info.video_codec_type = Config_3.video.codec;
						x_read_input_data(TCP_INPUT,input_info,&buffer_3);
					}
					if (buffer_3.filled_size <= 0)	
					{  
						usleep(5000);	//	5ms.
						continue;  
					}  

					err3 = RTK_Player_FeedInputBuffer(gPlayer_3, &buffer_3);

					if(err3 != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						RTK_Player_DiscardInputBuffer(gPlayer_3, &buffer_3);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Player_DiscardInputBuffer(gPlayer_3, &buffer_3);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
			}	
		}
#if 0
		if (isTestHdcpNotify == RTK_TRUE)
		{

			property_get("hdcp_support_test", pvalue, "1");
			if(pvalue[0] != hdcpvalue)
			{	
				hdcpvalue = pvalue[0];

				if(hdcpvalue == '0') // no
					hdcpsupport = RTK_FALSE;
				else if(hdcpvalue == '1')
					hdcpsupport = RTK_TRUE;
					
				rtk_porting_hdcp_support_notify(hdcpsupport);
			}

		}
#endif
		PLAYER_UNLOCK();
		usleep(10000);	//	10ms.	
	}


	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	int status, rc;
	//release PIP resource
	if(isTestMultiView)
	{
		gThreadExit = RTK_TRUE;
		rc = pthread_join(RTKIPTVMultiViewThread, (void **)&status);
		if (rc != 0)
			printf("[%s:%d]ERROR; return code from pthread_join() is %d\n", __func__,__LINE__, rc);
	}
	if(isTestMultiViewChangeChannel)
	{
		gThreadExit_2 = RTK_TRUE;
		rc = pthread_join(RTKChannelChangeThread, (void **)&status);
		if (rc != 0)
			printf("[%s:%d]ERROR; return code from pthread_join() is %d\n", __func__,__LINE__, rc);
	}
	
	//release resource
	if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_1)
		{
			delete pUdpReceiver_1;
			pUdpReceiver_1 = NULL;
		}
	}
	else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_1)
		{
			delete pTcpReceiver_1;
			pTcpReceiver_1 = NULL;
		}
	}
	if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_2)
		{
			delete pUdpReceiver_2;
			pUdpReceiver_2 = NULL;
		}
	}
	else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_2)
		{
			delete pTcpReceiver_2;
			pTcpReceiver_2 = NULL;
		}
	}
	if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_3)
		{
			delete pUdpReceiver_3;
			pUdpReceiver_3 = NULL;
		}
	}
	else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_3)
		{
			delete pTcpReceiver_3;
			pTcpReceiver_3 = NULL;
		}
	}
	if(gPlayer_1)
	{
		if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_1 = NULL;
	}
	if(gPlayer_2)
	{
		if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_1 = NULL;
	}
	if(gPlayer_3)
	{
		if(RTK_Player_Stop(gPlayer_3,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_3 = NULL;
	}
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	
	printf("Test finish.\n");

	return;

}

void rtk_hal_test_Player_CC()
{	
	printf("\n rtk_hal_test_Player_CC hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	fflush(stdin);
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}		
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	
	timeval cc_start,cc_end;
	int pt_Result;
	int cc_state = 0;
	
	
#if 0
	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= true;	

	int yu = 0; char  s[3];
	fflush(stdin);
       printf("Input  subtitle pid:\n");
       scanf("%d", &yu);
       tsSubtitleConfig.pid = (unsigned short)yu;
       fflush(stdin);
       printf("Input  subtitle language:\n");
       scanf("%s", s);
       printf("language is %c%c%c\n",s[0],s[1],s[2]);
       tsSubtitleConfig.langcode = ((toascii(s[0]))<<16) | (toascii(s[1])<<8) | (toascii(s[2]));
       printf("language code : %x\n",tsSubtitleConfig.langcode);
      	tsSubtitleConfig.idx = 0;
       fflush(stdin);
       printf("Input  subtitle subtype:0/1/2:\n");
       scanf("%d", &yu);
       tsSubtitleConfig.subtype = (RTKAP_SUBTITLE_TYPE_e)yu;   
#endif
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if (config.input.type == RTK_INPUT_MEMORY)
	{
		//RTK_Player_SetAVSyncMode(gPlayer,RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
       gettimeofday(&cc_start,NULL);
	


	INPUT_SOURCE_t input_info;
	memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
	input_info.fp = file;
	input_info.totalFileSize = totalFileSize;
	input_info.video_codec_type = config.video.codec;
	input_info.filePlay_once = RTK_TRUE;

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		 gettimeofday(&cc_end,NULL);
	
               pt_Result= cc_end.tv_sec-cc_start.tv_sec;
	      
		if(pt_Result >= 10  && pt_Result < 20 && cc_state == 0)
	        {
	        	RTK_Player_EnableCCDecoder(gPlayer_1);
			printf("\n Enable transport ccData out for 10 seconds \n");
			cc_state = 1;
	        }
		else  if(pt_Result >= 20  && pt_Result < 30 && cc_state == 1)
		{
			RTK_Player_DisableCCDecoder(gPlayer_1);
			printf("\n Disable transport ccData out for 10 seconds\n");
			cc_state = 2;
		}
		else  if(pt_Result >= 30  && pt_Result < 40 && cc_state == 2)
	        {
	        	RTK_Player_EnableCCDecoder(gPlayer_1);
			printf("\n Enable transport ccData out for 10 seconds \n");
			cc_state = 3;
	        }
		else if(pt_Result >40  && cc_state == 3)
		{
			RTK_Player_DisableCCDecoder(gPlayer_1);
			printf("\n Disable transport ccData out\n");
			cc_state = 4;
		}
	          //printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 )  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer.
					printf("feed Buffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
	
		usleep(10000);	//	10ms.	
	}


	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}
void rtk_hal_test_Player_CCPlayback()
{	
	printf("\n rtk_hal_test_Player_CCPlayback hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	fflush(stdin);
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}		
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	
	timeval cc_start,cc_end;
	int pt_Result;
	int cc_state = 0;
	
	

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if (config.input.type == RTK_INPUT_MEMORY)
	{
		//RTK_Player_SetAVSyncMode(gPlayer,RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
       gettimeofday(&cc_start,NULL);

	INPUT_SOURCE_t input_info;
	memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
	input_info.fp = file;
	input_info.totalFileSize = totalFileSize;
	input_info.video_codec_type = config.video.codec;
	input_info.filePlay_once = RTK_TRUE;
       RTK_ClosedCaption_Param_t info;
	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		 gettimeofday(&cc_end,NULL);
	
               pt_Result= cc_end.tv_sec-cc_start.tv_sec;
	      
		if(pt_Result >= 5  && pt_Result < 15 && cc_state == 0)
	        {
	              RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);
			printf("RTK_Player_SetCCPlayback: true, index:0\n");			 
	        	RTK_Player_SetCCPlayback(gPlayer_1,true,0);
			printf("\n wait for 10 seconds \n");			  	
			cc_state = 1;
	        }
		else  if(pt_Result >= 15  && pt_Result < 25 && cc_state == 1)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum+3);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum+3);
			printf("\n para error ,disable show cc ,wait for 10 seconds\n");
			cc_state = 2;
		}
		else  if(pt_Result >= 25  && pt_Result < 35 && cc_state == 2)
	        {
	        	RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
	        	printf("RTK_Player_SetCCPlayback: false, index:%d\n",info.ccStreamNum-1);
	        	RTK_Player_SetCCPlayback(gPlayer_1,false,info.ccStreamNum-1);
			printf("\n kill play cc thread,wait for 10 seconds \n");			  				
			cc_state = 3;
	        }
		else if(pt_Result >= 35  && pt_Result < 45  && cc_state == 3)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum-2);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum-2);
			printf("\n create cc thread,but para error,not show cc ,wait for 10 seconds\n");
			cc_state = 4;
		}
		else if(pt_Result >=45  && cc_state == 4)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum-1);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum-1);
			printf("\n show cc\n");
			cc_state = 5;
		}
	          //printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 )  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer.
					printf("feed Buffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
	
		usleep(10000);	//	10ms.	
	}


	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}

static void filePlay_withoutTP()
{	
	printf("\n filePlay_withoutTP hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);

	RTK_initialize();

	//we modify the default dvb resource(default support 2 play-withTP) config.
	//Becuase we not use TP, so we only let resConfig.player_usenum is 2.
	RTK_DvbResourceConfig_t resConfig;
	resConfig.demux_usenum=0;  
	resConfig.playerWithTP_usenum=0;
	resConfig.player_usenum=2;
	RTK_DvbResourceConfig(&resConfig);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.output 		= RTK_WIN_MAIN;
		
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

#if 1	
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
#else
    strcpy(file_path,"/data/1.ts");

	config.video.codec			= RTK_CODEC_VIDEO_MPEG2;
	config.video.pid            = 0x200;
	config.video.encrypted		= RTK_FALSE;
	
	config.audio.codec			= RTK_CODEC_AUDIO_MPEG2;
	config.audio.pid			= 0x28A;
	config.audio.focused		= RTK_TRUE;
	config.audio.encrypted		= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;

	file = fopen(file_path, "rb");
#endif
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	//HAL_TYPE_PLAYER mean we not use TP. Only you config this dvb resouce in RTK_DvbResourceConfig,
	//you can use it, otherwise you can not use it.
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_PLAYER) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				    goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				    continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		
		usleep(10000);	//	10ms.	
	}

	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}

	//RTK_finalize will release all the resource.
	RTK_finalize();
	
	printf("Test finish.\n");

	return;

}

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
static void filePlay_feedfromDMAbuffer()
{
	printf("\n filePlay_feedfromDMAbuffer hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);

	printf("########### set SMP ON ##############\n");
	RTK_DvbSetSMP(0,RTK_TRUE);
	RTK_DvbSetSMP(1,RTK_TRUE);

	//malloc dma buffer.
	int ret=0;
	unsigned char *pVirtAddr=NULL;
	unsigned int phyAddr=0;
	int feedSize=0;
	ION_DATA  ionHl;
	ION_DATA  ionHl_sec;

	
	memset(&ionHl, 0x00, sizeof(ION_DATA));
	memset(&ionHl_sec, 0x00, sizeof(ION_DATA));

	//malloc no secure memory.
	ret=rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
		ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

	pVirtAddr=ionHl.ion_virt;
	phyAddr=(unsigned int)ionHl.ion_phy;


	//malloc tp secure memory.
	ret=rtk_ion_malloc(&ionHl_sec, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK, 
		(1<<25)/*ION_FLAG_SECURE_TPACC*/);


	//open dvdplayer ta and use md memcpy to test.
	TEEC_Result Res;
	TEEC_Context ctx;
	TEEC_Session sess;
	unsigned int uErrOrigin;
	TEEC_Operation Op;

	TEEC_SharedMemory srcTShm;
	TEEC_SharedMemory dstTShm;	

	memset(&ctx, 0x00, sizeof(TEEC_Context));
	memset(&sess, 0x00, sizeof(TEEC_Session));
	
	TEEC_UUID uuid={  0x050cda95, 0x3526, 0x4385, \
		{ 0x9c, 0x1d, 0x80, 0xb4, 0xa2, 0xb9, 0x05, 0x76} };
	
	Res = TEEC_InitializeContext(NULL, &ctx);
	if (Res != TEEC_SUCCESS)
	{
			printf("TEEC_InitializeContext failed with code 0x%x", Res);
			return;
	}

	Res = TEEC_OpenSession(&ctx, &sess, &uuid,
			       TEEC_LOGIN_PUBLIC, NULL, NULL, &uErrOrigin);
	if (Res != TEEC_SUCCESS)
	{
		printf("TEEC_Opensession failed with code 0x%x origin 0x%x",Res, uErrOrigin);
		return;	
	}

	srcTShm.flags = TEEC_MEM_INPUT | TEEC_MEM_OUTPUT;
	Res = TEEC_RegisterSharedMemoryFileDescriptor((TEEC_Context*)&ctx, &srcTShm, ionHl.mmap_fd);
	if(Res)
	{
		printf("TEEC_RegisterSharedMemoryFileDescriptor srcTShm failed\n");
		return;
	}

	dstTShm.flags = TEEC_MEM_INPUT | TEEC_MEM_OUTPUT;
	Res = TEEC_RegisterSharedMemoryFileDescriptor((TEEC_Context*)&ctx, &dstTShm, ionHl_sec.mmap_fd);
	if(Res)
	{
		printf("TEEC_RegisterSharedMemoryFileDescriptor srcTShm failed\n");
		return;
	}
	
	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	//config.input.type			= RTK_INPUT_MEMORY_MD;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.output 		= RTK_WIN_MAIN;
		
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

#if 1	
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
#else
    strcpy(file_path,"/data/1.ts");

	config.video.codec			= RTK_CODEC_VIDEO_MPEG2;
	config.video.pid            = 0x200;
	config.video.encrypted		= RTK_FALSE;
	
	config.audio.codec			= RTK_CODEC_AUDIO_MPEG2;
	config.audio.pid			= 0x28A;
	config.audio.focused		= RTK_TRUE;
	config.audio.encrypted		= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;

	file = fopen(file_path, "rb");
#endif
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
		
		RTK_Player_GetTPBufferStatus(gPlayer_1, (uint32_t*)&feedSize, NULL);
		feedSize=feedSize>((200*1024)/188*188)?((200*1024)/188*188):feedSize;
		feedSize=fread(pVirtAddr, 1, feedSize, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			//flush no secure memory.
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);


			#if 1
			//copy data from no secure memory to secure memory.
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE);
			Op.params[0].value.a = (unsigned int)(ionHl_sec.ion_phy); //dst
			Op.params[1].value.a = phyAddr; //src
			Op.params[0].value.b = feedSize;
			
			Res = TEEC_InvokeCommand(&sess, 24/*TA_DTV_CMD_MD_SECUREMEM_COPY*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				return;
			}
			#else
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_MEMREF_PARTIAL_INOUT, TEEC_MEMREF_PARTIAL_INOUT, TEEC_NONE, TEEC_NONE);

			Op.params[0].memref.parent = &dstTShm;
			Op.params[0].memref.offset = 0;
			Op.params[0].memref.size = feedSize;
			
			Op.params[1].memref.parent = &srcTShm;
			Op.params[1].memref.offset = 0;
			Op.params[1].memref.size = feedSize;

			Res = TEEC_InvokeCommand(&sess, 23/*TA_DTV_CMD_TP_SECUREMEM_MOVE*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				return;
			}
			#endif
			
			#if 1
			//feed tp secure memory.
			if(RTK_Player_FeedDMABuffer(gPlayer_1, (uint32_t)(ionHl_sec.ion_phy), feedSize, 2000/*2000 ms*/, false)!=0)
			{
				printf("mtp feed failed\n");
			}
			#else
			//feed no secure memory.
			if(RTK_Player_FeedDMABuffer(gPlayer_1, (uint32_t)(ionHl.ion_phy), feedSize, 2000/*2000 ms*/, false)!=0)
			{
				printf("mtp feed failed\n");
			}
			#endif
		}
				
		usleep(10000);	//	10ms.	
	}

	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}

	TEEC_ReleaseSharedMemory(&dstTShm);
	TEEC_ReleaseSharedMemory(&srcTShm);
	
	rtk_ion_free(&ionHl);
	rtk_ion_free(&ionHl_sec);

	TEEC_CloseSession(&sess);
	TEEC_FinalizeContext(&ctx);

	printf("Test finish.\n");

	return;

}
#endif //end of ENABLE_DVB_HYBRID_WITH_SVP


static void filePlay_RawSample()
{
	printf("\n filePlay_RawSample hello\n\n");

	RTK_PlayerConfig config;
	RTK_EsInputBuf_t input;
	char folder_path[256]={0};
	char sample_path[256]={0};
	char sample_name[64]={0};
	int sample_id=1;
	int isInitSample=1;
	int totalFileSize=0;
	int read_ret;
	int isAudio=0;
	
	FILE * file=NULL;
	unsigned char *pSample_buf=NULL;
#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	char str_smp[16]={0};
#endif	
	unsigned char isSMP=0;
	unsigned int phyAddr=0;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);
	memset(&config, 0x00, sizeof(config));
	memset(&input, 0x00, sizeof(input));

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	int ret=-1;
	ION_DATA  ionHl;
	ION_DATA  ionHl_sec;

	unsigned char *pVirtAddr=NULL;

	memset(&ionHl, 0x00, sizeof(ION_DATA));
	memset(&ionHl_sec, 0x00, sizeof(ION_DATA));

	//malloc no secure memory.
	ret=rtk_ion_malloc(&ionHl, 512*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
		ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

	pVirtAddr=ionHl.ion_virt;
	phyAddr=(unsigned int)ionHl.ion_phy;


	//malloc tp secure memory.
	ret=rtk_ion_malloc(&ionHl_sec, 512*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK, 
		(1<<25)/*ION_FLAG_SECURE_TPACC*/);
	

	//open dvdplayer ta and use md memcpy to test.
	TEEC_Result Res;
	TEEC_Context ctx;
	TEEC_Session sess;
	unsigned int uErrOrigin;
	TEEC_Operation Op;

	TEEC_SharedMemory srcTShm;
	TEEC_SharedMemory dstTShm;	

	memset(&ctx, 0x00, sizeof(TEEC_Context));
	memset(&sess, 0x00, sizeof(TEEC_Session));
	
	TEEC_UUID uuid={  0x050cda95, 0x3526, 0x4385, \
		{ 0x9c, 0x1d, 0x80, 0xb4, 0xa2, 0xb9, 0x05, 0x76} };
	
	Res = TEEC_InitializeContext(NULL, &ctx);
	if (Res != TEEC_SUCCESS)
	{
			printf("TEEC_InitializeContext failed with code 0x%x", Res);
			return;
	}

	Res = TEEC_OpenSession(&ctx, &sess, &uuid,
			       TEEC_LOGIN_PUBLIC, NULL, NULL, &uErrOrigin);
	if (Res != TEEC_SUCCESS)
	{
		printf("TEEC_Opensession failed with code 0x%x origin 0x%x",Res, uErrOrigin);
		return;	
	}
#endif


	RTK_initialize();
	
	//we modify the default dvb resource(default support 2 play-withTP) config.
	//Becuase we need use es player resource, we set esplayer_usenum 1.
	RTK_DvbResourceConfig_t resConfig;
	resConfig.demux_usenum=0;  
	resConfig.playerWithTP_usenum=1;
	resConfig.player_usenum=0;
	resConfig.esplayer_usenum=1;
	RTK_DvbResourceConfig(&resConfig);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.output 		= RTK_WIN_MAIN;
		
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	
	
	printf("\nInput raw sample folder:\n");
	scanf("%s", folder_path);
	
#ifdef ENABLE_DVB_HYBRID_WITH_SVP

	printf("\nSMP config: on/off\n");
	scanf("%s", str_smp);
	
	if(strcmp(str_smp, "on")==0)
	{
		RTK_DvbSetSMP(0, RTK_TRUE);
		RTK_DvbSetSMP(1, RTK_TRUE);
		isSMP=1;
	}
	else 
	{
		RTK_DvbSetSMP(0, RTK_FALSE);
		RTK_DvbSetSMP(1, RTK_FALSE);
		isSMP=0;
	}
#endif

//	int videopid = config.video.pid;
//	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_ES_PLAYER) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	
	if(strstr(folder_path, "samples_a"))
		isAudio=1;

	//feed data until end of file.
	while(1)
	{
		//feed tp secure memory.
		memset(sample_path, 0x00, 256);
		strcpy(sample_path, folder_path);
		
		if(isInitSample && !isAudio)
		{
			//if(isAudio)
			//	strcat(sample_path, "/a_sample_init");
			//else
				strcat(sample_path, "/v_sample.init");
			
			isInitSample=0;
		}
		else
		{
			if(isAudio)
				sprintf(sample_name, "/a_sample.%04d", sample_id);
			else
				sprintf(sample_name, "/v_sample.%04d", sample_id);
			
			strcat(sample_path, sample_name);
			sample_id++;
		}

		printf("sample path is %s\n", sample_path);
		file=fopen(sample_path, "rb");
		if(file==NULL)
		{
			printf("open %s failed\n", sample_path);
			break;
		}
		
		fseek(file, 0, SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("sample size=%d\n",totalFileSize);

		pSample_buf=(unsigned char*)malloc(totalFileSize);
		read_ret=fread(pSample_buf, 1, totalFileSize, file);
		if(read_ret!=totalFileSize)
		{
			printf("file read fail, need read %d, but return %d\n", totalFileSize, read_ret);
		}
#ifdef ENABLE_DVB_HYBRID_WITH_SVP
		if(isSMP)
		{
			memcpy(pVirtAddr, pSample_buf, totalFileSize);
			
			//flush no secure memory.
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);

			//copy data from no secure memory to secure memory.
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE);
			Op.params[0].value.a = (unsigned int)(ionHl_sec.ion_phy); //dst
			Op.params[1].value.a = phyAddr; //src
			Op.params[0].value.b = totalFileSize;
			
			Res = TEEC_InvokeCommand(&sess, 24/*TA_DTV_CMD_MD_SECUREMEM_COPY*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				return;
			}
		}
#endif		

		//now data is in secure buffer;

		if(isAudio)
		{
			input.codec=RTK_CODEC_AUDIO_AAC;
			input.audio_configs.sampleRate=44100;
			input.audio_configs.channelNum=2;
		}	
		else
			input.codec=RTK_CODEC_VIDEO_H264;

		if(!isSMP)
			input.pData=pSample_buf;
		else 
		{
			input.isSecureBuf=1;
			input.isDstSecureBuf =1;
			input.secPhyAddr=phyAddr;
		}
		
		input.length=totalFileSize;
		input.pts=-1;
		/*printf("sample hex dump:%02x %02x %02x %02x %02x %02x %02x %02x\n",
			pSample_buf[0], pSample_buf[1], pSample_buf[2], pSample_buf[3],
			pSample_buf[4], pSample_buf[5], pSample_buf[6], pSample_buf[7]);*/
		
		if(RTK_Player_FeedEsInputBuffer(gPlayer_1, &input, 2000/*2000 ms*/)!=0)
		{
			printf("es feed failed\n");
		}

		free(pSample_buf);
		pSample_buf=NULL;

		fclose(file);
		
		usleep(10000);	//	10ms.	
	}

	
//ON_ERROR:
	
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	RTK_DestorySurface(RTK_WIN_MAIN);

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	rtk_ion_free(&ionHl);
	rtk_ion_free(&ionHl_sec);

	TEEC_CloseSession(&sess);
	TEEC_FinalizeContext(&ctx);
#endif
	
	printf("Test finish.\n");
	RTK_finalize();

	return;

}


static void filePlay_with_SMP_switch(void)
{
	printf("\n filePlay_with_SMP_switch hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
//	long ptsTestCount = 0;
	RTK_Bool bvideomute;
	int switch_wait_count=(100/*1s*/ * 30);
	int test_count=10;
	RTK_Bool smp=RTK_FALSE;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY; 
	config.video.output 		= RTK_WIN_MAIN;

	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	
TEST_BEGIN:
	RTK_initialize();

	RTK_DvbSetSMP(0, smp);
	if(smp==RTK_FALSE)
		smp=RTK_TRUE;
	else
		smp=RTK_FALSE;

	if(RTK_DvbGetSMP(0)==RTK_TRUE)
		printf("########### SMP is ON ##############\n");
	else 
		printf("########### SMP is OFF ##############\n");
	
	switch_wait_count=100*30;
	
	
	 	
	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
 		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		usleep(10000);	//	10ms.
		switch_wait_count--;
		if(switch_wait_count<=0)
			break;
		
	}
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
		
	printf("Test finish.\n");

	RTK_finalize();

	test_count--;
	if(test_count>0)
	{
		goto TEST_BEGIN;
	}
		

	return;
}

//#define __TEST_UPDATE_VO_PLANE__

void rtk_hal_test_Player_Fileplay_Onlypip()
{	
	printf("\n rtk_hal_test_Player_Fileplay hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	long ptsTestCount = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_PIP;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 200, 200, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	bool isTestMute = RTK_FALSE;
	int ch = 0;	
	
	printf("\n Do you want to test Video/Audio mute/unmute?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMute = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestMute = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);
#if 0
	char pvalue[PROPERTY_VALUE_MAX];
	property_set("enable.video.scale", "2");
	bool isTestVideoScale = RTK_FALSE;
	printf("\n Do you want to test video Scale?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestVideoScale = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestVideoScale = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);
#endif	
	if (strlen(FILE_NAME_1) != 0)
	{
		file = fopen(FILE_NAME_1, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if (config.input.type == RTK_INPUT_MEMORY)
	{
		//RTK_Player_SetAVSyncMode(gPlayer,RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	uint32_t u32VolumeVal = 0;
	RTK_audio_GetVolume(&u32VolumeVal);
	printf("get Current Volume val:%d\n",u32VolumeVal);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	RTK_Bool   bMuteStat = RTK_FALSE;
	RTK_Player_GetAudioMute  (gPlayer_1,&bMuteStat);
	
	printf("get Current Audio Mute status :%s\n",bMuteStat == RTK_FALSE ? "UnMute":"Mute");

#if (MTP_AUDIO_CHANGE)
		config2.callback.function = NULL;
		config2.callback.user_param = NULL;
		config2.input.type = RTK_INPUT_MEMORY;
		config2.video.codec = RTK_CODEC_VIDEO_MPEG2; //	it can be RTK_CODEC_NONE at initialize time.
		config2.video.pid = 0x100;
		config2.audio.codec = RTK_CODEC_AUDIO_AAC;	//	it can be RTK_CODEC_NONE at initialize time.
		config2.audio.pid = 0x110;
		config2.video.encrypted = RTK_FALSE;
		config2.audio.encrypted = RTK_FALSE;
		config2.audio.enable_raw_output_mode = RTK_FALSE;
		config2.audio.focused = RTK_FALSE;
		config2.pcr_pid = 0xFFFF;
		RTK_audio_setVolume(30);
		RTK_AudioConfig* audio = (RTK_AudioConfig*)malloc( sizeof(RTK_AudioConfig)*2);
		memcpy( audio, &config.audio, sizeof(RTK_AudioConfig));
		memcpy( (audio+1) , &config2.audio, sizeof(RTK_AudioConfig));
		time0 = pli_getMilliseconds();
#endif

/*
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
*/

	//	feed data until end of file.
	while(1)
	{

#if (MTP_AUDIO_CHANGE)
				time1 = pli_getMilliseconds();
				if (time1 - time0 > 10000)
				{
					static int i = 1;
					if (i == 0)
					{
						audio[0].focused = RTK_TRUE;
						audio[1].focused = RTK_FALSE;
					}
					else
					{
						audio[0].focused = RTK_FALSE;
						audio[1].focused = RTK_TRUE;
					}
					printf("================================== change audio ==================================\n");
		//			RTK_Player_ChangeAudio(gPlayer, audio[i]);
					RTK_Player_ChangeAudioEx(gPlayer_1, &audio, 2);
		
					i = (i == 0) ? 1 : 0;
					//------------------------------------------------------------------------------		
					time0 = time1;
				}
#endif

		#if 0 // DMA buffer feed test. Please include rtk_ion.h 
		{
		int ret=0;
		static unsigned char *pVirtAddr=NULL;
		static unsigned int phyAddr=0;
		int feedSize=0;

		static ION_DATA  ionHl;

		if(ionHl.ion_virt==NULL)
		{
			memset(&ionHl, 0x00, sizeof(ION_DATA));


			ret=rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
				ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

			pVirtAddr=ionHl.ion_virt;
			phyAddr=(unsigned int)ionHl.ion_phy;
		}
		
		feedSize=fread(pVirtAddr, 1, (200*1024)/188*188, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);
			if(RTK_Player_FeedDMABuffer(gPlayer_1, phyAddr, feedSize, 2000/*2000 ms*/)!=0)
			{
				printf("mtp feed failed\n");
			}
		}
		
		}
		#else
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		#endif

#if 0
		if(isTestVideoScale)
		{
			property_get("enable.video.scale", pvalue, "0");
			if(pvalue[0] == '0')// '1'
			{
			    rtk_porting_destory_winSurface(RTK_SURFACE_V1);
			    rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_FALSE, 0, 0);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale",  "2");
			}
			else if(pvalue[0] == '1')
			{
				rtk_porting_destory_winSurface(RTK_SURFACE_V1);
				rtk_test_create_winSurface(RTK_WIN_MAIN, 80, 56, 544, 306);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_TRUE, 544, 306);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale", "2");
			}
		}
#endif

		ptsTestCount++;
		if(ptsTestCount%200 == 0)
		{
			uint64_t ptsValue = 0;
			RTK_Player_GetCurrentDisplayingPTS(gPlayer_1,&ptsValue);
			printf("get Current PTS value:%llu\n",ptsValue);
		}	


#if  1  //temporary for set/get video/audio mute test
		if(isTestMute)	
		{
			count ++;
			if(count == 200)
			{
				printf("\n\n@@@@@@@@@@@@@@	Video Mute  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_TRUE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}
			if(count == 400)
			{
				printf("\n\n@@@@@@@@@@@@@@  Video ***Unmute***  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_FALSE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}

		}
#endif		
//		usleep(10000);	//	10ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}



static void PEScallback(uint32_t filterID , void * pes, uint32_t length, void * userParam)
{
	printf("%s() filterID=%d, pes=0x%x, length=%u, userParam=%p\n",__FUNCTION__,filterID, pes, length, userParam);
}

void rtk_hal_test_Player_PESFilter()
{	
	printf("\n rtk_hal_test_Player_PESFilter hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;

	int isPesFilterFromFile=0;
	char ch='\0';
	uint32_t totalFileSize=0;



	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	printf("\n Do you want to test pes from file(Default from tuner)? (y/N):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isPesFilterFromFile=1;
			printf(" test pes filter from file !\n");
		}
		else
		{
			isPesFilterFromFile=0;
			printf(" test pes filter from tuner !\n");
		}
	}
	fflush(stdin);

	if(isPesFilterFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function		= player_callback_4;
		config.callback.user_param	= &player_status_1;

		//we use RTK_TSInputBuffer to feed data.
		config.input.type			= RTK_INPUT_MEMORY;
	
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		config.callback.function = player_callback_4;
		config.input.type = RTK_INPUT_TUNER;
		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}


	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	RTK_PESFilterPattern pes_pattern;
	pes_pattern.pid = 0x85d;
	pes_pattern.u8filterID = 0;
	pes_pattern.callback = PEScallback;
	pes_pattern.userParam = NULL;	


	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= false;
	tsSubtitleConfig.pid= pes_pattern.pid;

	if(RTK_OK != RTK_Player_SetSubtitle( gPlayer_1,tsSubtitleConfig))
	{
		printf("[%s:%d:%s] RTK_Player_SetSubtitle failed\n",__FILE__,__LINE__,__func__);
	}

	if(RTK_OK != RTK_Player_AddPESFilter(gPlayer_1, &pes_pattern))
	{
		 printf("[%s:%d:%s] failed to add pes filters\n",__FILE__,__LINE__,__func__);	
	}



	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	config.video.pid = videopid;
	config.audio.pid = audiopid;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	config.audio.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	if(isPesFilterFromFile)
	{

		//	feed data until end of file.
		while(1)
		{
			//get dma buffer.
			RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					//input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						usleep(6000);
					        goto ON_WAIT_EOS;                    
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						usleep(6000);
					        continue;                                                
					} 
					err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed nputBuffer failed\n");
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}




			usleep(10000);	//	10ms.	
		}
	}
	else
	{
		int i=0;
		for(i=500;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}

		
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	if(isPesFilterFromFile)
	fclose(file);

	
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_OK != RTK_Player_RemovePESFilter(gPlayer_1, pes_pattern.u8filterID))
	{
		 printf("[%s:%d:%s] failed to removed pes filters\n",__FILE__,__LINE__,__func__);	
	}

	
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;


	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}




/**
** @brief
** main menu table, please add your hal moudle in this
**
*/
static test_item   main_test_menu[] = {

	//{"Test Rtk Example",                rtk_porting_examle_test},
#ifdef __LINARO_SDK__
	{"Test rtk_porting_display",rtk_porting_test_display},
#endif
	
#ifdef ANDROID
	{"Test rtk_hal_test_Player_Sectionfilter",	          rtk_hal_test_Player_Sectionfilter},
	{"Test rtk_hal_test_Player_Fileplay",         rtk_hal_test_Player_Fileplay},
	{"Test rtk_hal_test_Player_FileplayAuto",         rtk_hal_test_Player_FileplayAuto},
	{"Test rtk_hal_test_Player_Tuner",            rtk_hal_test_Player_Tuner},
	{"Test rtk_hal_test_Player_TunerZapping",            rtk_hal_test_Player_TunerZapping},
	{"Test rtk_hal_test_Player_TunerScan", rtk_hal_test_Player_TunerScan},
	{"Test rtk_hal_test_Player_EOS_File_Notify",			rtk_hal_test_Player_EOS_File_Notify},
	{"Test rtk_hal_test_Player_DVR_record", rtk_hal_test_Player_DVR_record},
	{"Test rtk_hal_test_Player_DVR_replay", rtk_hal_test_Player_DVR_replay},
	{"Test rtk_hal_test_Player_IPTV", rtk_hal_test_Player_IPTV},
	#ifndef ENABLE_GLINUX_RTK_PORTING
	{"Test rtk_hal_test_Player_TrickPlay", rtk_hal_test_Player_TrickPlay},
	{"Test rtk_hal_test_Player_audioOutputMode", rtk_hal_test_Player_audioOutputMode},
	{"Test rtk_hal_test_Player_Timeshift", rtk_hal_test_Player_Timeshift},
	#endif
	{"Test filePlay_withoutTP", filePlay_withoutTP},
	{"Test rtk_hal_test_Player_TunerPIP", rtk_hal_test_Player_TunerPIP},
	{"Test rtk_hal_test_Player_FilePIP", rtk_hal_test_Player_FilePIP},
	{"Test rtk_hal_test_Player_Fileplay_Onlypip", rtk_hal_test_Player_Fileplay_Onlypip},

	//{"Test rtk_hal_test_Player_CCPlayback", rtk_hal_test_Player_CCPlayback},
	//{"Test rtk_hal_test_Player_CCData", rtk_hal_test_Player_CC},

	#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	{"Test filePlay_feedfromDMAbuffer", filePlay_feedfromDMAbuffer},
	#endif
	{"Test filePlay_RawSample", filePlay_RawSample},
	{"Test filePlay_with_SMP_switch", filePlay_with_SMP_switch},
	{"Test rtk_hal_test_Demux_DVR_record", rtk_hal_test_Demux_DVR_record},
	//{"Config CAS_switch", CAS_switch}, // for develop test use

	{"rtk_hal_test_Player_PESFilter",rtk_hal_test_Player_PESFilter},		
    {"rtk_hal_test_Player_Fileplay_with_hdmi_delay",rtk_hal_test_Player_Fileplay_with_hdmi_delay},       
#endif
};      
/**
** @brief
** main menu
**
*/
static test_menu main_menu = {
    "RTK Middleware Tester", main_test_menu, (sizeof(main_test_menu)/sizeof(test_item))
};
typedef enum RTK_Demod_Module_Type
{
	RTK_DEMOD_MODULE_TYPE_MXL254C=0,
	RTK_DEMOD_MODULE_TYPE_SONY2837,
	RTK_DEMOD_MODULE_TYPE_MXL258C,
	RTK_DEMOD_MODULE_TYPE_SONY2878,
	RTK_DEMOD_MODULE_TYPE_AVL6211,
	RTK_DEMOD_MODULE_TYPE_MXL541C,
	RTK_DEMOD_MODULE_TYPE_MXL248,
	RTK_DEMOD_MODULE_TYPE_MXL581C,
} RTK_Demod_Module_Type_e; 
int main(int argc, char * argv[])
{
	UNUSED(argc);
	UNUSED(argv);
	printf("\n\nVERSION : V1\n\n");
#ifdef __SHOW_VERSION__	 //xiongz 20190828
    char ver[256]={0};
    if (-1 == RTK_Player_GetVersion(ver))
    {
        char * unknown_version = "unknown";
        memcpy(ver,unknown_version,strlen(unknown_version));
    }
    printf("\n\nVERSION: %s\n",ver);   
#endif	

	printf("\nDo you want to reset the demod module type?(y/n):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{		
			printf("\n Reset the demod module type !\n");
			printf("\nchoose  demod module type\n");
			list_item demod_module_types_list[] = 
			{
				{"MXL254C",RTK_DEMOD_MODULE_TYPE_MXL254C},
				{"SONY2837",RTK_DEMOD_MODULE_TYPE_SONY2837},
				{"MXL258C",RTK_DEMOD_MODULE_TYPE_MXL258C},
				{"SONY2878",RTK_DEMOD_MODULE_TYPE_SONY2878},
				{"AVL6211",RTK_DEMOD_MODULE_TYPE_AVL6211},
				{"MXL541C",RTK_DEMOD_MODULE_TYPE_MXL541C},
				{"MXL248",RTK_DEMOD_MODULE_TYPE_MXL248},
				{"MXL581C",RTK_DEMOD_MODULE_TYPE_MXL581C},
			};
			RTK_Demod_Module_Type_e Domed_type=(RTK_Demod_Module_Type_e)show_list("Demod Module Type List",demod_module_types_list,list_item_cnt(demod_module_types_list));
			property_set("persist.vendor.demodtype",demod_module_types_list[(int)Domed_type].item_desc);
			printf("\nReset demod module type successful!!\n");
			printf("\nPlease reboot the board!!\n");
			break;
		}
		else
		{
			printf(" \nNot reset the demod module type !\n");
		}
	}
	fflush(stdin);
	
	if(gCASType == RTK_CAS_TYPE_NONE)
	{
	#ifdef ENABLE_DVB_HYBRID_WITH_SVP
		char str_smp[32];
		memset(str_smp, 0x00, sizeof(str_smp));

		printf("\nPlease set global SMP: on/off? (if you don't know this, please set off)\n");
		scanf("%s", str_smp);

		if(strcmp(str_smp, "on")==0)
		{
			printf("########### set SMP ON ##############\n");
			RTK_DvbSetSMP(0,RTK_TRUE);
			RTK_DvbSetSMP(1,RTK_TRUE);
		}
		else 
		{
			printf("########### set SMP OFF ##############\n");
			RTK_DvbSetSMP(0,RTK_FALSE);
			RTK_DvbSetSMP(1,RTK_FALSE);
		}
	#endif 	
	}
	else
	{
		if(RTK_DvbGetSMP(0)==RTK_FALSE)
		{
			printf("########### set SMP ON ##############\n");
			RTK_DvbSetSMP(0,RTK_TRUE);
			RTK_DvbSetSMP(1,RTK_TRUE);
		}
	}
	
	rtkmid_show_menu(&main_menu);
	return 0;
}

#endif
