/**
** @Copyright (C), Realtek Semiconductor Corp.
**-------------------------------------------------------------------------------
** @File Name	: av_test.cpp
** @Version		: V2.0
** @Author		: mulderlance
** @Created		: 2016-07-21
** @Description	: Realtek porting init related func porting-API declaration
**-------------------------------------------------------------------------------
*/
#if (RTKPLAYER_ARCH_VER==RTKPLAYER_ARCH_V3)
#include <pthread.h>
#include "rtk_hal_test.h"
#include <sys/file.h>

#ifdef ANDROID
//#include "rtk_porting_rvsdSocket.h"
#include <cutils/properties.h>
#endif

#if defined(USE_RTKHAL_IN_ANDROID8) || defined(USE_RTKHAL_IN_ANDROID9) || defined(USE_RTKHAL_IN_ANDROID10) 
//#include <rtk_ion.h>
#else
//#include <ion.h> 
#endif


#include "rtk_TCPReceiver.h"
#include "rtk_UDPReceiver.h"
#include "rtk_UDP_hal.h"
#include "rtk_hal_test_util.h"

#include "rtk_hal.h"
#include <stdio.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <ctype.h>

#ifdef ENABLE_CDCA
//#include "cdca_client.h"
#include "Rtk_CDCa.h"
#include "cdca_rDebug.h"
#include "cdca_interface.h"
#elif defined(ENABLE_ALTIPROJECT)
#include "alti_client.h"
#include "alti_rDebug.h"
#endif

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
#include <rtk_ion.h>
#ifdef __cplusplus
extern "C" {
#endif
#include "tee_client_api.h"
#include "tee_client_api_extensions.h"

#ifdef __cplusplus
}
#endif

#endif //end of ENABLE_DVB_HYBRID_WITH_SVP

#undef  UNUSED
#define UNUSED(x)	((void)(x))	/* to avoid warnings */

struct timeval startzaping_1, endzaping_1;
double zapingtimeuse_1 =0;
struct timeval startzaping_2, endzaping_2;
double zapingtimeuse_2 =0;

#define DEMUX_TEST_REC (0)

long g_rec_size = 500;
static bool gStopPlayTest = false;
static bool bStopGetCCData = false ;
#if 1

#define FILE_NAME_1	   ""
#define FILE_NAME_2	   ""
#define FILE_NAME_3	   ""

#define CHANNEL1_PCR_PID     	(3030)
#define CHANNEL1_VIDEO_PID     	(3030)
#define CHANNEL1_AUDIO_PID     	(3031)
#define CHANNEL1_PMT_PID 		(1303)
#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_H264)
#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AC3)

#define CHANNEL2_PCR_PID     	(4001)
#define CHANNEL2_VIDEO_PID     	(4001)
#define CHANNEL2_AUDIO_PID    	(4002)
#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_H265)
#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_MPEG2)

#define CHANNEL1_MULTI_PCR_PID     		(1010)
#define CHANNEL1_MULTI_VIDEO_PID     	(1010)
#define CHANNEL1_MULTI_AUDIO_PID     	(1011)
#define CHANNEL1_MULTI_AUDIO_EX_0_PID	(1012)
#define CHANNEL1_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
#define CHANNEL1_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
#define CHANNEL1_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#define CHANNEL2_MULTI_PCR_PID     		(2050)
#define CHANNEL2_MULTI_VIDEO_PID     	(2050)
#define CHANNEL2_MULTI_AUDIO_PID     	(2051)
#define CHANNEL2_MULTI_AUDIO_EX_0_PID	(2052)
#define CHANNEL2_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
#define CHANNEL2_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
#define CHANNEL2_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#else
//-----------------------------------------------------------------------------
//	quick setting
//-----------------------------------------------------------------------------
#if 1
	#define FILE_NAME_1	   "/data/ts18.ts"
	#define FILE_NAME_2	   "/data/zhouhuajian.ts"

	#define CHANNEL1_FLOW_NO       (0)
	#define CHANNEL1_PCR_PID     (3030)
	#define CHANNEL1_VIDEO_PID     (3030)
	#define CHANNEL1_AUDIO_PID     (3031)
	#define CHANNEL1_PMT_PID 		(1303)
	#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_H264)
	#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AC3)

	#define CHANNEL2_FLOW_NO       (1)
	#define CHANNEL2_PCR_PID     (0x1FF)
	#define CHANNEL2_VIDEO_PID     (0x100)
	#define CHANNEL2_AUDIO_PID     (0x110)
	#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_AAC)

	#define CHANNEL1_MULTI_PCR_PID     		(1010)
	#define CHANNEL1_MULTI_VIDEO_PID     	(1010)
	#define CHANNEL1_MULTI_AUDIO_PID     	(1011)
	#define CHANNEL1_MULTI_AUDIO_EX_0_PID	(1012)
	#define CHANNEL1_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL1_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
	#define CHANNEL1_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)
		
	#define CHANNEL2_MULTI_PCR_PID     		(2050)
	#define CHANNEL2_MULTI_VIDEO_PID     	(2050)
	#define CHANNEL2_MULTI_AUDIO_PID     	(2051)
	#define CHANNEL2_MULTI_AUDIO_EX_0_PID	(2052)
	#define CHANNEL2_MULTI_VIDEO_CODEC     	(RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_MULTI_AUDIO_CODEC   	(RTK_CODEC_AUDIO_MPEG2)
	#define CHANNEL2_MULTI_AUDIO_EX_0_CODEC	(RTK_CODEC_AUDIO_MPEG2)

#else
	#define FILE_NAME_1	   "/mnt/media_rw/B296-1EA3/zhou_hwa_jian.ts"
	#define FILE_NAME_2	   "/mnt/media_rw/B296-1EA3/tian_xian_pei.ts"

	#define CHANNEL1_FLOW_NO       (0)
	#define CHANNEL1_PCR_PID     (0x100)
	#define CHANNEL1_VIDEO_PID     (0x100)
	#define CHANNEL1_AUDIO_PID     (0x110)
	#define CHANNEL1_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL1_AUDIO_CODEC   (RTK_CODEC_AUDIO_AAC)

	#define CHANNEL2_FLOW_NO       (1)
	#define CHANNEL2_PCR_PID     (0x200)
	#define CHANNEL2_VIDEO_PID     (0x200)
	#define CHANNEL2_AUDIO_PID     (0x28A)
	#define CHANNEL2_VIDEO_CODEC   (RTK_CODEC_VIDEO_MPEG2)
	#define CHANNEL2_AUDIO_CODEC   (RTK_CODEC_AUDIO_MPEG2)
#endif
#endif

typedef enum
{
	RTK_SEEKWHENCE_SET,
	RTK_SEEKWHENCE_CUR,
	RTK_SEEKWHENCE_END,
}RTK_SEEK_WHENCE;

#define PVR_REC_PTSFILE_PATH		"/data/rec_pts.dat"
#define PVR_REC_FRAMEFILE_PATH		"/data/rec_frame.dat"
#define PVR_REC_PCRFILE_PATH		"/data/rec_pcr.dat"
#define PVR_REC_TAGFILE_PATH		"/data/rec_tag.dat"
#define PVR_REPLAY_SEEK_CMD			"set seek"
#define PVR_REPLAY_TRICK_CMD		"set speed"
#define PVR_REPLAY_PAUSE_CMD		"set pause"
#define PVR_REPLAY_RESUME_CMD		"set resume"

#define RTK_GETSEEKWHENCE_STR(x)	((x == RTK_SEEKWHENCE_CUR) ? "RTK_SEEKWHENCE_CUR" : \
									(x == RTK_SEEKWHENCE_SET) ? "RTK_SEEKWHENCE_SET" : "RTK_SEEKWHENCE_END")
									
static pthread_t RTKChannelChangeThread;
//static pthread_t RTKRecordThread;

static pthread_t RTKTrickPlayControlThread;


static pthread_mutex_t gPlayerMutex = PTHREAD_MUTEX_INITIALIZER;
#define PLAYER_LOCK()		{ pthread_mutex_lock(&gPlayerMutex); }
#define PLAYER_UNLOCK()	{ pthread_mutex_unlock(&gPlayerMutex); }


static pthread_mutex_t gPlayerMutex_2 = PTHREAD_MUTEX_INITIALIZER;
#define PLAYER_2_LOCK()		{ pthread_mutex_lock(&gPlayerMutex_2); }
#define PLAYER_2_UNLOCK()	{ pthread_mutex_unlock(&gPlayerMutex_2); }


static RTK_Bool gThreadExit = RTK_FALSE;
static pthread_mutex_t gThreadExitMutex = PTHREAD_MUTEX_INITIALIZER;
#define THREAD_EXIT_LOCK()		{ pthread_mutex_lock(&gThreadExitMutex); }
#define THREAD_EXIT_UNLOCK()	{ pthread_mutex_unlock(&gThreadExitMutex); }

static RTK_Bool gThreadExit_2 = RTK_FALSE;
static pthread_mutex_t gThreadExitMutex_2 = PTHREAD_MUTEX_INITIALIZER;
#define THREAD_EXIT_LOCK_2()		{ pthread_mutex_lock(&gThreadExitMutex_2); }
#define THREAD_EXIT_UNLOCK_2()	{ pthread_mutex_unlock(&gThreadExitMutex_2); }

static pthread_mutex_t gDataCallbackMutex = PTHREAD_MUTEX_INITIALIZER;
#define DATA_CB_LOCK()		{ pthread_mutex_lock(&gDataCallbackMutex); }
#define DATA_CB_UNLOCK()	{ pthread_mutex_unlock(&gDataCallbackMutex); }

#define  WAIT_TIME_SECOND (40*60*60)//40
#define  SECTIONFILTER_TEST_WAIT_TIME_SECOND 120

#define TUNNER_ZAPPING_MODE    (0)
#define MTP_AUDIO_CHANGE	(0)
#define TIMESHIFT_SWITCH_SEC (10)



//for pvr test
FILE *pvr_ts_fp_player = NULL;
FILE *pvr_pts_fp_player = NULL;
FILE *pvr_frame_fp_player = NULL;
FILE *pvr_pcr_fp_player = NULL;
FILE *pvr_tag_fp_player = NULL;
static char timeshift_path[]="/data/timeshift.ts";

#if (MTP_AUDIO_CHANGE)
RTK_PlayerConfig config2;
INT64_T time0, time1;
#endif

//static RTK_DemuxConfig Config_demux;

typedef struct
{
	RTK_Bool eof_reached;
	RTK_Bool IFrameShowed;
}
PlayerStatus;

static RTK_SectionFilterMask SectionFilterPattern0, SectionFilterPattern1,SectionFilterPattern2,SectionFilterPattern3_1/*,SectionFilterPattern3_2*/;
static RTK_SectionFilterMask SectionFilterPattern4_1, SectionFilterPattern4_2;

RTK_SectionFilter filter_handle0, filter_handle1,filter_handle2,filter_handle3_1,filter_handle3_2;
RTK_SectionFilter filter_handle4_1, filter_handle4_2;	


static RTK_PlayerConfig Config_1, Config_2, Config_3;
PlayerStatus player_status_1;
PlayerStatus player_status_2;
PlayerStatus player_status_3;
RTK_Player gPlayer_1 = NULL;
RTK_Player gPlayer_2 = NULL;
RTK_Player gPlayer_3 = NULL;
RTK_Source gSource_1 = NULL;
RTK_Source gSource_2 = NULL;
RTK_Source gSource_3 = NULL;
static RTK_CAS_Type_e gCASType = RTK_CAS_TYPE_NONE;// RTK_CAS_TYPE_NAGRA_TKL ;
	
unsigned short channel_number =0;
#define MAX_ERROR_CONCEALMENT_LEVEL 4096

typedef struct
{
  int pmt_index;
  int video_in_pmt_index;
  int audio_in_pmt_index;  
}Prog_List;

//for function x_read_input_data parameter input_type, used for file and iptv
typedef enum
{
	FILE_INPUT = 0,
	UDP_INPUT,
	TCP_INPUT,
	TUNER_INPUT,	//reserved, not use
}INPUT_TYPE_e;

//for function x_read_input_data parameter souce_info
typedef struct
{
	FILE *fp;					//for FILE_INPUT
	uint32_t totalFileSize;		//for FILE_INPUT
	UDPReceiver* udp_receive;	//for UDP_INPUT
	TCPReceiver* tcp_receive;	//for TCP_INPUT
	RTK_Codec video_codec_type;
	RTK_Bool filePlay_once;		//this flag TRUE means playing file only once, not circularly
	RTK_Bool cEncrypted;		// RTK_TRUE means file is Encrypted else is not
}INPUT_SOURCE_t;

typedef enum
{
	UNENCRYPT = 0,
	AV_ENCRYPT,
	VIDEO_ENCRYPT,
	AUDIO_ENCRYPT,
}RTK_ENCRYPT_t;

TS_Program_Info m_programInfo;
bool m_isMonitorPAT = 0;
static int m_recvProgramCnt = 0;
INPUT_SOURCE_t input_info;
RTK_SectionFilter m_pmtHandle[PROGRAME_CNT];
uint16_t m_pmtFilterPID[PROGRAME_CNT];

pthread_t waitPMTThread;
RTK_VideoConfig video_config;
RTK_AudioConfig audio_config;
unsigned short pcr_pid=-1;
Prog_List prog_list[64]={{0,0,0}};	
static int file_play_status = 0;
RTK_SectionFilter patHandle;
RTK_SectionFilterMask patPattern;
RTK_SectionFilter catHandle;
RTK_SectionFilterMask catPattern;
static int waitpmt = 1;

static RTK_BOOL gFirstReceiveTSData = RTK_FALSE;
static long gDemuxDataSize = 0;
static long gPlayerFilePoint = 0;

static RTK_Source source = NULL;


//before RTK_Player_FeedInputBuffer, call x_read_input_data to read data from file or iptv
//#define myPrintf(fmt, args...) printf(fmt, ##args)
#define myPrintf(fmt, args...) 
void SectionCallback(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam);
char xAddPMT(uint16_t pid);
void xRemovePMT(RTK_SectionFilter handle);
RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec);
RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec);
void xChangeAvParm(int select_index);
void ThreadWaitPMT();
void* ThreadWaitPMTEntry(void* instance);
void xAddPAT(void);
void xRemovePAT(void);
char xAddSourcePMT(RTK_Source source, uint16_t pid);
RTK_ENCRYPT_t isScramble(int index,int video_index,int audio_index);
const char* StrScramble(int index,int video_index,int audio_index);


#if 0
static int64_t pli_getMilliseconds()
{
    struct timespec tp;
    clock_gettime(CLOCK_MONOTONIC, &tp);

    return (int64_t)tp.tv_sec * 1000 + tp.tv_nsec / 1000000;
}
#endif

void rtk_test_create_winSurface(RTK_WinPlane rtk_win_plane, int x_pos, int y_pos, int width, int height)
{
	//create window
	RTK_WinConfig rtk_win_config;
	rtk_win_config.plane = rtk_win_plane;
	rtk_win_config.pos_x = x_pos;
	rtk_win_config.pos_y = y_pos;
	rtk_win_config.width = width;
	rtk_win_config.height = height;
	RTK_CreateSurface(rtk_win_config);
}
struct flock g_tsFileLock;
static void _xSetFileBusyFlag(int fd, long  start)
{
	g_tsFileLock.l_type = F_WRLCK; 
	g_tsFileLock.l_whence = SEEK_SET;
	g_tsFileLock.l_start = start;
	g_tsFileLock.l_len = 0;
	fcntl(fd, F_SETLKW, &g_tsFileLock);
}

static void _xClearFileBusyFlag(int fd)
{
	g_tsFileLock.l_type = F_UNLCK;
	fcntl(fd, F_SETLKW, &g_tsFileLock);
}
static void section_callback0(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle,enStatus, section[0], length, userParam);
}

static void section_callback1(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static void section_callback2(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static void section_callback3(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(enStatus); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	//printf("%s() handle=%p, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, section[0], length, userParam);
}

static void section_callback3_1(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);UNUSED(enStatus);;	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
}

static volatile int flag_recieved_PAT = 0;
static void section_callback5(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam)
{
	UNUSED(handle); UNUSED(section); UNUSED(length); UNUSED(userParam);	// fix compile warning
	printf("%s() handle=%p, enStatus=%d, table_id=0x%x, length=%u, userParam=%p\n",__FUNCTION__,handle, enStatus, section[0], length, userParam);
	flag_recieved_PAT = 1;
}





static uint32_t x_read_input_data(INPUT_TYPE_e input_type, INPUT_SOURCE_t souce_info,RTK_TSInputBuffer *ibuffer)
{
	myPrintf("**********x_read_input_data enter, input_type==%d**********\n",input_type);
	uint32_t rtkBufferRemainSize = 0;
	rtkBufferRemainSize = (int) ((int)ibuffer->end - (int)ibuffer->memory); //this remainSize do not include ring cycle start part
	//printf("buffer->end=%d buffer.memory=%d,rtkBufferRemainSize=%d\n\n",(int)ibuffer->end,(int)ibuffer->memory,rtkBufferRemainSize);
	myPrintf("rtkBufferRemainSize=%uB,%uKB buffer.size==%uB, %uKB \n",rtkBufferRemainSize,rtkBufferRemainSize/1024,ibuffer->size,ibuffer->size/1024);

	if(input_type == FILE_INPUT)
	{
		if(!souce_info.fp)
			return RTK_Fail;

		if(souce_info.totalFileSize == (uint32_t)-1) // don't care when timeshift
		{
			ibuffer->filled_size = fread(ibuffer->memory, 1, ibuffer->size, souce_info.fp);
			if(ibuffer->filled_size < ibuffer->size)
			{
				ibuffer->isLast = RTK_TRUE;
			}
		}
	    else	
	    {
			myPrintf("file totalFileSize==%u\n",souce_info.totalFileSize);
		
			uint32_t remainFileSize =0;
			remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);			

			if(remainFileSize<188 && remainFileSize>0)
			{
				//printf("remain datasize: %d, packet is incomplete,discard\n",remainFileSize);
				if(souce_info.filePlay_once == RTK_TRUE)
				{
					ibuffer->filled_size = 0;
					ibuffer->isLast = RTK_TRUE;
					printf("buffer->isLast==%d \n",ibuffer->isLast);
					return RTK_Fail;
				}
				else if(souce_info.filePlay_once == RTK_FALSE)
				{
					//printf("...............................................play again...........................................\n");
					fseek(souce_info.fp, 0, SEEK_SET);
					remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);
				}				
			}
			//printf("get ibuffer.size==%uB, %uKB\n",ibuffer->size,ibuffer->size/(1024));
			//printf("file unplay size==%uB, %uKB\n",remainFileSize,remainFileSize/(1024));	             

	 		if(ibuffer->size < 188)
			{
			 	//printf("buffer lower than 188, discard this time\n");  
				return RTK_Fail;
			}
			
			if(ibuffer->size > remainFileSize)			
				ibuffer->filled_size = remainFileSize;			
			else 
				 ibuffer->filled_size = ibuffer->size;
			
			if (RTK_TRUE == souce_info.cEncrypted)
			{
				uint32_t read_ret = 0;
				read_ret = fread(ibuffer->memory, 1, ibuffer->filled_size, souce_info.fp);
				ibuffer->isLast = (feof(souce_info.fp) || (souce_info.totalFileSize - ftell(souce_info.fp)) == 0) ? RTK_TRUE: RTK_FALSE;
			}
			else
			{
				if(ibuffer->filled_size >=188)
				{		
					uint32_t filled_ret = 0;			
					unsigned char *pp = (unsigned char*)ibuffer->memory;
			
					while((ibuffer->filled_size - filled_ret)/188 >0 )
					{               
						fread(pp, 1, 1, souce_info.fp);
						if(pp[0] == 0x47)
						{
							fread(pp+1, 1, 187, souce_info.fp);
							filled_ret += 188;
							pp+= 188;
						}
						else
						  	continue;
			       		}
					ibuffer->filled_size =filled_ret;			
					//printf("ftell(file)==%ldB, %ldKB,feof(file)==%d\n",ftell(souce_info.fp),ftell(souce_info.fp)/1024,feof(souce_info.fp));	
				}
			}
			
			remainFileSize=souce_info.totalFileSize - ftell(souce_info.fp);
			if(remainFileSize == 0 || feof(souce_info.fp))
			{
				//printf("file end end end %d\n", ibuffer->filled_size);
				if(souce_info.filePlay_once == RTK_TRUE)
				{
					ibuffer->isLast = RTK_TRUE;
					printf("buffer->isLast==%d \n",ibuffer->isLast);
				}
				else if(souce_info.filePlay_once == RTK_FALSE)
				{
					fseek(souce_info.fp, 0, SEEK_SET);
					//printf("...............................................play again...........................................\n");
				}
			}
				
		}
		//printf("buffer->isLast==%d \n",ibuffer->isLast);
	}
	else if(input_type == TCP_INPUT || input_type == UDP_INPUT)
	{
		//ibuffer->filled_size = ibuffer->size;
		
		if(souce_info.video_codec_type == RTK_CODEC_VIDEO_H265)
		{
			if(ibuffer->size < (188*8*1100))
				ibuffer->size = ibuffer->size;
			else
				ibuffer->size = (188*8*1100);
		}
		
		uint32_t read_ret = 0;
		{
			if(input_type == TCP_INPUT && souce_info.tcp_receive)
				read_ret  = souce_info.tcp_receive->Read((char*)ibuffer->memory, ibuffer->size);
			else if(input_type == UDP_INPUT && souce_info.udp_receive)
			{
				read_ret = souce_info.udp_receive->Read((char*)ibuffer->memory, ibuffer->size);
			}
			else
			{
				myPrintf("input_type is not supported!\n");
				return RTK_Fail;
			}
		}
		ibuffer->filled_size = read_ret;
		//myPrintf("[%s,%d] read_ret = %d \n", __func__, __LINE__, read_ret);
		if(ibuffer->filled_size != ibuffer->size )
		{
			myPrintf("[%s,%d] iptv:  ibuffer->filled_size != ibuffer->size\n", __func__, __LINE__);
			return RTK_Fail;
		}
	}
	myPrintf("=========read ok=========\n");
	return RTK_OK;
}

//#define CCDUMP(fmt, args...) printf(fmt, ##args)
#define CCDUMP(fmt, args...) printf(fmt, ##args)

#define CC_USERDATA_ITUT35_H264 0xB50031
#define CC_USERDATA_STARTCODE_MPEG2 0x000001B2
#define CC_USER_IDENTIFIER 0x47413934
typedef struct _CC_DATA
{
	unsigned char cc_valid;
	unsigned char cc_type;
	unsigned char cc_data1;
	unsigned char cc_data2;
} CC_DATA_T;

void _xCC_Data_Dump(const CC_DATA_T *pccData, unsigned int cc_data_count)
{
	for(unsigned int cc_data_index=0; cc_data_index<cc_data_count; cc_data_index++)
	{
		if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
		{
			CCDUMP("cc_data_index=%d:  ", cc_data_index);
			CCDUMP("cc_valid = 0x%02x, cc_type =0x%02x, cc_data1 = 0x%02x, cc_data2 = 0x%02x \n", 
				pccData[cc_data_index].cc_valid,  
				pccData[cc_data_index].cc_type,
				pccData[cc_data_index].cc_data1,
				pccData[cc_data_index].cc_data2);
		}
	}
}


static void player_callback_1(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
		
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback1 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			gettimeofday(&endzaping_1, NULL);
	 		zapingtimeuse_1 = 1000000 * (endzaping_1.tv_sec - startzaping_1.tv_sec) + (endzaping_1.tv_usec - startzaping_1.tv_usec);
			if(zapingtimeuse_1 > 0)
	 		printf("Call [rtk_fileplay_zapping] %s()  cost %f s\n", __FUNCTION__, (zapingtimeuse_1/1000000.0));

			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback1 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("player_callback1 : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
			break;			
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						if(pccData)
						{
							delete(pccData);
							pccData= NULL;
						}

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						delete [] pccData;
						pccData= NULL;
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					//printf("player_callback1 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}
			break;

		default:
			printf("player_callback_1 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}

#if 1
static void player_callback_2(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
		
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback2 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			gettimeofday(&endzaping_2, NULL);
	 		zapingtimeuse_2 = 1000000 * (endzaping_2.tv_sec - startzaping_2.tv_sec) + (endzaping_2.tv_usec - startzaping_2.tv_usec);
			if(zapingtimeuse_2 > 0)
	 		printf("Call [rtk_fileplay_zapping] %s() cost %f s\n",__FUNCTION__,  (zapingtimeuse_2/1000000.0));
			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback2 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("%s(%d) player_callback2 : RTK_EOS...\n",__FUNCTION__,__LINE__);
			status->eof_reached = RTK_TRUE;
			break;
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						delete [] pccData;
						pccData= NULL;

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						delete(pccData);
						
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					printf("player_callback1 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}

			break;
		default:
			printf("player_callback_2 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}
#endif

#if 1
static void player_callback_3(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
	
	switch(event)
	{
		case RTK_FIRST_IFRAME_DISPLAYED:
			printf("player_callback3 : RTK_FIRST_IFRAME_DISPLAYED...\n");
			break;
		case RTK_FIRST_AUDIO_FRAME_DECODED:
			printf("player_callback3 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
			break;
		case RTK_EOS:
			printf("player_callback3 : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
			break;
		case RTK_PICTURE_USER_DATA:
			{
				CCDUMP("player_callback3 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u\n", data, data_size);
				unsigned int mpeg2StartCode = 0;
				unsigned int mpeg2UserIdentifier = 0;
				
				unsigned char h264CountryCode = 0;
				unsigned short h264ProviderCode = 0;
				unsigned int h264UserIdentifier = 0;
				
				unsigned int offset = 0;
				UNUSED(offset);
				
				mpeg2StartCode = (pData[0] | pData[1]<<8 | pData[2]<<16 | pData[3]<<24);
				mpeg2UserIdentifier = (pData[4] | pData[5]<<8 | pData[6]<<16 | pData[7]<<24);
				h264CountryCode = pData[0];
				h264ProviderCode = (pData[1]<<8 | pData[2]);
				h264UserIdentifier = (pData[3]<<24 | pData[4]<<16 | pData[5]<<8 | pData[6]);

				//printf("player_callback1 : RTK_PICTURE_USER_DATA: data=%p, data_size=%u, mpeg2StartCode=0x%08x, mpeg2UserIdentifier=0x%08x, h264CountryCode=0x%02x, h264ProviderCode=0x%04x, h264UserIdentifier=0x%08x\n", 
				//	data, data_size, mpeg2StartCode, mpeg2UserIdentifier, h264CountryCode, h264ProviderCode, h264UserIdentifier);

				
				if((CC_USERDATA_STARTCODE_MPEG2 == mpeg2StartCode)&&(CC_USER_IDENTIFIER == mpeg2UserIdentifier))
				{
					//0x00 00 01 B2 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char mpeg2CCCountPerCCData = 0;
						unsigned char offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+mpeg2CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: mpeg2 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}
					
					CCDUMP("mpeg2 cc data count=%d\n",cc_data_count);
					
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char offset = 0;
					unsigned char mpeg2CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					while(cc_data_size < data_size)
					{
						offset = 8+1;//8: mpegfalg; 1: cc_data_type_code;
						cc_data_index = 0;

						mpeg2CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						pccData = new  CC_DATA_T[mpeg2CCCountPerCCData];
						memset(pccData, 0x00, mpeg2CCCountPerCCData*sizeof(CC_DATA_T));

						while(cc_data_index < mpeg2CCCountPerCCData)
						{
							pccData[cc_data_index].cc_valid = (unsigned char)(pData[cc_data_size+offset+1+1]) &0x04>>2;
							pccData[cc_data_index].cc_type = (unsigned char)(pData[cc_data_size+offset+1+1] )&0x03;
							pccData[cc_data_index].cc_data1 = (unsigned char)(pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (unsigned char)(pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset +=3;
						}				
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, mpeg2CCCountPerCCData);
						if(pccData)
						{
							delete []pccData;
							pccData= NULL;
						}

						cc_data_size += (8+1+1+1+mpeg2CCCountPerCCData*3+1);//8:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
					}
				}
				else if((CC_USERDATA_ITUT35_H264 == (h264CountryCode<<16|h264ProviderCode))&&(CC_USER_IDENTIFIER == h264UserIdentifier))
				{
					//0xb5 00 31 47 41 39 34
					//find cc_data count.
					unsigned int cc_data_count = 0;
					unsigned int cc_data_size = 0;
					while(cc_data_size < data_size)
					{
						unsigned char h264CCCountPerCCData = 0;
						unsigned char offset = 7+1;//7: mpegfalg; 1: cc_data_type_code;
						if((cc_data_size+offset) >= data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						cc_data_size += (offset+1+1+h264CCCountPerCCData*3+1);//offset:mpegfalg+cc_data_type_code ; 1: cc_count; 1:reserved; 1:markerbit
						if(cc_data_size > data_size)
						{
							printf(" %s %d: h264 cc data size error!!\n", __FILE__, __LINE__);
							break;
						}
						cc_data_count ++;
					}	
					CCDUMP("h264CCDataCount=%d\n", cc_data_count);

					int ccflag = 0;
					cc_data_size = 0;
					unsigned int cc_data_index=0;
					unsigned char h264CCCountPerCCData = 0;
					CC_DATA_T *pccData = NULL;
					unsigned char offset = 0;
					while(cc_data_size < data_size)
					{	
						offset = 7+1;//8: mpegfalg; 1: cc_count; 1:reserved; 
						cc_data_index = 0;
							
						//printf(" data[%d]=0x%x, data[%d]=0x%x, data[%d]=0x%x\n", cc_data_size+offset, pData[cc_data_size+offset], cc_data_size+offset+1+1, pData[cc_data_size+offset+1], cc_data_size+offset+1+1, pData[cc_data_size+offset+1+1]);
						h264CCCountPerCCData = (unsigned char)(pData[cc_data_size+offset])&0x1F;
						//CCDUMP("h264CCCountPerCCData=%d\n", h264CCCountPerCCData);
						pccData = new  CC_DATA_T[h264CCCountPerCCData];
						memset(pccData,0x00,  h264CCCountPerCCData*sizeof(CC_DATA_T));
						while(cc_data_index < h264CCCountPerCCData)
						{				
							pccData[cc_data_index].cc_valid = ((pData[cc_data_size+offset+1+1]) &0x04)>>2;
							pccData[cc_data_index].cc_type = (pData[cc_data_size+offset+1+1])&0x03;
							pccData[cc_data_index].cc_data1 = (pData[cc_data_size+offset+1+1+1]);
							pccData[cc_data_index].cc_data2 = (pData[cc_data_size+offset+1+1+1+1]);
							cc_data_index++;
							offset += 3;
						}
						printf("_xCC_Data_Dump \n");
						_xCC_Data_Dump(pccData, h264CCCountPerCCData);
						for(int cc_data_index=0; cc_data_index<h264CCCountPerCCData; cc_data_index++)
						{
							if((pccData[cc_data_index].cc_valid == 0x01) && ((pccData[cc_data_index].cc_type == 0x02)||(pccData[cc_data_index].cc_type == 0x03)))
							{
								ccflag = 1;//this cc callback has valid data.
								break;
							}
						}

						delete(pccData);
						
						cc_data_size += (7+1+1+1+h264CCCountPerCCData*3+1);//8: mpegfalg; 1: cc_count; 1:reserved; 1:markerbit

					}
					if(ccflag == 1)
					{
						printf("\n");			
						for(unsigned int i=0; i<data_size; i++)
						{
							printf("%02x ", pData[i]);
							if((i+1)%41==0)
							{
								printf("\n");
							}
						}
						printf("\n");
					}

				}
				else
				{
					printf("player_callback3 : RTK_PICTURE_USER_DATA not notify!!!error!!!...\n");
				}
			}

			break;
		default:
			printf("player_callback_3 event=%d, data=%p, data_size=%u\n",event, data, data_size);
			break;
	}
}
#endif

static void player_callback_4(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{
	static int printCount;
	UNUSED(printCount);
	PlayerStatus * status = (PlayerStatus*)user_param;
	//unsigned char *pData = (unsigned char *)data;

	(void)type;	// fix compile warning
	
	switch(event)
	{
	case RTK_FIRST_IFRAME_DISPLAYED:
		status->IFrameShowed = RTK_TRUE;
		printf("player_callback4 : RTK_FIRST_IFRAME_DISPLAYED...\n");
		break;
	case RTK_FIRST_AUDIO_FRAME_DECODED:
		printf("player_callback4 : RTK_FIRST_AUDIO_FRAME_DECODED...\n");
		break;
	case RTK_EOS:
		printf("player_callback4 : RTK_EOS...\n");
		status->eof_reached = RTK_TRUE;
		break;
	case RTK_FILTER_TS_DATA:
		{
			if(pvr_ts_fp_player)
			{		
				DATA_CB_LOCK();
				_xSetFileBusyFlag(fileno(pvr_ts_fp_player), gDemuxDataSize);
				
				if(0== fseek(pvr_ts_fp_player, gDemuxDataSize, SEEK_SET))
				{
					fwrite( data, data_size, 1, pvr_ts_fp_player);
					fflush(pvr_ts_fp_player);
					gDemuxDataSize = ftell(pvr_ts_fp_player);
					_xClearFileBusyFlag(fileno(pvr_ts_fp_player));
					DATA_CB_UNLOCK();
					if(gFirstReceiveTSData == RTK_FALSE)
					gFirstReceiveTSData = RTK_TRUE;
				}
				else
				{
					printf("player_callback4 : RTK_FILTER_TS_DATA...fseek pvr_ts_fp_player errno:%d\n",errno);
					_xClearFileBusyFlag(fileno(pvr_ts_fp_player));
					DATA_CB_UNLOCK();
				}
			}
		}
		break;
	case RTK_FILTER_TS_INDEX:	//	data -> RTK_TS_Index
	case RTK_FILTER_TS_CTRL:		//	data -> RTK_TS_Ctrl
		break;
	case RTK_FILTER_TS_TAG:
		{
			if(pvr_tag_fp_player)
			{
				fwrite( data, data_size, 1, pvr_tag_fp_player);
			}
		}
		break;
	default:
		printf("player_callback_4 event=%d, data=%p, data_size=%u\n",event, data, data_size);
		break;
	}

	return;
			
}


void Record_callback(RTK_CallbackEvent event, HAL_TYPE type, void * user_param, void * data, uint32_t data_size)
{	
	//PlayerStatus * status = (PlayerStatus*)user_param;

	(void)type;	// fix compile warning
	PlayerStatus * status = (PlayerStatus*)user_param;
	
	switch(event)
	{
		case RTK_EOS:
			printf("Record_callback : RTK_EOS...\n");
			status->eof_reached = RTK_TRUE;
		break;
		
		case RTK_FILTER_TS_DATA:
		{
			if(pvr_ts_fp_player)
			{
				fwrite( data, data_size, 1, pvr_ts_fp_player);
			}
		}
		break;
		
		case RTK_FILTER_TS_INDEX:
		{
			if(pvr_frame_fp_player)
			{
				if((NULL != data) && (data_size > 0))
				{
					if((data_size % sizeof(RTK_TS_Index)) != 0)
					{
						printf("data_size is NOT multiple of sizeof(RTK_TS_Index)\n");
						break;
					}
					//store RTK_FILTER_TS_INDEX.
					RTK_TS_Index * ptFrameInfo = (RTK_TS_Index*)data;

					for(uint32_t i = 0; i < (data_size / sizeof(RTK_TS_Index)); i++)
					{
						fwrite(ptFrameInfo, sizeof(RTK_TS_Index), 1, pvr_frame_fp_player);
						++ptFrameInfo;
					}
				}
			}
		}
		break;
		
		case RTK_FILTER_TS_CTRL:
		{
			if(pvr_pts_fp_player)
			{
				//store RTK_FILTER_TS_CTRL.
				if((NULL != data) && (data_size > 0))
				{
					if((data_size % sizeof(RTK_TS_Ctrl)) != 0)
					{
						printf("%s() data_size is not multiple of sizeof(RTK_TS_Ctrl)!!\n", __func__);
						break;
					}

					RTK_TS_Ctrl *ptPTSInfo = (RTK_TS_Ctrl*)data;
					for(uint32_t i = 0; i < (data_size / sizeof(RTK_TS_Ctrl)); i++)
					{
						fwrite(ptPTSInfo, sizeof(RTK_TS_Ctrl), 1, pvr_pts_fp_player);
						++ptPTSInfo;
					}
				}
			}
		}
		break;
		
		case RTK_FILTER_TS_PCR:
			if(pvr_pcr_fp_player)
			{
				fwrite( data, data_size, 1, pvr_pcr_fp_player);
			}
		break;
		
		case RTK_FILTER_TS_TAG:
		{
			if(pvr_tag_fp_player)
			{
				fwrite( data, data_size, 1, pvr_tag_fp_player);
			}
		}
		break;
		
		default:
			printf("unhandled event: %d\n", event);
		break;
	}
}

RTK_Codec _xTS_Transfer_Video_Codec(unsigned short codec)
{
	RTK_Codec eRtkVideoCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG1;
			break;
		case TS_PSI_ST_ATSC_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_13818_2_Video://TS_PSI_DT_VideoStream
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG2;
			break;
		case TS_PSI_ST_14496_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_MPEG4_PART2;
			break;			
		case TS_PSI_ST_14496_10_Video:// TS_PSI_DT_MPEG4_Video
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexG_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_14496_10_AnnexH_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H264;
			break;
		case TS_PSI_ST_23008_2_Video:
			eRtkVideoCodec = RTK_CODEC_VIDEO_H265;
			break;
		case TS_PSI_DT_AVC:
			break;
		case TS_PSI_ST_AVS_Video:
			//eRtkVideoCodec = RTK_VIDEO_CODEC_TYPE_AVS;
			break;
		default:
			break;
	}

	return eRtkVideoCodec;
}

RTK_Codec _xTS_Transfer_Audio_Codec(unsigned short codec)
{
	RTK_Codec eRtkAudioCodec = RTK_CODEC_NONE;

	switch(codec)
	{
		case TS_PSI_ST_11172_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG1;
			break;
		case TS_PSI_ST_13818_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MPEG2;
			break;
		case TS_PSI_ST_13818_7_AAC:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AAC;
			break;
		case TS_PSI_ST_14496_3_Audio:
			eRtkAudioCodec = RTK_CODEC_AUDIO_MP4;
			break;
		case TS_PSI_ST_ATSC_AC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3;
			break;
		case TS_PSI_ST_ATSC_EAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_AC3_PLUS;//RTK_AUDIO_CODEC_TYPE_AAC_PLUS_LOAS
			break;
		case TS_PSI_ST_ATSC_DTS:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS;
			break;
		case TS_PSI_ST_ATSC_DTS_HD:
			eRtkAudioCodec = RTK_CODEC_AUDIO_DTS_HD;
			break;
		case TS_PSI_ST_DRA_Audio:
			//eRtkAudioCodec = RTK_AUDIO_CODEC_TYPE_DRA;
			break;
		case TS_PSI_DT_DVB_EnhancedAC3:
			eRtkAudioCodec = RTK_CODEC_AUDIO_EAC3;
			break;
		default:
			break;
	}

	return eRtkAudioCodec;
}

const char* StrScramble(int index,int video_index,int audio_index)
   {
      	 if(isScramble(index,video_index,audio_index)==UNENCRYPT)
		return "false";
	else if(isScramble(index,video_index,audio_index)==AV_ENCRYPT)
		return  "AV Both Scramble";
	else if(isScramble(index,video_index,audio_index)==VIDEO_ENCRYPT)
		return "VIDEO  Scramble";	
	else if(isScramble(index,video_index,audio_index)==AUDIO_ENCRYPT)
		return  "AUDIO  Scramble";	
	else
		return "false";	
  }

RTK_ENCRYPT_t isScramble(int index,int video_index,int audio_index)
{

    if(m_programInfo.cat_program.CasIDCount>0)
    	{    	
    	   for(int i = 0; i<m_programInfo.psi_program[index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{					  
					   return AV_ENCRYPT;
					}
		   		}
         for(int i=0;i<m_programInfo.psi_program[index].video_pids[video_index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].video_pids[video_index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{
					  return VIDEO_ENCRYPT;
					}
		   		}
	for(int i=0;i<m_programInfo.psi_program[index].audio_pids[audio_index].CasIDCount;i++)
		   	for(int j =0;j<m_programInfo.cat_program.CasIDCount;j++){
				if(m_programInfo.psi_program[index].audio_pids[audio_index].cas_id[i] == m_programInfo.cat_program.cas_id[j])
					{
					  return AUDIO_ENCRYPT;
					}
		   		}
			
    	}
	return UNENCRYPT;
   
}

void xChangeAvParm(int select_index)
{
	
	static int vpid_bk = -1;
	static int apid_bk = -1;
	int pmt_index = prog_list[select_index].pmt_index;
	int video_index_inpmt = prog_list[select_index].video_in_pmt_index;
	int audio_index_inpmt = prog_list[select_index].audio_in_pmt_index;
    uint8_t video_nums;
    uint8_t audio_nums;
#ifdef ENABLE_CDCA
    RTKCA_Descramble_ECM_info_t ecm_info;
	uint32_t tsid =0x202;
    memset(&ecm_info,0,sizeof(RTKCA_Descramble_ECM_info_t));
    video_nums = m_programInfo.psi_program[pmt_index].num_video_pids;
    audio_nums = m_programInfo.psi_program[pmt_index].num_audio_pids;
    ecm_info.source_handle=(int)source;
    ecm_info.emm_pid = m_programInfo.cat_program.ca_pid[video_index_inpmt];
    ecm_info.program_id=m_programInfo.psi_program[pmt_index].program_number ;

    for(int i=0;i<video_nums;i++)
    {
        if(m_programInfo.psi_program[pmt_index].video_pids[i].CasIDCount>0)
        {
        #ifdef ENABLE_REMAP_ECMPID
			Rtk_CDCA::getInstance()->MapExmCreate(tsid,m_programInfo.psi_program[pmt_index].video_pids[i].ca_pid[0],(int)source);
			ecm_info.ecm_AVPids[i].ecm_pid = tsid;
			tsid++;
		#else
			ecm_info.ecm_AVPids[i].ecm_pid = m_programInfo.psi_program[pmt_index].video_pids[i].ca_pid[0];
		#endif
        }
        else
        {
        #ifdef ENABLE_REMAP_ECMPID
			Rtk_CDCA::getInstance()->MapExmCreate(tsid,m_programInfo.psi_program[pmt_index].ca_pid[0],(int)source);
			ecm_info.ecm_AVPids[i].ecm_pid = tsid;
		#else
			ecm_info.ecm_AVPids[i].ecm_pid = m_programInfo.psi_program[pmt_index].ca_pid[0];
		#endif
        }
        ecm_info.ecm_AVPids[i].stream_pid = m_programInfo.psi_program[pmt_index].video_pids[i].pid;
    }

    for(int i=0;i<audio_nums;i++)
    {
        if(m_programInfo.psi_program[pmt_index].audio_pids[i].CasIDCount>0)
        {
        #ifdef ENABLE_REMAP_ECMPID
			Rtk_CDCA::getInstance()->MapExmCreate(tsid,m_programInfo.psi_program[pmt_index].audio_pids[i].ca_pid[0],(int)source);
			ecm_info.ecm_AVPids[i+video_nums].ecm_pid = tsid;
			tsid++;
		#else
			ecm_info.ecm_AVPids[i+video_nums].ecm_pid = m_programInfo.psi_program[pmt_index].audio_pids[i].ca_pid[0];
		#endif
        }
        else
        {
        #ifdef ENABLE_REMAP_ECMPID
			Rtk_CDCA::getInstance()->MapExmCreate(tsid,m_programInfo.psi_program[pmt_index].ca_pid[0],(int)source);
			ecm_info.ecm_AVPids[i+video_nums].ecm_pid = tsid;
		#else
			ecm_info.ecm_AVPids[i+video_nums].ecm_pid = m_programInfo.psi_program[pmt_index].ca_pid[0];
		#endif
        }
        ecm_info.ecm_AVPids[i+video_nums].stream_pid = m_programInfo.psi_program[pmt_index].audio_pids[i].pid;
    }
    
    Rtk_CDCA::getInstance()->StartDescramble(0/*main*/, ecm_info);
#endif
	if((vpid_bk == m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].pid)\
		&& (apid_bk == m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].pid)&&(file_play_status ==1))
		return;
	if( m_programInfo.psi_program[pmt_index].version == 0xff) // not ready
		return;

	if( !m_programInfo.psi_program[pmt_index].received ) // not ready
		return;

	
	vpid_bk =  m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].pid;
	apid_bk =  m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].pid;
	
      Config_1.video.pid = vpid_bk;
      Config_1.video.codec = _xTS_Transfer_Video_Codec(m_programInfo.psi_program[pmt_index].video_pids[video_index_inpmt].codec);
      Config_1.audio.pid = apid_bk;
      Config_1.audio.codec = _xTS_Transfer_Audio_Codec(m_programInfo.psi_program[pmt_index].audio_pids[audio_index_inpmt].codec);
      Config_1.pcr_pid = m_programInfo.psi_program[pmt_index].pcr_pid;
      Config_1.audio.focused = RTK_TRUE;
	  
      if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == UNENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_FALSE;
	     Config_1.audio.encrypted = RTK_FALSE;
	     input_info.cEncrypted = RTK_FALSE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == AV_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_TRUE;
	     Config_1.audio.encrypted = RTK_TRUE;
	     input_info.cEncrypted = RTK_TRUE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == VIDEO_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_TRUE;
	     Config_1.audio.encrypted = RTK_FALSE;
	     input_info.cEncrypted = RTK_TRUE;
      	}
	else if(isScramble(pmt_index,video_index_inpmt,audio_index_inpmt) == AUDIO_ENCRYPT)
      	{ 
      	   
            Config_1.video.encrypted = RTK_FALSE;
	     Config_1.audio.encrypted = RTK_TRUE;
	     input_info.cEncrypted = RTK_TRUE;
      	}	  
     
      if(m_programInfo.psi_program[pmt_index].subtitle_pids[0].pid !=0)
      	{
      	 Config_1.subtitle.pid = m_programInfo.psi_program[pmt_index].subtitle_pids[0].pid;
	 Config_1.subtitle.bshow = true;
	 Config_1.subtitle.langcode = m_programInfo.psi_program[pmt_index].subtitle_pids[0].langcode;
      	
	  if(RTK_Player_SetSubtitle(gPlayer_1,Config_1.subtitle) != RTK_OK)
	   {
		printf("Failed to change subtitle.\n");
		return;
	    }

      	}
	 //chage video pid and codec
	 if(RTK_Player_ChangeVideo(gPlayer_1, &Config_1.video) != RTK_OK)
	 {
	 	printf("failed to change video.\n");
		return;
	 }			 
		
	//change audio pid and codec
	if(RTK_Player_ChangeAudio(gPlayer_1, &Config_1.audio) != RTK_OK)
	{
	    printf("Failed to change audio.\n");
		return;
	}
	
	file_play_status = 1;
	waitpmt = 0;
	
	return;
		
}

void* ThreadWaitPMTEntry(void* instance)
{
	ThreadWaitPMT();
	UNUSED(instance);
	return NULL;
}

void  ThreadWaitPMT( )
{      
        struct timeval old_time,cur_time;
	int flag = 1;
	uint32_t rc, status;
	
	memset(&old_time,0,sizeof(struct timeval));
	memset(&cur_time,0,sizeof(struct timeval));
	gettimeofday(&old_time,0);	
	
	while(flag && (waitpmt == 1))
		{
		    gettimeofday(&cur_time,0);
		   if(cur_time.tv_sec -old_time.tv_sec+(cur_time.tv_usec -old_time.tv_usec)/1000000L >= 5)
		   	flag = 0;
		}
	if(waitpmt == 1){	
	printf("\n*********************Parsed %d pmt information*********************\n",m_recvProgramCnt);
	 if(m_recvProgramCnt != m_programInfo.program_cnt   && file_play_status == 0  )//not got all pmt tables.
		{
			bzero(&prog_list, sizeof(prog_list));
                    int  play_index = 0;
		      printf("Only Parsed some pmt information\n");	
			
               	     for(int i = 0; i < m_programInfo.program_cnt;i++)
                   	 	{
                   	 	  if(m_programInfo.psi_program[i].received == true)
                    		  	{
                    	  		  // printf("*********************program information*********************\n");
					  
					    if( m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids > 0 )
					     {
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				  	  	{
				 	   	  for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    		  	{

									
							 	 printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,vcnt,acnt));
							 	 printf("program number:0x%04x   PMT_PID:0x%04x    PCR_PID:0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
				 	      		  	 printf("VPID: 0x%04x  VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
						        	 printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
				    	         	   	prog_list[play_index].pmt_index = i;
						 	 	prog_list[play_index].video_in_pmt_index=vcnt;
						  	  	prog_list[play_index].audio_in_pmt_index=acnt;
						  	 	play_index ++;
								  
				    	  		}
				    	   	 }
				    	}
					else if (m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids==0)
					{
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				    		{
				    		       	printf("\n%d) program   isScramble:%s \n",play_index,StrScramble(i,vcnt,0));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("VPID: 0x%04x   VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
							printf("Audio none\n");
				 	       		prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=vcnt;
						 	prog_list[play_index].audio_in_pmt_index=0;
						  	 play_index ++;					  
				    	     }
					}
					else if (m_programInfo.psi_program[i].num_video_pids == 0 && m_programInfo.psi_program[i].num_audio_pids > 0)
					{
						for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    	  	{
					       
				 	       		printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,0,acnt));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("Video none\n");
							printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
							prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=0;
						  	prog_list[play_index].audio_in_pmt_index=acnt;
						   	play_index ++;								  
				    	  	}
					}
							   
                    	  	}
                      }
			 if(file_play_status == 0){
			 	 int select_index;
				while(1){
					 printf("\nPlease input play index(0~%d) to play\n",play_index-1);
					 fflush(stdin);
					 scanf("%d",&select_index);					 
					 if(select_index >= 0 &&  select_index <play_index){
						 printf("\nReceive the index you to play :%d\n",select_index);							 
						 break;}						
					 }				
				 xChangeAvParm(select_index);
			 	}
			
	         }

		}
	if(waitPMTThread){
	 rc = pthread_join(waitPMTThread, (void **)&status);
		if (rc != 0)
			{
			//	printf("ERROR; return code from waitPMTThread pthread_join() is %d\n", rc);
				return;
			}
			else
			{
				waitPMTThread = 0;
			//	printf("waitPMTThread Thread joined\n");
			}
		}		
	 return ;
		
}

void SectionCallback(const RTK_SectionFilter handle,RTK_HAL_SECTION_CB_STATUS enStatus, const unsigned char *section, const unsigned int length, void * userParam)
{
	TS_PSI_header PATHeader;
	TS_PSI_header CATHeader;
	TS_PSI_header PMTheader;
	TS_SI_header SDTHeader;
	TS_PSI_Program PMTprogramInfo;
	TS_CAT_program CATprogramInfo;
	TS_PAT_program PATprogram;

	const unsigned char* sectionData = section;
	const uint32_t  sectionLen = length;
	uint32_t rc, status;
	UNUSED(enStatus);
	UNUSED(SDTHeader);
	UNUSED(userParam);
	RTK_Source source = (RTK_Source)userParam;

	do
	{
		if (TS_PSI_PID_PAT == sectionData[0]) //PAT
		{
			//-------------------------------------------------------------------------
			//	Parse Header info from PAT table
			//-------------------------------------------------------------------------
			int32_t numOfProgram=0, i=0,j=0,rc=-1;
			bzero(&PATHeader, sizeof(PATHeader));
			bzero(&PATprogram, sizeof(PATprogram));
			TS_PSI_getSectionHeader(sectionData, &PATHeader);
			int program_cnt_old =0; 
			
			program_cnt_old = m_programInfo.program_cnt;
			

			if (m_programInfo.pat_program.version == PATHeader.version_number)
			{

				;
				//if(!m_isMonitorPAT)
				//	printf("Received same PAT. Skip this\n");
			}
			else//need to think about pat in many section at the same version_number ,now no think
			{
				printf("**** Received new PAT **** vsersion:  old=0x%x  new= 0x%x\n",   m_programInfo.pat_program.version,PATHeader.version_number);
				m_programInfo.pat_program.version = PATHeader.version_number;	
				numOfProgram = TS_PAT_getNumPrograms(sectionData);		
				printf(" *****Received  %d NIT/PMT****\n",numOfProgram);
				//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);
				if(numOfProgram > 0){
					
					for (i = 0; i < numOfProgram; i++)
					{
						rc = TS_PAT_getProgram((const unsigned char*)sectionData, sectionLen, i,  &PATprogram);
						
						if(PATprogram.program_number == TS_PSI_TID_NETWORK) //nit table
							{
							printf("Receive one NIT table\n");
							continue;
							}
						if (!rc && PATprogram.program_number) 
						{						   
						   if(m_programInfo.program_cnt > 0)//have parsed out some program,check if same
						   {
						         int exist_flag = 0;
						         for(j = 0; j < m_programInfo.program_cnt;j++)
						         {
						      		
						      	   	if(m_programInfo.psi_program[j].program_number == PATprogram.program_number)
						      	   		{
						      	   		 exist_flag = 1;
							  		 break; //quit from this for loop
						      	   		}														   
						         }
								 
							  if(exist_flag == 0) //not in the m_programInfo.psi_program[j],add it
							  	{									
							 		m_programInfo.psi_program[m_programInfo.program_cnt].program_number = PATprogram.program_number;
									m_programInfo.psi_program[m_programInfo.program_cnt].map_pid = PATprogram.PID;
									m_programInfo.program_cnt++;
									 
							  	}							  
						   }	
						   else
						   {
						   	  m_programInfo.psi_program[m_programInfo.program_cnt].program_number = PATprogram.program_number;
							  m_programInfo.psi_program[m_programInfo.program_cnt].map_pid = PATprogram.PID;
							  m_programInfo.program_cnt++;
							  
						   }
					    }//if (!rc && PATprogram.program_number) 
					}//for (i = 0; i < numOfProgram; i++)

					//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);


					printf("*********************PAT Information*********************\n");							
					for(int i = program_cnt_old; i< m_programInfo.program_cnt; i++)
					  {
					     printf("Parsed Program PID    : 0x%04X\n", m_programInfo.psi_program[i].map_pid);
					     printf("Parsed Program number : 0x%04X\n", m_programInfo.psi_program[i].program_number);
					  }
					printf("*********************************************************\n");


					//printf(" *****program_cnt_old : %d   m_programInfo.program_cnt:%d****\n",program_cnt_old,m_programInfo.program_cnt);

					if (source)
					{
						for (int i = program_cnt_old; i< m_programInfo.program_cnt; i++)
						{
							xAddSourcePMT(source, m_programInfo.psi_program[i].map_pid);
						}
						if (RTK_Source_RemoveSectionFilter(source, handle) != RTK_OK)
						{
							printf("Failed to remove PAT section filter.\n");
						}
					}
					else
					{
						for (int i = program_cnt_old; i< m_programInfo.program_cnt; i++)
						{
							xAddPMT(m_programInfo.psi_program[i].map_pid);
						}
						xRemovePAT();
					}
				}//if(numOfProgram > 0)
			}
		}
		else if (TS_PSI_TID_CAT == sectionData[0]) //CAT
		{
		  // printf("#### parse CAT ##");
			//-------------------------------------------------------------------------
			//	Parse Header info from CAT table
			//-------------------------------------------------------------------------
			bzero(&CATHeader, sizeof(CATHeader));
			bzero(&CATprogramInfo, sizeof(CATprogramInfo));
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &CATHeader);

			if (m_programInfo.cat_program.version != CATHeader.version_number)
			{
				printf("#### Received new CAT ####!!oldCATVersion=0x%x,newCATVersion=0x%x \n",m_programInfo.cat_program.version,CATHeader.version_number);
				m_programInfo.cat_program.version = CATHeader.version_number;				

				//-------------------------------------------------------------------------
				//	Parse EMM PID from CAT table
				//-------------------------------------------------------------------------
				CATprogramInfo.version = CATHeader.version_number;
				TS_PSI_parseCAT((const uint8_t *)sectionData, sectionLen, &CATprogramInfo);

				printf("*********************CAT Information*********************\n");
				printf("CAT version    : 0x%04x\n", CATprogramInfo.version );
				printf("CAT CasIDCount	: 0x%04x\n", CATprogramInfo.CasIDCount );

				for(int index = 0; index <CATprogramInfo.CasIDCount;index++ )
				{
					printf("CAT cas_id[%d]: 0x%04x, EMM PID:0x%04x\n",index, CATprogramInfo.cas_id[index],CATprogramInfo.ca_pid[index] ); 
				}				
				m_programInfo.cat_program = CATprogramInfo;	
			}
			
		}	
		
		else if ( TS_PSI_TID_PMT == sectionData[0]) /* PMT */{	
			
			//-------------------------------------------------------------------------
			bzero(&PMTheader, sizeof(PMTheader));
			bzero(&PMTprogramInfo, sizeof(PMTprogramInfo));					
					
			//	parse PMT Header			
			TS_PSI_getSectionHeader((const unsigned char*)sectionData, &PMTheader );	
			 int psi_index = 0;
			//	search index in m_programInfo.psi_program[32]	
			for(psi_index=0; psi_index<m_programInfo.program_cnt; psi_index++)
			{
				//find the pmt index according to program_number
			   if(m_programInfo.psi_program[psi_index].program_number == PMTheader.table_id_extension)					
			   {
			           //check received the same version pmt
				  if(m_programInfo.psi_program[psi_index].received == true && PMTheader.version_number == m_programInfo.psi_program[psi_index].version)
				     ;	//recv the same pmt,skip				
				 else
				 {
					//Store the main information about the program				
					PMTprogramInfo.program_number	= PMTheader.table_id_extension;
					PMTprogramInfo.version			= PMTheader.version_number;
					PMTprogramInfo.pcr_pid			= TS_PMT_getPcrPid((const uint8_t *)sectionData, sectionLen);
					PMTprogramInfo.descramble_info.descramble_algorithm = DESCRAMBLE_ALGO_UNKNOW;
					//Parse programe info from PMT table
					TS_PSI_parsePMT((const uint8_t *)sectionData, sectionLen, &PMTprogramInfo);				
				
					PMTprogramInfo.map_pid = m_programInfo.psi_program[psi_index].map_pid;//add by yunlong_ma,map_pid will be covered.
					m_programInfo.psi_program[psi_index] = PMTprogramInfo;					
					if(m_programInfo.psi_program[psi_index].received == false)	
					{
						m_recvProgramCnt++;
						;//printf("*********************Parse NEW PMT*********************\n");
					}
					else
					;//printf("********************* PMT program :0x%04x Changed******************\n",m_programInfo.psi_program[psi_index].program_number);

					m_programInfo.psi_program[psi_index].received = true;	
					
					/*
					printf("Program number           : 0x%04x\n", PMTprogramInfo.program_number);
					printf("Program version           : 0x%04x\n", PMTprogramInfo.version);
					printf("Program pcrPID            : 0x%04x\n", PMTprogramInfo.pcr_pid);
					printf("Program CasIDCount      :%d\n", PMTprogramInfo.CasIDCount);

					for(int i = 0;i <  PMTprogramInfo.CasIDCount;i++)
					{
						printf("Program CA_system_ID[%d]    : 0x%04x\n", i,PMTprogramInfo.cas_id[i]);     
						printf("Program ECM_PID[%d]         : 0x%04x\n", i,PMTprogramInfo.ca_pid[i]);
					}

					printf("Program scramble_algo   : 0x%04x\n", PMTprogramInfo.descramble_info.descramble_algorithm);
					printf("Program IV_value_avai   : 0x%04x\n", PMTprogramInfo.descramble_info.IV_value_available);
					printf("Program numOfVideoPID   : 0x%04x\n", PMTprogramInfo.num_video_pids);
					printf("Program numOfAudioPID   : 0x%04x\n", PMTprogramInfo.num_audio_pids);
					printf("Program numOfOtherPID   : 0x%04x\n", PMTprogramInfo.num_other_pids);
                      		printf("Program numOfSubtitlePID   : 0x%04x\n", PMTprogramInfo.num_subtitle_pids);
					printf("=============== Video ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_video_pids; i++)
					{
						printf("Program %d'th VideoES_PID: 0x%04x\n", i, PMTprogramInfo.video_pids[i].pid);
						printf("Program %d'th Video_Codec: 0x%04x\n", i, PMTprogramInfo.video_pids[i].codec);
											
						for (int j = 0; j < PMTprogramInfo.video_pids[i].CasIDCount; j++)
						{
							printf("video Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.video_pids[i].cas_id[j]);
							printf("video Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.video_pids[i].ca_pid[j]);                        
						}
					}

					printf("=============== Audio ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_audio_pids; i++)
					{
						printf("Program %d'th AudioES_PID: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].pid);
						printf("Program %d'th Audio_Codec: 0x%04x\n", i, PMTprogramInfo.audio_pids[i].codec);

						
						for (int j = 0; j < PMTprogramInfo.audio_pids[i].CasIDCount; j++)
						{
							printf("audio Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.audio_pids[i].cas_id[j]);
							printf("audio Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.audio_pids[i].ca_pid[j]);                        
						}

					}
					printf("=============== Others ===============\n");

					for (int i = 0; i < PMTprogramInfo.num_other_pids; i++)
					{
						printf("Program %d'th OtherES_PID : 0x%04x\n", i, PMTprogramInfo.other_pids[i].pid);
						printf("Program %d'th Other_stream: 0x%04x\n", i, PMTprogramInfo.other_pids[i].stream_type);
						
						for (int j = 0; j < PMTprogramInfo.other_pids[i].CasIDCount; j++)
						{
							printf("audio Program %d'th cas_id: 0x%04x\n", j, PMTprogramInfo.other_pids[i].cas_id[j]);
							printf("audio Program %d'th ecm pid: 0x%04x\n", j, PMTprogramInfo.other_pids[i].ca_pid[j]);                        
						}
					}

                  		  	printf("=============== Subtilte===============\n");

					for (int i = 0; i < PMTprogramInfo.num_subtitle_pids; i++)
					{
						printf("Program %d'th num_subtitle_pids : 0x%04x\n", i, PMTprogramInfo.subtitle_pids[i].pid);
					
					}
					printf("***********************************************************\n");
					*/
				
			if(source)
			{
				printf("remove PMT handle=%p\n", handle);
				if (RTK_Source_RemoveSectionFilter(source, handle) != RTK_OK)
				{
					printf("Failed to remove PMT section filter.\n");
				}
			}
			else
			{
				xRemovePMT(handle);
			}
	           // printf("Received pmt : %d   parse pmt form pat:%d\n",m_recvProgramCnt,m_programInfo.program_cnt);
			if(m_recvProgramCnt == 1 && waitpmt == 1){
				int rc;
				rc =pthread_create(&waitPMTThread, NULL,ThreadWaitPMTEntry,NULL);
				if(rc !=0)
					printf("can't create thread: %s\n", strerror(rc));
				}	
				
		     if(m_recvProgramCnt == m_programInfo.program_cnt && waitpmt == 1 )
		     	{
		     	       waitpmt = 0;
				 if(waitPMTThread){
					rc = pthread_join(waitPMTThread, (void **)&status);
					if (rc != 0)					
						;//printf("ERROR; return code from waitPMTThread pthread_join() is %d\n", rc);			
					else
					  {
						waitPMTThread = 0;
						//printf("waitPMTThread Thread joined\n");
					   }
				 	}
					   
		     		printf("Have Parsed all pmt information\n");					
				bzero(&prog_list, sizeof(prog_list));
				int  play_index = 0;
			
               	     for(int i = 0; i < m_programInfo.program_cnt;i++)
                   	 	{
                   	 	  if(m_programInfo.psi_program[i].received == true)
                    		  	{
                    	  		  // printf("*********************program information*********************\n");
					  
					    if( m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids > 0 )
					     {
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				  	  	{
				 	   	  for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    		  	{
					                	 printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,vcnt,acnt));
							 	 printf("program number:0x%04x   PMT_PID:0x%04x    PCR_PID:0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
				 	      		  	 printf("VPID: 0x%04x  VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
						        	 printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
				    	         	   	prog_list[play_index].pmt_index = i;
						 	 	prog_list[play_index].video_in_pmt_index=vcnt;
						  	  	prog_list[play_index].audio_in_pmt_index=acnt;
						  	 	play_index ++;
								  
				    	  		}
				    	   	 }
				    	}
					else if (m_programInfo.psi_program[i].num_video_pids>0 && m_programInfo.psi_program[i].num_audio_pids==0)
					{
						for (int vcnt= 0; vcnt < m_programInfo.psi_program[i].num_video_pids; vcnt++)
				    		{
				    			printf("\n%d) program   isScramble:%s \n",play_index,StrScramble(i,vcnt,0));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("VPID: 0x%04x   VCodec: 0x%04x\n",m_programInfo.psi_program[i].video_pids[vcnt].pid ,m_programInfo.psi_program[i].video_pids[vcnt].codec);
							printf("Audio none\n");
				 	       		prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=vcnt;
						 	prog_list[play_index].audio_in_pmt_index=0;
						  	 play_index ++;					  
				    	     }
					}
					else if (m_programInfo.psi_program[i].num_video_pids == 0 && m_programInfo.psi_program[i].num_audio_pids > 0)
					{
						for(int acnt = 0;acnt < m_programInfo.psi_program[i].num_audio_pids;acnt++)
				    	  	{
					       
				 	       		printf("\n%d) program   isScramble:%s\n",play_index,StrScramble(i,0,acnt));
							printf("program number: 0x%04x   PMT_PID: 0x%04x    PCR_PID: 0x%04x\n",m_programInfo.psi_program[i].program_number,m_programInfo.psi_program[i].map_pid,m_programInfo.psi_program[i].pcr_pid);
							printf("Video none\n");
							printf("APID: 0x%04x  ACodec: 0x%04x\n",m_programInfo.psi_program[i].audio_pids[acnt].pid ,m_programInfo.psi_program[i].audio_pids[acnt].codec);
							prog_list[play_index].pmt_index = i;
						 	prog_list[play_index].video_in_pmt_index=0;
						  	prog_list[play_index].audio_in_pmt_index=acnt;
						   	play_index ++;								  
				    	  	}
					}
							   
                    	  	}
                      }
			 if(file_play_status == 0){
			 	 int select_index;
				while(1){
					 printf("\nPlease input play index(0~%d) to play\n",play_index-1);
					 fflush(stdin);
					 scanf("%d",&select_index);					 
					 if(select_index >= 0 &&  select_index <play_index){
						 printf("\nReceive the index you to play :%d\n",select_index);							 
						 break;}						
					 }				
				 xChangeAvParm(select_index);
			 	}
		     }

	         }

			break;	
		}
			   			
								
		}
			 	
	      }		
		
			
		
		else
		{
			printf("Can not parse table id! TID = %d\n", sectionData[0]);
		}
	}while(0);

	return ;
}
void xAddPAT(void)
{
	if(patHandle == NULL){
	bzero(patPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(patPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(patPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
	patPattern.comp[0] = TS_PSI_TID_PAT;
	patPattern.mask[0] = 0xFF;
	patPattern.pid = TS_PSI_PID_PAT;
	patPattern.section_user_param = NULL;
	patPattern.callback_01 = SectionCallback;
	patPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	if (RTK_Player_AddSectionFilter(gPlayer_1, &patHandle, &patPattern) != RTK_OK)
	   {
		printf("Failed to add PAT section filter.\n");
		return;
	   }
      }
	return;
}
void xRemovePAT(void)
{
	if(patHandle)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, patHandle) != RTK_OK)
		{
			printf("Failed to remove PAT section filter.\n");
		}
		//printf("xRemovePAT\n");
		patHandle = NULL;
	}
	return;
}

void xAddCAT(void)
{
	if(catHandle == NULL)
	{
		bzero(catPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(catPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		catPattern.comp[0] = TS_PSI_TID_CAT;
		catPattern.mask[0] = 0xFF;
		catPattern.pid = TS_PSI_TID_CAT;
		catPattern.section_user_param = NULL;
		catPattern.callback_01 = SectionCallback;
		catPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(gPlayer_1, &catHandle, &catPattern) != RTK_OK)
		{
			printf("Failed to add CAT section filter.\n");
			return;
		}
	//	printf("xAddCAT\n");
		
	}
	return;
}

void xRemoveCAT(void)
{
	if(catHandle)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, catHandle) != RTK_OK)
		{
			printf("Failed to remove CAT section filter.\n");
		}
		//printf("xRemoveCAT\n");
		catHandle = NULL;
	}
	return;
}

char xAddPMT(uint16_t pid)
{
	RTK_SectionFilter pmtHandle;
	RTK_SectionFilterMask pmtPattern;
	int index = -1;

	// check if add before
	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtFilterPID[i]== 0) // find out free space
		{
			if(index== -1) index = i;
			continue;
		}
		else if(m_pmtFilterPID[i] == pid) // already exist
		{
			index = i;
			break;
		}
	}

	if( index != -1 && m_pmtHandle[index] == NULL)
	{
		bzero(pmtPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
		bzero(pmtPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
		pmtPattern.comp[0] = TS_PSI_TID_PMT;
		pmtPattern.mask[0] = 0xFF;
		pmtPattern.pid = pid;
		pmtPattern.section_user_param = NULL;
		pmtPattern.callback_01 = SectionCallback;
		pmtPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
		if (RTK_Player_AddSectionFilter(gPlayer_1, &pmtHandle, &pmtPattern) != RTK_OK)
		{
			printf("Failed to add PMT section filter.\n");
			return RTK_ERR;
		}
		//printf("xAddPMT PID 0x%x to index %d %p\n", pid, index, pmtHandle);
		m_pmtHandle[index] = pmtHandle;
		m_pmtFilterPID[index] = pid;
	}
	return RTK_OK;
}

void xRemovePMT(RTK_SectionFilter handle)
{
	int index = -1;

	for(int i=0;i<PROGRAME_CNT;i++)
	{
		if(m_pmtHandle[i] == handle) // find out
		{
			index = i;
			break;
		}
	}
	if(index != -1)
	{
		if (RTK_Player_RemoveSectionFilter(gPlayer_1, m_pmtHandle[index]) != RTK_OK)
		{
			printf("Failed to remove PAT section filter.\n");
			return;
		}
		//printf("xRemovePMT PID 0x%x from index %d %p\n", m_pmtFilterPID[index], index, m_pmtHandle[index]);
		m_pmtHandle[index] = NULL;
		m_pmtFilterPID[index] = 0;
	}
	return;
}

char xAddSourcePMT(RTK_Source source, uint16_t pid)
{
	RTK_SectionFilter handle;
	RTK_SectionFilterMask pattern;
	bzero(pattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(pattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(pattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
	pattern.comp[0] = TS_PSI_TID_PMT;
	pattern.mask[0] = 0xFF;
	pattern.pid = pid;
	pattern.section_user_param = source;
	pattern.callback_01 = SectionCallback;
	pattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	if (RTK_Source_AddSectionFilter(source, &handle, &pattern) != RTK_OK)
	{
		printf("Failed to add PMT section filter.\n");
		return RTK_ERR;
	}
	printf("Add PMT section filter handle=%p\n", handle);
	return RTK_OK;
}

RTK_Bool xIsPlayOnce(void)
{
	RTK_Bool is_play_once = RTK_TRUE;
	printf("\n Do you want to repeat play?(y/N):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			is_play_once = RTK_FALSE;
			break;
		}
		else if(ch == 'N'||ch =='n')
		{
			is_play_once = RTK_TRUE;
			break;
		}
	}
	fflush(stdin);
	return is_play_once;
}

int _get_number_with_range(long int* pval, long int min, long int max);
void inputHdmiDelays(long * HDMI_VSDB_delay_ms,long * HDMI_AUDIO_delay_ms) {

    int ret = RTK_Fail;
    long min = -3000;
    long max = 3000;
    do
    {
        printf("\nhdmi vsdb delay ms (decimal base range[%ld,%ld]) >> ",min,max);
        if (_get_number_with_range(HDMI_VSDB_delay_ms, min ,max)<0)    
            ret = RTK_Fail;
        else
            ret =RTK_OK;
    }while(ret == RTK_Fail);
    
    do
    {
        printf("\nhdmi audio delay ms (decimal base range[%ld,%ld]) >> ",min,max);        
        if (_get_number_with_range(HDMI_AUDIO_delay_ms, min ,max)<0)    
            ret = RTK_Fail;
        else
            ret =RTK_OK;
    }while(ret == RTK_Fail);    

}

#define TIMESHIFT_SIZE 1024*1024*50
static RTK_BOOL gTimeshiftPause = RTK_FALSE;
static RTK_BOOL gTimeshiftStop = RTK_FALSE;
static RTK_BOOL gPlayerResumeJustNow = RTK_FALSE;
static void* playTimeshiftThread(void* param)
{
	printf("\n playTimeshift hello\n\n");
	RTK_PlayerConfig* config = (RTK_PlayerConfig*)param;
	RTK_TSInputBuffer buffer;
	FILE * file=NULL;
	
	memset(&buffer, 0, sizeof(buffer));
	//create surface
	if(config->video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 100, 100, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}
	while(gFirstReceiveTSData == RTK_FALSE)
		usleep(1000);

	//input file name and pids and codec.
	file = pvr_ts_fp_player;
	if(file == NULL)
	{
		printf("file pointer is NULL\n");
		return NULL;
	}

	config->callback.function = player_callback_1;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_2, config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return NULL;
	}

	if (gPlayer_2 == NULL)
	{
		printf("Player is NULL!!");
		return NULL;
	}

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = RTK_CAS_TYPE_PRIVATE_REC;
	sourceParam.cas_param.tsid_sidx = 599;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_2,source);

	//Player start.
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return NULL;
	}

	while(1)
	{
		if(gTimeshiftStop)
			break;
		if(gPlayerResumeJustNow)
		{

			if(RTK_Player_Pause(gPlayer_2) != RTK_OK)
			{
				printf("Failed to pause av.\n");
			}
			if(RTK_Player_DropData(gPlayer_2) != RTK_OK)
			{
				printf("Failed to Dropdata \n");
			}

			if(RTK_Player_Resume(gPlayer_2) != RTK_OK)
			{
				printf("Failed to resume av.\n");
			}	

                      DATA_CB_LOCK();
			gPlayerFilePoint = gDemuxDataSize;
			DATA_CB_UNLOCK();
			gPlayerResumeJustNow = RTK_FALSE;
			gTimeshiftPause = RTK_FALSE;
		}
		if(gTimeshiftPause)
		{
			usleep(500);
			continue;
		}
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		uint32_t remainFileSize;
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		do
		{
			DATA_CB_LOCK();
			remainFileSize = gDemuxDataSize - gPlayerFilePoint;
			DATA_CB_UNLOCK();
			usleep(100);
		}while(buffer.size > remainFileSize);
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = (uint32_t)-1;// don't care file size;
				input_info.video_codec_type = config->video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				DATA_CB_LOCK();
				_xSetFileBusyFlag(fileno(input_info.fp), gPlayerFilePoint);
				fseek(input_info.fp, gPlayerFilePoint, SEEK_SET);
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				gPlayerFilePoint = ftell(input_info.fp);
				_xClearFileBusyFlag(fileno(input_info.fp));

				DATA_CB_UNLOCK();
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6*1000);
					continue;
				}
				err = RTK_Source_FeedInputBuffer(source, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed InputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}

		usleep(2*1000);
	
	}

#if 0
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_2.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
	player_status_2.eof_reached = RTK_FALSE;
#endif
ON_ERROR:
	config->audio.pid = 0;
	config->audio.focused = RTK_FALSE;
	RTK_Player_ChangeAudio(gPlayer_2, &config->audio);
	
	if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return NULL;
	}

	RTK_Player_SetSource(gPlayer_2, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return NULL;
	}
	gPlayer_2 = NULL;
	RTK_DestorySurface(config->video.output);
	
	printf("Test finish.\n");

	return NULL;

}

void xPlaySample(char *user_name, RTK_SourceParam_t sourceParam, RTK_PlayerConfig playerConfig, INPUT_SOURCE_t souce_info)
{
	RTK_Error ret = RTK_Fail;
	RTK_TSInputBuffer buffer;
	RTK_Source source = NULL;
	RTK_Player player = NULL;
//	uint32_t totleFileSize=0;
	uint32_t play_count = 0;

	if(user_name == NULL)
	{
		printf("%s user_name is NULL\n",__FUNCTION__);
		return ;
	}
	printf("%s::%s enter\n", __FUNCTION__, user_name);

	// create source
	ret = RTK_Source_Create(&source,sourceParam);
	if(ret != RTK_OK || source == NULL)
	{
		printf("%s::%s Failed to create source.\n", __FUNCTION__, user_name);
		return ;
	}

	// create player
	ret = RTK_Player_Create(&player, &playerConfig, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || player == NULL)
	{
		printf("%s::%s Failed to create player.\n", __FUNCTION__, user_name);
		return;
	}
	RTK_Player_SetSource(player, source);

	// player start
	if(RTK_Player_Start(player) != RTK_OK)
	{
		printf("%s::%s Failed to start player.\n", __FUNCTION__, user_name);
		return;
	}

	while(gStopPlayTest == false)
	{
		if(souce_info.fp == NULL) // tuner mode
		{
			sleep(1);
			play_count++;
			printf("%s::%s play %d sec\n", __FUNCTION__, user_name, play_count);
			continue;
		}
		else // file mode
		{
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
			switch(err)
			{
				case RTK_OK:
					x_read_input_data(FILE_INPUT, souce_info, &buffer);
					if (buffer.filled_size < 0)
					{
						RTK_Source_DiscardInputBuffer(source, &buffer);
						continue;
					}
					err = RTK_Source_FeedInputBuffer(source, &buffer);
					if(err != RTK_OK)
					{
						printf("%s::%s feed nputBuffer failed\n", __FUNCTION__, user_name);
						RTK_Source_DiscardInputBuffer(source, &buffer);
					}
					if(buffer.isLast == 1)
					{
						goto __PLAY_SAMPLE_EOS;
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
					//printf("%s::%s RTK_BUFFER_NOT_AVAILABLE!!\n", __FUNCTION__, user_name);
					usleep(20*0000);	//	more 20ms.
					break;
				default:
					//printf("%s::%s ERROR!!\n", __FUNCTION__, user_name);
					break;
			}

			usleep(20*0000);	//	20ms.
		}
	}

__PLAY_SAMPLE_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached ||player_status_2.eof_reached )
		{
			printf("eof_reached\n");
			break;
		}
	}

	if(RTK_Player_Stop(player,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player1.\n");
		return;
	}
	// disconnect
	RTK_Player_SetSource(player, NULL);

	if(RTK_Player_Destroy(player) != RTK_OK)
	{
		printf("Failed to destroy player1.\n");
		return;
	}

	// destory source
	RTK_Source_Destroy(source);
	printf("%s::%s exit\n",__FUNCTION__, user_name);

}


RTK_SourceParam_t xTransferTunerToSourceParam(RTK_TunerParam_t tunerParam)
{
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));

	switch(tunerParam.type)
	{
		case RTK_TUNER_TYPE_DVBC:
			sourceParam.type = RTK_SOURCE_TYPE_DVBC;
			break;
		case RTK_TUNER_TYPE_ABS:
			sourceParam.type = RTK_SOURCE_TYPE_ABS;
			break;
		case RTK_TUNER_TYPE_DTMB:
			sourceParam.type = RTK_SOURCE_TYPE_DTMB;
			break;
		case RTK_TUNER_TYPE_DVB_T:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_T;
			break;
		case RTK_TUNER_TYPE_DVB_S:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_S;
			break;
		case RTK_TUNER_TYPE_DVB_S2:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_S2;
			break;
		case RTK_TUNER_TYPE_DVB_T2:
			sourceParam.type = RTK_SOURCE_TYPE_DVB_T2;
			break;
		default:
			sourceParam.type = RTK_SOURCE_TYPE_DVBC;
			break;
	}
	sourceParam.bandwidth = tunerParam.bandwidth;
	memcpy( &sourceParam.tnr_param , &tunerParam.tnr_param, sizeof(tunerParam.tnr_param) );
	return sourceParam;
}

void CAS_switch()
{
	if (gCASType == RTK_CAS_TYPE_NONE)
	{
		printf("[%s][%d]: CAS_switch to RTK_CAS_TYPE_NAGRA_TKL\n", __FILE__, __LINE__);
		gCASType = RTK_CAS_TYPE_NAGRA_TKL;
		RTK_DvbSetSMP(0,RTK_TRUE);
		RTK_DvbSetSMP(1,RTK_TRUE);
	}
	else
	{
		printf("[%s][%d]: CAS_switch to RTK_CAS_TYPE_NONE\n", __FILE__, __LINE__);
		gCASType = RTK_CAS_TYPE_NONE;
		RTK_DvbSetSMP(0,RTK_FALSE);
		RTK_DvbSetSMP(1,RTK_FALSE);
	}
}

int rtkmid_input_Source_Param(RTK_SourceParam_t *source)
{
	int ret = RTK_Fail;
	RTK_Bool is_choose_source = RTK_FALSE;
	printf("\n Do you want to choose Tuner?(y/N):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			is_choose_source = RTK_TRUE;
			break;
		}
		else if(ch == 'N'||ch =='n')
		{
			is_choose_source = RTK_FALSE;
			break;
		}
	}
	fflush(stdin);

	if (RTK_TRUE == is_choose_source)
	{
		source->type = RTK_SOURCE_TYPE_TP;
		long int id = 0;
		do
		{
			printf("\n Enter Tuner id:>>\n");
			id = 0;
			if (_get_number_with_range(&id, 0x0 ,0xFF)<0)
				ret = RTK_Fail;
			else
				ret =RTK_OK;
		}while(ret == RTK_Fail);
		source->TunerID = (unsigned char)id;
	}

	return RTK_OK;
}

static int xReadFixedSizeDataByIndex(FILE* pFile, uint32_t uiFixedDataSize, uint64_t ulIndex, uint8_t* pucBuf)
{
	if (pFile == NULL || uiFixedDataSize == 0 || pucBuf == NULL)
	{
		printf("[%s %d] Parameter error!! pFile=%p uiFixedDataSize=%u ulIndex=%llu pcBuf=%p\n", 
				__FUNCTION__, __LINE__, pFile, uiFixedDataSize, ulIndex, pucBuf);
		return -1;
	}

	rewind(pFile);
	
	if (0 != fseek(pFile, uiFixedDataSize * ulIndex, SEEK_SET))
	{
		printf("[%s %d] fseek error.\n", __FUNCTION__, __LINE__);
	}
	if (fread(pucBuf, 1, uiFixedDataSize, pFile) == uiFixedDataSize)
	{
		return 0;
	}	
	printf("[%s %d] ulIndex=%llu out of range,or some other error!!\n", __FUNCTION__, __LINE__, ulIndex);
	return -3;	
}

static int xFindTargetPTSInfo(FILE* pPTSFile, uint64_t ulTargetPTS, uint64_t* pulIndex, RTK_TS_Ctrl* ptPTSInfo)
{
	if (pPTSFile == NULL || ptPTSInfo == NULL || pulIndex == NULL)
	{
		printf("[%s %d] Parameter error!! pFile=%p ulTargetPTS=%llu ulIndex=%p ptPTSInfo=%p\n", 
				__FUNCTION__, __LINE__, pPTSFile, ulTargetPTS, pulIndex, ptPTSInfo);
		return -1;
	}

	uint64_t ulFileSize = 0;
	uint64_t ulPTSNum = 0;
	uint64_t ulPTSFirst = 0, ulPTSFirstIndex = 0;
	
	uint64_t ulPTSLast = 0, ulPTSLastIndex = 0;
	uint64_t ulPTSTemp = 0, ulPTSTempIndex = 0;
	RTK_TS_Ctrl tPTSInfoTemp;
	
	fseek(pPTSFile, 0, SEEK_END);
	ulFileSize = ftell(pPTSFile);
	rewind(pPTSFile);
	
	ulPTSNum = ulFileSize / sizeof(RTK_TS_Ctrl);

	if (ulPTSNum <= 3)
	{
		printf("[%s %d] File too small!!\n", __FUNCTION__, __LINE__);
		return -1;
	}
	
	ulPTSFirstIndex = 0;
	ulPTSLastIndex = ulPTSNum - 1;
	ulPTSTempIndex = ulPTSLastIndex / 2;

	while (ulPTSFirstIndex != ulPTSTempIndex)
	{
		fseek(pPTSFile, ulPTSFirstIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read first PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSFirstIndex);
			return -1;
		}
		ulPTSFirst = tPTSInfoTemp.pts;		
		//printf("[%s %d] ulPTSFirst=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSFirst, ulPTSFirstIndex);
		if ((abs((int64_t)ulPTSFirst - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSFirstIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}

		fseek(pPTSFile, ulPTSTempIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read middle PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSTempIndex);
			return -1;
		}
		ulPTSTemp = tPTSInfoTemp.pts;
		//printf("[%s %d] ulPTSTemp=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSTemp, ulPTSTempIndex);

		if ((abs((int64_t)ulPTSTemp - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSTempIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}
		
		fseek(pPTSFile, ulPTSLastIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(&tPTSInfoTemp, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read last PTS error!! index=%llu\n", __FUNCTION__, __LINE__, ulPTSLastIndex);
			return -1;
		}
		ulPTSLast = tPTSInfoTemp.pts;
		//printf("[%s %d] ulPTSLast=%llu index=%llu\n",__FUNCTION__,__LINE__, ulPTSLast, ulPTSLastIndex);

		if ((abs((int64_t)ulPTSLast - (int64_t)ulTargetPTS)) < 18000)
		{
			*pulIndex = ulPTSLastIndex;
			ptPTSInfo->pts = tPTSInfoTemp.pts;
			ptPTSInfo->offset = tPTSInfoTemp.offset;
			return 0;
		}

		if ((ulPTSFirst < ulTargetPTS && ulPTSTemp > ulTargetPTS) ||
			(ulPTSFirst < ulTargetPTS && ulPTSTemp < ulPTSFirst))
		{
			ulPTSFirstIndex += 1;
			ulPTSLastIndex = ulPTSTempIndex - 1;			
		}
		else if ((ulPTSFirst < ulTargetPTS && ulPTSTemp < ulTargetPTS && ulPTSLast < ulTargetPTS) ||
				 (ulPTSFirst > ulTargetPTS && ulPTSTemp > ulTargetPTS && ulPTSLast > ulTargetPTS))
		{
			printf("[%s %d] Couldn't find target PTS info!!\n",__FUNCTION__,__LINE__);
			return -1;
		}
		else
		{
			ulPTSFirstIndex = ulPTSTempIndex + 1;
			ulPTSLastIndex -= 1;
		}	
		ulPTSTempIndex = (ulPTSLastIndex - ulPTSFirstIndex) / 2 + ulPTSFirstIndex;
	}	

	if (ulPTSFirstIndex == ulPTSTempIndex)
	{
		*pulIndex = ulPTSTempIndex;
		fseek(pPTSFile, *pulIndex * sizeof(RTK_TS_Ctrl), SEEK_SET);
		if (fread(ptPTSInfo, 1, sizeof(RTK_TS_Ctrl), pPTSFile) != sizeof(RTK_TS_Ctrl))
		{		
			printf("[%s %d] Read target PTS error!! index=%llu\n", __FUNCTION__, __LINE__, *pulIndex);
			return -1;
		}
		return 0;
	}
	
	
	return -1;
}

static int xFindTargetFrameInfo(FILE* pfFrameFile, uint64_t ulTargetOffset, uint64_t* pulFrameOffset, RTK_FrameType eTargetType)
{
	if (pfFrameFile == NULL || pulFrameOffset == NULL)
	{
		printf("[%s %d] Parameter error!! pfFrameFile=%p ulTargetOffset=%llu pulFrameOffset=%p eTargetType=%u\n", 
				__FUNCTION__, __LINE__, pfFrameFile, ulTargetOffset, pulFrameOffset, eTargetType);
		return -1;
	}

	uint64_t ulFileSize = 0;
	uint64_t ulFrameNum = 0;
	uint64_t ulFirstIndex = 0;
	uint64_t ulFirstOffset = 0;
	uint64_t ulLastIndex = 0;
	uint64_t ulLastOffset = 0;
	uint64_t ulMiddleIndex = 0;
	uint64_t ulMiddleOffset = 0;
	uint64_t ulTargetIndex = 0;
	RTK_TS_Index tFrameInfoTemp;
	
	fseek(pfFrameFile, 0, SEEK_END);
	ulFileSize = ftell(pfFrameFile);
	rewind(pfFrameFile);
	
	ulFrameNum = ulFileSize / sizeof(RTK_TS_Index);

	if (ulFrameNum <= 3)
	{
		printf("[%s %d] File too small!!\n", __FUNCTION__, __LINE__);
		return -1;
	}
	
	ulLastIndex = 0;
	ulLastIndex = ulFrameNum - 1;
	ulMiddleIndex = ulLastIndex / 2;

	while (ulFirstIndex != ulMiddleIndex)
	{
		fseek(pfFrameFile, ulFirstIndex * sizeof(RTK_TS_Index), SEEK_SET);
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read first frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulFirstIndex);
			return -1;
		}
		ulFirstOffset = tFrameInfoTemp.offset;		
		//printf("[%s %d] ulFirstOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulFirstOffset, ulFirstIndex);
		if ((abs((int64_t)ulFirstOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulFirstIndex;
			break;
		}

		fseek(pfFrameFile, ulMiddleIndex * sizeof(RTK_TS_Index), SEEK_SET);
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read middle frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulMiddleIndex);
			return -1;
		}
		ulMiddleOffset = tFrameInfoTemp.offset;
		//printf("[%s %d] ulMiddleOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulMiddleOffset, ulMiddleIndex);
		if ((abs((int64_t)ulMiddleOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulMiddleIndex;
			break;
		}
		
		fseek(pfFrameFile, ulLastIndex * sizeof(RTK_TS_Index), SEEK_SET);
		if (fread(&tFrameInfoTemp, 1, sizeof(RTK_TS_Index), pfFrameFile) != sizeof(RTK_TS_Index))
		{		
			printf("[%s %d] Read last frame error!! index=%llu\n", __FUNCTION__, __LINE__, ulMiddleIndex);
			return -1;
		}
		ulLastOffset = tFrameInfoTemp.offset;
		//printf("[%s %d] ulLastOffset=%llu index=%llu\n",__FUNCTION__,__LINE__, ulLastOffset, ulLastIndex);
		if ((abs((int64_t)ulLastOffset - (int64_t)ulTargetOffset)) < 1024)
		{
			ulTargetIndex = ulLastIndex;
			break;
		}

		if ((ulFirstOffset < ulTargetOffset && ulMiddleOffset > ulTargetOffset) ||
			(ulFirstOffset < ulTargetOffset && ulMiddleOffset < ulFirstOffset))
		{
			ulFirstIndex += 1;
			ulLastIndex = ulMiddleIndex - 1;			
		}
		else if ((ulFirstOffset < ulTargetOffset && ulMiddleOffset < ulTargetOffset && ulLastOffset < ulTargetOffset) || 
				 (ulFirstOffset > ulTargetOffset && ulMiddleOffset > ulTargetOffset && ulLastOffset > ulTargetOffset))
		{
			return -1;
		}
		else
		{
			ulFirstIndex = ulMiddleIndex + 1;
			ulLastIndex -= 1;	
		}
		
		ulMiddleIndex = (ulLastIndex - ulFirstIndex) / 2 + ulFirstIndex;
	}	

	if (ulFirstIndex == ulMiddleIndex)
	{
		ulTargetIndex = ulMiddleIndex;
	}
	
	if (tFrameInfoTemp.frame_type == eTargetType)
	{
		*pulFrameOffset = tFrameInfoTemp.offset;
		return 0;
	}
	else
	{
		int64_t i;
		uint64_t j;
		uint64_t ulTemp = 0;
		for(i = ulTargetIndex - 1; i >= 0; i--)
		{
			xReadFixedSizeDataByIndex(pfFrameFile, sizeof(RTK_TS_Index), i, (uint8_t*)&tFrameInfoTemp);
			if (tFrameInfoTemp.frame_type == eTargetType)
			{
				ulTemp = tFrameInfoTemp.offset;
				break;
			}
		}

		for(j = ulTargetIndex + 1; j < ulFrameNum; j++)
		{
			xReadFixedSizeDataByIndex(pfFrameFile, sizeof(RTK_TS_Index), j, (uint8_t*)&tFrameInfoTemp);
			if (tFrameInfoTemp.frame_type == eTargetType)
			{
				if ((ulTargetIndex - i) > (j - ulTargetIndex))
				{
					*pulFrameOffset = tFrameInfoTemp.offset;
				}
				else
				{
					*pulFrameOffset = ulTemp;
				}
				return 0;
			}
		}
		return -1;
	}
	
	return 0;
}

static int xPVR_Replay_Seek(FILE* pfTSFile, FILE* pfPTSFile, FILE* pfFrameFile, uint64_t ulPTSCur, int32_t iSeekTimeMs, RTK_SEEK_WHENCE eSeekWhence)
{
	printf("[%s %d] begin>>>\n",__FUNCTION__,__LINE__ );
	printf("[%s %d] ulPTSCur=%llu SeekTimeMs=%d SeekWhence=%s\n",__FUNCTION__,__LINE__, ulPTSCur, iSeekTimeMs, RTK_GETSEEKWHENCE_STR(eSeekWhence));

	uint64_t ulTSPosTar = 0;
	uint64_t ulPtsNumToSeek = 0;
	uint64_t ulPtsTar = 0;
	uint64_t ulPtsTarIndex = 0;
	uint64_t ulPtsInfoFileSize = 0;
	RTK_TS_Ctrl tPtsInfo;	
	
	bool bSeekBack = iSeekTimeMs > 0 ? false : true;
	
	if (pfTSFile == NULL || pfPTSFile == NULL || pfFrameFile == NULL || abs(iSeekTimeMs) < 90)
	{
		printf("[%s %d] Parameter error!! pfTSFile=%p pfPTSFile=%p pfFrameFile=%p iSeekTimeMs=%d\n",
				__FUNCTION__, __LINE__, pfTSFile, pfPTSFile, pfFrameFile, iSeekTimeMs);
		return -1;
	}

	if ((bSeekBack == true && iSeekTimeMs < 0 && eSeekWhence == RTK_SEEKWHENCE_SET) || 
		(bSeekBack == false && iSeekTimeMs > 0 && eSeekWhence == RTK_SEEKWHENCE_END))
	{
		printf("[%s %d] Can't seek forward from end or seek backward from begin!!\n",__FUNCTION__,__LINE__);
		return -1;
	}

	fseek(pfPTSFile, 0, SEEK_END);
	ulPtsInfoFileSize = ftell(pfPTSFile);
	rewind(pfPTSFile);
	printf("[%s %d] PTS info file size=%llukB Number of PTS=%llu.\n", __FUNCTION__, __LINE__, (ulPtsInfoFileSize >> 10), (ulPtsInfoFileSize / sizeof(RTK_TS_Ctrl)));

	// compute the target number of pts that need seek
	ulPtsNumToSeek = abs(iSeekTimeMs) * 90;
	if (eSeekWhence == RTK_SEEKWHENCE_CUR)
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), 0, (uint8_t*)&tPtsInfo);
		if (iSeekTimeMs < 0 && ulPTSCur < ulPtsNumToSeek)
		{
			ulPtsTar = tPtsInfo.pts;
		}
		else
		{
			ulPtsTar = ulPTSCur + (iSeekTimeMs * 90);
		}
	}
	else if (eSeekWhence == RTK_SEEKWHENCE_SET)
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), 0, (uint8_t*)&tPtsInfo);
		ulPtsTar = tPtsInfo.pts + (iSeekTimeMs * 90);
	}
	else
	{
		xReadFixedSizeDataByIndex(pfPTSFile, sizeof(RTK_TS_Ctrl), ulPtsInfoFileSize / sizeof(RTK_TS_Ctrl) - 1, (uint8_t*)&tPtsInfo);
		ulPtsTar = tPtsInfo.pts + (iSeekTimeMs * 90);
	}
	printf("[%s %d] Number of PTS needs to seek:%llu PTSTar=%llu.\n", __FUNCTION__, __LINE__, ulPtsNumToSeek, ulPtsTar);

	if (xFindTargetPTSInfo(pfPTSFile, ulPtsTar, &ulPtsTarIndex, &tPtsInfo))
	{		
		printf("[%s %d] Couldn't find target PTS info!! ulPtsTar=%llu\n", __FUNCTION__, __LINE__, ulPtsTar);
		return -1;			
	}	
	printf("[%s %d] Find target PTS info successed!! RTS=%llu offset=%llu index=%llu \n", __FUNCTION__, __LINE__, tPtsInfo.pts, tPtsInfo.offset, ulPtsTarIndex);

	if (xFindTargetFrameInfo(pfFrameFile, tPtsInfo.offset, &ulTSPosTar, RTK_FRAME_TYPE_I))
	{	
		ulTSPosTar = tPtsInfo.offset;	
		printf("[%s %d] Couldn't find target I frame info!! use PTSoffset=%llu \n", __FUNCTION__, __LINE__, ulTSPosTar);		
	}
	else
	{
		printf("[%s %d] Find target I frame info successed!! offset=%llu \n", __FUNCTION__, __LINE__, ulTSPosTar);
	}	
	
	printf("[%s %d] Seek TS file to TSPosTar=%llu.\n", __FUNCTION__, __LINE__, ulTSPosTar);
	
	fseek(pfTSFile, ulTSPosTar, SEEK_SET);

	printf("[%s %d] end<<<\n",__FUNCTION__,__LINE__ );
	return 0;
}

//Rtk_AvParam_t * avParam1
void rtk_hal_test_Player_Tuner()
{
	printf("[%s][%d]: rtk_hal_test_Tuner_Player\n", __FILE__, __LINE__);

	unsigned char chipid;
	RTK_TunerParam_t  tunerParam;
	RTK_SourceParam_t sourceParam;
	RTK_VideoConfig videoConfig;
	RTK_AudioConfig AudioConfig;
	unsigned short PcrPid;
	// create source
	memset(&tunerParam, 0, sizeof(RTK_TunerParam_t));
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	rtkmid_input_Tuner_Param(&tunerParam);
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 0;//100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	sourceParam.TunerID = 0;
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	
	RTK_Tuner_Init();
	
	if(RTK_Tuner_GetDeviceChipid(0,&chipid)!= RTK_OK)
	{
		printf("Failed to GetDeviceChipid.\n");
	}
	printf("\n chipid chipid chipid ==== %d \n",chipid);
	
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam))
	{
		printf("RTK_Tuner_Scan failed!!");
		return ;
	}

	
	RTK_Source source = NULL;
	RTK_Source_Create(&source,sourceParam);
	if(source == NULL)
	{
	   printf("Source is NULL!!");
	   return ;
	}

	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	// create player
	rtkmid_input_AV_type_pid(&videoConfig,&AudioConfig, &PcrPid);
	AudioConfig.encrypted = RTK_FALSE;
	AudioConfig.enable_raw_output_mode = RTK_FALSE;
	AudioConfig.focused = RTK_TRUE;
	
	RTK_PlayerConfig config;
	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}

	// connect
	RTK_Player_SetSource(gPlayer_1, source);

	// player start
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	RTK_Player_ChangeVideo(gPlayer_1, &videoConfig);
	RTK_Player_ChangeAudio(gPlayer_1, &AudioConfig);

	// play WAIT_TIME_SECOND sec
	int i=0;
	for(i=WAIT_TIME_SECOND;  i> 0;	i--)
	{
		sleep(1);

		RTK_Tuner_IsLocked(sourceParam.TunerID);
		RTK_TunerInfo info;
		RTK_Tuner_GetInfo(sourceParam.TunerID, &info);
		printf("Tuner:%u lock:%s strength=%u quality=%u snr=%.1fdB ber=%f agc=%u powerlevel=%.1fdBuV packetError=%f mer=%f lber=%f \n", 
				sourceParam.TunerID, info.locked == RTK_TRUE ? "true" : "false", info.strength, info.quality, info.snr, info.ber, info.agc, (float)(info.powerLevel / 10.0), info.packetError, info.mer, info.lber);
		unsigned long long ullBitrate = 0;
		RTK_Player_GetTsInputBitrate(gPlayer_1, &ullBitrate);
		printf("Ts input bitrate:%llu\n", ullBitrate);

		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	// disconnect
	RTK_Player_SetSource(gPlayer_1, NULL);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);

	// destroy source
	RTK_Source_Destroy(source);

	printf("Test finish.\n");

	return ;
}

void rtk_hal_test_Player_TunerPIP()
{
	printf("[%s][%d]: rtk_hal_test_Player_TunerPIP\n", __FILE__, __LINE__);

	RTK_Error ret = RTK_Fail;

	RTK_TunerParam_t  tunerParam1;
	RTK_TunerParam_t  tunerParam2;
	RTK_SourceParam_t sourceParam1;
	RTK_SourceParam_t sourceParam2;
	RTK_Source source1 = NULL;
	RTK_Source source2 = NULL;

	RTK_PlayerConfig config;
	RTK_VideoConfig videoConfig1;
	RTK_AudioConfig AudioConfig1;
	unsigned short PcrPid1;
	RTK_VideoConfig videoConfig2;
	RTK_AudioConfig AudioConfig2;
	unsigned short PcrPid2;

	// input
	printf("\n============Input Main Channel============\n");
	memset(&tunerParam1, 0, sizeof(RTK_TunerParam_t));
	memset(&sourceParam1, 0, sizeof(RTK_SourceParam_t));
	rtkmid_input_Tuner_Param(&tunerParam1);
	rtkmid_input_AV_type_pid(&videoConfig1,&AudioConfig1, &PcrPid1);

	printf("\n============Input PIP Channel============\n");
	memset(&tunerParam2, 0, sizeof(RTK_TunerParam_t));
	memset(&sourceParam2, 0, sizeof(RTK_SourceParam_t));
	rtkmid_input_Tuner_Param(&tunerParam2);
	rtkmid_input_AV_type_pid(&videoConfig2,&AudioConfig2, &PcrPid2);

	// create source 1
	sourceParam1.TunerID = 0;
	sourceParam1.type = RTK_SOURCE_TYPE_TP;
	sourceParam1.cas_param.type = gCASType;
	sourceParam1.cas_param.tsid_sidx = 100;
	sourceParam1.isSMP = RTK_DvbGetSMP(0);
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(sourceParam1.TunerID, tunerParam1))
	{
		printf("RTK_Tuner_Scan tuner1 failed!!");
		return ;
	}
	ret = RTK_Source_Create(&source1,sourceParam1);
	if(ret != RTK_OK || source1 == NULL)
	{
		printf("Failed to create source1.\n");
		return ;
	}

	// create source 2
	sourceParam2.TunerID = 1;
	sourceParam2.type = RTK_SOURCE_TYPE_TP;
	sourceParam2.cas_param.type = gCASType;
	sourceParam2.cas_param.tsid_sidx = 200;
	sourceParam2.isSMP = RTK_DvbGetSMP(1);
	if(RTK_OK != RTK_Tuner_Scan(sourceParam2.TunerID, tunerParam2))
	{
		printf("RTK_Tuner_Scan tuner2 failed!!");
		return ;
	}
	ret = RTK_Source_Create(&source2,sourceParam2);
	if(ret != RTK_OK || source2 == NULL)
	{
		printf("Failed to create source2.\n");
		return;
	}

	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);

	// create player1
	videoConfig1.output = RTK_WIN_MAIN;
	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	config.video.output = RTK_WIN_MAIN;
	ret = RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || gPlayer_1 == NULL)
	{
		printf("Failed to create player1.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, source1);

	// create player2
	videoConfig2.output = RTK_WIN_PIP;
	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	config.video.output = RTK_WIN_PIP;
	ret = RTK_Player_Create(&gPlayer_2, &config, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || gPlayer_2 == NULL)
	{
		printf("Failed to create player2.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_2, source2);
	RTK_Player_SetAVSyncMode(gPlayer_2, RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	// player start
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player1.\n");
		return ;
	}
	AudioConfig1.focused = RTK_TRUE;
	RTK_Player_ChangeVideo(gPlayer_1, &videoConfig1);
	RTK_Player_ChangeAudio(gPlayer_1, &AudioConfig1);
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("Failed to start player2.\n");
		return ;
	}
	AudioConfig2.focused = RTK_FALSE;
	RTK_Player_ChangeVideo(gPlayer_2, &videoConfig2);
	RTK_Player_ChangeAudio(gPlayer_2, &AudioConfig2);

	// play WAIT_TIME_SECOND sec
	int i=0;
	for(i=WAIT_TIME_SECOND;  i> 0;	i--)
	{
		sleep(1);
		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player1.\n");
		return;
	}
	if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player2.\n");
		return;
	}

	// disconnect
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Player_SetSource(gPlayer_2, NULL);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player1.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
	{
		printf("Failed to destroy player2.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	RTK_DestorySurface(RTK_WIN_PIP);

	// destroy source
	RTK_Source_Destroy(source1);
	RTK_Source_Destroy(source2);

	printf("Test finish.\n");

	return ;
}

void rtk_hal_test_Player_TunerZapping()
{
	printf("[%s][%d]: rtk_hal_test_Player_TunerZapping\n", __FILE__, __LINE__);

	RTK_PlayerConfig config;
	RTK_VideoConfig video1;
	RTK_AudioConfig audio1;
	RTK_VideoConfig video2;
	RTK_AudioConfig audio2;
	RTK_VideoConfig video3;
	RTK_AudioConfig audio3;
	RTK_TunerParam_t tunerParam1;
	RTK_TunerParam_t tunerParam2;
	RTK_TunerParam_t tunerParam3;

	RTK_Error lock_ok=RTK_Fail;
	RTK_Bool isKeepLastFrame = RTK_TRUE;
	unsigned short pcr_pid=-1;

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	RTK_RfDemodParam_t RfDemodParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	memset(&RfDemodParam, 0, sizeof(RTK_RfDemodParam_t));

	//reset config, video, audio.
	memset(&config, 0, sizeof(config));
	memset(&video1, 0, sizeof(video1));
	memset(&audio1, 0, sizeof(audio1));
	memset(&video2, 0, sizeof(video2));
	memset(&audio2, 0, sizeof(audio2));
	memset(&video3, 0, sizeof(video3));
	memset(&audio3, 0, sizeof(audio3));
	memset(&tunerParam1, 0, sizeof(tunerParam1));
	memset(&tunerParam2, 0, sizeof(tunerParam2));
	memset(&tunerParam3, 0, sizeof(tunerParam3));

	//get tuner param and av pid from console.
	printf("\nPlease enter first channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam1);
	rtkmid_input_AV_type_pid(&video1,&audio1, &pcr_pid);

	printf("\nPlease enter second channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam2);
	rtkmid_input_AV_type_pid(&video2,&audio2, &pcr_pid);

	printf("\nPlease enter third channel======================\n");
	rtkmid_input_Tuner_Param(&tunerParam3);
	rtkmid_input_AV_type_pid(&video3,&audio3, &pcr_pid);

	config.input.type = RTK_INPUT_SOURCE;

	//use play_callback to receive some notify event from decoder.
	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;

	//add for hank...
	#ifndef ENABLE_GLINUX_RTK_PORTING
	char value[50] = "";
	const char product_property[] = "ro.build.product";
	if(__system_property_get(product_property, value) != 0 
        && strcmp(value, "RealtekHank") == 0)
	{
		isKeepLastFrame = RTK_FALSE;	
	}
	#endif
	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return ;
	}
   
	sourceParam.TunerID = 0;
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam1))
	{
		printf("RTK_Tuner_Scan failed!!");
		return ;
	}
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1, source);
	lock_ok = (RTK_Error)RTK_OK;

 	int ch;int cnt = 0;
	bool  isTestRecycle = 0;
	printf("\n Do you want to test tuner zapping at recycle mode?(Y/n):");
	fflush(stdin);        
  	usleep(10); 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestRecycle = 1;
			printf(" Test tuner zapping at recycle mode !\n");
		}
		else
		{
			isTestRecycle = 0;
			printf(" Test tuner zapping at oneshot mode !\n");
		}
	}

	int interval[19] = {2,3,4,5,6,7,8,9,10,12,14,16,18,20,22,24,26,28,30};
	printf("\n Please the zapping interval index (period= interval *3)  between programs :\n");
	for(int i = 0; i<19;i++)
	printf("\n%d, zapping interval: %d\n",i,interval[i]);

	int timeval; int tm;
	fflush(stdin);        
	usleep(10); 
	while(1)
	{
		if(1 != scanf("%d",&tm))
		{
			printf("[%s, %d] scanf error!\n", __FILE__, __LINE__);
		}
		if(tm <19 && tm>= 0 && tm!='\n')
		{
			timeval = interval[tm];
			printf(" zapping interval is %d second!\n", interval[tm]);
			break;
		}
		else
		{			
			printf(" input error!\n");
			continue;
		}
	 }

	
do{
	printf("\n the %dth whole zapping begin\n",cnt+1);
	RTK_Tuner_Scan(sourceParam.TunerID, tunerParam1);	
		//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &video1);
	audio1.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &audio1);
	RTK_Player_Start(gPlayer_1);


	printf("wait %d second  then change channel2\n",timeval);
	sleep(timeval);

	//First stop and keep last frame.
	if(RTK_Player_Stop(gPlayer_1,isKeepLastFrame) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam2))
	{
		printf("%s: RTK_Tuner_Scan failed!!",__func__);
		return;
	}
#if 0
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1, source);
#endif
	lock_ok = (RTK_Error)RTK_OK;

	RTK_Player_ChangeVideo(gPlayer_1, &video2);
	audio2.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &audio2);
	RTK_Player_Start(gPlayer_1);

	printf("wait %d second  then change channel3\n",timeval);
	sleep(timeval);

	//First stop and keep last frame.
	RTK_Player_Stop(gPlayer_1, isKeepLastFrame);

RTK_Tuner_Scan(sourceParam.TunerID, tunerParam3);
#if 0
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1, source);
#endif
	lock_ok = (RTK_Error)RTK_OK;


	RTK_Player_ChangeVideo(gPlayer_1, &video3);
	audio3.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &audio3);
	RTK_Player_Start(gPlayer_1);
	

	printf("wait %d second  then change channel1\n",timeval);	
	sleep(timeval);
	
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	cnt ++;
	printf("the %dth whole zapping end\n\n",cnt);
	
}while(isTestRecycle);


	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	printf("Test finish.\n");
	
	return ;
}


//Rtk_AvParam_t * avParam1
void rtk_hal_test_Player_TunerScan()
{
	printf("[%s][%d]: rtk_hal_test_Player_TunerScan\n", __FILE__, __LINE__);

	RTK_PlayerConfig config;
	RTK_Source source = NULL;
	RTK_TunerParam_t  tunerParam;
	RTK_SourceParam_t sourceParam;
	uint16_t pat_pid = 0x0;

	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}

	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	memset(&tunerParam, 0 , sizeof(RTK_TunerParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	sourceParam.TunerID=0;
//	long start;
	long end;
	printf("Please enter the starting value of the frequency scan");
	rtkmid_input_Tuner_Param(&tunerParam);
	printf("Please enter the termination value of the frequency scan\n");
	if (_get_number_with_range(&end, 0x0 ,0xffff)<0)	
		return;
	long freq=tunerParam.tnr_param.dvb_c_param.u32frequency;
	int lock;
	RTK_Tuner_Init();
	while(1)
	{
		if(freq > end)
			break;

		tunerParam.tnr_param.dvb_c_param.u32frequency = freq;
		if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam))
		{
			printf("RTK_Tuner_Scan failed!!");
			return ;
		}
		if( RTK_OK != RTK_Source_Create(&source,sourceParam))
		{
			printf("\n create source in freq == %ld failed\n",freq);
			freq=freq+8;
			continue;
		}
		RTK_Source_PresetPidFilter(source, &pat_pid, 1);

		for(int i=0;i<20;i++)
		{
			usleep(10*1000);
			lock = RTK_Tuner_IsLocked(sourceParam.TunerID);
			if(lock == RTK_OK)
				break;
		}

		if(lock == RTK_OK)
		{
			printf("\n tuner  locked  in freq == %ld \n",freq);
			RTK_Player_SetSource(gPlayer_1, source);

			flag_recieved_PAT = 0;
			memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern0.pid = pat_pid;//PAT
			SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern0.callback_01 = section_callback5;
			SectionFilterPattern0.u32byWaitTimeoutMs = 0;
			RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
			while(flag_recieved_PAT == 0)
			{
				usleep(10*1000);
			}
			printf("\n tuner freq == %ld  got PAT\n",freq);
			RTK_Player_RemoveAllSectionFilters(gPlayer_1);
			RTK_Player_SetSource(gPlayer_1, NULL);
			flag_recieved_PAT = 0;
		}
		else
		{
			printf("\n tuner  unlock  in freq == %ld \n",freq);
		}

		RTK_Source_Destroy(source);
		freq=freq+8;
	}

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}

	
	printf("Test finish.\n");


	return ;
}




void rtk_hal_test_Player_FileplayAuto()
{	
	printf("\n rtk_hal_test_Player_FileplayAuto hello\n\n");

	
	RTK_TSInputBuffer buffer;
	
	char file_path[256]={0};
	FILE * file=NULL;		
	file_play_status = 0;
	waitpmt = 1;
	m_recvProgramCnt = 0;

	memset(&Config_1, 0, sizeof(Config_1));	
	
	Config_1.callback.function	= player_callback_1;
	Config_1.callback.user_param	= &player_status_1;
	Config_1.input.type			= RTK_INPUT_SOURCE;

 	
	
	Config_1.video.codec			= CHANNEL1_VIDEO_CODEC;
	Config_1.video.pid			= CHANNEL1_VIDEO_PID;
	Config_1.video.encrypted		= RTK_FALSE;
	Config_1.video.output 		= RTK_WIN_MAIN;

	Config_1.audio.codec					= CHANNEL1_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	Config_1.audio.pid					= CHANNEL1_AUDIO_PID;
	Config_1.audio.focused				= RTK_TRUE;
	Config_1.audio.encrypted				= RTK_FALSE;
	Config_1.audio.enable_raw_output_mode = RTK_FALSE;

	//create surface
	if(video_config.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	printf("\nInput  stream TSfilePath:\n");
	if(1 != scanf("%s", file_path))
	{
		printf("failed to read input ts file path.\n\n");
	}
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	

	Config_1.video.pid = 0;
	Config_1.audio.pid = 0;

	//RTK_DvbSetSMP(0, RTK_TRUE);
	//RTK_DvbSetSMP(1, RTK_TRUE);
	
	if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	//RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}


	printf("set Volume maxinum 30\n");
	RTK_audio_SetVolume(30);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);


	memset(&m_pmtFilterPID,0,sizeof(m_pmtFilterPID));
	memset(m_pmtHandle,0,sizeof(m_pmtHandle));
	bzero(&m_programInfo, sizeof(TS_Program_Info));
	m_programInfo.pat_program.version = 0xff;
	m_programInfo.cat_program.version = 0xff;
       xAddPAT();
	xAddCAT();
       int paly_from_begin = 0;
	//	feed data until end of file.
	while(1)
	{			       
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		
		switch(err)
		{
			case RTK_OK:
				
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;	
				if(file_play_status == 1)					
				 {
					
					if(paly_from_begin == 0)
					{
						fseek(input_info.fp,0,SEEK_SET);
						paly_from_begin = 1;						
						RTK_Source_DiscardInputBuffer(source, &buffer);

					}
					
					input_info.filePlay_once = RTK_TRUE;					
				  }
				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
					if(input_info.filePlay_once == RTK_TRUE)					
				       goto ON_WAIT_EOS; 
					else
						continue;
				}
				if (buffer.filled_size <= 0)  
				{
					RTK_Source_DiscardInputBuffer(source, &buffer);

					usleep(6000);
				        continue;                                                
				}

				err = RTK_Source_FeedInputBuffer(source, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");

					RTK_Source_DiscardInputBuffer(source, &buffer);

					goto ON_ERROR;
				}

				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;						
		}



	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	xRemoveCAT();
	xRemovePAT();
	for(int i=0;i<m_programInfo.program_cnt;i++)
		xRemovePMT(m_pmtHandle[i]);	

	if(waitPMTThread){
		int rc,status;
	        rc = pthread_join(waitPMTThread, (void **)&status);
			if (rc != 0)
			{
				printf("ERROR; return code from rtkPlayFeedThread pthread_join() is %d\n", rc);
				return;
			}
			else
			{
			       waitPMTThread = 0;
				printf("rtkPlayFeedThread Thread joined\n");
			}
		}

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(video_config.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}

void rtk_hal_test_Player_Fileplay()
{	
	printf("\n 1rtk_hal_test_Player_Fileplay hello\n\n");	
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	RTK_VideoConfig video_config;
	RTK_AudioConfig audio_config;
	unsigned short pcr_pid=-1;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	long ptsTestCount = 0;
	RTK_Bool bvideomute;
	RTK_Bool is_play_once = RTK_TRUE;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));
	memset(&video_config, 0, sizeof(video_config));
	memset(&audio_config, 0, sizeof(audio_config));

	video_config.codec			= CHANNEL1_VIDEO_CODEC;
	video_config.pid			= CHANNEL1_VIDEO_PID;
	video_config.encrypted		= RTK_FALSE;
	video_config.output 		= RTK_WIN_MAIN;

	audio_config.codec					= CHANNEL1_AUDIO_CODEC; //	it can be RTK_CODEC_NONE at initialize time.
	audio_config.pid					= CHANNEL1_AUDIO_PID;
	audio_config.focused				= RTK_TRUE;
	audio_config.encrypted				= RTK_FALSE;
	audio_config.enable_raw_output_mode = RTK_FALSE;

	config.callback.function	= player_callback_1;
	config.callback.user_param	= &player_status_1;

	config.input.type			= RTK_INPUT_SOURCE;

	config.video 				= video_config;
	config.audio 				= audio_config;
	config.pcr_pid				= CHANNEL1_PCR_PID;

	//create surface
	if(video_config.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	bool isTestMute = RTK_FALSE;
	int ch = 0;	

	
	printf("\n Do you want to test Video/Audio mute/unmute?(Y/n):");
	
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMute = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestMute = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);

	is_play_once = xIsPlayOnce();

	if (strlen(FILE_NAME_1) != 0)
	{
		file = fopen(FILE_NAME_1, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&video_config,&audio_config, &pcr_pid);

	}


	RTK_SectionFilter patHandle;
	RTK_SectionFilterMask patPattern;
	UNUSED(patHandle);
	UNUSED(patPattern);
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	config.video.pid = 0;
	config.audio.pid = 0;

	//RTK_DvbSetSMP(0, RTK_TRUE);
	//RTK_DvbSetSMP(1, RTK_TRUE);
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}


	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	//RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
#if defined(ENABLE_CDCA)  || defined(ENABLE_ALTIPROJECT)
        static bool bCWSet =false;
	sourceParam.cas_param.tsid_sidx = 0xFFFFFFFF;
        sourceParam.cas_param.type = RTK_CAS_TYPE_3RDPARTY_CA;
#else
        sourceParam.cas_param.tsid_sidx = 100;
#endif
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);
       
       if(RTK_Player_Start(gPlayer_1) != RTK_OK)
       {
           printf("Failed to start player.?\n");
           return ;
       }
        
#if defined(ENABLE_CDCA)
            Rtk_CDCA::getInstance()->DescramblerInit(0);
            memset(&m_pmtFilterPID,0,sizeof(m_pmtFilterPID));
            memset(m_pmtHandle,0,sizeof(m_pmtHandle));
            bzero(&m_programInfo, sizeof(TS_Program_Info));
            m_programInfo.pat_program.version = 0xff;
            m_programInfo.cat_program.version = 0xff;
            #if 1 // keyladder need ecm callback
                xAddPAT();
                xAddCAT();
            #else //clear key 
                unsigned int V_tsid = 100;
                //unsigned int A_tsid = 200;
                unsigned char numPid=0xFF;//1;
                unsigned short pVPIDs[1] = {CHANNEL1_VIDEO_PID};
                unsigned short pAPIDs[1] = {CHANNEL1_AUDIO_PID};
                RTK_Source_SetTsidSidx(source,V_tsid);
                //RTK_Source_SetTsidSid_Ex(source,V_tsid, numPid, pVPIDs);
                //RTK_Source_SetTsidSid_Ex(source,A_tsid, numPid, pAPIDs);
            #endif
#elif defined(ENABLE_ALTIPROJECT)
        RTK_Source_SetTsidSidx(source,100);
#endif

	

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &video_config);
	RTK_Player_ChangeAudio(gPlayer_1, &audio_config);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	uint32_t u32VolumeVal = 0;
	RTK_audio_GetVolume(&u32VolumeVal);
	printf("get Current Volume val:%d\n",u32VolumeVal);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	RTK_Bool   bMuteStat = RTK_FALSE;
	RTK_Player_GetAudioMute  (gPlayer_1,&bMuteStat);
	
	printf("get Current Audio Mute status :%s\n",bMuteStat == RTK_FALSE ? "UnMute":"Mute");

#if (MTP_AUDIO_CHANGE)
		config2.callback.function = NULL;
		config2.callback.user_param = NULL;
		config2.input.type = RTK_INPUT_SOURCE;
		config2.video.codec = RTK_CODEC_VIDEO_MPEG2; //	it can be RTK_CODEC_NONE at initialize time.
		config2.video.pid = 0x100;
		config2.audio.codec = RTK_CODEC_AUDIO_AAC;	//	it can be RTK_CODEC_NONE at initialize time.
		config2.audio.pid = 0x110;
		config2.video.encrypted = RTK_FALSE;
		config2.audio.encrypted = RTK_FALSE;
		config2.audio.enable_raw_output_mode = RTK_FALSE;
		config2.audio.focused = RTK_FALSE;
		config2.pcr_pid = 0xFFFF;
		RTK_audio_setVolume(30);
		RTK_AudioConfig* audio = (RTK_AudioConfig*)malloc( sizeof(RTK_AudioConfig)*2);
		memcpy( audio, &config.audio, sizeof(RTK_AudioConfig));
		memcpy( (audio+1) , &config2.audio, sizeof(RTK_AudioConfig));
		time0 = pli_getMilliseconds();
#endif

/*
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
*/

	//	feed data until end of file.
	while(1)
	{

#if (MTP_AUDIO_CHANGE)
				time1 = pli_getMilliseconds();
				if (time1 - time0 > 10000)
				{
					static int i = 1;
					if (i == 0)
					{
						audio[0].focused = RTK_TRUE;
						audio[1].focused = RTK_FALSE;
					}
					else
					{
						audio[0].focused = RTK_FALSE;
						audio[1].focused = RTK_TRUE;
					}
					printf("================================== change audio ==================================\n");
		//			RTK_Player_ChangeAudio(gPlayer, audio[i]);
					RTK_Player_ChangeAudioEx(gPlayer_1, &audio, 2);
		
					i = (i == 0) ? 1 : 0;
					//------------------------------------------------------------------------------		
					time0 = time1;
					printf("\n\ntime1-time0>10000\n");
				}
#endif

		#if 0 // DMA buffer feed test. Please include rtk_ion.h 
		{
		int ret=0;
		static unsigned char *pVirtAddr=NULL;
		static unsigned int phyAddr=0;
		int feedSize=0;

		static ION_DATA  ionHl;

		if(ionHl.ion_virt==NULL)
		{
			memset(&ionHl, 0x00, sizeof(ION_DATA));


			ret=rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
				ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

			pVirtAddr=ionHl.ion_virt;
			phyAddr=(unsigned int)ionHl.ion_phy;
		}
		
		feedSize=fread(pVirtAddr, 1, (200*1024)/188*188, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);
			if(RTK_Player_FeedDMABuffer(gPlayer_1, phyAddr, feedSize, 2000/*2000 ms*/)!=0)
			{
				printf("mtp feed failed\n");
			}
		}
		
		}
		#else
		//get dma buffer.

		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);

		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.video_codec_type = video_config.codec;
				input_info.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);

					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{
					RTK_Source_DiscardInputBuffer(source, &buffer);

					usleep(6000);
				        continue;                                                
				}

				err = RTK_Source_FeedInputBuffer(source, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");

					RTK_Source_DiscardInputBuffer(source, &buffer);

					goto ON_ERROR;
				}
                              usleep(500);
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		#endif

#if 0
		if(isTestVideoScale)
		{
			property_get("enable.video.scale", pvalue, "0");
			if(pvalue[0] == '0')// '1'
			{
			    rtk_porting_destory_winSurface(RTK_SURFACE_V1);
			    rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_FALSE, 0, 0);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale",  "2");
			}
			else if(pvalue[0] == '1')
			{
				rtk_porting_destory_winSurface(RTK_SURFACE_V1);
				rtk_test_create_winSurface(RTK_WIN_MAIN, 80, 56, 544, 306);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_TRUE, 544, 306);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale", "2");
			}
		}
#endif

#if defined(ENABLE_CDCA)  || defined(ENABLE_ALTIPROJECT)
        unsigned char keyLen=8; 
        unsigned char ek_key_len=16;
        //unsigned char video_even_key[8] = {0xbe, 0x2b, 0x15, 0xfe, 0xff, 0x0c, 0x61, 0x6c};
        //unsigned char video_odd_key[8] = {0x83, 0xb4, 0xa2, 0xd9, 0x9f, 0x4a, 0xee, 0xd7};
        if(!bCWSet){
            #ifdef ENABLE_CDCA
                //CDCAHwa_SetCW(100, video_odd_key, video_even_key,  keyLen, false);
                //CDCAHwa_SetCW(200, audio_odd_key, audio_even_key, keyLen, false);
                //CDSTBCA_ScrSetCW(100, video_odd_key, video_even_key,  keyLen, false);
                //CDSTBCA_ScrSetCW(200, video_odd_key, video_even_key,  keyLen, false);
            #elif defined(ENABLE_ALTIPROJECT)
                 ALTIPROJECT_SetCW(100, video_odd_key, video_even_key,  keyLen, false);
            #endif
                bCWSet=true;
        }
#endif
		ptsTestCount++;
		if(ptsTestCount%200 == 0)
		{
			uint64_t ptsValue = 0;
			RTK_Player_GetCurrentDisplayingPTS(gPlayer_1,&ptsValue);
			printf("get Current PTS value:%llu\n",ptsValue);
		}	


#if  1  //temporary for set/get video/audio mute test
		if(isTestMute)	
		{
			count ++;
			if(count == 200)
			{
				printf("\n\n@@@@@@@@@@@@@@	Video Mute  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_TRUE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}
			if(count == 400)
			{
				printf("\n\n@@@@@@@@@@@@@@  Video ***Unmute***  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_FALSE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}

		}
#endif	
		static Hal_Demux_Info_t demuxInfo;
		static int xx=0;
		if(xx%400==0)
			RTK_Player_GetPacketDemuxInfo(gPlayer_1, &demuxInfo);
		xx++;
		
//		usleep(5*1000);	//	5ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
#ifdef ENABLE_CDCA
            
            bCWSet =false;
            //CDCAHwa_Remove_ECMPID(100);
            //CDCAHwa_Remove_ECMPID(A_tsid);
 #elif defined(ENABLE_ALTIPROJECT)
            ALTIPROJECT_Remove_ECMPID(100);
#endif 

	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(video_config.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}


void rtk_hal_test_Player_Fileplay_with_hdmi_delay() {

    long HDMI_VSDB_delay_ms=0;
    long HDMI_AUDIO_delay_ms=0;
    
    inputHdmiDelays(&HDMI_VSDB_delay_ms,&HDMI_AUDIO_delay_ms);
    
    RTK_SetHdmiOutVSDBDelay((int)HDMI_VSDB_delay_ms);
    RTK_SetAudioHdmiDelay(true,(int)HDMI_AUDIO_delay_ms);

    rtk_hal_test_Player_Fileplay();
}

void rtk_hal_test_Player_FilePIP()
{
	printf("[%s][%d]: rtk_hal_test_Player_FilePIP\n", __FILE__, __LINE__);

	RTK_Error ret = RTK_Fail;
	char file_path[256]={0};
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	RTK_Bool is_play_once = RTK_TRUE;
	FILE * file1=NULL;
	FILE * file2=NULL;
	RTK_SourceParam_t sourceParam1;
	RTK_SourceParam_t sourceParam2;
	RTK_Source source1 = NULL;
	RTK_Source source2 = NULL;
	RTK_Player player1 = NULL;
	RTK_Player player2 = NULL;

	RTK_VideoConfig videoConfig1;
	RTK_AudioConfig AudioConfig1;
	unsigned short PcrPid1;
	RTK_VideoConfig videoConfig2;
	RTK_AudioConfig AudioConfig2;
	unsigned short PcrPid2;
	RTK_Error status1 = (RTK_Error)RTK_OK;
	RTK_Error status2 = (RTK_Error)RTK_OK;
	bool player1_sleep, player2_sleep;

	memset(&sourceParam1, 0, sizeof(RTK_SourceParam_t));
	memset(&sourceParam2, 0, sizeof(RTK_SourceParam_t));

	videoConfig1.codec					= CHANNEL1_VIDEO_CODEC;
	videoConfig1.pid					= CHANNEL1_VIDEO_PID;
	videoConfig1.encrypted				= RTK_FALSE;
	videoConfig1.output 				= RTK_WIN_MAIN;
	videoConfig2.codec					= CHANNEL2_VIDEO_CODEC;
	videoConfig2.pid					= CHANNEL2_VIDEO_PID;
	videoConfig2.encrypted				= RTK_FALSE;
	videoConfig2.output 				= RTK_WIN_MAIN;

	AudioConfig1.codec					= CHANNEL1_AUDIO_CODEC;
	AudioConfig1.pid					= CHANNEL1_AUDIO_PID;
	AudioConfig1.focused				= RTK_TRUE;
	AudioConfig1.encrypted				= RTK_FALSE;
	AudioConfig1.enable_raw_output_mode = RTK_FALSE;
	AudioConfig2.codec					= CHANNEL2_AUDIO_CODEC;
	AudioConfig2.pid					= CHANNEL2_AUDIO_PID;
	AudioConfig2.focused				= RTK_FALSE;
	AudioConfig2.encrypted				= RTK_FALSE;
	AudioConfig2.enable_raw_output_mode = RTK_FALSE;

	is_play_once = xIsPlayOnce();

	// input file
	if (strlen(FILE_NAME_1) == 0)
	{
		printf("\nInput TSfile1  Path:\n");
		scanf("%s", file_path);
		rtkmid_input_AV_type_pid(&videoConfig1,&AudioConfig1, &PcrPid1);
	}
	else
	{
		sprintf(file_path, "%s", FILE_NAME_1);
	}
	file1 = fopen(file_path, "rb");
	if(file1 == NULL)
	{
		printf("failed to open ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file %s\n\n", file_path);
	}

	if (strlen(FILE_NAME_2) == 0)
	{
		printf("\nInput TSfile2  Path:\n");
		if (1 != scanf("%s", file_path))
		{
			printf("failed to read file path.\n\n");
		}
		rtkmid_input_AV_type_pid(&videoConfig2,&AudioConfig2, &PcrPid2);
	}
	else
	{
		sprintf(file_path, "%s", FILE_NAME_2);
	}
	file2 = fopen(file_path, "rb");
	if(file2 == NULL)
	{
		printf("failed to open ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file %s\n\n", file_path);
	}
	uint32_t totleFileSize1=0;
	fseek(file1,0,SEEK_END);
	totleFileSize1=ftell(file1);
	rewind(file1);
	printf("totleFileSize1==%u\n",totleFileSize1);
	fseek(file1,0,SEEK_SET);
	uint32_t totleFileSize2=0;
	fseek(file2,0,SEEK_END);
	totleFileSize2=ftell(file2);
	rewind(file2);
	printf("totleFileSize2==%u\n",totleFileSize2);
	fseek(file2,0,SEEK_SET);

	// create source 1
	memset(&sourceParam1, 0, sizeof(RTK_SourceParam_t));
	sourceParam1.type = RTK_SOURCE_TYPE_MTP;
	sourceParam1.tnr_param.mm_param.flag = 0;
	sourceParam1.cas_param.type = gCASType;
	sourceParam1.cas_param.tsid_sidx = 100;
	sourceParam1.isSMP = RTK_DvbGetSMP(0);
	ret = RTK_Source_Create(&source1,sourceParam1);
	if(ret != RTK_OK || source1 == NULL)
	{
		fclose(file1);
		fclose(file2);
		printf("Failed to create source1.\n");
		return ;
	}

	// create source 2
	memset(&sourceParam2, 0, sizeof(RTK_SourceParam_t));
	sourceParam2.type = RTK_SOURCE_TYPE_MTP;
	sourceParam2.tnr_param.mm_param.flag = 0;
	sourceParam2.cas_param.type = gCASType;
	sourceParam2.cas_param.tsid_sidx = 200;
	sourceParam2.isSMP = RTK_DvbGetSMP(1);
	ret = RTK_Source_Create(&source2,sourceParam2);
	if(ret != RTK_OK || source2 == NULL)
	{
		printf("Failed to create source2.\n");
		return ;
	}

	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);

	// create player1
	videoConfig1.output = RTK_WIN_MAIN;
	memset(&config, 0, sizeof(config));
	config.callback.function   = player_callback_1;
	config.callback.user_param = &player_status_1;
	config.input.type = RTK_INPUT_SOURCE;
	config.video.output = RTK_WIN_MAIN;
	ret = RTK_Player_Create(&player1, &config, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || player1 == NULL)
	{
		printf("Failed to create player1.\n");
		return;
	}
	RTK_Player_SetSource(player1, source1);

	// create player2
	videoConfig2.output = RTK_WIN_PIP;
	memset(&config, 0, sizeof(config));
	config.callback.function   = player_callback_2;
	config.callback.user_param = &player_status_2;
	config.input.type = RTK_INPUT_SOURCE;
	config.video.output = RTK_WIN_PIP;
	ret = RTK_Player_Create(&player2, &config, HAL_TYPE_DEMUX);
	if(ret != RTK_OK || player2 == NULL)
	{
		printf("Failed to create player2.\n");
		return;
	}
	RTK_Player_SetSource(player2, source2);

	// player start
	if(RTK_Player_Start(player1) != RTK_OK)
	{
		printf("Failed to start player1.\n");
		fclose(file1);
		return ;
	}
	RTK_Player_SetAVSyncMode(player2, RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
	RTK_Player_ChangeVideo(player1, &videoConfig1);
	RTK_Player_ChangeAudio(player1, &AudioConfig1);
	if(RTK_Player_Start(player2) != RTK_OK)
	{
		printf("Failed to start player2.\n");
		return ;
	}
	RTK_Player_ChangeVideo(player2, &videoConfig2);
	RTK_Player_ChangeAudio(player2, &AudioConfig2);

	// Feed data
	while(1)
	{
		player1_sleep = false;
		player2_sleep = false;

		//---------------------------------------------------------------------
		//	player1
		//---------------------------------------------------------------------
		if (status1 != RTK_WAIT_EOS)
		{
			status1 = RTK_Source_GetInputBuffer(source1, &buffer);
		}
		
		switch(status1)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file1;
				input_info.totalFileSize = totleFileSize1;
				input_info.video_codec_type = videoConfig1.codec;
				input_info.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source1, &buffer);
					usleep(6000);
					status1 = RTK_WAIT_EOS;
					continue;
					//goto __PIP_ON_WAIT_EOS;
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)
				{
					RTK_Source_DiscardInputBuffer(source1, &buffer);
					usleep(6000);
					continue;
				}
				status1 = RTK_Source_FeedInputBuffer(source1, &buffer);
				if(status1 != RTK_OK)
				{
					printf("feed nputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source1, &buffer);
					break;
				}
				break;
			case RTK_WAIT_EOS:
				printf("%s(%d) player1 RTK_WAIT_EOS\n",__FUNCTION__,__LINE__);
				player1_sleep = true;
				if(is_play_once == RTK_TRUE)
				{
					if(status2 == RTK_WAIT_EOS)
						goto __PIP_ON_WAIT_EOS;
				}
				else if(player_status_1.eof_reached)
				{
					printf("%s(%d) player1 EOS reached\n",__FUNCTION__,__LINE__);
					fseek(file1, 0, SEEK_SET);
					RTK_Player_Stop(player1,RTK_FALSE);
					RTK_Player_Start(player1);
					RTK_Player_ChangeVideo(player1, &videoConfig1);
					RTK_Player_ChangeAudio(player1, &AudioConfig1);
					player_status_1.eof_reached = RTK_FALSE;
					status1 = (RTK_Error)RTK_OK;
				}
				break;
			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				player1_sleep = true;
				//	no room of internal input buffer. wait some time until available.
				break;
				printf("gPlayer_1 UNKNOWN ERROR!!\n");
		}
		//---------------------------------------------------------------------
		//	player2
		//---------------------------------------------------------------------
		if (status2 != RTK_WAIT_EOS)
		{
			//get dma buffer.
			status2 = RTK_Source_GetInputBuffer(source2, &buffer);
		}
		
		switch(status2)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info2;
				memset(&input_info2,0x0,sizeof(INPUT_SOURCE_t));
				input_info2.fp = file2;
				input_info2.totalFileSize = totleFileSize2;
				input_info2.video_codec_type = videoConfig2.codec;
				input_info2.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info2, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source2, &buffer);
					status2 = RTK_WAIT_EOS;
					continue;
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)
				{
					RTK_Source_DiscardInputBuffer(source2, &buffer);
					usleep(6000);
					continue;
				}
				status2 = RTK_Source_FeedInputBuffer(source2, &buffer);
				if(status2 != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed inputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source2, &buffer);
					break;
				}
				break;
			case RTK_WAIT_EOS:
				printf("%s(%d) player2 RTK_WAIT_EOS\n",__FUNCTION__,__LINE__);
				player2_sleep = true;
				if(is_play_once == RTK_TRUE)
				{
					if(status1 == RTK_WAIT_EOS)
						goto __PIP_ON_WAIT_EOS;
				}
				else if(player_status_2.eof_reached)
				{
					printf("%s(%d) player2 EOS reached\n",__FUNCTION__,__LINE__);
					fseek(file2, 0, SEEK_SET);
					if(RTK_Player_Stop(player2, RTK_FALSE) != RTK_OK)
					{
						printf("%s(%d), clean up error\n",__FUNCTION__,__LINE__);
					}
					RTK_Player_Start(player2);
					RTK_Player_ChangeVideo(player2, &videoConfig2);
					RTK_Player_ChangeAudio(player2, &AudioConfig2);
					player_status_2.eof_reached = RTK_FALSE;
					status2 = (RTK_Error)RTK_OK;
				}
				break;
			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				player2_sleep = true;
				//	no room of internal input buffer. wait some time until available.
				break;
				printf("gPlayer_2 UNKNOWN ERROR!!\n");
		}

		if (player1_sleep && player2_sleep)
		{
			usleep(1000);	//	1ms.
		}
	}

__PIP_ON_WAIT_EOS:
	//	wait 30 seconds until end of stream event.
	for(int i = 0; i < 30; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached && player_status_2.eof_reached )
		{
			printf("eof_reached\n");
			break;
		}
	}

	if(RTK_Player_Stop(player1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player1.\n");
		return;
	}
	if(RTK_Player_Stop(player2,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player2.\n");
		return;
	}

	// disconnect
	RTK_Player_SetSource(player1, NULL);
	RTK_Player_SetSource(player2, NULL);

	if(RTK_Player_Destroy(player1) != RTK_OK)
	{
		printf("Failed to destroy player1.\n");
		return;
	}
	if(RTK_Player_Destroy(player2) != RTK_OK)
	{
		printf("Failed to destroy player2.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	RTK_DestorySurface(RTK_WIN_PIP);

	// destory source
	RTK_Source_Destroy(source1);
	RTK_Source_Destroy(source2);

	
	printf("fielPIP Test finish.\n");
	return ;
}


void rtk_hal_test_Player_Sectionfilter()
{
	printf("\n rtk_hal_test_Player_Sectionfilter  hello\n\n");
	RTK_PlayerConfig config;
	RTK_SourceParam_t sourceParam;
	RTK_Source source = NULL;
	memset(&config, 0, sizeof(config));
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	sourceParam.TunerID = 0;
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	RTK_Source_Create(&source,sourceParam);
	if(source == NULL)
	{
	   printf("Source is NULL!!");
	   return ;
	}
	//DVB-c setting
	rtkmid_input_Tuner_Param(&config.input.tuner);
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, config.input.tuner))
	{
		printf("RTK_Tuner_Scan failed!!");
		return ;
	}
	gPlayer_1 = NULL;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, source);

//RTK_Player_AddSectionFilter Description
/*************
	prototype	RTK_Error RTK_Player_AddSectionFilter(RTK_Player player, 
	RTK_SectionFilter * filter_handle, 
	RTK_SectionFilterMask * pattern)
	brief			opens and sets sectionFilter by specific pid, add the SectionFilter into SI 
	engine with the player handle
	parameter	player:		handle of player to add section filter
				filter_handle:	handle of filter to specify
	pattern:	defines filter pid, mask, mode, compose type, monitor mode, user param and a function pointer to SI section filter callback
	return		RTK_OK, RTK_Fail
	Detailed
	This function provides an interface to add section filter to get sections data with specific pid. When sectionFilter works, pattern->callback will receive the sections.
	Player handle is assigned by RTK_Player_Create. Filter handle is assign to filter Index.
		typedef struct
		{
			UINT16_T pid;
	        UINT32_T options;
			RTK_SectionMonitoringMode monitoring_mode;
			UINT8_T mask[RTK_MAX_SECTION_MASK_LENGTH];	
			UINT8_T mode[RTK_MAX_SECTION_MASK_LENGTH];	
			UINT8_T comp[RTK_MAX_SECTION_MASK_LENGTH];	
			RTK_SectionFilterCallback callback;
			void * section_user_param;
		uint32_t u32byWaitTimeoutMs;
		RTK_SectionFilterCallback_01 callback_01;
		} RTK_SectionFilterMask;
		With the parameter pattern, it is clear to recognize filter features. At least, pattern->pid, pattern-> monitoring_mode,pattern->comp[0] ,  pattern->mask[0] and pattern->callback should be setting. 
		pattern->pid is the PID of TS package you want to get.
		pattern->monitoring_mode has two options show as RTK_SectionMonitoringMode. 	RTK_SECTION_MODE_ONESHOT means specified section callback should be called 1 time 	only. Specified section callback should be called whenever section was received if 	RTK_SECTION_MODE_CONTINOUS has been set. 
		typedef enum
		{
			RTK_SECTION_MODE_ONESHOT,	
			RTK_SECTION_MODE_CONTINOUS
		} RTK_SectionMonitoringMode;

	pattern-> mask: for all inclusion mask bits that are masked	(set to 0xff) ALL of the corresponding bits in the message must match the bits specified by the coefficient in order to be included. If one bit differs, it will be excluded.
	pattern-> mode: reserved, we do not use this param, it can be ignored now.
	pattern-> comp: the current filter value, it equivalent to an array, the max size of this array is 16 Byte.
			note: pattern->comp[0] stands for tid and must be given a value.
			 	mask[0] stands for tid and must be given a value 0xff or 0xfe.
	pattern-> u32byWaitTimeoutMs:  unit is millisecond, when its value is set 0, we will not check time out; when its value is set above 0, we will check time out;

		As parameter pattern->callback01, a function pointer to the section data reception function 	must be passed. This callback function defined as below:
	typedef void (*RTK_SectionFilterCallback_01)(const RTK_SectionFilter handle, RTK_HAL_SECTION_CB_STATUS enStatus,const unsigned char *section, const unsigned int length, void * userParam);

	typedef enum 
	{
		HAL_SECTION_FILTER_TIMEOUT,           //0x00  
		HAL_SECTION_FILTER_HIT      		  //0x01
	}RTK_HAL_SECTION_CB_STATUS;

		pattern->options default value is 0, it means to do CRC check.
		RTK_OK is returned if _xAddSectionFilter has successfully processed.
		RTK_Fail is returned if parameters error occurred or filter open failed.
***********/

//realtek internal use ts18 to do this test


///////////// the flow is pat setting example
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;//PAT
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	SectionFilterPattern0.u32byWaitTimeoutMs = 0;
	SectionFilterPattern0.comp[0] = 0x00;// comp[0] stands for tid and must be given a value.		
	SectionFilterPattern0.mask[0] = 0xFF; //  mask[0] stands for tid and must be given a value 0xff or 0xfe.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);

	
////////// the flow is cat setting example	
	memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern1.pid = 0X01;//CAT
	SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern1.comp[0] = 0x01;// comp[0] stands for tid and must be given a value.		
	SectionFilterPattern1.mask[0] = 0xFF; //  mask[0] stands for tid and must be given a value 0xff or 0xfe.	
	SectionFilterPattern1.callback_01 = section_callback1;
	/*****************
	 note: 	1, when section_callback2 enStatus return value is HAL_SECTION_FILTER_TIMEOUT,we will not recevie any section,
	        and the same time,we should do call RTK_Error RTK_Player_RemoveSectionFilter(RTK_Player player, RTK_SectionFilter filter_handle) func,
	        if we want to receive section data , we need call   RTK_Player_AddSectionFilter again.	
	      
	*****************/
	SectionFilterPattern1.u32byWaitTimeoutMs = 4000;// unit is millisecond
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle1, &SectionFilterPattern1);



///////////// the flow is emm setting example
	memset(&SectionFilterPattern2, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern2.pid = 0X053c;//emm pid
	SectionFilterPattern2.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern2.callback_01 = section_callback2;

	SectionFilterPattern2.options = 1;  // do crc check
	SectionFilterPattern2.u32byWaitTimeoutMs = 0;// unit is millisecond

/********
// need not check index 1 and 2  (0x00,0xB4)  
Data:   
0x82, 0x00, 0xB4, 0x3F, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x01, 0xCA, 0x01, 0xBB, 0x7E,

pattern mask set to filter as below,
comp:
0x82, 0x3F, 0x87, 0x00, 0x00,  0x00, 0x00, 0x00, 0x1A, 0x01, 0xCA, 0x01, 0x00, 0x00, 0x00, 0x00,
mask:
0xFF, 0xFF,0xFF,0xFF, 0xFF, 0xFF, 0xFF,0xFF,0xFF, 0xFF, 0xFF, 0xFF,0x00, 0x00, 0x00, 0x00,

If you want to specify data 0x82 , 0x3f 0x87, 0x1a to be received,  you can setting as thw follow
*********/

	SectionFilterPattern2.comp[0] = 0x82;
	SectionFilterPattern2.comp[1] = 0x3F;
	SectionFilterPattern2.comp[2] = 0x87;
	SectionFilterPattern2.comp[8] = 0x1A;
	SectionFilterPattern2.comp[9] = 0x01;

	SectionFilterPattern2.mask[0] = 0xFF; //mask[0] stands for tid and must be given a value 0xff or 0xfe.
	SectionFilterPattern2.mask[1] = 0xFF; 
	SectionFilterPattern2.mask[2] = 0xFF;
	SectionFilterPattern2.mask[8] = 0xFF;
	SectionFilterPattern2.mask[9] = 0xFF; 

	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle2, &SectionFilterPattern2);
	

	///////////// the flow is EIT setting example
	memset(&SectionFilterPattern3_1, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern3_1.pid = 0x12;// pid
	SectionFilterPattern3_1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern3_1.callback_01 = section_callback3_1;
	SectionFilterPattern3_1.u32byWaitTimeoutMs = 0;// unit is millisecond
	SectionFilterPattern3_1.comp[0] = 0x4e;// comp[0] stands for tid and must be given a value.
	SectionFilterPattern3_1.mask[0] = 0xfe; // mask[0] stands for tid and must be given a value 0xff or 0xfe.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle3_1, &SectionFilterPattern3_1);

	memset(&SectionFilterPattern4_1, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern4_1.pid = 0x12;// pid
	SectionFilterPattern4_1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern4_1.callback_01 = section_callback3_1;
	SectionFilterPattern4_1.u32byWaitTimeoutMs = 0;// unit is millisecond
	SectionFilterPattern4_1.comp[0] = 0x50;// comp[0] stands for tid and must be given a value.
	SectionFilterPattern4_1.mask[0] = 0xff; // mask[0] stands for tid and must be given a value 0xff or 0xfe.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle4_1, &SectionFilterPattern4_1);


	memset(&SectionFilterPattern4_2, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern4_2.pid = 0x12;// pid
	SectionFilterPattern4_2.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern4_2.callback_01 = section_callback3_1;
	SectionFilterPattern4_2.u32byWaitTimeoutMs = 0;// unit is millisecond
	SectionFilterPattern4_2.comp[0] = 0x60;// comp[0] stands for tid and must be given a value.
	SectionFilterPattern4_2.mask[0] = 0xff; // mask[0] stands for tid and must be given a value 0xff or 0xfe.
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle4_2, &SectionFilterPattern4_2);

	
	int i=0;
	for(i=SECTIONFILTER_TEST_WAIT_TIME_SECOND;  i> 0;  i--)
	{
		sleep(1);
		printf("Tuner A/V is playing.....%d s to stop it\n", i);
	}

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle0);

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle1);

	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle2);


	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle3_1);


	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle4_1);
	RTK_Player_RemoveSectionFilter(gPlayer_1,filter_handle4_2);


	// you can also call RTK_Player_RemoveAllSectionFilters remove all sectionflter filters
/*		
		if(RTK_Player_RemoveAllSectionFilters(gPlayer_1) != RTK_OK)
			printf("Failed to remove all sectionfilter filter\n");
*/	

	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	printf("Test finish.\n");
	
	return;
}

void rtk_hal_test_Source_Sectionfilter()
{
	printf("[%s][%d]: rtk_hal_test_Source_Sectionfilter\n", __FILE__, __LINE__);

	RTK_TunerParam_t  tunerParam;
	RTK_SourceParam_t sourceParam;
	RTK_Source source = NULL;
	unsigned char TunerID = 0;

	// create tuner
	memset(&tunerParam, 0, sizeof(RTK_TunerParam_t));
	rtkmid_input_Tuner_Param(&tunerParam);
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(TunerID, tunerParam))
	{
		printf("RTK_Tuner_Scan failed!!");
		return ;
	}

	// create source
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	sourceParam.TunerID = TunerID;
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	RTK_Source_Create(&source,sourceParam);
	if(source == NULL)
	{
	   printf("Source is NULL!!");
	   return ;
	}

	// clear param
	memset(&m_pmtFilterPID,0,sizeof(m_pmtFilterPID));
	memset(m_pmtHandle,0,sizeof(m_pmtHandle));
	bzero(&m_programInfo, sizeof(TS_Program_Info));
	m_programInfo.pat_program.version = 0xff;
	m_programInfo.cat_program.version = 0xff;
	file_play_status = 1;
	m_recvProgramCnt = 0;
	waitpmt = 1;

	// section filter PAT
	RTK_SectionFilter sectionHandle;
	RTK_SectionFilterMask sectionPattern;
	bzero(sectionPattern.comp, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(sectionPattern.mask, RTK_MAX_SECTION_MASK_LENGTH);
	bzero(sectionPattern.mode, RTK_MAX_SECTION_MASK_LENGTH);
	sectionPattern.comp[0] = TS_PSI_TID_PAT;
	sectionPattern.mask[0] = 0xFF;
	sectionPattern.pid = TS_PSI_PID_PAT;
	sectionPattern.section_user_param = source;
	sectionPattern.callback_01 = SectionCallback;
	sectionPattern.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	if (RTK_Source_AddSectionFilter(source, &sectionHandle, &sectionPattern) != RTK_OK)
	{
		printf("Failed to add PAT section filter.\n");
		return;
	}

	int i = 0;
	while(waitpmt == 1 && i < 10)
	{
		sleep(1);
		printf("test %d sec\n", i);
		i++;
	}
	sleep(1); // wait PMT parsing log finish

	// destroy source
	RTK_Source_Destroy(source);

	printf("Test finish.\n");

	return ;
}

#define ZAPPING_WAIT_TIME 10
static RTK_Bool isKeep = RTK_FALSE;
void* ChannelChangeThread(void *)
{

	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		

		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			
			PLAYER_LOCK();

			gettimeofday(&startzaping_1, NULL);

			if(gPlayer_1 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}

				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_1 = NULL;
			}

			if(gPlayer_2 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}

				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_2 = NULL;
			}


			if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("Failed to create player.\n");
				PLAYER_UNLOCK();
				return NULL;
			}

			if (gPlayer_1 == NULL)
			{
				printf("Player is NULL!!");
				PLAYER_UNLOCK();
				return NULL;
			}

			
			PLAYER_UNLOCK();
			
			player_status_1.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_1) != RTK_OK)
			{
				printf("Failed to start player.\n");
				return NULL;
			}
			channel_number = 1;

			memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern0.pid = 0x00;//PAT
			SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern0.callback_01 = section_callback2;
			SectionFilterPattern0.u32byWaitTimeoutMs = 0;
			RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
			
			
			memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern1.pid = 0X01;//CAT
			SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern1.callback_01 = section_callback3;
			SectionFilterPattern1.u32byWaitTimeoutMs = 0;
			RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle1, &SectionFilterPattern1);

			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();

			gettimeofday(&startzaping_2, NULL);
			
			if(gPlayer_1 != NULL)
			{
				
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_1, filter_handle1);


				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_1 = NULL;
			}
			if(gPlayer_2 != NULL)
			{
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle0);
				RTK_Player_RemoveSectionFilter(gPlayer_2, filter_handle1);

				if(isKeep ==RTK_TRUE)
				{
					if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				else
				{
					if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
					{
						printf("Failed to stop player.\n");
					}
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("Failed to destroy.\n");
				}
				gPlayer_2 = NULL;
			}


			if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("Failed to create player.\n");
				PLAYER_UNLOCK();
				return NULL;
			}

			if (gPlayer_2 == NULL)
			{
				printf("Player is NULL!!");
				PLAYER_UNLOCK();
				return NULL;
			}

			PLAYER_UNLOCK();

			player_status_2.eof_reached = RTK_FALSE;
			if(RTK_Player_Start(gPlayer_2) != RTK_OK)
			{
				printf("Failed to start player.\n");
				return NULL;
			}
			channel_number = 2;

			memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern0.pid = 0x00;//PAT
			SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern0.callback_01 = section_callback2;
			RTK_Player_AddSectionFilter(gPlayer_2, &filter_handle0, &SectionFilterPattern0);
			
			
			memset(&SectionFilterPattern1, 0x00, sizeof(RTK_SectionFilterMask));
			SectionFilterPattern1.pid = 0X01;//CAT
			SectionFilterPattern1.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
			SectionFilterPattern1.callback_01 = section_callback3;
			RTK_Player_AddSectionFilter(gPlayer_2, &filter_handle1, &SectionFilterPattern1);
			

			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}



#define TEST_PAUSE_DROP_RESUME

void* MultiViewChannelLiveThread(void *)
{
	THREAD_EXIT_LOCK();
	gThreadExit = RTK_FALSE;
	THREAD_EXIT_UNLOCK();
	
	isKeep = RTK_FALSE;
	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}

			if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_1 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_1.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_1) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			

			if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_2 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_2.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_2) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 1;
			PLAYER_UNLOCK();
			
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_2 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_2, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
			}
			
			if(gPlayer_1 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_1 = NULL;
			}
			
			if(RTK_Player_Create(&gPlayer_3, &Config_3, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_3 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			player_status_3.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_3) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			

			channel_number = 2;
			PLAYER_UNLOCK()
				
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}

void* MultiViewChannelChangeThread(void *)
{
	THREAD_EXIT_LOCK();
	gThreadExit = RTK_FALSE;
	THREAD_EXIT_UNLOCK();
	
	isKeep = RTK_TRUE;
	sleep(ZAPPING_WAIT_TIME);//wait for ZAPPING_WAIT_TIME  for first av play.

	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		if(channel_number != 1)
		{
			printf("begin to change channel 1...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_1 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				RTK_Player_SetSource(gPlayer_1, NULL);
				RTK_Source_Destroy(gSource_1);
				gSource_1=NULL;
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_1 = NULL;
			}
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				RTK_Player_SetSource(gPlayer_3, NULL);
				RTK_Source_Destroy(gSource_3);
				gSource_3=NULL;
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}

			if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_1 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			RTK_SourceParam_t sourceParam;
			memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
			sourceParam.type = RTK_SOURCE_TYPE_MTP;
			sourceParam.tnr_param.mm_param.flag = 0;
			sourceParam.cas_param.type = gCASType;
			sourceParam.cas_param.tsid_sidx = 100;
			sourceParam.isSMP = RTK_DvbGetSMP(0);

			RTK_Source_Create(&gSource_1,sourceParam);
			RTK_Player_SetSource(gPlayer_1,gSource_1);
			player_status_1.eof_reached = RTK_FALSE;			
			if(RTK_Player_Start(gPlayer_1) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 1;
			PLAYER_UNLOCK();
			
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
		else
		{
			printf("begin to change  channel 2...\n");
			
			PLAYER_LOCK();
			
			if(gPlayer_1 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_1, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				RTK_Player_SetSource(gPlayer_1, NULL);
				RTK_Source_Destroy(gSource_1);
				gSource_1=NULL;
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_1 = NULL;
			}
			
			if(gPlayer_3 != NULL)
			{
				if(RTK_Player_Stop(gPlayer_3, isKeep) != RTK_OK)
				{
					printf("[%s:%d]Failed to stop player.\n", __func__, __LINE__);
				}
				RTK_Player_SetSource(gPlayer_3, NULL);
				RTK_Source_Destroy(gSource_3);
				gSource_3=NULL;
				if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
				{
					printf("[%s:%d]Failed to destroy.\n", __func__, __LINE__);
				}
				gPlayer_3 = NULL;
			}
			
			if(RTK_Player_Create(&gPlayer_3, &Config_3, HAL_TYPE_DEMUX) != RTK_OK)
			{
				printf("[%s:%d]Failed to create player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			if (gPlayer_3 == NULL)
			{
				printf("[%s:%d]Player is NULL!!", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			RTK_SourceParam_t sourceParam;
			memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
			sourceParam.type = RTK_SOURCE_TYPE_MTP;
			sourceParam.tnr_param.mm_param.flag = 0;
			sourceParam.cas_param.type = gCASType;
			sourceParam.cas_param.tsid_sidx = 100;
			sourceParam.isSMP = RTK_DvbGetSMP(0);

			RTK_Source_Create(&gSource_3,sourceParam);
			RTK_Player_SetSource(gPlayer_3,gSource_3);
			player_status_3.eof_reached = RTK_FALSE;
			if(RTK_Player_Start(gPlayer_3) != RTK_OK)
			{
				printf("[%s:%d]Failed to start player.\n", __func__, __LINE__);
				PLAYER_UNLOCK();
				return NULL;
			}
			
			channel_number = 2;
			PLAYER_UNLOCK()
				
			for(int i=0; i<ZAPPING_WAIT_TIME; i++)
			{
				sleep(1);
			}

		}
	}

	return NULL;
}

/*simulate digicap UI advertisement fileplay circularly*/
/*unit test needs receive every EOS notify*/
/*/data/adv_files, total 20 files*/

unsigned char file_codec[1][2]={
{RTK_CODEC_VIDEO_H264,RTK_CODEC_AUDIO_AAC},
};
uint16_t av_pid[1][3]={
{512,513,512},
};
void rtk_hal_test_Player_EOS_File_Notify()
{	
	printf("\n rtk_hal_test_Player_EOS_File_Notify enter\n\n");

	static bool test_next_file = RTK_FALSE;
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(file_path);
	UNUSED(count);
	UNUSED(bvideomute);
	
	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	int ch = 0;	
	//test ts file in /data/adv_files, total 20 files

	UNUSED(ch);
	
	int fileCount = 20;
	char fileName[64] = {0};
	for(int i=0;i<fileCount;i++)
	{
		//open adv file one by one
		sprintf(fileName, "/data/adv_files/adv_%d.ts", i);
		file = fopen(fileName, "rb");
		if(file == NULL)
		{
			printf("%s %s %d:fail!! ERROR to open %s !\n", __FILE__, __FUNCTION__, __LINE__, fileName);
			return;
		}
		else
		{	
			printf("%s %s %d:success!! Success to open %s!\n", __FILE__, __FUNCTION__, __LINE__, fileName);
		}
		uint32_t totalFileSize = 0;
		fseek(file,0,SEEK_END);
		totalFileSize=ftell(file);
		rewind(file);
		printf("fileName==%s,totalFileSize==%u\n",fileName,totalFileSize);
		fseek(file,0,SEEK_SET);

		//set video audio codec & pid
		config.video.codec		= (RTK_Codec)file_codec[0][0];
		config.video.pid		= av_pid[0][0];
		config.audio.codec		= (RTK_Codec)file_codec[0][1];//	it can be RTK_CODEC_NONE at initialize time.
		config.audio.pid		= av_pid[0][1];
		config.pcr_pid			= av_pid[0][2];

		gettimeofday(&startzaping_1, NULL);

		int videopid = config.video.pid;
		int audiopid = config.audio.pid;
		config.video.pid = 0;
		config.audio.pid = 0;
	
		if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
		{
			printf("Failed to create player.\n");
			fclose(file);
			return;
		}

		if (gPlayer_1 == NULL)
		{
			printf("Player is NULL!!");
			return;
		}
		RTK_Source source = NULL;
		RTK_SourceParam_t sourceParam;
		memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
		sourceParam.type = RTK_SOURCE_TYPE_MTP;
		sourceParam.tnr_param.mm_param.flag = 0;
		sourceParam.cas_param.type = gCASType;
		sourceParam.cas_param.tsid_sidx = 100;
		sourceParam.isSMP = RTK_DvbGetSMP(0);

		RTK_Source_Create(&source,sourceParam);
		RTK_Player_SetSource(gPlayer_1,source);
		if(RTK_Player_Start(gPlayer_1) != RTK_OK)
		{
			printf("Failed to start player.\n");
			return ;
		}
	
		test_next_file = RTK_FALSE;

		config.video.pid = videopid;
		config.audio.pid = audiopid;

		//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
		RTK_Player_ChangeVideo(gPlayer_1, &config.video);
		RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
		while(test_next_file == RTK_FALSE)
		{
			//get dma buffer.
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
					       break;                                                
					} 
					err = RTK_Source_FeedInputBuffer(source, &buffer);
					if(buffer.isLast == RTK_TRUE)
					{
						printf("read file==%s is end\n",fileName);
						test_next_file = RTK_TRUE;
						break;
					}

					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						RTK_Source_DiscardInputBuffer(source, &buffer);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Source_DiscardInputBuffer(source, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
					//	no room of internal input buffer. wait some time until available.
					usleep(10000);	//	100ms.
					break;

				default:
					printf("UNKNOWN ERROR!!\n");
					goto ON_ERROR;
					break;
			}
		
			usleep(10000);	//	100ms.	
		}

		//	wait until end of stream event.
		if(buffer.isLast == RTK_TRUE)
		{
			while(!player_status_1.eof_reached)
			{
				sleep(1);
				printf("waiting until eos\n");
			}
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				fclose(file);
				if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
				{
					printf("Failed to stop player.\n");
					return;
				}
				RTK_Player_SetSource(gPlayer_1, NULL);
				RTK_Source_Destroy(source);
				if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
				{
					printf("Failed to destroy player.\n");
					return;
				}
				gPlayer_1 = NULL;
			}
		}
		if(i ==fileCount-1)
			i=0;
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	
	printf("Test finish.\n");
	
return;

}
/*simulate digicap UI advertisement fileplay circularly*/

void rtk_hal_test_Player_Fileplay2(const char* pFilePath, uint16_t videoPid, uint16_t audioPid, RTK_Codec videoCodec, RTK_Codec audioCodec)
{	
	printf("\n rtk_hal_test_Player_Fileplay2 hello\n\n");
	RTK_Bool is_play_once = RTK_TRUE;
	if(pFilePath == NULL)
	{
		printf("pFilePath is null!!!\n\n");
		return;
	}
	FILE* file = NULL;
	file = fopen(pFilePath, "rb");
	if(file == NULL)
	{
		printf("the file open fail, please chec the file exist or file permissions!!!\n");
		return;
	}
	
	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	///////////////////////////////////////////////////////////
	//init parameters
	///////////////////////////////////////////////////////////
	memset(&config, 0, sizeof(config));
	config.callback.function			= player_callback_1;
	config.callback.user_param			= &player_status_1;
	config.input.type					= RTK_INPUT_SOURCE;
	config.video.codec					= videoCodec;
	config.video.pid					= videoPid;
	config.video.encrypted				= RTK_FALSE;
	config.video.output 				= RTK_WIN_MAIN;
	config.audio.codec					= audioCodec; //	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid					= audioPid;
	config.audio.encrypted				= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid						= videoPid;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}
	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.filePlay_once = is_play_once;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
				//	no room of internal input buffer. wait some time until available.
				usleep(100000);	//	100ms.
				break;

			default:
				printf("UNKNOWN ERROR!!\n");
				goto ON_ERROR;
				break;
		}


		usleep(100000);	//	100ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:

	if(file)
	{
		fclose(file);
		file = NULL;
	}
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;
}

RTK_Demux demux;
static void rtk_hal_test_Demux_DVR_record()
{
	printf("\n rtk_hal_test_Player_DVR_record hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	int isRecordFromFile=0;
	char ch='\0';
	uint32_t totalFileSize=0;

	UNUSED(count);

	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));

	printf("\n Do you want to record from file(Default from tuner)? (y/N):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isRecordFromFile=1;
			printf(" record from file !\n");
		}
		else
		{
			isRecordFromFile=0;
			printf(" record from tuner !\n");
		}
	}
	fflush(stdin);

	if(isRecordFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function		= player_callback_4;
		config.callback.user_param	= &player_status_1;

		//we use RTK_TSInputBuffer to feed data.
		config.input.type = RTK_INPUT_SOURCE;

	
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		config.callback.function = player_callback_4;

		config.input.type = RTK_INPUT_SOURCE;

		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}
		
#if 1
	printf("\nPlease Input Record file path:\n");
	scanf("%s", file_path);
	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
#endif

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
#if 1
    RTK_Demux demux;    
    RTK_DemuxConfig Config_demux;
	memset(&Config_demux, 0, sizeof(Config_demux));
	Config_demux.callback.function = player_callback_4;
	Config_demux.callback.user_param	= &player_status_1;
	Config_demux.input.type = RTK_INPUT_SOURCE;
#endif	
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Demux_Create(&demux, &Config_demux) != RTK_OK)
	{
		fclose(file);
		printf("Failed to create player.\n");
		return;
	}

	if (demux == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	if(isRecordFromFile)
	{
		sourceParam.type = RTK_SOURCE_TYPE_MTP;
		sourceParam.tnr_param.mm_param.flag = 0;
		sourceParam.cas_param.type = gCASType;
		sourceParam.cas_param.tsid_sidx = 100;
		sourceParam.isSMP = RTK_DvbGetSMP(0);
	}
	else
	{
		sourceParam.TunerID = 0;
		sourceParam.type = RTK_SOURCE_TYPE_TP;
		sourceParam.cas_param.type = gCASType;
		sourceParam.cas_param.tsid_sidx = 100;
		sourceParam.isSMP = RTK_DvbGetSMP(0);
		RTK_Tuner_Init();
		if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, config.input.tuner))
		{
			printf("RTK_Tuner_Scan failed!!");
			return ;
		}
	}
	RTK_Source_Create(&source,sourceParam);
	RTK_Demux_SetSource(demux,source);


	//Player start.
	if(RTK_Demux_Start(demux) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	//RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	//RTK_Player_ChangeAudio(gPlayer_1, &config.audio);


#if 1
#if 1
	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	videoTSFilter.encrypt = RTK_FALSE;
	videoTSFilter.pid = config.video.pid;

	if(RTK_Demux_AddTSFilter(demux, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_FALSE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;

	if(RTK_Demux_AddTSFilter(demux, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}

#if 0
	//PAT TS filter
	RTK_TSFilter PATTSFilterHandle;
	RTK_TSFilterPattern PATTSFilter;
	PATTSFilter.encrypt = RTK_FALSE;
	PATTSFilter.isAnchor = RTK_FALSE;
	PATTSFilter.pid = 0;
	PATTSFilter.codec = RTK_CODEC_NONE;
	PATTSFilter.isTag = RTK_TRUE;
	if(RTK_Demux_AddTSFilter(demux, &PATTSFilter, &PATTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", PATTSFilter.pid);
	}

	//PMT TS filter
	RTK_TSFilter PMTTSFilterHandle;
	RTK_TSFilterPattern PMTTSFilter;
	PMTTSFilter.encrypt = RTK_FALSE;
	PMTTSFilter.isAnchor = RTK_FALSE;
	PMTTSFilter.pid = 0x243;
	PMTTSFilter.codec = RTK_CODEC_NONE;
	PMTTSFilter.isTag = RTK_FALSE;
	if(RTK_Demux_AddTSFilter(demux, &PMTTSFilter, &PMTTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", PATTSFilter.pid);
	}
#endif

#else
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;//PAT
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_ONESHOT;
	SectionFilterPattern0.callback_01 = section_callback5;
	SectionFilterPattern0.u32byWaitTimeoutMs = 0;
	RTK_Demux_AddSectionFilter(demux, &filter_handle0, &SectionFilterPattern0);
#endif
#endif	

	if(isRecordFromFile)
	{
		// wait PID filter ready
		usleep(200*1000);

		while(1)
		{
			//get dma buffer.
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);

			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");

						RTK_Source_DiscardInputBuffer(source, &buffer);

						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						RTK_Source_DiscardInputBuffer(source, &buffer);

						usleep(6*1000);
						continue;
					} 

					err = RTK_Source_FeedInputBuffer(source, &buffer);


					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");
						RTK_Source_DiscardInputBuffer(source, &buffer);

						goto ON_ERROR;
					}
					else

					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}

			usleep(10*1000);
		
		}
	}
	else
	{
		int i=0;
		for(i=WAIT_TIME_SECOND;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}	
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	if(isRecordFromFile)
	{
		for(int i = 0; i < 10; ++i)
		{
			sleep(1);
			printf("waiting until eos\n");
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				break;
			}
		}
	}
ON_ERROR:

	if(isRecordFromFile)
		fclose(file);

	#if 1
	//remove audio TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, audioTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) audioTSFilterHandle);
	
	//remove video TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, videoTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) videoTSFilterHandle);
	#else
	RTK_Demux_RemoveSectionFilter(demux,filter_handle0);
	#endif


	// you can also call RTK_Demux_RemoveAllTSFilters remove all ts filters
	if(RTK_Demux_RemoveAllTSFilters(demux) != RTK_OK)
		printf("Failed to remove all TS filter\n");

	if(RTK_Demux_Stop(demux) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	RTK_Demux_SetSource(demux, NULL);
	RTK_Source_Destroy(source);


	if(RTK_Demux_Destroy(demux) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	demux = NULL;
	printf("Test finish.\n");

	return;

	
}

static void rtk_hal_test_Player_DVR_record()
{
	printf("\n rtk_hal_test_Player_DVR_record hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	int isRecordFromFile=0;
	char ch='\0';
	uint32_t totalFileSize=0;

	UNUSED(count);

	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));

	

	//Creat a surface.
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	printf("\n Do you want to record from file(Default from tuner)? (y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isRecordFromFile=1;
			printf(" record from file !\n");
		}
		else
		{
			isRecordFromFile=0;
			printf(" record from tuner !\n");
		}
	}
	fflush(stdin);

	if(isRecordFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function	= Record_callback;
		config.callback.user_param	= &player_status_1;

		//we use RTK_TSInputBuffer to feed data.
		config.input.type = RTK_INPUT_SOURCE;

	
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		config.input.type = RTK_INPUT_SOURCE;

		config.callback.function = Record_callback; // player_callback_4
		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}

#if 0
	config.rec.enc_method = RTK_REC_METHOD_CONNECTPVR;
	config.rec.mode = RTK_REC_MODE_TS;
#endif

#if 1
	printf("\nPlease enter the path and name of the file where the recorded data will be stored.(like:/data/rec.ts):\n");
	scanf("%s", file_path);
	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", file_path);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", file_path);
	}
	
	printf("\nRecorded pts data will be stored in %s.\n", PVR_REC_PTSFILE_PATH);
	pvr_pts_fp_player = fopen(PVR_REC_PTSFILE_PATH, "wb");
	if(pvr_pts_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_PTSFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_PTSFILE_PATH);
	}
	
	printf("\nRecorded frame data will be stored in %s.\n", PVR_REC_FRAMEFILE_PATH);
	pvr_frame_fp_player = fopen(PVR_REC_FRAMEFILE_PATH, "wb");
	if(pvr_frame_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_FRAMEFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_FRAMEFILE_PATH);
	}

	printf("\nRecorded pcr data will be stored in %s.\n", PVR_REC_PCRFILE_PATH);
	pvr_pcr_fp_player = fopen(PVR_REC_PCRFILE_PATH, "wb");
	if(pvr_pcr_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_PCRFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_PCRFILE_PATH);
	}

	printf("\nRecorded tag data will be stored in %s.\n", PVR_REC_TAGFILE_PATH);
	pvr_tag_fp_player = fopen(PVR_REC_TAGFILE_PATH, "wb");
	if(pvr_tag_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_TAGFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_TAGFILE_PATH);
	}

#endif

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		if(isRecordFromFile)
			fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	if(isRecordFromFile)
	{
		sourceParam.type = RTK_SOURCE_TYPE_MTP;
		sourceParam.tnr_param.mm_param.flag = 0;
		sourceParam.cas_param.type = gCASType;
		sourceParam.cas_param.tsid_sidx = 100;
		sourceParam.isSMP = RTK_DvbGetSMP(0);
	}
	else
	{
		sourceParam.TunerID = 0;
		sourceParam.type = RTK_SOURCE_TYPE_TP;
		sourceParam.cas_param.type = gCASType;
		sourceParam.cas_param.tsid_sidx = 100;
		sourceParam.isSMP = RTK_DvbGetSMP(0);
		RTK_Tuner_Init();
		if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, config.input.tuner))
		{
			printf("RTK_Tuner_Scan failed!!");
			return ;
		}

	}
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);

	printf("\n Do you want to encrypt the record file?(y/n):");
	bool bEncryptFlag = false;
	while( (ch = getchar()) != '\n' && ch != EOF );
	while((ch = getchar())!='\n'){
		if(ch == 'Y'||ch =='y'){
			bEncryptFlag = true;
			while( (ch = getchar()) != '\n' && ch != EOF );
			if(!sourceParam.isSMP){
				printf("\nPlease Input record key(No more than 8 characters,NULL no key):\n");
				char recordKey[16]={0};
				scanf("%[^\n]", recordKey);
				RTK_Source_SetRecKey(source,recordKey,strlen(recordKey));
			}
			break;
		}
	}

	//Player start.
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;
	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);


	if(RTK_Player_DVRStart(gPlayer_1)!=RTK_OK)
	{
		printf("DVR start failed\n");
		fclose(file);
		fclose(pvr_ts_fp_player);
		fclose(pvr_pts_fp_player);
		fclose(pvr_frame_fp_player);
		fclose(pvr_pcr_fp_player);
		fclose(pvr_tag_fp_player);
	}

	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	if(bEncryptFlag){
		videoTSFilter.encrypt = RTK_TRUE;
	}
	else
		videoTSFilter.encrypt = RTK_FALSE;
	
	videoTSFilter.pid = config.video.pid;

	if(RTK_Player_AddTSFilter(gPlayer_1, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	
	if(bEncryptFlag)
		audioTSFilter.encrypt = RTK_TRUE;
	else
		audioTSFilter.encrypt = RTK_FALSE;
	
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;

	if(RTK_Player_AddTSFilter(gPlayer_1, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}

#if 0
	RTK_TSFilter PMTTSFilterHandle;
	RTK_TSFilterPattern PMTTSFilter;
	PMTTSFilter.encrypt = RTK_FALSE;
	PMTTSFilter.isAnchor = RTK_FALSE;
	PMTTSFilter.pid = 0x20;
	PMTTSFilter.codec = RTK_CODEC_NONE;
	PMTTSFilter.isTag = RTK_TRUE; // for connect PVR
	if(RTK_Player_AddTSFilter(gPlayer_1, &PMTTSFilter, &PMTTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", PMTTSFilter.pid);
	}
#endif	

	if(isRecordFromFile)
	{
		while(1)
		{
			//get dma buffer.
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);

			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");

						RTK_Source_DiscardInputBuffer(source, &buffer);

						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  

						RTK_Source_DiscardInputBuffer(source, &buffer);

						usleep(6*1000);
						continue;
					} 

					err = RTK_Source_FeedInputBuffer(source, &buffer);


					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");

						RTK_Source_DiscardInputBuffer(source, &buffer);

						goto ON_ERROR;
					}
	                              usleep(500);
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
                                     	usleep(10*1000);
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}
		
		}
	}
	else
	{
		int i=0;
		for(i=WAIT_TIME_SECOND + 560;  i > 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}	

ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	if(isRecordFromFile)
	{
		for(int i = 0; i < 3; ++i)
		{
			sleep(1);
			printf("waiting until eos\n");
			if(player_status_1.eof_reached)
			{
				printf("eof_reached\n");
				break;
			}
		}
	}
ON_ERROR:

	//Stop and Destroy DVR.
	RTK_Player_DVRStop(gPlayer_1);
	fclose(pvr_ts_fp_player);
	fclose(pvr_pts_fp_player);
	fclose(pvr_frame_fp_player);
	fclose(pvr_pcr_fp_player);
	fclose(pvr_tag_fp_player);

	if(isRecordFromFile)
		fclose(file);

	//remove audio TSFilter
	if(RTK_Player_RemoveTSFilter(gPlayer_1, audioTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) audioTSFilterHandle);

	//remove video TSFilter
	if(RTK_Player_RemoveTSFilter(gPlayer_1, videoTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) videoTSFilterHandle);


	// you can also call RTK_Player_RemoveAllTSFilters   remove all ts filters
/*	
	if(RTK_Player_RemoveAllTSFilters(gPlayer_1) != RTK_OK)
		printf("Failed to remove all TS filter\n");
*/

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	RTK_DestorySurface(RTK_WIN_MAIN);

	printf("Test finish.\n");

	return;


}

static int xGetStringNoBlock(char* cBuf)
{
    fd_set rfds;
    struct timeval tv;
    int iLen = 0;
	char cTempBuf[256];
	
    FD_ZERO(&rfds);
    FD_SET(0, &rfds);
    tv.tv_sec = 0;
    tv.tv_usec = 1000;

    if (select(1, &rfds, NULL, NULL, &tv) > 0)
    {
        if (1 == scanf("%s", cTempBuf))
        {
			strcpy(cBuf, cTempBuf);
			cBuf[strlen(cTempBuf)] = ' ';
			iLen = strlen(cTempBuf) + 1;
			//printf("xGetStringNoBlock get input(%d)\n", iLen);
        }
    }
	
    return iLen;
}

void rtk_hal_test_Player_DVR_replay()
{
	printf("\n rtk_hal_test_Player_DVR_replay hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char cKeyInput[256]={0};
	FILE* pfTSFile = NULL;
	FILE* pfPTSFile = NULL;
	FILE* pfFrameFile = NULL;
	int iPauseNotifyCnt = 0;

#if 0
	if(RTK_TRUE != RTK_DvbGetSMP(0))
	{
		printf("SMP off cannot run the DVR replay\n\n");
		return;
	}
#endif
	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));
	
	config.callback.function	= player_callback_4;
	config.callback.user_param	= &player_status_1;

	//we use RTK_TSInputBuffer to feed data.

	config.input.type = RTK_INPUT_SOURCE;


	printf("\n Do you want to test replay clear mode(Default is encrypt mode)? (y/n):");
	
	int ch = 0;	
	
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			config.input.isEncrypt = RTK_FALSE; //DVR recorded content is not encrypt.
			printf(" test replay clear mode !\n");
		}
		else
		{
			config.input.isEncrypt = RTK_TRUE; //DVR recorded content is encrypt.
			printf(" test replay encrypt mode !\n");
		}
	}
	fflush(stdin);
	
	//Creat a surface.
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	//input file name and pids and codec.
	printf("\nPlease enter target recored ts file path and name.(like:/data/rec.ts):\n");
	scanf("%s", cKeyInput);
	pfTSFile = fopen(cKeyInput, "rb");
	if(pfTSFile == NULL)
	{
		printf("Open target recored file:%s failed!!\n\n", cKeyInput);
		return;
	}
	else
	{
		printf("Open target recored file:%s successed.\n", cKeyInput);
	}
	
	pfPTSFile = fopen(PVR_REC_PTSFILE_PATH, "rb");
	if(pfPTSFile == NULL)
	{
		printf("Open target recored file:%s failed!!\n", PVR_REC_PTSFILE_PATH);
		return;
	}
	else
	{
		printf("Open target recored file:%s successed.\n", PVR_REC_PTSFILE_PATH);
	}

	pfFrameFile = fopen(PVR_REC_FRAMEFILE_PATH, "rb");
	if(pfFrameFile == NULL)
	{
		printf("Open target recored file:%s failed!!\n", PVR_REC_FRAMEFILE_PATH);
		fclose(pfTSFile);
		fclose(pfPTSFile);
		return;
	}
	else
	{
		printf("Open target recored file:%s successed.\n", PVR_REC_FRAMEFILE_PATH);
	}

	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	uint32_t totalFileSize = 0;
	fseek(pfTSFile,0,SEEK_END);
	totalFileSize=ftell(pfTSFile);
	rewind(pfTSFile);
	printf("Recored ts file totalFileSize=%u\n",totalFileSize);
	fseek(pfTSFile,0,SEEK_SET);

	//Here we dot set PIDs in create and set PIDs by RTK_Player_ChangeVideo;
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = -1;
	config.audio.pid = -1;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(pfPTSFile);
		fclose(pfFrameFile);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = RTK_CAS_TYPE_PRIVATE_REC;
	sourceParam.cas_param.tsid_sidx = 55;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);

	printf("\n Do you want to set the decrypt key?(y/N):");
	while((ch = getchar())!='\n'){
		if(ch == 'Y'||ch =='y'){
			while( (ch = getchar()) != '\n' && ch != EOF );
			if(!sourceParam.isSMP){
				printf("\nPlease Input decrypt key(No more than 8 characters,NULL no key):\n");
				char replayKey[16]={0};
				scanf("%[^\n]", replayKey);
				RTK_Source_SetRecKey(source,replayKey,strlen(replayKey));
			}
			break;
		}
	}

	printf("\n-------------------DVR replay command-------------------\n");
	printf("Cmd: %s xxx .\n", PVR_REPLAY_SEEK_CMD);
	printf("Descr: Seek current playing video by xxx milliseconds, xxx could be negative.\n");
	printf("Example: %s 1000; %s -1000.\n", PVR_REPLAY_SEEK_CMD, PVR_REPLAY_SEEK_CMD);
	printf("Cmd: %s xxx .\n", PVR_REPLAY_TRICK_CMD);
	printf("Descr: Set play speed, xxx could be negative.\n");
	printf("Example: %s 2.0; %s -2.0 .\n", PVR_REPLAY_TRICK_CMD, PVR_REPLAY_TRICK_CMD);
	printf("Cmd: %s; %s .\n", PVR_REPLAY_PAUSE_CMD, PVR_REPLAY_RESUME_CMD);
	printf("Descr: Set current playing pause or resume.\n");
	printf("Example: %s; %s .\n", PVR_REPLAY_PAUSE_CMD, PVR_REPLAY_RESUME_CMD);
	printf("--------------------------------------------------------\n");
	//Player start.
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused=RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	int32_t iSeekTimeMs = 0;
	float fPlaySpeed = 0.0;
	struct timeval tTimeTrickLast;
	struct timeval tTimeNow;
	int iLenLast = 0;
	int iLen = 0;
	
	tTimeTrickLast.tv_sec = 0;
	tTimeTrickLast.tv_usec = 0;
	tTimeNow.tv_sec = 0;
	tTimeNow.tv_usec = 0;
	uint64_t ulPtsCurr = 0;
	bool bFastTickStart = false;
	bool bPauseState = false;
	
	fflush(stdin);
	while(1)
	{
		iLen += xGetStringNoBlock(cKeyInput + iLen);
		if (iLen > 0 && iLenLast == iLen)
		{
			cKeyInput[iLen] = 0;
			printf("get input(%d):%s\n", iLen, cKeyInput);
			if (!strncmp(cKeyInput, PVR_REPLAY_SEEK_CMD, strlen(PVR_REPLAY_SEEK_CMD)))
			{
				if (1 == sscanf(cKeyInput + strlen(PVR_REPLAY_SEEK_CMD), "%d", &iSeekTimeMs))
				{
					//RTK_Player_Pause(gPlayer_1);
					RTK_Player_GetCurrentDisplayingPTS(gPlayer_1, &ulPtsCurr);
					if (xPVR_Replay_Seek(pfTSFile, pfPTSFile, pfFrameFile, ulPtsCurr, iSeekTimeMs, RTK_SEEKWHENCE_CUR))
					{
						printf("Seek video play by %dms from current failed!!\n", iSeekTimeMs);
					}
					else
					{
						printf("Seek video play by %dms from current successed.\n", iSeekTimeMs);
						RTK_Player_DropData(gPlayer_1);
						//RTK_Player_Resume(gPlayer_1);
					}
										
				}
			}
			else if (!strncmp(cKeyInput, PVR_REPLAY_TRICK_CMD, strlen(PVR_REPLAY_TRICK_CMD)))
			{
				if (1 == sscanf(cKeyInput + strlen(PVR_REPLAY_TRICK_CMD), "%f", &fPlaySpeed))
				{					
					if((fPlaySpeed > 2.0)||(fPlaySpeed < 0.0))
					{
						//need get I frame only, set av free run
						RTK_Player_SetAVSyncMode(gPlayer_1, RTK_AVSYNC_SYSTEM_MASTER);
						RTK_Player_SetAudioMute(gPlayer_1, RTK_TRUE);
					}
					else
					{
						//set sync by audio
						RTK_Player_SetAVSyncMode(gPlayer_1, RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
						//set audio unmute
						RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
					}
					
					//fPlaySpeed = fPlaySpeed < 0.0 ? -1.0 : fPlaySpeed;
					printf("Set play speed to %.2f.\n", fPlaySpeed);
					if (fPlaySpeed >= 0.0 && fPlaySpeed <= 2.0)
					{
						if (RTK_Player_SetPlaySpeed(gPlayer_1, fPlaySpeed))
						{
							printf("Set play speed to %.2f failed!!\n", fPlaySpeed);
						}
						else
						{
							printf("Set play speed to %.2f successed.\n", fPlaySpeed);
						}
					}
					else
					{
						printf("Set play speed to %.2f successed.\n", fPlaySpeed);
					}					
				}
			}
			else if (!strncmp(cKeyInput, PVR_REPLAY_PAUSE_CMD, strlen(PVR_REPLAY_PAUSE_CMD)))
			{
				if (bPauseState == false)
				{
					RTK_Player_Pause(gPlayer_1);
					bPauseState = true;
				}
				else
				{
					printf("Already paused!!\n");
				}
			}
			else if (!strncmp(cKeyInput, PVR_REPLAY_RESUME_CMD, strlen(PVR_REPLAY_RESUME_CMD)))
			{
				if (bPauseState == true)
				{
					RTK_Player_Resume(gPlayer_1);
					bPauseState = false;
				}
				else
				{
					printf("Already playing!!\n");
				}
			}
			else
			{
				printf("Unrecognized input:%s\n", cKeyInput);
			}
			iLen = 0;
			iLenLast = 0;
			fflush(stdin);
		}
		else
		{
			iLenLast = iLen;
		}

		if (fPlaySpeed < 0.0 || fPlaySpeed > 2.0)
		{
			if (bFastTickStart == false)
			{
				RTK_Player_GetCurrentDisplayingPTS(gPlayer_1, &ulPtsCurr);				
			}
			gettimeofday(&tTimeNow, NULL);
			uint64_t ulTimePastMs = (1000 * tTimeNow.tv_sec + tTimeNow.tv_usec / 1000) - (1000 * tTimeTrickLast.tv_sec + tTimeTrickLast.tv_usec / 1000);
			if ((bFastTickStart == false || player_status_1.IFrameShowed == RTK_TRUE) && ulTimePastMs >= 400)
			{
				player_status_1.IFrameShowed = RTK_FALSE;
				bFastTickStart = true;
				memcpy(&tTimeTrickLast, &tTimeNow, sizeof(tTimeNow));
				if (xPVR_Replay_Seek(pfTSFile, pfPTSFile, pfFrameFile, ulPtsCurr, (int32_t)(ulTimePastMs * fPlaySpeed), RTK_SEEKWHENCE_CUR))
				{
					printf("Seek video play by %dms from current failed!! File may reached the end, set play speed to normal.\n", (int32_t)(ulTimePastMs * fPlaySpeed));
					RTK_Player_SetPlaySpeed(gPlayer_1, 1.0);
					fPlaySpeed = 1.0;
					//set sync by audio
					RTK_Player_SetAVSyncMode(gPlayer_1, RTK_AVSYNC_AUDIO_MASTER_AUTO_AF);
					//set audio unmute
					RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
				}
				else
				{
					RTK_Player_DropData(gPlayer_1);
				}
				ulPtsCurr += 90 * ulTimePastMs * fPlaySpeed;
			}
		}
		else
		{
			bFastTickStart = false;
			gettimeofday(&tTimeTrickLast, NULL);
		}
		
		if (bPauseState == false)
		{
			//get dma buffer.
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);

			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
				
			switch(err)
			{
				case RTK_OK:
				{
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = pfTSFile;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					input_info.cEncrypted = RTK_TRUE;
					input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");
						RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
						usleep(6*1000);
						goto ON_WAIT_EOS;
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  

						RTK_Source_DiscardInputBuffer(source, &buffer);

						usleep(6*1000);
						continue;
					} 

					err = RTK_Source_FeedInputBuffer(source, &buffer);


					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed InputBuffer failed\n");

						RTK_Source_DiscardInputBuffer(source, &buffer);

						goto ON_ERROR;
					}

				}
				break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}
		}
		else
		{
			if (iPauseNotifyCnt++ >= 200)
			{
				iPauseNotifyCnt = 0;
				printf("Playing paused!! Use cmd \"%s\" to resume.\n", PVR_REPLAY_RESUME_CMD);
			}
		}
		usleep(10*1000);
	
	}
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(pfTSFile);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	RTK_DestorySurface(RTK_WIN_MAIN);

	printf("Test finish.\n");

	return;
}




void* TrickPlayControlThread(void *)
{

	sleep(2);//wait for 2s for av play.
	float speed =0.0;


	while(1)
	{
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();
		
		printf("\n\n####################################################################\n");
		printf("Trick Play Control Input:\n");
		printf("a: x0.5\n");
		printf("b: x0.6\n");
		printf("c: x0.8\n");
		printf("d: x1\n");
		printf("e: x1.2\n");
		printf("f: x1.5\n");
		printf("g: x2\n");
		printf("h: pause\n");
		printf("i: resume\n");
		printf("####################################################################\n\n");
		int ch = getchar();
		if(ch != -1)
		{
			RTK_Player_GetPlaySpeed(gPlayer_1, &speed);
			printf("before change speed = %f\n", speed);
			if(ch == 'a')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.5);		
				RTK_Player_Resume(gPlayer_1);
			}
			else if(ch == 'b')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.6);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'c')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 0.8);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'd')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'e')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1.2);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'f')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetPlaySpeed(gPlayer_1, 1.5);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'g')
			{
				RTK_Player_Pause(gPlayer_1);
				RTK_Player_SetTrickMode(gPlayer_1,RHAL_AV_TRICK_FULLTS);
				RTK_Player_SetPlaySpeed(gPlayer_1, 2);
				RTK_Player_Resume(gPlayer_1);

			}
			else if(ch == 'h')
			{
				RTK_Player_Pause(gPlayer_1);
			}
			else if(ch == 'i')
			{
				RTK_Player_Resume(gPlayer_1);
			}
			RTK_Player_GetPlaySpeed(gPlayer_1, &speed);
			printf("after change speed = %f\n", speed);
			
		}
		
		usleep(1000);
	}

	return NULL;
}




void rtk_hal_test_Player_TrickPlay(void)
{
	printf("\n rtk_hal_test_Player_TrickPlay hello\n\n");
	
	int threadFlag = 0;
	FILE * file = NULL;
	RTK_TSInputBuffer buffer;
	RTK_PlayerConfig config;
	char file_path[256]={0};

	//gPlayer_1 = NULL;
	gThreadExit = RTK_FALSE;


	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;

	config.input.type			= RTK_INPUT_SOURCE;

	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;

	//create surface
	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);	
	
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}

		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);	
		config.audio.focused = RTK_TRUE;
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);
	 

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("failed to create player.\n");
		fclose(file);
		return;
	}

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	//player_status_1.eof_reached = RTK_FALSE;
	
	//Create a thread for section filter parsing.
	pthread_create(&RTKTrickPlayControlThread, NULL, TrickPlayControlThread, (void*)&threadFlag);

	//	feed data until end of file.
	while(1)
	{
		PLAYER_LOCK();
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);

		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");

					RTK_Source_DiscardInputBuffer(source, &buffer);

					usleep(6000);
					goto ON_WAIT_EOS;
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{

					RTK_Source_DiscardInputBuffer(source, &buffer);

					usleep(6000);
					continue;
				}

				err = RTK_Source_FeedInputBuffer(source, &buffer);


				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");

					RTK_Source_DiscardInputBuffer(source, &buffer);

					goto ON_ERROR;
				}
				usleep(500);
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
		}
		PLAYER_UNLOCK();
		
	}


	

ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
		for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
	
ON_ERROR:	
	PLAYER_UNLOCK();
	if(file != NULL)
		fclose(file);

	THREAD_EXIT_LOCK();
	gThreadExit = RTK_TRUE;
	THREAD_EXIT_UNLOCK();

	printf("av stoped, press any key to exit!!\n");
	int status, rc;
	rc = pthread_join(RTKTrickPlayControlThread, (void **)&status);
	if (rc != 0)
		printf("ERROR; return code from pthread_join() is %d\n", rc);

	printf("Thread joined\n");
	RTK_Player_SetTrickMode(gPlayer_1,RHAL_AV_TRICK_IONLY);

	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
	}


	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy.\n");
	}
	gPlayer_1 = NULL;

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);	
	
	printf("play finished\n");
	return;
}


void rtk_hal_test_Player_audioOutputMode()
{	
	printf("\n rtk_hal_test_Player_audioOutputMode enter\n\n");
	printf("\n you need play mediabrowser file first!\n\n");
	int ch = 0;
	printf("\n Do you want to test spdif output mode?(Y/n):");
	bool isTestSpdif = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestSpdif = RTK_TRUE;
			printf(" Test Spdif output mdoe!\n");
		}
		else
		{
			isTestSpdif = RTK_FALSE;
			printf(" Not Test Spdif output mdoe !\n");
		}
		fflush(stdin);

		if(isTestSpdif == RTK_TRUE)
		{
			printf("\nchoose spdif output mode: \n");
			list_item spdif_output_mode_list[] = 
			{		 
				{"SPDIF_OFF",	 HAL_SPDIF_OFF },
				{"SPDIF_RAW",	 HAL_SPDIF_RAW },
				{"SPDIF_LPCM",	HAL_SPDIF_LPCM },		
			};

			Hal_Spdif_Mode_e output_mode = (Hal_Spdif_Mode_e)show_list("spdif output mode List", spdif_output_mode_list, list_item_cnt(spdif_output_mode_list));
			RTK_Set_Spdif_Output_Mode(output_mode);
			usleep(100*1000);
			Hal_Spdif_Mode_e get_output_mode = HAL_SPDIF_OFF;
			RTK_Get_Spdif_Output_Mode(&get_output_mode);
			printf("get spdif output mode is %d\n",get_output_mode);
		}
	}
	
	printf("\n Do you want to test hdmi output mode?(Y/n):");
	bool isTestHDMI = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestHDMI = RTK_TRUE;
			printf(" Test HDMI output mdoe!\n");
		}
		else
		{
			isTestHDMI = RTK_FALSE;
			printf(" Not Test HDMI output mdoe !\n");
		}
		fflush(stdin);

		if(isTestHDMI == RTK_TRUE)
		{
			printf("\nchoose HDMI output mode: \n");
			list_item hdmi_output_mode_list[] = 
			{		 
				{"HDMI_RAW",	 HAL_HDMI_RAW },
				{"HDMI_LPCM",	 HAL_HDMI_LPCM },
				{"HDMI_LPCM_MULTI_CH",	HAL_HDMI_LPCM_MULTI_CH },
				{"HDMI_AUTO",	 HAL_HDMI_AUTO },	
			};

			Hal_Hdmi_Mode_e output_mode = (Hal_Hdmi_Mode_e)show_list("hdmi output mode List", hdmi_output_mode_list, list_item_cnt(hdmi_output_mode_list));
			RTK_Set_Hdmi_Output_Mode(output_mode);
			usleep(100*1000);
			Hal_Hdmi_Mode_e get_output_mode = HAL_HDMI_RAW;
			RTK_Get_Hdmi_Output_Mode(&get_output_mode);
			printf("get hdmi output mode is %d\n",get_output_mode);
		}
	}
	printf("\n Do you want to test SetAudioOutputMode?(Y/n):");
	bool isTestAudioOutputMode = RTK_TRUE; 
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestAudioOutputMode = RTK_TRUE;
			printf(" Test SetAudioOutputMode!\n");
		}
		else
		{
			isTestAudioOutputMode = RTK_FALSE;
			printf(" Not Test SetAudioOutputMode !\n");
		}
		fflush(stdin);

		if(isTestAudioOutputMode == RTK_TRUE)
		{
			printf("\nchoose audio output mode: \n");
			list_item audio_output_mode_list[] = 
			{		 
				{"AUDIO_STEREO",	 HAL_AUDIO_STEREO },
				{"AUDIO_MAIN_BILINGUAL",	 HAL_AUDIO_MAIN_BILINGUAL },
				{"AUDIO_SUB_BILINGUAL",	HAL_AUDIO_SUB_BILINGUAL },
				{"AUDIO_FLASH_STEREO",	 HAL_AUDIO_FLASH_STEREO },
				{"AUDIO_FLASH_MAIN_BILINGUAL",	 HAL_AUDIO_FLASH_MAIN_BILINGUAL },
				{"AUDIO_FLASH_SUB_BILINGUAL",	 HAL_AUDIO_FLASH_SUB_BILINGUAL },
			};

			Hal_Audio_Output_Mode_e output_mode = (Hal_Audio_Output_Mode_e)show_list("audio output mode List", audio_output_mode_list, list_item_cnt(audio_output_mode_list));
			RTK_SetAudioOutputMode(output_mode);
		}
	}
	usleep(100*1000);
	printf("Test finish.\n");

	return;

}

/***************************************************************
* FCC Test.
****************************************************************/
#define FCC_CHLIST_FILE_PATH	"/data/vendor/multich_list.txt"
#define FCC_CHLIST_FILE_PATH_2	"/data/vendor/mediadrm/multich_list.txt"
#define halTestPrintf(fmt, args...)	printf(fmt, ##args)	

typedef struct
{
	int  freq;
	int   videopid;
	RTK_Codec   videocodec;
	int   audiopid;
	RTK_Codec   audiocodec;
	int    qam;
	int    lnbmode;
	int    symbolrate;
    RTK_Tuner_Bandwidth    bandwidth;	
#ifdef ENABLE_CDCA
	uint16_t emmpid;
	uint16_t ecmpid;
#endif
}RTK_FCCHANNELLIST;

#define FCC_CHLIST_MAX_CH_COUNT (100)

static int g_fcc_test_version = 3;
RTK_Tuner_Type_e gFCC_tunerType=RTK_TUNER_TYPE_DVBC;

static int _getIRInputEventFd()
{
    char device[64] = {0};
    char name[128] = {0};
    int fd = -1;
    int i;
    for(i = 0; i < 32; i++)
    {
        sprintf(device, "/dev/input/event%d", i);
        if((fd = open(device, O_RDONLY, 0)) >= 0)
        {
            ioctl(fd, EVIOCGNAME(sizeof(name)), name);
            if(strstr(name, "IR_input"))
            {
                printf("get IR device %s, name: %s\n", device, name);
                return fd;
            }
            close(fd);
        }
    }
    return -1;
}

static int _parse_FastChangeChannellist(RTK_FCCHANNELLIST *pFCC_chlist, int *pChCount, char *url)
{
	FILE *m_FCCchannellistFile=NULL;

	char strUrl[100];
	char *pch;
	int info = 0;
	int updatelnbmodeflag = 0;
	int m_totalFCCcount=0;
	
	memset(pFCC_chlist, 0, FCC_CHLIST_MAX_CH_COUNT*sizeof(RTK_FCCHANNELLIST));

	if(((access(FCC_CHLIST_FILE_PATH, F_OK)) == -1) && ((access(FCC_CHLIST_FILE_PATH_2, F_OK)) == -1))
	{
	    printf("\nError: Fcc channel list file does not exist, please check.\n\n");
	    return -1;
	}

	if((m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH, "rb")) == NULL)
	{
	    printf("\n open %s err to open path_2\n", FCC_CHLIST_FILE_PATH);
	    if ((m_FCCchannellistFile = fopen(FCC_CHLIST_FILE_PATH_2, "rb")) == NULL)
	    {
	        printf("\n path_2 open %s err \n", FCC_CHLIST_FILE_PATH_2);
	        return -1;
	    }
	}
	
	for(int i = 0; i < FCC_CHLIST_MAX_CH_COUNT; i++)
	{
		memset(strUrl,0,100);
		updatelnbmodeflag = 0;
		if(fgets(strUrl,100,m_FCCchannellistFile)== NULL)
		{
			break;
		}

		//Do not process comments
		if(strncmp(strUrl, "#", 1) == 0)
		{
			continue;
		}

		//get url
		if(strncmp(strUrl, "tuner://", 8) == 0)
		{
			memcpy(url, strUrl, strlen(strUrl) + 1);
			printf("Update_FastChangeChannellist URL: %s\n", url);
		}

		if(strncmp(strUrl, "fq=", 3) == 0)
		{
		    bool isBWUpdate = false;
			pch = strtok(strUrl,"&");				
			while (pch != NULL)
			{
			#ifdef ENABLE_CDCA
				if(strncmp(pch, "mp=", 3) ==0)
				{
					info = atoi(pch+3);
					halTestPrintf("Update FastChangeChannel emm pid (0x%x)>>>>>>>>>>>>>> \n",info);
					pFCC_chlist[m_totalFCCcount].emmpid = info;
				}
				else if (strncmp(pch, "cp=", 3) == 0)
				{
					info = atoi(pch+3);
					halTestPrintf("Update FastChangeChannel ecm pid (0x%x)>>>>>>>>>>>>>> \n",info);
					pFCC_chlist[m_totalFCCcount].ecmpid = info;
				}
				else if(strncmp(pch, "vp=", 3) == 0)
			#else
				if(strncmp(pch, "vp=", 3) == 0)
			#endif
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist video pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videopid = info;
				}
				else if(strncmp(pch, "ap=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist audio pid: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiopid= info;
				}
				else if(strncmp(pch, "vc=", 3) == 0)
				{
					printf("Update_FastChangeChannellist video codec strings: %s\n", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG2;
					}
					else if(strncmp((pch+3), "MPEG4_PART2", strlen("MPEG4_PART2")) == 0)
					{
						info = RTK_CODEC_VIDEO_MPEG4_PART2;
					}
					else if(strncmp((pch+3), "H264", strlen("H264")) == 0)
					{
						info = RTK_CODEC_VIDEO_H264;
					}
					else if(strncmp((pch+3), "H265", strlen("H265")) == 0)
					{
						info = RTK_CODEC_VIDEO_H265;
					}
					else
					{
						info = RTK_CODEC_NONE;
					}
					printf("Update_FastChangeChannellist video codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].videocodec =(RTK_Codec) info;
				}
				else if(strncmp(pch, "ac=", 3) == 0)
				{	
					printf("Update_FastChangeChannellist audio codec strings: %s", (pch+3));

					if(strncmp((pch+3), "MPEG1", strlen("MPEG1")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG1;
					}
					else if(strncmp((pch+3), "MPEG2", strlen("MPEG2")) == 0)
					{
						info = RTK_CODEC_AUDIO_MPEG2;
					}
					else if(strncmp((pch+3), "AACPLUS", strlen("AACPLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AACPLUS;
					}
					else if(strncmp((pch+3), "AAC", strlen("AAC")) == 0)
					{
						info = RTK_CODEC_AUDIO_AAC;
					}
					else if(strncmp((pch+3), "AC3_TRUE_HD", strlen("AC3_TRUE_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_TRUE_HD;
					}
					else if(strncmp((pch+3), "AC3_PLUS", strlen("AC3_PLUS")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3_PLUS;
					}
					else if(strncmp((pch+3), "EAC3", strlen("EAC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_EAC3;
					}
					else if(strncmp((pch+3), "AC3", strlen("AC3")) == 0)
					{
						info = RTK_CODEC_AUDIO_AC3;
					}
					else if(strncmp((pch+3), "DTS_HD", strlen("DTS_HD")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS_HD;
					}
					else if(strncmp((pch+3), "DTS", strlen("DTS")) == 0)
					{
						info = RTK_CODEC_AUDIO_DTS;
					}
					else if(strncmp((pch+3), "LPCM", strlen("LPCM")) == 0)
					{
						info = RTK_CODEC_AUDIO_LPCM;
					}
					else if(strncmp((pch+3), "MP3", strlen("MP3")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP3;
					}
					else if(strncmp((pch+3), "MP4", strlen("MP4")) == 0)
					{
						info = RTK_CODEC_AUDIO_MP4;
					}				
					else
					{
						info = RTK_CODEC_NONE;
					}
					printf("Update_FastChangeChannellist audio codec: %d\n", info);
					pFCC_chlist[m_totalFCCcount].audiocodec = (RTK_Codec) info;
				}
				else if(strncmp(pch, "fq=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist freq: %d\n", info);
					pFCC_chlist[m_totalFCCcount].freq = info;
				}			
				else if(strncmp(pch, "qa=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist qam: %d\n", info);
					pFCC_chlist[m_totalFCCcount].qam= info;
				}
			   	else if(strncmp(pch, "ln=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist lnbmode: %d\n", info);
					pFCC_chlist[m_totalFCCcount].lnbmode= info;
					updatelnbmodeflag = 1;
				}
				else if(strncmp(pch, "sr=", 3) == 0)
				{
					info = atoi(pch+3);
					printf("Update_FastChangeChannellist symbolrate: %d\n", info);
					pFCC_chlist[m_totalFCCcount].symbolrate= info;
				}
                else if(strncmp(pch, "bw=", 3) == 0)
                {
                    RTK_Tuner_Bandwidth bw = RTK_TUNER_BANDWIDTH_6M;
                    printf("Update_FastChangeChannellist bandwidth strings: %s\n", (pch+3));
                
                    if(strncmp((pch+3), "8M", strlen("8M")) == 0)
                    {
                        bw = RTK_TUNER_BANDWIDTH_8M;
                        isBWUpdate = true;
                    }
                    else if(strncmp((pch+3), "7M", strlen("7M")) == 0)
                    {
                        bw = RTK_TUNER_BANDWIDTH_7M;
                        isBWUpdate = true;
                    }
                    else if(strncmp((pch+3), "6M", strlen("6M")) == 0)
                    {
                        bw = RTK_TUNER_BANDWIDTH_6M;
                        isBWUpdate = true;
                    } 
                    else 
                    {
						printf("Update_FastChangeChannellist bandwidth error\n");
						fclose(m_FCCchannellistFile);
						return -1;
                    }
                    pFCC_chlist[m_totalFCCcount].bandwidth= bw;
                }
				
				
				pch = strtok(NULL, "&");
			}
			if(updatelnbmodeflag != 1)
				pFCC_chlist[m_totalFCCcount].lnbmode = 0xff;

			if (!isBWUpdate) {
    			pFCC_chlist[m_totalFCCcount].bandwidth = RTK_TUNER_BANDWIDTH_8M;
    			printf("program %d use 8M as default bandwidth config\n",m_totalFCCcount);
			}

			m_totalFCCcount += 1;
		}
		
	}
	
	fclose(m_FCCchannellistFile);
	*pChCount=m_totalFCCcount;
	
	return 0;
}

// only filled cur / up / down
static int g_CH_index_V2[3] ={-1,-1,-1}; // channel number in source program
static RTK_Source g_source[3] ={NULL,NULL,NULL};
//static RTK_Source g_last_source = 0;

static RTK_SourceParam_t _multich_fill_V3(RTK_FCCHANNELLIST* pFCC_chlist, int index)
{
	RTK_SourceParam_t source_param;
	memset(&source_param, 0, sizeof(RTK_SourceParam_t));
	source_param.type = RTK_SOURCE_TYPE_UNKNOWN;
	source_param.bandwidth = pFCC_chlist[index].bandwidth;
	if(gFCC_tunerType == RTK_TUNER_TYPE_DVBC)
	{
		source_param.type = RTK_SOURCE_TYPE_DVBC;
		source_param.tnr_param.dvb_c_param.u32frequency = pFCC_chlist[index].freq;
		source_param.tnr_param.dvb_c_param.u32symbol_rate = pFCC_chlist[index].symbolrate;
		switch (pFCC_chlist[index].qam)
		{
			case 16:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_16QAM;
				break;
			case 32:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_32QAM;
				break;
			case 64:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_64QAM;
				break;
			case 128:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_128QAM;
				break;
			case 256:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
				break;
			default:
				source_param.tnr_param.dvb_c_param.modulation = RTK_CABLETNR_256QAM;
				break;
		}
		source_param.tnr_param.dvb_c_param.annex_type = RTK_DVBC_ANNEX_A;
	}
	else if(gFCC_tunerType == RTK_TUNER_TYPE_DVB_S || gFCC_tunerType == RTK_TUNER_TYPE_DVB_S2)
	{
		source_param.type = (gFCC_tunerType == RTK_TUNER_TYPE_DVB_S) ? RTK_SOURCE_TYPE_DVB_S : RTK_SOURCE_TYPE_DVB_S2;
		source_param.tnr_param.dvb_s_param.u32frequency = pFCC_chlist[index].freq;
		source_param.tnr_param.dvb_s_param.u32symbol_rate = pFCC_chlist[index].symbolrate;
		switch (pFCC_chlist[index].lnbmode)
		{
			case 0xff:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
			case 0:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
			case 13:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V;
				break;
			case 18:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V;
				break;
			case 1322:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_13V_WITH_22K_BURST;
				break;
			case 1822:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_18V_WITH_22K_BURST;
				break;
			default:
				source_param.tnr_param.dvb_s_param.lnbmode = RTK_LNBMODE_OFF;
				break;
		}
	}
	source_param.isSMP = RTK_DvbGetSMP(0);
#if defined(ENABLE_CDCA)
    source_param.cas_param.tsid_sidx = 0xFFFFFFFF;
    source_param.cas_param.type = RTK_CAS_TYPE_3RDPARTY_CA;
#endif
	return source_param;
}

static int _multich_UpdateSource_V3(RTK_FCCHANNELLIST* pFCC_chlist, int FCC_chcount, int channel_index)
{
	int down_index = 0;
	int up_index = 0;
	int cur_need_update = 1;
	int down_need_update = 1;
	int up_need_update = 1;

	halTestPrintf("_multich_UpdateSource_V3 enter, change to %d\n",channel_index);

	// calculate down/up index
	down_index = (channel_index + 1) % FCC_chcount;
	up_index   = (channel_index - 1 + FCC_chcount) % FCC_chcount;

	// check cur program need remove or resue
	for(int i=0;i<3;i++)
	{
		if( g_CH_index_V2[i] == channel_index && cur_need_update == 1)
		{
			cur_need_update = 0;
		}
		else if(g_CH_index_V2[i] == down_index && down_need_update == 1)
		{
			down_need_update = 0;
		}
		else if(g_CH_index_V2[i] == up_index && up_need_update == 1)
		{
			up_need_update = 0;
		}
		else
		{
			g_CH_index_V2[i] = -1;
		}
	}


	// add need update index to free program
	for(int i=0;i<3;i++)
	{
		RTK_SourceParam_t source_param;
		RTK_TunerParam_t  tunerParam;
		memset(&tunerParam, 0, sizeof(RTK_TunerParam_t));
		uint16_t pid2[PIDSMAXNUM_IN_ONE_PROGRAM];
		if(g_CH_index_V2[i] == -1 )
		{
			if(cur_need_update)
			{
#ifdef ENABLE_CDCA			
				Rtk_CDCA::getInstance()->StopDescramble(i);
#endif
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, channel_index);
				source_param.type = RTK_SOURCE_TYPE_TP;
				source_param.TunerID = i;
				tunerParam.type = gFCC_tunerType;
				tunerParam.bandwidth = source_param.bandwidth;
				memcpy(&tunerParam.tnr_param, &source_param.tnr_param, sizeof(source_param.tnr_param));
				RTK_Tuner_Init();
				if(RTK_OK != RTK_Tuner_Scan(source_param.TunerID, tunerParam))
				{
					printf("RTK_Tuner_Scan failed!!");
				}
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[channel_index].videopid;
				pid2[1] = pFCC_chlist[channel_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				cur_need_update = 0;
				g_CH_index_V2[i] = channel_index;
#ifdef ENABLE_CDCA
				if(pFCC_chlist[channel_index].emmpid != 0){
					
					RTKCA_Descramble_ECM_info_t ecm_info;
					memset(&ecm_info,0,sizeof(RTKCA_Descramble_ECM_info_t));
					ecm_info.emm_pid = pFCC_chlist[channel_index].emmpid;
					ecm_info.program_id=1;
					ecm_info.ecm_AVPids[0].ecm_pid= pFCC_chlist[channel_index].ecmpid;
					ecm_info.ecm_AVPids[0].stream_pid = pFCC_chlist[channel_index].videopid;
					ecm_info.ecm_AVPids[1].ecm_pid= pFCC_chlist[channel_index].ecmpid;
					ecm_info.ecm_AVPids[1].stream_pid = pFCC_chlist[channel_index].audiopid;
					ecm_info.source_handle = (int)g_source[i];
					Rtk_CDCA::getInstance()->Init();
					Rtk_CDCA::getInstance()->DescramblerInit(i);
					Rtk_CDCA::getInstance()->StartDescramble(i, ecm_info);
					
				}
#endif
			}
			else if(down_need_update)
			{
#ifdef ENABLE_CDCA			
				Rtk_CDCA::getInstance()->StopDescramble(i);
#endif
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, down_index);
				source_param.type = RTK_SOURCE_TYPE_TP;
				source_param.TunerID = i;
				tunerParam.type = gFCC_tunerType;
				tunerParam.bandwidth = source_param.bandwidth;
				memcpy(&tunerParam.tnr_param, &source_param.tnr_param, sizeof(source_param.tnr_param));
				RTK_Tuner_Init();
				if(RTK_OK != RTK_Tuner_Scan(source_param.TunerID, tunerParam))
				{
					printf("RTK_Tuner_Scan failed!!");
				}
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[down_index].videopid;
				pid2[1] = pFCC_chlist[down_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				down_need_update = 0;
				g_CH_index_V2[i] = down_index;
#ifdef ENABLE_CDCA				
				if(pFCC_chlist[down_index].emmpid != 0){					
					RTKCA_Descramble_ECM_info_t ecm_info;
					memset(&ecm_info,0,sizeof(RTKCA_Descramble_ECM_info_t));
					ecm_info.emm_pid = pFCC_chlist[down_index].emmpid;
					ecm_info.program_id=1;
					ecm_info.ecm_AVPids[0].ecm_pid= pFCC_chlist[down_index].ecmpid;
					ecm_info.ecm_AVPids[0].stream_pid = pFCC_chlist[down_index].videopid;
					ecm_info.ecm_AVPids[1].ecm_pid= pFCC_chlist[down_index].ecmpid;
					ecm_info.ecm_AVPids[1].stream_pid = pFCC_chlist[down_index].audiopid;
					ecm_info.source_handle = (int)g_source[i];
					Rtk_CDCA::getInstance()->Init();
					Rtk_CDCA::getInstance()->DescramblerInit(i);
					Rtk_CDCA::getInstance()->StartDescramble(i, ecm_info);
					
				}
#endif 
			}
			else
			{
#ifdef ENABLE_CDCA
				Rtk_CDCA::getInstance()->StopDescramble(i);
#endif
				RTK_Source_Destroy(g_source[i]);
				source_param = _multich_fill_V3(pFCC_chlist, up_index);
				source_param.type = RTK_SOURCE_TYPE_TP;
				source_param.TunerID = i;
				tunerParam.type = gFCC_tunerType;
				tunerParam.bandwidth = source_param.bandwidth;
				memcpy(&tunerParam.tnr_param, &source_param.tnr_param, sizeof(source_param.tnr_param));
				RTK_Tuner_Init();
				if(RTK_OK != RTK_Tuner_Scan(source_param.TunerID, tunerParam))
				{
					printf("RTK_Tuner_Scan failed!!");
				}
				RTK_Source_Create(&g_source[i], source_param);
				pid2[0] = pFCC_chlist[up_index].videopid;
				pid2[1] = pFCC_chlist[up_index].audiopid;
				RTK_Source_PresetPidFilter(g_source[i], pid2, 2);
				up_need_update = 0;
				g_CH_index_V2[i] = up_index;
#ifdef ENABLE_CDCA				
				if(pFCC_chlist[up_index].emmpid != 0){					
					RTKCA_Descramble_ECM_info_t ecm_info;
					memset(&ecm_info,0,sizeof(RTKCA_Descramble_ECM_info_t));
					ecm_info.emm_pid = pFCC_chlist[up_index].emmpid;
					ecm_info.program_id=1;
					ecm_info.ecm_AVPids[0].ecm_pid= pFCC_chlist[up_index].ecmpid;
					ecm_info.ecm_AVPids[0].stream_pid = pFCC_chlist[up_index].videopid;
					ecm_info.ecm_AVPids[1].ecm_pid= pFCC_chlist[up_index].ecmpid;
					ecm_info.ecm_AVPids[1].stream_pid = pFCC_chlist[up_index].audiopid;
					ecm_info.source_handle = (int)g_source[i];
					Rtk_CDCA::getInstance()->Init();
					Rtk_CDCA::getInstance()->DescramblerInit(i);
					Rtk_CDCA::getInstance()->StartDescramble(i, ecm_info);
					
				}
#endif
			}
		}
	}

	for(int i=0;i<3;i++)
	{
		halTestPrintf("after _multich_UpdateSource_V3 program[%d] is channel %d\n", i ,g_CH_index_V2[i] );
	}
	return 0;
}


static int _multich_firstPlay(RTK_FCCHANNELLIST *pFCC_chlist, int FCC_chcount, int channel_index)
{
	RTK_VideoConfig video;
	RTK_AudioConfig audio;
//	int program_num = 0;

	g_CH_index_V2[0] = -1;
	g_CH_index_V2[1] = -1;
	g_CH_index_V2[2] = -1;
	g_source[0] = 0;
	g_source[1] = 0;
	g_source[2] = 0;

	if(g_fcc_test_version == 3)
	{
		RTK_Source cur_source = 0;
		_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
		for(int i=0;i<3;i++)
		{
			if( g_CH_index_V2[i] == channel_index)
			{
				cur_source = g_source[i];
				break;
			}
		}
		RTK_Player_SetSource(gPlayer_1, cur_source);
		video.pid=pFCC_chlist[channel_index].videopid;
		video.codec=pFCC_chlist[channel_index].videocodec;
		audio.pid=pFCC_chlist[channel_index].audiopid;
		audio.codec=pFCC_chlist[channel_index].audiocodec;
		audio.focused=RTK_TRUE;
		RTK_Player_ChangeVideo(gPlayer_1, &video);
		RTK_Player_ChangeAudio(gPlayer_1, &audio);
		RTK_Player_Start(gPlayer_1);
		return 0;
	}

	video.pid=pFCC_chlist[channel_index].videopid;
	video.codec=pFCC_chlist[channel_index].videocodec;
	audio.pid=pFCC_chlist[channel_index].audiopid;
	audio.codec=pFCC_chlist[channel_index].audiocodec;
	audio.focused=RTK_TRUE;

	RTK_Player_ChangeVideo(gPlayer_1, &video);
	RTK_Player_ChangeAudio(gPlayer_1, &audio);
	RTK_Player_Start(gPlayer_1);

	return 0;
}

static int _multich_ChangeCh(RTK_FCCHANNELLIST *pFCC_chlist, int FCC_chcount, int channel_index,int pre)
{
	RTK_VideoConfig video;
	RTK_AudioConfig audio;
	int program_num = -1;
	int update_program = 1;
	RTK_Player_Pause(gPlayer_1);
	RTK_Source cur_source = 0;
	UNUSED(pre);
	if(g_fcc_test_version == 3)
	{

__SEARCH_PROG_V3:

		for(int i=0;i<3;i++)
		{
			if( g_CH_index_V2[i] == channel_index)
			{
				program_num = i;
				cur_source = g_source[i];
				break;
			}
		}

		if(program_num == -1)
		{
			halTestPrintf("new current channel is not in list, update program first \n");
			_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
			update_program = 0; // no need update program after change channel
			goto __SEARCH_PROG_V3;
		}
		else
		{
			halTestPrintf("new current channel is in list, change play program first \n");
		}

		RTK_Player_SetSource(gPlayer_1, cur_source);
		video.pid=pFCC_chlist[channel_index].videopid;
		video.codec=pFCC_chlist[channel_index].videocodec;
		audio.pid=pFCC_chlist[channel_index].audiopid;
		audio.codec=pFCC_chlist[channel_index].audiocodec;
		audio.focused=RTK_TRUE;
		RTK_Player_ChangeChannel(gPlayer_1, &video, &audio);
		if(update_program == 1)
		{
			_multich_UpdateSource_V3(pFCC_chlist , FCC_chcount, channel_index);
		}

	}	
	return 0;
}

void rtk_hal_test_FCC(void)
{
	int irfd=-1;
	struct pollfd fds[2];
	int preChannelindex;
	char buf[128];
	int ret=0;
	const char upKey[8]={0x01, 0x00, 0x67, 0x00, 0x01, 0x00, 0x00, 0x00};
	const char downKey[8]={0x01, 0x00, 0x6c, 0x00, 0x01, 0x00, 0x00, 0x00};
	const char startKey[8]={0x01, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x00};
	const char stopKey[8]={0x01, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00};
	
	int isFirstPlay=1;
	int curChannelIndex=0;
	int MaxChannelNum = 0; //shpule be parse from file.
	int FCC_total_ChCount=0;
	int exitFlag=0;
	RTK_PlayerConfig config;

	char chlist_url[128];
	memset(chlist_url, 0x00, 128);

	RTK_FCCHANNELLIST* pFCC_chlist=(RTK_FCCHANNELLIST *)malloc(FCC_CHLIST_MAX_CH_COUNT*sizeof(RTK_FCCHANNELLIST));
	if(pFCC_chlist==NULL)
	{
		printf("pFCC_chlist malloc failed\n");
		return;
	}
	//RTK_DvbSetSMP(0,RTK_TRUE);
	//RTK_DvbSetSMP(1,RTK_TRUE);
	
	if(_parse_FastChangeChannellist(pFCC_chlist, &FCC_total_ChCount, chlist_url) != 0)
	{
		printf("parse " FCC_CHLIST_FILE_PATH " failed\n");
		return;
	}

	printf("\nFCC_total_ChCount	=== %d \n",FCC_total_ChCount);


	if(strncmp(chlist_url, "tuner://DVBC:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVBC;		
	}
	else if(strncmp(chlist_url, "tuner://DVBS:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_S;
	}
	else if(strncmp(chlist_url, "tuner://DVBS2:", 14) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_S2;
	}
	else if(strncmp(chlist_url, "tuner://DTMB:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DTMB;
	}
	else if(strncmp(chlist_url, "tuner://DVBT:", 13) == 0)
	{
		gFCC_tunerType = RTK_TUNER_TYPE_DVB_T ;
	}
	else
	{
		printf("Input Tuner parameter error, force DVBC!");
		gFCC_tunerType = RTK_TUNER_TYPE_DVBC;	
	}

	
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

    RTK_Tuner_Init();

	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;

	config.input.type = RTK_INPUT_SOURCE;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return ;
	}

	irfd=_getIRInputEventFd();
	if(irfd==-1)
	{
		free(pFCC_chlist);
		halTestPrintf("open IR input failed\n");
		return ;
	}
	halTestPrintf("open IR input OK\n");

	unsigned int uiPrintCnt = 0;
	RTK_TunerInfo tTunerInfo;
	
	fds[0].fd=irfd;
	fds[0].events=POLLIN;

	while(irfd!=-1)
	{
		if(!isFirstPlay)
		{
			uiPrintCnt++;
			if (uiPrintCnt > 5)
			{
				uiPrintCnt = 0;
				if(g_fcc_test_version == 3)
				{
					RTK_Source SourceCurrent = 0;
					int indexTunerID=0;
					for(int i = 0; i < 3; i++)
					{
						if( g_CH_index_V2[i] == curChannelIndex)
						{
							SourceCurrent = g_source[i];
							indexTunerID=i;
							printf("current source:[%p] \r\n", g_source[i]);
							break;
						}
					}
				
					if (RTK_OK == RTK_Tuner_GetInfo(indexTunerID, &tTunerInfo))
					{
						printf("tTunerInfo :\r\n");
						printf("locked     :%s\r\n", (tTunerInfo.locked == RTK_FALSE ? "false" : "true"));
						printf("strength   :%u\r\n", tTunerInfo.strength);
						printf("quality    :%u\r\n", tTunerInfo.quality);
						printf("snr        :%0.2f\r\n", tTunerInfo.snr);
						printf("ber        :%e\r\n", tTunerInfo.ber);
						if(tTunerInfo.powerLevel <100)
							printf("powerLevel :%d\r\n", tTunerInfo.powerLevel);
						else
							printf("powerLevel :%d.%d dBuV\r\n", tTunerInfo.powerLevel/10, tTunerInfo.powerLevel%10);
					}
					else
					{
						printf("RTK_Tuner_GetInfo fail!!\r\n");
					}
				}
			}
		}
		
		fds[0].events=POLLIN;
		memset(buf, 0x00, 128);
		if (poll(fds, 1, 300) <= 0)
		{
			//printf("poll error\n");
			continue;
		}

		if (fds[0].revents)
		{
			ret=read(fds[0].fd, buf, 128);
			if(ret>0)
			{
				#if 0
				int i=0;
				printf("read event is:\n");
				for(i=0; i<ret; i++)
				{
					if(i%16==0) printf("\n");
					printf("%02x ", buf[i]);
				}
				printf("\n");
				#endif

				if(memcmp(&buf[8], startKey, 8)==0)
				{
					halTestPrintf("start key\n");
							
					if(isFirstPlay)
					{
						
						curChannelIndex=0;
						halTestPrintf("playing CH %d\n", curChannelIndex);
						_multich_firstPlay(pFCC_chlist, FCC_total_ChCount, curChannelIndex);
						MaxChannelNum=FCC_total_ChCount -1;
						isFirstPlay=0;
					}
					else
						halTestPrintf("already start!!!\n");
					
				}
				else if(memcmp(&buf[8], stopKey, 8)==0)
				{
					if(!isFirstPlay)
					{
						halTestPrintf("stop key\n");
						if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
						{
							printf("Failed to stop player.\n");
						}
						if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
						{
							printf("Failed to destroy player.\n");
						}
						if(g_fcc_test_version == 3)
						{
						#ifdef ENABLE_CDCA
							for(int i=0;i<3;i++)
							{	
								Rtk_CDCA::getInstance()->StopDescramble(i);
								Rtk_CDCA::getInstance()->DescramblerUninit(i); 
							}
						#endif
							RTK_Source_Destroy(g_source[0]);
							RTK_Source_Destroy(g_source[1]);
							RTK_Source_Destroy(g_source[2]);
							g_source[0] = 0;
							g_source[1] = 0;
							g_source[2] = 0;
						}
						gPlayer_1 = NULL;
						RTK_DestorySurface(RTK_WIN_MAIN);
						
						isFirstPlay=1;
						exitFlag=1;
					}
				}
				else if(memcmp(&buf[8], upKey, 8)==0)
				{	
					halTestPrintf("up key\n");
					if(FCC_total_ChCount > 1)
					{
						preChannelindex = curChannelIndex;
						if(!isFirstPlay)
						{
							curChannelIndex = (curChannelIndex -1 + FCC_total_ChCount) % FCC_total_ChCount;
							halTestPrintf("playing CH %d\n", curChannelIndex);
							_multich_ChangeCh(pFCC_chlist, FCC_total_ChCount, curChannelIndex,preChannelindex);
						}
						else
						{
							halTestPrintf("please start first!!\n");
						}
					}
					
					
				}
				else if(memcmp(&buf[8], downKey, 8)==0)
				{
					halTestPrintf("down key\n");
					if(FCC_total_ChCount > 1)
					{
						preChannelindex = curChannelIndex;
						if(!isFirstPlay)
						{
							curChannelIndex = (curChannelIndex + 1) % FCC_total_ChCount;
							halTestPrintf("playing CH %d\n", curChannelIndex);
							_multich_ChangeCh(pFCC_chlist, FCC_total_ChCount, curChannelIndex,preChannelindex);
						}
						else
						{
							halTestPrintf("please start first!!\n");
						}
					}
					
				}
				else
				{
					halTestPrintf("cucc what key %02x %02x %02x %02x %02x %02x %02x %02x\n", buf[8], buf[9], buf[10], buf[11], buf[12], buf[13], buf[14], buf[15]);
				}
				
			}
			fds[0].revents=0;
		}

		if(exitFlag==1)
		{
			halTestPrintf("Exit test!!!\n");
			break;
		}	
	}
	close(irfd);
	free(pFCC_chlist);

	return;

}

void rtk_hal_test_FCC_V3(void)
{
	g_fcc_test_version =3;
	rtk_hal_test_FCC();

}

void rtk_hal_test_Player_Timeshift()
{
	printf("\n rtk_hal_test_Player_Timeshift hello\n\n");
	gDemuxDataSize = 0;
	gPlayerFilePoint = 0;
	RTK_PlayerConfig config;
	RTK_Bool is_play_once = RTK_TRUE;
	RTK_Demux demux = NULL;   
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	int isRecordFromFile=0;
	uint32_t totalFileSize = 0;
	memset(&config, 0, sizeof(config));
	memset(&buffer, 0, sizeof(buffer));

// setting config 
	config.callback.function = player_callback_4;	
	config.callback.user_param	= &player_status_1;


	config.input.type = RTK_INPUT_SOURCE;

	rtkmid_input_Tuner_Param(&config.input.tuner);
	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	config.audio.focused = RTK_TRUE;

// open timeshift file
	pvr_ts_fp_player = fopen(timeshift_path, "wb+");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open timeshift file: %s\n\n", timeshift_path);
		return;
	}
	else
	{
		printf("success to open timeshift file\n\n");
	}


// start a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX_ONLY) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		fclose(pvr_ts_fp_player);
		return;
	}


	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));

	sourceParam.TunerID = 0;
	sourceParam.type = RTK_SOURCE_TYPE_TP;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, config.input.tuner))
       {
       	printf("RTK_Tuner_Scan failed!!");
		fclose(pvr_ts_fp_player);
		return ;
	}
	
	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);

	if(RTK_Player_DVRStart(gPlayer_1)!=RTK_OK)
	{
		printf("DVR create failed\n");
		if(isRecordFromFile)
		{
			fclose(file);
		}
		fclose(pvr_ts_fp_player);
		return;
	}	

        
	#if 0
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	#endif
	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = config.video.codec;
	videoTSFilter.encrypt = RTK_TRUE;
	videoTSFilter.pid = config.video.pid;
	if(RTK_Player_AddTSFilter(gPlayer_1, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_TRUE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = config.audio.pid;
	audioTSFilter.codec = config.audio.codec;
	if(RTK_Player_AddTSFilter(gPlayer_1, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}
	gFirstReceiveTSData = RTK_FALSE;

	pthread_t timeshitfThread;

	gTimeshiftStop = RTK_FALSE;
	gTimeshiftPause = RTK_FALSE;
	pthread_create(&timeshitfThread, NULL, playTimeshiftThread,(void*)&config);
	sleep(1);
	while(1)
	{
		usleep(2*1000);
		int ret =-1;
		printf("\n");
		printf("Timeshift Control Input:\n");
		printf("a: pause\n");
		printf("b: resume\n");
		printf("c: exit timeshitf\n");
		printf("d: exit test\n");
		printf("\n");
		
		unsigned char ch = (unsigned char)getchar();
		switch(ch)
		{
			case 'a':
				if(gTimeshiftPause == RTK_FALSE)
				{
					ret = RTK_Player_Pause(gPlayer_2);
					if(ret != RTK_OK)
					{
						printf("Failed to pause av.\n");
					}
					gTimeshiftPause = RTK_TRUE;
				}
				break;
			case 'b':
				if(gTimeshiftPause == RTK_TRUE)
				{
					ret = RTK_Player_Resume(gPlayer_2);
					if(ret != RTK_OK)
					{
						printf("Failed to resume av.\n");
					}
					gTimeshiftPause = RTK_FALSE;
				}
				break;
			case 'c':
                            gPlayerResumeJustNow = RTK_TRUE;
				break;
			case 'd':
				goto ON_EXIT;
			default:
				break;
		}
		
	}

	
	
ON_EXIT:	
	int rc,status;
	gTimeshiftStop = RTK_TRUE;
	rc = pthread_join(timeshitfThread, (void **)&status);
	if (rc != 0)		
	{
		printf("ERROR; return code from playTimeshiftThread pthread_join() is %d\n", rc);
	}
	RTK_Player_DVRStop(gPlayer_1);

	if(pvr_ts_fp_player != NULL)
	{
		int fd = 0;
		fflush(pvr_ts_fp_player);
		fd = fileno(pvr_ts_fp_player); 
		fsync(fd); 
		fclose(pvr_ts_fp_player);
		pvr_ts_fp_player = NULL;
	}

	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);


	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;

	RTK_DestorySurface(RTK_WIN_MAIN);
	return;
}

static pthread_t RTKIPTVMultiViewThread;
UDPReceiver* pUdpReceiver_1 = NULL;
TCPReceiver* pTcpReceiver_1 = NULL;
UDPReceiver* pUdpReceiver_2 = NULL;
TCPReceiver* pTcpReceiver_2 = NULL;
UDPReceiver* pUdpReceiver_3 = NULL;
TCPReceiver* pTcpReceiver_3 = NULL;
RTK_SOCKET_t rtk_socket_1;
RTK_SOCKET_t rtk_socket_2;
RTK_SOCKET_t rtk_socket_3;
bool isTestClosePIP = RTK_FALSE;
void* IPTVMultiViewThread( void *) 
{	
	long count = 0;
	THREAD_EXIT_LOCK_2();
	gThreadExit_2 = RTK_FALSE;
	THREAD_EXIT_UNLOCK_2();
	
	INT8_T socketRet = RTK_ERR;
	RTK_TSInputBuffer buffer_2;
	
	
	if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
	{
		pUdpReceiver_2 = new UDPReceiver();
		if(pUdpReceiver_2 == NULL)
		{
			printf("[%s,%d]\n pUdpReceiver_2 NULL !\n", __func__, __LINE__);
			return NULL;
		}
		printf("[%s,%d]UDP2:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_2.iStrIP, rtk_socket_2.iPort);
		socketRet = pUdpReceiver_2->Open(rtk_socket_2.iPort, (const char*)rtk_socket_2.iStrIP);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pUdpReceiver_2 Open fail !\n", __func__, __LINE__);
			return NULL;
		}
	}
	else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
	{
		pTcpReceiver_2 = new TCPReceiver();
		if(pTcpReceiver_2 == NULL)
		{
			printf("[%s,%d]\n pTcpReceiver_2 NULL !\n", __func__, __LINE__);
			return NULL;
		}
		printf("[%s,%d]TCP2:%d\n", __func__, __LINE__,rtk_socket_2.iPort);
		socketRet = pTcpReceiver_2->Open(rtk_socket_2.iPort);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pTcpReceiver_2 Open fail !\n", __func__, __LINE__);
			return NULL;
		}
	}

	PLAYER_2_LOCK();
	if(RTK_Player_Create(&gPlayer_2, &Config_2, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("[%s,%d]Failed to create player.\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}
	if (gPlayer_2 == NULL)
	{
		printf("[%s,%d]Player is NULL!!\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}
	player_status_2.eof_reached = RTK_FALSE;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&gSource_2,sourceParam);
	RTK_Player_SetSource(gPlayer_2,gSource_2);
	if(RTK_Player_Start(gPlayer_2) != RTK_OK)
	{
		printf("[%s,%d]Failed to start player.\n", __func__, __LINE__);
		PLAYER_2_UNLOCK();
		return NULL;
	}	
	PLAYER_2_UNLOCK();
	
	while(1)
	{
		THREAD_EXIT_LOCK_2();
		if(gThreadExit_2 == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK_2();
			break;
		}
		THREAD_EXIT_UNLOCK_2();

		PLAYER_2_LOCK();
		if(gPlayer_2 != NULL)
		{
			//get dma buffer.
			RTK_Error err2 = RTK_Source_GetInputBuffer(gSource_2, &buffer_2);
			
			switch(err2)
			{
				case RTK_OK:
					{
						//	read ts data from network.
						if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
						{
							//buffer_2.filled_size = pUdpReceiver_2->Read((char*)buffer_2.memory, buffer_2.size);
							INPUT_SOURCE_t input_info;
							memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
							input_info.udp_receive = pUdpReceiver_2;
							input_info.video_codec_type = Config_2.video.codec;
							x_read_input_data(UDP_INPUT,input_info,&buffer_2);
						}
						else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
						{
							//buffer_2.filled_size = pTcpReceiver_2->Read((char*)buffer_2.memory, buffer_2.size);
							INPUT_SOURCE_t input_info;
							memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
							input_info.tcp_receive = pTcpReceiver_2;
							input_info.video_codec_type = Config_2.video.codec;
							x_read_input_data(TCP_INPUT,input_info,&buffer_2);

						}
						if (buffer_2.filled_size <= 0)	
						{  
							continue;  
						} 

						//request feed.
						err2 = RTK_Source_FeedInputBuffer(gSource_2, &buffer_2);
						if(err2 != RTK_OK)
						{
							//feed fail return dma buffer and goto error.
							RTK_Source_DiscardInputBuffer(gSource_2, &buffer_2);
							goto ON_ERROR;
						}
						else
						{
							//feed successful return dma buffer.
							RTK_Source_DiscardInputBuffer(gSource_2, &buffer_2);
						}
					}
					break;
			
				case RTK_BUFFER_NOT_AVAILABLE:
					{
						//no room of internal input buffer. wait some time until available.
						usleep(100*1000);	//	100ms.
					}
					break;
			
				default:
					{
						printf("UNKNOWN ERROR!!\n");
						goto ON_ERROR;
					}
					break;
			}
		}

		if(isTestClosePIP)
		{
			count ++;
			if(count == 200)
			{
				printf("[%s,%d]Close PIP NOW!!!!\n", __func__, __LINE__);
				if(RTK_Player_Stop(gPlayer_2, RTK_FALSE) != RTK_OK)
				{
					printf("[%s,%d]Failed to stop player.\n", __func__, __LINE__);
				}
				RTK_Player_SetSource(gPlayer_2, NULL);
				RTK_Source_Destroy(gSource_2);
				if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
				{
					printf("[%s,%d]Failed to destroy player.\n", __func__, __LINE__);
				}
				gPlayer_2 = NULL;
				goto ON_ERROR;
			}
		}
		
		PLAYER_2_UNLOCK();
		usleep(1000);
	}
ON_ERROR:

	return NULL;
}

//#define RTK_IPTV_TEST_INPUT_AUTO

void rtk_hal_test_Player_IPTV()
{	
	printf("\n rtk_hal_test_Player_IPTV hello\n\n");
	const bool isTestMultiView = RTK_FALSE;
	bool isTestMultiViewChangeChannel = RTK_FALSE;
	//bool isTestHdcpNotify = RTK_FALSE;
	RTK_InputType input_type = RTK_INPUT_SOURCE;
	RTK_WinPlane video_output = RTK_WIN_MAIN;
	RTK_InputType input_type_2 = RTK_INPUT_SOURCE;
	RTK_WinPlane video_output_2 = RTK_WIN_PIP;

#if 0
	int ch = 0; 
	char pvalue[PROPERTY_VALUE_MAX];
	char hdcpvalue = '1';
	bool hdcpsupport = RTK_TRUE;

	
	printf("\n Do you want to test Multiview?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMultiView = RTK_TRUE;
			printf("\n YES !\n");
		}
		else
		{
			printf("\n Not test Multiview !\n");
		}
	}
	fflush(stdin);

	printf("\n Do you want to play zapping?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMultiViewChangeChannel = RTK_TRUE;
			printf("\n YES !\n");
		}
		else
		{
			printf("\n Not test Multiview !\n");
		}
	}
	fflush(stdin);

	if(isTestMultiViewChangeChannel == RTK_TRUE)
	{
		printf("\n Do you want to play zapping in PIP mode(default MAIN mode)?(Y/n):");

		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				input_type = RTK_INPUT_MEMORY_PIP;
				video_output = RTK_WIN_PIP;
				input_type_2 = RTK_INPUT_MEMORY;
				video_output_2 = RTK_WIN_MAIN;
			}
		}
		fflush(stdin);
	}
	
	if(isTestMultiView)
	{
		printf("\n Do you want to test close PIP channel?(Y/n):");
		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				isTestClosePIP = RTK_TRUE;
				printf("\n YES !\n");
			}
			else
			{
				printf("\n Not test close PIP !\n");
			}
		}
		fflush(stdin);
	}
	
	printf("\n Do you want to test Hdcp notify?(Y/n):");
		while((ch = getchar())!='\n')
		{
			if(ch == 'Y'||ch =='y')
			{
				//isTestHdcpNotify = RTK_TRUE;
				printf("\n YES !\n");
			}
			else
			{
				printf("\n Not test close PIP !\n");
			}
		}
		fflush(stdin);
#endif
	
	///////////////////////////////////////////////////////////
	//init parameters
	///////////////////////////////////////////////////////////
	gPlayer_1 = NULL;
	gPlayer_2 = NULL;
	gPlayer_3 = NULL;
	RTK_TSInputBuffer buffer_1;
	RTK_TSInputBuffer buffer_3;
	memset(&Config_1, 0, sizeof(Config_1));
	memset(&Config_2, 0, sizeof(Config_2));
	memset(&Config_3, 0, sizeof(Config_3));
	memset(&rtk_socket_1, 0, sizeof(rtk_socket_1));
	memset(&rtk_socket_2, 0, sizeof(rtk_socket_2));
	memset(&rtk_socket_3, 0, sizeof(rtk_socket_3));
	INT8_T socketRet = RTK_ERR;
	player_status_1.eof_reached = RTK_FALSE;
	player_status_2.eof_reached = RTK_FALSE;
	player_status_3.eof_reached = RTK_FALSE;
	channel_number = 1;
	/////////////////////////////////////////////////////////////
	//multi-view:Config_1 set
	/////////////////////////////////////////////////////////////
	Config_1.callback.function				= player_callback_1;
	Config_1.callback.user_param			= &player_status_1;
	Config_1.input.type						= input_type;
	Config_1.video.codec					= CHANNEL1_VIDEO_CODEC;
	Config_1.video.pid                    	= CHANNEL1_VIDEO_PID;
	Config_1.video.encrypted             	= RTK_FALSE;
	Config_1.video.output					= video_output;
	Config_1.audio.codec                  = CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	Config_1.audio.pid                    = CHANNEL1_AUDIO_PID;
	Config_1.audio.encrypted              = RTK_FALSE;
	Config_1.audio.enable_raw_output_mode = RTK_FALSE;
	Config_1.pcr_pid						= CHANNEL1_PCR_PID;
	if(video_output == RTK_WIN_MAIN)
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
	}
	
	if(isTestMultiView)
	{
		/////////////////////////////////////////////////////////////
		//multi-view:Config_2 set
		/////////////////////////////////////////////////////////////
		Config_2.callback.function            = player_callback_2;
		Config_2.callback.user_param          = &player_status_2;
		Config_2.input.type                   = input_type_2;
		Config_2.video.codec                  = CHANNEL2_VIDEO_CODEC;
		Config_2.video.pid                    = CHANNEL2_VIDEO_CODEC;
		Config_2.video.encrypted              = RTK_FALSE;
		Config_2.video.output                 = video_output_2;
		Config_2.audio.codec                  = CHANNEL2_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
		Config_2.audio.pid                    = CHANNEL2_AUDIO_PID;
		Config_2.audio.encrypted              = RTK_FALSE;
		Config_2.audio.enable_raw_output_mode = RTK_FALSE;
		Config_2.pcr_pid                      = CHANNEL2_PCR_PID;
		if(video_output_2 == RTK_WIN_MAIN)
		{
			rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
		}
		else
		{
			rtk_test_create_winSurface(RTK_WIN_PIP, 300, 300, 1920/2, 1080/2);
		}
	}

	if(isTestMultiViewChangeChannel)
	{
		Config_3.callback.function				= player_callback_3;
		Config_3.callback.user_param			= &player_status_3;
		Config_3.input.type 					= input_type;
		Config_3.video.codec					= CHANNEL1_VIDEO_CODEC;
		Config_3.video.pid						= CHANNEL1_VIDEO_PID;
		Config_3.video.encrypted				= RTK_FALSE;
		Config_3.video.output					= video_output;
		Config_3.audio.codec				  = CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
		Config_3.audio.pid					  = CHANNEL1_AUDIO_PID;
		Config_3.audio.encrypted			  = RTK_FALSE;
		Config_3.audio.enable_raw_output_mode = RTK_FALSE;
		Config_3.pcr_pid						= CHANNEL1_PCR_PID;
	}
	
	//set socket param
#ifndef RTK_IPTV_TEST_INPUT_AUTO
	printf("\n Please Input MAIN stream info !\n");
	rtkmid_input_socket(&rtk_socket_1);
	rtkmid_input_AV_type_pid(&Config_1.video,&Config_1.audio, &Config_1.pcr_pid);
	fflush(stdin);
#else
	rtk_socket_1.e_socket_type = RTK_UDP_SOCKET;
	rtk_socket_1.iPort = 49220;
	strcpy(rtk_socket_1.iStrIP,"239.192.38.1");
	Config_1.video.pid = 52;
	Config_1.video.codec = RTK_CODEC_VIDEO_H264;
	Config_1.audio.pid = 53;
	Config_1.audio.codec = RTK_CODEC_AUDIO_AC3;
	Config_1.pcr_pid = 52;
#endif	
	Config_1.audio.focused = RTK_TRUE;
	

	if(isTestMultiView)
	{
#ifndef RTK_IPTV_TEST_INPUT_AUTO
		printf("\n Please Input PIP stream info !\n");
		//set socket param
		rtkmid_input_socket(&rtk_socket_2);
		rtkmid_input_AV_type_pid(&Config_2.video,&Config_2.audio, &Config_2.pcr_pid);
		fflush(stdin);
#else
		rtk_socket_2.e_socket_type = RTK_UDP_SOCKET;
		rtk_socket_2.iPort=49220;
		strcpy(rtk_socket_2.iStrIP, "239.192.40.26");
		Config_2.video.pid= 1215;
		Config_2.video.codec = RTK_CODEC_VIDEO_H264;
		Config_2.audio.pid = 1216;
		Config_2.audio.codec = RTK_CODEC_AUDIO_AC3;
		Config_2.pcr_pid = 1215;
#endif
	}

	if(isTestMultiViewChangeChannel)
	{
		printf("\n Please Input change channel info !\n");
		rtkmid_input_socket(&rtk_socket_3);
		rtkmid_input_AV_type_pid(&Config_3.video,&Config_3.audio, &Config_3.pcr_pid);
		fflush(stdin);
	}
	
	if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
	{
		pUdpReceiver_1 = new UDPReceiver();
		if(pUdpReceiver_1 == NULL)
		{
			printf("[%s,%d]\n pUdpReceiver_1 NULL !\n", __func__, __LINE__);
			return;
		}
		printf("[%s,%d]UDP1:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_1.iStrIP, rtk_socket_1.iPort);
		socketRet = pUdpReceiver_1->Open(rtk_socket_1.iPort, (const char*)rtk_socket_1.iStrIP);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pUdpReceiver_1 Open fail !\n", __func__, __LINE__);
			return;
		}
	}
	else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
	{
		pTcpReceiver_1 = new TCPReceiver();
		if(pTcpReceiver_1 == NULL)
		{
			printf("[%s,%d]\n pTcpReceiver_1 NULL !\n", __func__, __LINE__);
			return;
		}
		printf("[%s,%d]TCP1:%d\n", __func__, __LINE__,rtk_socket_1.iPort);
		socketRet = pTcpReceiver_1->Open(rtk_socket_1.iPort);
		if(socketRet != RTK_OK)
		{
			printf("[%s,%d]\n pTcpReceiver_1 Open fail !\n", __func__, __LINE__);
			return;
		}
	}
	if(RTK_Player_Create(&gPlayer_1, &Config_1, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("[%s,%d]Failed to create player.\n", __func__, __LINE__);
		return;
	}
	if (gPlayer_1 == NULL)
	{
		printf("[%s,%d]Player is NULL!!", __func__, __LINE__);
		return;
	}
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&gSource_1,sourceParam);
	RTK_Player_SetSource(gPlayer_1,gSource_1);
	
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("[%s,%d]Failed to start player.\n", __func__, __LINE__);
		return ;
	}

	if(isTestMultiView)
	{
		pthread_create(&RTKIPTVMultiViewThread, NULL, IPTVMultiViewThread, NULL);
	}

	if(isTestMultiViewChangeChannel)
	{
		if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
		{
			pUdpReceiver_3 = new UDPReceiver();
			if(pUdpReceiver_3 == NULL)
			{
				printf("[%s,%d]\n pUdpReceiver_3 NULL !\n", __func__, __LINE__);
				return;
			}
			printf("[%s,%d]UDP3:%s:%d\n", __func__, __LINE__, (const char*)rtk_socket_3.iStrIP, rtk_socket_3.iPort);
			socketRet = pUdpReceiver_3->Open(rtk_socket_3.iPort, (const char*)rtk_socket_3.iStrIP);
			if(socketRet != RTK_OK)
			{
				printf("[%s,%d]\n pUdpReceiver_2 Open fail !\n", __func__, __LINE__);
				return;
			}
		}
		else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
		{
			pTcpReceiver_3 = new TCPReceiver();
			if(pTcpReceiver_3 == NULL)
			{
				printf("[%s,%d]\n pTcpReceiver_3 NULL !\n", __func__, __LINE__);
				return;
			}
			printf("[%s,%d]TCP3:%d\n", __func__, __LINE__,rtk_socket_3.iPort);
			socketRet = pTcpReceiver_3->Open(rtk_socket_3.iPort);
			if(socketRet != RTK_OK)
			{
				printf("[%s,%d]\n pTcpReceiver_3 Open fail !\n", __func__, __LINE__);
				return;
			}
		}

		//Create a thread for section filter parsing.
		pthread_create(&RTKChannelChangeThread, NULL, MultiViewChannelChangeThread, NULL);
	}
	
	//	feed data until end of file.
	while(1)
	{
		//PLAYER_LOCK();
		if((gPlayer_1 != NULL) && (channel_number == 1))
		{
			//get dma buffer.
			RTK_Error err1 = RTK_Source_GetInputBuffer(gSource_1, &buffer_1);
			//printf("[%s,%d]buffer.memory=%p buffer.size=%d err=%d\n",__func__, __LINE__, buffer_1.memory, buffer_1.size, err1);
			switch(err1)
			{
				case RTK_OK:
					//	read ts data from network.
					if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
					{
						//buffer_1.filled_size = pUdpReceiver_1->Read((char*)buffer_1.memory, buffer_1.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						int read_ret = -1;
						input_info.udp_receive = pUdpReceiver_1;
						input_info.video_codec_type = Config_1.video.codec;
						read_ret = x_read_input_data(UDP_INPUT,input_info,&buffer_1);
					}
					else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
					{
						//buffer_1.filled_size = pTcpReceiver_1->Read((char*)buffer_1.memory, buffer_1.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.tcp_receive = pTcpReceiver_1;
						input_info.video_codec_type = Config_1.video.codec;
						x_read_input_data(TCP_INPUT,input_info,&buffer_1);
					}
					if (buffer_1.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						usleep(5000);	//	5ms.
						continue;  
					}  

					err1 = RTK_Source_FeedInputBuffer(gSource_1, &buffer_1);
					//printf("[%s,%d]buffer.memory=%p buffer.size=%d err=%d\n",__func__, __LINE__, buffer_1.memory, buffer_1.size, err1);

					if(err1 != RTK_OK)
					{	
						//	feed fail return dma buffer and goto error.
						RTK_Source_DiscardInputBuffer(gSource_1, &buffer_1);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Source_DiscardInputBuffer(gSource_1, &buffer_1);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
			}	
		}
		else if((gPlayer_3 != NULL) && (channel_number == 2))
		{
			//get dma buffer.
			RTK_Error err3 = RTK_Source_GetInputBuffer(gSource_3, &buffer_3);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			switch(err3)
			{
				case RTK_OK:
					//	read ts data from network.
					if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
					{
						//buffer_3.filled_size = pUdpReceiver_3->Read((char*)buffer_3.memory, buffer_3.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.udp_receive = pUdpReceiver_3;
						input_info.video_codec_type = Config_3.video.codec;
						x_read_input_data(UDP_INPUT,input_info,&buffer_3);
					}
					else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
					{
						//buffer_3.filled_size = pTcpReceiver_3->Read((char*)buffer_3.memory, buffer_3.size);
						INPUT_SOURCE_t input_info;
						memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
						//int read_ret = -1;
						input_info.tcp_receive = pTcpReceiver_3;
						input_info.video_codec_type = Config_3.video.codec;
						x_read_input_data(TCP_INPUT,input_info,&buffer_3);
					}
					if (buffer_3.filled_size <= 0)	
					{  
						usleep(5000);	//	5ms.
						continue;  
					}  

					err3 = RTK_Source_FeedInputBuffer(gSource_3, &buffer_3);

					if(err3 != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						RTK_Source_DiscardInputBuffer(gSource_3, &buffer_3);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Source_DiscardInputBuffer(gSource_3, &buffer_3);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
			}	
		}
#if 0
		if (isTestHdcpNotify == RTK_TRUE)
		{

			property_get("hdcp_support_test", pvalue, "1");
			if(pvalue[0] != hdcpvalue)
			{	
				hdcpvalue = pvalue[0];

				if(hdcpvalue == '0') // no
					hdcpsupport = RTK_FALSE;
				else if(hdcpvalue == '1')
					hdcpsupport = RTK_TRUE;
					
				rtk_porting_hdcp_support_notify(hdcpsupport);
			}

		}
#endif
		//PLAYER_UNLOCK();
		usleep(10000);	//	10ms.	
	}


	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	int status, rc;
	//release PIP resource
	if(isTestMultiView)
	{
		gThreadExit = RTK_TRUE;
		rc = pthread_join(RTKIPTVMultiViewThread, (void **)&status);
		if (rc != 0)
			printf("[%s:%d]ERROR; return code from pthread_join() is %d\n", __func__,__LINE__, rc);
	}
	if(isTestMultiViewChangeChannel)
	{
		gThreadExit_2 = RTK_TRUE;
		rc = pthread_join(RTKChannelChangeThread, (void **)&status);
		if (rc != 0)
			printf("[%s:%d]ERROR; return code from pthread_join() is %d\n", __func__,__LINE__, rc);
	}
	
	//release resource
	if(rtk_socket_1.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_1)
		{
			delete pUdpReceiver_1;
			pUdpReceiver_1 = NULL;
		}
	}
	else if(rtk_socket_1.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_1)
		{
			delete pTcpReceiver_1;
			pTcpReceiver_1 = NULL;
		}
	}
	if(rtk_socket_2.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_2)
		{
			delete pUdpReceiver_2;
			pUdpReceiver_2 = NULL;
		}
	}
	else if(rtk_socket_2.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_2)
		{
			delete pTcpReceiver_2;
			pTcpReceiver_2 = NULL;
		}
	}
	if(rtk_socket_3.e_socket_type == RTK_UDP_SOCKET)	
	{
		if(pUdpReceiver_3)
		{
			delete pUdpReceiver_3;
			pUdpReceiver_3 = NULL;
		}
	}
	else if(rtk_socket_3.e_socket_type == RTK_TCP_SOCKET)
	{
		if(pTcpReceiver_3)
		{
			delete pTcpReceiver_3;
			pTcpReceiver_3 = NULL;
		}
	}
	if(gPlayer_1)
	{
		if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		RTK_Player_SetSource(gPlayer_1, NULL);
		RTK_Source_Destroy(gSource_1);
		gSource_1 = NULL;
		if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_1 = NULL;
	}
	if(gPlayer_2)
	{
		if(RTK_Player_Stop(gPlayer_2,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		RTK_Player_SetSource(gPlayer_2, NULL);
		RTK_Source_Destroy(gSource_2);
		gSource_2 = NULL;
		if(RTK_Player_Destroy(gPlayer_2) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_1 = NULL;
	}
	if(gPlayer_3)
	{
		if(RTK_Player_Stop(gPlayer_3,RTK_FALSE) != RTK_OK)
		{
			printf("[%s:%d]Failed to stop player.\n",__func__,__LINE__);
			return;
		}
		RTK_Player_SetSource(gPlayer_3, NULL);
		RTK_Source_Destroy(gSource_3);
		gSource_3 = NULL;
		if(RTK_Player_Destroy(gPlayer_3) != RTK_OK)
		{
			printf("[%s:%d]Failed to destroy player.\n",__func__,__LINE__);
			return;
		}
		gPlayer_3 = NULL;
	}
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
	
	printf("Test finish.\n");

	return;

}

void rtk_hal_test_Player_CC()
{	
	printf("\n rtk_hal_test_Player_CC hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	fflush(stdin);
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}		
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	
	timeval cc_start,cc_end;
	int pt_Result;
	int cc_state = 0;
	
	
#if 0
	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= true;	

	int yu = 0; char  s[3];
	fflush(stdin);
       printf("Input  subtitle pid:\n");
       scanf("%d", &yu);
       tsSubtitleConfig.pid = (unsigned short)yu;
       fflush(stdin);
       printf("Input  subtitle language:\n");
       scanf("%s", s);
       printf("language is %c%c%c\n",s[0],s[1],s[2]);
       tsSubtitleConfig.langcode = ((toascii(s[0]))<<16) | (toascii(s[1])<<8) | (toascii(s[2]));
       printf("language code : %x\n",tsSubtitleConfig.langcode);
      	tsSubtitleConfig.idx = 0;
       fflush(stdin);
       printf("Input  subtitle subtype:0/1/2:\n");
       scanf("%d", &yu);
       tsSubtitleConfig.subtype = (RTKAP_SUBTITLE_TYPE_e)yu;   
#endif
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
       gettimeofday(&cc_start,NULL);
	


	INPUT_SOURCE_t input_info;
	memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
	input_info.fp = file;
	input_info.totalFileSize = totalFileSize;
	input_info.video_codec_type = config.video.codec;
	input_info.filePlay_once = RTK_TRUE;

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		 gettimeofday(&cc_end,NULL);
	
               pt_Result= cc_end.tv_sec-cc_start.tv_sec;
	      
		if(pt_Result >= 10  && pt_Result < 20 && cc_state == 0)
	        {
	        	RTK_Player_EnableCCDecoder(gPlayer_1);
			printf("\n Enable transport ccData out for 10 seconds \n");
			cc_state = 1;
	        }
		else  if(pt_Result >= 20  && pt_Result < 30 && cc_state == 1)
		{
			RTK_Player_DisableCCDecoder(gPlayer_1);
			printf("\n Disable transport ccData out for 10 seconds\n");
			cc_state = 2;
		}
		else  if(pt_Result >= 30  && pt_Result < 40 && cc_state == 2)
	        {
	        	RTK_Player_EnableCCDecoder(gPlayer_1);
			printf("\n Enable transport ccData out for 10 seconds \n");
			cc_state = 3;
	        }
		else if(pt_Result >40  && cc_state == 3)
		{
			RTK_Player_DisableCCDecoder(gPlayer_1);
			printf("\n Disable transport ccData out\n");
			cc_state = 4;
		}
	          //printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 )  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer.
					printf("feed Buffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
	
		usleep(10000);	//	10ms.	
	}


	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}
void rtk_hal_test_Player_CCPlayback()
{	
	printf("\n rtk_hal_test_Player_CCPlayback hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	fflush(stdin);
	
		printf("\nInput  stream TSfilePath:\n");
		scanf("%s", file_path);
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}		
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	
	timeval cc_start,cc_end;
	int pt_Result;
	int cc_state = 0;
	
	

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
       gettimeofday(&cc_start,NULL);

	INPUT_SOURCE_t input_info;
	memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
	input_info.fp = file;
	input_info.totalFileSize = totalFileSize;
	input_info.video_codec_type = config.video.codec;
	input_info.filePlay_once = RTK_TRUE;
       RTK_ClosedCaption_Param_t info;
	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		 gettimeofday(&cc_end,NULL);
	
               pt_Result= cc_end.tv_sec-cc_start.tv_sec;
	      
		if(pt_Result >= 5  && pt_Result < 15 && cc_state == 0)
	        {
	              RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);
			printf("RTK_Player_SetCCPlayback: true, index:0\n");			 
	        	RTK_Player_SetCCPlayback(gPlayer_1,true,0);
			printf("\n wait for 10 seconds \n");			  	
			cc_state = 1;
	        }
		else  if(pt_Result >= 15  && pt_Result < 25 && cc_state == 1)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum+3);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum+3);
			printf("\n para error ,disable show cc ,wait for 10 seconds\n");
			cc_state = 2;
		}
		else  if(pt_Result >= 25  && pt_Result < 35 && cc_state == 2)
	        {
	        	RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
	        	printf("RTK_Player_SetCCPlayback: false, index:%d\n",info.ccStreamNum-1);
	        	RTK_Player_SetCCPlayback(gPlayer_1,false,info.ccStreamNum-1);
			printf("\n kill play cc thread,wait for 10 seconds \n");			  				
			cc_state = 3;
	        }
		else if(pt_Result >= 35  && pt_Result < 45  && cc_state == 3)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum-2);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum-2);
			printf("\n create cc thread,but para error,not show cc ,wait for 10 seconds\n");
			cc_state = 4;
		}
		else if(pt_Result >=45  && cc_state == 4)
		{
			RTK_Player_GetCCInfo(gPlayer_1,&info);
		       printf("cc stream num:%d,type:%s",info.ccStreamNum,info.ccTypeString[info.ccStreamNum-1]);			   	
			printf("RTK_Player_SetCCPlayback: true, index:%d\n",info.ccStreamNum-1);
			RTK_Player_SetCCPlayback(gPlayer_1,true,info.ccStreamNum-1);
			printf("\n show cc\n");
			cc_state = 5;
		}
	          //printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 )  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer.
					printf("feed Buffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
	
		usleep(10000);	//	10ms.	
	}


	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}

//static RTK_Source source = NULL;
static RTK_SourceParam_t sourceParam;
void  *_Listen_CC_Thread(void* pParamList)
{
	unsigned char* buf = NULL;
	unsigned int length;
	FILE *wfd;
	if(!pParamList)
	{
		pthread_exit(0); /* exit */
		return NULL;
	}	
	sleep(1);	//	1s.	
	while(pParamList){
		THREAD_EXIT_LOCK();
		if(gThreadExit == RTK_TRUE)
		{
			THREAD_EXIT_UNLOCK();
			break;
		}
		THREAD_EXIT_UNLOCK();

		RTK_Bool is_idle = RTK_FALSE;
		if(RTK_OK == RTK_Source_GetIsIdle(source,&is_idle))
		{
			if(is_idle==RTK_TRUE)
			{
				printf("source is idle, maybe the test has been abnormal termination, exit cc listen thread\n");
				break;
			}
		}
		if(RTK_OK == RTK_Player_GetCCData(pParamList,&buf,&length)){
			if(length >= 8){
				printf("GetCCData    =[0x%x|0x%x|0x%x|0x%x|0x%x|0x%x|0x%x|0x%x]\n", buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);
			}
			if(length >0){
				if((wfd = fopen("/data/mycc","a+")) == NULL){
					printf("File Open Error1.\n");
				}else{
					size_t send_len = 0;
					if((send_len = fwrite(buf,1,length,wfd))== (size_t)length)
						printf("\nwrite1 unsigned char to file: success,%d\n\n",length);
					fclose(wfd);
				}
			}
		}
		usleep(4000);
	}
	pthread_exit(0); /* exit */
	return NULL;
}
void rtk_hal_test_Get_CC()
{	
	printf("\n rtk_hal_test_Get_CC hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}


	fflush(stdin);
	
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}		
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

	
	timeval cc_start,cc_end;
//	int pt_Result;
//	int cc_state = 0;
	
	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}
	
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);
	
	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	
	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);
    	gettimeofday(&cc_start,NULL);
	


	INPUT_SOURCE_t input_info;
	memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
	input_info.fp = file;
	input_info.totalFileSize = totalFileSize;
	input_info.video_codec_type = config.video.codec;
	input_info.filePlay_once = RTK_TRUE;
	gThreadExit = RTK_FALSE;

	//bStopGetCCData = false;
	pthread_t pid;
	if(0 != pthread_create(&pid, NULL,_Listen_CC_Thread,gPlayer_1))
	{
		printf("create CC thread error......\n");
		return ;
	}
	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		gettimeofday(&cc_end,NULL);
		switch(err)
		{
			case RTK_OK:				
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 )  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer.
					printf("feed Buffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
	
		usleep(10000);	//	10ms.	
	}


	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
//	bStopGetCCData = true;
	THREAD_EXIT_LOCK();
	gThreadExit = RTK_TRUE; //exit _Listen_CC_Thread
	THREAD_EXIT_UNLOCK();

	void *status;
	pthread_join(pid,&status);
	
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}
static void filePlay_withoutTP()
{	
	printf("\n filePlay_withoutTP hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);

	RTK_initialize();

	//we modify the default dvb resource(default support 2 play-withTP) config.
	//Becuase we not use TP, so we only let resConfig.player_usenum is 2.
	RTK_DvbResourceConfig_t resConfig;
	resConfig.demux_usenum=0;  
	resConfig.playerWithTP_usenum=0;
	resConfig.player_usenum=2;
	RTK_DvbResourceConfig(&resConfig);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.output 		= RTK_WIN_MAIN;
		
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

#if 1	
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
#else
    strcpy(file_path,"/data/1.ts");

	config.video.codec			= RTK_CODEC_VIDEO_MPEG2;
	config.video.pid            = 0x200;
	config.video.encrypted		= RTK_FALSE;
	
	config.audio.codec			= RTK_CODEC_AUDIO_MPEG2;
	config.audio.pid			= 0x28A;
	config.audio.focused		= RTK_TRUE;
	config.audio.encrypted		= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;

	file = fopen(file_path, "rb");
#endif
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	//HAL_TYPE_PLAYER mean we not use TP. Only you config this dvb resouce in RTK_DvbResourceConfig,
	//you can use it, otherwise you can not use it.
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_PLAYER) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
		//get dma buffer.
		RTK_Error err = RTK_Player_GetInputBuffer(gPlayer_1, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				    goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					usleep(6000);
				    continue;                                                
				} 
				err = RTK_Player_FeedInputBuffer(gPlayer_1, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		
		usleep(10000);	//	10ms.	
	}

	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}

	//RTK_finalize will release all the resource.
	RTK_finalize();
	
	printf("Test finish.\n");

	return;

}

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
static void filePlay_feedfromDMAbuffer()
{
	printf("\n filePlay_feedfromDMAbuffer hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);

	printf("########### set SMP ON ##############\n");
	RTK_DvbSetSMP(0,RTK_TRUE);
	RTK_DvbSetSMP(1,RTK_TRUE);

	//malloc dma buffer.
	int ret=0;
	unsigned char *pVirtAddr=NULL;
	unsigned int phyAddr=0;
	int feedSize=0;
	ION_DATA  ionHl;
	ION_DATA  ionHl_sec;

	
	memset(&ionHl, 0x00, sizeof(ION_DATA));
	memset(&ionHl_sec, 0x00, sizeof(ION_DATA));

	//malloc no secure memory.
	ret = rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK,
						ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

	pVirtAddr=ionHl.ion_virt;
	phyAddr=(unsigned int)ionHl.ion_phy;

	//malloc tp secure memory.
#if defined(USE_RTKHAL_IN_ANDROID10) && defined(ION_MACH_LINUX4P14)
	ret |= rtk_ion_malloc(&ionHl_sec, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK | RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
						(1<<25)/*ION_FLAG_SECURE_TPACC*/);
#else
	ret |= rtk_ion_malloc(&ionHl_sec, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK, 
						(1<<25)/*ION_FLAG_SECURE_TPACC*/);
#endif

	if (ret != 0)
	{
		printf("rtk_ion_malloc malloc memory fail!!\n");
		return;
	}
	
	//open dvdplayer ta and use md memcpy to test.
	TEEC_Result Res;
	TEEC_Context ctx;
	TEEC_Session sess;
	unsigned int uErrOrigin;
	TEEC_Operation Op;

	TEEC_SharedMemory srcTShm;
	TEEC_SharedMemory dstTShm;	

	memset(&ctx, 0x00, sizeof(TEEC_Context));
	memset(&sess, 0x00, sizeof(TEEC_Session));
	
	TEEC_UUID uuid={  0x050cda95, 0x3526, 0x4385, \
		{ 0x9c, 0x1d, 0x80, 0xb4, 0xa2, 0xb9, 0x05, 0x76} };
	
	Res = TEEC_InitializeContext(NULL, &ctx);
	if (Res != TEEC_SUCCESS)
	{
		printf("TEEC_InitializeContext failed with code 0x%x", Res);
		return;
	}

	Res = TEEC_OpenSession(&ctx, &sess, &uuid,
			       TEEC_LOGIN_PUBLIC, NULL, NULL, &uErrOrigin);
	if (Res != TEEC_SUCCESS)
	{
		printf("TEEC_Opensession failed with code 0x%x origin 0x%x",Res, uErrOrigin);
		return;	
	}

	srcTShm.flags = TEEC_MEM_INPUT | TEEC_MEM_OUTPUT;
	Res = TEEC_RegisterSharedMemoryFileDescriptor((TEEC_Context*)&ctx, &srcTShm, ionHl.mmap_fd);
	if(Res)
	{
		printf("TEEC_RegisterSharedMemoryFileDescriptor srcTShm failed\n");
		return;
	}

	dstTShm.flags = TEEC_MEM_INPUT | TEEC_MEM_OUTPUT;
	Res = TEEC_RegisterSharedMemoryFileDescriptor((TEEC_Context*)&ctx, &dstTShm, ionHl_sec.mmap_fd);
	if(Res)
	{
		printf("TEEC_RegisterSharedMemoryFileDescriptor srcTShm failed\n");
		return;
	}
	
	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	//config.input.type			= RTK_INPUT_MEMORY_MD;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.output 		= RTK_WIN_MAIN;
		
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

#if 1	
	printf("\nInput  stream TSfilePath:\n");
	scanf("%s", file_path);
	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
#else
    strcpy(file_path,"/data/1.ts");

	config.video.codec			= RTK_CODEC_VIDEO_MPEG2;
	config.video.pid            = 0x200;
	config.video.encrypted		= RTK_FALSE;
	
	config.audio.codec			= RTK_CODEC_AUDIO_MPEG2;
	config.audio.pid			= 0x28A;
	config.audio.focused		= RTK_TRUE;
	config.audio.encrypted		= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;

	file = fopen(file_path, "rb");
#endif
	
	uint32_t totalFileSize = 0;
	fseek(file,0,SEEK_END);
	totalFileSize = ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		fclose(file);
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MD;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = RTK_CAS_TYPE_NAGRA_NOCS; 
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP=RTK_TRUE;

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
		
		RTK_Player_GetTPBufferStatus(gPlayer_1, (uint32_t*)&feedSize, NULL);
		feedSize=feedSize>((200*1024)/188*188)?((200*1024)/188*188):feedSize;
		feedSize=fread(pVirtAddr, 1, feedSize, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			//flush no secure memory.
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);


			#if 1
			//copy data from no secure memory to secure memory.
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE);
			Op.params[0].value.a = (unsigned int)(ionHl_sec.ion_phy); //dst
			Op.params[1].value.a = phyAddr; //src
			Op.params[0].value.b = feedSize;
			
			Res = TEEC_InvokeCommand(&sess, 24/*TA_DTV_CMD_MD_SECUREMEM_COPY*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				return;
			}
			#else
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_MEMREF_PARTIAL_INOUT, TEEC_MEMREF_PARTIAL_INOUT, TEEC_NONE, TEEC_NONE);

			Op.params[0].memref.parent = &dstTShm;
			Op.params[0].memref.offset = 0;
			Op.params[0].memref.size = feedSize;
			
			Op.params[1].memref.parent = &srcTShm;
			Op.params[1].memref.offset = 0;
			Op.params[1].memref.size = feedSize;

			Res = TEEC_InvokeCommand(&sess, 23/*TA_DTV_CMD_TP_SECUREMEM_MOVE*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				fclose(file);
				return;
			}
			#endif
			
			#if 1
			//feed tp secure memory.
			if(RTK_Player_FeedDMABuffer(gPlayer_1, (uint32_t)(ionHl_sec.ion_phy), feedSize, 2000/*2000 ms*/, false)!=0)
			{
				printf("mtp feed failed\n");
			}
			#else
			//feed no secure memory.
			if(RTK_Player_FeedDMABuffer(gPlayer_1, (uint32_t)(ionHl.ion_phy), feedSize, 2000/*2000 ms*/, false)!=0)
			{
				printf("mtp feed failed\n");
			}
			#endif
		}
				
		usleep(10000);	//	10ms.	
	}

	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}

	TEEC_ReleaseSharedMemory(&dstTShm);
	TEEC_ReleaseSharedMemory(&srcTShm);
	
	rtk_ion_free(&ionHl);
	rtk_ion_free(&ionHl_sec);

	TEEC_CloseSession(&sess);
	TEEC_FinalizeContext(&ctx);

	printf("Test finish.\n");

	return;

}
#endif //end of ENABLE_DVB_HYBRID_WITH_SVP


static void filePlay_RawSample()
{
	printf("\n filePlay_RawSample hello\n\n");

	RTK_PlayerConfig config;
	RTK_EsInputBuf_t input;
	char folder_path[256]={0};
	char sample_path[256]={0};
	char sample_name[64]={0};
	int sample_id=1;
	int isInitSample=1;
	int totalFileSize=0;
	int read_ret;
	int isAudio=0;
	
	FILE * file=NULL;
	unsigned char *pSample_buf=NULL;
#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	char str_smp[16]={0};
#endif	
	unsigned char isSMP=0;
	unsigned int phyAddr=0;
//	long count = 0;
//	long ptsTestCount = 0;
//	RTK_Bool bvideomute;

//	UNUSED(count);
//	UNUSED(bvideomute);
	memset(&config, 0x00, sizeof(config));
	memset(&input, 0x00, sizeof(input));

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	int ret=-1;
	ION_DATA  ionHl;
	ION_DATA  ionHl_sec;

	unsigned char *pVirtAddr=NULL;

	memset(&ionHl, 0x00, sizeof(ION_DATA));
	memset(&ionHl_sec, 0x00, sizeof(ION_DATA));

	//malloc no secure memory.
	ret=rtk_ion_malloc(&ionHl, 512*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
		ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

	pVirtAddr=ionHl.ion_virt;
	phyAddr=(unsigned int)ionHl.ion_phy;


	//malloc tp secure memory.
#if defined(USE_RTKHAL_IN_ANDROID10) && defined(ION_MACH_LINUX4P14)
	ret |= rtk_ion_malloc(&ionHl_sec, 512*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK | RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
							(1<<25)/*ION_FLAG_SECURE_TPACC*/);
#else
	ret |= rtk_ion_malloc(&ionHl_sec, 512*1024, 1<<12, RTK_PHOENIX_ION_HEAP_SECURE_MASK, 
							(1<<25)/*ION_FLAG_SECURE_TPACC*/);
#endif

	if (ret != 0)
	{
		printf("rtk_ion_malloc malloc memory fail!!\n");
		return;
	}
	
	//open dvdplayer ta and use md memcpy to test.
	TEEC_Result Res;
	TEEC_Context ctx;
	TEEC_Session sess;
	unsigned int uErrOrigin;
	TEEC_Operation Op;

	TEEC_SharedMemory srcTShm;
	TEEC_SharedMemory dstTShm;	

	memset(&ctx, 0x00, sizeof(TEEC_Context));
	memset(&sess, 0x00, sizeof(TEEC_Session));
	
	TEEC_UUID uuid={  0x050cda95, 0x3526, 0x4385, \
		{ 0x9c, 0x1d, 0x80, 0xb4, 0xa2, 0xb9, 0x05, 0x76} };
	
	Res = TEEC_InitializeContext(NULL, &ctx);
	if (Res != TEEC_SUCCESS)
	{
			printf("TEEC_InitializeContext failed with code 0x%x", Res);
			return;
	}

	Res = TEEC_OpenSession(&ctx, &sess, &uuid,
			       TEEC_LOGIN_PUBLIC, NULL, NULL, &uErrOrigin);
	if (Res != TEEC_SUCCESS)
	{
		printf("TEEC_Opensession failed with code 0x%x origin 0x%x",Res, uErrOrigin);
		return;	
	}
#endif


	RTK_initialize();
	
	//we modify the default dvb resource(default support 2 play-withTP) config.
	//Becuase we need use es player resource, we set esplayer_usenum 1.
	RTK_DvbResourceConfig_t resConfig;
	resConfig.demux_usenum=0;  
	resConfig.playerWithTP_usenum=1;
	resConfig.player_usenum=0;
	resConfig.esplayer_usenum=1;
	RTK_DvbResourceConfig(&resConfig);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_MEMORY;
	config.video.output 		= RTK_WIN_MAIN;
		
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	
	
	printf("\nInput raw sample folder:\n");
	scanf("%s", folder_path);
	
#ifdef ENABLE_DVB_HYBRID_WITH_SVP

	printf("\nSMP config: on/off\n");
	scanf("%s", str_smp);
	
	if(strcmp(str_smp, "on")==0)
	{
		RTK_DvbSetSMP(0, RTK_TRUE);
		RTK_DvbSetSMP(1, RTK_TRUE);
		isSMP=1;
	}
	else 
	{
		RTK_DvbSetSMP(0, RTK_FALSE);
		RTK_DvbSetSMP(1, RTK_FALSE);
		isSMP=0;
	}
#endif

//	int videopid = config.video.pid;
//	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;

	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_ES_PLAYER) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	
	if(strstr(folder_path, "samples_a"))
		isAudio=1;

	//feed data until end of file.
	while(1)
	{
		//feed tp secure memory.
		memset(sample_path, 0x00, 256);
		strcpy(sample_path, folder_path);
		
		if(isInitSample && !isAudio)
		{
			//if(isAudio)
			//	strcat(sample_path, "/a_sample_init");
			//else
				strcat(sample_path, "/v_sample.init");
			
			isInitSample=0;
		}
		else
		{
			if(isAudio)
				sprintf(sample_name, "/a_sample.%04d", sample_id);
			else
				sprintf(sample_name, "/v_sample.%04d", sample_id);
			
			strcat(sample_path, sample_name);
			sample_id++;
		}

		printf("sample path is %s\n", sample_path);
		file=fopen(sample_path, "rb");
		if(file==NULL)
		{
			printf("open %s failed\n", sample_path);
			break;
		}
		
		fseek(file, 0, SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("sample size=%d\n",totalFileSize);

		pSample_buf=(unsigned char*)malloc(totalFileSize);
		read_ret=fread(pSample_buf, 1, totalFileSize, file);
		if(read_ret!=totalFileSize)
		{
			printf("file read fail, need read %d, but return %d\n", totalFileSize, read_ret);
		}
#ifdef ENABLE_DVB_HYBRID_WITH_SVP
		if(isSMP)
		{
			memcpy(pVirtAddr, pSample_buf, totalFileSize);
			
			//flush no secure memory.
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);

			//copy data from no secure memory to secure memory.
			memset(&Op, 0, sizeof(Op));
			Op.paramTypes = TEEC_PARAM_TYPES(TEEC_VALUE_INPUT, TEEC_VALUE_INPUT, TEEC_NONE, TEEC_NONE);
			Op.params[0].value.a = (unsigned int)(ionHl_sec.ion_phy); //dst
			Op.params[1].value.a = phyAddr; //src
			Op.params[0].value.b = totalFileSize;
			
			Res = TEEC_InvokeCommand(&sess, 24/*TA_DTV_CMD_MD_SECUREMEM_COPY*/, &Op, &uErrOrigin);
			if (Res != TEEC_SUCCESS)
			{
				printf("TEEC_InvokeCommand failed with code 0x%x origin 0x%x",
					Res, uErrOrigin);
				free(pSample_buf);
				return;
			}
		}
#endif		

		//now data is in secure buffer;

		if(isAudio)
		{
			input.codec=RTK_CODEC_AUDIO_AAC;
			input.audio_configs.sampleRate=44100;
			input.audio_configs.channelNum=2;
		}	
		else
			input.codec=RTK_CODEC_VIDEO_H264;

		if(!isSMP)
			input.pData=pSample_buf;
		else 
		{
			input.isSecureBuf=1;
			input.isDstSecureBuf =1;
			input.secPhyAddr=phyAddr;
		}
		
		input.length=totalFileSize;
		input.pts=-1;
		/*printf("sample hex dump:%02x %02x %02x %02x %02x %02x %02x %02x\n",
			pSample_buf[0], pSample_buf[1], pSample_buf[2], pSample_buf[3],
			pSample_buf[4], pSample_buf[5], pSample_buf[6], pSample_buf[7]);*/
		
		if(RTK_Player_FeedEsInputBuffer(gPlayer_1, &input, 2000/*2000 ms*/)!=0)
		{
			printf("es feed failed\n");
		}

		free(pSample_buf);
		pSample_buf=NULL;

		fclose(file);
		
		usleep(10000);	//	10ms.	
	}

	
//ON_ERROR:
	
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	RTK_DestorySurface(RTK_WIN_MAIN);

#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	rtk_ion_free(&ionHl);
	rtk_ion_free(&ionHl_sec);

	TEEC_CloseSession(&sess);
	TEEC_FinalizeContext(&ctx);
#endif
	
	printf("Test finish.\n");
	RTK_finalize();

	return;

}


static void filePlay_with_SMP_switch(void)
{
	printf("\n filePlay_with_SMP_switch hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
//	long ptsTestCount = 0;
	RTK_Bool bvideomute;
	int switch_wait_count=(100/*1s*/ * 30);
	int test_count=10;
	RTK_Bool smp=RTK_FALSE;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE; 
	config.video.output 		= RTK_WIN_MAIN;

	printf("\nInput  stream TSfilePath:\n");
	while(scanf("%s", file_path) == 0){
	 printf("\n read  fail \n Input  stream TSfilePath:\n");
	}
	
	rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	
TEST_BEGIN:
	RTK_initialize();

	RTK_DvbSetSMP(0, smp);
	if(smp==RTK_FALSE)
		smp=RTK_TRUE;
	else
		smp=RTK_FALSE;

	if(RTK_DvbGetSMP(0)==RTK_TRUE)
		printf("########### SMP is ON ##############\n");
	else 
		printf("########### SMP is OFF ##############\n");
	
	switch_wait_count=100*30;
	
	
	 	
	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	file = fopen(file_path, "rb");
	if(file == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}
	
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		fclose(file);
		printf("Failed to create player.\n");
		return;
	}

	if (gPlayer_1 == NULL)
	{
		fclose(file);
		printf("Player is NULL!!");
		return;
	}
	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		fclose(file);
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	//	feed data until end of file.
	while(1)
	{
 		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				//input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		usleep(10000);	//	10ms.
		switch_wait_count--;
		if(switch_wait_count<=0)
			break;
		
	}
	
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);
		
	printf("Test finish.\n");

	RTK_finalize();

	test_count--;
	if(test_count>0)
	{
		goto TEST_BEGIN;
	}
		

	return;
}

//#define __TEST_UPDATE_VO_PLANE__


void rtk_hal_test_Player_Fileplay_Onlypip()
{	
	printf("\n rtk_hal_test_Player_Fileplay hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;
	long count = 0;
	long ptsTestCount = 0;
	RTK_Bool bvideomute;

	UNUSED(count);
	UNUSED(bvideomute);

	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted		= RTK_FALSE;
	config.video.output 			= RTK_WIN_PIP;
	config.audio.codec			= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    = CHANNEL1_AUDIO_PID;
	config.audio.focused		= RTK_TRUE;
	config.audio.encrypted		= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 200, 200, 1920/2, 1080/2);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	bool isTestMute = RTK_FALSE;
	int ch = 0;	
	
	printf("\n Do you want to test Video/Audio mute/unmute?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestMute = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestMute = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);
#if 0
	char pvalue[PROPERTY_VALUE_MAX];
	property_set("enable.video.scale", "2");
	bool isTestVideoScale = RTK_FALSE;
	printf("\n Do you want to test video Scale?(Y/n):");
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isTestVideoScale = RTK_TRUE;
			printf(" Test Video/Audio Mute !\n");
		}
		else
		{
			isTestVideoScale = RTK_FALSE;
			printf(" Not Test Video/Audio Mute !\n");
		}
	}
	fflush(stdin);
#endif	
	if (strlen(FILE_NAME_1) != 0)
	{
		file = fopen(FILE_NAME_1, "rb");
	}
	else
	{
		printf("\nInput  stream TSfilePath:\n");
		if (1 != scanf("%s", file_path)) {
			printf("failed to read input ts file\n\n");
		}
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
	}
	uint32_t totalFileSize=0;
	fseek(file,0,SEEK_END);
	totalFileSize=ftell(file);
	rewind(file);
	printf("totalFileSize==%u\n",totalFileSize);
	fseek(file,0,SEEK_SET);

	gettimeofday(&startzaping_1, NULL);

	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}
	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.type = RTK_SOURCE_TYPE_MTP;
	sourceParam.tnr_param.mm_param.flag = 0;
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);

	RTK_Source_Create(&source,sourceParam);
	RTK_Player_SetSource(gPlayer_1,source);


	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	config.video.pid = videopid;
	config.audio.pid = audiopid;
	config.audio.focused = RTK_TRUE;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	printf("set Volume Volume Volume Volume\n");
	RTK_audio_SetVolume(30);

	uint32_t u32VolumeVal = 0;
	RTK_audio_GetVolume(&u32VolumeVal);
	printf("get Current Volume val:%d\n",u32VolumeVal);

	RTK_Player_SetAudioMute(gPlayer_1, RTK_FALSE);

	RTK_Bool   bMuteStat = RTK_FALSE;
	RTK_Player_GetAudioMute  (gPlayer_1,&bMuteStat);
	
	printf("get Current Audio Mute status :%s\n",bMuteStat == RTK_FALSE ? "UnMute":"Mute");

#if (MTP_AUDIO_CHANGE)
		config2.callback.function = NULL;
		config2.callback.user_param = NULL;
		config2.input.type = RTK_INPUT_SOURCE;
		config2.video.codec = RTK_CODEC_VIDEO_MPEG2; //	it can be RTK_CODEC_NONE at initialize time.
		config2.video.pid = 0x100;
		config2.audio.codec = RTK_CODEC_AUDIO_AAC;	//	it can be RTK_CODEC_NONE at initialize time.
		config2.audio.pid = 0x110;
		config2.video.encrypted = RTK_FALSE;
		config2.audio.encrypted = RTK_FALSE;
		config2.audio.enable_raw_output_mode = RTK_FALSE;
		config2.audio.focused = RTK_FALSE;
		config2.pcr_pid = 0xFFFF;
		RTK_audio_setVolume(30);
		RTK_AudioConfig* audio = (RTK_AudioConfig*)malloc( sizeof(RTK_AudioConfig)*2);
		memcpy( audio, &config.audio, sizeof(RTK_AudioConfig));
		memcpy( (audio+1) , &config2.audio, sizeof(RTK_AudioConfig));
		time0 = pli_getMilliseconds();
#endif

/*
	memset(&SectionFilterPattern0, 0x00, sizeof(RTK_SectionFilterMask));
	SectionFilterPattern0.pid = 0;
	SectionFilterPattern0.monitoring_mode = RTK_SECTION_MODE_CONTINOUS;
	SectionFilterPattern0.callback_01 = section_callback0;
	RTK_Player_AddSectionFilter(gPlayer_1, &filter_handle0, &SectionFilterPattern0);
*/

	//	feed data until end of file.
	while(1)
	{

#if (MTP_AUDIO_CHANGE)
				time1 = pli_getMilliseconds();
				if (time1 - time0 > 10000)
				{
					static int i = 1;
					if (i == 0)
					{
						audio[0].focused = RTK_TRUE;
						audio[1].focused = RTK_FALSE;
					}
					else
					{
						audio[0].focused = RTK_FALSE;
						audio[1].focused = RTK_TRUE;
					}
					printf("================================== change audio ==================================\n");
		//			RTK_Player_ChangeAudio(gPlayer, audio[i]);
					RTK_Player_ChangeAudioEx(gPlayer_1, &audio, 2);
		
					i = (i == 0) ? 1 : 0;
					//------------------------------------------------------------------------------		
					time0 = time1;
				}
#endif

		#if 0 // DMA buffer feed test. Please include rtk_ion.h 
		{
		int ret=0;
		static unsigned char *pVirtAddr=NULL;
		static unsigned int phyAddr=0;
		int feedSize=0;

		static ION_DATA  ionHl;

		if(ionHl.ion_virt==NULL)
		{
			memset(&ionHl, 0x00, sizeof(ION_DATA));


			ret=rtk_ion_malloc(&ionHl, 200*1024, 1<<12, RTK_PHOENIX_ION_HEAP_MEDIA_MASK, 
				ION_FLAG_SCPUACC | ION_FLAG_HWIPACC);

			pVirtAddr=ionHl.ion_virt;
			phyAddr=(unsigned int)ionHl.ion_phy;
		}
		
		feedSize=fread(pVirtAddr, 1, (200*1024)/188*188, file);
		feedSize=feedSize/188*188;

		if(feof(file)|| (totalFileSize-(ftell(file))<=0))
		{
			fseek(file, 0, SEEK_SET);
		}

		if(feedSize>0)
		{
			rtk_ion_flush_handle_fd(ionHl.mmap_fd);
			if(RTK_Player_FeedDMABuffer(gPlayer_1, phyAddr, feedSize, 2000/*2000 ms*/)!=0)
			{
				printf("mtp feed failed\n");
			}
		}
		
		}
		#else
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		
		switch(err)
		{
			case RTK_OK:
				INPUT_SOURCE_t input_info;
				memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
				input_info.fp = file;
				input_info.totalFileSize = totalFileSize;
				input_info.video_codec_type = config.video.codec;
				input_info.filePlay_once = RTK_TRUE;
				x_read_input_data(FILE_INPUT, input_info, &buffer);
				if(buffer.isLast == 1 && buffer.filled_size <= 0)
				{
					printf("file last, there is no data to feed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        goto ON_WAIT_EOS;                    
				}
				if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Source_DiscardInputBuffer(source, &buffer);
					usleep(6000);
				        continue;                                                
				} 
				err = RTK_Source_FeedInputBuffer(source, &buffer);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed nputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source, &buffer);
					goto ON_ERROR;
				}
				else
				{
					//	feed successful return dma buffer.
					 RTK_Source_DiscardInputBuffer(source, &buffer);
				}
				break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				usleep(10000);
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}
		#endif

#if 0
		if(isTestVideoScale)
		{
			property_get("enable.video.scale", pvalue, "0");
			if(pvalue[0] == '0')// '1'
			{
			    rtk_porting_destory_winSurface(RTK_SURFACE_V1);
			    rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_FALSE, 0, 0);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale",  "2");
			}
			else if(pvalue[0] == '1')
			{
				rtk_porting_destory_winSurface(RTK_SURFACE_V1);
				rtk_test_create_winSurface(RTK_WIN_MAIN, 80, 56, 544, 306);
			    RTK_Player_Window_Scale(gPlayer_1, RTK_TRUE, 544, 306);//used to match VO_IFRAME_DISPLAY_FIRST mode in CNavifilter
			    property_set("enable.video.scale", "2");
			}
		}
#endif

		ptsTestCount++;
		if(ptsTestCount%200 == 0)
		{
			uint64_t ptsValue = 0;
			RTK_Player_GetCurrentDisplayingPTS(gPlayer_1,&ptsValue);
			printf("get Current PTS value:%llu\n",ptsValue);
		}	


#if  1  //temporary for set/get video/audio mute test
		if(isTestMute)	
		{
			count ++;
			if(count == 200)
			{
				printf("\n\n@@@@@@@@@@@@@@	Video Mute  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_TRUE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}
			if(count == 400)
			{
				printf("\n\n@@@@@@@@@@@@@@  Video ***Unmute***  @@@@@@@@@@@@@@\n\n");
				RTK_Player_SetVideoMute(gPlayer_1, RTK_FALSE);	
				RTK_Player_GetVideoMute(gPlayer_1, &bvideomute);
				printf("\n@@@@@@@Get bvideomute=%d@@@@@@@\n",bvideomute);
			}

		}
#endif		
//		usleep(10000);	//	10ms.	
	}
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	fclose(file);
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;
	
	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}



#define RTKHAL_DBG_GETTIME

static struct timeval start1={0, 0};
static struct timeval end1={0, 0};

static double timeuse =0;
//static struct timeval zapping_start={0, 0};
//static struct timeval zapping_start2={0, 0};
//static struct timeval zapping_start3={0, 0};
//static struct timeval zapping_end={0, 0};
double zapping_timeuse =0;

#ifdef RTKHAL_DBG_GETTIME
#define RTK_GET_TIME(t_tv)						gettimeofday(t_tv, NULL)
#define RTK_GET_SPEND_TIME(start,end,spend) 		*(spend) = 1000000 * ((end)->tv_sec - (start)->tv_sec) + ((end)->tv_usec -(start)->tv_usec);
#define RTK_INFO_ZAPPING_TIME(infoStr,spend) 	RTKHAL_INF("[ZAPPING_TIME][%s] cost %f ms\n", (infoStr),(spend)/1000);
#else
#define RTK_GET_TIME(t_tv) 
#define RTK_GET_SPEND_TIME(start,end,spend) 
#define RTK_INFO_ZAPPING_TIME(infoStr,spend) 
#endif
#define MULTI_DTV_SOURCE_NUM	(3)
void rtk_hal_test_multiSource()
{	
	printf("\n rtk_hal_test_multiSource %d DTVSource hello\n\n",MULTI_DTV_SOURCE_NUM);

	RTK_Bool isKeepLast=RTK_TRUE;
	RTK_Demux gDemux = NULL;
	RTK_DemuxConfig config_demux;
	memset(&config_demux,0x0,sizeof(RTK_DemuxConfig));

	RTK_PlayerConfig config[MULTI_DTV_SOURCE_NUM];
	RTK_TSInputBuffer buffer[MULTI_DTV_SOURCE_NUM];
	memset(&config, 0x0, sizeof(RTK_PlayerConfig)*MULTI_DTV_SOURCE_NUM);
	memset(&buffer, 0x0, sizeof(RTK_TSInputBuffer)*MULTI_DTV_SOURCE_NUM);
	
	RTK_VideoConfig video_config[MULTI_DTV_SOURCE_NUM];
	RTK_AudioConfig audio_config[MULTI_DTV_SOURCE_NUM];
	unsigned short PcrPid[MULTI_DTV_SOURCE_NUM];
	memset(&video_config, 0x0, sizeof(RTK_VideoConfig)*MULTI_DTV_SOURCE_NUM);
	memset(&audio_config, 0x0, sizeof(RTK_AudioConfig)*MULTI_DTV_SOURCE_NUM);
	memset(&PcrPid,0x0,sizeof(pcr_pid)*MULTI_DTV_SOURCE_NUM);

	RTK_TunerParam_t  tunerParam;
	memset(&tunerParam, 0x0,sizeof(RTK_TunerParam_t));

	RTK_Source source[MULTI_DTV_SOURCE_NUM+2] = {NULL};
	RTK_SourceParam_t sourceParam[MULTI_DTV_SOURCE_NUM+2];

	int j=0;
	for(j=0;j<MULTI_DTV_SOURCE_NUM;j++)
	{
		//demux, source by tuner type
		memset(&sourceParam[j], 0, sizeof(RTK_SourceParam_t));
		rtkmid_input_Tuner_Param(&tunerParam);
		sourceParam[j].type = RTK_SOURCE_TYPE_TP;
		sourceParam[j].TunerID = j;
		sourceParam[j].cas_param.type = gCASType;
		sourceParam[j].cas_param.tsid_sidx = 100;
		sourceParam[j].isSMP = RTK_DvbGetSMP(0);
		RTK_Source_Create(&source[j],sourceParam[j]);
	}
	//player, source by MTP type
	memset(&sourceParam[4], 0, sizeof(RTK_SourceParam_t));
	sourceParam[4].type= RTK_SOURCE_TYPE_MTP;
	sourceParam[4].tnr_param.mm_param.flag = 0;
	sourceParam[4].cas_param.type = gCASType;
	sourceParam[4].cas_param.tsid_sidx = 100;
	sourceParam[4].isSMP = RTK_DvbGetSMP(0);
	RTK_Source_Create(&source[4],sourceParam[4]);
	
	if(source[0] == NULL || source[1] == NULL ||source[2] == NULL || source[4]== NULL)
	{
		printf("create source fail!\n");
		return;
	}

	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	for(int i =0;i<MULTI_DTV_SOURCE_NUM;i++)
	{
		printf("input source:%d info:\n",i);
		rtkmid_input_AV_type_pid(&video_config[i],&audio_config[i], &PcrPid[i]);
		audio_config[i].encrypted = RTK_FALSE;
		audio_config[i].enable_raw_output_mode = RTK_FALSE;
		audio_config[i].focused = RTK_FALSE;
	}

	RTK_Source current_source = source[0];
	int current_source_idx = 0;

	// create player
	//gPlayer_1 for play, gDemux for record
	config[current_source_idx].callback.function = NULL;
	config[current_source_idx].input.type = RTK_INPUT_SOURCE;
	if(RTK_Player_Create(&gPlayer_1, &config[current_source_idx], HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}

	RTK_Player_SetSource(gPlayer_1, source[4]);

	//create demux only
	config_demux.callback.function = Record_callback;
	//config_demux.callback.function = player_callback_4;
	config_demux.callback.user_param	= &player_status_1;
	config_demux.input.type = RTK_INPUT_SOURCE;

	if(RTK_Demux_Create(&gDemux, &config_demux) != RTK_OK)
	{
		printf("Failed to create demux.\n");
		return;
	}
	if (gDemux == NULL)
	{
	   printf("demux is NULL!!");
	   return ;
	}
	printf("gDemux create ok\n");

	int k =0;//start of for loop
	for (k=0;k<MULTI_DTV_SOURCE_NUM;k++)
	{
	printf("test source %d\n",k);
	current_source = source[k];
	current_source_idx = k;
	RTK_GET_TIME(&start1);
	// connect
	RTK_Demux_SetSource(gDemux, current_source);
	//RTK_Player_SetSource(gPlayer_1, source[4]);
	//printf("setSource source%d, source 4 ok\n",current_source_idx);


	char file_path[256]={0};
	sprintf(file_path, "/data/recyy_%d.ts",current_source_idx);
	printf("Record file path: %s\n",file_path);
	
	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file\n\n");
	}

	if(RTK_Demux_Start(gDemux) != RTK_OK)
	{
		printf("Failed to start gDemux.\n");
		return ;
	}
	
	//audio_config[current_source_idx].focused = RTK_TRUE;

	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = video_config[current_source_idx].codec;
	videoTSFilter.encrypt = RTK_FALSE;
	videoTSFilter.pid = video_config[current_source_idx].pid;

	if(RTK_Demux_AddTSFilter(gDemux, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x\n", videoTSFilter.pid );
	}
		printf("Add TSFilter for pid 0x%04x\n", videoTSFilter.pid );

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_FALSE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = audio_config[current_source_idx].pid;
	audioTSFilter.codec = audio_config[current_source_idx].codec;

	if(RTK_Demux_AddTSFilter(gDemux, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x\n", audioTSFilter.pid);
	}
			printf("Add TSFilter for pid 0x%04x\n", audioTSFilter.pid);

		printf("gDemux add tsfilter\n");


	usleep(100*1000);
	FILE * pvr_ts_fp_player2 = fopen(file_path, "rb");
	if(pvr_ts_fp_player2 == NULL)
	{
		printf("failed to open input ts file: %s\n\n", file_path);
		return;
	}
	else
	{
		printf("success to open input ts file pvr_ts_fp_player2\n\n");
	}
	audio_config[current_source_idx].focused = RTK_TRUE;
	RTK_Player_ChangeVideo(gPlayer_1, &video_config[current_source_idx]);
	RTK_Player_ChangeAudio(gPlayer_1, &audio_config[current_source_idx]);
	// player start
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		fclose(pvr_ts_fp_player2);
		printf("Failed to start player.\n");
		return ;
	}
	printf("gDemux start, change video pid=%d, audio pid=%d\n",video_config[current_source_idx].pid,audio_config[current_source_idx].pid);

	while(1)
	{
		//calc time for break while!
		RTK_GET_TIME(&end1);
		RTK_GET_SPEND_TIME(&start1,&end1,&timeuse);
		if(timeuse/1000000 >= 20)
		{
			printf("yydebug timeuse=%f us\n",timeuse);
			break;
		}
		//get dma buffer.
		RTK_Error err = RTK_Source_GetInputBuffer(source[4], &buffer[0]);

		//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
		switch(err)
		{
			case RTK_OK:
			{
				uint32_t feeding = 0;
				if(buffer[0].size < 1316*6)
					feeding = buffer[0].size;
				else
					feeding = 1316*6;
				
				buffer[0].filled_size = fread(buffer[0].memory, 1, feeding, pvr_ts_fp_player2);
				if(buffer[0].filled_size < feeding)
				{
					//buffer[0].isLast = RTK_TRUE;
					printf("not enough data to feed, requst(%d), get(%d), will feed(%d)\n", 
						feeding, buffer[0].filled_size, buffer[0].filled_size);
					//RTK_Player_DiscardInputBuffer(gPlayer_1, &buffer[0]);
					//usleep(30*1000);
					//continue;

				}
				
				if (buffer[0].filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
				{  
					RTK_Source_DiscardInputBuffer(source[4], &buffer[0]);
					usleep(6*1000);
					continue;
				} 
				err = RTK_Source_FeedInputBuffer(source[4], &buffer[0]);

				if(err != RTK_OK)
				{
					//	feed fail return dma buffer and goto error.
					printf("feed InputBuffer failed\n");
					RTK_Source_DiscardInputBuffer(source[4], &buffer[0]);
					//goto ON_ERROR;
					return;
				}
				else
				{
					//	feed successful return dma buffer.

				}
			}
			break;

			case RTK_BUFFER_NOT_AVAILABLE:
			default:	
				//	no room of internal input buffer. wait some time until available.
				break;
				//printf("UNKNOWN ERROR!!\n");
				
		}

		usleep(2*1000);
	
	}

	if(k==(MULTI_DTV_SOURCE_NUM-1))
		isKeepLast=RTK_FALSE;
	
	if(RTK_Player_Stop(gPlayer_1,isKeepLast) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	RTK_Source_Flush(source[4]);
	
	RTK_Demux_RemoveTSFilter(gDemux, videoTSFilterHandle);
	RTK_Demux_RemoveTSFilter(gDemux, audioTSFilterHandle);
	
	if(RTK_Demux_Stop(gDemux) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}
	
	// disconnect
	//RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Demux_SetSource(gDemux, NULL);

	fclose(pvr_ts_fp_player);
	fclose(pvr_ts_fp_player2);
	pvr_ts_fp_player = NULL;
	pvr_ts_fp_player2 = NULL;
	usleep(10*1000);

	}//end of for loop

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	if(RTK_Demux_Destroy(gDemux) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);

	// destory source
	RTK_Source_Destroy(source[0]);
	RTK_Source_Destroy(source[1]);
	RTK_Source_Destroy(source[2]);
	RTK_Source_Destroy(source[4]);
	gDemux = NULL;

	printf("Test finish.\n");


	return;
}

void rtk_hal_test_singleChannelMultiTP()
{
	printf("[%s][%d]: rtk_hal_test_singleChannelMultiTP\n", __FILE__, __LINE__);
	printf("[%s][%d]: test case: single Tuner + single channel with one Player + one Demux, using two TP\n", __FILE__, __LINE__);

	RTK_TunerParam_t  tunerParam;
	RTK_SourceParam_t sourceParam;
	memset(&tunerParam, 0, sizeof(RTK_TunerParam_t));
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));

	//enter tuner frequence info only one time
	rtkmid_input_Tuner_Param(&tunerParam);
	
	sourceParam.cas_param.type = gCASType;
	sourceParam.cas_param.tsid_sidx = 0;//100;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	sourceParam.TunerID = 0;
	sourceParam.type = RTK_SOURCE_TYPE_TP;

	//tuner init and scan	
	RTK_Tuner_Init();
	if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, tunerParam))
	{
		printf("RTK_Tuner_Scan failed!! \n");
		return ;
	}

	//prepare for demux record
#if 1
	printf("\nPlease enter the path and name of the file where the recorded data will be stored.(like:/data/rec.ts):\n");
	char file_path[256]={0};

	if(EOF == scanf("%s", file_path))
	{
		printf("scanf file_path failed!! \n");
		return ;
	}

	pvr_ts_fp_player = fopen(file_path, "wb");
	if(pvr_ts_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", file_path);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", file_path);
	}
	
	printf("\nRecorded pts data will be stored in %s.\n", PVR_REC_PTSFILE_PATH);
	pvr_pts_fp_player = fopen(PVR_REC_PTSFILE_PATH, "wb");
	if(pvr_pts_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_PTSFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_PTSFILE_PATH);
	}
	
	printf("\nRecorded frame data will be stored in %s.\n", PVR_REC_FRAMEFILE_PATH);
	pvr_frame_fp_player = fopen(PVR_REC_FRAMEFILE_PATH, "wb");
	if(pvr_frame_fp_player == NULL)
	{
		printf("Open or create target file:%s failed!!\n", PVR_REC_FRAMEFILE_PATH);
		return;
	}
	else
	{
		printf("Open or create target file:%s successed.\n", PVR_REC_FRAMEFILE_PATH);
	}
#endif
	RTK_DemuxConfig Config_demux;
	memset(&Config_demux, 0, sizeof(Config_demux));
	printf("\nPlease enter av info for Record\n");
	rtkmid_input_AV_type_pid(&Config_demux.video,&Config_demux.audio, &Config_demux.pcr_pid);
	Config_demux.audio.encrypted = RTK_FALSE;
	Config_demux.audio.enable_raw_output_mode = RTK_FALSE;
	Config_demux.audio.focused = RTK_FALSE;
	Config_demux.callback.function = Record_callback;
	Config_demux.callback.user_param	= &player_status_1;
	Config_demux.input.type = RTK_INPUT_SOURCE;
	//prepare for demux record


	// prepare for player
	RTK_VideoConfig videoConfig;
	RTK_AudioConfig AudioConfig;
	memset(&videoConfig, 0, sizeof(RTK_VideoConfig));
	memset(&AudioConfig, 0, sizeof(RTK_AudioConfig));
	unsigned short PcrPid;
	printf("\nPlease enter av info for Player\n");
	rtkmid_input_AV_type_pid(&videoConfig,&AudioConfig, &PcrPid);
	AudioConfig.encrypted = RTK_FALSE;
	AudioConfig.enable_raw_output_mode = RTK_FALSE;
	AudioConfig.focused = RTK_TRUE;
	// prepare for player


	// create source1
	RTK_Source source = NULL;
	RTK_Source_Create(&source,sourceParam);
	if(source == NULL)
	{
	   printf("Source is NULL!!");
	   return ;
	}

	//create surface
	rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);

	//one player one source for playing
	RTK_PlayerConfig config;
	memset(&config, 0, sizeof(config));
	config.callback.function = NULL;
	config.input.type = RTK_INPUT_SOURCE;
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}
	if (gPlayer_1 == NULL)
	{
	   printf("Player is NULL!!");
	   return ;
	}

	// connect
	RTK_Player_SetSource(gPlayer_1, source);

	// player start
	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	RTK_Player_ChangeVideo(gPlayer_1, &videoConfig);
	RTK_Player_ChangeAudio(gPlayer_1, &AudioConfig);
//one player one source for playing end

//one demux one source for background record!
	RTK_Source source2 = NULL;
	RTK_SourceParam_t sourceParam2;
	memset(&sourceParam2, 0, sizeof(RTK_SourceParam_t));

	// create source
	sourceParam2.cas_param.type = gCASType;
	sourceParam2.cas_param.tsid_sidx = 0;//100;
	sourceParam2.isSMP = RTK_DvbGetSMP(0);
	sourceParam2.TunerID = 0;
	sourceParam2.type = RTK_SOURCE_TYPE_TP;
	RTK_Source_Create(&source2,sourceParam2);
	if(source2 == NULL)
	{
	   printf("Source2 is NULL!!");
	   return ;
	}

	RTK_Demux demux = NULL;
	//Creat a demux type player.(demux type player will use TP HW to dumux TS. )
	if(RTK_Demux_Create(&demux, &Config_demux) != RTK_OK)
	{
		printf("Failed to create player.\n");
		return;
	}

	if (demux == NULL)
	{
		printf("Player is NULL!!");
		return;
	}
	RTK_Demux_SetSource(demux,source2);


	//Demux start.
	if(RTK_Demux_Start(demux) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}

	//Add record AV PIDs.
	//Video TS filter
	RTK_TSFilter videoTSFilterHandle;
	RTK_TSFilterPattern videoTSFilter;
	videoTSFilter.isAnchor = RTK_TRUE;
	videoTSFilter.codec = Config_demux.video.codec;
	videoTSFilter.encrypt = RTK_TRUE;
	videoTSFilter.pid = Config_demux.video.pid;

	if(RTK_Demux_AddTSFilter(demux, &videoTSFilter, &videoTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", videoTSFilter.pid );
	}

	//Audio TS filter
	RTK_TSFilter audioTSFilterHandle;
	RTK_TSFilterPattern audioTSFilter;
	audioTSFilter.encrypt = RTK_TRUE;
	audioTSFilter.isAnchor = RTK_FALSE;
	audioTSFilter.pid = Config_demux.audio.pid;
	audioTSFilter.codec = Config_demux.audio.codec;

	if(RTK_Demux_AddTSFilter(demux, &audioTSFilter, &audioTSFilterHandle) != RTK_OK)
	{
		printf("Failed to Add TSFilter for pid 0x%04x", audioTSFilter.pid);
	}
	//one demux one source for background record!

	//test Player zapping in one tuner frequence!
	int zapping_interval = 8;//8seconds interval
	int zapping_count=4;
	int i = 0;
	RTK_VideoConfig videoConfigZap[zapping_count];
	RTK_AudioConfig AudioConfigZap[zapping_count];
	unsigned short PcrPidZap[zapping_count];
	for(i=0;i<zapping_count;i++)
	{
		memset(&videoConfigZap[i], 0, sizeof(RTK_VideoConfig));
		memset(&AudioConfigZap[i], 0, sizeof(RTK_AudioConfig));
		memset(&PcrPidZap[i], 0, sizeof(unsigned short));
		printf("\nPlease enter zapping channel[%d] av info:\n",i);
		rtkmid_input_AV_type_pid(&videoConfigZap[i],&AudioConfigZap[i], &PcrPidZap[i]);
		AudioConfigZap[i].encrypted = RTK_FALSE;
		AudioConfigZap[i].enable_raw_output_mode = RTK_FALSE;
		AudioConfigZap[i].focused = RTK_TRUE;
	}
	i=0;
	for(i=0;i<zapping_count;i++)
	{
		sleep(zapping_interval);
		RTK_Player_Stop(gPlayer_1, RTK_TRUE);
		RTK_Player_SetShowMode_OnVideoChanged(gPlayer_1,RTK_VOSHOW_AF_DECODED_IFRAME);
		RTK_Player_ChangeVideo(gPlayer_1, &videoConfigZap[i]);
		RTK_Player_ChangeAudio(gPlayer_1, &AudioConfigZap[i]);
		if(RTK_Player_Start(gPlayer_1) != RTK_OK)
		{
			printf("Failed to start gPlayer_1.\n");
		}
		if (i==zapping_count-1)
			i=-1;
	}
	//test Player zapping in one tuner frequence!

//ON_ERROR:
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	// disconnect
	RTK_Player_SetSource(gPlayer_1, NULL);

	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}

	//destroy surface
	RTK_DestorySurface(RTK_WIN_MAIN);

	// destroy source
	RTK_Source_Destroy(source);


//destory demux
	//remove audio TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, audioTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) audioTSFilterHandle);
	
	//remove video TSFilter
	if(RTK_Demux_RemoveTSFilter(demux, videoTSFilterHandle) != RTK_OK)
		printf("Failed to remove TS filter with handle 0x%04x\n", (unsigned) videoTSFilterHandle);

	// you can also call RTK_Demux_RemoveAllTSFilters remove all ts filters
	if(RTK_Demux_RemoveAllTSFilters(demux) != RTK_OK)
		printf("Failed to remove all TS filter\n");

	if(RTK_Demux_Stop(demux) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}

	RTK_Demux_SetSource(demux, NULL);

	if(RTK_Demux_Destroy(demux) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	demux = NULL;
	RTK_Source_Destroy(source2);
	fclose(pvr_ts_fp_player);
	pvr_ts_fp_player=NULL;
	fclose(pvr_pts_fp_player);
	pvr_pts_fp_player=NULL;
	printf("Test finish.\n");
	return ;
}

static void PEScallback(uint32_t filterID , void * pes, uint32_t length, void * userParam)
{
	printf("%s() filterID=%d, pes=%p, length=%u, userParam=%p\n",__FUNCTION__,filterID, pes, length, userParam);
}

void rtk_hal_test_Player_PESFilter()
{	
	printf("\n rtk_hal_test_Player_PESFilter hello\n\n");

	RTK_PlayerConfig config;
	RTK_TSInputBuffer buffer;
	char file_path[256]={0};
	FILE * file=NULL;

	int isPesFilterFromFile=0;
	unsigned char ch='\0';
	uint32_t totalFileSize=0;



	memset(&config, 0, sizeof(config));

	config.callback.function		= player_callback_1;
	config.callback.user_param	= &player_status_1;
	config.input.type			= RTK_INPUT_SOURCE;
	config.video.codec			= CHANNEL1_VIDEO_CODEC;
	config.video.pid                    	= CHANNEL1_VIDEO_PID;
	config.video.encrypted             	= RTK_FALSE;
	config.video.output 		= RTK_WIN_MAIN;
	config.audio.codec                  	= CHANNEL1_AUDIO_CODEC;	//	it can be RTK_CODEC_NONE at initialize time.
	config.audio.pid                    	= CHANNEL1_AUDIO_PID;
	config.audio.focused                  = RTK_TRUE;
	config.audio.encrypted              	= RTK_FALSE;
	config.audio.enable_raw_output_mode = RTK_FALSE;
	config.pcr_pid				= CHANNEL1_PCR_PID;
	
	//create surface
	if(config.video.output == RTK_WIN_PIP)
	{
		rtk_test_create_winSurface(RTK_WIN_PIP, 0, 0, 1920, 1080);
	}
	else
	{
		rtk_test_create_winSurface(RTK_WIN_MAIN, 0, 0, 1920, 1080);
	}

	printf("\n Do you want to test pes from file(Default from tuner)? (y/N):");
	while((ch = (unsigned char)getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{
			isPesFilterFromFile=1;
			printf(" test pes filter from file !\n");
		}
		else
		{
			isPesFilterFromFile=0;
			printf(" test pes filter from tuner !\n");
		}
	}
	fflush(stdin);
	RTK_Source source = NULL;
	RTK_SourceParam_t sourceParam;
	memset(&sourceParam, 0, sizeof(RTK_SourceParam_t));
	sourceParam.cas_param.type = gCASType;
	sourceParam.isSMP = RTK_DvbGetSMP(0);
	sourceParam.cas_param.tsid_sidx = 100;
	if(isPesFilterFromFile)
	{
		//we use player_callback_4 for get data to record.
		config.callback.function		= player_callback_4;
		config.callback.user_param	= &player_status_1;
		sourceParam.type = RTK_SOURCE_TYPE_MTP;
		sourceParam.tnr_param.mm_param.flag = 0;
		//input file name and pids and codec.
		printf("\nInput  stream TSfilePath:\n");
		if(1 != scanf("%s", file_path))
		{
			printf("failed to read ts file path.\n");
		}
		file = fopen(file_path, "rb");
		if(file == NULL)
		{
			printf("failed to open input ts file: %s\n\n", file_path);
			return;
		}
		else
		{
			printf("success to open input ts file\n\n");
		}
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);

		
		fseek(file,0,SEEK_END);
		totalFileSize = ftell(file);
		rewind(file);
		printf("totalFileSize==%u\n",totalFileSize);
		fseek(file,0,SEEK_SET);
	}
	else
	{
		sourceParam.TunerID = 0;
		sourceParam.type = RTK_SOURCE_TYPE_TP;
		config.callback.function = player_callback_4;
		rtkmid_input_Tuner_Param(&config.input.tuner);
		rtkmid_input_AV_type_pid(&config.video,&config.audio, &config.pcr_pid);
		RTK_Tuner_Init();
		if(RTK_OK != RTK_Tuner_Scan(sourceParam.TunerID, config.input.tuner))
		{
			printf("RTK_Tuner_Scan failed!!");
			return ;
		}
	}


	int videopid = config.video.pid;
	int audiopid = config.audio.pid;
	config.video.pid = 0;
	config.audio.pid = 0;
	
	if(RTK_Player_Create(&gPlayer_1, &config, HAL_TYPE_DEMUX) != RTK_OK)
	{
		printf("Failed to create player.\n");
		fclose(file);
		return;
	}

	if (gPlayer_1 == NULL)
	{
		printf("Player is NULL!!");
		return;
	}

    RTK_Source_Create(&source,sourceParam);
    RTK_Player_SetSource(gPlayer_1, source);
    
	RTK_PESFilterPattern pes_pattern;
	printf("Enter the PID you want to filter:\n");
	if (_get_number_with_range((long int *)&pes_pattern.pid, 0x0 ,0x1fff)<0)
		return;
	pes_pattern.u8filterID = 0;
	pes_pattern.callback = PEScallback;
	pes_pattern.userParam = NULL;	

	RTK_SubtitleConfig	tsSubtitleConfig;
	memset(&tsSubtitleConfig,0 ,sizeof(RTK_SubtitleConfig));
	tsSubtitleConfig.bshow= false;
	tsSubtitleConfig.pid= pes_pattern.pid;

	if(RTK_OK != RTK_Player_SetSubtitle( gPlayer_1,tsSubtitleConfig))
	{
		printf("[%s:%d:%s] RTK_Player_SetSubtitle failed\n",__FILE__,__LINE__,__func__);
	}

	if(RTK_OK != RTK_Player_AddPESFilter(gPlayer_1, &pes_pattern))
	{
		 printf("[%s:%d:%s] failed to add pes filters\n",__FILE__,__LINE__,__func__);	
	}

	if(RTK_Player_Start(gPlayer_1) != RTK_OK)
	{
		printf("Failed to start player.\n");
		return ;
	}
	
	config.video.pid = videopid;
	config.audio.pid = audiopid;

	//if RTK_Player_Start with audio/video pid, then ChangeVideo/ChangeAudio, the previous data will be flush
	RTK_Player_ChangeVideo(gPlayer_1, &config.video);
	config.audio.focused=RTK_TRUE;
	RTK_Player_ChangeAudio(gPlayer_1, &config.audio);

	if(isPesFilterFromFile)
	{

		//	feed data until end of file.
		while(1)
		{
			//get dma buffer.
			RTK_Error err = RTK_Source_GetInputBuffer(source, &buffer);
			//printf("buffer.memory=%p buffer.size=%d err=%d\n",buffer.memory,buffer.size,err);
			
			switch(err)
			{
				case RTK_OK:
					INPUT_SOURCE_t input_info;
					memset(&input_info,0x0,sizeof(INPUT_SOURCE_t));
					input_info.fp = file;
					input_info.totalFileSize = totalFileSize;
					input_info.video_codec_type = config.video.codec;
					//input_info.filePlay_once = RTK_TRUE;
					x_read_input_data(FILE_INPUT, input_info, &buffer);
					if(buffer.isLast == 1 && buffer.filled_size <= 0)
					{
						printf("file last, there is no data to feed\n");
						RTK_Source_DiscardInputBuffer(source, &buffer);
						usleep(6000);
					        goto ON_WAIT_EOS;                    
					}
					if (buffer.filled_size <= 0 /*|| read_ret == RTK_Fail*/)  
					{  
						RTK_Source_DiscardInputBuffer(source, &buffer);
						usleep(6000);
					        continue;                                                
					} 
					err = RTK_Source_FeedInputBuffer(source, &buffer);

					if(err != RTK_OK)
					{
						//	feed fail return dma buffer and goto error.
						printf("feed nputBuffer failed\n");
						RTK_Source_DiscardInputBuffer(source, &buffer);
						goto ON_ERROR;
					}
					else
					{
						//	feed successful return dma buffer.
						 RTK_Source_DiscardInputBuffer(source, &buffer);
					}
					break;

				case RTK_BUFFER_NOT_AVAILABLE:
				default:	
					//	no room of internal input buffer. wait some time until available.
					break;
					//printf("UNKNOWN ERROR!!\n");
					
			}




			usleep(10000);	//	10ms.	
		}
	}
	else
	{
		int i=0;
		for(i=500;  i> 0;  i--)
		{
			sleep(1);
			printf("Tuner A/V is playing.....%d s to stop it\n", i);
		}
	}

		
ON_WAIT_EOS:
	//	wait 10 seconds until end of stream event.
	for(int i = 0; i < 10; ++i)
	{
		sleep(1);
		printf("waiting until eos\n");
		if(player_status_1.eof_reached)
		{
			printf("eof_reached\n");
			break;
		}
	}
ON_ERROR:
	if(isPesFilterFromFile)
	fclose(file);

	
	if(RTK_Player_Stop(gPlayer_1,RTK_FALSE) != RTK_OK)
	{
		printf("Failed to stop player.\n");
		return;
	}


	if(RTK_OK != RTK_Player_RemovePESFilter(gPlayer_1, pes_pattern.u8filterID))
	{
		 printf("[%s:%d:%s] failed to removed pes filters\n",__FILE__,__LINE__,__func__);	
	}

	RTK_Player_SetSource(gPlayer_1, NULL);
	RTK_Source_Destroy(source);
	if(RTK_Player_Destroy(gPlayer_1) != RTK_OK)
	{
		printf("Failed to destroy player.\n");
		return;
	}
	gPlayer_1 = NULL;


	//destroy surface
	if(config.video.output == RTK_WIN_PIP)
	{
		RTK_DestorySurface(RTK_WIN_PIP);
	}
	else
	{
		RTK_DestorySurface(RTK_WIN_MAIN);
	}
	
	printf("Test finish.\n");

	return;

}




/**
** @brief
** main menu table, please add your hal moudle in this
**
*/
static test_item   main_test_menu[] = {

	//{"Test Rtk Example",                rtk_porting_examle_test},
#ifdef __LINARO_SDK__
	{"Test rtk_porting_display",rtk_porting_test_display},
#endif
	
#ifdef ANDROID
	{"Test rtk_hal_test_Player_Sectionfilter",	          rtk_hal_test_Player_Sectionfilter},
	{"Test rtk_hal_test_Player_Fileplay",         rtk_hal_test_Player_Fileplay},
	{"Test rtk_hal_test_Player_FileplayAuto",         rtk_hal_test_Player_FileplayAuto},
	{"Test rtk_hal_test_Player_Tuner",            rtk_hal_test_Player_Tuner},
	{"Test rtk_hal_test_Player_TunerZapping",            rtk_hal_test_Player_TunerZapping},
	{"Test rtk_hal_test_Player_TunerScan", rtk_hal_test_Player_TunerScan},
	{"Test rtk_hal_test_Player_EOS_File_Notify",			rtk_hal_test_Player_EOS_File_Notify},
	{"Test rtk_hal_test_Player_DVR_record", rtk_hal_test_Player_DVR_record},
	{"Test rtk_hal_test_Player_DVR_replay", rtk_hal_test_Player_DVR_replay},
	{"Test rtk_hal_test_Player_IPTV", rtk_hal_test_Player_IPTV},
	#ifndef ENABLE_GLINUX_RTK_PORTING
	{"Test rtk_hal_test_Player_TrickPlay", rtk_hal_test_Player_TrickPlay},
	{"Test rtk_hal_test_Player_audioOutputMode", rtk_hal_test_Player_audioOutputMode},
	{"Test rtk_hal_test_FCC_V3", rtk_hal_test_FCC_V3},
	{"Test rtk_hal_test_Player_Timeshift", rtk_hal_test_Player_Timeshift},
	#endif
	{"Test filePlay_withoutTP", filePlay_withoutTP},
	{"Test rtk_hal_test_Player_TunerPIP", rtk_hal_test_Player_TunerPIP},
	{"Test rtk_hal_test_Player_FilePIP", rtk_hal_test_Player_FilePIP},

	{"Test rtk_hal_test_Player_Fileplay_Onlypip", rtk_hal_test_Player_Fileplay_Onlypip},
	
	//{"Test rtk_hal_test_Player_CCPlayback", rtk_hal_test_Player_CCPlayback},
	//{"Test rtk_hal_test_Player_CCData", rtk_hal_test_Player_CC},

	#ifdef ENABLE_DVB_HYBRID_WITH_SVP
	{"Test filePlay_feedfromDMAbuffer", filePlay_feedfromDMAbuffer},
	#endif
	{"Test filePlay_RawSample", filePlay_RawSample},
	{"Test filePlay_with_SMP_switch", filePlay_with_SMP_switch},
	{"Test rtk_hal_test_Demux_DVR_record", rtk_hal_test_Demux_DVR_record},
	
	{"Test rtk_hal_test_multiSource", rtk_hal_test_multiSource},
	
	//{"Config CAS_switch", CAS_switch}, // for develop test use

	{"rtk_hal_test_Player_PESFilter",rtk_hal_test_Player_PESFilter},		
    {"rtk_hal_test_Player_Fileplay_with_hdmi_delay",rtk_hal_test_Player_Fileplay_with_hdmi_delay}, 
    {"Test rtk_hal_test_Get_CCData", rtk_hal_test_Get_CC},	
	{"rtk_hal_test_Source_Sectionfilter",rtk_hal_test_Source_Sectionfilter},
	{"rtk_hal_test_singleChannelMultiTP",rtk_hal_test_singleChannelMultiTP},
#endif
};      
/**
** @brief
** main menu
**
*/
static test_menu main_menu = {
    "RTK Middleware Tester", main_test_menu, (sizeof(main_test_menu)/sizeof(test_item))
};
typedef enum RTK_Demod_Module_Type
{
	RTK_DEMOD_MODULE_TYPE_MXL254C=0,
	RTK_DEMOD_MODULE_TYPE_SONY2837,
	RTK_DEMOD_MODULE_TYPE_MXL258C,
	RTK_DEMOD_MODULE_TYPE_SONY2878,
	RTK_DEMOD_MODULE_TYPE_AVL6211,
	RTK_DEMOD_MODULE_TYPE_MXL541C,
	RTK_DEMOD_MODULE_TYPE_MXL248,
	RTK_DEMOD_MODULE_TYPE_MXL581C,
} RTK_Demod_Module_Type_e; 
int main(int argc, char * argv[])
{
	UNUSED(argc);
	UNUSED(argv);
	printf("VERSION : V3 \n");
#ifdef __SHOW_VERSION__	 //xiongz 20190828
    char ver[256]={0};
    if (-1 == RTK_Player_GetVersion(ver))
    {
        char * unknown_version = "unknown";
        memcpy(ver,unknown_version,strlen(unknown_version));
    }
    printf("\n\nVERSION: %s\n",ver);   
#endif	

	printf("\nDo you want to reset the demod module type?(y/n):");
	int ch=0;
	while((ch = getchar())!='\n')
	{
		if(ch == 'Y'||ch =='y')
		{		
			printf("\n Reset the demod module type !\n");
			printf("\nchoose  demod module type\n");
			list_item demod_module_types_list[] = 
			{
				{"MXL254C",RTK_DEMOD_MODULE_TYPE_MXL254C},
				{"SONY2837",RTK_DEMOD_MODULE_TYPE_SONY2837},
				{"MXL258C",RTK_DEMOD_MODULE_TYPE_MXL258C},
				{"SONY2878",RTK_DEMOD_MODULE_TYPE_SONY2878},
				{"AVL6211",RTK_DEMOD_MODULE_TYPE_AVL6211},
				{"MXL541C",RTK_DEMOD_MODULE_TYPE_MXL541C},
				{"MXL248",RTK_DEMOD_MODULE_TYPE_MXL248},
				{"MXL581C",RTK_DEMOD_MODULE_TYPE_MXL581C},
			};
			RTK_Demod_Module_Type_e Domed_type=(RTK_Demod_Module_Type_e)show_list("Demod Module Type List",demod_module_types_list,list_item_cnt(demod_module_types_list));
			property_set("persist.vendor.demodtype",demod_module_types_list[(int)Domed_type].item_desc);
			printf("\nReset demod module type successful!!\n");
			printf("\nPlease reboot the board!!\n");
			break;
		}
		else
		{
			printf(" \nNot reset the demod module type !\n");
		}
	}
	fflush(stdin);
	
	if(gCASType == RTK_CAS_TYPE_NONE)
	{
	#ifdef ENABLE_DVB_HYBRID_WITH_SVP
		char str_smp[32];
		memset(str_smp, 0x00, sizeof(str_smp));

		printf("\nPlease set global SMP: on/off? (if you don't know this, please set off)\n");
		scanf("%s", str_smp);

		if(strcmp(str_smp, "on")==0)
		{
			printf("########### set SMP ON ##############\n");
			RTK_DvbSetSMP(0,RTK_TRUE);
			RTK_DvbSetSMP(1,RTK_TRUE);
			RTK_DvbSetSMP(16, RTK_TRUE);
			RTK_DvbSetSMP(17, RTK_TRUE);
		}
		else 
		{
			printf("########### set SMP OFF ##############\n");
			RTK_DvbSetSMP(0,RTK_FALSE);
			RTK_DvbSetSMP(1,RTK_FALSE);
			RTK_DvbSetSMP(16, RTK_FALSE);
			RTK_DvbSetSMP(17, RTK_FALSE);
		}
	#endif 	
	}
	else
	{
		if(RTK_DvbGetSMP(0)==RTK_FALSE)
		{
			printf("########### set SMP ON ##############\n");
			RTK_DvbSetSMP(0,RTK_TRUE);
			RTK_DvbSetSMP(1,RTK_TRUE);
		}
	}
	
	rtkmid_show_menu(&main_menu);
	return 0;
}

#endif 
