##############################################################
# Copyright (C) 2008 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
###############################################################

LOCAL_PATH := $(call my-dir)
ifneq ($(filter 9%,$(PLATFORM_VERSION)),)
BUILD_IN_ANDROID9 = YES
else
BUILD_IN_ANDROID9 = NO
endif

LOCAL_PATH := $(call my-dir)
ifneq ($(filter 10%,$(PLATFORM_VERSION)),)
BUILD_IN_ANDROID10 = YES
else
BUILD_IN_ANDROID10 = NO
endif


###############################################################
#librtk_CaIntf.so
###############################################################
include $(CLEAR_VARS)
LOCAL_MODULE := librtk_CaIntf
LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES:= Rtk_EmptyCa.cpp

LOCAL_C_INCLUDES:= \
               external/stlport/stlport \
		bionic \
		system/core/include/cutils \
		vendor/realtek/RTKPLAYER/Rtk_CaIntf/include \

LOCAL_SHARED_LIBRARIES := \
                liblog \
                libutils

LOCAL_CFLAGS := -DANDROID

ifeq ($(BUILD_IN_ANDROID9),YES)
LOCAL_C_INCLUDES += system/core/libcutils/include

LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID9
endif

ifeq ($(BUILD_IN_ANDROID10),YES)
LOCAL_C_INCLUDES += system/core/libcutils/include

LOCAL_VENDOR_MODULE := true
LOCAL_CFLAGS += -DUSE_RTKHAL_IN_ANDROID10
endif

LIBVERSION:=\"$(shell cd $(LOCAL_PATH);git log -1 --format=%h_%cd --date=format:'%Y%m%d_%H:%M:%S')__Android$(PLATFORM_VERSION)\\n\"
$(warning "the librtk_CaInterface.so_$(HAL_PATH_SUFFIX)_version_$(LIBVERSION)")
LOCAL_CFLAGS     += -DEXTERN_FUNC_NAME=$(LOCAL_MODULE)_getGitSha
LOCAL_CFLAGS     += -DGIT_VERSION=\"$(LOCAL_MODULE)_$(HAL_PATH_SUFFIX)_version_\"$(LIBVERSION)

LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V1=$(RTKPLAYER_ARCH_V1)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V2=$(RTKPLAYER_ARCH_V2)
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_V3=$(RTKPLAYER_ARCH_V3)

ifeq ($(RTKPLAYER_ARCH_VER), )
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_V3)
else 
LOCAL_CFLAGS += -DRTKPLAYER_ARCH_VER=$(RTKPLAYER_ARCH_VER)
endif

include $(BUILD_SHARED_LIBRARY)
###############################################################
