/**
 * @file	RTK_CaManager.h
 *
 * @ingroup CA
 *
 * @brief 	super class for CA management
 */

#ifndef __IRTK_CAMANAGER_H__
#define __IRTK_CAMANAGER_H__

/**
 * includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef void (*RTK_CaManagerCallback_t)(int desramble_id, int event_id, void *pUserParam, void* pEvent, uint32_t event_size); 

/**
 * @class RTK_CaManager
 *
 * @brief
 *
 */

class Irtk_CaManager {
	/**
	 * data
	 */

	/**
	 * Constructors
	 */

public:
	/**
	 * @brief Constructors init all related internal variables
	 */
	Irtk_CaManager(){};
	virtual ~Irtk_CaManager(){};

	/**
	 * @brief CAS init
	 */
	virtual int Init() = 0;

	/**
	 * @brief CAS uninit
	 */
	virtual int UnInit() = 0;
	
	/**
	 * @brief CAS start descramble
	 */
	virtual int StartDescramble(int descramble_id, const char *pMetadata, uint32_t len) = 0 ;
	
	/**
	 * @brief CAS stop descramble
	 */
	virtual int StopDescramble(int descramble_id) = 0;
	
	/**
	 * @brief Register event callback.
	 */
	virtual int RegsiterEventCallback(int descramble_id, RTK_CaManagerCallback_t pfunc) = 0;
	
	/**
	 * @brief UnRegister event callback.
	 */
	virtual int UnRegsiterEventCallback(int descramble_id) = 0;
};


extern Irtk_CaManager* Rtk_GetCaManagerInstance(void);
extern void Rtk_PutCaManagerInstance(void);

#endif	//__RTK_CAMANAGER_H__

