/**
 * includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Irtk_CaIntf.h"
#include <cutils/log.h>
#define RTK_CAINTF_INF(fmt, args...)          ALOGD("[RTK_Player][INF]" fmt, ##args)

class Rtk_EmptyCA : public Irtk_CaIntf {

public:
	static Rtk_EmptyCA* getInstance();
	static void  deleteInstance();
	/**
	 * @brief Constructors init all related internal variables
	 */
	~Rtk_EmptyCA(){};

	/**
	 * @brief CAS init
	 */
	int Init() 
	{
		return RTKCA_OK;
	};

	/**
	 * @brief CAS uninit
	 */
	int UnInit() 
	{
		return RTKCA_OK;
	};
	/**
	 * @brief Init Descrambler
	 */
	int DescramblerInit(int descramble_id)
	{
		(void)(descramble_id);
		return RTKCA_OK;
	}

	/**
	 * @brief UnInit Descrambler
	 */
	int DescramblerUninit(int descramble_id)
	{
		(void)(descramble_id);
		return RTKCA_OK;
	}

	int SetEmmPid(uint16_t caSystemId, uint16_t pid, int sourceHandle)
	{
		(void)(caSystemId);
		(void)(pid);
		return RTKCA_OK;
	};

	/**
	 * @brief CAS start descramble
	 */
	int StartDescramble(int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info)
	{
		(void)(descramble_id);
		(void)(ecm_info);
		return RTKCA_OK;
	};

	/**
	 * @brief CAS stop descramble
	 */
	int StopDescramble(int descramble_id) 
	{
		(void)(descramble_id);
		return RTKCA_OK;
	};

	/**
	 * @brief Register event callback.
	 */
	int RegsiterEventCallback(int descramble_id, RTK_CaIntfCallback_t pfunc) 
	{
		(void)(descramble_id);
		(void)(pfunc);
		
		return RTKCA_OK;
	};

	/**
	 * @brief UnRegister event callback.
	 */
	int UnRegsiterEventCallback(int descramble_id)
	{
		(void)(descramble_id);
		return RTKCA_OK;
	};

	uint16_t GetCaSystemID(void)
	{
		return (uint16_t)(RTKCA_INVALID_CAID);
	}

	int DVRCipherInit(int id)
	{
		(void)(id);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherUnInit(int id)
	{
		(void)(id);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherConfig(int id, RTKCA_DvrCipher_config_t cfg)
	{
		(void)(id);
		(void)(cfg);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherGetDataAglin(int id, uint32_t *alignBytes)
	{
		(void)(id);
		(void)(alignBytes);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherContinuityReset(int id, int64_t conti_ofs)
	{
		(void)(id);
		(void)(conti_ofs);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherEnc(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)
	{
		(void)(id);
		(void)(inbuf);
		(void)(outbuf);
		(void)(size);
		return RTKCA_NOT_SUPPORT;
	}
	int DVRCipherDec(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)
	{
		(void)(id);
		(void)(inbuf);
		(void)(outbuf);
		(void)(size);
		return RTKCA_NOT_SUPPORT;
	}
private:
	static Rtk_EmptyCA* m_pSingleton;
	
	Rtk_EmptyCA() {return;};
	Rtk_EmptyCA(const Rtk_EmptyCA& obj) = delete; 
	Rtk_EmptyCA& operator=(const Rtk_EmptyCA& obj) = delete; 

};
Rtk_EmptyCA* Rtk_EmptyCA::m_pSingleton = NULL;

Rtk_EmptyCA* Rtk_EmptyCA::getInstance()
{
	if(m_pSingleton == NULL)
	{
		m_pSingleton = new Rtk_EmptyCA();
	}
	return m_pSingleton;
}
void  Rtk_EmptyCA::deleteInstance()
{
	if(m_pSingleton)
	{
		delete m_pSingleton;
		m_pSingleton=NULL;
	}
}

#ifdef  __cplusplus
extern "C" {
#endif
Irtk_CaIntf* Rtk_GetCaIntfInstance(void)
{
	return (Irtk_CaIntf *)(Rtk_EmptyCA::getInstance());
}

void Rtk_PutCaIntfInstance(void)
{
	Rtk_EmptyCA::deleteInstance();	
	return;
}
#ifdef  __cplusplus
}
#endif