/**
 * @file	Irtk_CaIntf.h
 *
 * @ingroup CA
 *
 * @brief 	super class for CA Interface
 */

#ifndef __IRTK_CAINTF_H__
#define __IRTK_CAINTF_H__

/**
 * includes
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rtk_caIntf_common.h"

typedef void (*RTK_CaIntfCallback_t)(int desramble_id, int event_id, void *pUserParam, void* pEvent, uint32_t event_size); 

/**
 * @class RTK_CaIntf
 *
 * @brief
 *
 */

class Irtk_CaIntf {
	/**
	 * data
	 */

	/**
	 * Constructors
	 */

public:
	/**
	 * @brief Constructors init all related internal variables
	 */
	Irtk_CaIntf(){};
	virtual ~Irtk_CaIntf(){};

	/**
	 * @brief CAS init
	 */
	virtual int Init() = 0;

	/**
	 * @brief CAS uninit
	 */
	virtual int UnInit() = 0;

	/**
	 * @brief Init Descrambler
	 */
	virtual int DescramblerInit(int descramble_id) = 0;

	/**
	 * @brief UnInit Descrambler
	 */
	virtual int DescramblerUninit(int descramble_id) = 0;

	virtual int SetEmmPid(uint16_t caSystemId, uint16_t pid, int sourceHandle)=0;

	/**
	 * @brief CAS start descramble
	 */
	virtual int StartDescramble(int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info) = 0 ;

	/**
	 * @brief CAS stop descramble
	 */
	virtual int StopDescramble(int descramble_id) = 0;
	
	/**
	 * @brief Register event callback.
	 */
	virtual int RegsiterEventCallback(int descramble_id, RTK_CaIntfCallback_t pfunc) = 0;
	
	/**
	 * @brief UnRegister event callback.
	 */
	virtual int UnRegsiterEventCallback(int descramble_id) = 0;

	virtual uint16_t GetCaSystemID(void) =0;

	virtual int DVRCipherInit(int id)=0;
	virtual int DVRCipherUnInit(int id)=0;
	virtual int DVRCipherGetDataAglin(int id, uint32_t *alignBytes)=0;
	virtual int DVRCipherConfig(int id, RTKCA_DvrCipher_config_t cfg)=0;
	virtual int DVRCipherContinuityReset(int id, int64_t conti_ofs)=0;
	virtual int DVRCipherEnc(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)=0;
	virtual int DVRCipherDec(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size)=0;	
	
};

#ifdef  __cplusplus
extern "C" {
#endif
extern Irtk_CaIntf* Rtk_GetIntfInstance(void);
extern void Rtk_PutCaIntfInstance(void);
#ifdef  __cplusplus
}
#endif
#endif	//__RTK_CAINTF_H__

