#ifndef __RTK_CAINTF_COMMON_H__
#define __RTK_CAINTF_COMMON_H__


#ifdef __cplusplus
extern "C" {
#endif

//error 
#define RTKCA_ERROR		(-1)
#define RTKCA_OK			(0)
#define RTKCA_NOT_SUPPORT	(-2)

//invalid value
#define RTKCA_INVALID_CAID	(0xFFFF)
#define RTKCA_MAX_STREAM_PID_NUM	(8)

typedef enum
{
	RTKCA_ALGO_UNKNOW=0,
	RTKCA_ALGO_CSA,
	RTKCA_ALGO_CSA2,
	RTKCA_ALGO_AES_128_ECB,
}RTKCA_ALGO_e;

typedef struct
{
    uint16_t  ecm_pid;
    uint16_t stream_pid;
}RTKCA_ECM_AVPid_t;

typedef struct RTKCA_Descramble_ECM_info
{
	int source_handle;
	uint16_t program_id;
	uint16_t  emm_pid;
	RTKCA_ALGO_e algo;
	RTKCA_ECM_AVPid_t ecm_AVPids[RTKCA_MAX_STREAM_PID_NUM];

}RTKCA_Descramble_ECM_info_t;

typedef struct
{
	uint8_t enc_or_dec; //0: enc, 1: dec, 2: both
	char *CipherRestoreInfo;
}RTKCA_DvrCipher_config_t;

#ifdef __cplusplus
}
#endif

#endif